#include "world.h"


#define MAX_TABLE_ENTRIES 200

FILE *input   = NULL;                          /* IF1 INPUT  FILE POINTER */
FILE *output  = stdout;                        /* IF1 OUTPUT FILE POINTER */

char *program   = "if1ld";                                /* PROGRAM NAME */

char *entryt[400];                             /* ENTRY POINT NAME TABLES */
int   entrys[400];
int   etop = -1;

char *furl = NULL;

char *fortt[400];
int   ftop = -1;

char *ct[400];
int   ctop = -1;

int   pmodule  = FALSE;                               /* PROGRAM MODULE?  */
int   smodule  = FALSE;                               /* SISAL MODULE?    */
int   forF     = FALSE;                           /* PROGRAM MODULE TYPES */
int   forC     = FALSE;
int   monolith = FALSE;                     /* MONOLITHIC PROGRAM MODULE? */

int   prof     = FALSE;                     /* PROFILE THE OPTIMIZER?     */

static char *ofile = NULL;                            /* OUTPUT FILE NAME */

/**************************************************************************/
/* LOCAL  **************    PlaceInEntryTable      ************************/
/**************************************************************************/
/* PURPOSE: PLACE nm IN THE ENTRY NAME TABLE.                             */
/**************************************************************************/

void PlaceInEntryTable( nm )
char *nm;
{
  register int idx;

  /* CHECK IF ALREADY IN THE OTHER TABLES */
  for ( idx = 0; idx <= ftop; idx++ )
    if ( strcmp( nm, fortt[idx] ) == 0 )
      Error2( "OPTIONS -e AND -f CONFLICT FOR:", nm );

  for ( idx = 0; idx <= ctop; idx++ )
    if ( strcmp( nm, ct[idx] ) == 0 )
      Error2( "OPTIONS -e AND -c CONFLICT FOR:", nm );

  for ( idx = 0; idx <= etop; idx++ )
    if ( strcmp( nm, entryt[idx] ) == 0 )
      return;

  if ( ++etop > MAX_TABLE_ENTRIES )
    Error2( "PlaceInEntryTable", "entryt OVERFLOW" );

  entryt[etop] = nm;
  entrys[etop] = FALSE;
}


/**************************************************************************/
/* LOCAL  **************      PlaceInCTable        ************************/
/**************************************************************************/
/* PURPOSE: PLACE nm IN THE C NAME TABLE.                                 */
/**************************************************************************/

void   PlaceInCTable( nm )
char *nm;
{
  register int idx;

  /* CHECK IF ALREADY IN THE OTHER TABLES */
  for ( idx = 0; idx <= ftop; idx++ )
    if ( strcmp( nm, fortt[idx] ) == 0 )
      Error2( "OPTIONS -c AND -f CONFLICT FOR:", nm );

  for ( idx = 0; idx <= etop; idx++ )
    if ( strcmp( nm, entryt[idx] ) == 0 )
      Error2( "OPTIONS -c AND -e CONFLICT FOR:", nm );

  for ( idx = 0; idx <= ctop; idx++ )
    if ( strcmp( nm, ct[idx] ) == 0 )
      return;

  if ( ++ctop > MAX_TABLE_ENTRIES )
    Error2( "PlaceInCTable", "ct OVERFLOW" );

  ct[ctop] = nm;
}


/**************************************************************************/
/* LOCAL  **************    PlaceInFortranTable    ************************/
/**************************************************************************/
/* PURPOSE: PLACE nm IN THE FORTRAN NAME TABLE.                           */
/**************************************************************************/

void PlaceInFortranTable( nm )
char *nm;
{
  register int idx;

  /* CHECK IF ALREADY IN THE OTHER TABLES */
  for ( idx = 0; idx <= ctop; idx++ )
    if ( strcmp( nm, ct[idx] ) == 0 )
      Error2( "OPTIONS -f AND -c CONFLICT FOR:", nm );

  for ( idx = 0; idx <= etop; idx++ )
    if ( strcmp( nm, entryt[idx] ) == 0 )
      Error2( "OPTIONS -f AND -e CONFLICT FOR:", nm );

  for ( idx = 0; idx <= ftop; idx++ )
    if ( strcmp( nm, fortt[idx] ) == 0 )
      return;

  if ( ++ftop > MAX_TABLE_ENTRIES )
    Error2( "PlaceInFortranTable", "fortt OVERFLOW" );

  fortt[ftop] = nm;
}


/**************************************************************************/
/* LOCAL  **************      ParseCommandLine     ************************/
/**************************************************************************/
/* PURPOSE: PARSE THE COMMAND LINE argv CONTAINING argc ENTRIES. THE 1ST  */
/*          ENTRY (argv[0]) IS IGNORED.   IF AN ARGUMENT DOES NOT BEGIN   */
/*          WITH A DASH, IT IS CONSIDERED THE NAME OF AN INPUT FILE. THE  */
/*          NAME OF EACH INPUT FILE IS STORED IN THE ARRAY files.         */
/*                                                                        */
/*          OPTIONS: -o outfile -> WRITE MONOLITH TO outfile; THE DEFAULT */
/*                                 IS stdout.                             */
/*                   -e funct   -> PROGRAM ENTRY POINT                    */
/*                   -f funct   -> FORTRAN INTERFACE FUNCTION             */
/*                   -c funct   -> C INTERFACE FUNCTION                   */
/**************************************************************************/

static void ParseCommandLine( argc, argv )
int    argc;
char **argv;
{
    register char *c;
    register char *p;
    register int   idx;

    for ( idx = 1; idx < argc; ++idx ) {
        if ( *(c = argv[ idx ]) == '-' )
            switch ( *( ++c ) ) {
		case 'W':
		    prof = TRUE;
		    break;

	        case 'o': /* SEE ReadTheIf1Files!!! */
		    if ( ++idx >= argc )
		        Error1( "USAGE: -o outfile" );

		    ofile = argv[ idx ];
		    break;

		case 'e': /* SEE ReadTheIf1Files!!! */
		    if ( ++idx >= argc )
		        Error1( "USAGE: -e function" );

		    PlaceInEntryTable( LowerCase( argv[ idx ] ) );
		    break;

		case 'c': /* SEE ReadTheIf1Files!!! */
		    if ( ++idx >= argc )
		        Error1( "USAGE: -c function" );

		    PlaceInCTable( LowerCase( argv[ idx ] ) );
		    break;

		case 'f': /* SEE ReadTheIf1Files!!! */
		    if ( ++idx >= argc )
		        Error1( "USAGE: -f function" );

		    PlaceInFortranTable( LowerCase( argv[ idx ] ) );
		    break;

		case 'F':
		    if ( *(c+1) != '\0' ) {
		      furl = c+1;
		      break;
		      }

		    forF = TRUE;
		    break;

		case 'C':
		    forC = TRUE;
		    break;

		case 'S':
		    smodule = TRUE;
		    break;

                default:
                    Error2( "ILLEGAL ARGUMENT", --c );
                }
        }

    pmodule = !smodule;

    if ( furl == NULL )
      Error1( "(INTERNAL ERROR) -Fcode NOT PROVIDED" );

    if ( forF && forC ) 
      Error1( "-forFORTRAN and -forC conflict" );

    if ( (forF || forC) && smodule ) 
      Error1( "-forC or -forFORTRAN and -smodule conflict" );

    if ( (!(forC || forF)) && !smodule ) {
      if ( etop > 0 )
        Error1( "only one entry point allowed in a program module" );
      }

    /* GUT CHECKS! */
    if ( !(pmodule || smodule) )
      Error2( "ParseCommandLine", "NEITHER pmodule OR smodule ENCOUNTERED!!!" );

    if ( pmodule && smodule )
      Error2( "ParseCommandLine", "pmodule AND smodule ENCOUNTERED!!!" );
}


/**************************************************************************/
/* GLOBAL **************           Stop            ************************/
/**************************************************************************/
/* PURPOSE: CLOSE ALL OPEN FILES AND STOP PROGRAM EXECUTION.  THE STATUS  */
/*          (status) IS RETURNED TO THE INVOKER OF THE PROGRAM.           */
/**************************************************************************/

void Stop( status )
int status;
{
    exit( status );
}


/**************************************************************************/
/* LOCAL  **************       ReadTheIf1Files     ************************/
/**************************************************************************/
/* PURPOSE: READ ALL IF1 INPUT FILES LISTED IN THE ARRAY argv AND BUILD   */
/*          THE MONOLITH.  IF A FILE CANNOT BE OPENED, AN ERROR MESSAGE   */
/*          IS PRINTED.                                                   */
/**************************************************************************/

static void ReadTheIf1Files( argc, argv )
int    argc;
char **argv;
{
    register FILE *fd;
    register int   idx;

    for ( idx = 1; idx < argc; idx++ ) {
        if ( *(argv[ idx ]) == '-' ) {
	    switch ( argv[idx][1] ) {
	      case 'o':
	      case 'e':
	      case 'f':
	      case 'c':
		idx++;     /* SKIP OUTPUT FILE NAME OR ENTRY POINT NAME */
		break;

	      default:
		break; 
	      }

	    continue;
	    }

        if ( (fd = fopen( argv[ idx ], "r" )) == NULL )
            Error2( "CAN'T OPEN", argv[ idx ] );

        input = fd;

	AssignSourceFileName( argv[ idx ] ); 
	PrepareForNextFile();

	If1Read();
	fclose( input );
	}
}


/**************************************************************************/
/* GLOBAL **************            main           ************************/
/**************************************************************************/
/* PURPOSE: COMBINE ONE OR MORE IF1 FILES TO FORM AN IF1 MODULE TYPE.     */
/*          NOTE, IF THE OUTPUT FILE NAME IS THE SAME AS ONE OF THE INPUT */
/*          FILE NAMES, THE CONTENTS OF THE INPUT FILE IS OVERWRITTEN.    */
/**************************************************************************/

void main( argc, argv )
int    argc;
char **argv;
{
    register FILE *fd;

    ParseCommandLine( argc, argv );

    StartProfiler();
    ReadTheIf1Files( argc, argv );
    StopProfiler( "ReadTheIf1Files" );

    if ( etop < 0 ) {
      entrys[++etop] = FALSE;
      entryt[etop] = LowerCase( MAIN_NAME );
      }

    StartProfiler();
    SmashTypes();
    CheckForUnresolvedNames();
    StopProfiler( "Smash and Check" );

    if ( monolith )
      AddStamp( MONOLITH, " CSU -> MONOLITHIC" );

    AddStamp( QMODE, furl );

    /* OPEN THE OUTPUT FILE AND WRITE THE STUFF                           */

    if ( ofile != NULL ) {
        if ( (fd = fopen( ofile, "w" )) == NULL )
	    Error2( "CAN'T OPEN", ofile );

        output = fd;
	}

    StartProfiler();
    If1Write();
    StopProfiler( "If1Write" );

    Stop( OK );
}
