#include "world.h"


/**************************************************************************/
/* LOCAL  **************        FindSource         ************************/
/**************************************************************************/
/* PURPOSE: FIND THE ACTUAL SOURCE NODE OF THE VALUE CARRIED ON EDGE e.   */
/**************************************************************************/

static PEDGE FindSource( e )
register PEDGE e;
{
  register PEDGE ee;
  register PNODE src;

  for ( ;; ) {
    if ( IsConst( e ) )
      return( e );

    src = e->src;

    if ( !IsSGraph( src ) )
      return( e );

    if ( IsTagCase( src->G_DAD ) && (e->eport == 1) )
      return( e );

    if ( (ee = FindImport( src->G_DAD, e->eport )) == NULL )
      return( e );

    e = ee;
    }
}


/**************************************************************************/
/* GLOBAL **************     AreValuesEqual        ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF EDGE v1 AND EDGE v2 CARRY THE SAME VALUE.      */
/**************************************************************************/

int AreValuesEqual( v1, v2 )
PEDGE v1;
PEDGE v2;
{
  if ( v1 == NULL || v2 == NULL )
    return( FALSE );

  return( AreEdgesEqual( FindSource(v1), FindSource(v2) ) );
}


/**************************************************************************/
/* GLOBAL **************       AreEdgesEqual       ************************/
/**************************************************************************/
/* PURPOSE: RETURNS TRUE IF THE EDGES e1 AND e2 ARE EQUAL.  TO BE EQUAL,  */
/*          THEY MUST EITHER BOTH DEFINE THE SAME CONSTANTS OR ADDRESS    */
/*          THE SAME SOURCE NODE AND HAVE THE SAME SOURCE PORT NUMBERS.   */
/*          IF THEY ARE NOT EQUAL, FALSE IS RETURNED.                     */
/**************************************************************************/

int AreEdgesEqual( e1, e2 )
PEDGE e1;
PEDGE e2;
{
  if ( IsConst( e1 ) ) {
    if ( IsConst( e2 ) )
      return( AreConstsEqual( e1, e2 ) );

    return( FALSE );
    }

  /* IF e2 IS A CONST, e2->src WILL BE NULL AND e2->eport WILL BE CONST_PORT */
  if ( (e1->src == e2->src) && (e1->eport == e2->eport) )
    return( TRUE );

  return( FALSE );
}


/**************************************************************************/
/* LOCAL  **************     DontCombineFill       ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF AFill NODE n CYCLES THROUGH A LOOP.            */
/**************************************************************************/

static int DontCombineFill( n )
PNODE n;
{
  register PEDGE e;

  for ( e = n->exp; e != NULL; e = e->esucc ) {
    if ( IsLoop( e->dst ) ) {
      if ( IsExport( e->dst->L_INIT, e->iport ) )
	if ( !IsExport( e->dst->L_TEST, e->iport ) )
	  if ( !IsExport( e->dst->L_BODY, e->iport ) )
	    if ( !IsExport( e->dst->L_RET, e->iport ) )
	      return( TRUE );
      }
    }

  return( FALSE );
}


/**************************************************************************/
/* GLOBAL **************       AreNodesEqual       ************************/
/**************************************************************************/
/* PURPOSE: CHECK IF TWO NODES ARE EQUIVALENT, RETURNING TRUE IF THEY ARE */
/*          AND FALSE IF THEY ARE NOT.                                    */
/**************************************************************************/

int AreNodesEqual( n1, n2 )
PNODE n1;
PNODE n2;
{
    register PEDGE i1;
    register PEDGE i2;

    if ( !IsSimple( n1 ) )
      return( FALSE );

    if ( n1->type != n2->type )
      return( FALSE );

    if ( glue && IsCall( n1 ) )
      return( FALSE );

    switch ( n1->type ) {
	case IFABuild:
	    /* BUG FIX FOR EMPTY ARRAY BUILDS --- 7/14/89 CANN */
	    if ( n1->imp->isucc == NULL ) return( FALSE );
	    /* END BUG FIX */

	case IFAFill:
	case IFRBuild:
	case IFAGather:
	    if ( n1->exp->info->type != n2->exp->info->type )
		return( FALSE );

        default:
	    break;
        }

    /* CANN 6/20/90 */
    if ( n1->type == IFAFill ) {
      if ( DontCombineFill( n1 ) ) return ( FALSE );
      if ( DontCombineFill( n2 ) ) return ( FALSE );
      }

    /* TAKE ADVANTAGE OF COMMUTATIVITY */
    switch ( n1->type ) {
      case IFPlus:
      case IFTimes:
        if ( noassoc ) break;

	/* IF A = C THEN B MUST = D */
	if ( AreValuesEqual( n1->imp, n2->imp ) )
	  if ( AreValuesEqual( n1->imp->isucc, n2->imp->isucc ) )
	    return( TRUE );

	/* IF A = D THEN B MUST = C */
	if ( AreValuesEqual( n1->imp, n2->imp->isucc ) )
	  if ( AreValuesEqual( n1->imp->isucc, n2->imp ) )
	    return( TRUE );

	return( FALSE );
	break;

      default:
	break;
      }

    i1 = n1->imp;
    i2 = n2->imp; 
    
    while ( (i1 != NULL) && (i2 != NULL) ) {
      if ( !AreValuesEqual( i1, i2 ) )
	return( FALSE );

      i1 = i1->isucc;
      i2 = i2->isucc;
      }

    if ( (i1 == NULL) && (i2 == NULL) )
      return( TRUE );

    /* UNEQUAL NUMBER OF IMPORTS */
    return( FALSE );  
}


/**************************************************************************/
/* GLOBAL **************     AreNodesEqualFast     ************************/
/**************************************************************************/
/* PURPOSE: CHECK IF TWO NODES ARE EQUIVALENT, RETURNING TRUE IF THEY ARE */
/*          AND FALSE IF THEY ARE NOT. THIS ROUTINE, DIFFERING FROM       */
/*          AreNodesEqual ASSUMES n1 AND n2 ARE FROM THE SAME SCOPE!      */
/**************************************************************************/

int AreNodesEqualFast( n1, n2 )
PNODE n1;
PNODE n2;
{
    register PEDGE i1;
    register PEDGE i2;

    if ( !IsSimple( n1 ) )
      return( FALSE );

    if ( n1->type != n2->type )
      return( FALSE );

    if ( glue )
      if ( IsCall( n1 ) )
        return( FALSE );

    switch ( n1->type ) {
	case IFABuild:
	    /* BUG FIX FOR EMPTY ARRAY BUILDS --- 7/14/89 CANN */
	    if ( n1->imp->isucc == NULL ) return( FALSE );
	    /* END BUG FIX */

	case IFAFill:
	case IFRBuild:
	case IFAGather:
	    if ( n1->exp->info->type != n2->exp->info->type )
		return( FALSE );

        default:
	    break;
        }


    switch ( n1->type ) {
      case IFAFill:
        /* CANN 6/20/90 */
        if ( DontCombineFill( n1 ) ) return ( FALSE );
        if ( DontCombineFill( n2 ) ) return ( FALSE );
	break;

      /* TAKE ADVANTAGE OF COMMUTATIVITY */

      case IFPlus:
      case IFTimes:
	if ( noassoc ) break;

	/* IF A = C THEN B MUST = D */
	if ( AreEdgesEqual( n1->imp, n2->imp ) )
	  if ( AreEdgesEqual( n1->imp->isucc, n2->imp->isucc ) )
	    return( TRUE );

	/* IF A = D THEN B MUST = C */
	if ( AreEdgesEqual( n1->imp, n2->imp->isucc ) )
	  if ( AreEdgesEqual( n1->imp->isucc, n2->imp ) )
	    return( TRUE );

	return( FALSE );
	break;

      default:
	break;
      }

    i2 = n2->imp; 
    
    for ( i1 = n1->imp; i1 != NULL; i1 = i1->isucc ) {
      if ( i2 == NULL )
	return( FALSE );

      if ( !AreEdgesEqual( i1, i2 ) )
	return( FALSE );

      i2 = i2->isucc;
      }

    /* UNEQUAL NUMBER OF IMPORTS */
    if ( i2 != NULL )
      return( FALSE );

    return( TRUE );  
}
