#include <stdio.h>
#include <math.h>

/* #ifdef CRAY */
/* #include <sys/signal.h> */
/* #else */
/* #include <signal.h> */
/* #endif */

#include "if1.h"


void                 If1Read();                           /* if1read.c        */

void                  If1Vec(),      WriteConcurInfo();   /* if1parallel.c    */
int           IsVecCandidate();
void                  If1Par();

void              If1Explode();                           /* if1explode.c     */
void        WriteExplodeInfo();

void               If1Unroll(),      WriteUnrollInfo();   /* if1unroll.c      */

void                If1Split(),       WriteSplitInfo();   /* if1split.c       */

void               If1Invert(),      WriteInvertInfo();   /* if1invert.c      */

double                TSECND();                           /* if1timer.c       */
void            StopProfiler();
void           StartProfiler();

void              EnterScope(),            MakeGraph();   /* if1build.c       */
void                MakeInfo(),             MakeEdge();
void               MakeConst(),             MakeNode();
void            MakeCompound(),            ExitScope();
void                AddStamp(),          RemoveStamp();
void    AssignSourceFileName();
int                  IsStamp();
PINFO               FindInfo();

void                If1Check();                           /* if1check.c       */

void           If1Normalized();                           /* if1normal.c      */
void  EliminateDeadFunctions();

void                 If1Fold();                           /* if1fold.c        */
void           WriteFoldInfo(),       PropagateConst();
char           *DoubleToReal();
int        CanPropagateConst();
void           NormalizeNode();

void          RemoveDeadEdge(),       RemoveDeadNode();   /* if1dead.c        */
void                If1Clean();
void           CombineKports();
void          FastCleanGraph();

void                 If1GCse();                           /* if1gcse.c        */
void             RemoveSCses();

void                If1Count();                           /* if1count.c       */
void            WriteLoopMap();

void                  If1Cse();                           /* if1cse.c         */

void                 If1Dope();                           /* if1dope.c        */
void           WriteDopeInfo();

void               If1PPrint();                           /* if1pprint.c      */

void                If1Invar();                           /* if1invar.c       */
int              IsInvariant();
int          IsEdgeInvariant();
void        ExposeInvariants();

void              LinkImport(),           LinkExport();   /* if1util.c        */
void            UnlinkImport(),         UnlinkExport();
void       ChangeImportPorts(),    ChangeExportPorts();
void         LinkImportLists(),      LinkExportLists();
void           LinkNodeLists(),        ChangeToConst();
void       ChangeEdgeToConst(),           ImportSwap();
void         LinkExportToEnd();
PNODE           FindLastNode();
PNODE              LinkGraph();
PNODE               LinkNode();
PNODE             UnlinkNode();
PNODE            UnlinkGraph();
int              IsInnerLoop();
char             *CopyString(),             *MyAlloc();
char              *LowerCase();
void                Warning1(),               Error1();
void                  Error2(), ChangeExportsToConst();
PALIST        LinkAssocLists();
PEDGE              EdgeAlloc();
PNODE              NodeAlloc();
PINFO              InfoAlloc();
PALIST        AssocListAlloc();
PEDGE             FindImport();
PEDGE             FindExport();
int            AreConstEqual(),           UsageCount();
int               IsReadOnly();

void                If1Write();                           /* if1write.c       */

void               If1Inline();                           /* if1inline.c      */
void           SpliceInGraph();

void              If1Fission();                           /* if1fission.c     */

void              If1DFusion();                           /* if1fuse.c        */
void              If1IFusion();
void         WriteFusionInfo();

int            AreNodesEqual(),        AreEdgesEqual();   /* if1equal.c       */
int           AreValuesEqual();
int        AreNodesEqualFast();

void              RemoveNode();                           /* if1move.c        */
void              InsertNode();
void     FindAndLinkToSource();

PEDGE               CopyEdge();                           /* if1copy.c        */
PNODE               CopyNode();
void             CopyImports(),          CopyExports();
void         CopyEdgeAndLink();
void        CopyEdgeAndReset();

void                    Stop(),                 main();   /* DRIVER FILE      */

int                   strlen();                           /* C LIBRARY STUFF  */
char                 *strcpy();

#ifndef RS6000
char                 *malloc();
#endif

#ifdef CRAY
double                  atof();
#endif

/* VARIOUS WRITE OPTIMIZATION FUNCTIONS */
void           WriteFissionInfo();
void              WriteFoldInfo();
void             WriteInvarInfo();
void               WriteCseInfo();
void              WriteGCseInfo();
void WriteSimplifyGeneratesInfo();
void             WriteDFuseInfo();
void             WriteCleanInfo();


#define OK       0                               /* PROGRAM EXIT STATUS CODES */
#define ERROR    1

#define FALSE    0
#define TRUE     1

extern FILE  *input;                             /* IF1 INPUT  STREAM         */
extern FILE  *output;                            /* IF1 OUTPUT STREAM         */

extern char  *program;                           /* PROGRAM NAME              */

extern char *sfile;                              /* SISAL FILE BEING READ     */
extern PNODE cfunct;                      /* FUNCTION BEING BUILT OR EXAMINED */

extern int    asetl;              /* REMOVE UNNECESSARY ASetL NODES?          */
extern int    ifuse;              /* PERFORM INDEPENDENT FUSION               */
extern int    sfuse;              /* PERFORM SELECT FUSION?                   */
extern int    dfuse;              /* PERFORM DEPENDENT FUSION?                */
extern int    info;               /* DUMP OPTIMIZATION INFORMATION?           */
extern int    vinfo;              /* DUMP VECTORIZATION INFORMATION?          */
extern int    sgnok;              /* ALLOW SIGNED ARITHMETIC CONSTANTS?       */
extern int    slfis;              /* PERFORM STREAM LOOP FISSION?             */
extern int    inter;              /* PERFORM INLINE EXPANSION?                */
extern int    inlineall;          /* INLINE EVERYTHING BUT REQUESTS?          */
extern int    native;       /* FLAG NODES NOT SUPPORTED IN NATIVE COMPILATION */
extern int    dope;               /* PEFORM DOPE VECTOR OPTIMIZATIONS?        */
extern int    amove;              /* PERFORM ANTI-MOVEMENT                    */
extern int    unroll;             /* PERFORM FORALL UNROLLING?                */
extern int    split;              /* PERFORM FORALL SPLITTING?                */
extern int    invert;             /* PERFORM LOOP INVERSION?                  */
extern int    vec;                /* VECTOR MODE?                             */
extern int    concur;             /* CONCURRENT MODE?                         */

extern int    maxint;                   /* MAXIMUM INTEGER READ FROM IF1 FILE */
extern PINFO  integer;                  /* INTEGER SYMBOL TABLE ENTRY         */
extern int    line;        /* LINE NUMBER OF PREVIOUSLY READ LINE OF IF1 FILE */
extern PINFO  ihead;                    /* SYMBOL TABLE HEAD POINTER          */
extern PINFO  itail;                    /* SYMBOL TABLE TAIL POINTER          */
extern PNODE  glstop;                   /* HEADER OF FUNCTION GRAPH LIST      */
extern char  *stamps[];                 /* ARRAY OF IF1 STAMPS 0 to 127       */
extern PRAGS  pragmas;        /* PRAGMAS FORM CURRENTLY READ LINE OF IF1 FILE */

extern  char *cnames[];                                /* COMPOUND NODE NAMES */
extern  char *gnames[];                                /* GRAPH NODE NAMES    */
extern  char *snames[];                                /* SIMPLE NODE NAMES   */

extern  int   Oinvar;                    /* OUTERMOST LOOP INVARIANT REMOVAL? */

extern int ikcnt;                   /* COUNT OF COMBINED K IMPORTS            */
extern int unnec;                   /* COUNT OF UNNECESSARY EDGES OR LITERALS */
extern int unused;                  /* COUNT OF UNUSED VALUES                 */
extern int dscnt;                   /* COUNT OF DEAD SIMPLE NODES             */
extern int dccnt;                   /* COUNT OF DEAD COMPOUND NODES           */
extern int agcnt;                   /* COUNT OF DEAD AGather NODES            */
extern int tgcse;                   /* TRY AND FORCE GCSE IMPORVEMENTS?       */

extern int maxunroll; /* MAX NUMBER OF ITERATIONS ALLOWED IN AN UNROLLED LOOP */

extern int cRay;                    /* COMPILING FOR THE CRAY?                */
extern int alliantfx;               /* COMPILING FOR THE ALLIANT?             */

extern int normidx;                 /* NORMALIZE ARRAY INDEXING OPERATIONS?   */
extern int fchange;                 /* WAS A FUSION DONE?                     */

extern int nchange;                 /* WAS A NODE UNLINKED OR LINKED?         */
extern int echange;                 /* WAS AN EDGE UNLINKED OR LINKED?        */

extern int glue;                    /* ELIMINATE DEAD FUNCTION CALLS?         */ 
extern int noincnt;                 /* FUNCTION CALL LIST INDEX               */
extern char *noin[];                /* FUNCTION CALL LIST                     */

extern double iter;                 /* LOOP ITERATION COUNT DEFAULT           */

extern int agcse;                   /* DO ANTI-GLOBAL CSE?                    */

extern int prof;                    /* PROFILE THE OPTIMIZER?                 */

extern int DeBuG;                   /* OPT FOR PROGRAM DEBUGGING?             */
extern int noassoc;                 /* NO ASSOCIATIVE TRANSFORMATIONS         */
