#include "world.h"


#define FIBREIN           1
#define FIBREOUT          2

#define GET_Tmp(y)        (Tmp = atoi( &(argv[ ArgIndex ][(y)]) ))

#define CASE_OPTION(f,s)  if ( argv[ArgIndex][s] == (f) )


void ParseCommandLine( argc, argv )
int   argc;
char *argv[];
{
  register int   ArgIndex;
           int   Tmp;
           int   Fd;
           int   FibreFileMode;

  FibreFileMode = FIBREIN;

  for ( ArgIndex = 1; ArgIndex < argc; ArgIndex++ ) {
      if ( argv[ArgIndex][0] != '-' ) {
        switch ( FibreFileMode ) {
	  case FIBREIN:
            OPEN( FibreInFd, argv[ArgIndex], "r" );
            break;

	  case FIBREOUT:
            OPEN( FibreOutFd, argv[ArgIndex], "w" );
            break;

          default:
            goto Argument_Error;
            break;
          }

        FibreFileMode++;
        continue;
        }

      CASE_OPTION( 'g', 1 ) {
	CASE_OPTION( 's', 2 ) {
	  CASE_OPTION( 's', 3 ) {
            UseGss = TRUE;
	    continue;
            }
	  }

	goto Argument_Error;
        }

      CASE_OPTION( 'n', 1 ) {
	CASE_OPTION( 'b', 2 ) {
          BindParallelWork = FALSE;
	  continue;
          }

	goto Argument_Error;
        }

      CASE_OPTION( 'b', 1 ) {
        BindParallelWork = TRUE;
        continue;
	}

      CASE_OPTION( 'z', 1 ) {
        NoFibreOutput = TRUE;
        continue;
        }

      CASE_OPTION( 'a', 1 ) {
	CASE_OPTION( 'x', 2 ) {
	  if ( GET_Tmp( 3 ) < 0 )
	    goto Argument_Error;

          ArrayExpansion = Tmp;
	  continue;
          }

        goto Argument_Error;
	}

      CASE_OPTION( 'l', 1 ) {
        CASE_OPTION( 's', 2 ) {
          if ( GET_Tmp( 3 ) <= 0 )
            goto Argument_Error;

          LoopSlices = Tmp;
          continue;
          }

	goto Argument_Error;
        }

      CASE_OPTION( 'w', 1 ) {
        if ( GET_Tmp( 2 ) <= 0 )
          goto Argument_Error;

        if ( Tmp > MAX_PROCS )
          goto Argument_Error;

        NumWorkers = Tmp;
        continue;
        }

      CASE_OPTION( 'r', 1 ) {
        GatherPerfInfo = TRUE;
        OPEN( PerfFd, "s.info", "a" );
        continue;
        }

      CASE_OPTION( 'd', 1 ) {
        CASE_OPTION( 's', 2 ) {
          if ( GET_Tmp( 3 ) <= 0 )
            goto Argument_Error;

          DsaSize = Tmp;
          continue;
          }

        CASE_OPTION( 'x', 2 ) {
          if ( GET_Tmp( 3 ) < 0 )
            goto Argument_Error;

          XftThreshold = Tmp;
          continue;
          }
	}

      CASE_OPTION( '\0', 1 ) {
        FibreFileMode++;
        continue;
        }

      goto Argument_Error;
      }

  if ( LoopSlices == -1 )
    LoopSlices = NumWorkers;
  else if ( UseGss )
    SisalError( "COMMAND LINE CONFLICT", "-gss AND -ls" );

  return;

Argument_Error:
  SisalError( "ILLEGAL COMMAND LINE ARGUMENT", argv[ArgIndex] );
} 


static void PrintExecutionTimes()
{
  struct WorkerInfo *InfoPtr;
  int    Worker;
  double CpuUse;
  int    NumIterations;

  fprintf( PerfFd, "  CpuTime  WallTime    CpuUse\n" );

#ifdef ALLIANT
  NumIterations = 1;
#else
  NumIterations = NumWorkers;
#endif

  for ( Worker = 0; Worker < NumIterations; Worker++ ) {
    InfoPtr = &(AllWorkerInfo[ Worker ]);

    if ( InfoPtr->WallTime != 0.0 ) {
      CpuUse  = InfoPtr->CpuTime;
      CpuUse /= InfoPtr->WallTime;
      }
    else
      CpuUse = 0.0;

    fprintf( PerfFd, " %8.4f %9.4f %8.1f%%\n",
             InfoPtr->CpuTime, InfoPtr->WallTime, CpuUse * 100.0 );
    }
}


void DumpRunTimeInfo()
{
  register struct WorkerInfo *InfoPtr;
  register int    Worker;
  register double CopyInfo, ATAttempts, ATCopies, ANoOpAttempts;
  register double RBuilds;
  register double ANoOpCopies, RNoOpAttempts, RNoOpCopies, ADataCopies;
  register int    StorageUsed, StorageWanted, DsaHelp;
  register double FlopInfo, FlopCountA, FlopCountL, FlopCountI;

  FlopInfo = FlopCountA = FlopCountL = FlopCountI = 0.0;

  CopyInfo = RBuilds = ATAttempts = ATCopies = ANoOpAttempts = 0.0;
  ANoOpCopies = RNoOpAttempts = RNoOpCopies = ADataCopies = 0.0;
  StorageUsed =  StorageWanted = DsaHelp = 0;

  for ( Worker = 0; Worker < NumWorkers; Worker++ ) {
    InfoPtr = &(AllWorkerInfo[ Worker ]);

    CopyInfo      += InfoPtr->CopyInfo;
    FlopInfo      += InfoPtr->FlopInfo;

    FlopCountA    += InfoPtr->FlopCountA;
    FlopCountL    += InfoPtr->FlopCountL;
    FlopCountI    += InfoPtr->FlopCountI;

    RBuilds       += InfoPtr->RBuilds;
    ATAttempts    += InfoPtr->ATAttempts;
    ATCopies      += InfoPtr->ATCopies;
    ANoOpAttempts += InfoPtr->ANoOpAttempts;
    ANoOpCopies   += InfoPtr->ANoOpCopies;
    RNoOpAttempts += InfoPtr->RNoOpAttempts;
    RNoOpCopies   += InfoPtr->RNoOpCopies;
    ADataCopies   += InfoPtr->ADataCopies;

    DsaHelp        += InfoPtr->DsaHelp;
    StorageUsed    += InfoPtr->StorageUsed;
    StorageWanted  += InfoPtr->StorageWanted;
    }

  fprintf( PerfFd, "\n\n\n" );
  fprintf( PerfFd, "  Workers   DsaSize  ExactFit  DsaHelps\n" );
  fprintf( PerfFd, "%9d %8db %8db %9d\n\n", 
	           NumWorkers, DsaSize, XftThreshold, DsaHelp );

  if ( !UseGss ) {
    fprintf( PerfFd, "     MemW      MemU  LpSliceV   ArrayEx\n" );
    fprintf( PerfFd, "%8db %8db %9d %9d\n\n", 
		     StorageWanted, StorageUsed, LoopSlices, ArrayExpansion );
  } else {
    fprintf( PerfFd, "     MemW      MemU   GssFact   ArrayEx\n" );
    fprintf( PerfFd, "%8db %8db %9d %9d\n\n", 
		     StorageWanted, StorageUsed, 1, ArrayExpansion );
    }

  PrintExecutionTimes();

  if ( CopyInfo > 0.0 ) {
    fprintf( PerfFd, "\n              AtOps            AtCopies"  );
    fprintf( PerfFd, "               AcOps            AcCopies\n" );
    fprintf( PerfFd, " %18.0f  %18.0f  %18.0f  %18.0f\n\n", ATAttempts, 
		       ATCopies, ANoOpAttempts, ANoOpCopies          );

    fprintf( PerfFd, "              RcOps            RcCopies" );
    fprintf( PerfFd, "           CharMoves\n" );
    fprintf( PerfFd, " %18.0f  %18.0f  %18.0f\n", RNoOpAttempts, 
		       RNoOpCopies, ADataCopies               );

    fprintf( PerfFd, "            RBuilds\n" );
    fprintf( PerfFd, " %18.0f\n", RBuilds );
    }

  if ( FlopInfo > 0.0 ) {
    fprintf( PerfFd, "\n FlopCounts (ARITHMETIC): %18.0f\n", FlopCountA );
    fprintf( PerfFd, "               (LOGICAL): %18.0f\n", FlopCountL );
    fprintf( PerfFd, "             (INTRINSIC): %18.0f\n", FlopCountI );
    }

  fprintf( PerfFd, "\n" );
}


void InitSisalRunTime()
{
  AcquireSharedMemory( DsaSize );

  InitDsa( DsaSize, XftThreshold );

  InitErrorSystem();
  InitWorkers();
  InitReadyList();
  InitSignalSystem();
  InitSpawn();
}
