.TH S.OUT local
.SH NAME
s.out \- SISAL executable
.SH SYNOPSIS
.B s.out 
[ options ] [ infile ] [ outfile ]
.SH DESCRIPTION
.I S.out
is the output file of the optimizing SISAL compiler (see \fIosc\fR(1)) and the
link editor \fIld\fR(1).  It is executable if there were no errors and
no unresolved externals during compilation.
When execution begins, FIBRE input is read from
infile (if provided) or
standard input and is associated positionally
with the arguments of the main SISAL
function.  At completion, results are
written in positional order
to outfile (if provided) or standard output in FIBRE form.
The character `-' implies standard input or output if it appears as  a
file parameter.

Options:
.TP 12
.BI \-wNUM
Set the number of worker processes to
.I NUM.
A value greater than one makes sense only on a multiprocessor
SISAL implementation (Cray, Encore, Sequent, Alliant, etc.).  Default:  1.

.TP 12
.BI \-lsNUM
If compiled for concurrent execution
(refer to \fIosc\fR(1)), 
slice each concurrentized 
.I for
loop into
.I NUM 
pieces.
Default:  Slice each concurrentized
loop into
.I W
pieces, where 
.I W
is the number of workers.

.TP 13
.B \-gss
If compiled for concurrent execution,
slice each concurrentized 
.I for
loop using guided self
scheduling.  Here the thickness of a slice is dynamically computed as
the number of iterations not yet scheduled divided by the
number of workers.
Note that the \-ls and \-gss options conflict.

.TP 12
.BI \-b
If compiled for concurrent execution 
(refer to \fIosc\fR(1)),
use the distributed run queue system to
bind parallel work to worker processes in a consistent and regular
manner. 
In the absence of gang scheduling, this option could degrade performance
if the machine load is high.
Default: Use the shared run queue system.
WARNING: on the SGI this option binds processors to worker processes,
and under heavy system loads, this can severely degrade job and system 
throughput.

.TP 12
.BI \-axNUM
Set array expansion value to
.I NUM\.
Each time the space for a dynamically growing array must be
expanded, it will obtain \fINUM\fR times the number of previous
expansions more elements.
Programs with dynamically growing arrays may benefit from a
larger value.  
The expansion value is also used to prevent memory fragmentation in
programs repeatedly building and recycling incrementally smaller or 
larger arrays.
Default:  100.

.TP 12
.BI \-dsNUM
Initialize the shared data management pool 
to
.I NUM
bytes.  An execution that terminates because of storage deadlock may
need more dynamic memory.  Default:  2000000 bytes.

.TP 12
.BI \-dxNUM
Set the exact fit storage allocation threshold to
.I NUM
bytes.  This eliminates the existence of
leftover free blocks whose sizes are smaller than \fINUM\fR bytes.  
Default: 100.

.TP 12
.BI \-r
Append resource utilization information to the file s.info (elapsed cpu
time, elapsed wall clock time, memory utilization figures, etc.).
A new file is created if s.info does not exist.

.TP 12
.BI \-z
Do not print the program's output. Default: print the program's output.

.SH IMPORTANT NOTES
One may provide an upper bound in a FIBRE array definition to reduce
FIBRE processing time.  Simply follow the lower bound by a comma 
and then the upper bound; for example,  "[1,2: 10 20]".
