#!/usr/bin/awk -f
#     %W% :: %G%

# This is an AWK script that converts conditional vector
# merge statements of the form:
#     target = cvmgX(arg1,arg2,arg2)
#     (where X can be any of "p", "m", "n", "z", or "t")
# to an equivelent IF-THEN-ELSE statement.
# The cvmgX cannot span more than one line, nor can it
# be part of a larger expression.
#

{
      ixp = index($0,"cvmgp");
      ixm = index($0,"cvmgm");
      ixz = index($0,"cvmgz");
      ixn = index($0,"cvmgn");
      ixt = index($0,"cvmgt");
      izsum = ixp + ixm + ixz + ixn + ixt
      if (izsum == 0) {
         print $0
	 }
      else {
#        print "C AWK HERE -----------------------------------------";
#	 print $0;

#	 ::::: set some constants
	 blank = " ";
	 true = 1;
	 false = 0;
	 lparen = "(";
	 rparen = ")";
	 comma = ",";

#        ::::: get indention string
	 indent = index($0,$1);
	 indstr = substr($0,1,indent-1);

#	 ::::: collect statement, strip whitespace
	 strip = "";
	 complete = 0;
	 paren = 0;
	 instr = $0;
	 while (complete != true) {
  	    nlen = length($0);
	    for (i=1; i<=nlen; i++) {
	       cr = substr(instr,i,1);

#	       ::::: coune paren nestings
	       if (cr == lparen)
	         { paren++ }
	       else if (cr == rparen)
	         { paren--};

#	       ::::: strip blanks
	       if ((cr != blank) && (cr != "	"))
	         { strip = strip cr };
	    };
#           ::::: check of all on one line
	    if (paren == 0)
	      { complete = true }
	    else
	      { 
#               ::::: not on one line ... punt
	        print $0;
	        next
	      };
	 };
	 
#	 print "stripped = " strip;

#	 ::::: break into fields
	 ncnt = split(strip,flds,"=");
         target = flds[1];
	 cvm = substr(flds[2],5,1);
	 args = substr(flds[2],7,length(flds[2])-7);
	 if (target=="" || args=="") {
#	      ::::: part of larger expression ... punt
	      print $0;
	      next
	    };
	 eqindex = index(strip,"=");
	 if (eqindex == 0) {
#	      ::::: part of larger expression ... punt
	      print $0;
	      next
	    }
	 else if (substr(strip,eqindex+1,4) != "cvmg") {
#	      ::::: part of larger expression ... punt
	      print $0;
	      next
	      };

#	 print "target = " target;
#	 print "args   = " args;
#	 print "cvm    = " cvm;

#        ::::: break out individual arguments
	 chunk[1] = "";
	 chunk[2] = "";
	 chunk[3] = "";
	 iarg = 1;
	 paren = 0;
	 for (i=1;i<=length(args);i++) {
	    ch = substr(args,i,1);
	    if ((ch == comma) && (paren == 0)) {
	       iarg++ }
	    else {
	       chunk[iarg] = chunk[iarg] ch;
	       if (ch == lparen) {
	         paren++  }
	       else if (ch == rparen) {
	         paren--  }
	       }
	    };

#	 ::::: determine comparitor
	 if (cvm == "p") {
	    prefix1 = "";
	    cmpar1  = " .ge. 0.0 ";
	    prefix2 = "";
	    cmpar2  = " .lt. 0.0 "
	    }
	 else if (cvm == "m") {
            prefix1 = "";
	    cmpar1  = " .lt. 0.0 ";
            prefix2 = "";
	    cmpar2  = " .ge. 0.0 "
	    }
	 else if (cvm == "n") {
            prefix1 = "";
	    cmpar1  = " .ne. 0.0 ";
            prefix2 = "";
	    cmpar2  = " .eq. 0.0 ";
	    }
	 else if (cvm == "z") {
            prefix1 = "";
	    cmpar1  = " .eq. 0.0 ";
	    prefix2 = "";
	    cmpar2  = " .ne. 0.0 ";
	    }
	 else if (cvm == "t") {
            prefix1 = "";
	    cmpar1  = "";
            prefix2 = " .not. " lparen;
	    cmpar2  = rparen;
	    }
	 
#	 ::::: produce output
#        print "TRANSLATES TO:";
	 if (target == chunk[1]) {
  	   print indstr "if (" prefix2 chunk[3] cmpar2 ") then"
	   print indstr "  "target" = "chunk[2]
	   print indstr "endif"
	   }
	 else if (target == chunk[2]) {
  	   print indstr "if (" prefix1 chunk[3] cmpar1 ") then"
	   print indstr "  "target" = "chunk[1]
	   print indstr "endif"
	   }
	 else {
  	   print indstr "if (" prefix1 chunk[3] cmpar1 ") then"
	   print indstr "  "target" = "chunk[1]
	   print indstr "else"
	   print indstr "  "target" = "chunk[2]
	   print indstr "endif"
	   }
	}
}
