#include <stdio.h>
#include </usr/include/math.h>

#define MAXLONG 2147843647.0
#define NUM_SURFACES 7.0
#define TSIZE 0.20
#define NUM_TRIANGLES 250
#define FALSE 0
#define TRUE 1

/* generate NUM_TRIANGLES random triangles
   max offset from "center" is TSIZE % of range
   -1 to 1
*/

long random();

/*==============================================*/

float next_rand() /* return range -1.0 < x < 1.0 */
{
  return (2.0*((float) random())/MAXLONG - 1.0);
}

/*==============================================*/

float clip (x)
float x;

{ float y;

  if (x > 1.0)
    y = 1.0;
  else if (x < -1.0)
    y = -1.0;
  else
    y = x;

  return (y);
}

/*==============================================*/

void generate_pt (pt_num, x0, y0, z0)
long pt_num;
float x0, y0, z0;

{float x1,y1;

  x1 = clip (x0 + TSIZE*next_rand());
  y1 = clip (y0 + TSIZE*next_rand());

  printf(" %d: <%.3f %.3f %.3f>", pt_num, x1, y1, z0);
}

/*==============================================*/

void gen_triangle_pts (pt1, semi_colon)
long pt1, semi_colon;
{float x0, y0, z0;

  x0 = next_rand();
  y0 = next_rand();
  z0 = next_rand();
  if (semi_colon)
    printf (";\n");
  generate_pt (pt1,   x0, y0, z0);
  printf (";\n");
  generate_pt (pt1+1, x0, y0, z0);
  printf (";\n");
  generate_pt (pt1+2, x0, y0, z0);
}

/*==============================================*/

void main ()
{
 long i, p, surf_id, semi_colon;

 p = 1;
 semi_colon = FALSE;
 printf ("[");   /* start pt array */

 for (i=0; i<NUM_TRIANGLES; i++) {
   gen_triangle_pts (p, semi_colon);
   p += 3;
   semi_colon = TRUE;
 }
 printf ("]\n"); /* end pt array */

 p = 1;
 semi_colon = FALSE;
 printf ("\n["); /* start triangle array */

 for (i=1; i<=NUM_TRIANGLES; i++) {
   surf_id  = (long) (NUM_SURFACES*(random()/MAXLONG) + 1.0);
   if (semi_colon)
     printf (";\n");
   printf ("%d: <%d %d %d %d>", i, surf_id, p, p+1, p+2);
   p += 3;
   semi_colon = TRUE;
 }
 printf ("]\n"); /* end triangle array */
}
