#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

/* ------------------------------------------------------------ */
NodeInfo
FindFunctionInModule(name,ModOffset)
     char	*name;
     int	ModOffset;
{
  NodeInfo	Table;
  int		Entry;
  int		TableSize;

  /* ------------------------------------------------------------ */
  FixupName(name);		/* Make it upper case */

  /* ------------------------------------------------------------ */
  Table = Linkage[ModOffset];
  TableSize = ModuleSizeOf(Table);

  /* ------------------------------------------------------------ */
  for(Entry=1;Entry<=TableSize;Entry++) {
    if (IsGraph(Table+Entry) &&
	strcmp(GraphNameOf(Table+Entry),name)==0) {
      return Table+Entry;
    }
  }

  return (NodeInfo)NULL;
}
/* ------------------------------------------------------------ */
void
SplitModuleFunctionName(S,ModPtr,FPtr,NamePtr)
     char	*S;
     int	*ModPtr;
     NodeInfo	*FPtr;
     char	**NamePtr;
{
  char		*DelPtr;
  char		FunctionName[MaxCommentSize];

  /* ------------------------------------------------------------ */
  /* First, find out if there is a ' indicating a module ID */
  /* If there is a module, break it out and look up the offset */
  DelPtr = index(S,'`');
  if ( DelPtr ) {
    *DelPtr = '\0';		/* Terminate the name */
    *ModPtr = GetModuleOffset(S);
    S = DelPtr+1;
  } else {
    *ModPtr = CurrentModule;
  }

  /* ------------------------------------------------------------ */
  /* Now break out the function and look it up in the module... */
  DelPtr = index(S,':');
  if ( DelPtr ) {
    *DelPtr = '\0';		/* Terminate the function name */
    (void)strcpy(FunctionName,S);
    *FPtr = FindFunctionInModule(FunctionName,*ModPtr);
    S = DelPtr+1;
  } else {
    *FPtr = (NodeInfo)NULL;
  }

  *NamePtr = S;
}
/* ------------------------------------------------------------ */
NodeInfo
FunctionOf(N)
     NodeInfo	N;
{
  while(N != ParentOf(N)) N = ParentOf(N);

  return N;
}
/* ------------------------------------------------------------ */
int
InNameList(S,L,n)
     char	*S;
     char	*L[];
     int	n;
{
  int		i;

  for(i=0;i<n;i++) if ( L[i] && strcmp(S,L[i]) == 0 ) return 1;

  return 0;
}
/* ------------------------------------------------------------ */
int
BreakName(args,BreakOrTrace)
     char	*args;
     int	BreakOrTrace;
{
  char		*parse[2];
  int		Line;
  int		ModuleOffset;
  int		BreakPoint;
  int		Identifier;
  NodeInfo	F,M;
  char		*name;
  NodeInfo	NodeList[MaxBreakAtPoint];
  int		NodeCount;
  int		i;

  /* Assume that no breakpoint will be set */
  Identifier = 0;

  /* ------------------------------------------------------------ */
  /* Break out the name and optional line number */
  ParseList(args,parse,1);

  /* ------------------------------------------------------------ */
  /* Split out the name, function, and module info */
  SplitModuleFunctionName(parse[0],&ModuleOffset,&F,&name);
  if ( ModuleOffset < 0 ) return Identifier;
  MakeUpper(name);
  Line = atoi(parse[1]);

  /* ------------------------------------------------------------ */
  /* Find all the nodes that set this name by checking each node in */
  /* the module.  If the function F is specified, then it also must be */
  /* a node within that function. */
  M = Linkage[ModuleOffset];
  for(i=1,NodeCount=0; i<=ModuleSizeOf(M); i++) {
    if (!IsGraph(M+i) &&
	NodeCount < MaxBreakAtPoint &&
	InNameList(name,OutputEdgeNames(M+i),OUTARITY(M+i)) &&
	(!F || FunctionOf(M+i) == F) &&
	(Line <= 0 || (M+i)->DebugInfo.SL == Line)) {
      NodeList[NodeCount++] = M+i;
    }
  }

  /* ------------------------------------------------------------ */
  /* If there are no nodes, emit a warning */
  if ( NodeCount == 0 ) {
    DebugMessage("No instruction creates that name\n");
  } else {
    /* Show the nodes that were selected */
    for(i=0;i<NodeCount;i++) DisplayNode("  ",NodeList[i]);

    /* Prepare a breakpoint entry in the table */
    BreakPoint = FirstFreeBreakPoint();
    if ( BreakPoint < 0 ) {
      DebugMessage("No space in breakpoint table\n");
    } else {
      Identifier = AddBreakPoint(BreakPoint,NameBreak,BreakOrTrace,args);
      for(i=0;i<NodeCount;i++) AddHash(NodeList[i],BreakPoint);
    }
  }

  return Identifier;
}
