#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

/* ------------------------------------------------------------ */
static void
ListFunctionsInModule(Module)
     NodeInfo	Module;
{
  int		Entry;
  char		message[100];
  char		unfixedname[100];

  for(Entry=1;Entry<=ModuleSizeOf(Module);Entry++) {
    if (IsGraph(Module+Entry) &&
	IsFunctionName(GraphNameOf(Module+Entry))
	) {
      /* Remove the trailing underscore for display */
      UnFixupName(GraphNameOf(Module+Entry),unfixedname);
	      
      (void)sprintf(message,"  %s:%s at line %d\n",
	      ModuleNameOf(Module),
	      unfixedname,
	      (Module+Entry)->DebugInfo.SL
	      );
      DebugMessage(message);
    }
  }
}

/* ------------------------------------------------------------ */
void
ListFunctions(com)
     char	*com;
{
  char		*parse[2];
  NodeInfo	Module;
  int		NT;

  if ( *com ) {
    /* Must want a specific module */
    if ( *com == '.' ) {
      Module = Linkage[CurrentModule];
    } else {
      ParseList(com,parse,1);
      Module = Linkage[FindModule(parse[0])];
    }

    if ( Module ) {
      ListFunctionsInModule(Module);
    } else {
      DebugMessage("No such module\n");
    }
  } else {
    /* List all functions */
    for(NT=0;Linkage[NT];NT++) {
      ListFunctionsInModule(Linkage[NT]);
    }
  }
}

/* ------------------------------------------------------------ */
void
ListModules(com)
     char	*com;		/* ARGSUSED */
{
  int		NT;
  char		message[100];

  for(NT=0;Linkage[NT];NT++) {
    (void)sprintf(message,"  %s\n",ModuleNameOf(Linkage[NT]));
    DebugMessage(message);
  }
}

/* ------------------------------------------------------------ */
void
ListBreakPoints(com)
     char	*com;		/* ARGSUSED */
{
  char		*parse[2];
  int	LB,HB;
  int	i;

  if (!*com) {
    /* List every possible breakpoint */
    LB = LowestBreakPoint();
    HB = HighestBreakPoint();
    
    for(i=LB;i<=HB;i++) {
      DisplayBreakPoint(i);
    }
  } else {
    /* Peal off arguments one at a time and display the breakpoint */
    ParseList(com,parse,1);
    while(*parse[0]) {
      DisplayBreakPoint(atoi(parse[0]));
      ParseList(parse[1],parse,1);
    }
  }
}

/* ------------------------------------------------------------ */
int
starstrcmp(a,b)
     char	**a,**b;
{
  return strcmp(*a,*b);
}
/* ------------------------------------------------------------ */
int
GetListOfFunctionNames(com,NameList,Max,FPtr)
     char	*com;
     char	**NameList;
     int	Max;
     NodeInfo	*FPtr;
{
  NodeInfo	F;
  char		*parse[2];
  int		i;
  int		Names;
  char		*VarName;

  /* Find the function to list and whether to list all names*/
  if (!*com) {
    F = TopLevelFunction();
  } else {
    ParseList(com,parse,1);
    F = FindGraph(parse[0],NULL,FALSE);
  }

  if ( F && IsGraph(F) && IsFunctionName(GraphNameOf(F)) ) {
    *FPtr = F;

    /* Add each of the (identifier) names to the list */
    for(i=0,Names=0;i<GlobalNameCount(F) && Names < Max;i++) {
      VarName = GlobalNames(F)[i];
      if ( isalpha(*VarName) ) NameList[Names++] = VarName;
    }

    /* Sort the list of identifiers */
    qsort((char*)NameList,Names,sizeof(*NameList),starstrcmp);
  } else {
    *FPtr = NULL;
  }

  return Names;
}

/* ------------------------------------------------------------ */
void
ListNames(com)
     char	*com;
{
  int		NameCount;
  char		*NameList[MaxNamesToList];
  NodeInfo	F;
  char		message[MaxCommentSize];
  int		i;

  /* Get list of names */
  NameCount = GetListOfFunctionNames(com,NameList,MaxNamesToList,&F);

  /* List the names */
  if ( F ) {
    (void)sprintf(message,"Names of %s\n",GraphNameOf(F));
    DebugMessage(message);

    for(i=0;i<NameCount;i++) {
      (void)sprintf(message,"  %s\n",NameList[i]);
      DebugMessage(message);
    }
  } else {
    DebugMessage("No such function\n");
  }
}

/* ------------------------------------------------------------ */
void
ListSystemVars(com)
     char	*com;		/* ARGSUSED */
{
  int		i;
  char		message[MaxCommentSize];

  for(i=0;SystemVariables[i].Name;i++) {
    switch ( SystemVariables[i].Type ) {
     case SysInteger:
      (void)sprintf(message,"  %s\t= %d\n",
		      SystemVariables[i].Name,
		      *((int*)(SystemVariables[i].Value))
		      );
      DebugMessage(message);
      break;

     case SysBool:
      (void)sprintf(message,"  %s\t= %s\n",
		      SystemVariables[i].Name,
		      (*((int*)(SystemVariables[i].Value)))?"True":"False"
		      );
      DebugMessage(message);
      break;

     default:;
    }
  }
}

/* ------------------------------------------------------------ */
void
ListOpsAt(args)
     char	*args;
{
  int		line;
  NodeInfo	Node;
  int		ModuleOffset;
  char		*ColonPtr;
  char		message[MaxCommentSize];

  /* Get the line number to list (and the module) */
  if ( !*args ) {
    DebugMessage("Listing operations requires line number\n");
  } else {
    ColonPtr = index(args,':');
    if ( ColonPtr ) {
      line = atoi(ColonPtr+1);
      *ColonPtr = '\0';
      ModuleOffset = GetModuleOffset(args);
    } else {
      line = atoi(args);
      ModuleOffset = CurrentModule;
    }


    /* Find the first node at the line */
    Node = FindNode(Linkage[ModuleOffset],line,1);

    /* Make sure it matches the line we want */
    if ( (!Node) ) {
      DebugMessage("No nodes in module\n");

    } else if ( Node->DebugInfo.SL != line ) {
      (void)sprintf(message,"No code at line %d, try %d\n",
	      line,Node->DebugInfo.SL);
      DebugMessage(message);

    } else {
      do {
	DisplayNode("  ",Node);
	Node = FindNode(Linkage[ModuleOffset],line,NodeIDOf(Node)+1);
      } while ( Node && Node->DebugInfo.SL == line );
    }
  }
}
