#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

/* Modification History:
   W.Cedeno, 10/23/91 - Modified FindLocalsInModule, InitializeGraphLocals,
   and AddLocal and deleted AppendLocal to correct the definition of local
   names.  The names will be using the Setup code.
*/

int
SameName(a,b)
     char	*a,*b;
{
  return (a==b) || (strcmp(a,b) == 0);
}

int
IsGlobalName(name,Graph)
     char	*name;
     NodeInfo	Graph;
{
  int		i;

  /* Compare the name to each entry in the global names table */
  for(i=0;i<GlobalNameCount(Graph);i++) {
    if ( SameName(name,GlobalNames(Graph)[i]) ) return 1;
  }

  return 0;
}

int
IsLocalName(name,Graph)
     char	*name;
     NodeInfo	Graph;
{
  int		i;

  /* Compare the name to each value exported by the graph.  If it */
  /* doesn't match any, it must be produced in the graph. */
  for(i=0;i<INARITY(Graph);i++) {
    if ( InputEdgeNames(Graph)[i] &&
	SameName(name,InputEdgeNames(Graph)[i]) ) return 0;
  }

  return 1;
}

void
InitializeGraphLocals(Graph, Size)
     NodeInfo	Graph;
     int Size;
{
  /* Creates a list to store the Local names for the graph */
    LHSLocalNameOf(Graph)		= CAllocate(Size,char*);
}

void
AddLocals( Graph, offset, name )
    NodeInfo   Graph;
    int offset;
    char *name;
{
    LocalNameOf(Graph)[offset-1] = name;
}

void
InitializeGraphGlobals(Graph)
     NodeInfo	Graph;
{
  int	i;

  /* If this is a function, then create a list for all known global */
  /* names.  This list is used by the ``list names'' command. */
  if ( IsFunctionName(GraphNameOf(Graph)) ) {
    LHSGlobalNames(Graph)	= CAllocate(GlobalListGuessSize,char*);
    GlobalNameCount(Graph)	= 0;
    for(i=0;i<GlobalListGuessSize;i++) {
      GlobalNames(Graph)[i] = NULL;
    }
    /* Mark the last one */
    GlobalNames(Graph)[GlobalListGuessSize-1] = "";
  }
}

NodeInfo
FunctionOfNode(N)
     NodeInfo	N;
{
  while(ParentOf(N) != N) N = ParentOf(N);

  return N;
}

void
AppendGlobalName(F,name)
     NodeInfo	F;
     char	*name;
{
  char		**NewList;
  int		i;

  /* Append the name if it isn't already included */
  if ( name && *name && !IsGlobalName(name,F) ) {
    /* If we've reached the end of the list, then it must be extended */
    if ( GlobalNames(F)[GlobalNameCount(F)] ) {
      /* Get a new globals list */
      NewList = CAllocate(GlobalNameCount(F)*2,char*);

      /* Copy in the old values */
      for(i=0;i<GlobalNameCount(F);i++) NewList[i] = GlobalNames(F)[i];

      /* Null out the rest of the values and include a non-null terminator */

      for(;i<GlobalNameCount(F)*2;i++) NewList[i] = NULL;
      NewList[GlobalNameCount(F)*2-1] = "";

      /* Replace the list with the new list */
      Free(GlobalNames(F));
      LHSGlobalNames(F)	= NewList;
    }

    GlobalNames(F)[GlobalNameCount(F)++] = name;
  }
}

void
AppendNames(N)
     NodeInfo	N;
{
  NodeInfo	F;
  int		i;

  if ( HasNames(N) ) {
    /* Get the nodes function */
    F = FunctionOfNode(N);

    /* Append the input and output edge names */
    if ( HasNames(N) ) {
      for(i=0;i<INARITY(N);i++) {
	if (InputEdgeNames(N)[i]) {
	  AppendGlobalName(F,InputEdgeNames(N)[i]);
	}
      }
      for(i=0;i<OUTARITY(N);i++) {
	if (OutputEdgeNames(N)[i]) {
	  AppendGlobalName(F,OutputEdgeNames(N)[i]);
	}
      }
    }
  }
}

void
FindLocalsInModule(Module)
     NodeInfo	Module;
{
  int		i;

  for(i=1;i<=ModuleSizeOf(Module);i++) {
    if ( InfoKind(Module+i) == Graph )
      InitializeGraphGlobals(Module+i);

    /* Build a global name list for each function */
    AppendNames(Module+i);
  }

}

void
FindLocalNames()
{
  int		NT;
  
  for(NT=0;Linkage[NT];NT++) FindLocalsInModule(Linkage[NT]);
}
