#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

NodeInfo
FunctionOwner(info)
     NodeInfo	info;
{
  return info-(info->NodeID);
}

void
CollectFibre(in,n,values,valsize)
     IF1OBJECT	*in[];
     int	n;
     char	*values;
     int	valsize;
{
  int		i;

  /* Initialize the value string */
  OpenStringOutput(values,valsize);

  for(i=0;i<n;i++) {
    /* Produce a comma separated list */
    if ( i != 0 ) OutputChar(',');

    /* Append a new Fibre value */
    FibrePrint(in[i]);
  }

  /* Close off the string */
  CloseStringOutput();
}

void
CollectNames(in,Names,Count,values,valsize)
     IF1OBJECT	*in[];
     char	**Names;
     int	Count;
     char	*values;
     int	valsize;	/* ARGSUSED */
{
  int		i, len, mlen;
  char		message[MaxCommentSize], *m;

  values[0]	= '\0';
  for(len=0,i=0;i<Count;i++) {
    /* Produce a comma separated list */
    if ( i != 0 ) { (void)strcat(values,","); ++len; }

    /* Append the name (or the value if there is no name or only a */
    /* bloak name). */
    if (Names[i] && *Names[i]) {
      mlen = strlen(Names[i]);
      m = Names[i];
    } else if ( in && in[i] ) {
      FibrePrintString(in[i],message,sizeof(message));
      mlen = strlen(message);
      m = message;
    } else 
    {
      m = "";
      mlen = 0;
    }
    
    if ( (mlen + len) > (valsize - 4) )
    {
      (void)strcat(values,"...");
      break;
    }
    else
    {
      (void)strcat(values,m);
      len += mlen;
    }
  }
}
/* ------------------------------------------------------------ */
void
DebugDisplay(BreakPoint)
     int	BreakPoint;
{
  Environment	*Env,*F;
  NodeInfo	Mod;
  char		UnFixedName[NameSize];
  char		Values[MaxCommentSize];
  char		message[MaxCommentSize+80];

  Env = TopOfEnvironmentStack();

  if (Env) {
    F = GetFunctionNode(Env);
    if (F) {
      UnFixupName((F)?F->NAME:"_",UnFixedName);

      Mod = FunctionOwner(F->INFO);

      if ( DisplayByName) {
	if ( IsGraph(Env->INFO) ) 
	{
	  CollectNames(Env->IN, OutputEdgeNames(Env->INFO),OUTARITY(Env->INFO),
		     Values, sizeof(Values));
	}
	else 
	{
	  CollectNames(Env->IN,InputEdgeNames(Env->INFO),INARITY(Env->INFO),
		     Values,sizeof(Values));
	}
	
      } else {
	if ( IsGraph(Env->INFO) ) {
	  CollectFibre(Env->IN,OUTARITY(Env->INFO),Values,sizeof(Values));
	} else {
	  CollectFibre(Env->IN,INARITY(Env->INFO),Values,sizeof(Values));
	}
      }

      /* Attempt to retreive the source line */
      GrabLine(UsagePath,ModuleNameOf(Mod),
	       Env->INFO->DebugInfo.SL,message,sizeof(message));
      DebugMessage(message);

      (void)sprintf(message,"[%d] Stopped at %s %s %d = %s(%s)",
	     BreakPoint,
	     ModuleNameOf(Mod),
	     UnFixedName,
	     Env->INFO->DebugInfo.SL,
	     Env->NAME,
	     Values);
      DebugMessage(message);

      if ( !IsGraph(Env->INFO) ) 
      {
	CollectNames(Env->OUT, OutputEdgeNames(Env->INFO),OUTARITY(Env->INFO),
		     Values, sizeof(Values));
      }
      else 
      {
	CollectNames(Env->IN,InputEdgeNames(Env->INFO),INARITY(Env->INFO),
		     Values,sizeof(Values));
      }
	
      (void)sprintf(message," -> %s\n", Values);
      DebugMessage(message);
    }
  } else {
    DebugMessage("At top level\n");
  }
}
/* ------------------------------------------------------------ */
void
DisplayNode(Indentation,N)
     char	*Indentation;
     NodeInfo	N;
{
  NodeInfo	F;
  NodeInfo	Mod;
  char		FunctionName[NameSize];
  char		GraphName[NameSize];
  char		*OperationName;
  char		InValues[MaxCommentSize/2];
  char		OutValues[MaxCommentSize/2];
  char		message[MaxCommentSize+100];

  if (N) {
    F = FunctionOfNode(N);
    if (F) {
      /* Get the name of the operation */
      if ( IsGraph(N) ) {
	UnFixupName(GraphNameOf(N),GraphName);
	OperationName = GraphName;
      } else {
	OperationName = OpList[OpCodeOf(N)].Name;
      }

      /* Get the name of this function */
      UnFixupName(GraphNameOf(F),FunctionName);

      /* Get the module the function is in */
      Mod = FunctionOwner(F);

      /* Get a list of the input and output names for this node */
      CollectNames((IF1OBJECT**)NULL,
		   InputEdgeNames(N),
		   INARITY(N),
		   InValues,
		   sizeof(InValues));
      CollectNames((IF1OBJECT**)NULL,
		   OutputEdgeNames(N),
		   OUTARITY(N),
		   OutValues,
		   sizeof(OutValues));

      (void)sprintf(message,"%-21.20s%4d =%s %s:%s(%s) -> (%s)\n",
		    ModuleNameOf(Mod),
		    (N->DebugInfo.SL > 0) ? N->DebugInfo.SL: 0,
		    Indentation,
		    FunctionName,
		    OperationName,
		    (IsGraph(N))?OutValues:InValues,
		    (IsGraph(N))?InValues:OutValues);
      DebugMessage(message);
    }
  }
}
