#include "SC.h"
#include "SCLib.h"

/* ------------------------------------------------------------ */
/* This is the string I/O package for debugging, etc...  */
int	PrintStringCurrentLength[MaxStringIO];
int	PrintStringLength[MaxStringIO];
char	*PrintStringBuffers[MaxStringIO];
int	StringPrintLevel  = 0;

void
OpenStringOutput(string,len)
     char	*string;
     int	len;
{
  if ( StringPrintLevel >= MaxStringIO ) Oops("Too many strings open");

  string[0]					= '\0';
  PrintStringCurrentLength[StringPrintLevel]	= 0;
  PrintStringLength[StringPrintLevel]		= len-1;
  PrintStringBuffers[StringPrintLevel++]	= string;
}

void
CloseStringOutput()
{
  if ( StringPrintLevel > 0 ) StringPrintLevel--;
}

/* ------------------------------------------------------------ 
   The boolean type is the same for all representations
   ------------------------------------------------------------ */
static void
BooleanToString(Answer,X)
     char		*Answer;
     SisalBoolean	X;
{
  (void)strcpy(Answer,(X)?"T":"F");
}

/* ------------------------------------------------------------ */
static void
PrintError(T)
     TypeD	T;
{
  switch ( T->CODE ) {
    case IF1ARRAY:
      OutputString("error[");
      OutputString("error");
      OutputString(":");
      OutputString("]");
      break;

    case IF1BASIC:
      OutputString("error");
      break;

    case IF1MULTIPLE:
      OutputString("error\\");
      OutputString("/");
      break;
    case IF1FIELD:
    case IF1FUNCTION:
    case IF1RECORD:
    case IF1STREAM:
    case IF1TAG:
    case IF1TUPLE:
    case IF1UNION:
    default:
      Oops("");
  }
}
/* ------------------------------------------------------------ */
void
PrintBag(B,View,n)
     BagPtr	B;
     unsigned	View;
     unsigned	n;
{
  unsigned	i;

  if (B) {
    for(i=0;i<n;i++) {
      /* Add a separator if needed */
      if ( i != 0 ) Separator();

      /* Quit printing if the max size has been exceeded */
      if ( PrintMax && i > PrintMax ) {
	OutputString("...");
	break;
      }

      FibrePrint(PointerIntoBag(B,View+i));
    }
  }
}
/* ------------------------------------------------------------ */
static void
PrintArrayLike(OBJ,Open,Close)
     IF1OBJECT	*OBJ;
     char	*Open,*Close;
{
  char		Answer[MaxLineSize];
  char		*QString;
  unsigned	i;
  char		OpenString[16];
  IF1OBJECT	*EL;
  SisalCharacter	C;
  unsigned	Len;

  if ( PrintSize ) {
    (void)sprintf(Answer,"SZ = %d",ArrTS(OBJ));
    OutputComment(Answer);
  }

  if ( PrintStrings &&
      TypeEntryOf(TypeOf(OBJ)) == IF1ARRAY &&
      TypeEntryOf(ElementTypeOfArray(TypeOf(OBJ))) == IF1BASIC &&
      KindOfBasic(ElementTypeOfArray(TypeOf(OBJ))) == IF1Character &&
      IntegerToLocal(ArrLB(OBJ)) == 1 &&
      !IsAnErroneousValue(OBJ)
      ) {			/* It must be a quoted string */
    /* Start with a quote in a string big enough for any possiblity. */
    /* This is a maximum of 4 characters per element (\xxx) for */
    /* unprintable characters. */
    QString = CAllocate(4*ArrTS(OBJ)+3,char);
    Len = 0;
    QString[Len++] = '"';

    /* Append in a string to represent each character */
    for(i=0;i<ArrTS(OBJ);i++) {
      if ( PrintMax && i > PrintMax ) {
	OutputString("...");
	break;
      }

      EL = PointerIntoBag(ArrCol(OBJ),ArrView(OBJ)+i);
      C	 = CVal(EL);
      switch (C) {
       case '"':
	(void)strcpy(QString+Len,"\\\"");
	Len += 2;
	break;
       case '\010':
	(void)strcpy(QString+Len,"\\b");
	Len += 2;
	break;
       case '\014':
	(void)strcpy(QString+Len,"\\f");
	Len += 2;
	break;
       case '\012':
	(void)strcpy(QString+Len,"\\n");
	Len += 2;
	break;
       case '\015':
	(void)strcpy(QString+Len,"\\r");
	Len += 2;
	break;
       case '\011':
	(void)strcpy(QString+Len,"\\t");
	Len += 2;
	break;
       case '\\':
	(void)strcpy(QString+Len,"\\\\");
	Len += 2;
	break;
       default:
	if (isprint(C)) {
	  QString[Len++] = C;
	} else {
	  (void)sprintf(QString+Len,"\\%03o",C);
	  Len += 4;
	}
      }
    }
    QString[Len++] = '"';
    QString[Len++] = '\0';
    OutputString(QString);
    Free(QString);
  } else {
    /* Print in array form */
    if ( ArrIsOK(OBJ) ) {
      (void)strcpy(OpenString,Open);
    } else {
      (void)strcat(strcpy(OpenString,"error"),Open);
    }
    OutputString(OpenString);

    if (IsArrLBErr(OBJ)) {
      PrintError(IntegerTypeD);
    } else {
      IntegerToString(Answer,ArrLB(OBJ));
      OutputString(Answer);
    }

    OutputString(":");

    PrintBag(ArrCol(OBJ),ArrView(OBJ),ArrPS(OBJ));

    for(i=ArrPS(OBJ);i<ArrTS(OBJ);i++) {
      PrintError(ElementTypeOfArray(TypeOf(OBJ)));
    }

    OutputString(Close);
  }
}

/* ------------------------------------------------------------ */
static void
PrintArray(OBJ)
     IF1OBJECT	*OBJ;
{
  PrintArrayLike(OBJ,"[","]");
}
/* ------------------------------------------------------------ */
static void
PrintBasic(OBJ)
     IF1OBJECT	*OBJ;
{
  char		Answer[MaxLineSize];

  if ( BasErr(OBJ) ) {
    PrintError(TypeOf(OBJ));
  } else {
    switch(KindOfBasic(TypeOf(OBJ))) {
      case IF1Boolean:
      BooleanToString(Answer,BVal(OBJ));
      OutputString(Answer);
      break;

      case IF1Character:
      CharacterToString(Answer,CVal(OBJ));
      OutputString(Answer);
      break;

      case IF1Double:
      DoubleToString(Answer,DVal(OBJ));
      OutputString(Answer);
      break;

      case IF1Integer:
      IntegerToString(Answer,IVal(OBJ));
      OutputString(Answer);
      break;

      case IF1Null:
      OutputString("nil");
      break;

      case IF1Real:
      RealToString(Answer,RVal(OBJ));
      OutputString(Answer);
      break;

      default:
      Oops("");
    }
  }
}
/* ------------------------------------------------------------ */
static void
PrintField(OBJ)			/* ARGSUSED */
     IF1OBJECT	*OBJ;
{
  Oops("Can't print fields");
}
/* ------------------------------------------------------------ */
static void
PrintFunction(OBJ)
     IF1OBJECT	*OBJ;
{
  char		Answer[MaxLineSize];
  char		*p;
  
  /* Make an uppercase copy of the function name */
  (void)strcpy(Answer,FunName(OBJ));
  for(p=Answer;*p;p++) {
    if ( islower(*p) ) *p = toupper(*p);
  }

  OutputString(Answer);

}
/* ------------------------------------------------------------ */
static void
PrintMultiple(OBJ)
     IF1OBJECT	*OBJ;
{
  char		Answer[MaxLineSize];
  unsigned	i;
  IF1OBJECT	Element;

  if ( PrintSize ) {
    (void)sprintf(Answer,"SZ = %d",MultSize(OBJ));
    OutputComment(Answer);
  }
  if (MultError(OBJ)) {
    PrintError(TypeOf(OBJ));
  } else {
    OutputString("\\");
    for(i=0;i<MultSize(OBJ);i++) {
      if ( i != 0 ) Separator();
      if ( PrintMax && i > PrintMax ) {
	OutputString("...");
	break;
      }

      GetFromMult(OBJ,i,&Element);
      FibrePrint(&Element);
    }
    OutputString("/");
  }
}
/* ------------------------------------------------------------ */
static void
PrintRecord(OBJ)
     IF1OBJECT	*OBJ;
{
  if (RecErr(OBJ)) {
    OutputString("error<");
  } else {
    OutputString("<");
  }
  if (RecCol(OBJ)) PrintBag(RecCol(OBJ),0,FieldCountOfRecord(TypeOf(OBJ)));
  OutputString(">");
}
/* ------------------------------------------------------------ */
static void
PrintStream(OBJ)
     IF1OBJECT	*OBJ;
{
  TypeD		ElementType;
  IF1OBJECT	*Element;
  unsigned	i;

  if (StrictStreams) {
    ElementType = ElementTypeOfStream(TypeOf(OBJ));

    if ( UseStdio &&
	TypeEntryOf(ElementType) == IF1BASIC &&
	KindOfBasic(ElementType) == IF1Character
	) {
      /* Dump out the bag's characters */
      if (ArrCol(OBJ)) {
	for(i=0;i<ArrPS(OBJ);i++) {
	  Element = PointerIntoBag(ArrCol(OBJ),ArrView(OBJ)+i);
	  OutputChar(CharacterToLocal(CVal(Element)));
	}
      }
    } else {
      PrintArrayLike(OBJ,"{","}");
    }
  } else {
    Oops("Cannot print a non-strict stream");
  }
}
/* ------------------------------------------------------------ */
static void
PrintTag(OBJ)			/* ARGSUSED */
     IF1OBJECT	*OBJ;
{
  Oops("Can't print a Tag");
}
/* ------------------------------------------------------------ */
static void
PrintTuple(OBJ)			/* ARGSUSED */
     IF1OBJECT	*OBJ;
{
  Oops("Can't print a Tuple");
}
/* ------------------------------------------------------------ */
static void
PrintUnion(OBJ)
     IF1OBJECT	*OBJ;
{
  char		Answer[MaxLineSize];

  if ( UniErr(OBJ) ) {
    OutputString("error(");
  } else {
    OutputString("(");
  }

  if (UniVal(OBJ)) {
    IntegerToString(Answer,UniTag(OBJ));
    OutputString(Answer);
    OutputString(":");
    PrintBag(UniVal(OBJ),0,1);
  }
  OutputString(")");
}
/* ------------------------------------------------------------ */
static void
PrintEmpty(OBJ)			/* ARGSUSED */
     IF1OBJECT	*OBJ;
{
  OutputString("empty");
}
/* ------------------------------------------------------------ */
void
FibrePrint(OBJ)
     IF1OBJECT	*OBJ;
{
  /* Handle non-objects */
  if (!OBJ) {
    OutputString("<none>");
    return;
  }

  /* Print out the object */
  switch( TypeEntryOf(TypeOf(OBJ)) ) {
    case IF1ARRAY:     
      PrintArray(OBJ);
      break;

    case IF1BASIC:
      PrintBasic(OBJ);
      break;

    case IF1FIELD:
      PrintField(OBJ);
      break;

    case IF1FUNCTION:
      PrintFunction(OBJ);
      break;

    case IF1MULTIPLE:
      PrintMultiple(OBJ);
      break;

    case IF1RECORD:
      PrintRecord(OBJ);
      break;

    case IF1STREAM:
      PrintStream(OBJ);
      break;

    case IF1TAG:
      PrintTag(OBJ);
      break;

    case IF1TUPLE:
      PrintTuple(OBJ);
      break;

    case IF1UNION:
      PrintUnion(OBJ);
      break;

    case IF1EMPTY:
      PrintEmpty(OBJ);
      break;

    default:
      Oops("");
      break;

  }
}

char*
TypeNameOf(T)
     TypeD	T;
{
  return (T)?(T->INFO.Name):"<no-type>";
}

void
PrintList(list,n)
     IF1OBJECT	*list[];
     int	n;
{
  int	i;
  for(i=0;i<n;i++) {
    FibrePrint(list[i]);
  }
  putchar('\n');
}

void
PrintListWithNames(list,n,NameList)
     IF1OBJECT	*list[];
     int	n;
     char	***NameList;
{
  int	i;
  char	NL[DisplayLineSize+1],*Name;

  NL[0] = '\0';
  for(i=0;i<n;i++) {
    if ( NameList[i] ) {
      Name = *NameList[i];
    } else {
      Name = "None";
    }

    if ( strlen(NL)+strlen(Name)+2 < DisplayLineSize-3 ) {
      if (i) (void)strcat(NL,", ");
      (void)strcat(NL,Name);
    } else {
      (void)strcat(NL,"...");
      break;
    }
  }
  OutputComment(NL);

  for(i=0;i<n;i++) {
    FibrePrint(list[i]);
  }
  putchar('\n');
}

void
PrintBlock(list,n)
     IF1OBJECT	list[];
     int	n;
{
  int	i;
  for(i=0;i<n;i++) {
    FibrePrint(list+i);
  }
  putchar('\n');
}

/* ------------------------------------------------------------ */
/* FibrePrintString(Obj,str,len)				*/
/*   This function will print a fibre value into a string	*/
/*   instead of to the output device.  The string had better be	*/
/*   less than len chars long.					*/
void
FibrePrintString(Obj,str,len)
     IF1OBJECT	*Obj;
     char	*str;
     int	len;
{
  OpenStringOutput(str,len);
  FibrePrint(Obj);
  CloseStringOutput();
}
