#include "SC.h"
#include "SCLib.h"

void
ABuild(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define LB	(0)
#define Val	(1)
#define OutA	(0)

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(OType(info)[OutA]) ) {
    SetIsOK(out[OutA],	TRUE);
    SetLB(out[OutA],	BasErr(in[LB]),IVal(in[LB]));
    SetPS(out[OutA],	INARITY(info)-1);
    SetTS(out[OutA],	INARITY(info)-1);
    SetCol(out[OutA],	FillBag(in+1,1,
				(int)(INARITY(info)-1),ArrayInitialSize));
    SetView(out[OutA],	0);

    /* Make sure the lower bound is {1: ...} for streams */
    if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

    SetDes(out[OutA],	OType(info)[OutA]);
  } else {
    Oops("Streams not implemented for ABuild");
  }

#undef LB
#undef Val
#undef OutA
}

/* ------------------------------------------------------------ */
void
AFill(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define LO	(0)
#define HI	(1)
#define Val	(2)
#define OutA	(0)

  int		Size;

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(OType(info)[OutA]) ) {
    if (BasErr(in[LO]) || BasErr(in[HI]) ) {
      MakeError(out[OutA],OType(info)[OutA]);
    } else {
      Size = IntegerToLocal(ISub(IVal(in[HI]),IVal(in[LO])))+1;
      if (Size<0) Size = 0;

      SetIsOK(out[OutA],	TRUE);
      SetLB(out[OutA],		FALSE,IVal(in[LO]));
      SetTS(out[OutA],		Size);
      SetPS(out[OutA],		Size);
      SetCol(out[OutA],		FillBag(&(in[Val]),0, /* Fill from same spot */
					Size,ArrayInitialSize));
      SetView(out[OutA],	0);

      /* Make sure the lower bound is {1: ...} for streams */
      if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

      SetDes(out[OutA],		OType(info)[OutA]);
    }
  } else {
    Oops("Streams not implemented for AFill");
  }

#undef LO
#undef HI
#undef Val
#undef OutA
}
/* ------------------------------------------------------------ */
void
AElement(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define FirstPos (1)
#define El	(0)

  TypeD		ElementType;
  IF1OBJECT	*Obj;
  int		Pos;
  int		InAr = INARITY(info);

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(IType(info)[A]) ) {

    for(Pos=FirstPos,Obj=in[A]; Pos<InAr; Pos++) {
      if (!BasErr(in[Pos]) &&
	  !IsArrLBErr(Obj) &&
	  IGreatEqual(IVal(in[Pos]),ArrLB(Obj)) &&
	  ILess(IVal(in[Pos]),
		LocalToInteger(AddLocal(ArrLB(Obj),(int)ArrPS(Obj)))) &&
	  (Obj = PointerIntoBag( /* Yes, I want =  (don't use ==) */
				ArrCol(Obj),
				BagPos(IntegerToLocal(IVal(in[Pos])),Obj)),

	   (Obj != NULL))
	  ) {
      } else {
	ElementType = OType(info)[El];
	MakeError(out[El],ElementType);
	goto Done;
      }
    }

    /* After the loop, Obj should point at the element (unless we */
    /* skipped out on the error condition in which case this statement */
    /* is skipped)  */
    Copy(out[El],Obj);

   Done:
    ;

  } else {
    Oops("Streams not implemented for AElement");
  }

#undef A
#undef FirstPos
#undef El
}

/* ------------------------------------------------------------ */
void
ALimL(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define Lim	(0)

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(IType(info)[A]) ) {

    CreateInteger(out[Lim],IsArrLBErr(in[A]),ArrLB(in[A]));

  } else {
    Oops("Streams not implemented for ALimL");
  }

#undef A
#undef Lim
}

/* ------------------------------------------------------------ */
void
ALimH(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define Lim	(0)

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(IType(info)[A]) ) {

    if (ArrIsOK(in[A]) && !IsArrLBErr(in[A])) {
      CreateInteger(out[Lim],FALSE, 
		    LocalToInteger(
				   AddLocal(ArrLB(in[A]),ArrPS(in[A])-1)));
    } else {
      CreateInteger(out[Lim],TRUE,IntegerZero);
    }

  } else {
    Oops("Streams not implemented for ALimH");
  }

#undef A
#undef Lim
}
/* ------------------------------------------------------------ */
void
ASize(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define Size	(0)

  if ( ARRAYLIKE(IType(info)[A]) ) {
    if (ArrIsOK(in[A])) {
      CreateInteger(out[Size],FALSE,LocalToInteger(ArrPS(in[A])));
    } else {
      CreateInteger(out[Size],TRUE,IntegerZero);
    }
  } else {
    Oops("Streams not implemented for ASize");
  }

#undef A
#undef Size
}
/* ------------------------------------------------------------ */
void
APrefixSize(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define Size	(0)

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(IType(info)[A]) ) {
    CreateInteger(out[Size],FALSE,LocalToInteger(ArrPS(in[A])));
  } else {
    Oops("Streams not implemented for APrefixSize");
  }

#undef A
#undef Size
}
/* ------------------------------------------------------------ */
void
AIsEmpty(in,out,info)
  IF1OBJECT	*in[],*out[];	/* ARGSUSED */
  NodeInfo	info;
{
#define A	(0)
#define Out	(0)

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(IType(info)[A]) ) {
      BVal( out[Out] ) = ( ArrPS( in[0] )) ? FALSE: TRUE;
      BasErr( out[Out] ) = FALSE;
      SetDes( out[Out], OType(info)[Out] );
  } else {
    Oops("Streams not implemented for AIsEmpty");
  }

#undef A
#undef Out
}
/* ------------------------------------------------------------ */
void
AAddL(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define VAL	(1)
#define OutA	(0)

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(OType(info)[OutA]) ) {
    SetIsOK(out[OutA],	ArrIsOK(in[A]));
    if (IsArrLBErr(in[A])) {
      SetLB(out[OutA],	TRUE,IntegerZero); /* [error: ] */
    } else {
      SetLB(out[OutA],	FALSE,LocalToInteger(SubLocal(ArrLB(in[A]),1)))
    }
    SetTS(out[OutA],	ArrTS(in[A])+1);
    SetPS(out[OutA],	ArrPS(in[A])+1);

    /* Fill the collection with the value and values from the array */
    ArrCol(out[OutA]) = CopyOfBag( ArrCol(in[A]), ArrayGrowthFactor, 
			  ArrView(in[A]), ArrPS(in[A]), ArrayGrowthFactor );
    Copy(PointerIntoBag(ArrCol(out[OutA]),ArrayGrowthFactor-1),in[VAL]);

    SetView(out[OutA],	ArrayGrowthFactor-1);

    /* Make sure the lower bound is {1: ...} for streams */
    if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

    SetDes(out[OutA],	OType(info)[OutA]);
  } else {
    Oops("Streams not implemented for AAddL");
  }

#undef A
#undef VAL
#undef OutA
}
/* ------------------------------------------------------------ */
void
AAddH(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define VAL	(1)
#define OutA	(0)

  IF1OBJECT	*objptr;
  unsigned	NextPos;

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(OType(info)[OutA]) ) {
    SetIsOK(out[OutA],	ArrIsOK(in[A]));
    SetLB(out[OutA],	IsArrLBErr(in[A]),ArrLB(in[A]));
    SetTS(out[OutA],	ArrTS(in[A])+1);
    if ( ArrIsOK(in[A]) && (ArrTS(in[A]) == ArrPS(in[A]))) {
      SetPS(out[OutA],	ArrPS(in[A])+1);

      NextPos = (ArrView(in[A])+ArrPS(in[A]));
      objptr = GetPointerIntoBag(ArrCol(in[A]),NextPos,TRUE);

      if ( IsEmptyObject(objptr) ){
	/* Can keep the same collection, but must mod the bag' */
	ArrCol(out[OutA])	= ArrCol(in[A]);
	ArrView(out[OutA])	= ArrView(in[A]);

	/* Make sure the lower bound is {1: ...} for streams */
	if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

	SetDes(out[OutA],	OType(info)[OutA]);

	Copy(objptr,in[VAL]);

      } else {
	ArrCol(out[OutA]) = CopyOfBag(ArrCol(in[A]),
				   ArrayGrowthFactor,
				   ArrView(in[A]),
				   ArrPS(in[A]),0);
	ArrView(out[OutA])	= 0;

	/* Make sure the lower bound is {1: ...} for streams */
	if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

	SetDes(out[OutA],	OType(info)[OutA]);

	Copy(PointerIntoBag(ArrCol(out[OutA]),ArrPS(in[A])),in[VAL]);
      }


    } else {
      /* Appending to an error array just extends the size */
      SetPS(out[OutA],	ArrPS(in[A]));
      SetCol(out[OutA],	ArrCol(in[A]));
      SetView(out[OutA],	ArrView(in[A]));

      /* Make sure the lower bound is {1: ...} for streams */
      if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

      SetDes(out[OutA],	OType(info)[OutA]);
    }

  } else {
    Oops("Streams not implemented for AAddH");
  }

#undef A
#undef VAL
#undef OutA
}
/* ------------------------------------------------------------ */
void
ARemL(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define OutA	(0)

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(OType(info)[OutA]) ) {
    if ( ArrTS(in[A]) > 0 ) {

      SetIsOK(out[OutA],	ArrIsOK(in[A]));
      SetLB(out[OutA],		IsArrLBErr(in[A]),
	    LocalToInteger(AddLocal(ArrLB(in[A]),1)));
      SetTS(out[OutA],		ArrTS(in[A])-1);
      SetPS(out[OutA],		ArrPS(in[A])-1);
      SetCol(out[OutA],		ArrCol(in[A]));
      SetView(out[OutA],	ArrView(in[A])+1);

      /* Make sure the lower bound is {1: ...} for streams */
      if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

      SetDes(out[OutA],		OType(info)[OutA]);

    } else {
      SetIsOK(out[OutA],	FALSE);
      SetLB(out[OutA],		TRUE,IntegerZero);
      SetTS(out[OutA],		0);
      SetPS(out[OutA],		(ArrPS(in[A]) > 0)
				  ?(ArrPS(in[A])-1)
				  :0);
      SetCol(out[OutA],		  ArrCol(in[A]));
      SetView(out[OutA],	ArrView(in[A])+1);

      /* Make sure the lower bound is {1: ...} for streams */
      if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

      SetDes(out[OutA],		OType(info)[OutA]);
    }

  } else {
    Oops("Streams not implemented for ARemL");
  }
#undef A
#undef OutA
}
/* ------------------------------------------------------------ */
void
ARemH(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define OutA	(0)

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(OType(info)[OutA]) ) {
    if ( ArrTS(in[A]) > 0 ) {

      SetIsOK(out[OutA],	ArrIsOK(in[A]));
      SetLB(out[OutA],		IsArrLBErr(in[A]),ArrLB(in[A]));
      SetTS(out[OutA],		ArrTS(in[A])-1);
      SetPS(out[OutA],		(ArrTS(in[A]) > ArrPS(in[A]))
				  ?(ArrPS(in[A]))
				    :( (ArrPS(in[A]) > 0)
				      ?(ArrPS(in[A])-1)
				        :0));
      SetCol(out[OutA],			ArrCol(in[A]));
      SetView(out[OutA],	ArrView(in[A]));

      /* Make sure the lower bound is {1: ...} for streams */
      if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

      SetDes(out[OutA],		OType(info)[OutA]);
    } else {
      SetIsOK(out[OutA],	FALSE);
      SetLB(out[OutA],		TRUE,IntegerZero);
      SetTS(out[OutA],		0);
      SetPS(out[OutA],		0);
      SetCol(out[OutA],		ArrCol(in[A]));
      SetView(out[OutA],	ArrView(in[A]));

      /* Make sure the lower bound is {1: ...} for streams */
      if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

      SetDes(out[OutA],		OType(info)[OutA]);
    }

  } else {
    Oops("Streams not implemented for ARemH");
  }
#undef A
#undef OutA
}
/* ------------------------------------------------------------ */
void
ASetL(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define LB	(1)
#define OutA	(0)

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(OType(info)[OutA]) ) {

    CreateArray(out[OutA],OType(info)[OutA],
		ArrIsOK(in[A]),
		BasErr(in[LB]),IVal(in[LB]),
		ArrTS(in[A]),
		ArrPS(in[A]),
		ArrCol(in[A]),
		ArrView(in[A])
		);

  } else {
    Oops("Streams not implemented for ASetL");
  }
#undef A
#undef LB
#undef OutA
}
/* ------------------------------------------------------------ */
void
AExtract(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define LO	(1)
#define HI	(2)
#define OutA	(0)

  int		Spread,i,low,high,lowerbound,upperbound;
  unsigned	Pos;
  IF1OBJECT	Err,*oldptr,*newptr;
  TypeD		ElementType;

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(OType(info)[OutA]) ) {
    /* Four cases...
     **
     ** 1. low,high, or lowerbound is an error		| Error Array
     ** 2. high < low					| Empty Array
     ** 3. low < lowerbound OR high >= lowerbound+prefixsize | New array
     ** 4. low in range					| Do in place
     */

    if ( IsArrLBErr(in[A]) || BasErr(in[LO]) || BasErr(in[HI]) ) {
      /* Case 1 */
      /*     Some value is an error, create an error array */
      MakeError(out[OutA],OType(info)[OutA]);

    } else {
      low	= IntegerToLocal(IVal(in[LO]));
      high	= IntegerToLocal(IVal(in[HI]));
      lowerbound = IntegerToLocal(ArrLB(in[A]));
      upperbound = lowerbound+ArrPS(in[A])-1;

      if ( high < low ) {
	/* Case 2 */
	/* Create an empty array */
	Spread			= high-low+1;
	SetIsOK(out[OutA],	TRUE);
	SetLB(out[OutA],	FALSE,LocalToInteger(low));
	SetTS(out[OutA],	0);
	SetPS(out[OutA],	0);
	SetCol(out[OutA],	EmptyBag(ArrayInitialSize));
	SetView(out[OutA],	0);

	/* Make sure the lower bound is {1: ...} for streams */
	if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

	SetDes(out[OutA],	OType(info)[OutA]);

      } else if ( low < lowerbound || high > upperbound ) {
	/* Case 3 */
	/*     Values outside original array bounds */

	ElementType = ElementTypeOfArray(IType(info)[0]);
	MakeError(&Err,ElementType);

	Spread			= high - low + 1;
	SetIsOK(out[OutA],	TRUE);
	SetLB(out[OutA],	FALSE,LocalToInteger(low));
	SetTS(out[OutA],	Spread);
	SetPS(out[OutA],	Spread);
	SetCol(out[OutA],	EmptyBag(ArrayInitialSize));
	SetView(out[OutA],	0);

	/* Make sure the lower bound is {1: ...} for streams */
	if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

	SetDes(out[OutA],	OType(info)[OutA]);

	/* Copy in prefixing error values */
	Pos = 0;
	for(i=low;i<lowerbound && i<=high;i++) {
	  newptr = GetPointerIntoBag(ArrCol(out[OutA]),Pos++,TRUE);
	  Copy(newptr,&Err);
	}

	/* Copy in values from old array */
	for(i=(low>lowerbound)?low:lowerbound;i<=upperbound && i<=high;i++) {
	  oldptr = GetPointerIntoBag(ArrCol(in[A]),BagPos(i,in[A]),FALSE);
	  newptr = GetPointerIntoBag(ArrCol(out[OutA]),Pos++,TRUE);
	  Copy(newptr,oldptr);
	}

	/* Copy in suffixing error values */
	for(i=upperbound+1; i <= high ; i++) {
	  newptr = GetPointerIntoBag(ArrCol(out[OutA]),Pos++,TRUE);
	  Copy(newptr,&Err);
	}
      } else {
	/* Case 4 */

	Spread = high - low + 1;
	SetIsOK(out[OutA],	TRUE);
	SetLB(out[OutA],	FALSE,LocalToInteger(low));
	SetTS(out[OutA],	Spread);
	SetPS(out[OutA],	Spread);
	SetCol(out[OutA],	ArrCol(in[A]));
	SetView(out[OutA],	BagPos(IntegerToLocal(low),in[A]));

	/* Make sure the lower bound is {1: ...} for streams */
	if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

	SetDes(out[OutA],	OType(info)[OutA]);
      }
    }
  } else {
    Oops("Streams not implemented for AExtract");
  }
#undef A
#undef LO
#undef HI
#undef OutA
}

/* ------------------------------------------------------------ */
void
ACatenate(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define A	(0)
#define OutA	(0)
  int		CatCount;
  int		GoodCatCount;
  int		CatPS;
  int		CatTS;
  unsigned	i;
  IF1OBJECT	*TheArray;
  unsigned	TheArrayPS;
  unsigned	TheArrayView;
  unsigned	ViewPos;
  BagPtr	Col;
  SisalBoolean	IsOK;

  NoWorkIfNoOutput();

  CatCount = INARITY(info);

  if ( ARRAYLIKE(OType(info)[OutA]) ) {
    CatPS	= 0;
    CatTS	= 0;
    GoodCatCount = 0;
    IsOK	= TRUE;
    for(i=0;i<CatCount;i++) {
      CatTS += ArrTS(in[A+i]);
      CatPS += ArrPS(in[A+i]);
      GoodCatCount++;
      if ( !ArrIsOK(in[A+i]) ) { IsOK = FALSE; break; }
    }
    for(i++;i<CatCount;i++) {
      CatTS += ArrTS(in[A+i]);
    }

    SetIsOK(out[OutA],	IsOK);
    SetLB(out[OutA],	IsArrLBErr(in[A+0]),ArrLB(in[A+0]));
    SetPS(out[OutA],	CatPS);
    SetTS(out[OutA],	CatTS);
    SetCol(out[OutA],	EmptyBag((unsigned)CatPS));
    SetView(out[OutA],	0);

    /* Make sure the lower bound is {1: ...} for streams */
    if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne); 

   SetDes(out[OutA],	OType(info)[OutA]);

    /* Copy over the good arrays (and prefix of first bad array) */
    ViewPos  = 0;
    Col	     = ArrCol(out[OutA]);
    for(i=0;i<GoodCatCount;i++) {
      TheArray = in[A+i];
      TheArrayPS = ArrPS(TheArray);
      TheArrayView = ArrView(TheArray);
      if (TheArrayPS) {
	FillFromBag(ArrCol(TheArray),Col,TheArrayView,ViewPos,TheArrayPS);
      }
      ViewPos += TheArrayPS;
    }
  } else {
    Oops("Streams not implemented for ACatenate");
  }
#undef A
#undef OutA
}
/* ------------------------------------------------------------ */
void
AReplace(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define		A	(0)
#define		Pos	(1)
#define		Val	(2)
#define		OutA	(0)
		
  IF1OBJECT	*Obj;
  unsigned	ChangeCount,SecondHalf,PreCount,PostCount,i;

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(OType(info)[OutA]) ) {
    ChangeCount = INARITY(info)-2;

    if (!BasErr(in[Pos]) &&
	!IsArrLBErr(in[A]) &&
	IGreatEqual(IVal(in[Pos]),ArrLB(in[A])) &&
	AddLocal(IVal(in[Pos]),ChangeCount) <= AddLocal(ArrLB(in[A]),(int)ArrPS(in[A]))
	){

	/* Make a new copy of the array without the selected value */

	SetIsOK(out[OutA],	ArrIsOK(in[A]));
	SetLB(out[OutA],	IsArrLBErr(in[A]),ArrLB(in[A]));
	SetPS(out[OutA],	ArrPS(in[A]));
	SetTS(out[OutA],	ArrTS(in[A]));
	SetCol(out[OutA],	EmptyBag((unsigned)ArrPS(in[A])));
	SetView(out[OutA],	0);

	PreCount  = IntegerToLocal(ISub(IVal(in[Pos]),ArrLB(in[A])));
	SecondHalf = PreCount+ChangeCount;
	PostCount = ArrPS(in[A])-PreCount-ChangeCount;

	if ( PreCount ) {
	  /* Must prepend the prefixing values */
	  FillFromBag(ArrCol(in[A]),ArrCol(out[OutA]),
		      ArrView(in[A]),0,
		      PreCount);
	}

	for (i=0;i<ChangeCount;i++) {
	  Obj = PointerIntoBag(ArrCol(out[OutA]),
			       BagPos(AddLocal(IVal(in[Pos]),i),out[OutA]));
	  Copy(Obj,in[Val+i]);
	}

	if ( PostCount ) {
	  /* Must append the suffixing values */
	  FillFromBag(ArrCol(in[A]),ArrCol(out[OutA]),
		      ArrView(in[A])+SecondHalf,SecondHalf,
		      PostCount);
	}

	/* Make sure the lower bound is {1: ...} for streams */
	if ( STREAMLIKE(OType(info)[OutA]) ) SetLB(out[OutA],FALSE,IntegerOne);

	SetDes(out[OutA],	OType(info)[OutA]);
    } else {
      MakeError(out[OutA],OType(info)[OutA]);
    }
  } else {
    Oops("Streams not implemented for AReplace");
  }

#undef		A
#undef		Pos
#undef		Val
#undef		OutA
}
/* ------------------------------------------------------------ */
void
AReplaceN(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define		A		(0)
#define		Lev		(1)
#define		FirstPos	(2)
#define		FirstVal	(FirstPos+Levels)
#define		OutA		(0)
		
  unsigned	ChangeCount,i;
  int		InAr = INARITY(info);
  int		Levels;
  int		Pos;
  IF1OBJECT	Ar[10];
  unsigned	Offsets[10];
  IF1OBJECT	ErrObj;
  IF1OBJECT	*ShortList[1];
  IF1OBJECT	**ReplaceList;
  IF1OBJECT	*P;

  NoWorkIfNoOutput();

  if ( ARRAYLIKE(OType(info)[OutA]) ) {
    /* First, see how many levels to do the replace on and how many */
    /* new values. */
    Levels = IVal(in[Lev]);
    if ( Levels > sizeof(Ar)/sizeof(Ar[0]) ) Oops("Too deep in AReplaceN");
    ChangeCount = InAr-Levels-2;
    ReplaceList = in+FirstVal;

    /* Get a list of the arrays involved.  If an array is out of */
    /* bounds, then do error processing and exit the loop. */
    for(Ar[0]=(*(in[A])),i=0; i<Levels; i++) {
      /* Make sure the initial position exists at this level */
      Pos = FirstPos+i;
      Offsets[i] = BagPos(IVal(in[Pos]),Ar+i);
      if ( BasErr(in[Pos]) ||
	  IsArrLBErr(Ar+i) ||
	  ILess(IVal(in[Pos]),ArrLB(Ar+i)) ||
	  /* Check room for only one change except at the last level */
	  AddLocal(IVal(in[Pos]),(i<(Levels-1))?(1):(ChangeCount)) >
	  AddLocal(ArrLB(Ar+i),(int)ArrPS(Ar+i))
	  ){

	/* Access error at level i, make an error element of the */
	/* proper type and include it at this level in the final */
	/* array. */
	Levels = i;
	ChangeCount = 1;
	MakeError(&ErrObj,TypeOf(Ar+i));
	ShortList[0] = &ErrObj;
	ReplaceList = ShortList;
      } else {
	Ar[i+1] = *PointerIntoBag(ArrCol(Ar+i),Offsets[i]);
      }
    }

    /* ------------------------------------------------------------ */
    /* If we've blown the first level, just throw away the entire */
    /* array and replace it with an error value. */
    if ( !Levels ) {
      /* Just throw away the entire array and copy the error value */
      /* from the Replace List into the output value */
      FCopy(out[OutA],ReplaceList[0],aARRAY);
    } else {
      /* ------------------------------------------------------------ */
      /* Make a complete copy of the array */
      ArrayCopy(Ar,Offsets,Levels);

      /* ------------------------------------------------------------ */
      /* Put the new values into their positions */
      for(i=0; i<ChangeCount; i++) {
	P = PointerIntoBag(ArrCol(Ar+Levels-1),
			   BagPos(AddLocal(IVal(in[FirstPos+Levels-1]),i),
				  Ar+Levels-1)
			   );

	/* Copy in new object */
	Copy(P,ReplaceList[i]);
      }

      /* Copy the input array over to the output */
      FCopy(out[OutA],Ar+0,aARRAY);
    }
  } else {
    Oops("Streams not implemented for AReplaceN");
  }

#undef		A
#undef		FirstPos
#undef		FirstVal
#undef		OutA
}
