#include "SC.h"
#include "SCLib.h"

extern BagPtr BagList;

/* ------------------------------------------------------------ */
void
CollectBags()
{
  BagPtr	B,Next,NewList;

  for(B=BagList, NewList = NULL; B; B=Next) {
    Next = B->NextInChain;
    if (!B->Ref) {
      DestroyBag(B);
    } else {
      B->Ref = 0;
      B->NextInChain = NewList;
      NewList = B;
    }
  }

  /* ------------------------------------------------------------ */
  /* Reset the bag list to the compressed list */
  BagList = NewList;
}

/* ------------------------------------------------------------ */
void
BagInUse(B)
     BagPtr	B;
{
  int		i;

  /* ------------------------------------------------------------ */
  /* Mark this bag as active */
  B->Ref = 1;

  /* ------------------------------------------------------------ */
  /* Mark any continuations of this bag as active too */
  for(i=0;i<BagFanout;i++) if ( B->Fanout[i] ) BagInUse(B->Fanout[i]);
}

/* ------------------------------------------------------------ */
void
MarkInUse(obj)
     IF1OBJECT	*obj;
{
  unsigned	i;

  switch( TypeEntryOf(TypeOf(obj)) ) {
   case IF1STREAM:
    if ( ! StrictStreams ) Oops("Cannot garbage collect strict streams"); 
   case IF1ARRAY:
    if ( ArrCol(obj) ) {
      BagInUse(ArrCol(obj));
      for(i=0;i<ArrPS(obj);i++) {
	MarkInUse(PointerIntoBag(ArrCol(obj),ArrView(obj)+i));
      }
    }
    break;

   case IF1MULTIPLE:
    if ( MultTag(obj) == BagMult ) {
      BagInUse(MultBag(obj));
      for(i=0;i<MultTrueSize(obj);i++) {
	MarkInUse(PointerIntoBag(MultBag(obj),MultView(obj)+i));
      }
    }
    break;

   case IF1RECORD:
    if ( RecCol(obj) ) {
      BagInUse(RecCol(obj));
      for(i=0;i<FieldCountOfRecord(TypeOf(obj));i++) {
	MarkInUse(PointerIntoBag(RecCol(obj),i));
      }
    }
    break;

   case IF1UNION:
    if ( UniVal(obj) ) {
      BagInUse(UniVal(obj));
      MarkInUse(PointerIntoBag(RecCol(obj),0));
    }
    break;

   case IF1EMPTY:
   case IF1BASIC:
    break;
	
   default:
    Oops("BadType in Garbage collection");
  }
}

/* ------------------------------------------------------------ */
void
GarbageCollect()
{
  Environment		*T;
  int			i;

  for(T=TopOfEnvironmentStack();T;T= T->Next) {
    for(i=0;i<T->VARCOUNT;i++) {
      MarkInUse(T->VARS+i);
    }
  }

  CollectBags();
}
