#include "SC.h"
#include "SCLib.h"

void
RangeGenerate(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
#define LOW	(0)
#define HIGH	(1) 
#define M	(0)

  SisalInteger		LO,HI;
  int			Size;
  IF1OBJECT		*Mult;

  NoWorkIfNoOutput();

  Mult = out[M];

  if (BasErr(in[LOW]) || BasErr(in[HIGH])) {
    MultError(Mult)		= TRUE;
    MultSize(Mult)		= 0;
    sBasErr(MultLow(Mult))	= BasErr(in[LOW]); 
    sIVal(MultLow(Mult))	= IVal(in[LOW]);
  } else {
    LO				= IVal(in[LOW]);
    HI				= IVal(in[HIGH]);

    Size			= ILess(HI,LO)?(0):AddLocal(ISub(HI,LO),1);

    MultError(Mult)		= FALSE;
    MultSize(Mult)		= Size;
    MultTrueSize(Mult)		= Size;
    sBasErr(MultLow(Mult))	= FALSE;
    sIVal(MultLow(Mult))	= LO;
  }

  MultTag(Mult)			= GenMult;
  SetDes(Mult,			OType(info)[M]);

#undef LO
#undef HI
#undef M
}
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
void
AScatter(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
#define A	(0)
#define M	(0)
#define IDX	(1)

  BagPtr		B;
  IF1OBJECT		*Array,*Mult,*Index;

  if ( ARRAYLIKE(IType(info)[0]) ) {
    Array = in[A];
    Mult = out[M];
    Index = out[IDX];

    if (Mult) {
      B = ArrCol(Array);
      MultTag(Mult)		= BagMult;

      MultError(Mult)		= (SisalBoolean)(! ArrIsOK(Array) );
      MultSize(Mult)		= ArrPS(Array);
      MultTrueSize(Mult)	= ArrTS(Array);
      sBasErr(MultLow(Mult))	= IsArrLBErr(Array);
      sIVal(MultLow(Mult))	= ArrLB(Array);

      MultView(Mult)		= ArrView(Array);
      MultBag(Mult)		= B;

      SetDes(Mult,		OType(info)[M]);
    }

    if (Index) {

      MultTag(Index)	= GenMult;

      if (IsArrLBErr(Array)) {
	MultError(Index)	= TRUE;
	MultSize(Index)		= 0;
	sBasErr(MultLow(Mult))	= TRUE;
	sIVal(MultLow(Mult))	= IntegerZero;
      } else {
	MultError(Index)	= FALSE;
	MultSize(Index)		= ArrPS(Array);
	MultTrueSize(Index)	= ArrTS(Array);
	sBasErr(MultLow(Index))	= FALSE; 
	sIVal(MultLow(Index))	= ArrLB(Array);
      }
      SetDes(Index,	OType(info)[IDX]);
    }

  } else {
    Oops("Strict Streams not implemented for AScatter");
  }
#undef A
#undef M
#undef IDX
}
