#include "SC.h"
#include "SCLib.h"

typedef int	IntPair[2];

static IntPair		*OpCodeCount;
static SisalBoolean	ProfileOpcodes;
/* ------------------------------------------------------------ */
static Parameter	HookParms[] = {
  {"-prof",ToggleParm,ParmAddr(ProfileOpcodes),ParmAddr(ParmFalse),NULL,
     "Profile op code execution counts"},

  {NULL, StringParm, NULL, NULL, NULL}
};

/* ------------------------------------------------------------ */
static int
TypeCompatable(A,B)
     TypeD	A,B;
{
  int		i;

  /* We have it easy if we are sending to a null entry or if the types */
  /* are equivalent or if we have an empty value for a multiple. */
  if ( !B ||
      A == B ||
      TypeEntryOf(A) == IF1EMPTY && TypeEntryOf(B) == IF1MULTIPLE
      ) return 1;

  /* Another easy thing is if the TypeEntries are incompatable */
  if ( TypeEntryOf(A) != TypeEntryOf(B) ) return 0;

  /* Make sure the sub-types are compatable too */
  switch( TypeEntryOf(A) ) {
   case IF1ARRAY:
    return TypeCompatable(ElementTypeOfArray(A),ElementTypeOfArray(B));

   case IF1STREAM:
    return TypeCompatable(ElementTypeOfStream(A),ElementTypeOfStream(B));

   case IF1MULTIPLE:
    return TypeCompatable(ElementTypeOfMultiple(A),ElementTypeOfMultiple(B));

   case IF1RECORD:
    if ( FieldCountOfRecord(A) != FieldCountOfRecord(B) ) return 0;
    for(i=0;i<FieldCountOfRecord(A);i++) {
      if (!TypeCompatable(FieldTypesOfRecord(A)[i],FieldTypesOfRecord(B)[i])) {
	return 0;
      }
    }
    return 1;

   case IF1UNION:
    if ( TagCountOfUnion(A) != TagCountOfUnion(B) ) return 0;
    for(i=0;i<TagCountOfUnion(A);i++) {
      if (!TypeCompatable(TagTypesOfUnion(A)[i],TagTypesOfUnion(B)[i])) {
	return 0;
      }
    }
    return 1;

   case IF1BASIC:
    return ( KindOfBasic(A) == KindOfBasic(B) );

   default:
    ;
  }

  /* For now that's good enough */
  return 1;
}

void
SanityHook(VList,TList,n)
     IF1OBJECT		*VList[];
     TypeD		TList[];
     int		n;
{
  int		i;
  char		msg[128];
  TypeD		TV,TT;		/* ARGSUSED */

  if ( TList ) {
    for(i=0;i<n;i++) {
      if ( VList[i] && !IsEmptyObject(VList[i])) {
	TV = TypeOf(VList[i]);
	TT = TList[i];

	/* Make sure type information jives */
	if ( !TypeCompatable(TypeOf(VList[i]),TList[i]) ) {
	  (void)sprintf(msg,"Type incompatablity Error on edge %d @ 0x%x= %d"
			,i+1,VList[i],VList[i]);
	  Oops(msg);
	}

	/* Make sure it really is that type */
	if ( TList[i] && !IsItReally(VList[i],TList[i]) ) {
	  (void)sprintf(msg,"Type/value mismatch on edge %d @ 0x%x= %d"
			,i+1,VList[i],VList[i]);
	  Oops(msg);
	}
      }
    }
  }
}

/* ------------------------------------------------------------ */
int
IsItReally(obj,T)
     IF1OBJECT	*obj;
     TypeD	T;
{
  TypeD		ET;
  IF1OBJECT	*El;
  unsigned	i;

  switch( TypeEntryOf(T) ) {
   case IF1ARRAY:
    if ( ArrCol(obj) ) {
      ET = ElementTypeOfArray(T);
      for(i=0;i<ArrPS(obj);i++) {
	El = PointerIntoBag(ArrCol(obj),ArrView(obj)+i);
	if ( !IsItReally(El,ET) ) {
	  return 0;
	}
      }
    }
    break;

   case IF1RECORD:
    if ( RecCol(obj) ) {
      for(i=0;i<FieldCountOfRecord(T);i++) {
	El = PointerIntoBag(RecCol(obj),i);
	if ( !IsItReally(El,FieldTypesOfRecord(T)[i]) ) {
	  return 0;
	}
      }
    }
    break;

   default:
    ;
  }
  return 1;
}

void
PreStartHook()
{
  int		i;

  PACKAGE_HOOK(PackagePreStart);

  InsertParmList(HookParms,ParmList);

  /* Make a table to count references to operations */
  OpCodeCount = CAllocate(OpListSize,IntPair);
  for(i=0;i<OpListSize;i++) {
    OpCodeCount[i][0] = 0;
    OpCodeCount[i][1] = 0;
  }
}

void
PreNodeHook(NodeNum,OpCode,in,out,info)	/* ARGSUSED */
     int		NodeNum;
     int		OpCode;
     IF1OBJECT		*in[];
     IF1OBJECT		*out[];
     NodeInfo		info;
{
  PACKAGE_HOOK(PackagePreNode);

  if (ProfileOpcodes) {
    OpCodeCount[OpCode][0]++;
  }
}

void
PostNodeHook(NodeNum,OpCode,in,out,info) /* ARGSUSED */
     int		NodeNum;
     int		OpCode;
     IF1OBJECT		*in[];
     IF1OBJECT		*out[];
     NodeInfo		info;
{
  PACKAGE_HOOK(PackagePostNode);
}

void
GraphHook(code,name,in,out,info) /* ARGSUSED */
     Function	code;
     char	*name;
     IF1OBJECT	*in[],*out[];
     NodeInfo	info;
     
{
  PACKAGE_HOOK(PackageGraph);
}

void
EndGraphHook(code,name,in,out,info) /* ARGSUSED */
     Function	code;
     char	*name;
     IF1OBJECT	*in[],*out[];
     NodeInfo	info;
     
{
  PACKAGE_HOOK(PackageEndGraph);
}

void
StartHook(ParmList,argc,argv)	/* ARGSUSED */
     Parameter	ParmList[];
     int	argc;
     char	*argv[];
{
  PACKAGE_HOOK(PackageStart);
}

void
ErrorHook()
{
  PACKAGE_HOOK(PackageError);

}

void
CopyHook(Count)			/* ARGSUSED */
     unsigned	Count;
{
}

void
ForallHook(info,in,iteration,iterationcount) /* ARGSUSED */
     NodeInfo	info;
     IF1OBJECT	*in[];
     unsigned	iteration;
     unsigned	iterationcount;
{
  PACKAGE_HOOK(PackageForall);
}

void
FunctionHook(in,out,info)	/* ARGSUSED */
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  PACKAGE_HOOK(PackageFunction);
}

/* ------------------------------------------------------------ */
void
CompleteHook()
{
  int		i;
  char		comline[MaxCommentSize];

  PACKAGE_HOOK(PackageComplete);

 if (ProfileOpcodes) {
   for(i=0;i<OpListSize;i++) {
     if (OpCodeCount[i][0] || OpCodeCount[i][1]) {
       (void)sprintf(comline,"%s:%s\t%d\t%d",
	       OpList[i].Name,
	       (strlen(OpList[i].Name) < 5)?"\t":"",
	       OpCodeCount[i][0],
	       OpCodeCount[i][1]);
       OutputComment(comline);
     }
   }
 }
}
