#include "SC.h"
#include "SCLib.h"

#ifdef ALLDEBUG
#  define LOCALDEBUG	(1)
#else
#  define LOCALDEBUG	(0)
#endif

void
Iter(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
  NodeInfo	BodyGraphInfo;
  NodeStuff	IterInfo;
  unsigned	GraphArity;
  IF1OBJECT	*Locals[EntryMax];
  IF1OBJECT	LocalValues[EntryMax];
  IF1OBJECT	**PointerVector;
  IF1OBJECT	*ValueVector;
  IF1OBJECT	**TIN,**TOUT,**THold;
  unsigned	i;
  unsigned	InAr;
  unsigned	OutAr;
  Function	BodyCode;
  char		*BodyName;
  int		Iteration;

			
#define FLAG		(0)

  /* ------------------------------------------------------------ */
  /* Save some shared quanities directly to aid optimization */
  InAr		= INARITY(info);
  OutAr		= OUTARITY(info);

  /* ------------------------------------------------------------ */
  /* If the FLAG value is error, just copy inputs to outputs */
  if ( BasErr(in[FLAG]) ) {
    SetToError(out,OType(info),OutAr);

  } else if ( ! BVal(in[FLAG]) ) {
    /* ------------------------------------------------------------ */
    /* If the loop is a zero trip loop, simply copy inputs to outputs */
    CopyVector(out,in,OutAr,InAr);

  } else {
    /* ------------------------------------------------------------ */
    /* For a multi-pass execution, the execution is as follows. */
    /*    1: Increment the inputs to save values across executions. */
    /*    2: Execute the body into a temporary set of outputs. */
    /*	  3: While the FLAG is true, move the outputs to inputs, */
    /*	     merge the original inputs back into the vector incrementing */
    /*	     the ref count by 1 for the new iteration, execute the body */
    /*	     back into the outputs. */
    /*	  4: If the FLAG is an error, mark the outputs as errors */
    /*	  5: Consume the temp ref count on the original inputs */
    /*	  6: Move the temporary outputs to the outputs  */
    /* ------------------------------------------------------------ */
    /* 0. Build up some temporary structures */
    BodyGraphInfo = ChildrenOf(info)[0];
    BodyCode	  = GraphCodeOf(BodyGraphInfo);
    BodyName	  = GraphNameOf(BodyGraphInfo);


    BuildNodeInfo(&IterInfo,OutAr,InAr,OType(info),IType(info));

    GraphArity = INARITY(BodyGraphInfo);

    /* Build vectors to hold temporary iter values */
    if ( GraphArity*2 < EntryMax ) {
      PointerVector = Locals;
      ValueVector = LocalValues;
    } else {
      PointerVector = CAllocate(GraphArity*2,IF1OBJECT*);
      ValueVector   = CAllocate(GraphArity*2,IF1OBJECT);
    }

    TIN		= PointerVector;
    TOUT	= PointerVector+GraphArity;
    for(i=0;i<GraphArity;i++) {
      PointerVector[i]			= ValueVector+i;
      PointerVector[i+GraphArity]	= ValueVector+GraphArity+i;
    }
    EmptyVector(PointerVector,GraphArity*2);
    PushEnv("Iter",info,in,out,ValueVector,(unsigned)(GraphArity*2),0);

    /* ------------------------------------------------------------ */
    /* 2. First pass ... */
    ExecGraph(BodyCode,BodyName,in,TOUT,&IterInfo);

    /* ------------------------------------------------------------ */
    /* 3. While FLAG is true, execute the body */
    for(Iteration=0; (!BasErr(TOUT[FLAG])) && BVal(TOUT[FLAG]); Iteration++) {
      if ( InfiniteLoopCount && Iteration > InfiniteLoopCount ) {
#if Debugger
	InfiniteLoopFlag = TRUE;
#else
	Oops("In an infinite loop");
#endif
      }

      /* Move outputs to inputs */
      THold = TIN; TIN = TOUT; TOUT = THold;

      MergeVector(TIN,in,GraphArity,InAr);

      ExecGraph(BodyCode,BodyName,TIN,TOUT,&IterInfo);
    }

    /* ------------------------------------------------------------ */
    /* 4. Mark the outputs as errors if FLAG=error[boolean] */
    if ( BasErr(TOUT[FLAG]) ) {
      SetToError(out,OType(info),OutAr);
    } else {
      /* ------------------------------------------------------------ */
      /* Copy the temporary vector to the final vector */
      CopyVector(out,TOUT,OutAr,GraphArity);
    }

    /* ------------------------------------------------------------ */
    /* 99. Clean up allocated values */
    PopEnv();
    if (PointerVector != Locals) {
      Free(PointerVector);
      Free(ValueVector);
    }
  }

#undef FLAG
}

