#include "SC.h"
#include "SCLib.h"

int
ParseCharToken(Ptr,Token)
     char	**Ptr;
     char	*Token;
{
  int		len;

  /* If no characters follow, then no more tokens */
  if ( !**Ptr ) return 0;

  len = 0;
  switch( **Ptr ) {
   case '\\':			/* Escape */
    Token[len++] = *((*Ptr)++);	/* Collect the backslash */
    if (isodigit(**Ptr)) {
      /* Octal escape */
      do {
	Token[len++] = *((*Ptr)++);
      } while ( len < 4 && isodigit(**Ptr) );
    } else {
      /* Character escape */
      Token[len++] = *((*Ptr)++);
    }
    break;

   default:
    Token[len++] = *((*Ptr)++);
  }

  Token[len] = '\0';
  return 1;
}

void
InitString(T,Val,Obj)
     TypeD	T;
     char	*Val;
     IF1OBJECT	*Obj;
{
  unsigned	elements;
  char		Token[10];
  char		*ParsePtr;
  BagPtr	Collection;
  SisalCharacter  C;
  IF1OBJECT	*El;

  for(elements=0,ParsePtr=Val; ParseCharToken(&ParsePtr,Token); elements++);

  /* Ready a collection for the number of strings (plus 1 more) */
  Collection = EmptyBag(elements+1);

  /* Get an element and convert it to a SisalCharacter then to IF1OBJECT */
  for(elements=0,ParsePtr=Val; ParseCharToken(&ParsePtr,Token); elements++){
    StringToCharacter(Token,&C);
    El = PointerIntoBag(Collection,elements);

    CVal(El) = C;
    BasErr(El) = FALSE;
    SetDes(El,CharacterTypeD);
  }

  /* Append another object to the end of the collection so that no */
  /* update in place operations will try to extend the collection. */
  El = PointerIntoBag(Collection,elements);
  StringToCharacter("\\000",&C);
  CVal(El) = C;
  BasErr(El) = FALSE;
  SetDes(El,CharacterTypeD);

  CreateArray(Obj,T,TRUE,FALSE,IntegerOne,elements,elements,Collection,0);
}

void
InitBasicLiteral(T,Val,Obj)
     TypeD	T;
     char	*Val;
     IF1OBJECT	*Obj;
{
  switch ( KindOfBasic(T) ) {
   case IF1Boolean:	StringToBoolean(Val,&BVal(Obj)); break;
   case IF1Character:	StringToCharacter(Val,&CVal(Obj)); break;
   case IF1Double:	StringToDouble(Val,&DVal(Obj)); break;
   case IF1Integer:	StringToInteger(Val,&IVal(Obj)); break;
   case IF1Null:	break;
   case IF1Real:	StringToReal(Val,&RVal(Obj)); break;
   default:
    Oops("Can't do this basic");
  }
  BasErr(Obj) = FALSE;
  SetDes(Obj,T);
}
void
InitFunctionLiteral(Mod,T,Val,Obj)
     NodeInfo	Mod;
     TypeD	T;
     char	*Val;
     IF1OBJECT	*Obj;
{
  NodeInfo	F;

  /* Search for the graph code */
  F = FindGraph(Val,Mod,FALSE);

  /* If we haven't found it, it must be a special function */
  if ( !F ) Oops("No such function or must search right module");

  FunName(Obj) = Val;
  FunCode(Obj) = GraphCodeOf(F);
  SetDes(Obj,T);
}

void
InitializeLiteral(Mod,T,Val,Obj)
     NodeInfo	Mod;
     TypeD	T;
     char	*Val;
     IF1OBJECT	*Obj;
{
  /* If the value is ERROR, create an error value */
  if ( strcmp(Val,"ERROR") == 0 ) {
    MakeError(Obj,T);
  } else {
    /* The literal must either be a basic type, a string, or a function */
    switch( TypeEntryOf(T) ) {
     case IF1ARRAY: InitString(T,Val,Obj);
      break;

     case IF1BASIC: InitBasicLiteral(T,Val,Obj);
      break;

     case IF1FUNCTION: InitFunctionLiteral(Mod,T,Val,Obj);
      break;

     default:
      Oops("Invalid literal");
      break;
    }
  }
}

void
InitializeLiteralPools()
{
  int		NT;
  int		i;

  for(NT=0;Linkage[NT];NT++) {
    for(i=0;i<ModuleLiteralCountOf(Linkage[NT]);i++) {
      InitializeLiteral(Linkage[NT],
			ModuleLiterals(Linkage[NT])[i].LiteralType,
			ModuleLiterals(Linkage[NT])[i].LiteralValue,
			&ModuleLiterals(Linkage[NT])[i].Value);
    }
  }

  /* ------------------------------------------------------------ */
  /* Clear the bag list so that any storage allocated for these values */
  /* is persistent. */
  BagList = NULL;
}
