#include "SC.h"
#include "SCLib.h"

static void
Arith1Op(in,out,info,boolval,DOP,IOP,ROP)
     IF1OBJECT		*in[];
     IF1OBJECT		*out[];
     NodeInfo		info;
     SisalBoolean	*boolval;
     Function	DOP;
     Function	IOP;
     Function	ROP;
{
  SisalBoolean		val;

  IF1OBJECT	*A,*RES;
  A		= in[0];
  RES		= out[0];

  NoWorkIfNoOutput();

  switch(KindOfBasic(IType(info)[0])) {
    case IF1Boolean:
      if (!boolval) Oops("Attempting undefined boolean operation");
      val		= boolval[(BasErr(A))?((int)UNDEF):((int)BVal(A))];

      BasErr(RES)	= (SisalBoolean)(val == UNDEF);
      BVal(RES)	= val;
      break;

    case IF1Double:
      if ( BasErr(A) ) {
	BasErr(RES)		= TRUE;
      } else {
	DOP(DVal(A),&DVal(RES),&BasErr(RES));
      }
      break;

    case IF1Integer:
      if ( BasErr(A) ) {
	BasErr(RES)		= TRUE;
      } else {
	IOP(IVal(A),&IVal(RES),&BasErr(RES));
      }
      break;

    case IF1Real:
      if ( BasErr(A) ) {
	BasErr(RES) = TRUE;
      } else {
	ROP(RVal(A),&RVal(RES),&BasErr(RES));
      }
      break;

    default:
      Oops("Undefined type in Op1");
  }

  /* Release the output value */
  SetDes(RES,OType(info)[0]);
}

static void
Arith2Op(in,out,info,boolval,DOP,IOP,ROP)
     IF1OBJECT		*in[];
     IF1OBJECT		*out[];
     NodeInfo		info;
     SisalBoolean	*boolval;
     Function	DOP;
     Function	IOP;
     Function	ROP;
{
  SisalBoolean		val;

  IF1OBJECT	*A,*B,*RES;
  A		= in[0];
  B		= in[1];
  RES		= out[0];

  NoWorkIfNoOutput();
  switch(KindOfBasic(IType(info)[0])) {
    case IF1Boolean:
      if (!boolval) Oops("Attempting undefined boolean operation");
      val		= boolval[3*((BasErr(A)) ? (int) UNDEF : ((int)BVal(A)))
				  +((BasErr(B)) ? (int) UNDEF : ((int)BVal(B)))];
      BasErr(RES)	= (SisalBoolean)(val == UNDEF);
      BVal(RES)	= val;
      break;

    case IF1Double:
      if ( BasErr(A) || BasErr(B) ) {
	BasErr(RES)		= TRUE;
      } else {
	DOP(DVal(A),DVal(B),&DVal(RES),&BasErr(RES));
      }
      break;

    case IF1Integer:
      if ( BasErr(A) || BasErr(B) ) {
	BasErr(RES)		= TRUE;
      } else {
	IOP(IVal(A),IVal(B),&IVal(RES),&BasErr(RES));
      }
      break;

    case IF1Real:
      if (BasErr(A) || BasErr(B) ) {
	BasErr(RES) = TRUE;
      } else {
	ROP(RVal(A),RVal(B),&RVal(RES),&BasErr(RES));
      }
      break;

    default:
      Oops("Undefined type in Op");
  }


  /* Release the output value */
  SetDes(RES,OType(info)[0]);
}

static void
Arith3Op(in,out,info,boolval,COP,DOP,IOP,ROP)
     IF1OBJECT		*in[];
     IF1OBJECT		*out[];
     NodeInfo		info;
     SisalBoolean	*boolval;
     Function	COP;
     Function	DOP;
     Function	IOP;
     Function	ROP;
{
  IF1OBJECT	*A,*B,*RES;
  A		= in[0];
  B		= in[1];
  RES		= out[0];

  NoWorkIfNoOutput();

  if (BasErr(A) || BasErr(B)) {
    /* Create an error boolean */
    BasErr(RES)	= TRUE;
    BVal(RES)	= UNDEF;
  } else {
    /* Output is never in error */
    BasErr(RES)	= FALSE;

    switch(KindOfBasic(IType(info)[0])) {
      case IF1Boolean:
      if (!boolval) Oops("Attempting undefined boolean operation");
      BVal(RES) = boolval[2*((int)BVal(A))+((int)BVal(B))];
      break;

      case IF1Character:
      COP(CVal(A),CVal(B),&BVal(RES));
      break;

      case IF1Double:
      DOP(DVal(A),DVal(B),&BVal(RES));
      break;

      case IF1Integer:
      IOP(IVal(A),IVal(B),&BVal(RES));
      break;

      case IF1Real:
      ROP(RVal(A),RVal(B),&BVal(RES));
      break;

      default:
      Oops("Undefined type in Op");
    }
  }

  /* Release the output value (always a boolean) */
  SetDes(RES,BooleanTypeD);
}
/* ------------------------------------------------------------ */
void
Plus(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  /* Plus is boolean OR */
  static SisalBoolean BoolVal[9] = {
    /*	F	T	E  */
/*F*/	FALSE,	TRUE,	UNDEF,
/*T*/	TRUE,	TRUE,	TRUE,
/*E*/	UNDEF,	TRUE,	UNDEF
  };

  Arith2Op(in,out,info,BoolVal,DoublePlus,IntegerPlus,RealPlus);
}

void
Times(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  /* Srith2Times is boolean AND */
  static SisalBoolean BoolVal[9] = {
    /*	F	T	E  */
/*F*/	FALSE,	FALSE,	FALSE,
/*T*/	FALSE,	TRUE,	UNDEF,
/*E*/	FALSE,	UNDEF,	UNDEF
  };

  Arith2Op(in,out,info,BoolVal,DoubleTimes,IntegerTimes,RealTimes);
}

void
Min(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  /* Min is boolean AND */
  static SisalBoolean BoolVal[9] = {
    /*	F	T	E  */
/*F*/	FALSE,	FALSE,	FALSE,
/*T*/	FALSE,	TRUE,	UNDEF,
/*E*/	FALSE,	UNDEF,	UNDEF
  };

  Arith2Op(in,out,info,BoolVal,DoubleMin,IntegerMin,RealMin);
}

void
Max(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  /* Max is boolean OR */
  static SisalBoolean BoolVal[9] = {
    /*	F	T	E  */
/*F*/	FALSE,	TRUE,	UNDEF,
/*T*/	TRUE,	TRUE,	TRUE,
/*E*/	UNDEF,	TRUE,	UNDEF
  };

  Arith2Op(in,out,info,BoolVal,DoubleMax,IntegerMax,RealMax);
}
/* ------------------------------------------------------------ */
void
Minus(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  Arith2Op(in,out,info,
	  (SisalBoolean*)NULL,DoubleMinus,IntegerMinus,RealMinus);
}

void
Div(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  Arith2Op(in,out,info,(SisalBoolean*)NULL,DoubleDiv,IntegerDiv,RealDiv);
}

void
Mod(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  Arith2Op(in,out,info,
	   (SisalBoolean*)NULL,
	   (Function)NULL,
	   IntegerMod,
	   (Function)NULL);
}
/* ------------------------------------------------------------ */
void
Exp(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  IF1OBJECT	*A,*B,*RES;
  A		= in[0];
  B		= in[1];
  RES		= out[0];

  NoWorkIfNoOutput();

  if (BasErr(A) || BasErr(B)) {
    BasErr(RES) = TRUE;
  } else {
    switch(KindOfBasic(IType(info)[0])) {
      case IF1Double:
      switch(KindOfBasic(IType(info)[1])) {
	case IF1Double:
	DoubleDoubleExp(DVal(A),DVal(B),&DVal(RES),&BasErr(RES));
	break;

	case IF1Integer:
	DoubleIntegerExp(DVal(A),IVal(B),&DVal(RES),&BasErr(RES));
	break;

	case IF1Real:
	DoubleRealExp(DVal(A),RVal(B),&DVal(RES),&BasErr(RES));
	break;
      }
      break;

      case IF1Integer:
      switch(KindOfBasic(IType(info)[1])) {
	case IF1Double:
	IntegerDoubleExp(IVal(A),DVal(B),&DVal(RES),&BasErr(RES));
	break;

	case IF1Integer:
	IntegerIntegerExp(IVal(A),IVal(B),&RVal(RES),&BasErr(RES));
	break;

	case IF1Real:
	IntegerRealExp(IVal(A),RVal(B),&RVal(RES),&BasErr(RES));
	break;
      }
      break;

      case IF1Real:
      switch(KindOfBasic(IType(info)[1])) {
	case IF1Double:
	RealDoubleExp(RVal(A),DVal(B),&DVal(RES),&BasErr(RES));
	break;

	case IF1Integer:
	RealIntegerExp(RVal(A),IVal(B),&RVal(RES),&BasErr(RES));
	break;

	case IF1Real:
	RealRealExp(RVal(A),RVal(B),&RVal(RES),&BasErr(RES));
	break;
      }
    }
  }

  /* Set the indicated output type */
  SetDes(RES,OType(info)[0]);
}
/* ------------------------------------------------------------ */
void
Abs(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  Arith1Op(in,out,info,
	   (SisalBoolean*)NULL,
	   DoubleAbs,
	   IntegerAbs,
	   RealAbs);
}

void
Neg(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  Arith1Op(in,out,info,
	   (SisalBoolean*)NULL,
	   DoubleNeg,
	   IntegerNeg,
	   RealNeg);
}
/* ------------------------------------------------------------ */
void
Not(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  static SisalBoolean BoolVal[3] = {
    /* F     T     E */
       TRUE, FALSE,UNDEF
  };

  Arith1Op(in,out,info,
	   BoolVal,
	   (Function)NULL,
	   (Function)NULL,

	   (Function)NULL);
}
/* ------------------------------------------------------------ */
void
Less(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  static SisalBoolean BoolVal[4] = {
    /*	F	T */
/*F*/	FALSE,	TRUE,
/*T*/	FALSE,	FALSE
  };

  Arith3Op(in,out,info,BoolVal,CharacterLess,DoubleLess,IntegerLess,RealLess);
}
void
LessEqual(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  static SisalBoolean BoolVal[4] = {
    /*	F	T */
/*F*/	TRUE,	TRUE,
/*T*/	FALSE,	TRUE
  };

  Arith3Op(in,out,info,
	   BoolVal,CharacterLessEqual,DoubleLessEqual,
	   IntegerLessEqual,RealLessEqual);
}
void
Equal(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  static SisalBoolean BoolVal[4] = {
    /*	F	T */
/*F*/	TRUE,	FALSE,
/*T*/	FALSE,	TRUE
  };

  Arith3Op(in,out,info,
	   BoolVal,CharacterEqual,DoubleEqual,
	   IntegerEqual,RealEqual);
}
void
NotEqual(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  static SisalBoolean BoolVal[4] = {
    /*	F	T */
/*F*/	FALSE,	TRUE,
/*T*/	TRUE,	FALSE
  };

  Arith3Op(in,out,info,
	   BoolVal,CharacterNotEqual,DoubleNotEqual,
	   IntegerNotEqual,RealNotEqual);
}
/* ------------------------------------------------------------ */
void
IsError(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;		/* ARGSUSED */
{
  IF1OBJECT	*B,*RES;
  B		= in[1];	/* The first arg is a literal error */
				/* val, this arg is the value to test */
  RES		= out[0];

  NoWorkIfNoOutput();

  /* Insert the values for the resulting boolean */
  BasErr(RES)	= FALSE;
  BVal(RES)	= (SisalBoolean)IsAnErrorValue(B);

  /* Set the type and returns */
  SetDes(RES,BooleanTypeD);
}
/* ------------------------------------------------------------ */
void
Bool(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  IF1OBJECT	*A,*RES;
  A		= in[0];
  RES		= out[0];

  NoWorkIfNoOutput();

  if ( BasErr(A) ) {
    BasErr(RES) = TRUE;
  } else {
    switch(KindOfBasic(IType(info)[0])) {
      case IF1Integer:
	IntegerBoolean(IVal(A),&BVal(RES),&BasErr(RES));
	break;

      default:
	Oops("Bad type in Bool");
	break;
    }
  }

  SetDes(RES,OType(info)[0]);
}
void
Char(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  IF1OBJECT	*A,*RES;
  A		= in[0];
  RES		= out[0];

  NoWorkIfNoOutput();

  if ( BasErr(A) ) {
    BasErr(RES) = TRUE;
  } else {
    switch(KindOfBasic(IType(info)[0])) {
      case IF1Integer:
	IntegerCharacter(IVal(A),&CVal(RES),&BasErr(RES));
	break;

      default:
	Oops("Bad type in Char");
	break;
    }
  }

  SetDes(RES,OType(info)[0]);
}
void
Double(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  IF1OBJECT	*A,*RES;
  A		= in[0];
  RES		= out[0];

  NoWorkIfNoOutput();

  if ( BasErr(A) ) {
    BasErr(RES) = TRUE;
  } else {
    switch(KindOfBasic(IType(info)[0])) {
      case IF1Integer:
	IntegerDouble(IVal(A),&DVal(RES),&BasErr(RES));
	break;

      case IF1Real:
	RealDouble(RVal(A),&DVal(RES),&BasErr(RES));
	break;

      default:
	Oops("Bad type in Double");
	break;
    }
  }

  SetDes(RES,OType(info)[0]);
}
void
Int(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{

  IF1OBJECT	*A,*RES;
  A		= in[0];
  RES		= out[0];

  NoWorkIfNoOutput();

  if ( BasErr(A) ) {
    BasErr(RES) = TRUE;
  } else {
    switch(KindOfBasic(IType(info)[0])) {
      case IF1Boolean:
	BooleanInteger(BVal(A),&IVal(RES),&BasErr(RES));
	break;

      case IF1Character:
	CharacterInteger(CVal(A),&IVal(RES),&BasErr(RES));
	break;

      case IF1Double:
	DoubleInteger(DVal(A),&IVal(RES),&BasErr(RES));
	break;

      case IF1Integer:
	IVal(RES)	= IVal(A);
	BasErr(RES)	= FALSE;
	break;

      case IF1Real:
	RealInteger(RVal(A),&IVal(RES),&BasErr(RES));
	break;

      default:
	Oops("Bad type in conversion");
	break;
    }
  }

  SetDes(RES,OType(info)[0]);
}
void
Floor(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  IF1OBJECT	*A,*RES;
  A		= in[0];
  RES		= out[0];

  NoWorkIfNoOutput();

  if ( BasErr(A) ) {
    BasErr(RES) = TRUE;
  } else {
    switch(KindOfBasic(IType(info)[0])) {
      case IF1Double:
	DoubleFloor(DVal(A),&IVal(RES),&BasErr(RES));
	break;

      case IF1Real:
	RealFloor(RVal(A),&IVal(RES),&BasErr(RES));
	break;

      default:
	Oops("Bad type in Floor");
	break;
      }
  }
  SetDes(RES,OType(info)[0]);
}
void
Trunc(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  IF1OBJECT	*A,*RES;
  A		= in[0];
  RES		= out[0];

  NoWorkIfNoOutput();

  if ( BasErr(A) ) {
    BasErr(RES) = TRUE;
  } else {
    switch(KindOfBasic(IType(info)[0])) {
      case IF1Double:
	DoubleTrunc(DVal(A),&IVal(RES),&BasErr(RES));
	break;

      case IF1Real:
	RealTrunc(RVal(A),&IVal(RES),&BasErr(RES));
	break;

      default:
	Oops("Bad type in Trunc");
	break;
      }
  }
  SetDes(RES,OType(info)[0]);
}
void
Single(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  IF1OBJECT	*A,*RES;
  A		= in[0];
  RES		= out[0];

  NoWorkIfNoOutput();

  if ( BasErr(A) ) {
    BasErr(RES) = TRUE;
  } else {
    switch(KindOfBasic(IType(info)[0])) {
      case IF1Double:
	DoubleReal(DVal(A),&RVal(RES),&BasErr(RES));
	break;

      case IF1Integer:
	IntegerReal(IVal(A),&RVal(RES),&BasErr(RES));
	break;

      default:
	Oops("Bad type in Single");
	break;
    }
  }

  SetDes(RES,OType(info)[0]);
}
