#include "SC.h"
#include "SCLib.h"

extern double tan();
extern double atan();
extern double cos();
extern double acos();
extern double exp();
extern double log();
extern double log10();
extern double sin();
extern double asin();
#define sqr(x) ((x)*(x))
extern double sqrt();

#define and(x,y) ((x) & (y))
#define or(x,y) ((x) | (y))
#define xor(x,y) ((x) ^ (y))
#define not(x) (~(x))
#define shiftr(x,y) ((x) >> (y))
#define shiftl(x,y) ((x) << (y))

/* Literal Pool */
  NoLiterals

/* Node Table */
#define NodeTable	SystemNodeTable
NodeStuff	NodeTable[] = {
	EntryInformation(5,0,"System"),
	SystemRoutine(1,"SUM_",SUM_),
	SystemRoutine(2,"PRODUCT_",PRODUCT_),
	SystemRoutine(3,"LEAST_",LEAST_),
	SystemRoutine(4,"GREATEST_",GREATEST_),
	SystemRoutine(5,"CATENATE_",CATENATE_)
};

/* ------------------------------------------------------------ */
/* One argument function definition */
#define CInterface(F_,F,cast) \
GlobalFunction(F_) \
{ \
  IF1OBJECT	*X = in[0]; \
  IF1OBJECT	*FX = out[0]; \
 \
  if ( TypeEntryOf(TypeOf(X)) != IF1BASIC || BasErr(X) ) { \
    MakeError(FX,TypeOf(X)); \
  } else { \
    BasErr(FX) = FALSE; \
    switch( KindOfBasic(TypeOf(X)) ) { \
     case IF1Double: \
      DVal(FX) = LocalToDouble((double)F(cast DoubleToLocal(DVal(X)))); \
      SetDes(FX,DoubleTypeD); \
      break; \
     case IF1Real: \
      RVal(FX) = LocalToReal((float)F(cast RealToLocal(RVal(X)))); \
      SetDes(FX,RealTypeD); \
      break; \
     case IF1Integer: \
      IVal(FX) = LocalToInteger((int)F(cast IntegerToLocal(IVal(X)))); \
      SetDes(FX,IntegerTypeD); \
      break; \
     default: \
      MakeError(FX,TypeOf(X)); \
    } \
  } \
}

/* Two arguments function definition */
#define CInterface2(F_,F,cast) \
GlobalFunction(F_) \
{ \
  IF1OBJECT	*X = in[0]; \
  IF1OBJECT     *Y = in[1]; \
  IF1OBJECT	*FX = out[0]; \
 \
  if ( TypeEntryOf(TypeOf(X)) != IF1BASIC || BasErr(X) || \
       TypeEntryOf(TypeOf(Y)) != IF1BASIC || BasErr(Y) ) { \
    MakeError(FX,TypeOf(X)); \
  } else { \
    BasErr(FX) = FALSE; \
    switch( KindOfBasic(TypeOf(X)) ) { \
     case IF1Double: \
      DVal(FX) = LocalToDouble((double)F(cast DoubleToLocal(DVal(X)), \
                                         cast DoubleToLocal(DVal(Y)))); \
      SetDes(FX,DoubleTypeD); \
      break; \
     case IF1Real: \
      RVal(FX) = LocalToReal((float)F(cast RealToLocal(RVal(X)), \
                                      cast RealToLocal(RVal(Y)))); \
      SetDes(FX,RealTypeD); \
      break; \
     case IF1Integer: \
      IVal(FX) = LocalToInteger((int)F(cast IntegerToLocal(IVal(X)), \
                                       cast IntegerToLocal(IVal(Y)))); \
      SetDes(FX,IntegerTypeD); \
      break; \
     default: \
      MakeError(FX,TypeOf(X)); \
    } \
  } \
}

CInterface(ATAN_,atan,(double))
CInterface(TAN_,tan,(double))
CInterface(COS_,cos,(double))
CInterface(ACOS_,acos,(double))
CInterface(ETOTHE_,exp,(double))
CInterface(LOG_,log,(double))
CInterface(LOG10_,log10,(double))
CInterface(SIN_,sin,(double))
CInterface(ASIN_,asin,(double))
CInterface(SQR_,sqr,)
CInterface(SQRT_,sqrt,(double))
CInterface2(AND_,and,(int))
CInterface2(OR_,or,(int))
CInterface2(XOR_,xor,(int))
CInterface(NOT_,not,(int))
CInterface2(SHIFTR_,shiftr,(int))
CInterface2(SHIFTL_,shiftl,(int))
