#include "SC.h"
#include "SCLib.h"

/* ------------------------------------------------------------ */
void
AllButLastValue(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
#define	MULT	(0)
#define COND	(1)

  BagPtr	B;
  unsigned	i;
  unsigned	Size;
  IF1OBJECT	*OutMult, *OutValue, *InMult;
  TypeD         OutType;
  int		GoodCount;	/* Number of items that are good */
				/* before the first Error[boolean] in */
				/* the flags multiple. Not used */

  OutType = OType(info)[MULT];
  InMult = in[MULT];
  OutMult = out[MULT];
  Size = ( INARITY(info) > 1 )? NumberOfTrueInMultiple( in[COND] ): 
    MultSize(InMult);
  
  if ( IsEmptyObject(InMult) || !Size )
  {
    SetToError( OutMult, OutType, OUTARITY(info) );
    return;
  } else if (INARITY(info) > 1) {
    /* Conditionally collect the elements that are set to true */
    /* Collect a bag full of the pertinent items but last one */
    B = ConditionalCollect( InMult, in[COND], Size, &GoodCount );
    MakeMultipleFromBag( OutType, B, Size, OutMult );
    
  } else {
    /* Copy the Multiple from the inputs and delete last element */
    *OutMult = *InMult;
  }
  
  --MultTrueSize( OutMult );
  if ( MultSize( OutMult ) > MultTrueSize( OutMult ) )
    MultSize( OutMult ) = MultTrueSize( OutMult );

#undef MULT
#undef COND

}

/* ------------------------------------------------------------ */
void
FirstorFinalValue(in,out,info,First)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
     SisalBoolean First;
{
#define	MULT	(0)
#define COND	(1)
#define TOUT    (0)

  BagPtr        B;
  unsigned	element;
  unsigned	Size, GoodCount;
  IF1OBJECT	*OutMult, *InMult;
  TypeD         OutType;

  InMult = in[MULT];
  Size = ( INARITY(info) > 1 )? NumberOfTrueInMultiple( in[COND] ): 0;
  element = (First) ? 0 : MultSize(InMult)-1;
  
  if ( Size )
  {
    /* Extract the first or final element from those that are TRUE */
    B = ConditionalCollect( InMult, in[COND], Size, &GoodCount );
    MakeMultipleFromBag( OType(info)[MULT], B, Size, OutMult );
    GetFromMult( OutMult, element, out[TOUT]);
  }
  else 
  {
    /* Copy the element from the Multiple */
    GetFromMult( InMult, element, out[TOUT] );
  }
  
#undef MULT
#undef COND
#undef TOUT

}

/* ------------------------------------------------------------ */
void
FirstValue(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  FirstorFinalValue(in,out,info,TRUE);
}

/* ------------------------------------------------------------ */
void
FinalValue(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  FirstorFinalValue(in,out,info,FALSE);
}
