#include "world.h"

typedef void    ((*Function)());     /* needed to pass functions */

/**************************************************************************/
/* LOCAL ***************    ApplyToEachNode     ***************************/
/**************************************************************************/
/* Purpose: Applys the function, funct, to all nodes starting from n      */
/**************************************************************************/

static void ApplyToEachNode(pred,n,funct)
     PNODE n;
     Function funct;
{
  PNODE sg,sn,Pred;

  if (IsCompound(n)) {
    for (sg = n->C_SUBS; sg !=NULL; sg=sg->gsucc) {
      ApplyToEachNode(NULL,sg,funct);
    }
    funct(pred,n);
  } else if (IsGraph(n)) {
    Pred = n;
    for (sn = n->G_NODES; sn !=NULL; sn = sn->nsucc) {
      ApplyToEachNode(Pred,sn,funct);
      Pred = sn;
    }
  }
}

/**************************************************************************/
/* LOCAL ***************    ApplyToAllNodes     ***************************/
/**************************************************************************/
/* Purpose: Applies the function,funct, to all nodes starting from glstop  */
/**************************************************************************/

static void ApplyToAllNodes(funct)
     Function funct;
{
  PNODE f;
  for (f=glstop->gsucc; f!=NULL; f=f->gsucc) {
    ApplyToEachNode(NULL,f,funct);
  }
}
/* ------------------------------------------------------------ */
PNODE
InsertNodeAtEndOfGraph(G,Op)
     PNODE      G;
     int        Op;
{
  PNODE         N,NEW;
  int		Label;

  /* ------------------------------------------------------------ */
  /* Find the last label in the graph */
  for(N=G->nsucc,Label = 0; N; N=N->nsucc) Label++;

  /* Create a new node with the proper opcode that will go before A */
  NEW = NodeAlloc( Label, Op );

  LinkNode(FindLastNode(G),NEW);

  return NEW;
}
/* ------------------------------------------------------------ */
#define NewEdge(NewE,From,FromP,To,ToP,Einfo) {\
  NewE = EdgeAlloc(From,FromP,To,ToP);\
  NewE->info = Einfo;\
  if (From) LinkExport(From,NewE);\
  LinkImport(To,NewE);\
}
#define NewLiteral(NewE,To,ToP,Einfo,Econst) {\
  NewEdge(NewE,(PNODE)NULL,CONST_LABEL,To,ToP,Einfo);\
  NewE->constant = Econst;\
}
/* ------------------------------------------------------------ */
int
LargestInputPort(N)
     PNODE	N;
{
  int		Count;
  PEDGE		E;
  for(Count=0,E=N->imp; E; E=E->isucc) Count++;
  return Count;
}

/* ------------------------------------------------------------ */
static void
InsertLoopNoops(PRED,LOOP)
     PNODE	PRED,LOOP;
{
  PNODE		Init,Test,Body,Ret;
  PNODE		New,Noop,N,M,NextN;
  PEDGE		e,nexte,NewE,OutsideE,BodyE,InitE;
  int		Port,NoOpPort,LoopPort,Label;

  if ( IsLoopA(LOOP) || IsLoopB(LOOP) ) {
    Init = LOOP->L_INIT;
    Test = LOOP->L_TEST;
    Body = LOOP->L_BODY;
    Ret  = LOOP->L_RET;

    /* ------------------------------------------------------------ */
    /* Find the NoOp node. If there isn't any, create one */
    Noop = NULL;
    for(Noop=Init->nsucc; Noop && !IsNoOp(Noop); Noop=Noop->nsucc);
    if (!Noop) {		/* Create one if needed */
	Noop = InsertNodeAtEndOfGraph(Init,IFNoOp);
	CopyPragmas(Init,Noop);
    }
    NoOpPort = LargestInputPort(Noop)+1;
    LoopPort = LargestInputPort(LOOP)+1;

    /* ------------------------------------------------------------ */
    /* Yank the nodes (if any) out of the INIT graph */
    for (N = Init->G_NODES; N != NULL; N = NextN) {
      NextN = N->nsucc;

      if ( N->type != IFNoOp ) {
	/* Unlink the node and insert it directly before the loop */
	Label = LOOP->label;
	for(M=LOOP; M; M = M->nsucc) M->label++;
	UnlinkNode(N);
	LinkNode(PRED,N);
	N->label = Label;

	/* Link the outside edges to the node copy outside the compound */
	for(e=N->imp; e; e=nexte) {
	  nexte = e->isucc;

	  if ( !IsConst(e) ) {
	    /* Cut the inside-out link to the node */
	    Port = e->iport;
	    UnlinkImport(e);

	    /* Replace it with a legitimate edge */
	    OutsideE = FindImport(LOOP,e->eport);
	    NewEdge(NewE,OutsideE->src,OutsideE->eport,N,Port,e->info);
	    CopyPragmas(OutsideE,NewE);

	    /* Cut it loose from the graph */
	    UnlinkExport(e);
	  }
	}

	/* Make new K ports for results */
	for(e=N->exp; e; e=nexte) {
	  nexte = e->esucc;

	  /* Cut the output loose from the node */
	  Port = e->eport;
	  UnlinkExport(e);

	  /* Create a K port */
	  AddNewLoopPort(LOOP,LoopPort);

	  /* Connect a legitimage edge from the node */
	  NewEdge(NewE,N,Port,LOOP,LoopPort,e->info);
	  CopyPragmas(e,NewE);

	  /* Reconnect the edge to the new K port */
	  e->eport = LoopPort;
	  LinkExport(Init,e);

	  LoopPort++;
	}
      }
    }

    /* Remove pass throughs in the BODY not used elsewhere */
    for(BodyE=Body->exp; BodyE; BodyE = nexte) {
      nexte = BodyE->esucc;
      Port = BodyE->eport;
      if ( IsGraph(BodyE->dst) &&
	  BodyE->iport == Port &&
	  UsageCount(Body,Port) == 1 &&
	  !FindExport(Init,Port) &&
	  !FindExport(Test,Port) &&
	  !FindExport(Ret ,Port) ) {

	/* Remove the pass through from the INIT graph */
	InitE = FindImport(Init,Port);
	if ( InitE ) {
	  UnlinkImport(InitE);
	  UnlinkExport(InitE);
	}

	/* Remove the pass through in the BODY */
	UnlinkExport(BodyE);
	UnlinkImport(BodyE);
      }
    }

    /* Identify edges (now imported) that aren't local really used */
    for(OutsideE=LOOP->imp; OutsideE; OutsideE = nexte) {
      nexte = OutsideE->isucc;

      Port = OutsideE->iport;
      if ( !FindExport(Init,Port) &&
	  !FindExport(Test,Port) &&
	  !FindExport(Body,Port) &&
	  !FindExport(Ret ,Port) ) {

	/* Remove the edge leading into the LOOP */
	UnlinkImport(OutsideE);
	UnlinkExport(OutsideE);

	/* Adjust the ports */
	RemoveLoopPort(LOOP,Port);
      }
    }

    /* ------------------------------------------------------------ */
    /* Route the literal and graph values through the NoOp */
    for(e = Init->imp; e; e = nexte ) {
      nexte = e->isucc;
      Port = e->iport;
      UnlinkImport(e);
      e->iport = NoOpPort;	/* Link into first empty port of NoOp */
      LinkImport(Noop,e);

      NewEdge(NewE,Noop,NoOpPort,Init,Port,e->info);
      NoOpPort++;
      CopyPragmas(e,NewE);
    }
  }
}

/* ------------------------------------------------------------ */
AddNewLoopPort(LOOP,Port)
     PNODE	LOOP;
     int	Port;
{
  PNODE		Init,Test,Body,Ret;
  PEDGE		E;

  Init = LOOP->L_INIT;
  Test = LOOP->L_TEST;
  Body = LOOP->L_BODY;
  Ret  = LOOP->L_RET;

#define AddIPort(G) for(E=G->imp;E;E=E->isucc) if (E->iport>=Port) E->iport++
#define AddOPort(G) for(E=G->exp;E;E=E->esucc) if (E->eport>=Port) E->eport++
  AddIPort(LOOP);

  AddOPort(Init);
  AddIPort(Init);

  AddOPort(Test);

  AddOPort(Body);
  AddIPort(Body);

  AddOPort(Ret);
}
/* ------------------------------------------------------------ */
RemoveLoopPort(LOOP,Port)
     PNODE	LOOP;
     int	Port;
{
  PNODE		Init,Test,Body,Ret;
  PEDGE		E;

  Init = LOOP->L_INIT;
  Test = LOOP->L_TEST;
  Body = LOOP->L_BODY;
  Ret  = LOOP->L_RET;

#define RemoveIPort(G) for(E=G->imp;E;E=E->isucc) if (E->iport>=Port) E->iport--
#define RemoveOPort(G) for(E=G->exp;E;E=E->esucc) if (E->eport>=Port) E->eport--
  RemoveIPort(LOOP);

  RemoveOPort(Init);
  RemoveIPort(Init);

  RemoveOPort(Test);

  RemoveOPort(Body);
  RemoveIPort(Body);

  RemoveOPort(Ret);
}

/* ------------------------------------------------------------ */
void
If2Process()
{
  PNODE		F;

  ApplyToAllNodes(InsertLoopNoops);

  If2Write();
}
