/* Run-time library for use with "p2c", the Pascal to C translator */

/* "p2c"  Copyright (C) 1989 Dave Gillespie.
 * This file may be copied, modified, etc. in any way.  It is not restricted
 * by the licence agreement accompanying p2c itself.
 */



/* Header file for code generated by "p2c", the Pascal-to-C translator */

/* "p2c"  Copyright (C) 1989 Dave Gillespie, version 1.16.
 * This file may be copied, modified, etc. in any way.  It is not restricted
 * by the licence agreement accompanying p2c itself.
 */


#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <setjmp.h>
/* #include <assert.h> */


#ifdef M_XENIX  /* avoid compiler bug */
# define SHORT_MAX  (32767)
# define SHORT_MIN  (-32768)
#endif


/* The following definitions work only on twos-complement machines */
#ifndef SHORT_MAX
# define SHORT_MAX  (((unsigned short) -1) >> 1)
# define SHORT_MIN  (~SHORT_MAX)
#endif

#ifndef INT_MAX
# define INT_MAX    (((unsigned int) -1) >> 1)
# define INT_MIN    (~INT_MAX)
#endif

#ifndef LONG_MAX
# define LONG_MAX   (((unsigned long) -1) >> 1)
# define LONG_MIN   (~LONG_MAX)
#endif

#ifndef SEEK_SET
# define SEEK_SET   0
# define SEEK_CUR   1
# define SEEK_END   2
#endif

#ifndef EXIT_SUCCESS
# define EXIT_SUCCESS  0
# define EXIT_FAILURE  1
#endif


#define SETBITS  32


# define Signed
# define Void       int
# ifndef Const
#  define Const
# endif
# ifndef Volatile
#  define Volatile
# endif
# define PP(x)      ()
# define PV()       ()

typedef char *Anyptr;

# define Inline

#define Register    register  /* Register variables */
#define Char        char      /* Characters (not bytes) */

#ifndef Static
# define Static
#endif

#ifndef Local
# define Local
#endif

typedef Signed   char schar;
typedef unsigned char unchar;
typedef unsigned char boolean;

#ifndef true
# define true    1
# define false   0
#endif


typedef struct {
    Anyptr proc, link;
} _PROCEDURE;

#ifndef _FNSIZE
# define _FNSIZE  120
#endif


extern void    PASCAL_MAIN  PP( (int, Char **) );
extern Char    **P_argv;
extern int     P_argc;
extern short   P_escapecode;
extern int     P_ioresult;


/* extern Anyptr   malloc      PP( (size_t) ); */
/* extern void     free        PP( (Anyptr) ); */

/* extern int      _OutMem     PV(); */
extern Anyptr   _OutMem     PV();

extern int      _CaseCheck  PV();
extern int      _NilCheck   PV();
extern int	_Escape     PP( (int) );
extern int	_EscIO      PP( (int) );

extern long     ipow        PP( (long, long) );
extern Char    *strsub      PP( (Char *, Char *, int, int) );
extern Char    *strltrim    PP( (Char *) );
extern Char    *strrtrim    PP( (Char *) );
extern Char    *strrpt      PP( (Char *, Char *, int) );
extern Char    *strpad      PP( (Char *, Char *, int, int) );
extern int      strpos2     PP( (Char *, Char *, int) );
extern long     memavail    PV();
extern int      P_peek      PP( (FILE *) );
extern int      P_eof       PP( (FILE *) );
extern int      P_eoln      PP( (FILE *) );
extern void     P_readpaoc  PP( (FILE *, Char *, int) );
extern void     P_readlnpaoc PP( (FILE *, Char *, int) );
extern long     P_maxpos    PP( (FILE *) );
extern Char    *P_trimname  PP( (Char *, int) );
extern long    *P_setunion  PP( (long *, long *, long *) );
extern long    *P_setint    PP( (long *, long *, long *) );
extern long    *P_setdiff   PP( (long *, long *, long *) );
extern long    *P_setxor    PP( (long *, long *, long *) );
extern int      P_inset     PP( (unsigned, long *) );
extern int      P_setequal  PP( (long *, long *) );
extern int      P_subset    PP( (long *, long *) );
extern long    *P_addset    PP( (long *, unsigned) );
extern long    *P_addsetr   PP( (long *, unsigned, unsigned) );
extern long    *P_remset    PP( (long *, unsigned) );
extern long    *P_setcpy    PP( (long *, long *) );
extern long    *P_expset    PP( (long *, long) );
extern long     P_packset   PP( (long *) );
extern int      P_getcmdline PP( (int l, int h, Char *line) );
extern void     TimeStamp   PP( (int *Day, int *Month, int *Year,
				 int *Hour, int *Min, int *Sec) );
extern void	P_sun_argv  PP( (char *, int, int) );


/* I/O error handling */
#define _CHKIO(cond,ior,val,def)  ((cond) ? P_ioresult=0,(val)  \
					  : P_ioresult=(ior),(def))
#define _SETIO(cond,ior)          (P_ioresult = (cond) ? 0 : (ior))

/* Following defines are suitable for the HP Pascal operating system */
#define FileNotFound     10
#define FileNotOpen      13
#define FileWriteError   38
#define BadInputFormat   14
#define EndOfFile        30

/* Creating temporary files */
char dummyfilename[512];
char dummystring[1024];
# define tmpfile()  (fopen(tmpnam(dummyfilename), "w+"))

/* Memory allocation */
char *calloc();
extern Anyptr __MallocTemp__;
# define Malloc(n)  ((__MallocTemp__ = calloc(n,1)) ? __MallocTemp__ : (Anyptr)_OutMem())

#define FreeR(p)    (free((Anyptr)(p)))    /* used if arg is an rvalue */
#define Free(p)     (free((Anyptr)(p)), (p)=NULL)

/* sign extension */
#define SEXT(x,n)   ((x) | -(((x) & (1L<<((n)-1))) << 1))

/* packed arrays */   /* BEWARE: these are untested! */
#define P_getbits_UB(a,i,n,L)   ((int)((a)[(i)>>(L)-(n)] >>   \
				       (((~(i))&((1<<(L)-(n))-1)) << (n)) &  \
				       (1<<(1<<(n)))-1))

#define P_getbits_SB(a,i,n,L)   ((int)((a)[(i)>>(L)-(n)] <<   \
				       (16 - ((((~(i))&((1<<(L)-(n))-1))+1) <<\
					      (n)) >> (16-(1<<(n))))))

#define P_putbits_UB(a,i,x,n,L) ((a)[(i)>>(L)-(n)] |=   \
				 (x) << (((~(i))&((1<<(L)-(n))-1)) << (n)))

#define P_putbits_SB(a,i,x,n,L) ((a)[(i)>>(L)-(n)] |=   \
				 ((x) & (1<<(1<<(n)))-1) <<   \
				 (((~(i))&((1<<(L)-(n))-1)) << (n)))

#define P_clrbits_B(a,i,n,L)    ((a)[(i)>>(L)-(n)] &=   \
				 ~( ((1<<(1<<(n)))-1) <<   \
				   (((~(i))&((1<<(L)-(n))-1)) << (n))) )

/* small packed arrays */
#define P_getbits_US(v,i,n)     ((int)((v) >> ((i)<<(n)) & (1<<(1<<(n)))-1))
#define P_getbits_SS(v,i,n)     ((int)((long)(v) << (SETBITS - (((i)+1) << (n))) >> (SETBITS-(1<<(n)))))
#define P_putbits_US(v,i,x,n)   ((v) |= (x) << ((i) << (n)))
#define P_putbits_SS(v,i,x,n)   ((v) |= ((x) & (1<<(1<<(n)))-1) << ((i)<<(n)))
#define P_clrbits_S(v,i,n)      ((v) &= ~( ((1<<(1<<(n)))-1) << ((i)<<(n)) ))

#define P_max(a,b)   ((a) > (b) ? (a) : (b))
#define P_min(a,b)   ((a) < (b) ? (a) : (b))


/* Fix toupper/tolower on Suns and other stupid BSD systems */
#ifdef toupper
# undef toupper
# undef tolower
# define toupper(c)   my_toupper(c)
# define tolower(c)   my_tolower(c)
#endif

#ifndef _toupper
# if 'A' == 65 && 'a' == 97
#  define _toupper(c)  ((c)-'a'+'A')
#  define _tolower(c)  ((c)-'A'+'a')
# else
#  define _toupper(c)  toupper(c)
#  define _tolower(c)  tolower(c)
# endif
#endif


exit_()
{
  exit(0);
}


/* #define LACK_LABS     */   /* Define these if necessary */
/* #define LACK_MEMMOVE  */


#ifndef NO_TIME
# include <time.h>
#endif

mymemcpy(s1,s2,n)
char *s1;
char *s2;
int   n;
{
  int i;

  for ( i = 0; i < n; i++ )
    s1[i] = s2[i];
}



#define Isspace(c)  isspace(c)      /* or "((c) == ' ')" if preferred */




int P_argc;
char **P_argv;

short P_escapecode;
int P_ioresult;

long EXCP_LINE;    /* Used by Pascal workstation system */

Anyptr __MallocTemp__;

void PASCAL_MAIN(argc, argv)
int argc;
char **argv;
{
    P_argc = argc;
    P_argv = argv;

#ifdef LOCAL_INIT
    LOCAL_INIT();
#endif
}





/* In case your system lacks these... */

#ifdef LACK_LABS
long labs(x)
long x;
{
    return((x > 0) ? x : -x);
}
#endif


#ifdef LACK_MEMMOVE
Anyptr memmove(d, s, n)
Anyptr d, s;
register long n;
{
    if (d < s || d - s >= n) {
	mymemcpy(d, s, n);
	return d;
    } else if (n > 0) {
	register char *dd = d + n, *ss = s + n;
	while (--n >= 0)
	    *--dd = *--ss;
    }
    return d;
}
#endif


int my_toupper(c)
int c;
{
    if (islower(c))
	return _toupper(c);
    else
	return c;
}


int my_tolower(c)
int c;
{
    if (isupper(c))
	return _tolower(c);
    else
	return c;
}




long ipow(a, b)
long a, b;
{
    long v;

    if (a == 0 || a == 1)
	return a;
    if (a == -1)
	return (b & 1) ? -1 : 1;
    if (b < 0)
	return 0;
    if (a == 2)
	return 1 << b;
    v = (b & 1) ? a : 1;
    while ((b >>= 1) > 0) {
	a *= a;
	if (b & 1)
	    v *= a;
    }
    return v;
}




/* Common string functions: */

/* Store in "ret" the substring of length "len" starting from "pos" (1-based).
   Store a shorter or null string if out-of-range.  Return "ret". */

char *strsub(ret, s, pos, len)
register char *ret, *s;
register int pos, len;
{
    register char *s2;

    if (--pos < 0 || len <= 0) {
        *ret = 0;
        return ret;
    }
    while (pos > 0) {
        if (!*s++) {
            *ret = 0;
            return ret;
        }
        pos--;
    }
    s2 = ret;
    while (--len >= 0) {
        if (!(*s2++ = *s++))
            return ret;
    }
    *s2 = 0;
    return ret;
}


/* Return the index of the first occurrence of "pat" as a substring of "s",
   starting at index "pos" (1-based).  Result is 1-based, 0 if not found. */

int strpos2(s, pat, pos)
char *s;
register char *pat;
register int pos;
{
    register char *cp, ch;
    register int slen;

    if (--pos < 0)
        return 0;
    slen = strlen(s) - pos;
    cp = s + pos;
    if (!(ch = *pat++))
        return 0;
    pos = strlen(pat);
    slen -= pos;
    while (--slen >= 0) {
        if (*cp++ == ch && !strncmp(cp, pat, pos))
            return cp - s;
    }
    return 0;
}


/* Case-insensitive version of strcmp. */

int strcicmp(s1, s2)
register char *s1, *s2;
{
    register unsigned char c1, c2;

    while (*s1) {
	if (*s1++ != *s2++) {
	    if (!s2[-1])
		return 1;
	    c1 = toupper(s1[-1]);
	    c2 = toupper(s2[-1]);
	    if (c1 != c2)
		return c1 - c2;
	}
    }
    if (*s2)
	return -1;
    return 0;
}




/* HP and Turbo Pascal string functions: */

/* Trim blanks at left end of string. */

char *strltrim(s)
register char *s;
{
    while (Isspace(*s++)) ;
    return s - 1;
}


/* Trim blanks at right end of string. */

char *strrtrim(s)
register char *s;
{
    register char *s2 = s;

    if (!*s)
	return s;
    while (*++s2) ;
    while (s2 > s && Isspace(*--s2))
        *s2 = 0;
    return s;
}


/* Store in "ret" "num" copies of string "s".  Return "ret". */

char *strrpt(ret, s, num)
char *ret;
register char *s;
register int num;
{
    register char *s2 = ret;
    register char *s1;

    while (--num >= 0) {
        s1 = s;
        while ((*s2++ = *s1++)) ;
        s2--;
    }
    return ret;
}


/* Store in "ret" string "s" with enough pad chars added to reach "size". */

char *strpad(ret, s, padchar, num)
char *ret;
register char *s;
register int padchar, num;
{
    register char *d = ret;

    if (s == d) {
	while (*d++) ;
    } else {
	while ((*d++ = *s++)) ;
    }
    num -= (--d - ret);
    while (--num >= 0)
	*d++ = padchar;
    *d = 0;
    return ret;
}


/* Copy the substring of length "len" from index "spos" of "s" (1-based)
   to index "dpos" of "d", lengthening "d" if necessary.  Length and
   indices must be in-range. */

void strmove(len, s, spos, d, dpos)
register char *s, *d;
register int len, spos, dpos;
{
    s += spos - 1;
    d += dpos - 1;
    while (*d && --len >= 0)
	*d++ = *s++;
    if (len > 0) {
	while (--len >= 0)
	    *d++ = *s++;
	*d = 0;
    }
}


/* Delete the substring of length "len" at index "pos" from "s".
   Delete less if out-of-range. */

void strdelete(s, pos, len)
register char *s;
register int pos, len;
{
    register int slen;

    if (--pos < 0)
        return;
    slen = strlen(s) - pos;
    if (slen <= 0)
        return;
    s += pos;
    if (slen <= len) {
        *s = 0;
        return;
    }
    while ((*s = s[len])) s++;
}


/* Insert string "src" at index "pos" of "dst". */

void strinsert(src, dst, pos)
register char *src, *dst;
register int pos;
{
    register int slen, dlen;

    if (--pos < 0)
        return;
    dlen = strlen(dst);
    dst += dlen;
    dlen -= pos;
    if (dlen <= 0) {
        strcpy(dst, src);
        return;
    }
    slen = strlen(src);
    do {
        dst[slen] = *dst;
        --dst;
    } while (--dlen >= 0);
    dst++;
    while (--slen >= 0)
        *dst++ = *src++;
}




/* File functions */

/* Peek at next character of input stream; return EOF at end-of-file. */

int P_peek(f)
FILE *f;
{
    int ch;

    ch = getc(f);
    if (ch == EOF)
	return EOF;
    ungetc(ch, f);
    return (ch == '\n') ? ' ' : ch;
}


/* Check if at end of file, using Pascal "eof" semantics.  End-of-file for
   stdin is broken; remove the special case for it to be broken in a
   different way. */

int P_eof(f)
FILE *f;
{
    register int ch;

    if (feof(f))
	return 1;
    if (f == stdin)
	return 0;    /* not safe to look-ahead on the keyboard! */
    ch = getc(f);
    if (ch == EOF)
	return 1;
    ungetc(ch, f);
    return 0;
}


/* Check if at end of line (or end of entire file). */

int P_eoln(f)
FILE *f;
{
    register int ch;

    ch = getc(f);
    if (ch == EOF)
        return 1;
    ungetc(ch, f);
    return (ch == '\n');
}


/* Read a packed array of characters from a file. */

void P_readpaoc(f, s, len)
FILE *f;
char *s;
int len;
{
    int ch;

    for (;;) {
	if (len <= 0)
	    return;
	ch = getc(f);
	if (ch == EOF || ch == '\n')
	    break;
	*s++ = ch;
	--len;
    }
    while (--len >= 0)
	*s++ = ' ';
    if (ch != EOF)
	ungetc(ch, f);
}

void P_readlnpaoc(f, s, len)
FILE *f;
char *s;
int len;
{
    int ch;

    for (;;) {
	ch = getc(f);
	if (ch == EOF || ch == '\n')
	    break;
	if (len > 0) {
	    *s++ = ch;
	    --len;
	}
    }
    while (--len >= 0)
	*s++ = ' ';
}


/* Compute maximum legal "seek" index in file (0-based). */

long P_maxpos(f)
FILE *f;
{
    long savepos = ftell(f);
    long val;

    if (fseek(f, 0L, SEEK_END))
        return -1;
    val = ftell(f);
    if (fseek(f, savepos, SEEK_SET))
        return -1;
    return val;
}


/* Use packed array of char for a file name. */

Char *P_trimname(fn, len)
register Char *fn;
register int len;
{
    static Char fnbuf[256];
    register Char *cp = fnbuf;
    
    while (--len >= 0 && *fn && !isspace(*fn))
	*cp++ = *fn++;
    return fnbuf;
}




/* Pascal's "memavail" doesn't make much sense in Unix with virtual memory.
   We fix memory size as 10Meg as a reasonable compromise. */

long memavail()
{
    return 10000000;            /* worry about this later! */
}

long maxavail()
{
    return memavail();
}




/* Sets are stored as an array of longs.  S[0] is the size of the set;
   S[N] is the N'th 32-bit chunk of the set.  S[0] equals the maximum
   I such that S[I] is nonzero.  S[0] is zero for an empty set.  Within
   each long, bits are packed from lsb to msb.  The first bit of the
   set is the element with ordinal value 0.  (Thus, for a "set of 5..99",
   the lowest five bits of the first long are unused and always zero.) */

/* (Sets with 32 or fewer elements are normally stored as plain longs.) */

long *P_setunion(d, s1, s2)         /* d := s1 + s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (sz1 > 0 && sz2 > 0) {
        *d++ = *s1++ | *s2++;
	sz1--, sz2--;
    }
    while (--sz1 >= 0)
	*d++ = *s1++;
    while (--sz2 >= 0)
	*d++ = *s2++;
    *dbase = d - dbase - 1;
    return dbase;
}


long *P_setint(d, s1, s2)           /* d := s1 * s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (--sz1 >= 0 && --sz2 >= 0)
        *d++ = *s1++ & *s2++;
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


long *P_setdiff(d, s1, s2)          /* d := s1 - s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (--sz1 >= 0 && --sz2 >= 0)
        *d++ = *s1++ & ~*s2++;
    if (sz1 >= 0) {
        while (sz1-- >= 0)
            *d++ = *s1++;
    }
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


long *P_setxor(d, s1, s2)         /* d := s1 / s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (sz1 > 0 && sz2 > 0) {
        *d++ = *s1++ ^ *s2++;
	sz1--, sz2--;
    }
    while (--sz1 >= 0)
	*d++ = *s1++;
    while (--sz2 >= 0)
	*d++ = *s2++;
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


int P_inset(val, s)                 /* val IN s */
register unsigned val;
register long *s;
{
    register int bit;
    bit = val % SETBITS;
    val /= SETBITS;
    if (val < *s++ && ((1<<bit) & s[val]))
	return 1;
    return 0;
}


long *P_addset(s, val)              /* s := s + [val] */
register long *s;
register unsigned val;
{
    register long *sbase = s;
    register int bit, size;
    bit = val % SETBITS;
    val /= SETBITS;
    size = *s;
    if (++val > size) {
        s += size;
        while (val > size)
            *++s = 0, size++;
        *sbase = size;
    } else
        s += val;
    *s |= 1<<bit;
    return sbase;
}


long *P_addsetr(s, v1, v2)              /* s := s + [v1..v2] */
register long *s;
register unsigned v1, v2;
{
    register long *sbase = s;
    register int b1, b2, size;
    if ((int)v1 > (int)v2)
	return sbase;
    b1 = v1 % SETBITS;
    v1 /= SETBITS;
    b2 = v2 % SETBITS;
    v2 /= SETBITS;
    size = *s;
    v1++;
    if (++v2 > size) {
        while (v2 > size)
            s[++size] = 0;
        s[v2] = 0;
        *s = v2;
    }
    s += v1;
    if (v1 == v2) {
        *s |= (~((-2)<<(b2-b1))) << b1;
    } else {
        *s++ |= (-1) << b1;
        while (++v1 < v2)
            *s++ = -1;
        *s |= ~((-2) << b2);
    }
    return sbase;
}


long *P_remset(s, val)              /* s := s - [val] */
register long *s;
register unsigned val;
{
    register int bit;
    bit = val % SETBITS;
    val /= SETBITS;
    if (++val <= *s) {
	if (!(s[val] &= ~(1<<bit)))
	    while (*s && !s[*s])
		(*s)--;
    }
    return s;
}


int P_setequal(s1, s2)              /* s1 = s2 */
register long *s1, *s2;
{
    register int size = *s1++;
    if (*s2++ != size)
        return 0;
    while (--size >= 0) {
        if (*s1++ != *s2++)
            return 0;
    }
    return 1;
}


int P_subset(s1, s2)                /* s1 <= s2 */
register long *s1, *s2;
{
    register int sz1 = *s1++, sz2 = *s2++;
    if (sz1 > sz2)
        return 0;
    while (--sz1 >= 0) {
        if (*s1++ & ~*s2++)
            return 0;
    }
    return 1;
}


long *P_setcpy(d, s)                /* d := s */
register long *d, *s;
{
    register long *save_d = d;

#ifdef SETCPY_MEMCPY
    mymemcpy(d, s, (*s + 1) * sizeof(long));
#else
    register int i = *s + 1;
    while (--i >= 0)
        *d++ = *s++;
#endif
    return save_d;
}


/* s is a "smallset", i.e., a 32-bit or less set stored
   directly in a long. */

long *P_expset(d, s)                /* d := s */
register long *d;
register long s;
{
    if (s) {
	d[1] = s;
	*d = 1;
    } else
        *d = 0;
    return d;
}


long P_packset(s)                   /* convert s to a small-set */
register long *s;
{
    if (*s++)
        return *s;
    else
        return 0;
}





/* Oregon Software Pascal extensions, courtesy of William Bader */

int P_getcmdline(l, h, line)
int l, h;
Char *line;
{
    int i, len;
    char *s;
    
    h = h - l + 1;
    len = 0;
    for(i = 1; i < P_argc; i++) {
	s = P_argv[i];
	while (*s) {
	    if (len >= h) return len;
	    line[len++] = *s++;
	}
	if (len >= h) return len;
	line[len++] = ' ';
    }
    return len;
}

#ifdef TURN_BACK_ON
void TimeStamp(Day, Month, Year, Hour, Min, Sec)
int *Day, *Month, *Year, *Hour, *Min, *Sec;
{
#ifndef NO_TIME
    struct tm *tm;
    /* long clock; */
    time_t clock;  /* Oct, 1991 */

    time(&clock);
    tm = localtime(&clock);
    *Day = tm->tm_mday;
    *Month = tm->tm_mon + 1;		/* Jan = 0 */
    *Year = tm->tm_year;
    if (*Year < 1900)
	*Year += 1900;     /* year since 1900 */
    *Hour = tm->tm_hour;
    *Min = tm->tm_min;
    *Sec = tm->tm_sec;
#endif
}
#endif




/* SUN Berkeley Pascal extensions */

void P_sun_argv(s, len, n)
register char *s;
register int len, n;
{
    register char *cp;

    if ((unsigned)n < P_argc)
	cp = P_argv[n];
    else
	cp = "";
    while (*cp && --len >= 0)
	*s++ = *cp++;
    while (--len >= 0)
	*s++ = ' ';
}




/* int _OutMem() */
Anyptr _OutMem()
{
    /* return _Escape(-2); */
    /* TO AVOID int->char* COERSION WARNING MESSAGES ON SOME MACHINES */
    _Escape(-2);
    return( (Anyptr) NULL );
}

int _CaseCheck()
{
    return _Escape(-9);
}

int _NilCheck()
{
    return _Escape(-3);
}





/* The following is suitable for the HP Pascal operating system.
   It might want to be revised when emulating another system. */

char *_ShowEscape(buf, code, ior, prefix)
char *buf, *prefix;
int code, ior;
{
    char *bufp;

    if (prefix && *prefix) {
        strcpy(buf, prefix);
	strcat(buf, ": ");
        bufp = buf + strlen(buf);
    } else {
        bufp = buf;
    }
    if (code == -10) {
        sprintf(bufp, "Pascal system I/O error %d", ior);
        switch (ior) {
            case 3:
                strcat(buf, " (illegal I/O request)");
                break;
            case 7:
                strcat(buf, " (bad file name)");
                break;
            case FileNotFound:   /*10*/
                strcat(buf, " (file not found)");
                break;
            case FileNotOpen:    /*13*/
                strcat(buf, " (file not open)");
                break;
            case BadInputFormat: /*14*/
                strcat(buf, " (bad input format)");
                break;
            case 24:
                strcat(buf, " (not open for reading)");
                break;
            case 25:
                strcat(buf, " (not open for writing)");
                break;
            case 26:
                strcat(buf, " (not open for direct access)");
                break;
            case 28:
                strcat(buf, " (string subscript out of range)");
                break;
            case EndOfFile:      /*30*/
                strcat(buf, " (end-of-file)");
                break;
            case FileWriteError: /*38*/
		strcat(buf, " (file write error)");
		break;
        }
    } else {
        sprintf(bufp, "Pascal system error %d", code);
        switch (code) {
            case -2:
                strcat(buf, " (out of memory)");
                break;
            case -3:
                strcat(buf, " (reference to NIL pointer)");
                break;
            case -4:
                strcat(buf, " (integer overflow)");
                break;
            case -5:
                strcat(buf, " (divide by zero)");
                break;
            case -6:
                strcat(buf, " (real math overflow)");
                break;
            case -8:
                strcat(buf, " (value range error)");
                break;
            case -9:
                strcat(buf, " (CASE value range error)");
                break;
            case -12:
                strcat(buf, " (bus error)");
                break;
            case -20:
                strcat(buf, " (stopped by user)");
                break;
        }
    }
    return buf;
}


int _Escape(code)
int code;
{
    char buf[100];

    P_escapecode = code;
    if (code == 0)
        exit(0);
    if (code == -1)
        exit(1);
    fprintf(stderr, "%s\n", _ShowEscape(buf, P_escapecode, P_ioresult, ""));
    exit(1);
}

int _EscIO(code)
int code;
{
    P_ioresult = code;
    return _Escape(-10);
}




/* End. */




/* Output from p2c, the Pascal-to-C translator */
/* From input file "nl.p" */


/* copyright (C) 1986 by the Regents of the University of California */


/* STRUTL has no data dependancies ...  first in .makeo file */

/* Pad String pads a string constant to a M4 known size  - pjm 1/88*/



/* SETUTL has on data dependancies ...
   second in .makeo file */
/* IF1INIT no dependancies..
   third in .makeo file */

/* FILUTL depends on STRUTL,
   Include fourth in .makeo files */
/* PARUTL depends on STRUTL, FILUTL,
   Include fifth in .makeo files   */
/* Graph.m4 depends on STRUTL, IF1INIT, SETUTL.
   Include sixth in the .makeo file      */



/* IF1INPUT depends on STRUTL, IF1INIT, GRAPH.
   Include seventh in .makeo file                */

/* IF1DUMP depends on STRUTL, GRAPH, and IF1INPUT
   eighth in .makeo file                          */





/*  global constants here */

/*#TITLE  STRUTL  CONSTANTS       Jan82   String Handling Routines.*/

#define maxstringchars  80
/* changed from 132 */
/*mlw*/

#define blankstring     "                                                                                "

#define maxbigint       LONG_MAX



/* Constants from setutl.m4 */
/* The maximum size of a set of integers */

#define maxsetsize      6000   /*mlw*/


/*#TITLE  IF1INIT CONSTANTS       Oct83   Standard IF1 Constants*/
/*Constants derived from v9.me 84/7/26 by sks*/

#define ifmaxnamelen    15   /* dlz -8/87 for the name tables */

#define ifmaxnode       195

/*Node */
#define ifnforall       0
#define ifnselect       1
#define ifntagcase      2
#define ifnloopa        3
#define ifnloopb        4
#define ifnifthenelse   5   /*mlw - 2/3/86*/
#define ifniter         6
#define ifnmodule       20   /* jwrg */
#define ifngraph        21   /* jwrg */

#define ifnaaddh        100
#define ifnaaddl        101
#define ifnaextract     102
#define ifnabuild       103
#define ifnacatenate    104
#define ifnaelement     105
#define ifnafill        106
#define ifnagather      107
#define ifnaisempty     108
#define ifnalimh        109
#define ifnaliml        110
#define ifnaremh        111
#define ifnareml        112
#define ifnareplace     113
#define ifnascatter     114
#define ifnasetl        115
#define ifnasize        116
#define ifnabs          117
#define ifnbindarguments  118
#define ifnbool         119
#define ifncall         120
#define ifnchar         121
#define ifndiv          122
#define ifndouble       123
#define ifnequal        124
#define ifnexp          125
#define ifnfirstvalue   126
#define ifnfinalvalue   127
#define ifnfloor        128
#define ifnint          129
#define ifniserror      130
#define ifnless         131
#define ifnlessequal    132
#define ifnmax          133
#define ifnmin          134
#define ifnminus        135
#define ifnmod          136
#define ifnneg          137
#define ifnnoop         138
#define ifnnot          139
#define ifnnotequal     140
#define ifnplus         141
#define ifnrangegenerate  142
#define ifnrbuild       143
#define ifnrelements    144
#define ifnrreplace     145
#define ifnredleft      146
#define ifnredright     147
#define ifnredtree      148
#define ifnreduce       149
#define ifnallbutlastvalue  150
#define ifnsingle       151
#define ifntimes        152
#define ifntrunc        153
#define ifnaprefixsize  154
#define ifnareplacen    160
#define ifnspawn        161
#define ifnfilter       168
#define ifnashift       169

/*IF2 Nodes*/

#define ifnaaddlat      170
#define ifnaaddhat      171
#define ifnabufpartition  172
#define ifnabuildat     173
#define ifnabufscatter  174
#define ifnacatenateat  175
#define ifnaelementsat  176
#define ifnaextractat   177
#define ifnafillat      178
#define ifnagatherat    179
#define ifnaremhat      180
#define ifnaremlat      181
#define ifnareplaceat   182
#define ifnarraytobuf   183
#define ifnasetlat      184
#define ifndefarraybuf  185
#define ifndefrecordbuf  186
#define ifnfinalvalueat  187
#define ifnmemalloc     188
#define ifnrbufelements  189
#define ifnrbuildat     190
#define ifnrecordtobuf  191
#define ifnrelementsat  192
#define ifnreduceat     193
#define ifnshiftbuffer  194
#define ifncondsetrefcnt  195

#define ifmaxerror      12

/*ErrorType */
/* genuine errors must be all < IFENoError */
#define ifebroken       0
#define ifeerror        1
#define ifemiselt       2
#define ifenegover      3
#define ifenegunder     4
#define ifeposover      5
#define ifeposunder     6
#define ifeundef        7
#define ifeunknown      8
#define ifezerodivide   9
#define ifenoerror      10   /*rky, means value present, not an error */
#define ifenovalue      11
    /*rky, means no value present, not even an error */
#define ifmrnovalue     12   /*dlz no min reeval previous value */

/*TypeTableEntry */

#define ifmaxtype       11

#define iftarray        0
#define iftbasic        1
#define iftfield        2
#define iftfunctiontype  3
#define iftmultiple     4
#define iftrecord       5
#define iftstream       6
#define ifttag          7
#define ifttuple        8
#define iftunion        9
#define iftwild         10
#define iftbuffer       11

/*BasicType */

#define ifmaxbasic      6

#define ifbboolean      0
#define ifbcharacter    1
#define ifbdouble       2
#define ifbinteger      3
#define ifbnull         4
#define ifbreal         5
#define ifbwild         6

/* types of reduction operations */
#define ifmaxreduction  5

#define ifrsum          0
#define ifrproduct      1
#define ifrleast        2
#define ifrgreatest     3
#define ifrcatenate     4
#define ifrappend       5
    /* rky 10dec84. AGather is just a kind of multiple reduction */


/* PARUTL TYPESApril 84Parameter Handling Constants*/
#define maxinfile       9

#define parflagchar     "-"
#define parsepchar      " "
#define parsplitchar    " "
#define parargchar      " "



/*dlz - 8/87 added new functions: NewTypeAlloc, NewEdgeAlloc, and
  NewNodeAlloc to consolidate and replace various allocation and
  initialization sequences throughout.  Also, made compilation
  of vivek's extra edge and node fields conditional.  Some new
  macros, etc. for simplification, fixed errors in some existing
  macro definitions, general "cleanup" and correction */


/* Constants from graph.m4 */
/* The number of the first Atomic node sort */

#define firstatom       100

/* The maximum number of Type Table Entries handled */
#define entrymax        1000

/* Constant for internal pragmas (for Vivek) */
#define extrainfomax    15

/* for Bit Marks set in node record */
#define maxbitrange     29




/*  global types here */

/*#TITLE  STRUTL  TYPES           Jan82   String Handling Routines.*/

typedef Char stryngar[maxstringchars];

typedef struct stryng {
  char len;
  stryngar str;
} stryng;

typedef Char str10[10];
typedef Char str20[20];


/* Types from setutl.m4 */
typedef unsigned char bitbucket[(maxsetsize + 7) / 8];   /*mlw*/
/*mlw*/

typedef struct setofint {
  short count;   /* number of elements in the set */
  short maxsize;   /* max numb of elements set can hold */
  bitbucket inset;   /* bit vector, true means ele in set */
} setofint;


/*#TITLE  IF1INIT TYPES             IFNAug83   Standard IF1 Types*/

/* Printable Name */
typedef Char printable[16];


/* Nodes */

/* Error Values */

/* Type Values */

/* Basic Values */

/* Types for reduction operations */

typedef enum {
  ifgfunction, ifgselector, ifgalternative, ifgvariant, ifgloopainit,
  ifgloopabody, ifgloopatest, ifgloopareturns, ifgloopbinit, ifgloopbbody,
  ifgloopbtest, ifgloopbreturns, ifgforallgenerator, ifgforallbody,
  ifgforallreturns, ifgifpredicate, ifgiftrue, ifgiffalse, ifgiterbody
} ifgraphtype;


/*dlz - 8/87*/
typedef enum {
  unaryalgeb, binaryalgeb, multiplereduct, multiplefilter, multiplegenr,
  structureaccess, structurebuild, indexchange, bufferaccess, bufferbuild,
  bufferreduct, buffergenr, bufferdefine, controlabstr, functioninvoke,
  graphnode, unclassified, unknown
} ndclasstype;






/*#TITLE  PARUTL  TYPES           Jan82   Parameter Handling Routines.*/

typedef enum {
  intpar, boolpar, strpar, ifilpar, ofilpar, flagpar, restpar
} partyp;
typedef struct parrec *infilelist[maxinfile];

typedef struct parrec {
  str10 longname, shortname;
  partyp partype;
  long normpos, specpos;
  stryng parvalue;
  struct parrec *nextpar;
} parrec;


/* Types from graph.m4 */
/* Type Table Entries
      STId -a special value used for dumping out if1 programs and
              for checking multiple definitions.
      STLabel - The label of the IF1 type entry.  Also used for type
                smashing.
      STEquivChain - Used for type smashing.
      STLiteral - The name of the type (if there is one).
      STSize - Amount of memory an object of this type requires. Used
               in IF1offset.
      STRecurFlag - Whether or not this type is recursive.
*/


typedef struct stentry {
  long stid, stlabel;   /*sks*/
  struct stentry *stequivchain;   /*sks*/
  stryng stliteral;   /*mlw*/
  long stsize;
  boolean strecurflag;   /*jef 10/1/85*/
  char stsort;
  union {
    char stbasic;
    struct {
      struct stentry *starg, *stres;
    } U3;
    struct stentry *stbasetype;
    struct {
      struct stentry *stelemtype, *stnext;
    } U2;
  } UU;
} stentry;


typedef double extrainfo[extrainfomax];   /*for vivek*/

/* Ports
   Each node has a list of input and output ports.  A single structure is
   used for Literals and Edges.  Edges have some extra fields descibing
   the source Port.  The fields are used as follows:
     PTType - points to a symbol table entry giving the type of the
                port.
     PTToNode - points to the node which is destination of the edge or
                literal.
     PTToPort - gives the number of this port.
     PTToNext - points to the next input port for the destination node.
     PTName - gives the a symbolic name associated with this edge (if avail.)
     PTIF1Line - the line number of the if1 file that defined this edge.
     PTSrcLine - the line number of the SISAL text file where this edge is
                 created.
     PTWiLine - the column of the SISAL text file where this edge is
                 created.
     PTId - Global ID for this edge.  Does not correspond to anything in
            the IF1 test file.
     PTMark - ByValue, ByReference or Destroy pragma.
               Destoy means this is the last reference and the value may be removed.
     PTDFAddr - AR offset pragma.
     PTLBound, PTUBound - lower and upper bound pragma.
     PTNextEdge - Used by DI for associating similar edges.
     PTClass - ???
   Extra fields for Edges:
     PTFrNode - points to the origin node.
     PTFrPort - indicates the number of the output port.
     PTFrNext - points to the next output port for the origin node.
   Extra fields for Literals:
     PTLitValue - value of the literal edge stored in Stryng format.
 */

typedef enum {
  byref, byval, destroy
} egmark;   /***NEW** no ByDefault*/

typedef enum {
  ptlit, ptedge, ptdep, ptundef
} portsort;

typedef enum {
  pcuncoded, pccoded
} portclass;


/*mlw - more descriptive name*/

typedef struct port {
  stentry *pttype;
  struct node *pttonode;
  long pttoport;
  egmark ptmark;   /*mlw  - pass by value or reference */
  long ptif1line;   /* sks for structure analysis reporting */
  long ptsrcline, ptwiline;
  struct port *pttonext;
  stryng ptname;   /*mlw*/
  long ptid;   /*mlw*/
  long ptlbound, ptubound;   /* mlw, lower and upper bounds pragmas */
  long ptsetrc, ptconmodrc, ptprodmodrc;
      /* rjs, set & modify ref count pragmas */
  long ptdfaddr, ptmraddr;   /* dlz, for MinReeval offsets */
  struct port *ptnextedge;
  portclass ptclass;

  portsort ptsort;
  union {
    struct {
      struct node *ptfrnode;
      long ptfrport;
      struct port *ptfrnext;
    } U1;
    stryng ptlitvalue;
  } UU;
} port;

/* Graphs
   Each compound node has a list of subsidiary graphs. Each graph is
   accessed via the special Graph node.
 */


typedef struct graph {
  struct node *grnode;
  struct graph *grnext;
} graph;

/* Nodes
    Nodes are either Simple nodes, Compound nodes, or Graph nodes.
    Further, a Graph node may be a Function graph (in which case it
    has an associated Linkage record) or a subgraph of a compound node.

    NDId - A global identifier with no counterpart in IF1 text files.
    NDCode - The opcode of this node, e.g. IFNPlus, IFNSelect, IFNGraph.
    NDMisc - an integer (or set of bits) for miscellaneous use.
    NDLabel - Label of the node within a graph.  Graph nodes always have
              a label of zero.
    NDLine - Line number in the IF1 text file where this node was defined.
    NDSrcLine - Line number within the SISAL text file that defined this
                node.
    NDWiLine - column number in SISAL text file where this node was defined.
    NDXCoord, NDYCoord - (X,Y) coordinate pargmas
    NDParent - If the node is Simple or Compound then Parent is the
               graph node corresponding to the graph immediately containing
               this node.  If the node is a Graph node representing a
               subgraph of a compound node the Parent is the compound
               node.If the node is a Function graph node then the
               parent is the dummy compound node called "Module".
    NDNext - The nodes of a graph are connected in a linked list.  This
             field points to the next node in the list.  The NDNext
             fields of Graph nodes point to the first (simple or compound)
             node of the graph it defines.
    NDNextInLine - A pointer to the next node of the IF1 graph that
                   came from the same source line.  Used by DI.
    NDIList - A pointer to the list of input edges of the node.  CAUTION:
              No fan-in is allowed.  Therefore, the input edges of a
              GRAPH node are the edges where the values LEAVE the graph.
    NDOList - A pointer to the list of output edges of the node.  On a
              GRAPH node, these are the edges where values ENTER the graph.
    NDDepIList - A pointer to the list of dependence edges that are input
              to the node.  NOTE: there can be fan-in of dependence edges.
              The input port of all dep edges is port 0.
    NDDepOList - A pointer to the list of dependence edges that are output
              by the node.  The output port of all dep edges is port 0.
 Fields for Graph nodes only:
    NDLink - A pointer to the Linkage record if this node represents a
             function graph node.
    NDType - A pointer into the type table used only for Function graph
             nodes.  Subgraphs of Compound nodes have a nil type.
 Fields for Compound nodes only:
    NDSubsid - a pointer to a list of subgraphs.
    NDAssoc - a pointer to an association list used to associate tag
              numbers with subgraphs of a TAGCASE nodes.
*/


typedef struct assoclist {
  long graphnum;
  struct assoclist *next;
} assoclist;

typedef enum {
  ndatomic, ndgraph, ndcompound, ndundef
} nodesort;



typedef union intbitset {
  long numb;
  long bits;
} intbitset;

typedef struct node {
  long ndid, ndcode;
  intbitset ndmisc;   /* dlz (new) -- for miscellaneous uses */
  long ndlabel;   /* sks for structure analysis reporting */
  long ndline;   /* sks for structure analysis reporting */
  long ndsrcline, ndwiline;   /* mlw, Source Line and Within Line markers */
  long ndxcoord, ndycoord;   /* mlw, X and Y coordinates - graphics */
  struct node *ndparent, *ndnext;
  port *ndilist, *ndolist, *nddepilist, *nddepolist;
  struct node *ndnextinline;
  double ndfrequency;   /*rjs, pragma for vivek */
  long ndexpanded;   /* rjs, pragma for vivek */

  nodesort ndsort;
  union {
    struct {
      struct linkrec *ndlink;
      stentry *ndtype;
      long ndfirstmro, ndlastmro;   /* dlz, added for MR */
    } U1;
    struct {
      graph *ndsubsid;
      assoclist *ndassoc;
    } U2;
  } UU;
} node;

/* Linkage Records
   Each Function in a compilation unit has a record associating the
   appropriate Graph node with a string used to identify the function
   in literals.
   LKSort - Is it a Local (G), Imported (I), or Exported (X) function.
   LKGraph - a pointer to the Function graph node.
   LKName - The name of the function.
   LKModuleName - Name of the Module this function resides in
   LKARSize - Number of DATUMS in an AR for this function (pragma).
   LKMRSize - Number of Datums in an MRV for this function (someday a pragma?)
   LKExpand - Marked to be expanded inline or not (pragma).
   LKARIndex - a field for DI internal use.
   LKNext - pointer to the next linkage record in this module.
 */

typedef enum {
  lslocal, lsimported, lsexported
} linksort;

typedef struct linkrec {
  linksort lksort;
  node *lkgraph;
  stryng lkname, lkmodulename;
  long lkarsize;   /*mlw - Size of activation record for this fun*/
  long lkmrsize;   /*dlz - Size of MR value record for this fun */
  boolean lkexpand;   /*mlw - Is this function inline expandable? */
  long lkarindex;
  struct linkrec *lknext;
} linkrec;





/* Include global variables here */
Static parrec *paramlist;

/*#TITLE  IF1INIT VARIABLES         IFNAug83   Standard IF1 Variables*/

Static printable nodename[ifmaxnode + 1];

Static printable errvname[ifmaxerror + 1];

Static printable typename[ifmaxtype + 1];

Static printable basename[ifmaxbasic + 1];

Static printable graphname[19];

Static ndclasstype nodeclass[ifmaxnode + 1];   /* dlz - 8/87 */



Static long startclock, startsysclock;



Static FILE *source, *diag;
Static infilelist infile;
Static parrec *outfile;
Static boolean timingflag;


/* these vars are needed by module using the graph */
Static stentry *typetable[entrymax];
Static long tthwm;   /* symbol table high water mark */
Static long univmodulecnt, univnodecnt, univedgecnt;
Static linkrec *funclist;
Static node *firstfunction, *module;
Static stryng stamp['[' - 'A'];
Static long stampset[9];


Static node *funct, *temp;


/* Include all desired functions and procedures here */


/*#TITLE  STRUTL  ROUTINES        Jan83   String Handling Routines.*/

/* macro function IsDigit( C: char ): boolean */

/* macro function IsHexOnly( C: char ): boolean */

/* macro function IsLowerCase( C: char ): boolean */

/* macro function IsUpperCase( C: char ): boolean */

/* macro procedure MakeLowerCase( var C: char ) */

/* macro procedure MakeUpperCase( var C: char ) */

/* macro function StringLength( S: Stryng ): integer */

/* macro function IsEmptyString( S: Stryng ): boolean */

Static Char stringchar(s, n)
stryng *s;
long n;
{
  if (n > s->len)
    return ' ';
  else
    return (s->str[n - 1]);
}


Static Void clearstring(s, first, last)
stryng *s;
char first, last;
{
  char i;

  for (i = first - 1; i < last; i++)
    s->str[i] = ' ';
  s->len = first - 1;
}


Static Void clearstringtoend(s)
stryng *s;
{
  /* rky Oct87 */
  char i;

  for (i = s->len; i < maxstringchars; i++)
    s->str[i] = ' ';
}


/* macro procedure InitString( S: Stryng )  */

Static Void insertchar(s, c, p)
stryng *s;
Char c;
char p;
{
  long i;

  if (s->len < p - 1)
    s->len = p - 1;
  if (s->len != maxstringchars)
    s->len++;
  for (i = s->len; i > p; i--)
    s->str[i - 1] = s->str[i - 2];
  s->str[p - 1] = c;
}


Static Void concatchar(s, c)
stryng *s;
Char c;
{
  if (s->len < maxstringchars) {
    s->len++;
    s->str[s->len - 1] = c;
  }
}


Static Void concatnchars(s, c, n)
stryng *s;
Char c;
long n;
{
  long i;

  for (i = 1; i <= n; i++)
    concatchar(s, c);
}


/* macro procedure CharString( S: Stryng; C: Char ) */

Static Void stripspaces(s)
stryng *s;
{
  boolean spaces;

  spaces = (s->len > 0);
  while (spaces) {
    if (s->str[s->len - 1] != ' ') {
      spaces = false;
      break;
    }
    s->len--;
    if (s->len == 0)
      spaces = false;
  }
}


Static Void string10(s, s10)
stryng *s;
Char *s10;
{
  long i;

  for (i = 0; i <= 9; i++)
    s->str[i] = s10[i];
  clearstring(s, 11, maxstringchars);
  stripspaces(s);
}


Static Void string20(s, s20)
stryng *s;
Char *s20;
{
  long i;

  for (i = 0; i <= 19; i++)
    s->str[i] = s20[i];
  clearstring(s, 21, maxstringchars);
  stripspaces(s);
}


Static Void stringn(s, sn, count)
stryng *s;
Char *sn;
long count;
{

  /* Name:                   StringN
     Purpose:                Build a Stryng of a specified number of characters
                             from the given character string.  Trailing blanks
                             are not deleted.
     Method:                 This is a slight generalization of the String10
                             routine of STRUTL which is needed for debug messages.
                             The STRUTL package is used to do the work.
     Calling Form:           StringN(string, 'message string', 14 )
     Author:                 J. Engle, 3/13/84
     Modified:
     Input Arguments:        sN     : the character string to put into s
                             Count  : the number of characters (including trailing
                                        blanks) of sN to use
     Output Arguments:       s      : the resulting Stryng
     Input/Output Arguments: (none)
     Packages Used:          STRUTL.ROUTINES
     Notes:
       */
  long realcount;   /*refinement of the argument Count*/
  long i;   /*loop index*/

  realcount = count;
  if (count > maxstringchars)
    realcount = maxstringchars;
  for (i = 0; i < realcount; i++)
    s->str[i] = sn[i];
  if (realcount < maxstringchars)
    clearstring(s, (int)(realcount + 1), maxstringchars);
  s->len = realcount;
}


Static Void insertstring(s, t, p)
stryng *s, *t;
char p;
{
  long i, j, FORLIM;

  if (s->len < p - 1)
    s->len = p - 1;
  if (s->len + t->len <= maxstringchars)
    s->len += t->len;
  else
    s->len = maxstringchars;
  FORLIM = p + t->len - 1;
  for (i = s->len - 1; i >= FORLIM; i--)
    s->str[i] = s->str[i - t->len];
  if (s->len < p + t->len)
    j = s->len;
  else
    j = p + t->len - 1;
  for (i = p; i <= j; i++)
    s->str[i - 1] = t->str[i - p];
}


/* macro procedure ConcatString( var S: Stryng; T: Stryng ) */

Static Void readstring(fil, s)
FILE **fil;
stryng *s;
{
  Char ch;

  s->len = 0;
  while (!P_eoln(*fil) && s->len < maxstringchars) {
    s->len++;
    ch = getc(*fil);
    if (ch == '\n')
      ch = ' ';
    s->str[s->len - 1] = ch;
  }
  if (s->len < maxstringchars)
    clearstring(s, s->len + 1, maxstringchars);
  fscanf(*fil, "%*[^\n]");
  getc(*fil);
}


Static boolean readstringok(fil, s)
FILE **fil;
stryng *s;
{

  /* Same as ReadString, but returns FALSE if line had more than MaxStringChars. */
  boolean Result;
  Char ch;

  s->len = 0;
  while (!P_eoln(*fil) && s->len < maxstringchars) {
    s->len++;
    ch = getc(*fil);
    if (ch == '\n')
      ch = ' ';
    s->str[s->len - 1] = ch;
  }
  if (s->len < maxstringchars)
    clearstring(s, s->len + 1, maxstringchars);
  Result = P_eoln(*fil);
  fscanf(*fil, "%*[^\n]");
  getc(*fil);
  return Result;
}


Local boolean isletter(c)
Char c;
{
  if (islower(c))
    return true;
  else if (isupper(c))
    return true;
  else if (c == '_' || c == '-' || c == '.')
    return true;
  else
    return false;
}  /* IsLetter */


Static Void readidentifier(fil, s)
FILE **fil;
stryng *s;
{
  /* reads a string of the form [Letter | Digit]* */
  Char ch;
  boolean finished;

  finished = false;
  s->len = 0;
  while (!finished) {
    if (P_eoln(*fil)) {
      finished = true;
      break;
    }
    ch = P_peek(*fil);
/* p2c: nl.p, line 907:
 * Note: File parameter fil needs its associated buffers [318] */
    if (!(isletter(ch) || isdigit(ch))) {
      finished = true;
      break;
    }
/* p2c: nl.p, line 911:
 * Note: File parameter fil needs its associated buffers [318] */
    getc(*fil);
    s->len++;
    s->str[s->len - 1] = ch;   /* with */
  }
}  /* ReadIdentifier */


Static Void readifstring(fil, s)
FILE **fil;
stryng *s;
{

  /* Should be used to read a string of characters between
     double quote symbols.  Sets the Length field and pads
     with blank spaces. */
  char i;

  s->len = 0;
  while ((!P_eoln(*fil)) & (P_peek(*fil) != '"'))
    getc(*fil);
/* p2c: nl.p, line 931:
 * Note: File parameter fil needs its associated buffers [318] */
/* p2c: nl.p, line 932:
 * Note: File parameter fil needs its associated buffers [318] */
  if (!P_eoln(*fil))
    getc(*fil);
/* p2c: nl.p, line 934:
 * Note: File parameter fil needs its associated buffers [318] */
  while ((!P_eoln(*fil)) & (P_peek(*fil) != '"')) {
/* p2c: nl.p, line 935:
 * Note: File parameter fil needs its associated buffers [318] */
    s->len++;
    s->str[s->len - 1] = getc(*fil);
    if (s->str[s->len - 1] == '\n')
      s->str[s->len - 1] = ' ';
  }
  if (!P_eoln(*fil))
    getc(*fil);
/* p2c: nl.p, line 940:
 * Note: File parameter fil needs its associated buffers [318] */
  /* now pad with blanks */
  for (i = s->len; i < maxstringchars; i++)
    s->str[i] = ' ';
}  /* ReadIFString */


Static Void readliteralstring(fil, s)
FILE **fil;
stryng *s;
{

  /* Preconditions: (1) string is less than MaxStringChar characters
                   (2) string begins and ends in double quotes
    PostConditions: outside quotes are stripped and string is read
                    into variable S.
    Example:  ""apple"" is read as: "apple"
              "'apple'" is read as: 'apple'
              "apple"   is read as:  apple
    Note:  Backslash is a quoting character
    Example:  ""\""" is read as: "\""
  */
  Char ch;
  long i;
  boolean finished;

  /* read the first two characters, the first must be a double quote */
/* p2c: nl.p, line 967:
 * Note: File parameter fil needs its associated buffers [318] */
  getc(*fil);
  ch = getc(*fil);
  if (ch == '\n')
    ch = ' ';
  s->len = 1;
  s->str[s->len - 1] = ch;
  finished = false;
  while (!finished) {
    ch = getc(*fil);
    if (ch == '\n')
      ch = ' ';
    if (ch == '"') {
      finished = true;
      break;
    }
    if (ch != '\\') {
      s->len++;
      s->str[s->len - 1] = ch;
      continue;
    }
    ch = getc(*fil);
    if (ch == '\n')
      ch = ' ';
    s->str[s->len] = '\\';
    s->len += 2;
    s->str[s->len - 1] = ch;
  }
  /* check to see if string ends in two double quotes, if so,
     one belongs as the last character of the string */
  if (P_peek(*fil) == '"') {
    getc(*fil);
    s->len++;
    s->str[s->len - 1] = '"';
  }
/* p2c: nl.p, line 991:
 * Note: File parameter fil needs its associated buffers [318] */
/* p2c: nl.p, line 993:
 * Note: File parameter fil needs its associated buffers [318] */
  for (i = s->len; i < maxstringchars; i++)
    s->str[i] = ' ';
}  /* ReadLiteralString */


Static Void writestring(fil, s)
FILE **fil;
stryng *s;
{
  long i, FORLIM;

  FORLIM = s->len;
  for (i = 0; i < FORLIM; i++)
    putc(s->str[i], *fil);
}


Static Void writenstring(fil, s, n)
FILE **fil;
stryng s;
long n;
{
  long i;

  for (i = 1; i <= n; i++) {
    if (i > s.len)
      putc(' ', *fil);
    else
      putc(s.str[i - 1], *fil);
  }
}


Static Void substring(t, s, first, last)
stryng *t, *s;
char first;
long last;
{
  long i, FORLIM;

  if (last > s->len)
    last = s->len;
  if (first > last)
    first = last + 1;
  else {
    FORLIM = last - first;
    for (i = 0; i <= FORLIM; i++)
      t->str[i] = s->str[i + first - 1];
  }
  clearstring(t, (int)(last - first + 2), maxstringchars);
}


Static Void deletestring(s, first, last)
stryng *s;
char first;
long last;
{
  long i, offset, FORLIM;

  if (last > s->len)
    last = s->len;
  if (first > last)
    first = last + 1;
  offset = last - first + 1;
  FORLIM = s->len;
  for (i = last; i < FORLIM; i++)
    s->str[i - offset] = s->str[i];
  clearstring(s, (int)(s->len - offset + 1), s->len);
}


Static Char uppercase(c)
Char c;
{
  if (islower(c))
    return _toupper(c);
  else
    return c;
}


Static Void stringuppercase(s)
stryng *s;
{
  long i, FORLIM;

  FORLIM = s->len;
  for (i = 0; i < FORLIM; i++) {
    if (islower(s->str[i]))
      s->str[i] = _toupper(s->str[i]);
  }
}


Static Char lowercase(c)
Char c;
{
  if (isupper(c))
    return _tolower(c);
  else
    return c;
}


Static Void stringlowercase(s)
stryng *s;
{
  long i, FORLIM;

  /*StringLowerCase*/
  FORLIM = s->len;
  for (i = 0; i < FORLIM; i++) {
    if (isupper(s->str[i]))
      s->str[i] = _tolower(s->str[i]);
  }
}


Static boolean matchstrings(s1, s2, pos)
stryng *s1, *s2;
char pos;
{
  long i, ix;
  boolean res;
  long FORLIM;

  /* Convert to offset in index */
  ix = pos - 1;
  /* Check first string is long enough */
  if (s2->len < s1->len + ix)
    return false;
  else {
    res = true;
    FORLIM = s1->len;
    for (i = 0; i < FORLIM; i++) {
      if (s2->str[i + ix] != s1->str[i])
	res = false;
    }
    return res;
  }
}


Static boolean equalstrings(s1, s2)
stryng *s1, *s2;
{
  if (s1->len == s2->len)
    return (matchstrings(s1, s2, 1));
  else
    return false;
}


Static boolean equivstrings(s1, s2)
stryng *s1, *s2;
{
  /* True iff S1=S2 ignoring case differences.  Doesn't change S1 or S2.
     rky added 25May88.  Gotos are fun! */
  boolean Result;
  long i, diff, caseshift;
  stryng *WITH;

  WITH = s1;   /*with*/
  if (WITH->len != s2->len)
    goto _L2;
  Result = true;
  caseshift = 'A' - 'a';
  i = 0;
_L1:   /* top of loop */
  if (i == WITH->len)
    goto _L3;
  i++;
  diff = s2->str[i - 1] - WITH->str[i - 1];
  if (diff == 0)
    goto _L1;
  if (diff == caseshift) {
    if (islower(WITH->str[i - 1]))   /* else fall through to fail */
      goto _L1;
  } else if (diff == -caseshift) {
    if (isupper(WITH->str[i - 1]))   /* else fall through to fail */
      goto _L1;
  }
_L2:
  Result = false;   /*fail*/
_L3:   /*succeed*/
  return Result;

  /* else fall through to fail */
}


Static long findchar(c, s, pos)
Char c;
stryng *s;
char pos;
{
  long Result, i;

  Result = 0;
  for (i = s->len; i >= pos; i--) {
    if (s->str[i - 1] == c)
      Result = i;
  }
  return Result;
}


Static long findstring(s, t, pos)
stryng *s, *t;
char pos;
{
  long chpos;
  boolean match;

  if (s->len == 0)
    return pos;
  else {
    match = false;
    chpos = pos - 1;
    do {
      chpos = findchar(s->str[0], t, (int)(chpos + 1));
      if (chpos != 0)
	match = matchstrings(s, t, (int)chpos);
    } while (!(match || chpos == 0));
    return chpos;
  }
}


Static long findlastchar(c, s)
Char c;
stryng *s;
{
  long Result, i, FORLIM;

  Result = 0;
  FORLIM = s->len;
  for (i = 1; i <= FORLIM; i++) {
    if (s->str[i - 1] == c)
      Result = i;
  }
  return Result;
}


Static Void numberstring(s, n, base)
stryng *s;
long n, base;
{
  long sign, ch;

  memcpy(s->str, blankstring, sizeof(stryngar));
  s->len = 0;
  if (n < 0)
    sign = -1;
  else
    sign = 1;
  do {
    ch = sign * (n % base);
/* p2c: nl.p, line 1219:
 * Note: Using % for possibly-negative arguments [317] */
    if (ch < 10)
      ch += '0';
    else
      ch += '7';
    insertchar(s, (Char)ch, 1);
    n /= base;
  } while (n != 0);
  if (sign == -1)
    insertchar(s, '-', 1);
}


Static Void integerstring(s, n, width)
stryng *s;
long n, width;
{
  numberstring(s, n, 10L);
  while (s->len < width)
    insertchar(s, ' ', 1);
}


Static long charval(ch)
Char ch;
{
  ch = uppercase(ch);
  if (isdigit(ch))
    return (ch - '0');
  else {
    if (ch >= 'A' && ch <= 'F')
      return (ch - 55);
    else
      return 16;
  }
}


Static long stringnumber(s, pos, base)
stryng *s;
long *pos, base;
{
  long maxdivbase, maxmodbase, newval, res;
  boolean neg;

  /* StringNumber */
  neg = false;
  if (base < 2 || base > 16)
    base = 16;
  maxdivbase = maxbigint / base;
  maxmodbase = maxbigint % base;
  res = 0;
  while (*pos < s->len && s->str[*pos - 1] == ' ')
    (*pos)++;
  if (s->str[*pos - 1] == '-' || s->str[*pos - 1] == '+') {
    if (s->str[*pos - 1] == '-')
      neg = true;
    (*pos)++;
  }
  while (*pos < s->len && s->str[*pos - 1] == ' ')
    (*pos)++;
  while ((res >= 0) & (charval(s->str[*pos - 1]) < base)) {
    newval = charval(s->str[*pos - 1]);
    if (res < maxdivbase || res == maxdivbase && newval <= maxmodbase) {
      res = res * base + newval;
      (*pos)++;
    } else
      res = -maxbigint;
  }
  if (neg)
    return (-res);
  else
    return res;
}


/* macro function StringNumber( S: Stryng; Pos: integer ): integer */



/* Procedures and Functions from setutl.m4 */

Static Void makeemptyset(iset, size)
setofint *iset;
short size;
{

  /* pre  : none
     post : maxsize := size; cardinality := 0;
            bitvector set to all false values */
  short element;

  iset->count = 0;
  iset->maxsize = size;
  for (element = 0; element < size; element++)
    P_clrbits_B(iset->inset, element, 0, 3);
}  /* MakeEmptySet */


/* macro function SizeOfSet ( Iset : SetOfInt ) : integer; */
/* pre  : none
   post : returns cardinality of this set */

/* macro function IsEmptySet ( Iset : SetOfInt ) : boolean; */
/* pre  : none
   post : returns true only if (cardinality = 0)  */

Static Void addtoset(element, iset)
short element;
setofint *iset;
{

  /* pre  : none
     post : if (element > maxsize) or (element already in set) then
               nothing happens
            otherwise
               add element to set and increment cardinality           */
  if (element > iset->maxsize)   /* otherwise do nothing */
    return;
  if (!P_getbits_UB(iset->inset, element - 1, 0, 3)) {
    iset->count++;
    P_putbits_UB(iset->inset, element - 1, 1, 0, 3);
  }
}  /* AddToSet */


Static Void removefromset(element, iset)
short element;
setofint *iset;
{

  /* pre  : none
     post : if (element > maxsize) or (element not in set) then
              nothing happens
           otherwise
              remove element from set and decrement cardinality       */
  if (element > iset->maxsize)   /* otherwise do nothing */
    return;
  if (P_getbits_UB(iset->inset, element - 1, 0, 3)) {
    iset->count--;
    P_clrbits_B(iset->inset, element - 1, 0, 3);
  }
}  /* RemoveFromSet */


Static boolean isinset(element, iset)
short element;
setofint iset;
{

  /* pre  : none
     post : returns true if both (element <= maxsize) and (element is
                                  in the set)
                        otherwise returns false                       */
  if (element > iset.maxsize)
    return false;
  else
    return P_getbits_UB(iset.inset, element - 1, 0, 3);
}  /* IsInSet */


Static Void getsetelement(element, iset)
short *element;
setofint *iset;
{

  /* pre  : none
     post : if cardinality = 0 then
              sets element := 0  and does not change Set
           else
              finds an (arbitrary) element in the set
              returns this element
              and removes it from the set                             */
  long TEMP1;

  if (iset->count == 0) {
    *element = 0;
    return;
  }
  *element = 1;
  while (!(TEMP1 = *element - 1, P_getbits_UB(iset->inset, TEMP1, 0, 3)))
    (*element)++;
  TEMP1 = *element - 1;
  P_clrbits_B(iset->inset, TEMP1, 0, 3);
  iset->count--;
}  /* GetSetElement */


Static boolean issubset(subset, bigset)
setofint subset, bigset;
{

  /* pre  : none
     post : returns false if (maxsize of subset > maxsize of bigset)
            otherwise returns true only if subset is contained in
                                          bigset                     */
  short element;
  boolean stopcondition;

  if (subset.maxsize > bigset.maxsize || subset.count > bigset.count)
    return false;
  else {
    element = 1;
    stopcondition = false;
    while (element <= subset.maxsize && !stopcondition) {
      if (P_getbits_UB(subset.inset, element - 1, 0, 3))
	stopcondition = !P_getbits_UB(bigset.inset, element - 1, 0, 3);
      element++;
    }
    return (!stopcondition);
  }
}  /* IsSubset */


Static Void setunion(set1, set2, newset)
setofint set1, set2, *newset;
{

  /* pre  : none
     post : sets maxsize of newset to the maximum of [maxsize of set1,
            maxsize of set2]
            puts element in newset only if it is in set1 or set2      */
  short element;

  if (set1.maxsize >= set1.maxsize) {
    *newset = set1;
    for (element = 0; element < set2.maxsize; element++) {
      if (P_getbits_UB(set2.inset, element, 0, 3)) {
	if (!P_getbits_UB(set1.inset, element, 0, 3)) {
	  P_putbits_UB(newset->inset, element, 1, 0, 3);
	  newset->count++;
	}
      }
    }
    return;
  }
  *newset = set2;
  for (element = 0; element < set1.maxsize; element++) {
    if (P_getbits_UB(set1.inset, element, 0, 3)) {
      if (!P_getbits_UB(set2.inset, element, 0, 3)) {
	P_putbits_UB(newset->inset, element, 1, 0, 3);
	newset->count++;
      }
    }
  }
}  /* SetUnion */


Static Void setdifference(set1, set2, newset)
setofint set1, set2, *newset;
{

  /* pre  : none
     post : sets maxsize of newset := maxsize of set1
            puts element in newset only if it is in set1 and it is not
            in set2.   i.e. newset = set1 - set2.                     */
  short size, element;

  *newset = set1;   /* initialize the newset to be the same as set1 */
  if (set1.maxsize >= set2.maxsize)
	/* remove all elements of set1 that are in set2 */
	  size = set2.maxsize;
  else
    size = set1.maxsize;
  for (element = 0; element < size; element++) {
    if (P_getbits_UB(set2.inset, element, 0, 3)) {
      newset->count--;
      P_clrbits_B(newset->inset, element, 0, 3);
    }
  }
}  /* SetDifference */




/*#TITLE  IF1INIT ROUTINES          IFNAug83   Standard IF1 Routines*/

Static Void initnames()
{
  long i;

  /* InitNames */
  /* Node Identifiers */
  for (i = 0; i <= ifmaxnode; i++)
    memcpy(nodename[i], "*************** ", sizeof(printable));

  /* Compound Nodes */
  memcpy(nodename[ifnselect], "Select          ", sizeof(printable));
  memcpy(nodename[ifnloopb], "LoopB           ", sizeof(printable));
  memcpy(nodename[ifnloopa], "LoopA           ", sizeof(printable));
  memcpy(nodename[ifnforall], "Forall          ", sizeof(printable));
  memcpy(nodename[ifntagcase], "TagCase         ", sizeof(printable));
  memcpy(nodename[ifnmodule], "Module          ", sizeof(printable));
  memcpy(nodename[ifnifthenelse], "IfThenElse      ", sizeof(printable));
  memcpy(nodename[ifniter], "Iter            ", sizeof(printable));

  /* Simple Node */
  memcpy(nodename[ifnaaddh], "AAddH           ", sizeof(printable));
  memcpy(nodename[ifnaaddl], "AAddL           ", sizeof(printable));
  memcpy(nodename[ifnaextract], "AExtract        ", sizeof(printable));
  memcpy(nodename[ifnabuild], "ABuild          ", sizeof(printable));
  memcpy(nodename[ifnacatenate], "ACatenate       ", sizeof(printable));
  memcpy(nodename[ifnaelement], "AElement        ", sizeof(printable));
  memcpy(nodename[ifnafill], "AFill           ", sizeof(printable));
  memcpy(nodename[ifnagather], "AGather         ", sizeof(printable));
  memcpy(nodename[ifnaisempty], "AIsEmpty        ", sizeof(printable));
  memcpy(nodename[ifnalimh], "ALimH           ", sizeof(printable));
  memcpy(nodename[ifnaliml], "ALimL           ", sizeof(printable));
  memcpy(nodename[ifnaremh], "ARemH           ", sizeof(printable));
  memcpy(nodename[ifnareml], "ARemL           ", sizeof(printable));
  memcpy(nodename[ifnareplace], "AReplace        ", sizeof(printable));
  memcpy(nodename[ifnascatter], "AScatter        ", sizeof(printable));
  memcpy(nodename[ifnasetl], "ASetL           ", sizeof(printable));
  memcpy(nodename[ifnasize], "ASize           ", sizeof(printable));
  memcpy(nodename[ifnabs], "Abs             ", sizeof(printable));
  memcpy(nodename[ifnbindarguments], "BindArguments   ", sizeof(printable));
  memcpy(nodename[ifnbool], "Bool            ", sizeof(printable));
  memcpy(nodename[ifncall], "Call            ", sizeof(printable));
  memcpy(nodename[ifnchar], "Char            ", sizeof(printable));
  memcpy(nodename[ifndiv], "Div             ", sizeof(printable));
  memcpy(nodename[ifndouble], "Double          ", sizeof(printable));
  memcpy(nodename[ifnequal], "Equal           ", sizeof(printable));
  memcpy(nodename[ifnexp], "Exp             ", sizeof(printable));
  memcpy(nodename[ifnfirstvalue], "FirstValue      ", sizeof(printable));
  memcpy(nodename[ifnfinalvalue], "FinalValue      ", sizeof(printable));
  memcpy(nodename[ifnfloor], "Floor           ", sizeof(printable));
  memcpy(nodename[ifnint], "Int             ", sizeof(printable));
  memcpy(nodename[ifniserror], "IsError         ", sizeof(printable));
  memcpy(nodename[ifnless], "Less            ", sizeof(printable));
  memcpy(nodename[ifnlessequal], "LessEqual       ", sizeof(printable));
  memcpy(nodename[ifnmax], "Max             ", sizeof(printable));
  memcpy(nodename[ifnmin], "Min             ", sizeof(printable));
  memcpy(nodename[ifnminus], "Minus           ", sizeof(printable));
  memcpy(nodename[ifnmod], "Mod             ", sizeof(printable));
  memcpy(nodename[ifnneg], "Neg             ", sizeof(printable));
  memcpy(nodename[ifnnoop], "NoOp            ", sizeof(printable));
  memcpy(nodename[ifnnot], "Not             ", sizeof(printable));
  memcpy(nodename[ifnnotequal], "NotEqual        ", sizeof(printable));
  memcpy(nodename[ifnplus], "Plus            ", sizeof(printable));
  memcpy(nodename[ifnrangegenerate], "RangeGenerate   ", sizeof(printable));
  memcpy(nodename[ifnrbuild], "RBuild          ", sizeof(printable));
  memcpy(nodename[ifnrelements], "RElements       ", sizeof(printable));
  memcpy(nodename[ifnrreplace], "RReplace        ", sizeof(printable));
  memcpy(nodename[ifnreduce], "Reduce          ", sizeof(printable));
  memcpy(nodename[ifnredleft], "ReduceLeft      ", sizeof(printable));
  memcpy(nodename[ifnredright], "ReduceRight     ", sizeof(printable));
  memcpy(nodename[ifnredtree], "ReduceTree      ", sizeof(printable));
  memcpy(nodename[ifnallbutlastvalue], "AllButLastVal   ", sizeof(printable));
  memcpy(nodename[ifnsingle], "Single          ", sizeof(printable));
  memcpy(nodename[ifntimes], "Times           ", sizeof(printable));
  memcpy(nodename[ifntrunc], "Trunc           ", sizeof(printable));
  memcpy(nodename[ifnaprefixsize], "APrefixSize     ", sizeof(printable));
  memcpy(nodename[ifnareplacen], "AReplaceN       ", sizeof(printable));
  memcpy(nodename[ifnspawn], "Spawn           ", sizeof(printable));
  memcpy(nodename[ifnfilter], "Filter          ", sizeof(printable));
  memcpy(nodename[ifnashift], "AShift          ", sizeof(printable));
  memcpy(nodename[ifnarraytobuf], "ArrayToBuf      ", sizeof(printable));
  memcpy(nodename[ifnrecordtobuf], "RecordToBuf     ", sizeof(printable));
  memcpy(nodename[ifnshiftbuffer], "ShiftBuffer     ", sizeof(printable));
  memcpy(nodename[ifnabufscatter], "ABufScatter     ", sizeof(printable));
  memcpy(nodename[ifnabufpartition], "ABufPartition   ", sizeof(printable));
  memcpy(nodename[ifnrbufelements], "RBufElements    ", sizeof(printable));
  memcpy(nodename[ifnabuildat], "ABuildAt        ", sizeof(printable));
  memcpy(nodename[ifnafillat], "AFillAt         ", sizeof(printable));
  memcpy(nodename[ifnareplaceat], "AReplaceAt      ", sizeof(printable));
  memcpy(nodename[ifnasetlat], "ASetLAt         ", sizeof(printable));
  memcpy(nodename[ifnaelementsat], "AElementsAt     ", sizeof(printable));
  memcpy(nodename[ifnacatenateat], "ACatenateAt     ", sizeof(printable));
  memcpy(nodename[ifnaremlat], "ARemLAt         ", sizeof(printable));
  memcpy(nodename[ifnaremhat], "ARemHAt         ", sizeof(printable));
  memcpy(nodename[ifnaaddlat], "AAddLAt         ", sizeof(printable));
  memcpy(nodename[ifnaaddhat], "AAddHAt         ", sizeof(printable));
  memcpy(nodename[ifnaextractat], "AExtractAt      ", sizeof(printable));
  memcpy(nodename[ifnrbuildat], "RBuildAt        ", sizeof(printable));
  memcpy(nodename[ifnrelementsat], "RElementsAt     ", sizeof(printable));
  memcpy(nodename[ifnagatherat], "AGatherAt       ", sizeof(printable));
  memcpy(nodename[ifnreduceat], "ReduceAt        ", sizeof(printable));
  memcpy(nodename[ifnfinalvalueat], "FinalValueAt    ", sizeof(printable));
  memcpy(nodename[ifndefarraybuf], "DefArrayBuf     ", sizeof(printable));
  memcpy(nodename[ifndefrecordbuf], "DefRecordBuf    ", sizeof(printable));
  memcpy(nodename[ifnmemalloc], "MemAlloc        ", sizeof(printable));
  memcpy(nodename[ifncondsetrefcnt], "CondSetRefCnt   ", sizeof(printable));


  /* Graph Names */
  memcpy(graphname[(long)ifgfunction], "Function        ", sizeof(printable));
  memcpy(graphname[(long)ifgselector], "Selector        ", sizeof(printable));
  memcpy(graphname[(long)ifgalternative], "Alternative     ",
	 sizeof(printable));
  memcpy(graphname[(long)ifgvariant], "Variant         ", sizeof(printable));
  memcpy(graphname[(long)ifgloopainit], "LoopAInit       ", sizeof(printable));
  memcpy(graphname[(long)ifgloopabody], "LoopABody       ", sizeof(printable));
  memcpy(graphname[(long)ifgloopatest], "LoopATest       ", sizeof(printable));
  memcpy(graphname[(long)ifgloopareturns], "LoopAReturns    ",
	 sizeof(printable));
  memcpy(graphname[(long)ifgloopbinit], "LoopBInit       ", sizeof(printable));
  memcpy(graphname[(long)ifgloopbbody], "LoopBBody       ", sizeof(printable));
  memcpy(graphname[(long)ifgloopbtest], "LoopBTest       ", sizeof(printable));
  memcpy(graphname[(long)ifgloopbreturns], "LoopBReturns    ",
	 sizeof(printable));
  memcpy(graphname[(long)ifgforallgenerator], "ForallGenerate  ",
	 sizeof(printable));
  memcpy(graphname[(long)ifgforallbody], "ForallBody      ",
	 sizeof(printable));
  memcpy(graphname[(long)ifgforallreturns], "ForallReturns   ",
	 sizeof(printable));
  memcpy(graphname[(long)ifgifpredicate], "IfPredicate     ",
	 sizeof(printable));
  memcpy(graphname[(long)ifgiftrue], "IfTrue          ", sizeof(printable));
  memcpy(graphname[(long)ifgiffalse], "IfFalse         ", sizeof(printable));
  memcpy(graphname[(long)ifgiterbody], "IterBody        ", sizeof(printable));


  /* Error Values */
  memcpy(errvname[ifeerror], "Error           ", sizeof(printable));
  memcpy(errvname[ifeundef], "Undef           ", sizeof(printable));
  memcpy(errvname[ifebroken], "Broken          ", sizeof(printable));
  memcpy(errvname[ifemiselt], "MisElt          ", sizeof(printable));
  memcpy(errvname[ifeposover], "PosOver         ", sizeof(printable));
  memcpy(errvname[ifenegover], "NegOver         ", sizeof(printable));
  memcpy(errvname[ifeposunder], "PosUnder        ", sizeof(printable));
  memcpy(errvname[ifenegunder], "NegUnder        ", sizeof(printable));
  memcpy(errvname[ifezerodivide], "ZeroDivide      ", sizeof(printable));
  memcpy(errvname[ifeunknown], "Unknown         ", sizeof(printable));
  memcpy(errvname[ifenoerror], "NoError         ", sizeof(printable));
  memcpy(errvname[ifenovalue], "NoValue         ", sizeof(printable));
  memcpy(errvname[ifmrnovalue], "NoMRValue       ", sizeof(printable));

  /* Type Values */
  memcpy(typename[iftbasic], "Basic           ", sizeof(printable));
  memcpy(typename[iftfunctiontype], "Function        ", sizeof(printable));
  memcpy(typename[iftarray], "Array           ", sizeof(printable));
  memcpy(typename[iftstream], "Stream          ", sizeof(printable));
  memcpy(typename[iftmultiple], "Multiple        ", sizeof(printable));
  memcpy(typename[iftrecord], "Record          ", sizeof(printable));
  memcpy(typename[ifttuple], "Tuple           ", sizeof(printable));
  memcpy(typename[iftunion], "Union           ", sizeof(printable));
  memcpy(typename[iftfield], "Field           ", sizeof(printable));
  memcpy(typename[ifttag], "Tag             ", sizeof(printable));
  memcpy(typename[iftwild], "Wild            ", sizeof(printable));
  memcpy(typename[iftbuffer], "Buffer          ", sizeof(printable));

  /* Base Type Values */
  memcpy(basename[ifbboolean], "Boolean         ", sizeof(printable));
  memcpy(basename[ifbcharacter], "Character       ", sizeof(printable));
  memcpy(basename[ifbinteger], "Integer         ", sizeof(printable));
  memcpy(basename[ifbreal], "Real            ", sizeof(printable));
  memcpy(basename[ifbdouble], "Double          ", sizeof(printable));
  memcpy(basename[ifbnull], "Null            ", sizeof(printable));
  memcpy(basename[ifbwild], "Wild            ", sizeof(printable));

  /* Node Classifications */

  for (i = 0; i <= ifmaxnode; i++)
    nodeclass[i] = unknown;

  /* Compound Nodes */
  nodeclass[ifnselect] = controlabstr;
  nodeclass[ifnloopb] = controlabstr;
  nodeclass[ifnloopa] = controlabstr;
  nodeclass[ifnforall] = controlabstr;
  nodeclass[ifntagcase] = controlabstr;
  nodeclass[ifniter] = controlabstr;
  nodeclass[ifnifthenelse] = controlabstr;

  /* Not real sure about these .... */
  nodeclass[ifnmodule] = unclassified;
  nodeclass[ifngraph] = graphnode;
  nodeclass[ifncondsetrefcnt] = unclassified;

  /* Simple Node */
  nodeclass[ifnaaddh] = structurebuild;
  nodeclass[ifnaaddl] = structurebuild;
  nodeclass[ifnaextract] = structureaccess;
  nodeclass[ifnabuild] = structurebuild;
  nodeclass[ifnacatenate] = structurebuild;
  nodeclass[ifnaelement] = structureaccess;
  nodeclass[ifnafill] = structurebuild;
  nodeclass[ifnagather] = structurebuild;
  nodeclass[ifnaisempty] = structureaccess;
  nodeclass[ifnalimh] = structureaccess;
  nodeclass[ifnaliml] = structureaccess;
  nodeclass[ifnaremh] = structureaccess;
  nodeclass[ifnareml] = structureaccess;
  nodeclass[ifnareplace] = structurebuild;
  nodeclass[ifnascatter] = multiplegenr;
  nodeclass[ifnasetl] = indexchange;
  nodeclass[ifnasize] = structureaccess;
  nodeclass[ifnabs] = unaryalgeb;
  nodeclass[ifnbindarguments] = functioninvoke;
  nodeclass[ifnbool] = unaryalgeb;
  nodeclass[ifncall] = functioninvoke;
  nodeclass[ifnchar] = unaryalgeb;
  nodeclass[ifndiv] = binaryalgeb;
  nodeclass[ifndouble] = unaryalgeb;
  nodeclass[ifnequal] = binaryalgeb;
  nodeclass[ifnexp] = binaryalgeb;
  nodeclass[ifnfirstvalue] = multiplefilter;
  nodeclass[ifnfinalvalue] = multiplefilter;
  nodeclass[ifnfloor] = unaryalgeb;
  nodeclass[ifnint] = unaryalgeb;
  nodeclass[ifniserror] = unaryalgeb;
  nodeclass[ifnless] = binaryalgeb;
  nodeclass[ifnlessequal] = binaryalgeb;
  nodeclass[ifnmax] = binaryalgeb;
  nodeclass[ifnmin] = binaryalgeb;
  nodeclass[ifnminus] = binaryalgeb;
  nodeclass[ifnmod] = binaryalgeb;
  nodeclass[ifnneg] = unaryalgeb;
  nodeclass[ifnnoop] = unaryalgeb;
  nodeclass[ifnnot] = unaryalgeb;
  nodeclass[ifnnotequal] = binaryalgeb;
  nodeclass[ifnplus] = binaryalgeb;
  nodeclass[ifnrangegenerate] = multiplegenr;
  nodeclass[ifnrbuild] = structurebuild;
  nodeclass[ifnrelements] = structureaccess;
  nodeclass[ifnrreplace] = structurebuild;
  nodeclass[ifnreduce] = multiplereduct;
  nodeclass[ifnredleft] = multiplereduct;
  nodeclass[ifnredright] = multiplereduct;
  nodeclass[ifnredtree] = multiplereduct;
  nodeclass[ifnallbutlastvalue] = multiplefilter;
  nodeclass[ifnsingle] = unaryalgeb;
  nodeclass[ifntimes] = unaryalgeb;
  nodeclass[ifntrunc] = unaryalgeb;
  nodeclass[ifnaprefixsize] = structureaccess;
  nodeclass[ifnareplacen] = structurebuild;
  nodeclass[ifnspawn] = controlabstr;
  nodeclass[ifnfilter] = multiplefilter;
  nodeclass[ifnashift] = indexchange;

  /*IF2 Nodes*/

  nodeclass[ifnarraytobuf] = bufferbuild;
  nodeclass[ifnrecordtobuf] = bufferbuild;
  nodeclass[ifnshiftbuffer] = indexchange;
  nodeclass[ifnabufscatter] = buffergenr;
  nodeclass[ifnabufpartition] = bufferaccess;
  nodeclass[ifnrbufelements] = bufferaccess;
  nodeclass[ifnabuildat] = bufferbuild;
  nodeclass[ifnafillat] = bufferbuild;
  nodeclass[ifnareplaceat] = bufferbuild;
  nodeclass[ifnasetlat] = indexchange;
  nodeclass[ifnaelementsat] = bufferaccess;
  nodeclass[ifnacatenateat] = bufferbuild;
  nodeclass[ifnaremlat] = bufferaccess;
  nodeclass[ifnaremhat] = bufferaccess;
  nodeclass[ifnaaddlat] = bufferbuild;
  nodeclass[ifnaaddhat] = bufferbuild;
  nodeclass[ifnaextractat] = bufferaccess;
  nodeclass[ifnrbuildat] = bufferbuild;
  nodeclass[ifnrelementsat] = bufferaccess;
  nodeclass[ifnagatherat] = bufferreduct;
  nodeclass[ifnreduceat] = bufferreduct;
  nodeclass[ifnfinalvalueat] = bufferreduct;
  nodeclass[ifndefarraybuf] = bufferdefine;
  nodeclass[ifndefrecordbuf] = bufferdefine;
  nodeclass[ifnmemalloc] = bufferdefine;

}




/* copyright (C) 1986 by the Regents of the University of California */


extern long creat PP((Char *name, long mode));

extern long open PP((Char *name, long mode));

extern long close PP((long fildes));

extern Void exit_ PP((long code));


/*#TITLE  FILUTL  ROUTINES        Jul83   File Handling Routines.*/

/*
**  Code for BuildName and Splitname tends to be common to all systems
*/

Static Void buildname(newname, dev, name, ext)
stryng *newname, dev, name, ext;
{
  if (dev.len > 0) {
    *newname = dev;



  } else {
    memcpy(newname->str, blankstring, sizeof(stryngar));
    newname->len = 0;
  }


  if (newname->len < maxstringchars)
    insertstring(newname, &name, newname->len + 1);
  if (ext.len <= 0)
    return;
  concatchar(newname, '.');

  if (newname->len < maxstringchars)
    insertstring(newname, &ext, newname->len + 1);
}



Static Void splitname(origname, dev, name, ext)
stryng *origname, *dev, *name, *ext;
{
  long pos, len;

  /* SplitName */
  *name = *origname;
  pos = findlastchar('.', name);
  if (pos > 0) {
    len = name->len;
    substring(ext, name, (int)(pos + 1), len);
    deletestring(name, (int)pos, len);
  } else {
    memcpy(ext->str, blankstring, sizeof(stryngar));
    ext->len = 0;
  }




  pos = 0;
  if (pos > 0) {
    substring(dev, name, 1, pos - 1);
    deletestring(name, 1, pos);
  } else {
    memcpy(dev->str, blankstring, sizeof(stryngar));
    dev->len = 0;
  }
}


Static Void defaultfilename(name, defname)
stryng *name, *defname;
{
  stryng namedev, namenom, nameext, defdev, defnom, defext;

  /* DefaultFileName */
  splitname(name, &namedev, &namenom, &nameext);
  splitname(defname, &defdev, &defnom, &defext);
  if (namedev.len == 0)
    namedev = defdev;
  if (namenom.len == 0)
    namenom = defnom;
  if (nameext.len == 0)
    nameext = defext;
  buildname(name, namedev, namenom, nameext);
}


/*
**  The rest of the functions tend to be system specific
*/





Static boolean openread(fil, nom)
FILE **fil;
stryng *nom;
{
  boolean Result;
  stryng s;
  long mode, filedescriptor;
  Char STR1[256];

  s = *nom;
  stripspaces(&s);
  concatchar(&s, '\0');
  mode = 0;   /* mode=0 to read */
  filedescriptor = open(s.str, mode);
  if (filedescriptor == -1)
    return false;
  Result = true;
  filedescriptor = close(filedescriptor);
  if (*fil != NULL) {
    sprintf(STR1, "%.*s", maxstringchars, s.str);
    *fil = freopen(STR1, "r", *fil);
  } else {
    sprintf(STR1, "%.*s", maxstringchars, s.str);
    *fil = fopen(STR1, "r");
  }
  if (*fil == NULL)
    _EscIO(FileNotFound);
  return Result;
}


Static boolean openintread(fil, nom)
FILE **fil;
stryng *nom;
{
  boolean Result;
  stryng s;
  long mode, filedescriptor;
  Char STR1[256];

  s = *nom;
  stripspaces(&s);
  concatchar(&s, '\0');
  mode = 0;   /* mode=0 to read */
  filedescriptor = open(s.str, mode);
  if (filedescriptor == -1)
    return false;
  Result = true;
  filedescriptor = close(filedescriptor);
  if (*fil != NULL) {
    sprintf(STR1, "%.*s", maxstringchars, s.str);
    *fil = freopen(STR1, "rb", *fil);
  } else {
    sprintf(STR1, "%.*s", maxstringchars, s.str);
    *fil = fopen(STR1, "rb");
  }
  if (*fil == NULL)
    _EscIO(FileNotFound);
  return Result;
}


Static Void starttimer()
{
  startclock = 0;
/* p2c: nl.p, line 1928: Warning: Symbol 'CLOCK' is not defined [221] */
  startsysclock = 0;
/* p2c: nl.p, line 1929: Warning: Symbol 'SYSCLOCK' is not defined [221] */
}  /* StartTimer */


Static Void recordtime()
{
  long usertime, systime;

  usertime = 0 - startclock;
/* p2c: nl.p, line 1938: Warning: Symbol 'CLOCK' is not defined [221] */
  systime = 0 - startsysclock;
/* p2c: nl.p, line 1939: Warning: Symbol 'SYSCLOCK' is not defined [221] */
  printf(" took %ld milliseconds ( %ldu+ %lds )\n",
	 usertime + systime, usertime, systime);
}  /* RecordTime */


Static boolean canread(nom)
stryng *nom;
{
  boolean Result;
  long mode, filedescriptor;
  stryng s;

  s = *nom;
  stripspaces(&s);
  concatchar(&s, '\0');
  mode = 0;   /* mode=0 to read */
  filedescriptor = open(s.str, mode);
  if (filedescriptor == -1)
    return false;
  Result = true;
  filedescriptor = close(filedescriptor);
  return Result;
}


/* procedure CloseRead( var Fil: Text ); is a no-op on Unix*/



Static boolean openwrite(fil, nom)
FILE **fil;
stryng *nom;
{
  boolean Result;
  long mode, filedescriptor;
  stryng s;
  Char STR1[256];

  s = *nom;
  stripspaces(&s);
  concatchar(&s, '\0');
  mode = 1;   /* mode=1 to write */
  filedescriptor = open(s.str, mode);
  if (filedescriptor == -1) {
    mode = 438;
    filedescriptor = creat(s.str, mode);
    if (filedescriptor == -1)
      return false;
    Result = true;
    filedescriptor = close(filedescriptor);
    if (*fil != NULL) {
      sprintf(STR1, "%.*s", maxstringchars, s.str);
      *fil = freopen(STR1, "w", *fil);
    } else {
      sprintf(STR1, "%.*s", maxstringchars, s.str);
      *fil = fopen(STR1, "w");
    }
    if (*fil == NULL)
      _EscIO(FileNotFound);
    return Result;
  }
  Result = true;
  filedescriptor = close(filedescriptor);
  if (*fil != NULL) {
    sprintf(STR1, "%.*s", maxstringchars, s.str);
    *fil = freopen(STR1, "w", *fil);
  } else {
    sprintf(STR1, "%.*s", maxstringchars, s.str);
    *fil = fopen(STR1, "w");
  }
  if (*fil == NULL)
    _EscIO(FileNotFound);
  return Result;
}


Static boolean canwrite(nom)
stryng *nom;
{
  boolean Result;
  long mode, filedescriptor;
  stryng s;

  s = *nom;
  stripspaces(&s);
  concatchar(&s, '\0');
  mode = 1;   /* mode=1 to write */
  filedescriptor = open(s.str, mode);
  if (filedescriptor != -1) {
    Result = true;
    filedescriptor = close(filedescriptor);
    return Result;
  }
  mode = 0;   /* mode=0 to read */
  filedescriptor = open(s.str, mode);
  if (filedescriptor != -1) {   /*can read but can't write*/
    filedescriptor = close(filedescriptor);
    return false;
  }
  mode = 438;
  filedescriptor = creat(s.str, mode);
  if (filedescriptor == -1)
    return false;
  Result = true;
  filedescriptor = close(filedescriptor);
  return Result;

  /*can't read or write; try to create it*/
}


/* procedure CloseWrite( var Fil: Text ); is a no-op on Unix*/



Static Void flushwrite(fil)
FILE **fil;
{
  fflush(*fil);
  P_ioresult = 0;
}



/* procedure Page( var Fil: Text ); is defined on unix */

Static Void gettermline(termline, termtext)
stryng *termline, *termtext;
{
  FILE *TEMP1;

  TEMP1 = stdout;
/* p2c: nl.p, line 2062:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
  writestring(&TEMP1, termtext);
  TEMP1 = stdin;
/* p2c: nl.p, line 2063:
 * Note: Taking address of stdin; consider setting VarFiles = 0 [144] */
  readstring(&TEMP1, termline);
}


Static Void getcommandline(cmdline)
stryng *cmdline;
{
  stryng sarg;
  stryngar arg;
  long narg, i;

  /* GetCommandLine */
  memcpy(cmdline->str, blankstring, sizeof(stryngar));
  cmdline->len = 0;
  narg = P_argc - 1;
  /* narg is the number of arguments */
  for (i = 1; i <= narg; i++) {
    P_sun_argv(arg, sizeof(stryngar), (int)i);
	/* assigns the i-th argument to arg */
    memcpy(sarg.str, arg, sizeof(stryngar));
    sarg.len = maxstringchars;
    stripspaces(&sarg);
    concatchar(&sarg, ' ');
    if (cmdline->len < maxstringchars)
      insertstring(cmdline, &sarg, cmdline->len + 1);
  }
}


Static Void dfexit()
{
  exit_(1L);
}








/*#TITLE  PARUTL  ROUTINES        Oct82   Parameter Handling Routines.*/

Static parrec *defineparameter(parlist, long_, short_, parsort, pos1, pos2)
parrec **parlist;
Char *long_, *short_;
partyp parsort;
long pos1, pos2;
{
  parrec *newpar;

  /* DefineParameter */
  newpar = (parrec *)Malloc(sizeof(parrec));
  memcpy(newpar->longname, long_, sizeof(str10));
  memcpy(newpar->shortname, short_, sizeof(str10));
  newpar->partype = parsort;
  newpar->normpos = pos1;
  newpar->specpos = pos2;
  memcpy(newpar->parvalue.str, blankstring, sizeof(stryngar));
  newpar->parvalue.len = 0;
  newpar->nextpar = *parlist;
  *parlist = newpar;
  return newpar;
}


/*macro procedure InitParameter( Param: ParRef ); */

Static Void setparameter(param, paramvalue)
parrec *param;
stryng *paramvalue;
{
  long pos;
  long dum;

  /* SetParameter */
  if (((1L << ((long)param->partype)) &
       ((1L << ((long)ifilpar)) | (1L << ((long)ofilpar)))) != 0)
    defaultfilename(&param->parvalue, paramvalue);
  else if (param->parvalue.len == 0) {
    switch (param->partype) {   /* Case */

    case restpar:
    case strpar:
      param->parvalue = *paramvalue;
      break;

    case flagpar:
    case boolpar:
      stringuppercase(paramvalue);
      string10(&param->parvalue, "YES       ");
      if (!equalstrings(paramvalue, &param->parvalue)) {
	string10(&param->parvalue, "NO        ");
	if (!equalstrings(paramvalue, &param->parvalue))
	  deletestring(&param->parvalue, 1, 2L);
      }
      break;

    case intpar:
      pos = 1;
      dum = stringnumber(paramvalue, &pos, 10L);
      if (pos == paramvalue->len + 1)
	param->parvalue = *paramvalue;
      break;
    }
  }
  *paramvalue = param->parvalue;
}


/*macro function ParamSet( Par: ParRef ): Boolean; */

/*macro procedure StrParValue( var Str: Stryng; Par: ParRef ); */

Static boolean boolparvalue(par)
parrec *par;
{
  if (((1L << ((long)par->partype)) &
       ((1L << ((long)boolpar)) | (1L << ((long)flagpar)))) != 0)
    return (par->parvalue.len == 3);
  else
    return false;
}


Static long intparvalue(par)
parrec *par;
{
  long pos;

  pos = 1;
  return (stringnumber(&par->parvalue, &pos, 10L));
}


Static Char gettoken(token, cmd)
stryng *token, *cmd;
{
  long pos;
  boolean quote, done;
  Char leadchar, ch;
  Char STR1[256], STR2[256];

  /* GetToken */
  quote = false;
  done = false;
  pos = 1;

  while ((cmd->len > 0) & (stringchar(cmd, 1L) == ' '))
    deletestring(cmd, 1, 1L);

  leadchar = stringchar(cmd, 1L);
  if (leadchar == ' ' || leadchar == ' ' || leadchar == '-')
    deletestring(cmd, 1, 1L);
  else
    leadchar = ' ';

  do {
    ch = stringchar(cmd, pos);
    if (pos > cmd->len)
      done = true;
    else {
      if (ch == '\'') {
	deletestring(cmd, (int)pos, pos);
	if (quote & (stringchar(cmd, pos) == '\''))
	  pos++;
	else
	  quote = !quote;
      } else {
	if (quote)
	  pos++;
	else {
	  sprintf(STR1, "%c", ch);
	  sprintf(STR2, "%c", leadchar);
	  if ((ch == ' ' || ch == ' ' || ch == '-') |
	      ((strcmp(STR1, parargchar) == 0) & (strcmp(STR2, parflagchar) == 0)))
	    done = true;
	  else {
	    if (ch == ' ')
	      deletestring(cmd, (int)pos, pos);
	    else
	      pos++;
	  }
	}
      }
    }
  } while (!done);

  substring(token, cmd, 1, pos - 1);
  deletestring(cmd, 1, pos - 1);
  return leadchar;
}


Static boolean parsecommandline(parlist)
parrec *parlist;
{
  boolean Result;
  stryng commline, flagline, testline, tokenline;
  parrec *parpoint, *foundpar;
  long pospar;
  Char leadchar;
  boolean firsthalf;
  Char STR1[256], STR2[256], STR3[256];

  /* ParseCommandLine */
  getcommandline(&commline);
  stripspaces(&commline);
  Result = (commline.len > 0);
  insertchar(&commline, ' ', 1);
  firsthalf = true;
  pospar = 0;
  while (commline.len > 0) {
    leadchar = gettoken(&tokenline, &commline);
    foundpar = NULL;

    sprintf(STR1, "%c", leadchar);
    /* See if this could be a Flag */
    if (!strcmp(STR1, parflagchar)) {
      parpoint = parlist;
      flagline = tokenline;
      stringuppercase(&flagline);

      /* Try to Locate the Flag */
      while (parpoint != NULL && foundpar == NULL) {
	string10(&testline, parpoint->longname);
	if (equalstrings(&flagline, &testline))
	  foundpar = parpoint;
	else {
	  string10(&testline, parpoint->shortname);
	  if (equalstrings(&flagline, &testline))
	    foundpar = parpoint;
	}
	parpoint = parpoint->nextpar;
      }

      if (foundpar == NULL) {
	/* No Flag found so convert to Positional parameter */
	insertchar(&tokenline, '-', 1);
	leadchar = ' ';
      } else {
	if (foundpar->partype == flagpar)
	  string10(&tokenline, "YES       ");
	else {
	  /* Check for an argument separator if one is required */
	  if (strcmp(parargchar, " ")) {
	    sprintf(STR2, "%c", stringchar(&commline, 1L));
	    if (!strcmp(STR2, parargchar))
	      deletestring(&commline, 1, 1L);
	    else
	      foundpar = NULL;
	  }

	  /* Pick up argument */
	  if (foundpar != NULL) {
	    if (foundpar->partype == restpar) {
	      while (stringchar(&commline, 1L) == ' ')
		deletestring(&commline, 1, 1L);
	      tokenline = commline;
	      memcpy(commline.str, blankstring, sizeof(stryngar));
	      commline.len = 0;
	    } else {
	      leadchar = gettoken(&tokenline, &commline);
	      sprintf(STR2, "%c", leadchar);
	      if (!strcmp(STR2, parflagchar))
		insertchar(&tokenline, '-', 1);
	      else
		leadchar = '-';
	    }
	  }
	}
      }
    }

    sprintf(STR1, "%c", leadchar);
    /* If no Suitable Parameter found, assume Positional */
    if (strcmp(STR1, parflagchar)) {
      sprintf(STR2, "%c", leadchar);
      /* Deal with Seperators */
      if (!strcmp(STR2, parsepchar))
	pospar++;
      else {
	sprintf(STR3, "%c", leadchar);
	if (!strcmp(STR3, parsplitchar)) {
	  pospar = 1;
	  firsthalf = false;
	}
      }

      parpoint = parlist;
      while (parpoint != NULL && foundpar == NULL) {
	if (!strcmp(parsplitchar, " ")) {
	  if (parpoint->normpos == pospar)
	    foundpar = parpoint;
	} else {
	  if (parpoint->specpos == pospar &&
	      firsthalf == (parpoint->partype == ofilpar))
	    foundpar = parpoint;
	}
	parpoint = parpoint->nextpar;
      }
    }

    /* If Parameter found then set any argument */
    if (foundpar != NULL)
      setparameter(foundpar, &tokenline);
  }
  return Result;
}



Static Void getparamvalue(param, prompt)
parrec *param;
stryng prompt;
{
  stryng parvalue;

  concatchar(&prompt, ':');
  concatchar(&prompt, ' ');
  gettermline(&parvalue, &prompt);
  setparameter(param, &parvalue);
}



Static Void defaultext(name, oldname, ext)
stryng *name, *oldname;
Char *ext;
{
  stryng dev, nom;

  splitname(oldname, &dev, &nom, name);
  string10(name, ext);
  buildname(name, dev, nom, *name);
}



Static Void askparam(par, prompt)
parrec *par;
Char *prompt;
{
  stryng promptstring;

  memcpy(par->parvalue.str, blankstring, sizeof(stryngar));
  par->parvalue.len = 0;
  string20(&promptstring, prompt);
  getparamvalue(par, promptstring);
}



Static Void askordefault(par, def, inter, prompt)
parrec *par;
stryng *def;
boolean inter;
Char *prompt;
{
  stryng prstring;

  /* AskOrDefault */
  if (par->parvalue.len <= 0) {
    if (inter) {
      string20(&prstring, prompt);
      if (def->len > 0) {
	concatchar(&prstring, ' ');
	concatchar(&prstring, '[');


	if (prstring.len < maxstringchars)
	  insertstring(&prstring, def, prstring.len + 1);
	concatchar(&prstring, ']');
      }
      getparamvalue(par, prstring);
    }
    if (par->parvalue.len <= 0)
      setparameter(par, def);
  }
  *def = par->parvalue;
}


Static Void readcommandline(infile, outfile, paramlist, timingflag)
parrec **infile;
parrec **outfile, **paramlist;
boolean *timingflag;
{
  parrec *timingparam;
  boolean interact;
  stryng infilename;
  long i, zero;
  Char ch;
  Char s1[10], s2[10];

  zero = '0';
  for (i = 1; i <= maxinfile; i++) {
    memcpy(s1, "IN        ", 10L);
    memcpy(s2, "I         ", 10L);
    ch = (Char)(i + zero);
    s1[2] = ch;
    s2[1] = ch;
    infile[i - 1] = defineparameter(paramlist, s1, s2, ifilpar, i, 1L);
  }
  *outfile = defineparameter(paramlist, "OUT       ", "O         ", ofilpar,
			     11L, 1L);
  timingparam = defineparameter(paramlist, "TIMING    ", "T         ",
				flagpar, 12L, 1L);
  interact = parsecommandline(*paramlist);
  *timingflag = (timingparam->parvalue.len > 0);
  interact = (infile[0]->parvalue.len <= 0);
  memcpy(infilename.str, blankstring, sizeof(stryngar));
  infilename.len = 0;
  askordefault(infile[0], &infilename, interact, "Input file name     ");
  if (interact)
    infile[0]->parvalue = infilename;
  if ((*outfile)->parvalue.len <= 0) {
    if (infile[0]->parvalue.len > 0)
      (*outfile)->parvalue = infile[0]->parvalue;
  }
}  /* ReadCommandLine */


Static boolean openinputfile(filename, source)
stryng *filename;
FILE **source;
{

  /* Insures an '.if1' extension is on the file name and then tries to
     open it for reading.  Returns true if file opens properly.
   */
  defaultext(filename, filename, "if1       ");
  return (openread(source, filename));
}  /* OpenInputFile */


Static boolean openoutputfile(filename, source)
stryng *filename;
FILE **source;
{

  /* Insures an '.if1' extension is on the file name and then tries to
     open it for writing.  Returns true if file opens properly.
   */
  defaultext(filename, filename, "if1       ");
  return (openwrite(source, filename));
}  /* OpenOutputFile */


Static boolean openlistingfile(listfilename, list)
stryng listfilename;
FILE **list;
{  /* OpenOutputFile */
  stryng dev, name, ext;
  FILE *TEMP1;

  /* Make sure OutFileName has .pp extension */
  splitname(&listfilename, &dev, &name, &ext);
  defaultext(&listfilename, &name, "pp        ");

  /* Try to open for writing */
  if (canwrite(&listfilename))
    return (openwrite(list, &listfilename));
  else {
    printf("\n***** Could open listing file: ");
    TEMP1 = stdout;
/* p2c: nl.p, line 2536:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
    writestring(&TEMP1, &listfilename);
    printf(" *****\n");
    return false;
  }
}  /* OpenListingFile */



Static boolean openuncompfile(uncompfilename, uncomp)
stryng uncompfilename;
FILE **uncomp;
{  /* OpenOutputFile */
  stryng dev, name, ext;
  FILE *TEMP1;

  /* Make sure UncompFileName has .pp extension */
  splitname(&uncompfilename, &dev, &name, &ext);
  defaultext(&uncompfilename, &name, "unc       ");

  /* Try to open for writing */
  if (canwrite(&uncompfilename))
    return (openwrite(uncomp, &uncompfilename));
  else {
    printf("\n***** Could open un-comp output file: ");
    TEMP1 = stdout;
/* p2c: nl.p, line 2560:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
    writestring(&TEMP1, &uncompfilename);
    printf(" *****\n");
    return false;
  }
}  /* OpenUnCompFile */





Static stentry *newtypealloc(sort)
char sort;
{

  /*Allocates new type record, initializes fields, returns pointer*/
  stentry *t;

  t = (stentry *)Malloc(sizeof(stentry));
  t->stid = -1;
  t->stlabel = -1;
  t->stequivchain = t;
  memcpy(t->stliteral.str, blankstring, sizeof(stryngar));
  t->stliteral.len = 0;
  t->stsize = 0;
  t->strecurflag = false;
  t->stsort = sort;
  switch (t->stsort) {   /*with*/

  case iftwild:   /*nothing*/
    break;

  case iftbasic:
    t->UU.stbasic = ifbwild;
    break;

  case iftfunctiontype:
    t->UU.U3.starg = NULL;
    t->UU.U3.stres = NULL;
    break;

  case iftarray:
  case iftstream:
  case iftmultiple:
  case iftrecord:
  case iftunion:
  case iftbuffer:
    t->UU.stbasetype = NULL;
    break;

  case iftfield:
  case ifttuple:
  case ifttag:
    t->UU.U2.stelemtype = NULL;
    t->UU.U2.stnext = NULL;
    break;
  }/*case*/
  return t;
}  /*NewTypeAlloc*/


Static port *newedgealloc(sort)
portsort sort;
{

  /*Allocates new Edge (Port) record, initializes fields, returns pointer*/
  port *e;

  switch (sort) {

  case ptlit:
    e = (port *)Malloc(sizeof(port));
    break;

/* p2c: nl.p, line 2606:
 * Note: No SpecialMalloc form known for PORT.PTLIT [187] */
  case ptedge:
    e = (port *)Malloc(sizeof(port));
    break;

/* p2c: nl.p, line 2607:
 * Note: No SpecialMalloc form known for PORT.PTEDGE [187] */
  case ptdep:
    e = (port *)Malloc(sizeof(port));
    break;

/* p2c: nl.p, line 2608:
 * Note: No SpecialMalloc form known for PORT.PTDEP [187] */
  case ptundef:
    e = (port *)Malloc(sizeof(port));
    break;
  }/*case*/
  e->pttype = NULL;
  e->pttonode = NULL;
  e->pttoport = -1;
  e->ptid = -1;
  e->ptmark = byval;
  e->ptclass = pcuncoded;
  e->ptif1line = -1;
  e->ptsrcline = -1;
  e->ptwiline = -1;
  memcpy(e->ptname.str, blankstring, sizeof(stryngar));
  e->ptname.len = 0;
  e->ptlbound = -LONG_MAX;
  e->ptubound = -LONG_MAX;   /*dlz - ???, but canonical*/
  e->ptsetrc = -LONG_MAX;
  e->ptconmodrc = -LONG_MAX;
  e->ptprodmodrc = -LONG_MAX;
  e->ptdfaddr = -LONG_MAX;
  e->ptmraddr = 0;
  e->pttonext = NULL;
  e->ptnextedge = NULL;
  e->ptsort = sort;
  switch (e->ptsort) {   /*with*/

  case ptedge:
    e->UU.U1.ptfrnode = NULL;
    e->UU.U1.ptfrnext = NULL;
    e->UU.U1.ptfrport = -1;
    break;

  case ptdep:
    e->UU.U1.ptfrnode = NULL;
    e->UU.U1.ptfrnext = NULL;
    e->UU.U1.ptfrport = 0;
    e->pttoport = 0;
    string10(&e->ptname, "DEPENDENCE");
    break;

  case ptlit:
    memcpy(e->UU.ptlitvalue.str, blankstring, sizeof(stryngar));
    e->UU.ptlitvalue.len = 0;
    break;

  case ptundef:   /*nothing*/
    break;
  }/*case*/
  return e;
}  /*NewEdgeAlloc*/


Static node *newnodealloc(sort)
nodesort sort;
{

  /*Allocates new Node record, initializes fields, returns pointer*/
  node *n;

  switch (sort) {

  case ndatomic:
    n = (node *)Malloc(sizeof(node));
    break;

/* p2c: nl.p, line 2648:
 * Note: No SpecialMalloc form known for NODE.NDATOMIC [187] */
  case ndgraph:
    n = (node *)Malloc(sizeof(node));
    break;

/* p2c: nl.p, line 2649:
 * Note: No SpecialMalloc form known for NODE.NDGRAPH [187] */
  case ndcompound:
    n = (node *)Malloc(sizeof(node));
    break;

/* p2c: nl.p, line 2650:
 * Note: No SpecialMalloc form known for NODE.NDCOMPOUND [187] */
  case ndundef:
    n = (node *)Malloc(sizeof(node));
    break;
  }/*case*/
  n->ndid = -1;
  n->ndlabel = -1;
  n->ndcode = -1;
  n->ndmisc.numb = 0;
  n->ndline = -1;
  n->ndsrcline = -1;
  n->ndwiline = -1;
  n->ndxcoord = -LONG_MAX;
  n->ndycoord = -LONG_MAX;
  n->ndparent = NULL;
  n->ndnext = NULL;
  n->ndnextinline = NULL;
  n->ndilist = NULL;
  n->ndolist = NULL;
  n->nddepilist = NULL;
  n->nddepolist = NULL;
  n->ndfrequency = -1.0;
  n->ndexpanded = -1;
  n->ndsort = sort;
  switch (n->ndsort) {   /*with*/

  case ndatomic:   /*nothing*/
    break;

  case ndgraph:
    n->UU.U1.ndlink = NULL;
    n->UU.U1.ndtype = NULL;
    n->UU.U1.ndfirstmro = 0;
    n->UU.U1.ndlastmro = 0;
    n->ndlabel = 0;
    break;

  case ndcompound:
    n->UU.U2.ndsubsid = NULL;
    n->UU.U2.ndassoc = NULL;
    break;

  case ndundef:   /*nothing*/
    break;
  }/*case*/
  return n;
}  /*NewNodeAlloc*/



Static Void initstamps()
{
  Char c;
  stryng name;
  long SET[9];

  memcpy(name.str, blankstring, sizeof(stryngar));
  name.len = 0;
  for (c = 'A'; c <= 'Z'; c++) {
    P_addset(stampset, c);
    stamp[c - 'A'] = name;
  }
}  /* InitStamps */


Static Void removestamp(ch)
Char ch;
{
  long SET[9];

  P_remset(stampset, ch);
}  /* RemoveStamp */


Static Void addstamp(ch, str)
Char ch;
stryng str;
{
  long SET[9];

  P_addset(stampset, ch);
  stamp[ch - 'A'] = str;
}  /* AddStamp */


Static boolean stampisset(ch)
Char ch;
{
  return P_inset(ch, stampset);
}  /* StampIsSet */


Static boolean stampismissing(ch)
Char ch;
{
  return (!P_inset(ch, stampset));
}  /* StampIsMissing */



/* The following function give information about Nodes */

/* macro function NodeId ( gnode : NDPtr) : integer; */

/* macro function IsSimple( N: NdPtr ) : boolean */

/* macro function IsCompound( N: NdPtr ) : boolean */

/* macro function IsGraph( N: NdPtr ) : boolean */

/* macro function IsEmptyGraph( N: NdPtr ) : boolean */
/* IsEmptyGraph returns true if the graph has no internal nodes
   Assumes:(graph^.NDSort = NDGraph)       */

/*macro function IsLastNodeInGraph( N: NdPtr ) : boolean */

/*macro function NotEndOfGraph( N: NdPtr ) : boolean */

/*macro function IsFirstNodeInGraph( N: NdPtr ) : boolean */
/* assumes N <> nil */

Static long numbofsubgraphs(cnode)
node *cnode;
{

  /* Assumes cnode <> nil and (cnode^.NDSort = NDCompound)
     returns the number of subgraphs of this compound node,
     if a value of zero is returned, you know something is wrong.  */
  long count;
  graph *tmp;

  count = 0;
  tmp = cnode->UU.U2.ndsubsid;
  while (tmp != NULL) {
    count++;
    tmp = tmp->grnext;
  }
  return count;
}  /* NumbOfSubgraphs */


Static long numbnodesingraph(gnode)
node *gnode;
{

  /* Assumes gnode <> nil and (gnode^.NDSort = NDGraph)
     returns the number of nodes within this graph, the
     graphnode itself is not counted and and the compound
     nodes are counted only once (ie, we do not dive inside
     compounds. Empty graphs return a count of zero.  */
  long count;
  node *tmp;

  count = 0;
  tmp = gnode->ndnext;
  while (tmp != NULL) {
    count++;
    tmp = tmp->ndnext;
  }
  return count;
}  /* NumbNodesInGraph */


Static Void directancestors(n, nodesabove)
node *n;
setofint *nodesabove;
{

  /* returns a set of the nodes "directly above" node N (in the
     dataflow sense).  This set will be empty if the node can
     be scheduled to execute first in the graph. */
  port *iport, *WITH;

  makeemptyset(nodesabove, (int)univnodecnt);
  iport = n->ndilist;
  if (n->ndsort == ndgraph)
    return;
  while (iport != NULL) {   /*sks*/
    WITH = iport;
    if (WITH->ptsort == ptedge) {
      if (WITH->UU.U1.ptfrnode->ndsort != ndgraph)
	addtoset((int)WITH->UU.U1.ptfrnode->ndid, nodesabove);
    }
    iport = WITH->pttonext;   /*with*/
    /*sks*/
  }
}  /* DirectAncestors */


/* macro procedure NameOfGraph( var S: stryng; G: NdPtr ) */

/* macro function NumbOfAlternatives( N: NDPtr ) : integer */
/* NumbOfAlternatives assumes (N^.NDSort = NDCompound)
 One child graph is the selector graph, the others are Alternatives */

/* macro function NodeKind( N: NDPtr ) : integer */

Static long numberofwiredinputports(n)
node *n;
{

  /* Assumes N <> nil */
  port *eptr;
  long count;

  eptr = n->ndilist;
  count = 0;
  while (eptr != NULL) {
    count++;
    eptr = eptr->pttonext;
  }
  return count;
}  /* NumberOfInputPorts */


Static long numberofwiredoutputports(n)
node *n;
{

  /* Assumes N <> nil and edges are ordered by port numbers */
  port *e;
  long count, portnum;

  e = n->ndolist;
  count = 0;
  portnum = -1;
  while (e != NULL) {
    /* assumes edges are in order by port number */
    if (portnum != e->UU.U1.ptfrport) {
      count++;
      portnum = e->UU.U1.ptfrport;
    }
    e = e->UU.U1.ptfrnext;
  }
  return count;
}  /* NumberOfWiredOutputPorts */


Static long largestinputportnumber(n)
node *n;
{

  /* Assumes N <> nil
     returns the largest port number on the nodes input port list.
     NOTE: edges are ordered in the list by increasing port number */
  port *e;

  e = n->ndilist;
  if (e == NULL)
    return 0;
  else {
    while (e->pttonext != NULL)
      e = e->pttonext;
    return (e->pttoport);
  }
}  /* LargestInputPortNumber */


Static long largestoutputportnumber(n)
node *n;
{

  /* Assumes N <> nil
     returns largest port number on nodes output list */
  port *e;

  e = n->ndolist;
  if (e == NULL)
    return 0;
  else {
    while (e->UU.U1.ptfrnext != NULL)
      e = e->UU.U1.ptfrnext;
    return (e->UU.U1.ptfrport);
  }
}  /* LargestOutputPortNumber */


Static long nodelabel(n)
node *n;
{
  if (n == NULL)
    return -1;
  else
    return (n->ndlabel);
}  /* NodeLabel */


/* macro function FunctionKind( F : NDPtr ) : LinkSort; */


/* macro function IsLocalFunction( fungraph: NDPtr) : boolean; */
/* Assumes fungraph <> nil and fungraph is a function graph */

/* macro function IsGlobalFunction( fungraph: NDPtr) : boolean; */
/* Assumes fungraph <> nil and fungraph is a function graph */

/* The following functions give information about edges */

/* macro function IsEdge( E: EGPtr ) : boolean */

/* macro function IsLiteral( E: EGPtr ) : boolean */

/* macro function IsDependence( E: EGPtr ) : boolean */


Static boolean isboundaryedge(e)
port *e;
{

  /* Assumes E <> nil */
  /* returns true if E is incident on a graph boundary */
  boolean isgraphedge;

  if (e->ptsort == ptedge)
    isgraphedge = (e->UU.U1.ptfrnode->ndsort == ndgraph);
  else
    isgraphedge = false;
  return (isgraphedge || e->pttonode->ndsort == ndgraph);
}  /* IsBoundaryEdge */


/* macro function EdgeId( E: EGPtr ) : integer */

/* macro procedure NameOfEdge( var S: stryng; E: EGPtr ) */

/* macro procedure ValueOfLiteral( var S: stryng; E: EGPtr ) */

/* macro function ValueOfSetRC( E : EGPtr ) : integer; */

/* macro function ValueOfModRC(E : EGPtr ) : integer; */

/* macro function ValueOfProdRC(E : EGPtr ) : integer; */

/* macro function ConsumerNodeOfEdge( E : EGPtr ) : NDPtr; */

Static node *producernodeofedge(e)
port *e;
{

  /* Assumes E <> nil
     if edge is a literal there is no producer node and nil is returned */
  if (e->ptsort == ptedge || e->ptsort == ptdep)
    return (e->UU.U1.ptfrnode);
  else
    return NULL;
}  /* ProducerNodeOfEdge */


/* macro TypeOfEdge( E: EGPtr ) : STPtr */

/* macro DataSizeOfEdge( E: EGPtr ) : real */

/* macro SetDataSizeOfEdge( E : EGPtr; Value : real ); */

/* macro CardinalityOfEdge( E: EGPtr ) : real */

/* macro SetCardinalityOfEdge( E : EGPtr; Value : real ); */

/* macro SetCommOfEdge( E : EGPtr; Value : boolean); */

/* macro IsEdgeCommunicated( E : EGptr) : boolean;  */


/* macro SetRCOfEdge( E : EGPtr; Value : integer); */

/* macro SetProdModRCOfEdge( E : EGPtr; Value : integer); */

/* macro SetConModRCOfEdge( E : EGPtr; Value : integer); */

Static long producerportnumber(e)
port *e;
{

  /* Assumes E <> nil */
  if (e->ptsort == ptedge)
    return (e->UU.U1.ptfrport);
  else
    return -1;
}  /* ProducerPortNumber */


/* macro ConsumerPortNumber( E: EGPtr ) : integer */
/* Assumes E <> nil */

/* The following functions are used to traverse the graph */

Static node *tonamedgraph(name)
stryng name;
{

  /* returns the graphnode of the function with the given name.
     If no such function exists then it returns nill.
     rky changed 25May88 to use EquivName instead of StringLowerCase and
     EqualStrings. */
  boolean found;
  linkrec *funptr;

  funptr = funclist;
  found = false;
  do {
    if (funptr == NULL)
      found = true;
    else {
      if (equivstrings(&name, &funptr->lkname))
	found = true;
      else
	funptr = funptr->lknext;
    }
  } while (!found);
  if (funptr == NULL)
    return NULL;
  else
    return (funptr->lkgraph);
}  /* ToNamedGraph */


/* macro function ToFirstNodeInGraph( N: NdPtr ) : integer */
/* toFirstNodeInGraph assumes (graph^.NDSort = NDGraph)
 returns the first scheduled to be executed in this graph,
 if the Graph is empty thein it returns nil       */

/* macro ExecTimeOfNode( N : NDPtr ) : real */

/* macro SetExecTimeOfNode( N : NDPtr; Value : real ); */

/* macro ProcNumberOfNode( N : NDPtr ) : integer */

/* macro SetProcNumberOfNode( N : NDPtr; Value : integer ); */

/* macro SchedNumberOfNode( N : NDPtr ) : integer */

/* macro SetSchedNumberOfNode( N : NDPtr; Value : integer ); */

/* macro FrequencyOfNode( N : NDPtr ) : real */

/* macro SetFrequencyOfNode( N : NDPtr; Value : real ); */

/* macro IsNodeExpanded( N : NDPtr) : boolean; */

/* macro SetExpandedValueOfNode(N : NDPtr; Val : boolean); */


Static node *tolastnodeingraph(n)
node *n;
{

  /* assumes N <> nil and (N^.NDSort = NDGraph) */
  /* IfEmptyGraph(N) then it returns nil */
  node *last;

  if (n->ndnext == NULL)
    return NULL;
  else {
    last = n->ndnext;
    while (last->ndnext != NULL)
      last = last->ndnext;
    return last;
  }
}  /* ToLastNodeInGraph */


/*macro function ToNextNode( N: NdPtr ) : NdPtr */
/* ToNextNode assumes gnode <> nil
   Returns next node in this graph to be executed,
   returns nil if no next node*/

Static node *toprevnode(n)
node *n;
{

  /* Assumes N <> nil */
  /* if (N^.NDSort = NDGraph) or (n = n^.NDParent^.NDNext) then returns nil
     otherwise it returns the node previously scheduled to be
     executed. */
  node *prev;

  if (n->ndsort == ndgraph)
    return NULL;
  else if (n->ndparent->ndnext == n)
    return NULL;
  else {
    prev = n->ndparent->ndnext;
    while (prev->ndnext != n)
      prev = prev->ndnext;
    return prev;
  }
}  /* ToPrevNode */


/*macro ToEnclosingGraph( GNode: NdPtr ) : NdPtr */
/* ToEnclosingGraph assumes gnode <> nil and ( not (gnode^.NDSort = NDGraph))
 returns a pointer to the graphnode surrounding this one. */

/*macro function N: NdPtr ^.NDNext : NdPtr */
/* ^.NDNext assumes gnode <> nil
   Returns next node in this graph to be executed,
   returns nil if no next node*/

/*macro function ToFirstChildGraph( cnode : NDPtr) : NDPtr */
/* Assumes (cnode^.NDSort = NDCompound), with at least one subgraph.
   Result is a pointer to first subgraph of this compound node.  rky 8/87 */

Static node *tonextchildgraph(child)
node *child;
{

  /* Assumes child points to a subgraph of a compound node.  rky 8/87
     Result is a pointer to next subgraph of the same compound node, or nil.  */
  graph *tmp;

  tmp = child->ndparent->UU.U2.ndsubsid;
  while (tmp->grnode != child)
    tmp = tmp->grnext;
  if (tmp->grnext == NULL)
    return NULL;
  else
    return (tmp->grnext->grnode);
}  /* ToNextChildGraph */


Static node *tochildgraph(cnode, gindex)
node *cnode;
long gindex;
{

  /* Assumes (cnode^.NDSort = NDCompound) and Gindex >= 0
     returns a pointer to the i'th subgraph of this compound
     node where i is the value of Gindex.  If no such subgraph
     exists, it returns the nill pointer.      */
  graph *tmp;

  tmp = cnode->UU.U2.ndsubsid;
  while (tmp != NULL && gindex > 0) {
    gindex--;
    tmp = tmp->grnext;
  }
  if (tmp == NULL)
    return NULL;
  else
    return (tmp->grnode);
}  /* ToChildGraph */



Static node *toenclosingcompound(gnode)
node *gnode;
{

  /* Assumes gnode <> nil
     returns a pointer to the closest enclosing Compound node
     if one exists.  Returns nil if such a node doesn't exist.
   */
  if (gnode == module)
    return NULL;
  else {
    if (gnode->ndsort != ndgraph)
      gnode = gnode->ndparent;
    /* gnode now points to a graph node */
    gnode = gnode->ndparent;
    /* gnode now points to a compound node */
    if (gnode == module)
      return NULL;
    else
      return gnode;
  }
}  /* ToEnclosingCompound */


Static node *toenclosingfunction(n)
node *n;
{

  /* ToEnclosingFunction assumes N <> nil and N <> Module,
     it returns a pointer to the function graph that properly contains
     the node N. */
  if (n == NULL || n == module)
    return NULL;
  else {
    if (n->ndsort != ndgraph)
      n = n->ndparent;
    /* from this point on N will always point to a graph node */
    while (n->UU.U1.ndlink == NULL) {
      /* N points to a subgraph of a compound node */
      n = n->ndparent->ndparent;
    }
    return n;
  }
}  /* ToEnclosingFunction */


Static node *toinitgraph(n)
node *n;
{

  /* Assumes (N^.NDSort = NDCompound)
     If the node is not a LoopB or LoopA node then return nil */
  if (n->ndcode == ifnloopa || n->ndcode == ifnloopb)
    return (n->UU.U2.ndsubsid->grnode);
  else
    return NULL;
}  /* ToInitGraph */


Static node *tobodygraph(n)
node *n;
{

  /* Assumes (N^.NDSort = NDCompound)
     If the node is not a LoopB or LoopA node then return nil */
  if (n->ndcode == ifnloopa || n->ndcode == ifnloopb)
    return (n->UU.U2.ndsubsid->grnext->grnext->grnode);
  else
    return NULL;
}  /* ToBodyGraph */


Static node *totestgraph(n)
node *n;
{

  /* Assumes (N^.NDSort = NDCompound)
     If the node is not a LoopB or LoopA node then return nil */
  if (n->ndcode == ifnloopa || n->ndcode == ifnloopb)
    return (n->UU.U2.ndsubsid->grnext->grnode);
  else
    return NULL;
}  /* ToTestGraph */


Static node *toreturnsgraph(n)
node *n;
{

  /* Assumes (N^.NDSort = NDCompound)
     If the node is not a LoopB or LoopA node then return nil */
  if (n->ndcode == ifnloopa || n->ndcode == ifnloopb)
    return (n->UU.U2.ndsubsid->grnext->grnext->grnext->grnode);
  else
    return NULL;
}  /* ToReturnsGraph */


Static node *toiterbodygraph(n)
node *n;
{

  /* Assumes (N^.NDSort = NDCompound)
     if N is not a Iter node, then return nil */
  if (n->ndcode == ifniter)
    return (n->UU.U2.ndsubsid->grnode);
  else
    return NULL;
}  /* ToIterBodyGraph */


Static node *toselectorgraph(n)
node *n;
{

  /* Assumes (N^.NDSort = NDCompound)
     If N is not a Select node, then return nil */
  if (n->ndcode == ifnselect)
    return (n->UU.U2.ndsubsid->grnode);
  else
    return NULL;
}  /* ToSelectorGraph */


Static node *toalternativegraph(n, i)
node *n;
long i;
{

  /* Assumes (N^.NDSort = NDCompound)
     If N is not a Select node, then return nil */
  if (n->ndcode == ifnselect)
    return (tochildgraph(n, i + 1));
  else
    return NULL;
}  /* ToAlternativeGraph */


Static node *toforallgeneratorgraph(n)
node *n;
{

  /* Assumes (N^.NDSort = NDCompound)
     if N is not a Forall node, then return nil */
  if (n->ndcode == ifnforall)
    return (n->UU.U2.ndsubsid->grnode);
  else
    return NULL;
}  /* ToForallGeneratorGraph */


Static node *toforallbodygraph(n)
node *n;
{

  /* Assumes (N^.NDSort = NDCompound)
     if N is not a Forall node, then return nil */
  if (n->ndcode == ifnforall)
    return (n->UU.U2.ndsubsid->grnext->grnode);
  else
    return NULL;
}  /* ToForallBodyGraph */


Static node *toforallreturnsgraph(n)
node *n;
{

  /* Assumes (N^.NDSort = NDCompound)
     if N is not a Forall node, then return nil */
  if (n->ndcode == ifnforall)
    return (n->UU.U2.ndsubsid->grnext->grnext->grnode);
  else
    return NULL;
}  /* ToForallReturnsGraph */


Static node *totagcasesubgraph(t, tagnum)
node *t;
long tagnum;
{
  assoclist *alist;

  alist = t->UU.U2.ndassoc;
  while (tagnum > 0) {
    if (alist == NULL)
      tagnum = 0;
    else {
      tagnum--;
      alist = alist->next;
    }
  }
  if (alist == NULL)
    return NULL;
  else
    return (tochildgraph(t, alist->graphnum));
}  /* ToTagCaseSubgraph */


/* macro function NumberOfPredicates( C : NDPtr ) : integer */
/*C is an IfThenElse node.  Returns the number of predicate subgraphs */

/* macro function ToNthPredicateGraph( C : NDPtr; N : integer ) : NDPtr */
/*C is an IfThenElse node, N = 1, 2, ....      */
/*Returns a pointer to the N'th predicate subgraph      */

/* macro function ToNthTrueGraph( C : NDPtr; N : integer ) : NDPtr */
/*C is an IfThenElse node, N = 0, 1, ....      */
/*Returns a pointer to the N'th true subgraph      */

/* macro function ToFalseGraph( N : NDPtr ) : NDPtr */
/* N is an IfThenElse node.Returns a pointer to the false subgraph */

Static port *getinputedge(n, portnum)
node *n;
long portnum;
{

  /* If no edge is connected to this port number then nil is returned */
  port *eptr;
  boolean found;

  eptr = n->ndilist;
  found = false;
  while (!found) {
    if (eptr == NULL) {
      found = true;
      break;
    }
    if (eptr->pttoport == portnum)
      found = true;
    else
      eptr = eptr->pttonext;
  }
  return eptr;
}  /* GetInputEdge */


Static port *getoutputedge(n, portnum)
node *n;
long portnum;
{

  /* If no edge is connected to this port number then nil is returned */
  port *eptr;
  boolean found;

  eptr = n->ndolist;
  found = false;
  while (!found) {
    if (eptr == NULL) {
      found = true;
      break;
    }
    if (eptr->UU.U1.ptfrport == portnum)
      found = true;
    else
      eptr = eptr->UU.U1.ptfrnext;
  }
  return eptr;
}  /* GetOutputEdge */


Static port *nextoutputedgesameport(e)
port *e;
{

  /* Returns nil if no next edge exists */
  long portnum;

  portnum = e->UU.U1.ptfrport;
  e = e->UU.U1.ptfrnext;
  if (e != NULL) {
    if (e->UU.U1.ptfrport > portnum)
      e = NULL;
  }
  return e;
}  /* NextOutputEdgeSamePort */


/* Assumes N <> nil */

/* Assumes N <> nil */

/* Assumes E <> nil */

/* Assumes N <> nil */

/* Assumes N <> nil */

/* Assumes E <> nil */

/* dlz - 8/87 instead of for-loops */
/* over port range      */


Static port *nextinputedgenextport(e, p)
port *e;
long p;
{

  /* Added 21Sept87 rky.  Does same job as GetInputEdge, but faster.
     Returns the edge attached to input port p, where E is a non-nil edge
     attached to a further-left input port of the same node.
     Returns nil if no input edge exists on port p.  */
  port *nie;

  nie = e->pttonext;
  if (nie == NULL)
    return NULL;
  else if (nie->pttoport == p)
    return nie;
  else
    return NULL;
}  /* NextInputEdgeNextPort */


Static port *nextoutputedgenextport(e)
port *e;
{

  /* Added 15-Oct-87 dlz ; Returns the next non-fanout output edge,
     as above, for speed... */
  long p;

_L1:
  p = e->UU.U1.ptfrport;
  e = e->UU.U1.ptfrnext;
  if (e != NULL) {
    if (e->UU.U1.ptfrport == p)
      goto _L1;
  }
  return e;
}



Static port *inputedgegeport(n, p)
node *n;
long p;
{
  port *e;
  boolean found;

  e = n->ndilist;
  found = false;
  while (!found) {
    if (e == NULL) {
      found = true;
      break;
    }
    if (e->pttoport >= p)
      found = true;
    else
      e = e->pttonext;
  }
  return e;
}  /* InputEdgeGEPort */


Static port *outputedgegeport(n, p)
node *n;
long p;
{
  port *e;
  boolean found;

  e = n->ndolist;
  found = false;
  while (!found) {
    if (e == NULL) {
      found = true;
      break;
    }
    if (producerportnumber(e) >= p)
      found = true;
    else
      e = e->UU.U1.ptfrnext;
  }
  return e;
}  /* OutputEdgeGEPort */


Static node *getnodewithlabel(n, l)
node *n;
long l;
{
  boolean found, finished;

  found = false;
  finished = false;
  while (!(finished || found)) {
    if (n == NULL) {
      finished = true;
      break;
    }
    if (n->ndlabel == l) {
      found = true;
      break;
    }
    if (n->ndlabel > l)
      finished = true;
    else
      n = n->ndnext;
  }
  if (found)
    return n;
  else
    return NULL;
}  /* GetNodeWithLabel */


Static node *getnodewithid(f, id)
node *f;
long id;
{
  node *n, *gn;
  graph *g;
  boolean found;

  n = f;
  found = false;
  while (!found && n != NULL) {
    if (n->ndid == id) {
      found = true;
      break;
    }
    if (n->ndsort != ndcompound) {
      n = n->ndnext;
      continue;
    }  /* N is compound */
    g = n->UU.U2.ndsubsid;
    while (!found && g != NULL) {
      gn = getnodewithid(g->grnode, id);
      if (gn == NULL)   /*not found .. go to next subgraph*/
	g = g->grnext;
      else {
	/*found .. save the node and signal completion*/
	n = gn;
	found = true;
      }  /* else */
    }  /* while */
    if (!found)   /*move to next node*/
      n = n->ndnext;
  }
  return n;

  /* N is simple or a graph node .. move to next */
}  /* GetNodeWithID */


Static node *tonextfunction(f)
node *f;
{
  if (f == NULL)
    return NULL;
  else if (f->UU.U1.ndlink->lknext == NULL)
    return NULL;
  else
    return (f->UU.U1.ndlink->lknext->lkgraph);
}  /* ToNextFunction */


/* Functions used to examine and add to the type table */

/* macro function NameOfType( T: STPtr ) : Stryng */

/* macro WhichEntryType( S: STPtr ) : STENtry */

/* macro WhichBasicType( S: STPtr ) : STPtr */

/* macro function TypeOfGraph( G : NDPtr ) : STPtr; */


/* macro function BaseOfMultipleType( M: STPtr ) : STPtr; */


/* macro function BaseOfArrayType( M: STPtr ) : STPtr; */


/* macro function BaseOfTupleType( M: STPtr ) : STPtr; */


/* macro function BaseOfBufferType( M: STPtr ) : STPtr; */


/* macro function BaseOfStreamType( S: STPtr ) : STPtr; */


/* macro function GetFirstFunRes( N: NDPtr ) : STPtr; */


/* macro function GetFirstFunArg( N: NDPtr ) : STPtr; */


Static stentry *getnextfunarg(s)
stentry *s;
{
  if (s->stsort != ifttuple)
    return NULL;
  else
    return (s->UU.U2.stnext);
}  /* GetNextFunArg */


Static stentry *getnextfunres(s)
stentry *s;
{
  if (s->stsort != ifttuple)
    return NULL;
  else
    return (s->UU.U2.stnext);
}  /* GetNextFunRes */


Static long numberoffunargs(t)
stentry *t;
{

  /* Assumes T <> nil */
  stentry *temp;
  long count;

  count = 0;
  temp = t->UU.U3.starg;
  while (temp != NULL) {
    count++;
    if (temp->stsort == ifttuple)
      temp = temp->UU.U2.stnext;
    else
      temp = NULL;
  }
  return count;
}  /* NumberOfFunArgs */


Static long numberoffunres(t)
stentry *t;
{

  /* Assumes T <> nil */
  stentry *temp;
  long count;

  count = 0;
  temp = t->UU.U3.stres;
  while (temp != NULL) {
    count++;
    if (temp->stsort == ifttuple)
      temp = temp->UU.U2.stnext;
    else
      temp = NULL;
  }
  return count;
}  /* NumberOfFunRes */


Static stentry *typeofnthfunarg(f, n)
stentry *f;
long n;
{
  /* Return the type of the Nth function input argument */
  if (n < 1 || f->stsort != iftfunctiontype)
    return NULL;
  else {
    f = f->UU.U3.starg;
    while (n > 1) {
      n--;
      if (f != NULL)
	f = f->UU.U2.stnext;
    }
    if (f == NULL)
      return NULL;
    else
      return (f->UU.U2.stelemtype);
  }
}  /* TypeOfNthFunArg */


Static stentry *typeofnthfunres(f, n)
stentry *f;
long n;
{
  /* Returns the type of the Nth function output argument */
  if (n < 1 || f->stsort != iftfunctiontype)
    return NULL;
  else {
    f = f->UU.U3.stres;
    while (n > 1) {
      n--;
      if (f != NULL)
	f = f->UU.U2.stnext;
    }
    if (f == NULL)
      return NULL;
    else
      return (f->UU.U2.stelemtype);
  }
}  /* TypeOfNthFunRes */


Static long largestfieldnumberofrecord(r)
stentry *r;
{

  /* Returns the number of Fields defined for this record type */
  stentry *f;
  long count;

  if (r->stsort != iftrecord)
    return -1;
  else {
    count = -1;
    f = r->UU.stbasetype;
    while (f != NULL) {
      count++;
      f = f->UU.U2.stnext;
    }
    return count;
  }
}  /* LargestFieldNumberOfRecord */


Static Void typeandnameofnthfield(r, n, ftype, fname)
stentry *r;
long n;
stentry **ftype;
stryng *fname;
{
  /* Pre:  R is a RECORD type entry and N is an integer greater
          than or equal to zero.
    Post: The type and name of the Nth field ofrecord R are placed in
          FType and FName.
    Note:  If R is not a record entry, or N < 0, or N > the largest
           field number defined for this record (using a zero based
           numbering scheme) then Nil is placed in FType and FName is
           empty
  */
  memcpy(fname->str, blankstring, sizeof(stryngar));
  fname->len = 0;
  if (n < 0 || r->stsort != iftrecord) {
    *ftype = NULL;
    return;
  }
  r = r->UU.stbasetype;
  while (n > 0) {
    n--;
    if (r != NULL)
      r = r->UU.U2.stnext;
  }
  if (r == NULL)
    *ftype = NULL;
  else {
    *ftype = r->UU.U2.stelemtype;
    *fname = r->stliteral;
  }
}  /* TypeOfNthField */


Static stentry *typeofnthfield(r, n)
stentry *r;
long n;
{
  /* Pre:  R is a RECORD type entry and N is an integer greater
          than or equal to zero.
    Post: The type of the Nth field ofrecord R is returned
    Note:  If R is not a record entry, or N < 0, or N > the largest
           field number defined for this record (using a zero based
           numbering scheme) then Nil is returned.
  */
  if (n < 0 || r->stsort != iftrecord)
    return NULL;
  else {
    r = r->UU.stbasetype;
    while (n > 0) {
      n--;
      if (r != NULL)
	r = r->UU.U2.stnext;
    }
    if (r == NULL)
      return NULL;
    else
      return (r->UU.U2.stelemtype);
  }
}  /* TypeOfNthField */


Static long largesttagnumberofunion(u)
stentry *u;
{
  /* Returns the number of Tags defined for this Union type */
  stentry *f;
  long count;

  if (u->stsort != iftunion)
    return -1;
  else {
    count = -1;
    f = u->UU.stbasetype;
    while (f != NULL) {
      count++;
      f = f->UU.U2.stnext;
    }
    return count;
  }
}  /* LargestTagNumberOfUnion */


Static Void typeandnameofnthtag(u, n, ttype, tname)
stentry *u;
long n;
stentry **ttype;
stryng *tname;
{
  /* Pre:  U is a UNION type entry and N is an integer greater
          than or equal to zero.
    Post: The type of the Nth tag of the union type U is placed in TType and
          the name of the Nth tag is placed in TName.
    Note:  If U is not a union entry, or N < 0, or N > the largest
           tag defined for this union then TType = nil and TName is
           empty.
  */
  memcpy(tname->str, blankstring, sizeof(stryngar));
  tname->len = 0;
  if (n < 0 || u->stsort != iftunion) {
    *ttype = NULL;
    return;
  }
  u = u->UU.stbasetype;
  while (n > 0) {
    n--;
    if (u != NULL)
      u = u->UU.U2.stnext;
  }
  if (u == NULL)
    *ttype = NULL;
  else {
    *ttype = u->UU.U2.stelemtype;
    *tname = u->stliteral;
  }
}  /* TypeOfNthTag */


Static stentry *typeofnthtag(u, n)
stentry *u;
long n;
{
  /* Pre:  U is a UNION type entry and N is an integer greater
          than or equal to zero.
    Post: The type of the Nth tag of the union type U is returned
    Note:  If U is not a union entry, or N < 0, or N > the largest
           tag defined for this union then Nil is returned.
  */
  if (n < 0 || u->stsort != iftunion)
    return NULL;
  else {
    u = u->UU.stbasetype;
    while (n > 0) {
      n--;
      if (u != NULL)
	u = u->UU.U2.stnext;
    }
    if (u == NULL)
      return NULL;
    else
      return (u->UU.U2.stelemtype);
  }
}  /* TypeOfNthTag */


/* The following is a collection of functions that allow run-time additions
   to the Type Table.  Entries are constructed, then smashed into the table
   before being assigned to data objects.
 */

/*macro function MakeFunctionType () : STPtr;*/

/*macro function MakeRecordType () : STPtr;*/

/*macro function MakeUnionType () : STPtr;*/


Static stentry *searchtypetable(kind, x, y, name)
char kind;
stentry *x, *y;
stryng name;
{

  /* Search the Type Table for an entry of the given Kind that has:
      if Kind in [Stream, Array, Multiple, Record, Union, Buffer ] then
        X is its STBaseType
      if Kind in [Field, Tag] then
        X is its STElemType and Y is its STNext
    If an entry is not found, then return nil
  */
  long i;
  stentry *tbl;
  boolean found;

  found = false;
  i = 1;
  while (!found && i <= tthwm) {
    tbl = typetable[i - 1];
    if (tbl == NULL) {
      i++;
      continue;
    }
    if (tbl->stsort != kind) {
      i++;
      continue;
    }
    switch (kind) {

    case iftwild:
    case iftbasic:
      found = true;
      break;

    case iftmultiple:
    case iftarray:
    case iftstream:
    case iftrecord:
    case iftunion:
    case iftbuffer:
      if (tbl->UU.stbasetype == x)
	found = true;
      else
	i++;
      break;

    case iftfield:
    case ifttag:
      if ((tbl->UU.U2.stelemtype == x && tbl->UU.U2.stnext == y) &
	  equalstrings(&tbl->stliteral, &name))
	found = true;
      else
	i++;
      break;

    case ifttuple:
      if (tbl->UU.U2.stelemtype == x && tbl->UU.U2.stnext == y)
	found = true;
      else
	i++;
      break;

    case iftfunctiontype:
      if (tbl->UU.U3.starg == x && tbl->UU.U3.stres == y)
	found = true;
      else
	i++;
      break;
    }/* case */
  }  /* while */
  if (found)
    return tbl;
  else
    return NULL;
}  /* SearchTypeTable */



Static Void addfunargtype(f, arg)
stentry *f, *arg;
{
  stentry *x, *y;

  if (f->stsort != iftfunctiontype) {
    printf("ERROR: (AddFunArgType) first argument is not a function\n");
    return;
  }
  if (arg->stlabel <= 0) {
    printf("ERROR: (AddFunArgType) Arg Component not in type table\n");
    return;
  }
  x = newtypealloc(ifttuple);
  x->UU.U2.stelemtype = arg;
  y = f->UU.U3.starg;
  /* Now link X onto the end of the arg list */
  if (y == NULL) {
    f->UU.U3.starg = x;   /*first in list*/
    return;
  }
  while (y->UU.U2.stnext != NULL)
    y = y->UU.U2.stnext;
  y->UU.U2.stnext = x;
}  /* AddFunArgType */


Static Void addfunrestype(f, res)
stentry *f, *res;
{
  stentry *x, *y;

  if (f->stsort != iftfunctiontype) {
    printf("ERROR: (AddFunResType) first argument is not a function\n");
    return;
  }
  if (res->stlabel <= 0) {
    printf("ERROR: (AddFunResType) Res. Component not in type table\n");
    return;
  }
  x = newtypealloc(ifttuple);
  x->UU.U2.stelemtype = res;
  y = f->UU.U3.stres;
  /* Now link X onto the end of R's list */
  if (y == NULL) {
    f->UU.U3.stres = x;   /*first in list*/
    return;
  }
  while (y->UU.U2.stnext != NULL)
    y = y->UU.U2.stnext;
  y->UU.U2.stnext = x;
}  /* AddFunResType */


/* The maximum number of Equivalence classes handled */

#define maxclass        1000


/* Local variables for smashtypes: */
struct LOC_smashtypes {
  long lastclass;
  stentry *classtable[maxclass + 1];
  stentry *lastinclass[maxclass + 1];
} ;

Local long equivclass(s, LINK)
stentry *s;
struct LOC_smashtypes *LINK;
{
  /* EquivClass */
  if (s != NULL)
    return (s->stid);
  else
    return (-LONG_MAX);
}

Local Void dumponeequivclass(class_, LINK)
long class_;
struct LOC_smashtypes *LINK;
{
  stentry *member, *WITH;

  /* DumpOneEquivClass */
  printf("Equivalence class %ld\n", class_);
  member = LINK->classtable[class_];
  while (member != NULL) {
    WITH = member;
    printf("%5ld", WITH->stlabel);
    member = WITH->stequivchain;
  }
  putchar('\n');
}

Local Void dumpequivclasses(LINK)
struct LOC_smashtypes *LINK;
{
  /* DumpEquivClasses prints the LABELS of the type table */
  /*  entries that are in each equivalence class*/
  /* imports:LastClass*/
  long class_, FORLIM;

  /* DumpEquivClasses */
  FORLIM = LINK->lastclass;
  for (class_ = 1; class_ <= FORLIM; class_++)
    dumponeequivclass(class_, LINK);
  printf("LastClass is %ld\n\n", LINK->lastclass);
}

Local boolean sameequivclass(a, b, LINK)
stentry *a, *b;
struct LOC_smashtypes *LINK;
{
  boolean Result, first;

  /* SameEquivClass */
  switch (a->stsort) {   /* case */

  case iftwild:
    Result = true;
    break;

  case iftbasic:
    Result = (a->UU.stbasic == b->UU.stbasic);
    break;

  case iftfunctiontype:
    Result = (equivclass(a->UU.U3.starg, LINK) == equivclass(b->UU.U3.starg,
		LINK)) & (equivclass(a->UU.U3.stres, LINK) ==
			  equivclass(b->UU.U3.stres, LINK));
    break;

  case iftarray:
  case iftstream:
  case iftmultiple:
  case iftrecord:
  case iftunion:
  case iftbuffer:
    Result = (equivclass(a->UU.stbasetype, LINK) ==
	      equivclass(b->UU.stbasetype, LINK));
    break;

  case iftfield:
  case ifttag:
    if (equivclass(a->UU.U2.stelemtype, LINK) ==
	equivclass(b->UU.U2.stelemtype, LINK)) {
      if (a->UU.U2.stnext != NULL && b->UU.U2.stnext != NULL)
	first = (equivclass(a->UU.U2.stnext, LINK) ==
		 equivclass(b->UU.U2.stnext, LINK));
      else
	first = (a->UU.U2.stnext == NULL && b->UU.U2.stnext == NULL);
    } else
      first = false;
    Result = first & equalstrings(&a->stliteral, &b->stliteral);
    break;

  case ifttuple:
    if (equivclass(a->UU.U2.stelemtype, LINK) ==
	equivclass(b->UU.U2.stelemtype, LINK)) {
      if (a->UU.U2.stnext != NULL && b->UU.U2.stnext != NULL)
	Result = (equivclass(a->UU.U2.stnext, LINK) ==
		  equivclass(b->UU.U2.stnext, LINK));
      else
	Result = (a->UU.U2.stnext == NULL && b->UU.U2.stnext == NULL);
    } else
      Result = false;
    break;

  }

  return Result;
}

Local Void createnewequivclass(r, LINK)
stentry *r;
struct LOC_smashtypes *LINK;
{
  /* CreateNewEquivClass */
  if (LINK->lastclass < maxclass)
    LINK->lastclass++;
  else
    printf("SmashType: Out of room for equivalence classes\n");
  r->stid = LINK->lastclass;
  r->stequivchain = NULL;
  LINK->classtable[LINK->lastclass] = r;
  LINK->lastinclass[LINK->lastclass] = r;
}

Local Void removefromequivclass(old, exile, LINK)
stentry *old, *exile;
struct LOC_smashtypes *LINK;
{
  /* RemoveFromEquivClass */
  if (exile == LINK->lastinclass[old->stid])
    LINK->lastinclass[old->stid] = old;
  old->stequivchain = exile->stequivchain;
}

Local Void addtoequivclass(representative, newmember, LINK)
stentry *representative, *newmember;
struct LOC_smashtypes *LINK;
{
  long classnum;

  /* AddToEquivClass */
  classnum = representative->stid;
  newmember->stid = classnum;
  newmember->stequivchain = NULL;
  LINK->lastinclass[classnum]->stequivchain = newmember;
  LINK->lastinclass[classnum] = newmember;
}

Local Void initequivclasses(LINK)
struct LOC_smashtypes *LINK;
{

  /* InitEquivClasses looks at every entry in the type table and places*/
  /* then non-nil ones into one of 12 equivilence classes:*/
  /*IFTBasicIFTRecord*/
  /*IFTFunctionTypeIFTUnion*/
  /*IFTArrayIFTField*/
  /*IFTStreamIFTTuple*/
  /*IFTMultipleIFTTag*/
  /*IFTWildIFTBuffer*/
  /* WARNING: Some equivalence classes may be left empty! */
  /* imports TypeTable, EntryMax*/
  /* exports LastClass (set to highest class USED */
  stentry *s;
  long entry_, class_, FORLIM;

  /* InitEquivClasses */
  for (class_ = 1; class_ <= maxclass; class_++) {
    LINK->classtable[class_] = NULL;
    LINK->lastinclass[class_] = NULL;
  }
  FORLIM = tthwm;
  for (entry_ = 1; entry_ <= FORLIM; entry_++) {
    if (typetable[entry_ - 1] != NULL) {
      s = typetable[entry_ - 1];
      s->stlabel = entry_;
      s->stid = s->stsort + 1;
      s->stequivchain = NULL;
      if (LINK->classtable[s->stid] == NULL) {  /* First in list */
	LINK->classtable[s->stid] = s;
	LINK->lastinclass[s->stid] = s;
      } else {  /* Insert at end of list */
	LINK->lastinclass[s->stid]->stequivchain = s;
	LINK->lastinclass[s->stid] = s;
      }
    }
  }
  for (class_ = 1; class_ <= ifmaxtype + 1; class_++) {
    if (LINK->classtable[class_] != NULL)
      LINK->lastclass = class_;
  }
}

/* macro function NextInEquivClass( M : STPtr ) : STPtr; */

/* macro function MoreInEquivClass( M : STPtr ) : boolean; */

Local Void gatherothers(prev, representative, LINK)
stentry *prev, **representative;
struct LOC_smashtypes *LINK;
{
  /* GatherOthers tries to remove elements in the Class headed by */
  /* Prev and moves them to the class headed by Representative*/
  stentry *potentialmember;

  /* macro procedure Mark( Entry : STPtr ); */

  /* macro function IsMarked( Entry : STPtr ): boolean; */

  /* macro procedure RemoveMark( var Entry : STPtr ); */

  /* GatherOthers */
  /* ^.STLabel := -^.STLabel all entries equivalent to Representative */
  potentialmember = (*representative)->stequivchain;
  while (potentialmember != NULL) {
    if (sameequivclass(*representative, potentialmember, LINK))
      potentialmember->stlabel = -potentialmember->stlabel;
    potentialmember = potentialmember->stequivchain;
  }

  /* remove all marked entries */
  removefromequivclass(prev, *representative, LINK);
  createnewequivclass(*representative, LINK);
  while (prev->stequivchain != NULL) {
    potentialmember = prev->stequivchain;
    if (potentialmember->stlabel < 0) {
      potentialmember->stlabel = -potentialmember->stlabel;
      removefromequivclass(prev, potentialmember, LINK);
      addtoequivclass(*representative, potentialmember, LINK);
    } else
      prev = potentialmember;
  }
}

Local Void pointtohead(LINK)
struct LOC_smashtypes *LINK;
{
  /* PointToHead makes the STEquivChain of each entry point at the */
  /*  representative of the equivalence class, and places a -1*/
  /*  in the representative's STId field (so that it will be*/
  /*  dumped in the node dumping process*/
  /* 83/10/4  sks*/
  long thisclass;
  stentry *temp, *member, *representative;
  long FORLIM;
  stentry *WITH;

  /* PointToHead */
  FORLIM = LINK->lastclass;
  for (thisclass = 1; thisclass <= FORLIM; thisclass++) {
    if (LINK->classtable[thisclass] != NULL) {
      representative = LINK->classtable[thisclass];
      representative->stid = -1;
      member = representative;
      while (member != NULL) {
	WITH = member;
	temp = WITH->stequivchain;
	WITH->stequivchain = representative;
	member = temp;   /* with */
      }
    }  /* if */
  }
}


/* -------------------------------------------------------------------- */
/* --------------------------- SmashTypes ----------------------------- */
Static Void smashtypes()
{

  /* Smashtypes maps types that are structurally equivalent into the same*/
  /* type number.Note that SISAL type equivalence is not guaranteed, since */
  /* the names of fields and tags of smashed types may not be the same.*/
  /* imports:TypeTable*/
  /* exports:LastClass*/
  /*ClassTable*/
  /*.STEquivChain*/
  /*.STLabel*/
  /*.STId*/
  /* 83/10/1 sks*/
  struct LOC_smashtypes V;
  boolean changed;
  long class_;
  stentry *member, *previous, *representative;
  long FORLIM;


  /* SmashTypes */
  initequivclasses(&V);
  changed = true;
  while (changed) {   /* while */
    changed = false;
    FORLIM = V.lastclass;
    for (class_ = 1; class_ <= FORLIM; class_++) {
      representative = V.classtable[class_];
      previous = representative;
      if (previous == NULL)
	member = NULL;
      else
	member = previous->stequivchain;
      while (member != NULL) {
	if (sameequivclass(representative, member, &V)) {
	  previous = member;
	  member = previous->stequivchain;
	} else {
	  /* Begin another class and grab all others */
	  /* from this one that belong in it */
	  changed = true;
	  gatherothers(previous, &member, &V);
	  member = NULL;
	}
      }  /* while Member<>nil */
    }  /* for */
  }
  pointtohead(&V);
}

#undef maxclass


/* --------------------------- SmashTypes ----------------------------- */
/* -------------------------------------------------------------------- */

Static Void adjustgraphptrs()
{
  long typenum, FORLIM;
  stentry *WITH;

  FORLIM = tthwm;
  for (typenum = 0; typenum < FORLIM; typenum++) {
    if (typetable[typenum] != NULL) {
      WITH = typetable[typenum];
      switch (WITH->stsort) {

      case iftwild:
      case iftbasic:
	/* blank case */
	break;

      case iftfunctiontype:
	if (WITH->UU.U3.starg != NULL)
	  WITH->UU.U3.starg = WITH->UU.U3.starg->stequivchain;
	if (WITH->UU.U3.stres != NULL)
	  WITH->UU.U3.stres = WITH->UU.U3.stres->stequivchain;
	break;

      case iftarray:
      case iftstream:
      case iftmultiple:
      case iftrecord:
      case iftunion:
      case iftbuffer:
	if (WITH->UU.stbasetype != NULL)
	  WITH->UU.stbasetype = WITH->UU.stbasetype->stequivchain;
	break;

      case iftfield:
      case ifttuple:
      case ifttag:
	if (WITH->UU.U2.stelemtype != NULL)
	  WITH->UU.U2.stelemtype = WITH->UU.U2.stelemtype->stequivchain;
	if (WITH->UU.U2.stnext != NULL)
	  WITH->UU.U2.stnext = WITH->UU.U2.stnext->stequivchain;
	break;
      }/* case */
    }
  }
}  /* AdjustGraphPtrs */


Static Void compacttypetable(tthwm, oldtthwm)
long *tthwm, oldtthwm;
{

  /*  Pre:  The TypeTable has been extended beyond OldTTHWM (Old Symbol
           Table High Water Mark) and the new types added have been
           smashed into the existing types and some new ones.  At this
           point, the STEquivChain of each entry of the table points to
           its equivalence class representative.  Also, the new graph
           has been walked and all pointers to symbol table entries have
           been changed to the class representatives.
     Post: The Symbol Table below OldTTHWM is scanned and all entries
           which are not equivalence class representatives are removed.
           The resulting entries are compacted and the TTHWM is reset.
  */
  long lastincompacted, current;
  stentry *rep, *s;
  long FORLIM;

  lastincompacted = oldtthwm;
  FORLIM = *tthwm;
  for (current = oldtthwm; current < FORLIM; current++) {
    s = typetable[current];
    if (s != NULL) {
      if (s->stequivchain != s) {
	/* Make sure representative has name */
	rep = s->stequivchain;
	if (rep != NULL) {
	  if (rep->stliteral.len == 0) {
	    if (s->stliteral.len != 0)
	      rep->stliteral = s->stliteral;
	  }
	}
	/* Not a class representative, remove it */
	typetable[current] = NULL;
      } else {
	/* Is a class representative */
	lastincompacted++;
	if (current + 1 > lastincompacted) {
	  /* Compact list */
	  s->stlabel = lastincompacted;
	  typetable[lastincompacted - 1] = s;
	  typetable[current] = NULL;
	}
      }
    }
  }
  *tthwm = lastincompacted;
}  /* CompactTypeTable */


Static stentry *getbasictype(base)
char base;
{

  /* returns a pointer to the type table entry corresponding to
     the basic type specified by Base.  An entry MUST exist for
     all basic types, this is required by LoadProgram.

   */
  return (typetable[base]);
}  /* GetBasicType */


Static stentry *getwildtype()
{

  /* Returns a type table entry corresponding to the Wild Card type.
     Note that this is NOT the BASIC Wild Card (IFBWild) but the
     higher level wild card (IFTWild).
   */
  stentry *wld;
  stryng name;

  memcpy(name.str, blankstring, sizeof(stryngar));
  name.len = 0;
  wld = searchtypetable(iftwild, NULL, NULL, name);
  if (wld != NULL) {
    return wld;
  }  /* if */
  wld = newtypealloc(iftwild);
  if (tthwm == entrymax) {
    printf("ERROR: (GetWildType) Type Table Overflow\n");
    wld = NULL;
    return wld;
  }
  tthwm++;
  wld->stlabel = tthwm;
  typetable[tthwm - 1] = wld;
  return wld;

  /* else */
}  /* GetWildType */


Static stentry *getconstructortype(kind, base)
char kind;
stentry *base;
{

  /* Requires that the Base type already be in the table - if not,
     an error message is printed and Nil is returned.
     If the base is in the table, then it searches the table for
     this constructor.  If it finds one, it returns this type, otherwise
     it returns a newly constructed type and adds it to the table.
   */
  stentry *con;
  stryng name;

  if (((1L << kind) & ((1L << iftarray) | (1L << iftstream) |
		       (1L << iftmultiple) | (1L << iftbuffer))) == 0) {
    printf("ERROR (GetConstructorType) only works with: \n");
    printf(" --->  Arrays, Streams, and Multiples\n");
    return NULL;
  } else if (base->stlabel <= 0) {
    printf("ERROR (GetConstructorType) Base type not in table\n");
    return NULL;
  } else {
    /* Base is in type table, search for Array[ Base ] or
       Stream[ Base ], or Multiple[ Base ] or Buffer[ Base ] entry */
    memcpy(name.str, blankstring, sizeof(stryngar));
    name.len = 0;
    con = searchtypetable(kind, base, NULL, name);
    if (con != NULL)  /* Not in table, construct one and add it */
      return con;
    con = (stentry *)Malloc(sizeof(stentry));
    con = newtypealloc(kind);
    con->UU.stbasetype = base;
    if (tthwm == entrymax) {
      printf("ERROR: (GetConstructorType) Type Table Overflow\n");
      return con;
    }
    tthwm++;
    con->stlabel = tthwm;
    typetable[tthwm - 1] = con;
    return con;
  }

  /* else */
}  /* GetConstructorType */



Static Void addfieldtype(r, fld)
stentry *r, *fld;
{

  /* It is required that Fld already be in the type table.
     If its not, an error message is posted and nothing is done.
     If it is, a field link is constructed and added to the
     end of R's field list.
   */
  stentry *x, *y;

  if (r->stsort != iftrecord) {
    printf("ERROR: (AddFieldType) first argument is not a record\n");
    return;
  }
  if (fld->stlabel <= 0) {
    printf("ERROR: (AddFieldType) Field Component not in type table\n");
    return;
  }
  x = newtypealloc(iftfield);
  x->UU.U2.stelemtype = fld;
  y = r->UU.stbasetype;
  /* Now link X onto the end of R's list */
  if (y == NULL) {
    r->UU.stbasetype = x;   /*first in list*/
    return;
  }
  while (y->UU.U2.stnext != NULL)
    y = y->UU.U2.stnext;
  y->UU.U2.stnext = x;
}  /* AddFieldType */


Static Void addtagtype(u, tg)
stentry *u, *tg;
{

  /* It is required that Tg already be in the type table.
     If its not, an error message is posted and nothing is done.
     If it is, a field link is constructed and added to the
     end of U's field list.
   */
  stentry *x, *y;

  if (u->stsort != iftunion) {
    printf("ERROR: (AddTagType) first argument is not a union\n");
    return;
  }
  if (tg->stlabel <= 0) {
    printf("ERROR: (AddTagType) Tag Component not in type table\n");
    return;
  }
  x = newtypealloc(ifttag);
  x->UU.U2.stelemtype = tg;
  y = u->UU.stbasetype;
  /* Now link X onto the end of U's list */
  if (y == NULL) {
    u->UU.stbasetype = x;   /*first in list*/
    return;
  }
  while (y->UU.U2.stnext != NULL)
    y = y->UU.U2.stnext;
  y->UU.U2.stnext = x;
}  /* AddTagType */


Static Void putintable(typ)
stentry **typ;
{

  /* Enter Typ into the type table.
     If no room is left, send an error message
   */
  if (tthwm == entrymax) {
    printf("ERROR: (AddToTypeTable) Type Table Overflow\n");
    *typ = NULL;
    return;
  }
  tthwm++;
  (*typ)->stlabel = tthwm;
  typetable[tthwm - 1] = *typ;
}  /* PutInTable */


Local Void putstruct(tt)
stentry *tt;
{
  if (tt == NULL) {
    return;
  }  /* if TT <> nil */
  if (tt->stlabel != -1) {
    return;
  }  /* if */
  putintable(&tt);
  switch (tt->stsort) {

  case iftbasic:
  case iftwild:
    /* blank case */
    break;

  case iftfunctiontype:
    putstruct(tt->UU.U3.starg);
    putstruct(tt->UU.U3.stres);
    break;

  case ifttuple:
  case iftfield:
  case ifttag:
    if (!tt->strecurflag)
      putstruct(tt->UU.U2.stelemtype);
    putstruct(tt->UU.U2.stnext);
    break;

  case iftarray:
  case iftstream:
  case iftbuffer:
  case iftmultiple:
    if (!tt->strecurflag)
      putstruct(tt->UU.stbasetype);
    break;

  case iftrecord:
  case iftunion:
    putstruct(tt->UU.stbasetype);
    break;
  }/* case */
}  /* PutStruct */


Static stentry *addtotypetable(typ)
stentry *typ;
{
  stentry *Result, *newtyp, *elem, *nxt, *arg, *rets;
  stryng name;
  long oldtthwm;

  if (typ == NULL)
    return NULL;
  if (typ->stlabel > 0)
    return typ;
  memcpy(name.str, blankstring, sizeof(stryngar));
  name.len = 0;
  switch (typ->stsort) {

  case iftbasic:
    Result = searchtypetable(typ->stsort, NULL, NULL, name);
    break;

  case iftfunctiontype:
    if (typ->UU.U3.starg == NULL)
      arg = NULL;
    else
      arg = addtotypetable(typ->UU.U3.starg);
    if (typ->UU.U3.stres == NULL)
      rets = NULL;
    else
      rets = addtotypetable(typ->UU.U3.stres);
    newtyp = searchtypetable(typ->stsort, arg, rets, name);
    if (newtyp == NULL) {
      newtyp = typ;
      newtyp->UU.U3.starg = arg;
      newtyp->UU.U3.stres = rets;
      putintable(&newtyp);
    }
    Result = newtyp;
    break;

  case iftarray:
  case iftstream:
  case iftmultiple:
  case iftbuffer:
    /* this should never happen, all arrays, streams,
            and tuples should already be built into the table */
    elem = addtotypetable(typ->UU.stbasetype);
    newtyp = searchtypetable(typ->stsort, elem, NULL, name);
    if (newtyp == NULL) {  /* not in the table */
      newtyp = typ;
      newtyp->UU.stbasetype = elem;
      putintable(&newtyp);
    }
    Result = newtyp;
    break;

  case iftrecord:
    if (typ->UU.stbasetype == NULL)
      nxt = NULL;
    else
      nxt = addtotypetable(typ->UU.stbasetype);
    newtyp = searchtypetable(typ->stsort, nxt, NULL, name);
    if (newtyp == NULL) {  /* Not found in table */
      newtyp = typ;
      newtyp->UU.stbasetype = nxt;
      putintable(&newtyp);
    }
    Result = newtyp;
    break;

  case iftunion:
    if (typ->strecurflag) {
      oldtthwm = tthwm;
      putstruct(typ);
      smashtypes();
      adjustgraphptrs();
      Result = typetable[oldtthwm]->stequivchain;
      compacttypetable(&tthwm, oldtthwm);
    } else {
      if (typ->UU.stbasetype == NULL)
	nxt = NULL;
      else
	nxt = addtotypetable(typ->UU.stbasetype);
      newtyp = searchtypetable(typ->stsort, nxt, NULL, name);
      if (newtyp == NULL) {
	newtyp = typ;
	newtyp->UU.stbasetype = nxt;
	putintable(&newtyp);
      }
      Result = newtyp;
    }
    break;

  case ifttuple:
    elem = addtotypetable(typ->UU.U2.stelemtype);
    if (typ->UU.U2.stnext != NULL)
      nxt = addtotypetable(typ->UU.U2.stnext);
    else
      nxt = NULL;
    newtyp = searchtypetable(typ->stsort, elem, nxt, name);
    if (newtyp == NULL) {  /* not found in table */
      newtyp = typ;
      newtyp->UU.U2.stnext = nxt;
      newtyp->UU.U2.stelemtype = elem;
      putintable(&newtyp);
    }
    Result = newtyp;
    break;

  case ifttag:
  case iftfield:
    elem = addtotypetable(typ->UU.U2.stelemtype);
    if (typ->UU.U2.stnext != NULL)
      nxt = addtotypetable(typ->UU.U2.stnext);
    else
      nxt = NULL;
    newtyp = searchtypetable(typ->stsort, elem, nxt, typ->stliteral);
    if (newtyp == NULL) {  /* not found in table */
      newtyp = typ;
      newtyp->UU.U2.stnext = nxt;
      newtyp->UU.U2.stelemtype = elem;
      putintable(&newtyp);
    }
    Result = newtyp;
    break;
  }/* case */
  return Result;
}  /* AddToTypeTable */


Static stentry *makefuntypefromgraph(g)
node *g;
{
  /* Construct a function type definition for the given graph
     and add the definition to the global type table.
     NOTE:  Unused ports get defined as wild types.
   */
  stentry *ft, *arg, *res;
  long port_;
  port *e;
  long FORLIM;

  ft = newtypealloc(iftfunctiontype);
  FORLIM = largestinputportnumber(g);
  for (port_ = 1; port_ <= FORLIM; port_++) {
    e = getinputedge(g, port_);
    if (e == NULL)
      res = getwildtype();
    else
      res = e->pttype;
    addfunrestype(ft, res);
  }
  FORLIM = largestoutputportnumber(g);
  for (port_ = 1; port_ <= FORLIM; port_++) {
    e = getoutputedge(g, port_);
    if (e == NULL)
      arg = getwildtype();
    else
      arg = e->pttype;
    addfunargtype(ft, arg);
  }
  return (addtotypetable(ft));
}  /* MakeFunTypeFromGraph */


/* Functions that read and set pragma values */




/* GetEdgeBounds( E : EGPtr; var Lo, Hi : integer );   Assumes E <> nil */


/* macro function GetSourceLine( N: NDPtr ) : integer assumes N <> nil */

/* macro function GetWithinLine ( N : NDPtr) : integer; Assumes N <> nil */

/* macro function EdgeMark( E: EGPtr ) : EGMark */

/* macro procedure SetEdgeMark( var E: EGPtr ; M: EGMark */

/* macro function IsInlineExpandable( fungraph: NDPtr) : boolean; */
/* Assumes fungraph <> nil and fungraph is a function graph */

/* macro procedure SetInlinePragma( fungraph: NDPtr; V: boolean ); */
/* Assumes fungraph <> nil and fungraph is a function graph */



/* Functions needed specifically by the interpreter (DI) */

Static Void linkcallnodetofunction(cnode, fgraph)
node *cnode, *fgraph;
{

  /* Assumes Cnode and Fgraph <> nil */
  if (fgraph == NULL)
    cnode->UU.U1.ndlink = NULL;
  else
    cnode->UU.U1.ndlink = fgraph->UU.U1.ndlink;
}  /* LinkCallNodeToFunction */


Static node *tocalledgraph(callnode)
node *callnode;
{
  if (callnode->UU.U1.ndlink == NULL)
    return NULL;
  else
    return (callnode->UU.U1.ndlink->lkgraph);
}  /* ToCalledGraph */


/* macro function NumbFunLocals( F: NdPtr ) : integer */
/* NumbFunLocals assumes funnode is the graph node of a function */

/* macro procedure SetNumbFunLocals( F: NdPtr, n: integer ) */
/* SetNumbFunLocals assumes funnode is the graph node of a function */

/* macro function DatumAddr ( E : EGPtr) : integer; */
/* Assumes E is not nil */

/* macro procedure SetDatumAddr( E: EGPtr, n: integer ) */
/* SetDatumAddr assumes E is not nil */

/* macro function MRDatumAddr ( E : EGPtr ) : integer */

/* macro procedure SetMRDatumAddr( E : EGPtr, N : integer ) */


/* ^.NDLink^.LKARIndex :=  assumes F <> nil and F points to a function graph */


/* ^.NDLink^.LKARIndex assumes F <> nil and F points to a function graph */

/* macro function NextSimilarEdge( E : EGPtr ) : EGPtr; */

/* macro procedure LinkToSimilarEdge( List, NewLink : EGPtr ); */

/* macro function NextNodeInLine( N : NDPtr ) : NDPtr; */

/* macro procedure LinkToNextNodeInLine( List, NewLink : NDPtr ); */

/* macro procedure SetFunctionModule( F : NDPtr; Name : Stryng ); */

/* macro procedure ModuleNameOfFunction( var Name : Stryng; F : NDPtr); */

/******************************************************************/
/* These function must come last in the files due to dependencies */

Static ifgraphtype graphkind(g)
node *g;
{

  /* Assumes (G^.NDSort = NDGraph)
     Analyses a graph node to determine its IFGraphType */
  ifgraphtype Result;
  node *parent;
  graph *gptr;
  long count;

  parent = toenclosingcompound(g);
  if (parent == NULL)
    return ifgfunction;
  switch (parent->ndcode) {

  case ifnselect:
    if (g == toselectorgraph(parent))
      Result = ifgselector;
    else
      Result = ifgalternative;
    break;

  case ifntagcase:
    Result = ifgvariant;
    break;

  case ifnloopb:
    if (g == toinitgraph(parent))
      Result = ifgloopbinit;
    else if (g == totestgraph(parent))
      Result = ifgloopbtest;
    else if (g == tobodygraph(parent))
      Result = ifgloopbbody;
    else
      Result = ifgloopbreturns;
    break;

  case ifnloopa:
    if (g == toreturnsgraph(parent))
      Result = ifgloopareturns;
    else if (g == toinitgraph(parent))
      Result = ifgloopainit;
    else if (g == totestgraph(parent))
      Result = ifgloopatest;
    else
      Result = ifgloopabody;
    break;

  case ifnforall:
    gptr = parent->UU.U2.ndsubsid;
    if (g == gptr->grnode)
      Result = ifgforallgenerator;
    else if (g == gptr->grnext->grnode)
      Result = ifgforallbody;
    else
      Result = ifgforallreturns;
    break;
    /* IFNForall */

  case ifnifthenelse:
    gptr = parent->UU.U2.ndsubsid;
    count = 1;
    while (gptr->grnode != g) {
      gptr = gptr->grnext;
      count++;
    }
    if (gptr->grnext == NULL)
      Result = ifgiffalse;
    else if ((count & 1) == 0)
      Result = ifgifpredicate;
    else
      Result = ifgiftrue;
    break;

  case ifniter:
    Result = ifgiterbody;
    break;
  }/* case */
  return Result;
}  /* GraphKind */


Static char reductionop(n)
node *n;
{

  /* assumes N <> nil, N is a reduction node, and
     first input edge is a literal string of the reduction
     operators name */
  char Result;
  port *e;

  e = getinputedge(n, 1L);
  switch (lowercase(e->UU.ptlitvalue.str[0])) {

  case 's':
    Result = ifrsum;
    break;

  case 'p':
    Result = ifrproduct;
    break;

  case 'l':
    Result = ifrleast;
    break;

  case 'g':
    Result = ifrgreatest;
    break;

  case 'c':
    Result = ifrcatenate;
    break;
  }/* case */
  return Result;
}  /* ReductionOp */


Static Void loopranges(c, k, l, t)
node *c;
long *k, *l, *t;
{

  /*
    Assumes C <> nil, returns:
      K = number of input ports on node C, these ports are numbered
          1 .. K.
      L = Largest Loop value port number.  Loop ports are numbered
          K + 1 .. L.
          ( NOTE:  if C is not a loop compound node then -1 is returned )
      T = Largest Temporary value port number.Temporary ports are
          numbered L+1 .. T.
          ( NOTE: -1 is returned if C is not an LoopA or Forall node )
  */
  node *g;

  *k = largestinputportnumber(c);
  if (c->ndsort != ndcompound) {
    *l = -1;
    *t = -1;
    return;
  }
  switch (c->ndcode) {

  case ifnselect:
  case ifntagcase:
  case ifnifthenelse:
    *l = -1;
    *t = -1;
    break;

  case ifnforall:
    g = toforallgeneratorgraph(c);
    *l = largestinputportnumber(g);
    if (*l == 0)
      *l = *k;
    g = toforallbodygraph(c);
    *t = largestinputportnumber(g);
    if (*t == 0)
      *t = *l;
    break;

  case ifnloopb:
  case ifnloopa:
    g = toinitgraph(c);
    *l = largestinputportnumber(g);
    if (*l == 0)
      *l = *k;
    g = tobodygraph(c);
    *t = largestinputportnumber(g);
    if (*t == 0)
      *t = *l;
    break;

  case ifniter:   /* added rky 8/87 */
    g = c->UU.U2.ndsubsid->grnode;
    *l = largestinputportnumber(g);
    *t = -1;   /* there are no Ts */
    /* difference between K and L is that K not hooked as input to Body */
    *k = g->ndilist->pttonext->pttoport - 1;
    break;
  }/* case */
}  /* LoopRanges */


Static long fanout(n, portnum)
node *n;
long portnum;
{

  /* Returns the number of edges connected to output port number
     'portnum'. A value of zero is returned if no such port exists */
  long count;
  port *eptr;

  count = 0;
  /* Find first port with this port number */
  eptr = getoutputedge(n, portnum);
  while (eptr != NULL) {
    count++;
    eptr = nextoutputedgesameport(eptr);
  }
  return count;
}  /* Fanout */




/* Graph2.m4 contains graph routines that alter the structure of the
   graph and are only used by some of the optimization routines.
   These were removed from the graph.m4 file since they are "Special"
   and not everyone needs them. */

/*dlz - 8/87 updated to use new allocation routines in graph.m4,
  some cleanup, ***still confusion/glitch (?) in CopyEdges, CopyGraph*/


Static Void disconnectedgefromsource(e)
port *e;
{
  /*in out*/
  /* ----------------------------------------------------
     DisconnectEdgeFromSource
          - Completely unlinks E from it's source node's
            output edge list
          - nills out all pointer fields having to do with
            it's source node.
     ---------------------------------------------------- */
  port *temp;

  if (e->ptsort != ptedge)
    return;
  if (e->UU.U1.ptfrnode == NULL)
    return;
  temp = e->UU.U1.ptfrnode->ndolist;
  if (temp == e)
    e->UU.U1.ptfrnode->ndolist = e->UU.U1.ptfrnext;
  else {
    while (temp->UU.U1.ptfrnext != e)
      temp = temp->UU.U1.ptfrnext;
    temp->UU.U1.ptfrnext = e->UU.U1.ptfrnext;
  }
  e->UU.U1.ptfrnode = NULL;
  e->UU.U1.ptfrnext = NULL;
  e->UU.U1.ptfrport = 0;
}  /* DisconnectEdgeFromSource */


Static Void disconnectedgefromdest(e)
port *e;
{
  /*in out*/
  /* -------------------------------------------------------
     DisconnectEdgeFromDest
         - Unlinks E from it's destination node's input list
         - nills out all pointer fields having to do with
           E's destination node
     ------------------------------------------------------- */
  port *temp;

  if (e->pttonode == NULL)
    return;
  temp = e->pttonode->ndilist;
  if (temp == e)
    e->pttonode->ndilist = e->pttonext;
  else {
    while (temp->pttonext != e)
      temp = temp->pttonext;
    temp->pttonext = e->pttonext;
  }
  e->pttonode = NULL;
  e->pttonext = NULL;
  e->pttoport = 0;
}  /* DisconnectEdgeFromDest */


Static Void removeedge(e)
port **e;
{
  /* -------------------------------------------------
     RemoveEdge
         - Removes E from graph leaving graph valid
         - nills out all pointer fields
         - returns pointer to completely unlinked edge
     ------------------------------------------------- */
  disconnectedgefromsource(*e);
  disconnectedgefromdest(*e);
  (*e)->pttype = NULL;
}  /* RemoveEdge */


Static Void removeinputedges(n)
node *n;
{
  port *e, *tmpe;

  e = n->ndilist;
  while (e != NULL) {
    tmpe = e;
    e = e->pttonext;
    removeedge(&tmpe);
  }
}  /* RemoveInputEdges */


Static Void removenode PP((node *n));

Local Void removegraph(g)
node *g;
{
  /* Walk the nodes of the graph G removing each in turn */
  node *tmpn, *nd;

  nd = g->ndnext;
  while (nd != NULL) {
    tmpn = nd;
    nd = nd->ndnext;
    removenode(tmpn);
  }
  removenode(g);
}  /* RemoveGraph */


/* macro procedure ChangeEdgeName( E : EGPtr; S : Stryng ) */

/* macro procedure ChangeLiteralValue( E : EGPtr; S : Stryng ) */

Static Void removenode(n)
node *n;
{
  /*  Remove Node :
        - if N is a compound node it removes the subgraphs first.
        - removes all input edges
        - removes all output edges
        - completely disconnects N from the graph
  */
  graph *grtmp;
  node *prev;
  port *temp;

  if (n->ndsort == ndcompound) {
    grtmp = n->UU.U2.ndsubsid;
    while (grtmp != NULL) {
      removegraph(grtmp->grnode);
      grtmp = grtmp->grnext;
    }
  }
  /* Remove input edges */
  while (n->ndilist != NULL) {
    temp = n->ndilist;
    removeedge(&temp);
  }
  /* Remove output edges */
  while (n->ndolist != NULL) {
    temp = n->ndolist;
    removeedge(&temp);
  }
  /* Remove the node from the graph */
  if (n->ndsort != ndgraph) {
    prev = n->ndparent;
    while (prev->ndnext != n)
      prev = prev->ndnext;
    prev->ndnext = n->ndnext;
  }
  n->UU.U2.ndsubsid = NULL;
  n->ndnext = NULL;
  n->ndparent = NULL;
}  /* RemoveNode */


Static node *createsimplenode(opcode)
long opcode;
{
  /* Create a Simple node with the opcode given.
     The new node will have no input or output edges and will
     not be connected to any graph.
   */
  node *newnode;

  newnode = newnodealloc(ndatomic);
  univnodecnt++;
  newnode->ndid = univnodecnt;
  newnode->ndcode = opcode;
  return newnode;
}  /* CreateSimpleNode */


Static node *createcompoundnode(opcode)
long opcode;
{
  /* Create a Compound node with the opcode given.
     The new node will have no input or output edges and will
     not be connected to any graph.
   */
  node *newnode;

  newnode = newnodealloc(ndcompound);
  univnodecnt++;
  newnode->ndid = univnodecnt;
  newnode->ndcode = opcode;
  return newnode;
}  /* CreateCompoundNode */


Static Void insertnode(parentnode, prevnode, newnode)
node *parentnode, *prevnode, *newnode;
{
  /* Inserts NewNode into graph of ParentNode after PrevNode.
     If Prevnode = nil then the NewNode is inserted as the first
     in the graph headed by ParentNode.
   */
  node *ntemp, *WITH;

  newnode->ndparent = parentnode;
  if (prevnode == NULL) {   /* with */
    newnode->ndnext = parentnode->ndnext;
    parentnode->ndnext = newnode;
    if (newnode->ndnext == NULL)
      newnode->ndlabel = 1;
    else
      newnode->ndlabel = newnode->ndnext->ndlabel;
  } else {
    newnode->ndnext = prevnode->ndnext;
    prevnode->ndnext = newnode;
    newnode->ndlabel = prevnode->ndlabel + 1;
  }
  /* Now change the Labels of all nodes following NewNode */
  ntemp = newnode->ndnext;
  while (ntemp != NULL) {
    WITH = ntemp;
    WITH->ndlabel++;
    ntemp = WITH->ndnext;
  }
}  /* InsertNode*/


Static Void changeedgedest(e, newdestnode, newdestport)
port *e;
node *newdestnode;
long newdestport;
{
  /* -----------------------------------------------------------------
     Step 1  Removes E from it's current destination node's input list
             ( if it is in one) and
     Step 2  Adds it to NewDestNode's input list at port number
             NewDestPort
     NOTE:   This operation may cause Fan-In.
     ----------------------------------------------------------------- */
  port *nedge;
  boolean found;

  disconnectedgefromdest(e);
  /* Now Link E into input edge list of NewDestNode */
  e->pttonode = newdestnode;
  e->pttoport = newdestport;
  nedge = newdestnode->ndilist;
  if (nedge == NULL) {  /* List was empty, adding first edge */
    newdestnode->ndilist = e;
    e->pttonext = NULL;
    return;
  }
  if (nedge->pttoport >= newdestport) {  /* Insert first in list */
    e->pttonext = newdestnode->ndilist;
    newdestnode->ndilist = e;
    return;
  }
  found = false;
  do {
    if (nedge->pttonext == NULL)
      found = true;
    else if (nedge->pttonext->pttoport >= newdestport)
      found = true;
    else
      nedge = nedge->pttonext;
  } while (!found);
  /* insert after Nedge */
  e->pttonext = nedge->pttonext;
  nedge->pttonext = e;
}  /* ChangeEdgeDest */


Static Void changeedgesrc(e, newsrcnode, newsrcport)
port *e;
node *newsrcnode;
long newsrcport;
{
  /* -----------------------------------------------------------------
     Step 1  Removes E from it's current source node's output list
             ( if it is in one) and
     Step 2  Adds it to NewSrcNode's input list at port number
             NewSrcPort
     ----------------------------------------------------------------- */
  port *nedge;
  boolean found;

  disconnectedgefromsource(e);
  /* Now Link E into output edge list of NewSrcNode */
  e->UU.U1.ptfrnode = newsrcnode;
  e->UU.U1.ptfrport = newsrcport;
  nedge = newsrcnode->ndolist;
  if (nedge == NULL) {  /* List was empty, adding first edge */
    newsrcnode->ndolist = e;
    e->UU.U1.ptfrnext = NULL;
    return;
  }
  if (nedge->UU.U1.ptfrport >= newsrcport) {  /* Insert first in list */
    e->UU.U1.ptfrnext = newsrcnode->ndolist;
    newsrcnode->ndolist = e;
    return;
  }
  found = false;
  do {
    if (nedge->UU.U1.ptfrnext == NULL)
      found = true;
    else if (nedge->UU.U1.ptfrnext->UU.U1.ptfrport >= newsrcport)
      found = true;
    else
      nedge = nedge->UU.U1.ptfrnext;
  } while (!found);
  /* insert after Nedge */
  e->UU.U1.ptfrnext = nedge->UU.U1.ptfrnext;
  nedge->UU.U1.ptfrnext = e;
}  /* ChangeEdgeSrc */


Static port *insertedge(fromnode, fromport, tonode, toport, etype, name)
node *fromnode;
long fromport;
node *tonode;
long toport;
stentry *etype;
stryng name;
{  /* Does NOT work for inserting Literals */
  port *newedge;

  newedge = newedgealloc(ptedge);
  univedgecnt++;
  newedge->ptid = univedgecnt;
  newedge->ptname = name;
  newedge->pttype = etype;   /* with */
  changeedgedest(newedge, tonode, toport);
  changeedgesrc(newedge, fromnode, fromport);
  return newedge;
}  /* InsertEdge */


Static port *insertliteral(tonode, toport, etype, lvalue, lname)
node *tonode;
long toport;
stentry *etype;
stryng lvalue, lname;
{
  port *newedge;

  newedge = newedgealloc(ptlit);
  univedgecnt++;
  newedge->ptid = univedgecnt;
  newedge->ptname = lname;
  newedge->UU.ptlitvalue = lvalue;
  newedge->pttype = etype;   /* with */
  changeedgedest(newedge, tonode, toport);
  return newedge;
}  /* InsertLiteral */


Static Void renumbergraph(g, recurse)
node *g;
boolean recurse;
{
  /* Walks the graph G renumbering then nodes as it comes to them.
     If Recurse = true then it recursively renumbers the
     subgraphs of the compound nodes of G otherwise, it simple
     renumbers the nodes of G.
   */
  long lab, graphnum;
  node *n;
  long FORLIM;

  n = g->ndnext;
  lab = 0;
  while (n != NULL) {
    lab++;
    n->ndlabel = lab;
    if (recurse) {
      if (n->ndsort == ndcompound) {
	FORLIM = numbofsubgraphs(n);
	for (graphnum = 0; graphnum < FORLIM; graphnum++)
	  renumbergraph(tochildgraph(n, graphnum), recurse);
      }
    }
    n = n->ndnext;
  }
}  /* RenumberGraph */


Static Void putnodebefore(n, intransit)
node *n, *intransit;
{
  /* Assumes N <> nil and not (N^.NDSort = NDGraph) */
  /* Inserts the node InTransit in front of the node N */
  node *prev;

  /* remove from old graph */
  prev = intransit->ndparent;
  while (prev->ndnext != intransit)
    prev = prev->ndnext;
  prev->ndnext = intransit->ndnext;
  /* insert into new graph */
  prev = n->ndparent;
  while (prev->ndnext != n)
    prev = prev->ndnext;
  prev->ndnext = intransit;
  intransit->ndparent = n->ndparent;
  intransit->ndnext = n;
  intransit->ndlabel = n->ndlabel;
  /* renumber labels from N on down */
  do {
    n->ndlabel++;
    n = n->ndnext;
  } while (n != NULL);
}  /* PutNodeBefore */


Static Void shiftinputports(n, startport, amount)
node *n;
long startport, amount;
{
  /* Shifts the port numbers of the input edges of N, starting from
     port StartPort and shifting by Amount.
   */
  boolean found;
  port *e;

  found = false;
  e = n->ndilist;
  while (e != NULL && !found) {
    if (e->pttoport >= startport)
      found = true;
    else
      e = e->pttonext;
  }
  if (!found)
    return;
  while (e != NULL) {
    e->pttoport += amount;
    e = e->pttonext;
  }
}  /* ShiftInputPorts */


Static Void shiftoutputports(n, startport, amount)
node *n;
long startport, amount;
{
  /* Shifts the port numbers of the output edges of N, starting from
     port StartPort and shifting by Amount.
   */
  boolean found;
  port *e;

  found = false;
  e = n->ndolist;
  while (e != NULL && !found) {
    if (e->UU.U1.ptfrport >= startport)
      found = true;
    else
      e = e->UU.U1.ptfrnext;
  }
  if (!found)
    return;
  while (e != NULL) {
    e->UU.U1.ptfrport += amount;
    e = e->UU.U1.ptfrnext;
  }
}  /* ShiftOutputPorts */


Static Void copynodepragmas(oldn, n)
node *oldn, *n;
{
  n->ndsrcline = oldn->ndsrcline;
}



Static node *copygraph PP((node *oldg));



Static node *copycompound PP((node *oldn));


Static node *copynode(n)
node *n;
{
  /* Create and return a new node identical to N except without any
     input or output edges and detached from any surrounding graph.
     N is not changed in any way.
     If N is a graph node or a compound node, it copys the graph
     structure or the entire compound node.
   */
  node *newnode;

  if (n->ndsort == ndgraph)
    return (copygraph(n));
  else if (n->ndsort == ndcompound)
    return (copycompound(n));
  else {
    newnode = newnodealloc(ndatomic);
    univnodecnt++;
    copynodepragmas(n, newnode);

    newnode->ndid = univnodecnt;
    newnode->ndcode = n->ndcode;
    newnode->ndlabel = n->ndlabel;
    return newnode;
  }

  /* N is a simple node */
}  /* CopyNode */


Static node *copycompound(oldn)
node *oldn;
{
  /*( OldN : NDPtr ) : NDPtr*/
  /* Returns a pointer to a newly created compound node
     with the same internal structure as OldN but no
     external input or output edges.
     Note: Recursively calls CopyGraph.
   */
  node *n;
  graph *lastgraph, *graphlink;
  assoclist *tagwalk, *taglast;
  long gnum, FORLIM;

  n = newnodealloc(ndcompound);
  univnodecnt++;
  copynodepragmas(oldn, n);

  n->ndid = univnodecnt;
  n->ndcode = oldn->ndcode;
  n->ndlabel = oldn->ndlabel;
  /* Copy subgraphs of compound node */
  lastgraph = NULL;
  FORLIM = numbofsubgraphs(oldn);
  for (gnum = 0; gnum < FORLIM; gnum++) {
    graphlink = (graph *)Malloc(sizeof(graph));
    graphlink->grnode = copygraph(tochildgraph(oldn, gnum));
    graphlink->grnode->ndparent = n;
    if (lastgraph == NULL)
      n->UU.U2.ndsubsid = graphlink;
    else
      lastgraph->grnext = graphlink;
    lastgraph = graphlink;
  }
  lastgraph->grnext = NULL;
  /* copy tag list (if it exists) */
  if (n->ndcode != ifntagcase)  /* copy tag list */
    return n;
  tagwalk = oldn->UU.U2.ndassoc;
  taglast = NULL;
  while (tagwalk != NULL) {
    if (taglast == NULL) {
      taglast = (assoclist *)Malloc(sizeof(assoclist));
      n->UU.U2.ndassoc = taglast;
    } else {
      taglast->next = (assoclist *)Malloc(sizeof(assoclist));
      taglast = taglast->next;
    }
    taglast->graphnum = tagwalk->graphnum;
    tagwalk = tagwalk->next;
  }
  taglast->next = NULL;
  return n;
}  /* CopyCompound */


Local Void copyedges(newg, oldg)
node *newg, *oldg;
{
  /* NewG is a skeleton structure of OldG.  It consists of
     Nodes identical to that of OldG and connected in the
     same order, but has no edges.  This procedure walks
     both NewG and OldG in tandem and makes a copy of each
     input edge of every node of OldG for each corresponding
     node of NewG.
   */
  node *oldn, *newn, *prodn;
  port *olde, *newe;
  long port_, nlab;

  newn = newg;
  oldn = oldg;
  /* Walk the nodes of OldG and NewG */
  while (oldn != NULL) {
    if (oldn->ndlabel != newn->ndlabel) {
      printf("INTERNAL ERROR, COPYGRAPH: Wrong Labels: %12ld%12ld\n",
	     oldn->ndlabel, newn->ndlabel);
      oldn = NULL;
      break;
    }
    olde = oldn->ndilist;
    while (olde != NULL) {
      newe = (port *)Malloc(sizeof(port));
      *newe = *olde;
      /* Assign a different Id to this new edge */
      univedgecnt++;
      newe->ptid = univedgecnt;
      /* dlz ***     NewE^.PTExtraInfo := nil;  temp. commented out ****/
      newe->pttonode = NULL;
      newe->pttonext = NULL;
      changeedgedest(newe, newn, olde->pttoport);
      if (olde->ptsort == ptedge) {
	newe->UU.U1.ptfrnode = NULL;
	newe->UU.U1.ptfrnext = NULL;
	port_ = producerportnumber(olde);
	nlab = olde->UU.U1.ptfrnode->ndlabel;
	prodn = getnodewithlabel(newg, nlab);
	changeedgesrc(newe, prodn, port_);
      }
      olde = olde->pttonext;
    }
    oldn = oldn->ndnext;
    newn = newn->ndnext;
  }
}  /* CopyEdges */


Static node *copygraph(oldg)
node *oldg;
{
  /* ( OldG : NDPtr ) : NDPtr */
  /* Returns a pointer to a new graph that is an exact copy
     of the old graph, except that the nodes and edges have
     new and unique ID's */
  node *g, *n, *prev, *marker;

  g = (node *)Malloc(sizeof(node));
  univnodecnt++;
  g->ndid = univnodecnt;
  g->ndline = 0;
  g->ndsrcline = oldg->ndsrcline;
  g->ndwiline = -LONG_MAX;
  g->ndxcoord = -LONG_MAX;
  g->ndycoord = -LONG_MAX;
  /*dlz*** NDExtraInfo := nil; **** temp commented out*/
  g->ndparent = NULL;
  g->ndilist = NULL;
  g->ndolist = NULL;
  g->ndcode = oldg->ndcode;
  g->ndlabel = oldg->ndlabel;
  g->ndsort = oldg->ndsort;
  switch (g->ndsort) {

  case ndgraph:
    g->UU.U1.ndlink = NULL;
    g->UU.U1.ndtype = oldg->UU.U1.ndtype;
    break;

  case ndcompound:
    g->UU.U2.ndsubsid = NULL;
    break;
  }/* case */
  prev = g;
  marker = oldg->ndnext;
  /* Walk the graph copying nodes as we go along */
  while (marker != NULL) {
    if (marker->ndsort == ndcompound)
      n = copycompound(marker);
    else  /* Simple Node */
      n = copynode(marker);
    n->ndparent = g;
    prev->ndnext = n;
    prev = n;
    marker = marker->ndnext;
  }
  prev->ndnext = NULL;
  copyedges(g, oldg);
  return g;
}  /* CopyGraph */



Static Void linknodeintograph(n, parent, prev)
node *n, *parent, *prev;
{
  /* This routine links the node into the graph pointed to by
     Parent after the node Prev.  It then changes the Labels
     of all the nodes from this point on to avoid having two
     nodes in the graph with the same Label.
     Note:  Assumes the graph is ordered.
     Note:  if prev = nil then adds N as the first node in the graph.
   */
  if (prev == NULL)
    prev = parent;
  n->ndnext = prev->ndnext;
  prev->ndnext = n;
  n->ndparent = parent;
  n->ndlabel = prev->ndlabel;
  while (n != NULL) {
    n->ndlabel++;
    n = n->ndnext;
  }
}  /* LinkNodeIntoGraph */


/* macro procedure ChangeEdgeType( E : EGPtr; T : STPtr ); */
/* Changes the type of the edge E to T */


/* macro procedure ChangeNextNode( CurrentNode, NextNode : NDPtr ); */
/* Assumes CurrentNode <> nil */


Static Void removefunction(fungraph)
node *fungraph;
{
  /* Disconnects the given function from the environment and
   removes all its nodes.  */
  linkrec *funlink, *prevlink;
  graph *prevgraph, *fgraph;

  /* FunGraph is connected at both the top and the bottom.  Find the
     top connection and break it first */
  prevgraph = module->UU.U2.ndsubsid;
  if (prevgraph->grnode == fungraph) {  /* first in list, remove it */
    if (prevgraph->grnext == NULL)
      firstfunction = NULL;
    else
      firstfunction = prevgraph->grnext->grnode;
    module->UU.U2.ndsubsid = prevgraph->grnext;
    prevgraph->grnext = NULL;
    prevgraph->grnode = NULL;
  } else {  /* find the previous element, then remove link to FunGraph */
    while (prevgraph->grnext->grnode != fungraph)
      prevgraph = prevgraph->grnext;
    fgraph = prevgraph->grnext;
    prevgraph->grnext = fgraph->grnext;
    fgraph->grnext = NULL;
    fgraph->grnode = NULL;
  }
  /* Now unlink at the bottom end */
  funlink = fungraph->UU.U1.ndlink;
  if (funlink == funclist) {
    funclist = funlink->lknext;
    funlink->lknext = NULL;
  } else {
    prevlink = funclist;
    while (prevlink->lknext != funlink)
      prevlink = prevlink->lknext;
    prevlink->lknext = funlink->lknext;
    funlink->lknext = NULL;
  }
  funlink->lkgraph = NULL;
  /* Now remove the graph nodes from the universe */
  fungraph->UU.U1.ndlink = NULL;
  removenode(fungraph);
}  /* RemoveFunction */



Static Void cleanupgraph PP((node *g));


Static Void cleanupnewiter(loop)
node *loop;
{
  node *bodyg;
  long lstart, lend, port_, maxloopin;
  port *e, *ine, *oute;

  bodyg = toiterbodygraph(loop);
  e = bodyg->ndilist;
  e = e->pttonext;
  lstart = e->pttoport;
  lend = largestinputportnumber(bodyg);
  maxloopin = largestinputportnumber(loop);

  /* Check for unused loop input Ports */

  for (port_ = 2; port_ <= maxloopin; port_++) {
    e = getoutputedge(bodyg, port_);
    oute = getoutputedge(loop, port_);
    if (e == NULL && oute == NULL) {
      e = getinputedge(loop, port_);
      if (e != NULL) {
	disconnectedgefromsource(e);
	disconnectedgefromdest(e);
      }
      if (getinputedge(bodyg, port_) == NULL) {
	shiftinputports(loop, port_, -1L);
	shiftoutputports(bodyg, port_, -1L);
	shiftinputports(bodyg, port_, -1L);
	shiftoutputports(loop, port_, -1L);
      }
    }  /*then*/
  }  /*for*/

  /* Check for unused L ports */

  for (port_ = lstart; port_ <= lend; port_++) {
    ine = getinputedge(bodyg, port_);
    oute = getoutputedge(bodyg, port_);
    e = getoutputedge(loop, port_);
    if (e == NULL && oute == NULL && ine != NULL) {
      disconnectedgefromsource(ine);
      disconnectedgefromdest(ine);
      shiftinputports(loop, port_, -1L);
      shiftoutputports(bodyg, port_, -1L);
      shiftinputports(bodyg, port_, -1L);
      shiftoutputports(loop, port_, -1L);
    }  /*then*/
  }  /*for*/
  cleanupgraph(bodyg);
}  /*CleanUpNewIter*/


Static Void cleanupforall(loop)
node *loop;
{
  long port_, count, k, l, t;
  port *e;
  node *geng, *bodyg, *retg;
  long FORLIM;

  geng = toforallgeneratorgraph(loop);
  bodyg = toforallbodygraph(loop);
  retg = toforallreturnsgraph(loop);
  k = largestinputportnumber(loop);
  l = largestinputportnumber(geng);
  if (l == 0)
    l = k;
  t = largestinputportnumber(bodyg);
  if (t == 0)
    t = l;

  /* walk input edges of Returns graph, removing unused edges */
  port_ = 1;
  FORLIM = largestinputportnumber(retg);
  for (count = 1; count <= FORLIM; count++) {
    if (getoutputedge(loop, port_) == NULL) {
      e = getinputedge(retg, port_);
      if (e != NULL)
	removeedge(&e);
      shiftinputports(retg, port_, -1L);
      shiftoutputports(loop, port_, -1L);
    } else
      port_++;
  }

  /* remove unused nodes of this graph */
  cleanupgraph(retg);

  /* Check for missing temporaries */
  port_ = l + 1;
  for (count = port_; count <= t; count++) {
    if (getoutputedge(retg, port_) == NULL) {
      e = getinputedge(bodyg, port_);
      if (e != NULL)
	removeedge(&e);
      shiftoutputports(retg, port_, -1L);
      shiftinputports(bodyg, port_, -1L);
    } else
      port_++;
  }

  /* Now remove dead code from the body graph */
  cleanupgraph(bodyg);

  /* ************  CANNOT REMOVE CONTROL INFO IN GENERATOR GRAPH **********/
/* p2c: nl.p, line 5901: Note: Changed "* /" to "% /" in comment [140]
    /* Check for missing Loop values %/
    port := K+1;
    for count := port to L do
      if (GetOutputEdge( BodyG, port ) = nil) and
         (GetOutputEdge( RetG, port ) = nil) then
        begin
          E := GetInputEdge( GenG, port );
          if E <> nil then RemoveEdge( E );
          ShiftInputPorts( GenG, port, -1 );
          ShiftOutputPorts( BodyG, port, -1 );
          ShiftInputPorts( BodyG, port, -1 );
          ShiftOutputPorts( RetG, port, -1 );
        end
      else
        port := succ( port );
  */
/* p2c: nl.p, line 5917: Note: Changed "* /" to "% /" in comment [140]
    /* Now Remove Dead Code in the Generator graph %/
    CleanUpGraph( GenG );
****************************************************************   */

  /* Check for unused Loop imports */
  port_ = 1;
  for (count = port_; count <= k; count++) {
    if ((getoutputedge(geng, port_) == NULL) & (getoutputedge(bodyg, port_) ==
	  NULL) & (getoutputedge(retg, port_) == NULL)) {
      e = getinputedge(loop, port_);
      if (e != NULL)
	removeedge(&e);
      shiftinputports(loop, port_, -1L);
      shiftoutputports(geng, port_, -1L);
      shiftinputports(geng, port_, -1L);
      shiftoutputports(bodyg, port_, -1L);
      shiftinputports(bodyg, port_, -1L);
      shiftoutputports(retg, port_, -1L);
    } else
      port_++;
  }
}  /* CleanUpForall */



Static Void cleanupiterloop(loop)
node *loop;
{
  node *initg, *testg, *bodyg, *retg;
  long k, l, t, port_, count;
  port *e;
  long FORLIM;

  initg = toinitgraph(loop);
  testg = totestgraph(loop);
  bodyg = tobodygraph(loop);
  retg = toreturnsgraph(loop);
  k = largestinputportnumber(loop);
  l = largestinputportnumber(initg);
  if (l == 0)
    l = k;
  t = largestinputportnumber(bodyg);
  if (t == 0)
    t = l;

  /* walk input edges of Returns graph, removing unused edges */
  port_ = 1;
  FORLIM = largestinputportnumber(retg);
  for (count = 1; count <= FORLIM; count++) {
    if (getoutputedge(loop, port_) == NULL) {
      e = getinputedge(retg, port_);
      if (e != NULL)
	removeedge(&e);
      shiftinputports(retg, port_, -1L);
      shiftoutputports(loop, port_, -1L);
    } else
      port_++;
  }

  cleanupgraph(retg);
  cleanupgraph(testg);

  port_ = l + 1;
  for (count = port_; count <= t; count++) {
    if ((getoutputedge(retg, port_) == NULL) &
	(getoutputedge(testg, port_) == NULL)) {
      e = getinputedge(bodyg, port_);
      if (e != NULL)
	removeedge(&e);
      shiftinputports(bodyg, port_, -1L);
      shiftoutputports(testg, port_, -1L);
      shiftoutputports(retg, port_, -1L);
    } else
      port_++;
  }

  cleanupgraph(bodyg);

  port_ = k + 1;
  for (count = port_; count <= l; count++) {
    if ((getoutputedge(testg, port_) == NULL) &
	(getoutputedge(bodyg, port_) == NULL) & (getinputedge(bodyg, port_) ==
	  NULL) & (getoutputedge(retg, port_) == NULL)) {
      e = getinputedge(initg, port_);
      if (e != NULL)
	removeedge(&e);
      shiftinputports(initg, port_, -1L);
      shiftoutputports(testg, port_, -1L);
      shiftoutputports(bodyg, port_, -1L);
      shiftinputports(bodyg, port_, -1L);
      shiftoutputports(retg, port_, -1L);
    } else
      port_++;
  }

  cleanupgraph(initg);

  port_ = 1;
  for (count = port_; count <= k; count++) {
    if ((getoutputedge(initg, port_) == NULL) & (getoutputedge(testg, port_) ==
	  NULL) & (getoutputedge(bodyg, port_) == NULL) &
	(getoutputedge(retg, port_) == NULL)) {
      e = getinputedge(loop, port_);
      if (e != NULL)
	removeedge(&e);
      shiftinputports(loop, port_, -1L);
      shiftoutputports(initg, port_, -1L);
      shiftinputports(initg, port_, -1L);
      shiftoutputports(testg, port_, -1L);
      shiftoutputports(bodyg, port_, -1L);
      shiftinputports(bodyg, port_, -1L);
      shiftoutputports(retg, port_, -1L);
    } else
      port_++;
  }
}  /* CleanUpIterLoop */


Static Void cleanupselect(n)
node *n;
{
  long k, r, maxr, grnum, subgr, count, port_;
  node *g;
  port *e;
  boolean empty;

  grnum = numbofsubgraphs(n) - 1;
  k = largestinputportnumber(n);
  maxr = 0;
  for (subgr = 1; subgr <= grnum; subgr++) {
    r = largestinputportnumber(tochildgraph(n, subgr));
    if (r > maxr)
      maxr = r;
  }

  port_ = 1;
  for (count = 1; count <= maxr; count++) {
    if (getoutputedge(n, port_) == NULL) {
      shiftoutputports(n, port_, -1L);
      for (subgr = 1; subgr <= grnum; subgr++) {
	g = tochildgraph(n, subgr);
	e = getinputedge(g, port_);
	if (e != NULL)
	  removeedge(&e);
	shiftinputports(g, port_, -1L);
      }
    } else
      port_++;
  }

  /* remove dead code from subgraphs */
  for (subgr = 0; subgr <= grnum; subgr++)
    cleanupgraph(tochildgraph(n, subgr));

  /* remove unused inputs */
  port_ = 1;
  for (count = 1; count <= k; count++) {
    empty = true;
    for (subgr = 0; subgr <= grnum; subgr++)
      empty &= (getoutputedge(tochildgraph(n, subgr), port_) == NULL);
    if (empty) {
      e = getinputedge(n, port_);
      if (e != NULL)
	removeedge(&e);
      shiftinputports(n, port_, -1L);
      for (subgr = 0; subgr <= grnum; subgr++)
	shiftoutputports(tochildgraph(n, subgr), port_, -1L);
    } else
      port_++;
  }
}  /* CleanUpSelect */


Static Void cleanuptagcase(n)
node *n;
{
  long k, r, maxr, grnum, subgr, count, port_;
  node *g;
  port *e;
  boolean empty;

  grnum = numbofsubgraphs(n) - 1;
  k = largestinputportnumber(n);
  maxr = 0;
  for (subgr = 0; subgr <= grnum; subgr++) {
    r = largestinputportnumber(tochildgraph(n, subgr));
    if (r > maxr)
      maxr = r;
  }

  /* remove unused outputs */
  port_ = 1;
  for (count = 1; count <= maxr; count++) {
    if (getoutputedge(n, port_) == NULL) {
      shiftoutputports(n, port_, -1L);
      for (subgr = 0; subgr <= grnum; subgr++) {
	g = tochildgraph(n, subgr);
	e = getinputedge(g, port_);
	if (e != NULL)
	  removeedge(&e);
	shiftinputports(g, port_, -1L);
      }
    } else
      port_++;
  }

  /* remove dead code in all subgraphs */
  for (subgr = 0; subgr <= grnum; subgr++)
    cleanupgraph(tochildgraph(n, subgr));

  /* remove unused inputs */
  port_ = 2;
  for (count = 2; count <= k; count++) {
    empty = true;
    for (subgr = 0; subgr <= grnum; subgr++)
      empty &= (getoutputedge(tochildgraph(n, subgr), port_) == NULL);
    if (empty) {
      e = getinputedge(n, port_);
      if (e != NULL)
	removeedge(&e);
      shiftinputports(n, port_, -1L);
      for (subgr = 0; subgr <= grnum; subgr++)
	shiftoutputports(tochildgraph(n, subgr), port_, -1L);
    } else
      port_++;
  }
}  /* CleanUpTagCase */


Static Void cleanupifthenelse(n)
node *n;
{
  long k, r, maxr, grnum, subgr, count, port_;
  node *g;
  port *e;
  boolean empty;

  grnum = numbofsubgraphs(n) - 1;
  k = largestinputportnumber(n);
  maxr = 0;
  for (subgr = 0; subgr <= grnum; subgr++) {
    if ((subgr & 1) == 0 || subgr == grnum)
    {  /* only true and false subgraphs */
      r = largestinputportnumber(tochildgraph(n, subgr));
      if (r > maxr)
	maxr = r;
    }
  }

  port_ = 1;
  for (count = 1; count <= maxr; count++) {
    if (getoutputedge(n, port_) == NULL) {
      shiftoutputports(n, port_, -1L);
      for (subgr = 0; subgr <= grnum; subgr++) {
	if ((subgr & 1) == 0 || subgr == grnum)
	{  /* only true and false subgraphs */
	  g = tochildgraph(n, subgr);
	  e = getinputedge(g, port_);
	  if (e != NULL)
	    removeedge(&e);
	  shiftinputports(g, port_, -1L);
	}
      }
    } else
      port_++;
  }

  /* remove dead code from subgraphs */
  for (subgr = 0; subgr <= grnum; subgr++)
    cleanupgraph(tochildgraph(n, subgr));

  /* remove unused inputs */
  /* NOTE:  Input on port 1 is control information and can't be removed */
  port_ = 2;
  for (count = 2; count <= k; count++) {
    empty = true;
    for (subgr = 0; subgr <= grnum; subgr++)
      empty &= (getoutputedge(tochildgraph(n, subgr), port_) == NULL);
    if (empty) {
      e = getinputedge(n, port_);
      if (e != NULL)
	removeedge(&e);
      shiftinputports(n, port_, -1L);
      for (subgr = 0; subgr <= grnum; subgr++)
	shiftoutputports(tochildgraph(n, subgr), port_, -1L);
    } else
      port_++;
  }

}  /* CleanUpIfThenElse */


#define stackbucketsize  50


typedef struct nodebucket {
  struct nodebucket *prev, *next;
  node *elems[stackbucketsize];
} nodebucket;

typedef struct ndstack {
  long length;
  nodebucket *firstbucket, *lastbucket;
} ndstack;


Local Void nsinit(s)
ndstack *s;
{
  s->length = 0;
  s->firstbucket = NULL;
  s->lastbucket = NULL;
}

Local boolean nsempty(s)
ndstack *s;
{
  return (s->length == 0);
}

Local Void nspush(s, n)
ndstack *s;
node *n;
{
  nodebucket *b;
  long ix;

  s->length++;
  ix = (s->length - 1) % stackbucketsize + 1;
/* p2c: nl.p, line 6254:
 * Note: Using % for possibly-negative arguments [317] */
  if (ix == 1) {
    b = (nodebucket *)Malloc(sizeof(nodebucket));
    if (s->lastbucket == NULL) {  /* stack was empty */
      s->firstbucket = b;
      s->lastbucket = b;
      b->prev = NULL;
    } else {
      s->lastbucket->next = b;
      b->prev = s->lastbucket;
      s->lastbucket = b;
    }
    b->next = NULL;
  }
  /* must add a new bucket */
  /* put element in */
  s->lastbucket->elems[ix - 1] = n;   /* with */
}  /* NSPush */

Local node *nspop(s)
ndstack *s;
{
  node *Result;
  long ix;
  nodebucket *b;

  if (s->length == 0)   /* with */
    return NULL;
  ix = (s->length - 1) % stackbucketsize + 1;
/* p2c: nl.p, line 6289:
 * Note: Using % for possibly-negative arguments [317] */
  Result = s->lastbucket->elems[ix - 1];
  s->length--;
  if (ix != 1)
    return Result;
  if (s->firstbucket == s->lastbucket) {
    b = s->lastbucket;
    s->lastbucket = NULL;
    s->firstbucket = NULL;
    Free(b);
    return Result;
  }
  b = s->lastbucket;
  s->lastbucket = b->prev;
  if (s->lastbucket != NULL)
    s->lastbucket->next = NULL;
  b->prev = NULL;
  Free(b);
  return Result;

  /* else */
  /* else */
}  /* NSPop */


Static Void cleanupgraph(g)
node *g;
{
  /*( G : NDPtr )*/
  ndstack stk;
  node *above, *below, *curr;

  nsinit(&stk);
  /* walk down the graph reversing pointer */
  above = g;
  curr = g->ndnext;
  while (curr != NULL) {
    below = curr->ndnext;
    curr->ndnext = above;
    above = curr;
    curr = below;
  }
  /* Walk back up, reversing the pointers again and tagging dead nodes */
  curr = above;
  above = curr->ndnext;
  below = NULL;
  while (curr != g) {
    if (curr->ndolist == NULL) {
      removeinputedges(curr);
      nspush(&stk, curr);
    } else if (curr->ndsort == ndcompound) {
      switch (curr->ndcode) {

      case ifnforall:
	cleanupforall(curr);
	break;

      case ifnloopb:
	cleanupiterloop(curr);
	break;

      case ifnloopa:
	cleanupiterloop(curr);
	break;

      case ifnselect:
	cleanupselect(curr);
	break;

      case ifntagcase:
	cleanuptagcase(curr);
	break;

      case ifnifthenelse:
	cleanupifthenelse(curr);
	break;

      case ifniter:
	cleanupnewiter(curr);
	break;
      }
    }
    curr->ndnext = below;
    below = curr;
    curr = above;
    above = above->ndnext;
  }
  /* now remove marked nodes */
  while (!nsempty(&stk)) {
    curr = nspop(&stk);
    /*if MessagesOn then
              writeln( 'Dead Code Removal:  Removing node ', Curr^.NDId:1);
    */
    removenode(curr);
  }
}  /* CleanUpGraph */

#undef stackbucketsize



Static Void removedeadcode(messageson)
boolean messageson;
{

  /* This routine walks the function graphs of a module, searching for
     and removing dead code.  Code is dead if it produces values that
     can never be used.  One example of this is a node with no output
     edges, another is a node that has output edges connected to a graph
     but for which there are no other implicit connections in other graphs.
     This second case can happen if temporaries are computed in the body
     of a loop and wired the the graph outputs but are never used in the
     test or returns graph.
     The algorithm requires that the nodes have been ordered.  It traverses
     the graph in reverse order (by walking down and reversing pointers then
     walking back up and restoring them) looking for nodes with no output
     edges.  If it finds one it removes all of its input edges and saves
     that node on a stack to be removed later (when the graph is restored).
     It cleans up compound nodes by traversing the subgraphs in the
     reverse order, taking account of impicit connections between subgraphs.
   */
  node *f;

  f = firstfunction;
  while (f != NULL) {
    cleanupgraph(f);
    f = tonextfunction(f);
  }
}  /* RemoveDeadCode */


Local Void rm(n)
node *n;
{
  port *e, *ie, *oe;
  node *srcnode, *cn;
  long srcport, port_, cp;
  stryng lvalue, name;

  /* First, change all output edges */
  ie = n->ndilist;
  while (ie != NULL) {
    port_ = ie->pttoport;
    oe = getoutputedge(n, port_);
    if (oe == NULL) {
      printf("WARNING: RemoveNoOp: No output edge on port %ld", port_);
      printf(" of NoOp node ID = %ld\n", n->ndid);
    } else if (producerportnumber(oe) != port_) {
      printf("WARNING: RemoveNoOp: No output edge on port %ld", port_);
      printf(" of NoOp node ID = %ld\n", n->ndid);
    } else if (ie->ptsort == ptlit) {
      /* make corresponding outputs Literals */
      lvalue = ie->UU.ptlitvalue;
      while (oe != NULL) {
	e = oe;
	oe = nextoutputedgesameport(oe);
	cp = e->pttoport;
	cn = e->pttonode;
	name = e->ptname;
	disconnectedgefromdest(e);
	disconnectedgefromsource(e);
	e = insertliteral(cn, cp, e->pttype, lvalue, name);
	/*  ChangeEdgeToLiteral( E, Lvalue )*/
      }
    } else {
      /* Change the source nodes of all outputs */
      srcnode = producernodeofedge(ie);
      srcport = producerportnumber(ie);
      while (oe != NULL) {
	e = oe;
	oe = nextoutputedgesameport(oe);
	changeedgesrc(e, srcnode, srcport);
      }
    }
    ie = ie->pttonext;
  }
  removenode(n);

  /* IE is an edge */
}  /* rm */


Static Void removenoop(g)
node *g;
{
  node *gn, *n;
  long grnum, FORLIM;

  n = g->ndnext;
  while (n != NULL) {
    gn = n;
    n = n->ndnext;
    if (gn->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(gn);
      for (grnum = 0; grnum < FORLIM; grnum++)
	removenoop(tochildgraph(gn, grnum));
    } else if (gn->ndcode == ifnnoop)
      rm(gn);
  }
}  /* RemoveNoOp */


Local Void pushinside(n, l)
node *n;
port *l;
{
  long port_, gr, cp;
  stryng lvalue, name;
  node *g, *cn;
  port *e, *tmpe;
  long FORLIM;

  port_ = l->pttoport;
  lvalue = l->UU.ptlitvalue;
  removeedge(&l);
  shiftinputports(n, port_, -1L);
  FORLIM = numbofsubgraphs(n);
  for (gr = 0; gr < FORLIM; gr++) {
    g = tochildgraph(n, gr);
    e = getoutputedge(g, port_);
    while (e != NULL) {
      tmpe = e;
      e = nextoutputedgesameport(e);
      cn = tmpe->pttonode;
      cp = tmpe->pttoport;
      name = tmpe->ptname;
      disconnectedgefromdest(tmpe);
      disconnectedgefromsource(tmpe);
      tmpe = insertliteral(cn, cp, tmpe->pttype, lvalue, name);
      /*      ChangeEdgeToLiteral( TmpE, Lvalue )*/
    }
    shiftoutputports(g, port_, -1L);
  }
  switch (n->ndcode) {

  case ifnifthenelse:
  case ifnselect:
  case ifntagcase:
    /* blank case */
    break;

  case ifnforall:
    g = toforallgeneratorgraph(n);
    shiftinputports(g, port_, -1L);
    g = toforallbodygraph(n);
    shiftinputports(g, port_, -1L);
    break;

  case ifnloopb:
  case ifnloopa:
    g = toinitgraph(n);
    shiftinputports(g, port_, -1L);
    g = tobodygraph(n);
    shiftinputports(g, port_, -1L);
    break;
  }/* case */
}  /* PushInside */


Static Void pushliteralsinside(n)
node *n;
{
  port *e, *tmpe;

  e = n->ndilist;
  while (e != NULL) {
    tmpe = e;
    e = e->pttonext;
    if (tmpe->ptsort == ptlit) {
      if (n->ndcode != ifntagcase && n->ndcode != ifnifthenelse ||
	  tmpe->pttoport != 1)
	pushinside(n, tmpe);
      /* This edge represents Control and can't be removed */
    }
  }
}  /* PushLiteralsInside */


Static Void swapinputports(n, p1, p2)
node *n;
long p1, p2;
{

  /* Swap the edges connected to ports P1 and P2 */
  port *e1, *e2;

  e1 = getinputedge(n, p1);
  e2 = getinputedge(n, p2);
  /* Note, this will cause Edge E2 to be inserted before edge E1
     at port P1 (causing Fan-in).  The next operation will rectify
     the situation by removing edge E1 from port P1 and placing
     it at port P2 */
  if (e2 != NULL)
    changeedgedest(e2, n, p1);
  if (e1 != NULL)
    changeedgedest(e1, n, p2);
}  /* SwapInputPorts */


Static Void swapoutputports(n, p1, p2)
node *n;
long p1, p2;
{
  port *etmp, *e1, *e2;

  e1 = getoutputedge(n, p1);
  e2 = getoutputedge(n, p2);
  /* Move the edges on port P1 to port P2 */
  /* NOTE: They will be moved to the FRONT of the list of all edges
          on port P2, the origional edges of port P2 will still be
          there, but at the back of the list */
  while (e1 != NULL) {
    etmp = e1;
    e1 = nextoutputedgesameport(e1);
    changeedgesrc(etmp, n, p2);
  }
  while (e2 != NULL) {
    etmp = e2;
    e2 = nextoutputedgesameport(e2);
    changeedgesrc(etmp, n, p1);
  }
}  /* SwapOutputPorts */


Local long compactinputs(c, startport, lastport)
node *c;
long startport, lastport;
{
  /* -- C is a compound node
     -- 1 <= StartPort <= LastPort <= LargestInputPortNumber( C )
     This function searches for input ports of C whose values
     are not used by any subgraphs.  If such a port is found:
       (1) the input edge corresponding to that port is removed
       (2) that port is "removed" by shifting the remaining
           ports to the left by one unit.
     -- The function returns the number of ports removed.
   */
  long p, ix, lastgraph, numberremoved, grnum;
  port *e;
  boolean portused;

  lastgraph = numbofsubgraphs(c) - 1;
  p = startport;
  numberremoved = 0;
  for (ix = p; ix <= lastport; ix++) {
    portused = false;
    grnum = 0;
    while (grnum <= lastgraph && !portused) {
      if (getoutputedge(tochildgraph(c, grnum), p) != NULL)
	portused = true;
      else
	grnum++;
    }
    if (portused)
      p++;
    else {  /* remove this port */
      numberremoved++;
      e = getinputedge(c, p);
      if (e != NULL)
	removeedge(&e);
      shiftinputports(c, p, -1L);
      for (grnum = 0; grnum <= lastgraph; grnum++)
	shiftoutputports(tochildgraph(c, grnum), p, -1L);
    }
  }
  return numberremoved;
}  /* CompactInputs */


Static Void compactports(c)
node *c;
{

  /* -- C is a compound node
     This routine examines the implicit port connections of C searching
     for port numbers that are no longer used by any subgraph.  If any
     are found, they are eliminated by shifting edges into this gap from
     the right.
   */
  port *tmpe, *e1, *e2, *e3;
  long k, l, t, p, count, ix;
  node *initg, *geng, *testg, *bodyg, *retg;

  k = largestinputportnumber(c);
  switch (c->ndcode) {

  case ifnforall:
    geng = toforallgeneratorgraph(c);
    bodyg = toforallbodygraph(c);
    retg = toforallreturnsgraph(c);
    l = largestinputportnumber(geng);
    if (l == 0)
      l = k;
    t = largestinputportnumber(bodyg);
    if (t == 0)
      t = l;
    /* Compact the K ports */
    count = compactinputs(c, 1L, k);
    if (count > 0) {
      shiftinputports(geng, k + 1, -count);
      shiftinputports(bodyg, l + 1, -count);
      k -= count;
      l -= count;
      t -= count;
    }
    /* Compact the L ports */
    /*  P := K+1;Cannot remove and L ports, even if unused
              count := 0;
              for ix := P to L do
                begin
                  E1 := GetOutputEdge( BodyG, P );
                  E2 := GetOutputEdge( RetG, P );
                  if (E1 = nil) and (E2 = nil) then
                    begin
                      count := succ( count );
                      ShiftOutputPorts( BodyG, P, -1 );
                      ShiftInputPorts( BodyG, P, -1 );
                      ShiftOutputPorts( RetG, P, -1 );
                      TmpE := GetInputEdge( GenG, P );
                      if TmpE <> nil then
                        RemoveEdge( TmpE );
                      ShiftInputPorts( GenG, P, -1 )
                    end
                  else
                    P := succ( P )
                end;
              L := L - count;
              T := T - count;*/
    /* Compact the T ports */
    count = 0;
    p = l + 1;
    for (ix = p; ix <= t; ix++) {
      if (getoutputedge(retg, p) == NULL) {
	count++;
	shiftoutputports(retg, p, -1L);
	tmpe = getinputedge(bodyg, p);
	if (tmpe != NULL)
	  removeedge(&tmpe);
	shiftinputports(bodyg, p, -1L);
      } else
	p++;
    }
    t -= count;
    break;
    /* IFNForall */

  case ifnloopa:
  case ifnloopb:
    initg = toinitgraph(c);
    testg = totestgraph(c);
    bodyg = tobodygraph(c);
    retg = toreturnsgraph(c);
    l = largestinputportnumber(initg);
    if (l == 0)
      l = k;
    t = largestinputportnumber(bodyg);
    if (t == 0)
      t = l;
    /* Compact the K ports */
    count = compactinputs(c, 1L, k);
    if (count > 0) {
      shiftinputports(initg, k + 1, -count);
      shiftinputports(bodyg, k + 1, -count);
      k -= count;
      l -= count;
      t -= count;
    }
    /* Compact the L ports */
    p = k + 1;
    count = 0;
    for (ix = p; ix <= l; ix++) {
      e1 = getoutputedge(testg, p);
      e2 = getoutputedge(bodyg, p);
      e3 = getoutputedge(retg, p);
      if (e1 == NULL && e2 == NULL && e3 == NULL) {
	count++;
	shiftoutputports(testg, p, -1L);
	shiftoutputports(bodyg, p, -1L);
	tmpe = getinputedge(bodyg, p);
	if (tmpe != NULL)
	  removeedge(&tmpe);
	shiftinputports(bodyg, p, -1L);
	shiftoutputports(retg, p, -1L);
	tmpe = getinputedge(initg, p);
	if (tmpe != NULL)
	  removeedge(&tmpe);
	shiftinputports(initg, p, -1L);
      } else
	p++;
    }
    l -= count;
    t -= count;
    /* Compact the T ports */
    count = 0;
    p = l + 1;
    for (ix = p; ix <= t; ix++) {
      e1 = getoutputedge(testg, p);
      e2 = getoutputedge(retg, p);
      if (e1 == NULL && e2 == NULL) {
	count++;
	shiftoutputports(testg, p, -1L);
	shiftoutputports(retg, p, -1L);
	tmpe = getinputedge(bodyg, p);
	if (tmpe != NULL)
	  removeedge(&tmpe);
	shiftinputports(bodyg, p, -1L);
      } else
	p++;
    }
    t -= count;
    break;
    /* IFNLoopA, IFNLoopB */

  case ifnselect:
    count = compactinputs(c, 1L, k);
    break;
    /* IFNSelect */

  case ifntagcase:
    count = compactinputs(c, 2L, k);
    break;
    /* IFNTagCase */

  case ifnifthenelse:
    count = compactinputs(c, 1L, k);
    break;
    /* IFNIfThenElse */
  }/* case */
}  /* CompactPorts */


Static Void replacecallwithgraph(cnode, fgraph)
node **cnode, *fgraph;
{

  /* Preconditions:
      1) Cnode is a call node to the function whose graph is Fgraph
      2) Fgraph has already been determined to be inline expandable
    Postconditions:
      1) Fgraph is copied to a temporary location
      2) Cnode is removed from its surrounding graph and the contents of
         the copied fgraph are put in its place.
      3) The edges at the graph boundry are wired as when the call node
         existed.
  */
  node *n, *parent, *prev, *next, *newg, *srcnode, *cn;
  long port_, srcport, cp;
  port *e, *ce, *ge, *tmpe;
  stryng litvalue, name;

  newg = copynode(fgraph);

  /* Now change the input edges of Cnode */
  e = (*cnode)->ndilist;
  e = e->pttonext;   /* First Edge Is Function Name */
  while (e != NULL) {
    ce = e;
    e = e->pttonext;
    port_ = ce->pttoport - 1;
    if (ce->ptsort == ptlit) {
      litvalue = ce->UU.ptlitvalue;
      ge = getoutputedge(newg, port_);
      while (ge != NULL) {
	tmpe = ge;
	ge = nextoutputedgesameport(ge);
	cn = tmpe->pttonode;
	cp = tmpe->pttoport;
	name = tmpe->ptname;
	disconnectedgefromsource(tmpe);
	disconnectedgefromdest(tmpe);
	tmpe = insertliteral(cn, cp, tmpe->pttype, litvalue, name);
	/*ChangeEdgeToLiteral( TmpE, LitValue );*/
      }
      continue;
    }
    srcnode = producernodeofedge(ce);
    srcport = producerportnumber(ce);
    ge = getoutputedge(newg, port_);
    while (ge != NULL) {
      tmpe = ge;
      ge = nextoutputedgesameport(ge);
      changeedgesrc(tmpe, srcnode, srcport);
    }
  }

  /* Now change the output edges */
  e = newg->ndilist;
  while (e != NULL) {
    ge = e;
    e = e->pttonext;
    port_ = ge->pttoport;
    srcnode = producernodeofedge(ge);
    srcport = producerportnumber(ge);
    removeedge(&ge);
    ce = getoutputedge(*cnode, port_);
    while (ce != NULL) {
      tmpe = ce;
      ce = nextoutputedgesameport(ce);
      changeedgesrc(tmpe, srcnode, srcport);
    }
  }

  /* Now remove the call node and insert the graph contents */
  parent = (*cnode)->ndparent;
  prev = toprevnode(*cnode);
  if (prev == NULL)
    prev = parent;
  next = (*cnode)->ndnext;
  removenode(*cnode);
  n = newg->ndnext;
  prev->ndnext = n;
  while (n != NULL) {
    n->ndparent = parent;
    prev = n;
    n = n->ndnext;
    if (n == NULL)
      prev->ndnext = next;
  }
  newg->ndnext = NULL;
  removenode(newg);   /*nonrecursively*/

  /* The Graph must now be renumbered to avoid label conflicts */
  renumbergraph(parent, false);
}  /* ReplaceCallWithGraph */


Static Void replacefunctiongraph(newfg, oldfg)
node *newfg, *oldfg;
{


  /*  Replace the function represented by OldFG with NewFG.  Assumes OldFG is
      a function in the current module.   */
  graph *g;

  newfg->UU.U1.ndlink = oldfg->UU.U1.ndlink;
  newfg->UU.U1.ndlink->lkgraph = newfg;

  g = module->UU.U2.ndsubsid;
  while (g->grnode != oldfg)
    g = g->grnext;
  g->grnode = newfg;

  if (firstfunction == oldfg)
    firstfunction = newfg;
}


Local Void buildbasictype(base, name)
char base;
Char *name;
{
  /* builds a symbol table entry an IF1 basic type */
  /* BaseRange is a subrange of defined constants  */
  stentry *s;

  s = newtypealloc(iftbasic);
  s->stlabel = base + 1;
  string10(&s->stliteral, name);
  s->UU.stbasic = base;
  typetable[s->stlabel - 1] = s;
}  /* BuildBasicType */





/* dlz - reorganized and rewrote 8/87 to avoid referencing possibly
   uncompiled fields (vivek's), extracted similar sequences, etc.
   Also, rewrote pragma assignments thru new routines AssignNodePragma
   and AssignEdgePragma, now pragmas not usable in this version
   ignored and a cautionary message printed */


Static Void initmodule()
{
  /* Initializes the global variables needed for loading the program */
  long i;
  stentry *t;
  node *WITH;

  univnodecnt = 0;
  univedgecnt = 0;
  univmodulecnt = 0;
  initstamps();
  funclist = NULL;
  firstfunction = NULL;
  module = (node *)Malloc(sizeof(node));
  WITH = module;
  WITH->ndcode = ifnmodule;
  WITH->ndsort = ndcompound;
  WITH->UU.U2.ndsubsid = NULL;
  buildbasictype(ifbboolean, "Boolean   ");
  buildbasictype(ifbcharacter, "Character ");
  buildbasictype(ifbdouble, "Double    ");
  buildbasictype(ifbinteger, "Integer   ");
  buildbasictype(ifbnull, "Null      ");
  buildbasictype(ifbreal, "Real      ");
  buildbasictype(ifbwild, "WildBasic ");
  tthwm = 7;
  for (i = tthwm; i < entrymax; i++)
    typetable[i] = NULL;
  /* Add the Wild Card Type to the Type Table */
  t = getwildtype();
}  /* InitModule */


Local Void adjustedges(n)
node *n;
{
  port *e;

  e = n->ndilist;
  while (e != NULL) {
    if (e->pttype != NULL)
      e->pttype = e->pttype->stequivchain;
    e = e->pttonext;
  }
}  /* AdjustEdges */

Local Void adjustgraph(g)
node *g;
{
  node *n;
  long grnum, FORLIM;

  adjustedges(g);
  if (g->UU.U1.ndtype != NULL)
    g->UU.U1.ndtype = g->UU.U1.ndtype->stequivchain;
  n = g->ndnext;
  while (n != NULL) {
    adjustedges(n);
    if (n->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(n);
      /* walk the subgraphs of the compound node */
      for (grnum = 0; grnum < FORLIM; grnum++)
	adjustgraph(tochildgraph(n, grnum));
    }
    n = n->ndnext;
  }
}  /* AdjustGraph */


Static Void adjusttypepointers(newmodule)
node *newmodule;
{

  /* Pre:  The types in the TypeTable have been smashed and all
          entries STEquivChain point to the representative of
          that entries equivalence class.  The Edges and Literals
          in the subgraphs of NewModule still point to the elements
          of the equivalence class but not necessairly to the
          representative.
    Post: All edges and literals of the subgraphs of NewModule
          have symbol table entries pointing to the representative
          of the equivalence classes.
          Also, all fields of the type records point to the
          representative of the class they used to point to.
  */
  long funcnum, FORLIM;

  adjustgraphptrs();
  FORLIM = numbofsubgraphs(newmodule);
  /* walk the function graphs */
  for (funcnum = 0; funcnum < FORLIM; funcnum++)
    adjustgraph(tochildgraph(newmodule, funcnum));
}  /* AdjustTypePointers */


#define tab             9
#define hashtablesize   1000   /* must be HashTableUB + 1 */
#define hashtableub     999   /* must be HashTableSize - 1 */


typedef enum {
  ifpoffset, ifparsize, ifpname, ifpsrcline, ifpwiline, ifpbounds, ifpcoord,
  ifptypesize, ifpexpand, ifpemark, ifprectype, ifpexectime, ifpprocnumber,
  ifpschednumber, ifpfrequency, ifpdatasize, ifpcardinal, ifpcompexpand,
  ifpcomm, ifpsetrc, ifpprodmodrc, ifpconmodrc
} pragmatype;

typedef struct hashtablerecord {
  long key, offset;
} hashtablerecord;


typedef enum {
  stilllooking, tablefull, foundlabel, foundemptyslot
} searchcodes;


#define nodemax         3000   /* Maximum number of nodes in a single graph */


/* Local variables for loadprogram: */
struct LOC_loadprogram {
  long newstamps[9];
  long oldtthwm;
  node *newmodule;
  linkrec *newflist;
} ;

/* Local variables for readif1file: */
struct LOC_readif1file {
  struct LOC_loadprogram *LINK;
  boolean Result;
  linkrec **newflist, **newfend;
  FILE **source;
  jmp_buf _JL998;
  long i, lineno;
  long digits[9], letters[9], legallinechars[9];
  hashtablerecord hashtable[hashtableub + 1];
  stryng pragname;   /* Globals set in ReadPragma */
  long pragint1, pragint2;   /* Globals set in ReadPragma */
  double pragreal;   /* Glabals set in ReadPragma */
  boolean ignoredsomepragmas;   /* dlz - 8/87 warning flag   */
} ;

Local graph *readgraphs PP((struct LOC_readif1file *LINK));

Local Void warnmessage(LINK)
struct LOC_readif1file *LINK;
{
  printf("WARNING:  Line: %4ld *** ", LINK->lineno);
}  /* WarnMessage */

Local Void errmessage(LINK)
struct LOC_readif1file *LINK;
{
  printf("ERROR:  Line: %4ld *** ", LINK->lineno);
  LINK->Result = false;
}  /* ErrMessage */

Local Void skipjunk(LINK)
struct LOC_readif1file *LINK;
{
  /* procedure SkipJunk scans the Source line until it finds
     either a comment (in quotes), a pragma (beginning with %)
     or the end of line. */
  boolean finished;

  finished = false;
  while (!finished) {
    if (P_eoln(*LINK->source)) {
      finished = true;
      break;
    }
    if (P_peek(*LINK->source) == '%' || P_peek(*LINK->source) == '"') {
/* p2c: nl.p, line 7114:
 * Note: File parameter source needs its associated buffers [318] */
      finished = true;
    } else
      getc(*LINK->source);
  }

/* p2c: nl.p, line 7115:
 * Note: File parameter source needs its associated buffers [318] */
}  /* SkipJunk */

Local boolean readreal(val, LINK)
double *val;
struct LOC_readif1file *LINK;
{
  boolean Result;
  Char ch;

  while (P_peek(*LINK->source) == ' ') {
    ch = getc(*LINK->source);
    if (ch == '\n')
      ch = ' ';
  }
/* p2c: nl.p, line 7124:
 * Note: File parameter source needs its associated buffers [318] */
  if (!(P_inset(P_peek(*LINK->source), LINK->digits) |
	(P_peek(*LINK->source) == '-')))
    return false;
/* p2c: nl.p, line 7126:
 * Note: File parameter source needs its associated buffers [318] */
/* p2c: nl.p, line 7126:
 * Note: File parameter source needs its associated buffers [318] */
  Result = true;
  fscanf(*LINK->source, "%lg", val);
  return Result;
}  /* ReadReal */

Local boolean readinteger(val, LINK)
long *val;
struct LOC_readif1file *LINK;
{
  /* reads an integer of the form [digit]+
       - returns if successful or not
       - if success then returns integer in Val
       - does not consume any characters beyond the integer
  */
  boolean Result;

  if (!(P_inset(P_peek(*LINK->source), LINK->digits) |
	(P_peek(*LINK->source) == '-')))
    return false;
/* p2c: nl.p, line 7142:
 * Note: File parameter source needs its associated buffers [318] */
/* p2c: nl.p, line 7142:
 * Note: File parameter source needs its associated buffers [318] */
  Result = true;
  fscanf(*LINK->source, "%ld", val);
  return Result;
}  /* ReadInteger */

Local Void readvalidinteger(val, LINK)
long *val;
struct LOC_readif1file *LINK;
{
  /* - Skips leading blanks.
     - gives error message and aborts when reading an
       integer fails
   */
  while (P_peek(*LINK->source) == (Char)tab || P_peek(*LINK->source) == ' ')
    getc(*LINK->source);
/* p2c: nl.p, line 7157:
 * Note: File parameter source needs its associated buffers [318] */
/* p2c: nl.p, line 7157:
 * Note: File parameter source needs its associated buffers [318] */
  if (readinteger(val, LINK))
    return;
  errmessage(LINK);
  printf("Expected to read an integer\n");
  longjmp(LINK->_JL998, 1);
}  /* ReadValidInteger */

Local Void readstamp(LINK)
struct LOC_readif1file *LINK;
{
  /* read the stamp into a comment string and set the StampSet.
     C$  [A-Z] progname  varsion  time
  */
  Char ch;
  stryng str;
  long SET[9];

  /* 'C' has already been read */
/* p2c: nl.p, line 7175:
 * Note: File parameter source needs its associated buffers [318] */
  getc(*LINK->source);
  /* find the stamp identifier */
  while (P_peek(*LINK->source) == (Char)tab || P_peek(*LINK->source) == ' ')
    getc(*LINK->source);
/* p2c: nl.p, line 7177:
 * Note: File parameter source needs its associated buffers [318] */
/* p2c: nl.p, line 7177:
 * Note: File parameter source needs its associated buffers [318] */
  ch = getc(*LINK->source);
  if (ch == '\n')
    ch = ' ';
  P_addset(LINK->LINK->newstamps, ch);
  readstring(LINK->source, &str);
  /* Note, ReadString issues a readln */
  stamp[ch - 'A'] = str;
}  /* ReadStamp */

Local boolean classified(a, b, code)
Char a, b;
pragmatype *code;
{
  /* Classify the characters stored in the variables 'a' and 'b',
     return false if they represent an unknown pragma */
  boolean Result;

  Result = true;
  if (a != 'x' && a != 'w' && a != 's' && a != 'p' && a != 'o' && a != 'n' &&
      a != 'm' && a != 'i' && a != 'f' && a != 'e' && a != 'd' && a != 'c' &&
      a != 'b' && a != 'a')
    return false;
  switch (a) {

  case 'a':
    if (b == 'r')
      *code = ifparsize;
    else
      Result = false;
    break;

  case 'b':
    if (b == 'd')
      *code = ifpbounds;
    else
      Result = false;
    break;

  case 'c':
    if (b == 'd')
      *code = ifpcardinal;
    else if (b == 'o')
      *code = ifpcomm;
    else if (b == 'm')
      *code = ifpconmodrc;
    else
      Result = false;
    break;

  case 'd':
    if (b == 's')
      *code = ifpdatasize;
    else
      Result = false;
    break;

  case 'e':
    if (b == 'x')
      *code = ifpexpand;
    else if (b == 't')
      *code = ifpexectime;
    else if (b == 'p')
      *code = ifpcompexpand;
    else
      Result = false;
    break;

  case 'f':
    if (b == 'q')
      *code = ifpfrequency;
    else
      Result = false;
    break;

  case 'i':
    if (b == 'd')
      *code = ifpschednumber;
    else
      Result = false;
    break;

  case 'm':
    if (b == 'k')
      *code = ifpemark;
    else
      Result = false;
    break;

  case 'n':
    if (b == 'a')
      *code = ifpname;
    else
      Result = false;
    break;

  case 'o':
    if (b == 'f')
      *code = ifpoffset;
    else
      Result = false;
    break;

  case 'p':
    if (b == 'n')
      *code = ifpprocnumber;
    else if (b == 'm')
      *code = ifpprodmodrc;
    else
      Result = false;
    break;

  case 's':
    if (b == 'l')
      *code = ifpsrcline;
    else if (b == 'z')
      *code = ifptypesize;
    else if (b == 't')
      *code = ifprectype;
    else if (b == 'r')
      *code = ifpsetrc;
    else
      Result = false;
    break;

  case 'w':
    if (b == 'l')
      *code = ifpwiline;
    else
      Result = false;
    break;

  case 'x':
    if (b == 'y')
      *code = ifpcoord;
    else
      Result = false;
    break;
  }/* case */
  return Result;
}  /* Classified */

Local boolean readpragma(code, LINK)
pragmatype *code;
struct LOC_readif1file *LINK;
{
  /* Look for constructions of the form "%ab=value" in the comment
     field of an IF1 line.  If one is found and valid return true along
     with the value and the type of pragma, otherwise return false.
     The value will be placed in the global variables:
        PragName, PragInt1, PragInt2
   */
  Char ch, a, b;
  boolean stillsearching, foundpercent, found, finished;
  char state;

  found = false;
  finished = false;
  state = 0;
  while (!finished) {
    if (P_eoln(*LINK->source)) {
      finished = true;
      break;
    }
    switch (state) {

    case 0:
      foundpercent = false;
      stillsearching = true;
      while (stillsearching) {
	if (P_eoln(*LINK->source)) {
	  stillsearching = false;
	  break;
	}
	ch = getc(*LINK->source);
	if (ch == '\n')
	  ch = ' ';
	if (ch == '%') {
	  stillsearching = false;
	  foundpercent = true;
	}
      }
      if (foundpercent)
	state = 1;
      else
	finished = true;
      break;
      /* state 0 */

    case 1:
      ch = getc(*LINK->source);
      if (ch == '\n')
	ch = ' ';
      if (P_inset(ch, LINK->letters)) {
	a = lowercase(ch);
	state = 2;
      } else
	state = 0;
      break;
      /* at this point "%" has been found */
      /* state 1 */

    case 2:
      ch = getc(*LINK->source);
      if (ch == '\n')
	ch = ' ';
      if (P_inset(ch, LINK->letters)) {
	b = lowercase(ch);
	if (classified(a, b, code)) {
	  if (*code == ifpexpand || *code == ifprectype) {
	    found = true;
	    finished = true;
	  } else
	    state = 3;
	} else
	  state = 0;
      } else
	state = 0;
      break;
      /* at this point "%x" has been found */
      /* state 2 */

    case 3:
      ch = getc(*LINK->source);
      if (ch == '\n')
	ch = ' ';
      if (ch == '=')
	state = 4;
      else
	state = 0;
      break;
      /* state 3 */

    case 4:   /* at this point "%ab=" has been found */
      switch (*code) {

      case ifpemark:
	/* Read a character */
	if (P_peek(*LINK->source) == 'R') {
/* p2c: nl.p, line 7304:
 * Note: File parameter source needs its associated buffers [318] */
	  finished = true;
	  found = true;
	  LINK->pragint1 = 1;
/* p2c: nl.p, line 7309:
 * Note: File parameter source needs its associated buffers [318] */
	  getc(*LINK->source);
	} else if (P_peek(*LINK->source) == 'V') {
/* p2c: nl.p, line 7311:
 * Note: File parameter source needs its associated buffers [318] */
	  finished = true;
	  found = true;
	  LINK->pragint1 = 0;
/* p2c: nl.p, line 7316:
 * Note: File parameter source needs its associated buffers [318] */
	  getc(*LINK->source);
	} else if (P_peek(*LINK->source) == 'D') {
/* p2c: nl.p, line 7318:
 * Note: File parameter source needs its associated buffers [318] */
	  finished = true;
	  found = true;
	  LINK->pragint2 = 2;
/* p2c: nl.p, line 7323:
 * Note: File parameter source needs its associated buffers [318] */
	  getc(*LINK->source);
	} else
	  state = 0;
	break;

      case ifpcomm:
	/* Read a character */
	if ((P_peek(*LINK->source) == 'T') | (P_peek(*LINK->source) == 't')) {
/* p2c: nl.p, line 7329:
 * Note: File parameter source needs its associated buffers [318] */
/* p2c: nl.p, line 7329:
 * Note: File parameter source needs its associated buffers [318] */
	  finished = true;
	  found = true;
	  LINK->pragint1 = 1;
/* p2c: nl.p, line 7334:
 * Note: File parameter source needs its associated buffers [318] */
	  getc(*LINK->source);
	} else {
	  finished = true;
	  found = true;
	  LINK->pragint1 = 0;
/* p2c: nl.p, line 7341:
 * Note: File parameter source needs its associated buffers [318] */
	  getc(*LINK->source);
	}
	break;

      case ifpname:
	/* Read an Identifier name */
	if (P_inset(P_peek(*LINK->source), LINK->letters)) {
/* p2c: nl.p, line 7345:
 * Note: File parameter source needs its associated buffers [318] */
	  readidentifier(LINK->source, &LINK->pragname);
	  finished = true;
	  found = true;
	} else
	  state = 0;
	break;

      case ifparsize:
      case ifpoffset:
      case ifpsrcline:
      case ifpwiline:
      case ifptypesize:
      case ifpprocnumber:
      case ifpschednumber:
      case ifpcompexpand:
      case ifpsetrc:
      case ifpprodmodrc:
      case ifpconmodrc:
	/* Read an integer */
	if (readinteger(&LINK->pragint1, LINK)) {
	  finished = true;
	  found = true;
	} else
	  state = 0;
	break;

      case ifpexectime:
      case ifpfrequency:
      case ifpdatasize:
      case ifpcardinal:
	if (readreal(&LINK->pragreal, LINK)) {
	  finished = true;
	  found = true;
	} else
	  state = 0;
	break;

      case ifpbounds:
      case ifpcoord:
	/* Read a pair of integers */
	if (readinteger(&LINK->pragint1, LINK))
	  state = 5;
	else
	  state = 0;
	break;
      }/* case code */
      break;

    case 5:
      /* at this point '%xx=<int>' has been found and we
           are searching for the string ',<int>'       */
      if (P_peek(*LINK->source) == ',') {
	getc(*LINK->source);
	if (P_eoln(*LINK->source))
	  finished = true;
	else if (readinteger(&LINK->pragint2, LINK)) {
	  finished = true;
	  found = true;
	} else
	  state = 0;
      } else
	state = 0;
/* p2c: nl.p, line 7376:
 * Note: File parameter source needs its associated buffers [318] */
/* p2c: nl.p, line 7378:
 * Note: File parameter source needs its associated buffers [318] */
      break;
    }/* case */
  }
  return found;
}  /* ReadPragma */

Local stentry *getspointer(tlabel, LINK)
long tlabel;
struct LOC_readif1file *LINK;
{
  /* Hashes Tlabel into TypeTable, produces error messages if
      - Tlabel is < 0
      - HashTable Size is exceeded
      - TypeTable Size is exceeded
    Returns:
      - nil if error occurred
      - nil if Tlabel = 0
      - pointer to TypeTable entry otherwise
    Note:  If an entry is not found and there is room in the tables
           then it creates a new entry.
    The hashing scheme was used because one of the front end SISAL
    to IF1 compilers was generating seemingly random (and LARGE)
    type labels that were overflowing the type table.
  */
  stentry *Result;
  searchcodes code;
  short stoppingpoint, hashix;
  long key;
  stentry *t;
  hashtablerecord *WITH;

  if (tlabel == 0)
    return NULL;
  if (tlabel < 0) {
    errmessage(LINK);
    printf("Bad Symbol table pointer: %ld\n", tlabel);
    return NULL;
  }
  /* Look in hash table */
  hashix = tlabel % hashtablesize;
/* p2c: nl.p, line 7426:
 * Note: Using % for possibly-negative arguments [317] */
  stoppingpoint = hashix;
  code = stilllooking;
  do {
    key = LINK->hashtable[hashix].key;
    if (key == tlabel)
      code = foundlabel;
    else if (key < 0)
      code = foundemptyslot;
    else {
      hashix = (hashix + 1) % hashtablesize;
      if (hashix == stoppingpoint)
	code = tablefull;
    }
  } while (code == stilllooking);
  switch (code) {

  case stilllooking:   /* should never get here */
    break;

  case tablefull:
    errmessage(LINK);
    printf("HashTable Size Exceeded\n");
    Result = NULL;
    break;
    /* TableFull */

  case foundlabel:
    Result = typetable[LINK->hashtable[hashix].offset - 1];
    break;

  case foundemptyslot:
    if (tthwm >= entrymax) {
      errmessage(LINK);
      printf("Type Table Size Exceeded\n");
      Result = NULL;
    } else {
      tthwm++;
      WITH = &LINK->hashtable[hashix];
      WITH->key = tlabel;
      WITH->offset = tthwm;
      t = (stentry *)Malloc(sizeof(stentry));
      t->stlabel = tthwm;
      t->stid = 0;
      t->stsize = -1;
      t->stequivchain = t;
      typetable[tthwm - 1] = t;
      Result = t;
    }
    break;
  }/* case */
  return Result;
}  /* GetSPointer */

Local Void buildtype(LINK)
struct LOC_readif1file *LINK;
{
  /* reads a Type line and builds the appropriate data structures:
     T  typenumber typetableentry [ additional type information ]
   */
  long code1, code2, typenum;
  pragmatype code;
  stentry *s;

  /* first character is a 'T' */
/* p2c: nl.p, line 7488:
 * Note: File parameter source needs its associated buffers [318] */
  getc(*LINK->source);
  readvalidinteger(&typenum, LINK);

  /* build the data structure */
  s = getspointer(typenum, LINK);
  if (s == NULL) {
    if (typenum == 0) {
      errmessage(LINK);
      printf("Bad Type Identifier");
    }
  } else {
    if (s->stid != 0) {
      errmessage(LINK);
      printf("Double Definition of Type\n");
    } else {
      s->stid = -1;
      s->stsize = -LONG_MAX;
      s->strecurflag = false;
      readvalidinteger(&code1, LINK);
      if ((unsigned long)code1 > ifmaxtype) {
	errmessage(LINK);
	printf("Undefined IF1 Type: %ld\n", code1);
	longjmp(LINK->_JL998, 1);
      } else
	s->stsort = code1;
      switch (s->stsort) {

      case iftwild:   /* Nothing to do */
	break;

      case iftbasic:
	readvalidinteger(&code1, LINK);
	if ((unsigned long)code1 > ifmaxbasic) {
	  errmessage(LINK);
	  printf("Undefined IF1 Basic Type: %ld\n", code1);
	  longjmp(LINK->_JL998, 1);
	} else
	  s->UU.stbasic = code1;
	break;

      case iftfunctiontype:
	readvalidinteger(&code1, LINK);
	s->UU.U3.starg = getspointer(code1, LINK);
	readvalidinteger(&code2, LINK);
	s->UU.U3.stres = getspointer(code2, LINK);
	break;

      case iftarray:
      case iftstream:
      case iftmultiple:
      case iftrecord:
      case iftunion:
      case iftbuffer:
	readvalidinteger(&code1, LINK);
	s->UU.stbasetype = getspointer(code1, LINK);
	break;

      case iftfield:
      case ifttuple:
      case ifttag:
	readvalidinteger(&code1, LINK);
	s->UU.U2.stelemtype = getspointer(code1, LINK);
	readvalidinteger(&code2, LINK);
	s->UU.U2.stnext = getspointer(code2, LINK);
	break;
      }/* case */
    }
  }

  memcpy(s->stliteral.str, blankstring, sizeof(stryngar));
  s->stliteral.len = 0;
  while (readpragma(&code, LINK)) {
    if (code == ifpname)
      s->stliteral = LINK->pragname;
    else if (code == ifptypesize)
      s->stsize = LINK->pragint1;
    else if (code == ifprectype)
      s->strecurflag = true;
  }
  fscanf(*LINK->source, "%*[^\n]");
  getc(*LINK->source);
}  /* BuildType */

/* Local variables for readgraphs: */
struct LOC_readgraphs {
  struct LOC_readif1file *LINK;
  struct {
    long nthigh;
    node *ntnode[nodemax + 1];
  } nodetable;
} ;

Local Void marknodedefined(n, LINK)
node *n;
struct LOC_readgraphs *LINK;
{
  univnodecnt++;
  n->ndid = univnodecnt;
}  /* MarkNodeDefined */

Local Void markedgedefined(e, LINK)
port *e;
struct LOC_readgraphs *LINK;
{
  univedgecnt++;
  e->ptid = univedgecnt;
}  /* MarkEdgeDefined */

Local Void resetnodetable(LINK)
struct LOC_readgraphs *LINK;
{
  for (LINK->LINK->i = LINK->nodetable.nthigh; LINK->LINK->i >= 0; LINK->LINK->i--)
    LINK->nodetable.ntnode[LINK->LINK->i] = NULL;
  LINK->nodetable.nthigh = -1;
}  /* ResetNodeTable */


Local Void assignnodepragma(n, code, LINK)
node *n;
pragmatype code;
struct LOC_readgraphs *LINK;
{
  /*Fill in common pragma values for a node   dlz 8/87*/
  if (((1L << ((long)code)) &
       ((1L << ((long)ifpsrcline)) | (1L << ((long)ifpwiline)) |
	(1L << ((long)ifpcoord)) | (1L << ((long)ifpcompexpand)))) != 0) {
/* p2c: nl.p, line 8522: Note:
 * Line breaker spent 0.7+0.40 seconds, 727 tries on line 8192 [251] */
    switch (code) {

    case ifpsrcline:
      n->ndsrcline = LINK->LINK->pragint1;
      break;

    case ifpwiline:
      n->ndwiline = LINK->LINK->pragint1;
      break;

    case ifpcoord:
      n->ndxcoord = LINK->LINK->pragint1;
      n->ndycoord = LINK->LINK->pragint2;
      break;

    case ifpcompexpand:
      if (LINK->LINK->pragint1 == 1) {
	if (true)
	  n->ndexpanded = 1;
	else
	  n->ndexpanded = 0;
      } else if (false)
	n->ndexpanded = 1;
      else
	n->ndexpanded = 0;
      break;
    }/*case*/
    return;
  }
  if (((1L << ((long)code)) & ((1L << ((long)ifpexectime)) |
	 (1L << ((long)ifpprocnumber)) | (1L << ((long)ifpschednumber)))) != 0) {
    /*fields weren't compiled in this version, => ignore*/
    LINK->LINK->ignoredsomepragmas = true;

  } else if (code == ifpfrequency)
    n->ndfrequency = LINK->LINK->pragreal;
}  /*AssignNodePragma*/


Local Void assignedgepragma(e, code, LINK)
port *e;
pragmatype code;
struct LOC_readgraphs *LINK;
{
  /*Fill in common pragma values for an edge   dlz 8/87*/
  if (((1L << ((long)code)) & ((1L << ((long)ifpoffset)) |
	 (1L << ((long)ifpname)) | (1L << ((long)ifpbounds)) |
	 (1L << ((long)ifpsrcline)) | (1L << ((long)ifpwiline)) |
	 (1L << ((long)ifpemark)) | (1L << ((long)ifpsetrc)) |
	 (1L << ((long)ifpconmodrc)) | (1L << ((long)ifpprodmodrc)))) == 0) {
/* p2c: nl.p, line 8522: Note:
 * Line breaker spent 11.3+0.82 seconds, 5000 tries on line 8244 [251] */
    if (((1L << ((long)code)) & ((1L << ((long)ifpdatasize)) |
	   (1L << ((long)ifpcomm)) | (1L << ((long)ifpcardinal)))) != 0) {
      /*fields not compiled in this version => ignore*/
      LINK->LINK->ignoredsomepragmas = true;
    }
    return;
  }

  switch (code) {

  case ifpoffset:
    e->ptdfaddr = LINK->LINK->pragint1;
    break;

  case ifpname:
    e->ptname = LINK->LINK->pragname;
    break;

  case ifpbounds:
    e->ptlbound = LINK->LINK->pragint1;
    e->ptubound = LINK->LINK->pragint2;
    break;

  case ifpsrcline:
    e->ptsrcline = LINK->LINK->pragint1;
    break;

  case ifpwiline:
    e->ptwiline = LINK->LINK->pragint1;
    break;

  case ifpsetrc:
    e->ptsetrc = LINK->LINK->pragint1;
    break;

  case ifpconmodrc:
    e->ptconmodrc = LINK->LINK->pragint1;
    break;

  case ifpprodmodrc:
    e->ptprodmodrc = LINK->LINK->pragint1;
    break;

  case ifpemark:
    if (LINK->LINK->pragint1 == 1)
      e->ptmark = byref;
    else if (LINK->LINK->pragint1 == 0)
      e->ptmark = byval;
    else
      e->ptmark = destroy;
    break;
  }/*case*/
}  /*AssignEdgePragma*/

/* Local variables for getnpointer: */
struct LOC_getnpointer {
  struct LOC_readgraphs *LINK;
} ;

Local Void insertinlist(nnum, LINK)
long nnum;
struct LOC_getnpointer *LINK;
{
  /* Inserts the new node whose label is NNum into the list of
     nodes of this new graph, in order according to this label */
  boolean done;
  node *ntemp, *WITH;

  WITH = LINK->LINK->nodetable.ntnode[nnum];   /* with */
  ntemp = WITH->ndparent->ndnext;
  if (ntemp == NULL) {
    WITH->ndparent->ndnext = LINK->LINK->nodetable.ntnode[nnum];
    WITH->ndnext = NULL;
    return;
  }
  if (ntemp->ndlabel >= nnum) {
    WITH->ndnext = ntemp;
    WITH->ndparent->ndnext = LINK->LINK->nodetable.ntnode[nnum];
    return;
  }
  done = false;
  do {
    if (ntemp->ndnext == NULL)
      done = true;
    else if (ntemp->ndnext->ndlabel >= nnum)
      done = true;
    else
      ntemp = ntemp->ndnext;
  } while (!done);
  WITH->ndnext = ntemp->ndnext;
  ntemp->ndnext = LINK->LINK->nodetable.ntnode[nnum];
}  /* InsertInList */


Local node *getnpointer(nnum, nsort, LINK)
long nnum;
nodesort nsort;
struct LOC_readgraphs *LINK;
{
  /* This routine has two (related) functions, it builds the linked
     list of nodes in a graph and maintains the NodeTable data
     structure.
     *** dlz - 8/87 modified to use new alloc. and init. routines,
     some clumsiness since nodes may be referenced before defined:
     can't tell what kind of node it will be yet ***

     When a new graph is to be constructed, the NodeTable is reset
     and the graph header node is built and placed in location zero
     of this table.  As additional nodes of the graph are referenced
     they are (1) added into the table at the location according to
     thier label number (unless they have already been added) and
     (2) they are added to the graph's linked list of nodes in order
     according to thier label number.  Since location zero contains
     the graph header the parent fields of the nodes is easily set.
     Recursion to build subgraphs of compound nodes will not effect
     the state of this instantiation of the table
   */
  struct LOC_getnpointer V;
  node *WITH;

  V.LINK = LINK;
  if (nnum < 0) {   /* with NodeTable */
    errmessage(LINK->LINK);
    printf("Bad Node Pointer\n");
    return NULL;
  } else if (nnum > nodemax) {
    errmessage(LINK->LINK);
    printf("Node Table Size Exceeded\n");
    return NULL;
  } else {
    if (LINK->nodetable.ntnode[nnum] == NULL) {  /* build a new record */
      if (nnum > LINK->nodetable.nthigh)
	LINK->nodetable.nthigh = nnum;
      LINK->nodetable.ntnode[nnum] = newnodealloc(nsort);
      WITH = LINK->nodetable.ntnode[nnum];   /*with*/
      WITH->ndid = -1;
      WITH->ndlabel = nnum;
      WITH->ndparent = LINK->nodetable.ntnode[0];
      if (nnum > 0)
	insertinlist(nnum, &V);
      return (LINK->nodetable.ntnode[nnum]);
    }  /* if NTNode[NNum] = nil then*/


    WITH = LINK->nodetable.ntnode[nnum];
    if (nsort != ndundef && WITH->ndsort == ndundef)
      WITH->ndsort = nsort;
    return (LINK->nodetable.ntnode[nnum]);
  }

  /*in case allo'd as NDUndef*/
}  /* GetNPointer */


Local Void buildnode(LINK)
struct LOC_readgraphs *LINK;
{
  /* A node line looks like:
     N label opcode [ pragmas ] */
  long labelnum, opcode;
  node *n;
  pragmatype code;

  /* then first character is N */
/* p2c: nl.p, line 7783:
 * Note: File parameter source needs its associated buffers [318] */
  getc(*LINK->LINK->source);
  readvalidinteger(&labelnum, LINK->LINK);
  readvalidinteger(&opcode, LINK->LINK);

  /* build data structure */
  n = getnpointer(labelnum, ndatomic, LINK);
  if (n != NULL) {
    if (n->ndid > 0) {
      errmessage(LINK->LINK);
      printf("Double definition of node\n");
    } else {
      marknodedefined(n, LINK);
      n->ndcode = opcode;
      n->ndline = LINK->LINK->lineno;
    }
  }

  while (readpragma(&code, LINK->LINK))
    assignnodepragma(n, code, LINK);
  fscanf(*LINK->LINK->source, "%*[^\n]");
  getc(*LINK->LINK->source);
}  /* BuildNode */

Local Void buildcompound(LINK)
struct LOC_readgraphs *LINK;
{
  /* reads a compound node, builds the subgraphs by a recursive call
     to ReadGraphs.
     OpenBracket
     G
     G ...
     CloseBracket nodenumber opcode numbofgraphs [graphnumbers]... [pragmas]
   */
  assoclist *atemp, *alast;
  graph *graphlist, *glast, *gtemp, *gnew;
  long labelnum, opcode, graphcount, gnumber;
  node *n;
  pragmatype code;

/* p2c: nl.p, line 7822:
 * Note: File parameter source needs its associated buffers [318] */
  getc(*LINK->LINK->source);
  fscanf(*LINK->LINK->source, "%*[^\n]");

  getc(*LINK->LINK->source);
  /* read the subgraphs */
  graphlist = readgraphs(LINK->LINK);

/* p2c: nl.p, line 7828:
 * Note: File parameter source needs its associated buffers [318] */
  getc(*LINK->LINK->source);
  readvalidinteger(&labelnum, LINK->LINK);
  readvalidinteger(&opcode, LINK->LINK);
  readvalidinteger(&graphcount, LINK->LINK);
  n = getnpointer(labelnum, ndcompound, LINK);
  if (n != NULL) {
    if (n->ndid > 0) {
      errmessage(LINK->LINK);
      printf("Double Definition of compound node\n");
    } else {
      marknodedefined(n, LINK);
      n->ndline = LINK->LINK->lineno;
      n->ndcode = opcode;
      /* set parent fields of subgraphs */
      gtemp = graphlist;
      while (gtemp != NULL) {
	gtemp->grnode->ndparent = n;
	gtemp = gtemp->grnext;
      }

      /* now read the ordering of the subgraphs and
         re-arrange them accordingly */
      if (opcode == ifntagcase) {
	/* build association list */
	n->UU.U2.ndsubsid = graphlist;
	alast = NULL;
	while (graphcount > 0) {
	  graphcount--;
	  atemp = (assoclist *)Malloc(sizeof(assoclist));
	  readvalidinteger(&atemp->graphnum, LINK->LINK);
	  if (alast == NULL)
	    n->UU.U2.ndassoc = atemp;
	  else
	    alast->next = atemp;
	  alast = atemp;
	}
	alast->next = NULL;
      } else {
	while (graphcount > 0) {
	  readvalidinteger(&gnumber, LINK->LINK);
	  /* let Gtemp point to the Gnumber'd graph */
	  gtemp = graphlist;
	  while (gnumber > 0) {
	    gtemp = gtemp->grnext;
	    gnumber--;
	  }
	  /* build a new list in the proper order */
	  gnew = (graph *)Malloc(sizeof(graph));
	  gnew->grnode = gtemp->grnode;
	  gnew->grnext = NULL;
	  if (n->UU.U2.ndsubsid == NULL)
	    n->UU.U2.ndsubsid = gnew;
	  else
	    glast->grnext = gnew;
	  glast = gnew;
	  graphcount--;
	}
      }
    }  /* else */
  }

  /* read the pragmas */
  while (readpragma(&code, LINK->LINK))
    assignnodepragma(n, code, LINK);
  fscanf(*LINK->LINK->source, "%*[^\n]");
  getc(*LINK->LINK->source);
}  /* BuildCompound */

Local Void insertasdepoutput(e, LINK)
port *e;
struct LOC_readgraphs *LINK;
{
  node *n;

  n = e->UU.U1.ptfrnode;
  if (n->nddepolist != NULL)
    e->UU.U1.ptfrnext = n->nddepolist;
  else
    e->UU.U1.ptfrnext = n->ndolist;
  n->nddepolist = e;
}  /*InsertAsDepOutput*/

Local Void insertasoutput(e, LINK)
port *e;
struct LOC_readgraphs *LINK;
{
  node *n;
  port *thisport, *lastport;
  long portnum;
  boolean insert, done;

  n = e->UU.U1.ptfrnode;
  portnum = e->UU.U1.ptfrport;
  lastport = NULL;
  thisport = n->ndolist;
  do {
    if (thisport == NULL)
      insert = true;
    else
      insert = (thisport->UU.U1.ptfrport > portnum);
    if (insert) {
      if (lastport == NULL)
	n->ndolist = e;
      else
	lastport->UU.U1.ptfrnext = e;
      e->UU.U1.ptfrnext = thisport;
    } else {
      lastport = thisport;
      thisport = thisport->UU.U1.ptfrnext;
    }
  } while (!insert);
  if (e != n->ndolist || n->nddepolist == NULL)
	/*then was put at head of list and have Dep edge*/
	  return;
  thisport = n->nddepolist;
  done = false;
  while (!done) {
    lastport = thisport;
    thisport = thisport->UU.U1.ptfrnext;
    if (thisport == NULL)
      done = true;
    else if (thisport->ptsort != ptdep)
      done = true;
  }
  lastport->UU.U1.ptfrnext = n->ndolist;
}  /* InsertAsOutput */

Local Void insertasdepinput(e, LINK)
port *e;
struct LOC_readgraphs *LINK;
{
  node *n;

  n = e->pttonode;
  if (n->nddepilist != NULL)
    e->pttonext = n->nddepilist;
  else
    e->pttonext = n->ndilist;
  n->nddepilist = e;
}  /*InsertAsDepInput*/

Local Void insertasinput(e, LINK)
port *e;
struct LOC_readgraphs *LINK;
{
  node *n;
  port *thisport, *lastport;
  long portnum;
  boolean insert, done;

  n = e->pttonode;
  portnum = e->pttoport;
  lastport = NULL;
  thisport = n->ndilist;
  do {
    if (thisport == NULL)
      insert = true;
    else
      insert = (thisport->pttoport > portnum);
    if (insert) {
      if (lastport == NULL)
	n->ndilist = e;
      else
	lastport->pttonext = e;
      e->pttonext = thisport;
    } else {
      lastport = thisport;
      thisport = thisport->pttonext;
    }
  } while (!insert);
  if (e != n->ndilist || n->nddepilist == NULL)
	/*then was put at head of list and have Dep edge*/
	  return;
  thisport = n->nddepilist;
  done = false;
  while (!done) {
    lastport = thisport;
    thisport = thisport->pttonext;
    if (thisport == NULL)
      done = true;
    else if (thisport->ptsort != ptdep)
      done = true;
  }  /*while*/
  lastport->pttonext = n->ndilist;
}  /* InsertAsInput */

Local Void buildliteral(LINK)
struct LOC_readgraphs *LINK;
{
  /*
     L  destinationnode destinationport typenumber [comment] [pragma]...
  */
  long destnode, destport, ltype;
  pragmatype code;
  stryng lvalue;
  port *l;

  /* first char is L */
/* p2c: nl.p, line 8040:
 * Note: File parameter source needs its associated buffers [318] */
  getc(*LINK->LINK->source);
  readvalidinteger(&destnode, LINK->LINK);
  readvalidinteger(&destport, LINK->LINK);
  readvalidinteger(&ltype, LINK->LINK);
  skipjunk(LINK->LINK);
  if (!P_eoln(*LINK->LINK->source)) {
    if (P_peek(*LINK->LINK->source) == '"') {
/* p2c: nl.p, line 8046:
 * Note: File parameter source needs its associated buffers [318] */
      readliteralstring(LINK->LINK->source, &lvalue);
    } else {
      memcpy(lvalue.str, blankstring, sizeof(stryngar));
      lvalue.len = 0;
    }
  }

  /* now build data structure */
  l = newedgealloc(ptlit);
  markedgedefined(l, LINK);
  l->pttonode = getnpointer(destnode, ndundef, LINK);
  l->pttoport = destport;
  l->ptif1line = LINK->LINK->lineno;
  l->pttype = getspointer(ltype, LINK->LINK);
  l->UU.ptlitvalue = lvalue;
  /* error messages */
  if (l->pttonode == NULL) {
    errmessage(LINK->LINK);
    printf("Bad Destination Node\n");
  } else
    insertasinput(l, LINK);
  if (ltype == 0) {
    errmessage(LINK->LINK);
    printf("Bad Type Pointer\n");
  }

  /* now read pragmas */
  while (readpragma(&code, LINK->LINK))
    assignedgepragma(l, code, LINK);
  fscanf(*LINK->LINK->source, "%*[^\n]");
  getc(*LINK->LINK->source);
}  /* BuildLiteral */

Local Void builddepedge(LINK)
struct LOC_readgraphs *LINK;
{
  /*
    D srcnode destnode [comment] [pragma]...
  */
  long srcnode, destnode;
  pragmatype code;   /*dlz - not used, why?, no dep pragmas?*/
  port *e;

  /* first char is D */
/* p2c: nl.p, line 8094:
 * Note: File parameter source needs its associated buffers [318] */
  getc(*LINK->LINK->source);
  readvalidinteger(&srcnode, LINK->LINK);
  readvalidinteger(&destnode, LINK->LINK);

  /* now build data structure */
  e = newedgealloc(ptdep);
  markedgedefined(e, LINK);
  e->pttonode = getnpointer(destnode, ndundef, LINK);
  e->pttoport = 0;
  e->ptif1line = LINK->LINK->lineno;
  e->UU.U1.ptfrnode = getnpointer(srcnode, ndundef, LINK);
  e->UU.U1.ptfrport = 0;
  /* error messages */
  if (e->UU.U1.ptfrnode == NULL) {
    errmessage(LINK->LINK);
    printf("Bad Source Node\n");
  } else
    insertasdepoutput(e, LINK);
  if (e->pttonode == NULL) {
    errmessage(LINK->LINK);
    printf("Bad Destination Node\n");
  } else
    insertasdepinput(e, LINK);

  fscanf(*LINK->LINK->source, "%*[^\n]");
  getc(*LINK->LINK->source);
}  /* BuildDepEdge */


Local Void buildedge(LINK)
struct LOC_readgraphs *LINK;
{
  /*
    E srcnode srcport destnode destport typenumber [comment] [pragma]...
  */
  long srcnode, srcport, destnode, destport, etype;
  pragmatype code;
  port *e;

  /* first char is E */
/* p2c: nl.p, line 8139:
 * Note: File parameter source needs its associated buffers [318] */
  getc(*LINK->LINK->source);
  readvalidinteger(&srcnode, LINK->LINK);
  readvalidinteger(&srcport, LINK->LINK);
  readvalidinteger(&destnode, LINK->LINK);
  readvalidinteger(&destport, LINK->LINK);
  readvalidinteger(&etype, LINK->LINK);

  /* now build data structure */
  e = newedgealloc(ptedge);
  markedgedefined(e, LINK);
  e->pttonode = getnpointer(destnode, ndundef, LINK);
  e->pttoport = destport;
  e->ptif1line = LINK->LINK->lineno;
  e->UU.U1.ptfrnode = getnpointer(srcnode, ndundef, LINK);
  e->UU.U1.ptfrport = srcport;
  e->pttype = getspointer(etype, LINK->LINK);
  /* error messages */
  if (e->UU.U1.ptfrnode == NULL) {
    errmessage(LINK->LINK);
    printf("Bad Source Node\n");
  } else
    insertasoutput(e, LINK);
  if (e->pttonode == NULL) {
    errmessage(LINK->LINK);
    printf("Bad Destination Node\n");
  } else
    insertasinput(e, LINK);
  if (etype < 0) {
    errmessage(LINK->LINK);
    printf("Bad Type Pointer\n");
  }

  /* now read pragmas */
  while (readpragma(&code, LINK->LINK))
    assignedgepragma(e, code, LINK);
  fscanf(*LINK->LINK->source, "%*[^\n]");
  getc(*LINK->LINK->source);
}  /* BuildEdge */

Local Void buildgraph(graphlist, LINK)
graph **graphlist;
struct LOC_readgraphs *LINK;
{
  /* a graph line looks like:
     G typenum [ string ] [ pragma ]...
     X typenum [ string ] [ pragma ]...
     I typenum [ string ] [ pragma ]...
   */
  Char grkind;
  stryng fname;
  node *g;
  graph *gtemp, *gnode;
  long graphtype;
  pragmatype code;
  linkrec *WITH1;

  grkind = getc(*LINK->LINK->source);
  if (grkind == '\n')
    grkind = ' ';
  readvalidinteger(&graphtype, LINK->LINK);
  skipjunk(LINK->LINK);
  memcpy(fname.str, blankstring, sizeof(stryngar));
  fname.len = 0;
  if (!P_eoln(*LINK->LINK->source)) {
    if (P_peek(*LINK->LINK->source) == '"') {
/* p2c: nl.p, line 8206:
 * Note: File parameter source needs its associated buffers [318] */
      readifstring(LINK->LINK->source, &fname);
    }
  }

  /* prepare for reading this graph's nodes */
  resetnodetable(LINK);
  /* Build the graphnode for this graph */
  g = getnpointer(0L, ndgraph, LINK);

  /* Make a new graph node and add to the end of GraphList */
  gnode = (graph *)Malloc(sizeof(graph));
  gnode->grnext = NULL;
  if (*graphlist == NULL)
    *graphlist = gnode;
  else {
    gtemp = *graphlist;
    while (gtemp->grnext != NULL)
      gtemp = gtemp->grnext;
    gtemp->grnext = gnode;
  }

  /* fill in the data structure for G */
  gnode->grnode = g;
  marknodedefined(g, LINK);
  g->ndcode = ifngraph;
  g->ndline = LINK->LINK->lineno;
  g->UU.U1.ndtype = getspointer(graphtype, LINK->LINK);
  if (fname.len == 0)   /* with */
    g->UU.U1.ndlink = NULL;
  else {
    g->UU.U1.ndlink = (linkrec *)Malloc(sizeof(linkrec));
    WITH1 = g->UU.U1.ndlink;   /* with NDLink */
    if (grkind == 'G')
      WITH1->lksort = lslocal;
    else if (grkind == 'X')
      WITH1->lksort = lsexported;
    else
      WITH1->lksort = lsimported;
    WITH1->lkname = fname;
    WITH1->lkgraph = g;
    WITH1->lkarsize = -LONG_MAX;
    WITH1->lkexpand = false;
    WITH1->lknext = NULL;
    memcpy(WITH1->lkmodulename.str, blankstring, sizeof(stryngar));
    WITH1->lkmodulename.len = 0;
    /* Add to end of function list */
    if (*LINK->LINK->newflist == NULL) {
      *LINK->LINK->newflist = g->UU.U1.ndlink;
      *LINK->LINK->newfend = g->UU.U1.ndlink;
    } else {
      (*LINK->LINK->newfend)->lknext = g->UU.U1.ndlink;
      *LINK->LINK->newfend = g->UU.U1.ndlink;
    }
  }

  /* read pragmas */
  while (readpragma(&code, LINK->LINK)) {
    if (((1L << ((long)code)) &
	 ((1L << ((long)ifpexpand)) | (1L << ((long)ifparsize)))) == 0) {
      assignnodepragma(g, code, LINK);
      continue;
    }
    switch (code) {

    case ifpexpand:
      if (g->UU.U1.ndlink != NULL)
	g->UU.U1.ndlink->lkexpand = true;
      break;

    case ifparsize:
      if (g->UU.U1.ndlink != NULL)
	g->UU.U1.ndlink->lkarsize = LINK->LINK->pragint1;
      break;
    }/*then-case*/
  }
  fscanf(*LINK->LINK->source, "%*[^\n]");
  getc(*LINK->LINK->source);

  /* GrKind = 'I' */
}  /* BuildGraph */


Local graph *readgraphs(LINK)
struct LOC_readif1file *LINK;
{
  /* *******************************************************************/
  /* ***********************   READGRAPHS  *************************** */
  /*   */
  /* This procedure builds a list of graphs specified by the input   */
  /* file and returns a pointer to to this linked list.  It is called  */
  /* recursively by one of its sibling procedures: BuildCompound.      */
  /* Function graphs are distinguished from subgraphs of compound      */
  /* nodes by the fact that they have names (in double quotes) on the  */
  /* graph header line after the type field.  Function graphs also     */
  /* have a linkage record associated with them (subgraphs do not)     */
  /* and a global (nested within ReadIF1File) pair of pointers         */
  /* (NewFList, NewFEnd) which point to the head and rear of this      */
  /* list.  The important sub procedures of this function are:         */
  /*GetNPointer  */
  /*BuildNode  */
  /*BuildCompound  */
  /*BuildLiteral  */
  /*BuildEdge  */
  /*BuildGraph  */
  /* (the type table routines are siblings ane are located above the   */
  /*  function)  */
  struct LOC_readgraphs V;
  boolean done;
  graph *glist;

  V.LINK = LINK;
  done = false;
  V.nodetable.nthigh = nodemax;
  glist = NULL;
  while ((!done) & (!P_eof(*LINK->source))) {
    LINK->lineno++;
    /* skip leading blanks */
    while ((P_peek(*LINK->source) == (Char)tab ||
	    P_peek(*LINK->source) == ' ') & (!P_eoln(*LINK->source)))
      getc(*LINK->source);
/* p2c: nl.p, line 8292:
 * Note: File parameter source needs its associated buffers [318] */
/* p2c: nl.p, line 8293:
 * Note: File parameter source needs its associated buffers [318] */
    if (P_eoln(*LINK->source)) {
      fscanf(*LINK->source, "%*[^\n]");
      getc(*LINK->source);
      continue;
    }
    if (!P_inset(P_peek(*LINK->source), LINK->legallinechars)) {
      warnmessage(LINK);
/* p2c: nl.p, line 8318:
 * Note: File parameter source needs its associated buffers [318] */
      printf("Illegal Line, Bad first character: %c\n", P_peek(*LINK->source));
      fscanf(*LINK->source, "%*[^\n]");
      getc(*LINK->source);
      continue;
    }
/* p2c: nl.p, line 8296:
 * Note: File parameter source needs its associated buffers [318] */
/* p2c: nl.p, line 8297:
 * Note: File parameter source needs its associated buffers [318] */
    switch (P_peek(*LINK->source)) {

    case 'X':
    case 'G':
    case 'I':
      buildgraph(&glist, &V);
      break;

    case 'L':
      buildliteral(&V);
      break;

    case 'E':
      buildedge(&V);
      break;

    case 'D':
      builddepedge(&V);
      break;

    case 'N':
      buildnode(&V);
      break;

    case '{':
      buildcompound(&V);
      break;

    case '}':
      done = true;
      break;

    case 'T':
      buildtype(LINK);
      break;

    case 'C':
      getc(*LINK->source);
      if (!P_eoln(*LINK->source)) {
	if (P_peek(*LINK->source) == '$') {
/* p2c: nl.p, line 8309:
 * Note: File parameter source needs its associated buffers [318] */
	  readstamp(LINK);
	} else {
	  fscanf(*LINK->source, "%*[^\n]");
	  getc(*LINK->source);
	}
      }
      break;
/* p2c: nl.p, line 8307:
 * Note: File parameter source needs its associated buffers [318] */
    }/* case */
  }  /* while */
  return glist;
}  /* ReadGraphs */

#undef nodemax

Local boolean readif1file(newflist_, newfend_, newmodule, source_, LINK)
linkrec **newflist_, **newfend_;
node **newmodule;
FILE **source_;
struct LOC_loadprogram *LINK;
{
  /*
     NewFList = pointer to the head of the new list of function linkage
                records for the functions defined in the source file.
     NewFEnd  = pointer to the tail of the new list of function linkage
                records for the functions defined in the source file.
     NewModule   = pointer to a dummy compound node whose subgraphs are
                the functions defined in the source file.
  */
  struct LOC_readif1file V;
  Char c;
  long SET[9];

  /* **********************         ******************* */
  /* ********************** End Of Function READGRAPHS ******************* */
  /* ********************************************************************* */

  V.LINK = LINK;
  V.newflist = newflist_;
  V.newfend = newfend_;
  V.source = source_;
  if (setjmp(V._JL998))
    goto _L998;
  /* Initializations */
  V.Result = true;
  P_addset(P_expset(V.legallinechars, 0L), 'I');
  P_addset(V.legallinechars, 'C');
  P_addset(V.legallinechars, 'T');
  P_addset(V.legallinechars, 'L');
  P_addset(V.legallinechars, 'E');
  P_addset(V.legallinechars, 'D');
  P_addset(V.legallinechars, 'X');
  P_addset(V.legallinechars, 'G');
  P_addset(V.legallinechars, 'N');
  P_addset(V.legallinechars, '{');
  P_addset(V.legallinechars, '}');
  P_addset(P_expset(V.digits, 0L), '0');
  P_addset(V.digits, '1');
  P_addset(V.digits, '2');
  P_addset(V.digits, '3');
  P_addset(V.digits, '4');
  P_addset(V.digits, '5');
  P_addset(V.digits, '6');
  P_addset(V.digits, '7');
  P_addset(V.digits, '8');
  P_addset(V.digits, '9');
  P_expset(V.letters, 0L);
  for (c = 'a'; c <= 'z'; c++)
    P_addset(V.letters, c);
  for (c = 'A'; c <= 'Z'; c++)
    P_addset(V.letters, c);
  for (V.i = 0; V.i <= hashtableub; V.i++)
    V.hashtable[V.i].key = -1;
  LINK->oldtthwm = tthwm;
  V.lineno = 0;
  V.ignoredsomepragmas = false;
  (*newmodule)->UU.U2.ndsubsid = readgraphs(&V);
_L998:
  if (V.ignoredsomepragmas)
    printf("Caution: unusable pragmas for this version ignored\n");
  return V.Result;
}  /* ReadIF1File */

#undef tab
#undef hashtablesize
#undef hashtableub

/* Local variables for linkintomodule: */
struct LOC_linkintomodule {
  struct LOC_loadprogram *LINK;
} ;

Local Void getnextfunction(newf, newg, LINK)
linkrec **newf;
graph **newg;
struct LOC_linkintomodule *LINK;
{
  /* Remove a function from Flist, recall that is linked both at
     the bottom by Flist and at the top by a dummy compound node. */
  if (LINK->LINK->newflist == NULL) {
    *newf = NULL;
    *newg = NULL;
    return;
  }
  *newf = LINK->LINK->newflist;
  LINK->LINK->newflist = LINK->LINK->newflist->lknext;
  *newg = LINK->LINK->newmodule->UU.U2.ndsubsid;
  LINK->LINK->newmodule->UU.U2.ndsubsid = (*newg)->grnext;
  (*newf)->lknext = NULL;
  (*newg)->grnext = NULL;
}  /* GetNextFunction */

Local Void addtoendoflist(newf, newg, LINK)
linkrec **newf;
graph **newg;
struct LOC_linkintomodule *LINK;
{
  linkrec *f;
  graph *g;

  /* Change Parent Link of new function */
  (*newf)->lkgraph->ndparent = module;
  /* Now Link into the module and function list */
  if (funclist == NULL) {
    funclist = *newf;
    module->UU.U2.ndsubsid = *newg;
    firstfunction = (*newf)->lkgraph;
    return;
  }
  f = funclist;
  g = module->UU.U2.ndsubsid;
  while (f->lknext != NULL) {
    f = f->lknext;
    g = g->grnext;
  }
  f->lknext = *newf;
  g->grnext = *newg;
}  /* AddToEndOfList */

Local Void replacefunction(newf, oldf, newg, LINK)
linkrec **newf, **oldf;
graph **newg;
struct LOC_linkintomodule *LINK;
{
  /* Replace OldF with NewF in FuncList, similarly, place NewG in
     Module.
   */
  linkrec *f;
  graph *g;

  /* First change the parent link of the new function */
  (*newf)->lkgraph->ndparent = module;
  /* Now replace OldF with NewF */
  if (funclist == *oldf) {  /* first in list */
    (*newf)->lknext = (*oldf)->lknext;
    funclist = *newf;
    firstfunction = (*newf)->lkgraph;
    (*oldf)->lknext = NULL;
    (*newg)->grnext = module->UU.U2.ndsubsid->grnext;
    module->UU.U2.ndsubsid->grnext = NULL;
    module->UU.U2.ndsubsid = *newg;
    return;
  }
  f = funclist;
  g = module->UU.U2.ndsubsid;
  while (f->lknext != *oldf) {
    f = f->lknext;
    g = g->grnext;
  }
  (*newf)->lknext = (*oldf)->lknext;
  f->lknext = *newf;
  (*oldf)->lknext = NULL;
  (*newg)->grnext = g->grnext->grnext;
  g->grnext->grnext = NULL;
  g->grnext = *newg;
}  /* ReplaceFunction */

Local boolean linkintomodule(LINK)
struct LOC_loadprogram *LINK;
{
  /* Link the functions in NewFList to FuncList */
  struct LOC_linkintomodule V;
  boolean Result;
  node *g;
  linkrec *newf, *oldf;
  linksort newsort, oldsort;
  graph *newg;
  boolean success;
  FILE *TEMP1;

  V.LINK = LINK;
  success = true;
  getnextfunction(&newf, &newg, &V);
  while (newf != NULL) {
    if (newf->lkgraph != newg->grnode) {
      printf("Function ");
      TEMP1 = stdout;
/* p2c: nl.p, line 8450:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
      writestring(&TEMP1, &newf->lkname);
      printf(" is not linked properly \n");
      success = false;
      newf = NULL;
    } else {
      g = tonamedgraph(newf->lkname);
      if (g == NULL)
	addtoendoflist(&newf, &newg, &V);
      else {
	oldf = g->UU.U1.ndlink;
	newsort = newf->lksort;
	oldsort = oldf->lksort;
	if (oldsort != lsexported && oldsort != lslocal ||
	    newsort != lsimported)
	{   /* added 29Oct87 rky */
	  if (oldsort == lsimported && newsort == lsexported) {
	    /* replace old with new */
	    replacefunction(&newf, &oldf, &newg, &V);
	  } else {
	    printf("WARNING:  Replacing old function ");
	    TEMP1 = stdout;
/* p2c: nl.p, line 8482:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
	    writestring(&TEMP1, &oldf->lkname);
	    printf(" with new definition.\n");
	    replacefunction(&newf, &oldf, &newg, &V);
	  }
	}
	/* Eventually inter-module interface should be corrected,
	   but for now, local functions act like exported funs */
	/* do nothing */
      }  /* else */
      getnextfunction(&newf, &newg, &V);
    }  /* while */
    Result = success;
  }
  return Result;

  /* Issue warning, replace old with new */
}  /* LinkIntoModule */


Static boolean loadprogram(infile)
stryng infile;
{
  struct LOC_loadprogram V;
  boolean Result;
  FILE *source;
  linkrec *newfend;
  node *WITH;
  FILE *TEMP1;

  source = NULL;
  P_expset(V.newstamps, 0L);
  V.newflist = NULL;
  newfend = NULL;
  V.newmodule = (node *)Malloc(sizeof(node));
  WITH = V.newmodule;
  WITH->ndcode = ifnmodule;
  WITH->ndsort = ndcompound;
  WITH->UU.U2.ndsubsid = NULL;
  if (openinputfile(&infile, &source)) {
    if (readif1file(&V.newflist, &newfend, &V.newmodule, &source, &V)) {
      univmodulecnt++;
      smashtypes();
      adjusttypepointers(V.newmodule);
      compacttypetable(&tthwm, V.oldtthwm);
      Result = linkintomodule(&V);
      P_setint(stampset, stampset, V.newstamps);
    } else
      Result = false;
  } else {
    printf("*** Error in opening input file: ");
    TEMP1 = stdout;
/* p2c: nl.p, line 8518:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
    writestring(&TEMP1, &infile);
    printf(" ***\n");
    Result = false;
  }
  if (source != NULL)
    fclose(source);
  return Result;
}  /* LoadProgram */


Static boolean loadmodule(paramlist)
parrec **paramlist;
{
  boolean noerror;
  long filenum;
  stryng filename;
  FILE *TEMP1;

  initnames();
  initmodule();
  readcommandline(infile, &outfile, paramlist, &timingflag);
  filenum = 1;
  noerror = true;
  while (noerror && filenum <= maxinfile) {
    if (infile[filenum - 1]->parvalue.len > 0) {
      filename = infile[filenum - 1]->parvalue;
      if (timingflag) {
	printf("* Reading file: ");
	TEMP1 = stdout;
/* p2c: nl.p, line 8545:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
	writestring(&TEMP1, &filename);
	printf(" ...\n");
	starttimer();
      }
      noerror = loadprogram(filename);
      if (noerror && timingflag)
	recordtime();
    }
    filenum++;
  }  /* while */
  return noerror;
}  /* LoadModule */


#define tab             9


/* Local variables for dumpprogram: */
struct LOC_dumpprogram {
  FILE *diag;
} ;

Local Void dumpgraph PP((node *g, struct LOC_dumpprogram *LINK));


Local Void writetypenumber(entry_, LINK)
stentry *entry_;
struct LOC_dumpprogram *LINK;
{
  /* Print out the type number associated with this type pointer.
     If the pointer is nill the type number is zero.  */
  /* WriteTypeNumber */
  if (entry_ == NULL)
    fprintf(LINK->diag, "%c0", (Char)tab);
  else
    fprintf(LINK->diag, "%c%ld", (Char)tab, entry_->stlabel);
}

Local Void dumpentry(eptr, LINK)
stentry *eptr;
struct LOC_dumpprogram *LINK;
{
  /* Print the type table entry for this Type pointer. */
  /* DumpEntry */
  if (eptr == NULL)   /* with */
    return;
  fprintf(LINK->diag, "T %ld %d", eptr->stlabel, eptr->stsort);
  switch (eptr->stsort) {

  case iftwild:
    /* blank case */
    break;

  case iftbasic:
    fprintf(LINK->diag, " %d", eptr->UU.stbasic);
    break;

  case iftfunctiontype:
    writetypenumber(eptr->UU.U3.starg, LINK);
    writetypenumber(eptr->UU.U3.stres, LINK);
    break;

  case iftarray:
  case iftstream:
  case iftmultiple:
  case iftrecord:
  case iftunion:
  case iftbuffer:
    writetypenumber(eptr->UU.stbasetype, LINK);
    break;

  case iftfield:
  case ifttuple:
  case ifttag:
    writetypenumber(eptr->UU.U2.stelemtype, LINK);
    writetypenumber(eptr->UU.U2.stnext, LINK);
    break;
  }/* case */

  /* write type pragmas */
  if (eptr->stliteral.len != 0) {
    fprintf(LINK->diag, "    %%na=");
    writestring(&LINK->diag, &eptr->stliteral);
  }
  if (eptr->stsize > 0)
    fprintf(LINK->diag, "    %%sz=%ld", eptr->stsize);
  if (eptr->strecurflag)
    fprintf(LINK->diag, "    %%rt");
  putc('\n', LINK->diag);
}


Local Void writeedgepragmas(e, LINK)
port *e;
struct LOC_dumpprogram *LINK;
{
  if (e->ptname.len != 0) {
    fprintf(LINK->diag, "%c %%na=", (Char)tab);
    writestring(&LINK->diag, &e->ptname);
  }
  if (e->ptlbound != -LONG_MAX)
    fprintf(LINK->diag, "%c%%bd=%ld,%ld", (Char)tab, e->ptlbound, e->ptubound);
  if (e->ptdfaddr > 0)
    fprintf(LINK->diag, "%c%%of=%ld", (Char)tab, e->ptdfaddr);
  if (e->ptmark == byref)
    fprintf(LINK->diag, "%c%%mk=R", (Char)tab);
  else if (e->ptmark == byval)
    fprintf(LINK->diag, "%c%%mk=V", (Char)tab);
  else
    fprintf(LINK->diag, "%c%%mk=D", (Char)tab);
  if (e->ptsrcline >= 0)
    fprintf(LINK->diag, "%c%%sl=%ld", (Char)tab, e->ptsrcline);
  if (e->ptwiline >= 0)
    fprintf(LINK->diag, "%c%%wl=%ld", (Char)tab, e->ptwiline);
  if (e->ptsetrc != -LONG_MAX)
    fprintf(LINK->diag, "%c%%sr=%ld", (Char)tab, e->ptsetrc);
  if (e->ptprodmodrc != -LONG_MAX)
    fprintf(LINK->diag, "%c%%pm=%ld", (Char)tab, e->ptprodmodrc);
  if (e->ptconmodrc != -LONG_MAX)   /*with*/
    fprintf(LINK->diag, "%c%%cm=%ld", (Char)tab, e->ptconmodrc);
  putc('\n', LINK->diag);
}  /*WriteEdgePragmas*/

Local Void dumpinputedges(n, LINK)
node *n;
struct LOC_dumpprogram *LINK;
{
  /* Walk the input edges of the node N and print out
     each in turn.
     Print out the pragmas associated with each edge or literal.*/
  port *e, *WITH;

  e = n->nddepilist;   /* also display any dep edges */
  if (e == NULL)
    e = n->ndilist;
  while (e != NULL) {   /* while-with */
    WITH = e;
    if (e->ptsort == ptdep)
      fprintf(LINK->diag, "D%c%ld%c%ld\n",
	      (Char)tab, WITH->UU.U1.ptfrnode->ndlabel, (Char)tab,
	      WITH->pttonode->ndlabel);
    else {
      if (e->ptsort == ptlit)
	fprintf(LINK->diag, "L%c", (Char)tab);
      else
	fprintf(LINK->diag, "E%c%ld %ld",
		(Char)tab, WITH->UU.U1.ptfrnode->ndlabel,
		WITH->UU.U1.ptfrport);
      fprintf(LINK->diag, "%c%ld %ld",
	      (Char)tab, WITH->pttonode->ndlabel, WITH->pttoport);
      writetypenumber(WITH->pttype, LINK);
      if (WITH->ptsort == ptlit) {
	fprintf(LINK->diag, " \"");
	writestring(&LINK->diag, &WITH->UU.ptlitvalue);
	putc('"', LINK->diag);
      }
      writeedgepragmas(e, LINK);
    }  /*else*/

    e = e->pttonext;
  }
}  /* DumpInputEdges */


Local Void writenodepragmas(n, LINK)
node *n;
struct LOC_dumpprogram *LINK;
{
  if (n->ndsrcline >= 0)
    fprintf(LINK->diag, "%c%%sl=%ld", (Char)tab, n->ndsrcline);
  if (n->ndwiline >= 0)
    fprintf(LINK->diag, "%c%%wl=%ld", (Char)tab, n->ndwiline);
  if (n->ndxcoord != -LONG_MAX)
    fprintf(LINK->diag, "%c%%xy=%ld,%ld", (Char)tab, n->ndxcoord, n->ndycoord);
  if (n->ndfrequency >= 0.0)
    fprintf(LINK->diag, "%c%%fq=% .5E", (Char)tab, n->ndfrequency);
  if (n->ndexpanded == 1)
    fprintf(LINK->diag, "%c%%ep=1", (Char)tab);
  else if (n->ndexpanded == 0)
    fprintf(LINK->diag, "%c%%ep=0", (Char)tab);

  putc('\n', LINK->diag);   /*with*/
}  /*WriteNodePragmas*/

Local Void dumpsimple(n, LINK)
node *n;
struct LOC_dumpprogram *LINK;
{
  /* Print out the simple node N along with its pragmas */
  fprintf(LINK->diag, "N %ld%c%ld", n->ndlabel, (Char)tab, n->ndcode);
  writenodepragmas(n, LINK);
}  /* DumpSimple */

Local Void dumpcompound(n, LINK)
node *n;
struct LOC_dumpprogram *LINK;
{
  /* N is a compound node.
     This will consist of :
       (1) a header line
       (2) a list of subgraphs  (recursive call to DumpGraph)
       (3) a closing line with pragmas.
     The tagcase node is handled carefully to get the subgraph-tag
     associations correct.*/
  assoclist *atemp;
  graph *gptr;
  long count, graphcount;

  /* DumpCompound */
  fprintf(LINK->diag, "{ Compound %3ld %3ld\n", n->ndlabel, n->ndcode);
  /* Dump the subsidiary graphs */
  graphcount = 0;
  gptr = n->UU.U2.ndsubsid;
  while (gptr != NULL) {
    graphcount++;
    dumpgraph(gptr->grnode, LINK);
    gptr = gptr->grnext;
  }
  /* Dump the pointer list */
  if (n->ndcode == ifntagcase)   /* with N^ */
  {  /* Dump association list */
    /*find length of list*/
    count = 0;
    atemp = n->UU.U2.ndassoc;
    while (atemp != NULL) {
      count++;
      atemp = atemp->next;
    }
    fprintf(LINK->diag, "} %ld %ld %ld", n->ndlabel, n->ndcode, count);
    /* write out the assoc list */
    atemp = n->UU.U2.ndassoc;
    while (atemp != NULL) {
      fprintf(LINK->diag, " %ld", atemp->graphnum);
      atemp = atemp->next;
    }
  }  /*then*/
  else {   /*if*/
    fprintf(LINK->diag, "} %ld %ld %ld", n->ndlabel, n->ndcode, graphcount);
    for (count = 0; count < graphcount; count++)
      fprintf(LINK->diag, " %ld", count);
  }

  writenodepragmas(n, LINK);
}

Local Void dumpgraph(g, LINK)
node *g;
struct LOC_dumpprogram *LINK;
{
  /*( G : NDPtr )*/
  /* Print out the appropriate IF1 line depending on the type
     of graph this is (X, I, or G).  Then walk the nodes of
     the graph and print out each node followed by all its input
     edges.*/
  node *n;
  linkrec *WITH1;

  /* Dump graph header */
  if (g->UU.U1.ndlink == NULL)   /*with*/
  {  /* Is a subgraph of a compound node */
    putc('G', LINK->diag);
    writetypenumber(g->UU.U1.ndtype, LINK);
  } else {   /* Is a Function Graph */
    WITH1 = g->UU.U1.ndlink;
    if (WITH1->lksort == lslocal)
      putc('G', LINK->diag);
    else if (WITH1->lksort == lsimported)
      putc('I', LINK->diag);
    else
      putc('X', LINK->diag);
    writetypenumber(g->UU.U1.ndtype, LINK);
    fprintf(LINK->diag, "%c\"", (Char)tab);
    writestring(&LINK->diag, &WITH1->lkname);
    putc('"', LINK->diag);
    /* write function pragmas here */
    if (WITH1->lkarsize >= 0)
      fprintf(LINK->diag, "%c%%ar=%ld", (Char)tab, WITH1->lkarsize);
    if (WITH1->lkexpand)
      fprintf(LINK->diag, "  %%ex");
  }
  /* with */

  writenodepragmas(g, LINK);
  dumpinputedges(g, LINK);
  n = g->ndnext;
  while (n != NULL) {
    if (n->ndsort == ndcompound)
      dumpcompound(n, LINK);
    else
      dumpsimple(n, LINK);
    dumpinputedges(n, LINK);
    n = n->ndnext;
  }
}  /* DumpGraph */


Local Void dumpif1file(diag, LINK)
FILE **diag;
struct LOC_dumpprogram *LINK;
{
  /* Module = A pointer to a dummy compound node whose subsidiary
             graphs are the graphnodes of the if file being produced.*/
  long entrynum;
  Char ch;
  node *fgraph;
  long FORLIM;

  FORLIM = tthwm;
  /* First dump the type table */
  for (entrynum = 0; entrynum < FORLIM; entrynum++)
    dumpentry(typetable[entrynum], LINK);
  /* Dump the stamps */
  for (ch = 'A'; ch <= 'Z'; ch++) {
    if (P_inset(ch, stampset)) {
      fprintf(*diag, "C$  %c", ch);
      writestring(diag, &stamp[ch - 'A']);
      putc('\n', *diag);
    }
  }
  fgraph = firstfunction;
  while (fgraph != NULL) {
    dumpgraph(fgraph, LINK);
    fgraph = tonextfunction(fgraph);
  }
}  /* DumpIF1File */




/* dlz, reorganized and consolidated 8/87: 3 deep procedure nesting to 1,
   conditional comp. of vivek's stuff, new procs Write(Node/Edge)Pragmas */




Static Void dumpprogram(outfile)
stryng outfile;
{
  struct LOC_dumpprogram V;
  FILE *TEMP1;

  V.diag = NULL;
  if (openoutputfile(&outfile, &V.diag))
    dumpif1file(&V.diag, &V);
  else {
    printf("*** ERROR, cannot open output file: ");
    TEMP1 = stdout;
/* p2c: nl.p, line 8826:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
    writestring(&TEMP1, &outfile);
    printf(" ***\n");
  }
  if (V.diag != NULL)
    fclose(V.diag);
}  /* DumpProgram */

#undef tab


Static Void dumpmodule()
{
  stryng outfilename;
  FILE *TEMP1;

  outfilename = outfile->parvalue;
  if (timingflag) {
    printf("* Dumping program to file: ");
    TEMP1 = stdout;
/* p2c: nl.p, line 8839:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
    writestring(&TEMP1, &outfilename);
    printf(" ...\n");
    starttimer();
  }
  dumpprogram(outfilename);
  if (timingflag)
    recordtime();
}  /* DumpModule */


#define tab             9
#define maxnamelen      5
#define commtablesize   80
#define commtablemax    79   /* CommTableSize - 1 */
#define intlistlen      50


typedef struct intlist {
  char length;
  long element[intlistlen];
} intlist;

typedef Char commandname[maxnamelen];
/*List all function*/
/*List all nodes*/
/*Name current function*/
/*Goto node with Id*/
/*List input edges*/
/*List commands*/
/*Move left*/
/*display loop depth*/
/*Move right*/
/*Goto node with label*/
/*Show Current Graph*/
/*List nodes with given opcode*/
/*List all nodes with opcode (recursive)*/
/*Goto next node*/
/*List output edges*/
/*Goto parent*/
/*Shop which graph ports effect node*/
/*Show current position*/
/*Quit*/
/*Goto given subgraph*/
/*Show type*/
/*Show Nodes Above*/
/*Show Nodes Below*/
/*Display node record*/
/*Display input edge record*/
/*Display output edge record*/
/*Display input dependence edge records*/
/*Display output dependence edge records*/
/*Display all input edges*/
/*Display all output edges*/
typedef enum {
  cclisallfun, cclisallnodes, ccfunction, ccnodeid, cclisinedges, cchelp,
  ccleft, cclooplevel, ccright, ccnodelabel, ccgraph, cclisnodeswop,
  ccrecfind, ccnextnode, cclisoutedges, ccparent, ccgraphports, ccposition,
  ccquit, ccsubgraph, ccdisptype, ccnodesabove, ccnodesbelow, ccdumpnode,
  ccdumpinput, ccdumpoutput, ccdumpdepinput, ccdumpdepoutput, ccdumpallinput,
  ccdumpalloutput, ccshowtable
} commandtype;   /*Display hash table*/
/* p2c: nl.p, line 8896: Note:
 * Line breaker spent 1.7+0.30 seconds, 1907 tries on line 9747 [251] */

typedef struct commandrec {
  boolean empty;
  commandname name;
  commandtype commvalue;
} commandrec;


#define prime           89


/* Local variables for graphwalk: */
struct LOC_graphwalk {
  commandrec commandtable[commtablemax + 1];
  long blankchars[9];
} ;

Local char hashfunction(name, LINK)
Char *name;
struct LOC_graphwalk *LINK;
{
  long sum, pos;

  sum = (name[0] - '0') * name[1] % prime;
/* p2c: nl.p, line 8916:
 * Note: Using % for possibly-negative arguments [317] */
  for (pos = 2; pos < maxnamelen; pos++)
    sum += name[pos];
  return (sum % commtablesize);
/* p2c: nl.p, line 8919:
 * Note: Using % for possibly-negative arguments [317] */
}

#undef prime

/* ---------------------------------------------------------------- */
/* A collection of routines to implement lists of integers          */

Local boolean emptylist(l, LINK)
intlist *l;
struct LOC_graphwalk *LINK;
{
  return (l->length == 0);
}  /* EmptyList */

Local Void initlist(l, LINK)
intlist *l;
struct LOC_graphwalk *LINK;
{
  l->length = 0;
}  /* InitList */

Local long poplist(l, LINK)
intlist *l;
struct LOC_graphwalk *LINK;
{
  long Result;

  Result = l->element[l->length - 1];
  l->length--;
  return Result;
}  /* PopList */

Local Void addtolist(l, ele, LINK)
intlist *l;
long ele;
struct LOC_graphwalk *LINK;
{
  long i;
  boolean found;

  /* see if ele is in list yet */
  i = 1;
  found = false;
  while (i <= l->length && !found) {
    if (l->element[i - 1] == ele)
      found = true;
    else
      i++;
  }
  if (found)
    return;
  if (i > intlistlen)
    printf("INTERNAL ERROR: List Overflow!!\n");
  else {
    l->length = i;
    l->element[i - 1] = ele;
  }
}  /* AddToList */

/* ---------------------------------------------------------------- */

Local Void displaytable(LINK)
struct LOC_graphwalk *LINK;
{
  long loc;
  commandrec *WITH;

  for (loc = 0; loc <= commtablemax; loc++) {
    WITH = &LINK->commandtable[loc];
    if (!WITH->empty)
      printf("loc: %2ld  %.*s\n", loc, maxnamelen, WITH->name);
  }
}  /* DisplayTable */

/* Local variables for initcommandtable: */
struct LOC_initcommandtable {
  struct LOC_graphwalk *LINK;
} ;

Local Void insert_(cname_, command, LINK)
Char *cname_;
commandtype command;
struct LOC_initcommandtable *LINK;
{
  commandname cname;
  long loc;
  commandrec *WITH;

  memcpy(cname, cname_, sizeof(commandname));
  loc = hashfunction(cname, LINK->LINK);
  while (!LINK->LINK->commandtable[loc].empty) {
    loc = (loc + 1) % commtablesize;
/* p2c: nl.p, line 8985:
 * Note: Using % for possibly-negative arguments [317] */
  }
  WITH = &LINK->LINK->commandtable[loc];
  WITH->empty = false;
  memcpy(WITH->name, cname, sizeof(commandname));
  WITH->commvalue = command;
}  /* Insert */

Local Void initcommandtable(LINK)
struct LOC_graphwalk *LINK;
{
  struct LOC_initcommandtable V;
  long loc;

  V.LINK = LINK;
  for (loc = 0; loc <= commtablemax; loc++)
    LINK->commandtable[loc].empty = true;
  insert_("above", ccnodesabove, &V);
  insert_("allf ", cclisallfun, &V);
  insert_("below", ccnodesbelow, &V);
  insert_("f    ", cclisnodeswop, &V);
  insert_("fr   ", ccrecfind, &V);
  insert_("fun  ", ccfunction, &V);
  insert_("graph", ccgraph, &V);
  insert_("gport", ccgraphports, &V);
  insert_("help ", cchelp, &V);
  insert_("id   ", ccnodeid, &V);
  insert_("iedge", cclisinedges, &V);
  insert_("label", ccnodelabel, &V);
  insert_("l    ", ccleft, &V);
  insert_("loop ", cclooplevel, &V);
  insert_("n    ", ccnextnode, &V);
  insert_("nodes", cclisallnodes, &V);
  insert_("oedge", cclisoutedges, &V);
  insert_("up   ", ccparent, &V);
  insert_("pos  ", ccposition, &V);
  insert_("q    ", ccquit, &V);
  insert_("r    ", ccright, &V);
  insert_("table", ccshowtable, &V);
  insert_("down ", ccsubgraph, &V);
  insert_("type ", ccdisptype, &V);
  insert_("dn   ", ccdumpnode, &V);
  insert_("di   ", ccdumpinput, &V);
  insert_("do   ", ccdumpoutput, &V);
  insert_("ddepi", ccdumpdepinput, &V);
  insert_("ddepo", ccdumpdepoutput, &V);
  insert_("dalli", ccdumpallinput, &V);
  insert_("dallo", ccdumpalloutput, &V);
}  /* InitCommandTable */

Local Void skipblanks(LINK)
struct LOC_graphwalk *LINK;
{
  boolean finished;

  finished = false;
  while (!finished) {
    if (P_eoln(stdin)) {
      finished = true;
      break;
    }
    if (P_inset(P_peek(stdin), LINK->blankchars))
      getc(stdin);
    else
      finished = true;
  }
}  /* SkipBlanks */

Local boolean readinteger_(i, LINK)
long *i;
struct LOC_graphwalk *LINK;
{
  Char ch;

  skipblanks(LINK);
  ch = P_peek(stdin);
  if (ch >= '0' && ch <= '9') {
    scanf("%ld", i);
    return true;
  } else
    return false;
}  /* ReadInteger */

/* Local variables for getvalidcommand: */
struct LOC_getvalidcommand {
  struct LOC_graphwalk *LINK;
} ;

Local Void readcommandname(cname, LINK)
Char *cname;
struct LOC_getvalidcommand *LINK;
{
  /* Read the command entered from the command line.
       -- Skip leading blanks and tabs
       -- Reads entire character string until eoln, blank or
          tab are found
       -- Smashes chars to lower case
       -- Only records first MaxNameLen characters
       -- Pads remainder of name with blanks
       -- Does not issue a readln since arguments may be forthcomming
  */
  long i, length;
  boolean found;
  Char ch;

  skipblanks(LINK->LINK);
  found = false;
  length = 0;
  while (!found) {
    if (P_eoln(stdin)) {
      found = true;
      break;
    }
    ch = P_peek(stdin);
    if (P_inset(ch, LINK->LINK->blankchars)) {
      found = true;
      break;
    }
    getc(stdin);
    if (length < maxnamelen) {
      length++;
      cname[length - 1] = lowercase(ch);
    }
  }
  /* pad word with blanks */
  for (i = length; i < maxnamelen; i++)
    cname[i] = ' ';
}  /* ReadCommandName */

Local boolean foundintable(cname, command, LINK)
Char *cname;
commandtype *command;
struct LOC_getvalidcommand *LINK;
{
  boolean Result;
  long loc;
  boolean stilllooking;
  commandrec *WITH;

  stilllooking = true;
  loc = hashfunction(cname, LINK->LINK);
  while (stilllooking) {
    WITH = &LINK->LINK->commandtable[loc];
    if (WITH->empty) {
      stilllooking = false;
      Result = false;
      continue;
    }
    if (!strncmp(WITH->name, cname, sizeof(commandname))) {
      stilllooking = false;
      Result = true;
      *command = WITH->commvalue;
    } else {
      loc = (loc + 1) % commtablesize;
/* p2c: nl.p, line 9122:
 * Note: Using % for possibly-negative arguments [317] */
    }
  }
  return Result;
}  /* FoundInTable */

Local Void getvalidcommand(command, LINK)
commandtype *command;
struct LOC_graphwalk *LINK;
{
  struct LOC_getvalidcommand V;
  boolean found;
  commandname cname;

  V.LINK = LINK;
  found = false;
  while (!found) {
    printf("GW>> ");
    readcommandname(cname, &V);
    if (foundintable(cname, command, &V)) {
      found = true;
      break;
    }
    scanf("%*[^\n]");
    getchar();
    printf("Command unknown: %.*s\n", maxnamelen, cname);
  }
}  /* GetValidCommand */

/* -------------------------------------------------------------- */
/* The following procedures  the operations of the          */
/* graphwalker.            */

Local long findlooplevel(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{
  long level;
  boolean found;

  if (n == module)
    return -1;
  else {
    level = 0;
    found = false;
    while (!found) {
      if (n->ndsort == ndgraph) {
	switch (graphkind(n)) {

	case ifgselector:
	case ifgalternative:
	case ifgvariant:
	case ifgloopainit:
	case ifgloopbinit:
	case ifgifpredicate:
	case ifgiftrue:
	case ifgiffalse:
	  break;

	case ifgloopabody:
	case ifgloopatest:
	case ifgloopareturns:
	case ifgloopbbody:
	case ifgloopbtest:
	case ifgloopbreturns:
	case ifgforallgenerator:
	case ifgforallbody:
	case ifgforallreturns:
	  level++;
	  break;

	case ifgfunction:
	  found = true;
	  break;
	}/* case */
      }
      n = n->ndparent;
    }
    return level;
  }
}  /* FindLoopLevel */

Local long findlexicallevel(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{
  /* Function graphs are considered to be at level 0
     and the level number increases each time you dive
     into a the subgraphs of a compound node
   */
  long level;

  if (n == module)
    return -1;
  else {
    level = -1;
    do {
      n = toenclosingcompound(n);
      level++;
    } while (n != NULL);
    return level;
  }
}  /* FindLexicalLevel */

Local Void displayedge(e, LINK)
port *e;
struct LOC_graphwalk *LINK;
{
  FILE *TEMP1;

  if (e == NULL) {
    printf("Error:  nil edge pointer\n");
    return;
  }
  printf("%4ld", e->ptif1line);
  if (e->ptsort == ptedge)
    printf(":  E  %2ld %2ld", e->UU.U1.ptfrnode->ndlabel, e->UU.U1.ptfrport);
  else
    printf(":  L       ");
  printf("     %2ld %2ld", e->pttonode->ndlabel, e->pttoport);
  printf("  Type: %3ld", e->pttype->stlabel);
  if (e->ptsort == ptlit) {
    printf("  \"");
    TEMP1 = stdout;
/* p2c: nl.p, line 9213:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
    writestring(&TEMP1, &e->UU.ptlitvalue);
    putchar('"');
  }
  if (e->ptname.len != 0) {
    printf("  Name: ");
    TEMP1 = stdout;
/* p2c: nl.p, line 9219:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
    writestring(&TEMP1, &e->ptname);
  }
  if (e->ptdfaddr > 0)
    printf("   %%of=%ld", e->ptdfaddr);
  putchar('\n');
}  /* DisplayEdge */

Local Void displaynode(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{
  long i, pos;
  printable name;
  ifgraphtype gkind;
  FILE *TEMP1;

  if (n == NULL) {
    printf("ERROR: Nil node pointer\n");
    return;
  }
  printf("%4ld:", n->ndline);
  if (n->ndsort == ndgraph) {
    printf("  G %2ld   ", n->ndlabel);
    gkind = graphkind(n);
    pos = 1;
    memcpy(name, graphname[(long)gkind], sizeof(printable));
    while (name[pos - 1] != ' ') {
      putchar(name[pos - 1]);
      pos++;
    }
    if (gkind == ifgfunction) {
      putchar(' ');
      TEMP1 = stdout;
/* p2c: nl.p, line 9252:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
      writestring(&TEMP1, &n->UU.U1.ndlink->lkname);
      pos += n->UU.U1.ndlink->lkname.len + 1;
    }
    for (i = pos + 1; i <= 19; i++)
      putchar(' ');
  } else {
    printf("  N %2ld   ", n->ndlabel);
    pos = 1;
    memcpy(name, nodename[n->ndcode], sizeof(printable));
    while (name[pos - 1] != ' ') {
      putchar(name[pos - 1]);
      pos++;
    }
    for (i = pos + 1; i <= 19; i++)
      putchar(' ');
  }
  printf("  Id: %4ld   Level: %2ld\n", n->ndid, findlexicallevel(n, LINK));
}  /* DisplayNode */

Local Void writetype(t)
stentry *t;
{
  FILE *TEMP1;

  if (t == NULL) {
    printf("Nil");
    return;
  }
  switch (t->stsort) {

  case iftarray:
    printf("Array[ ");
    writetype(t->UU.stbasetype);
    printf(" ] ");
    break;

  case iftbasic:
    TEMP1 = stdout;
/* p2c: nl.p, line 9287:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
    writestring(&TEMP1, &t->stliteral);
    break;

  case iftfunctiontype:
    printf("Function ( ");
    writetype(t->UU.U3.starg);
    printf(" RETURNS ");
    writetype(t->UU.U3.stres);
    putchar(')');
    break;

  case iftmultiple:
    printf("Multiple[ ");
    writetype(t->UU.stbasetype);
    printf(" ] ");
    break;

  case iftrecord:
    printf("Record[ ");
    writetype(t->UU.stbasetype);
    printf(" ] ");
    break;

  case iftstream:
    printf("Stream[ ");
    writetype(t->UU.stbasetype);
    printf(" ] ");
    break;

  case ifttuple:
  case iftfield:
  case ifttag:
    writetype(t->UU.U2.stelemtype);
    if (t->UU.U2.stnext != NULL) {
      printf(", ");
      writetype(t->UU.U2.stnext);
    }
    break;

  case iftunion:
    printf("Union[ ");
    writetype(t->UU.stbasetype);
    printf(" ] ");
    break;

  case iftbuffer:
    printf("Buffer[ ");
    writetype(t->UU.stbasetype);
    printf("] ");
    break;

  case 10:
    printf(" special structured Wild type ");
    break;
  }/* case */
}  /* WriteType */

Local Void displaytype(LINK)
struct LOC_graphwalk *LINK;
{
  long typenum;

  if (!readinteger_(&typenum, LINK)) {
    printf("Invalid Integer Argument\n");
    return;
  }
  if (typenum < 1 || typenum > tthwm) {
    printf("Integer argument out of range: %ld\n", typenum);
    return;
  }
  printf("Type %3ld = ", typenum);
  writetype(typetable[typenum - 1]);
  putchar('\n');
}  /* DisplayType */

Local Void marknode(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{
  n->ndid = -n->ndid;
}

Local boolean nodemarked(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{
  return (n->ndid < 0);
}

Local Void unmarkgraph(g, count, LINK)
node *g;
long count;
struct LOC_graphwalk *LINK;
{
  node *n;

  n = g->ndnext;
  while (count > 0) {
    if (n->ndid < 0) {
      count--;
      n->ndid = -n->ndid;
    }
    n = n->ndnext;
  }
}

Local Void gatherboundaryedges(l, n, mcount, LINK)
intlist *l;
node *n;
long *mcount;
struct LOC_graphwalk *LINK;
{
  node *pn;
  port *e;

  /* assume N is not marked */
  (*mcount)++;
  marknode(n, LINK);
  e = n->ndilist;
  while (e != NULL) {
    if (e->ptsort == ptedge) {
      pn = producernodeofedge(e);
      if (pn->ndsort == ndgraph)
	addtolist(l, producerportnumber(e), LINK);
      else if (!nodemarked(pn, LINK))
	gatherboundaryedges(l, pn, mcount, LINK);
    }
    e = e->pttonext;
  }
}  /* GatherBoundaryEdges */


Local Void listallfuns(LINK)
struct LOC_graphwalk *LINK;
{
  node *fun;

  fun = firstfunction;
  while (fun != NULL) {
    displaynode(fun, LINK);
    fun = tonextfunction(fun);
  }
}  /* ListAllFuns */

Local Void listallnodes(current, LINK)
node *current;
struct LOC_graphwalk *LINK;
{
  node *g, *n;

  if (current->ndsort == ndgraph)
    g = current;
  else
    g = current->ndparent;
  n = g->ndnext;
  if (n == NULL) {
    printf("Graph is Empty\n");
    return;
  }
  while (n != NULL) {
    displaynode(n, LINK);
    n = n->ndnext;
  }
}  /* ListAllNodes */

Local Void gotonextnode(cursor, LINK)
node **cursor;
struct LOC_graphwalk *LINK;
{
  node *n;

  n = (*cursor)->ndnext;
  if (n == NULL)
    printf("At end of graph\n");
  else {
    *cursor = n;
    displaynode(*cursor, LINK);
  }
}  /* GotoNextNode */

Local Void gotoparent(cursor, LINK)
node **cursor;
struct LOC_graphwalk *LINK;
{
  if (*cursor == module) {
    printf("How did you get here?  Module is off limits!\n");
    return;
  }
  if ((*cursor)->ndparent == module)
    printf("At top of function, you can't move up\n");
  else {
    *cursor = (*cursor)->ndparent;
    displaynode(*cursor, LINK);
  }
}  /* GotoParent */

Local Void showcurrfun(cursor, LINK)
node *cursor;
struct LOC_graphwalk *LINK;
{
  boolean finished;

  if (cursor == module) {
    printf("At Top Of Graph\n");
    return;
  }
  finished = false;
  while (!finished) {
    if (cursor->ndsort == ndgraph) {
      if (cursor->UU.U1.ndlink != NULL)
	finished = true;
      else
	cursor = cursor->ndparent;
    } else
      cursor = cursor->ndparent;
  }
  displaynode(cursor, LINK);
}  /* ShowCurrFun */

Local Void gotonodeid(cursor, LINK)
node **cursor;
struct LOC_graphwalk *LINK;
{
  node *n;
  long id;

  if (!readinteger_(&id, LINK)) {
    printf("Error: Bad node Id\n");
    return;
  }
  if (id < 1 || id > univnodecnt) {
    printf("Argument out of range: %ld\n", id);
    return;
  }
  n = toenclosingfunction(*cursor);
  n = getnodewithid(n, id);
  if (n == NULL)
    printf("No such node in current function\n");
  else {
    *cursor = n;
    displaynode(*cursor, LINK);
  }
}  /* GotoNodeId */

Local Void showoutedges(cursor, LINK)
node *cursor;
struct LOC_graphwalk *LINK;
{
  port *e;
  long port_;

  if (readinteger_(&port_, LINK)) {
    e = getoutputedge(cursor, port_);
    if (e == NULL) {
      printf("No output edges from port %ld\n", port_);
      return;
    }
    do {
      displayedge(e, LINK);
      e = nextoutputedgesameport(e);
    } while (e != NULL);
    return;
  }
  e = cursor->ndolist;
  if (e == NULL) {
    printf("No Output Edges\n");
    return;
  }
  while (e != NULL) {
    displayedge(e, LINK);
    e = e->UU.U1.ptfrnext;
  }
}  /* ShowOutEdges */

Local Void showinedges(cursor, LINK)
node *cursor;
struct LOC_graphwalk *LINK;
{
  port *e;
  long port_;

  if (readinteger_(&port_, LINK)) {
    e = getinputedge(cursor, port_);
    if (e == NULL)
      printf("No input edges to port %ld\n", port_);
    else
      displayedge(e, LINK);
    return;
  }
  e = cursor->ndilist;
  if (e == NULL) {
    printf("No Input Edges\n");
    return;
  }
  while (e != NULL) {
    displayedge(e, LINK);
    e = e->pttonext;
  }

  /* No argument, display all edges */
}  /* ShowInEdges */

Local Void gotosubgraph(cursor, LINK)
node **cursor;
struct LOC_graphwalk *LINK;
{
  long graphnum;

  if ((*cursor)->ndsort != ndcompound) {
    printf("Not at a compound node\n");
    return;
  }
  if (!readinteger_(&graphnum, LINK)) {
    printf("Invalid integer argument\n");
    return;
  }
  if ((graphnum < 0) | (graphnum >= numbofsubgraphs(*cursor)))
    printf("No Subgraph numbered: %ld\n", graphnum);
  else {
    *cursor = tochildgraph(*cursor, graphnum);
    displaynode(*cursor, LINK);
  }
}  /* GotoSubgraph */

Local Void gotonodelabel(cursor, LINK)
node **cursor;
struct LOC_graphwalk *LINK;
{
  node *g, *n;
  long lab;

  if (*cursor == module)
    g = *cursor;
  else if ((*cursor)->ndsort == ndgraph)
    g = *cursor;
  else
    g = (*cursor)->ndparent;
  if (!readinteger_(&lab, LINK)) {
    printf("Invalid Integer argument\n");
    return;
  }
  n = getnodewithlabel(g, lab);
  if (n == NULL)
    printf("No node with label: %ld\n", lab);
  else {
    *cursor = n;
    displaynode(*cursor, LINK);
  }
}  /* GotoNodeLabel */

/* Local variables for findnodes: */
struct LOC_findnodes {
  struct LOC_graphwalk *LINK;
  boolean recursive;
} ;

Local Void searchgraph(g, opcode, LINK)
node *g;
long opcode;
struct LOC_findnodes *LINK;
{
  node *n;
  long graphnum, FORLIM;

  n = g->ndnext;
  while (n != NULL) {
    if (n->ndcode == opcode)
      displaynode(n, LINK->LINK);
    if (LINK->recursive && n->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(n);
      for (graphnum = 0; graphnum < FORLIM; graphnum++)
	searchgraph(tochildgraph(n, graphnum), opcode, LINK);
    }
    n = n->ndnext;
  }
}  /* SearchGraph */

Local Void findnodes(cursor, recursive_, LINK)
node *cursor;
boolean recursive_;
struct LOC_graphwalk *LINK;
{
  struct LOC_findnodes V;
  node *g;
  long opcode;

  V.LINK = LINK;
  V.recursive = recursive_;
  if (cursor == module)
    g = cursor;
  else if (cursor->ndsort == ndgraph)
    g = cursor;
  else
    g = cursor->ndparent;
  if (readinteger_(&opcode, LINK))
    searchgraph(g, opcode, &V);
  else
    printf("Invalid Integer Argument\n");
}  /* FindNodes */

Local Void moveright_(cursor, LINK)
node **cursor;
struct LOC_graphwalk *LINK;
{
  /* If Cursor is positioned in a subgraph of a compound
     node, move to the sibling graph to the right (if one
     exists)
   */
  node *g;
  graph *gtemp;

  if (*cursor == module) {
    printf("Not in Subgraph of Compound Node\n");
    return;
  }
  if ((*cursor)->ndsort == ndgraph)
    g = *cursor;
  else
    g = (*cursor)->ndparent;
  gtemp = g->ndparent->UU.U2.ndsubsid;
  while (gtemp->grnode != g)
    gtemp = gtemp->grnext;
  if (gtemp->grnext == NULL)
    printf("No Graph to the right\n");
  else {
    *cursor = gtemp->grnext->grnode;
    displaynode(*cursor, LINK);
  }
}  /* MoveRight */

Local Void moveleft_(cursor, LINK)
node **cursor;
struct LOC_graphwalk *LINK;
{
  /* If Cursor is positioned in a subgraph of a compound
     node, move to the sibling graph to the left (if one
     exists)
   */
  node *g;
  graph *gtemp;

  if (*cursor == module) {
    printf("Not in Subgraph of Compound Node\n");
    return;
  }
  if ((*cursor)->ndsort == ndgraph)
    g = *cursor;
  else
    g = (*cursor)->ndparent;
  gtemp = g->ndparent->UU.U2.ndsubsid;
  if (gtemp->grnode == g) {
    printf("No subgraph to the left\n");
    return;
  }
  while (gtemp->grnext->grnode != g)
    gtemp = gtemp->grnext;
  *cursor = gtemp->grnode;
  displaynode(*cursor, LINK);
}  /* MoveLeft */

Local Void shownodesabove(cursor, LINK)
node *cursor;
struct LOC_graphwalk *LINK;
{
  long port_;
  port *e;
  intlist l;
  node *g;

  if (readinteger_(&port_, LINK)) {
    e = getinputedge(cursor, port_);
    if (e == NULL) {
      printf("No edge connected to input port: %ld\n", port_);
      return;
    }
    if (e->ptsort == ptlit)
      printf("Literal connected to port: %ld\n", port_);
    else
      displaynode(producernodeofedge(e), LINK);
    return;
  }
  initlist(&l, LINK);
  if (cursor->ndsort == ndgraph)
    g = cursor;
  else
    g = cursor->ndparent;
  e = cursor->ndilist;
  while (e != NULL) {
    if (e->ptsort == ptedge)
      addtolist(&l, nodelabel(producernodeofedge(e)), LINK);
    e = e->pttonext;
  }
  if (emptylist(&l, LINK))
    printf("Not Dependant on any nodes\n");
  else {
    while (!emptylist(&l, LINK))
      displaynode(getnodewithlabel(g, poplist(&l, LINK)), LINK);
  }
}  /* ShowNodesAbove */

Local Void shownodesbelow(cursor, LINK)
node *cursor;
struct LOC_graphwalk *LINK;
{
  long port_;
  port *e;
  intlist l;
  node *g;

  initlist(&l, LINK);
  if (cursor->ndsort == ndgraph)
    g = cursor;
  else
    g = cursor->ndparent;
  if (readinteger_(&port_, LINK)) {
    e = getoutputedge(cursor, port_);
    if (e == NULL)
      printf("No edges connected to output port: %ld\n", port_);
    else {
      while (e != NULL) {
	addtolist(&l, nodelabel(e->pttonode), LINK);
	e = nextoutputedgesameport(e);
      }
    }
  } else {
    e = cursor->ndolist;
    while (e != NULL) {
      addtolist(&l, nodelabel(e->pttonode), LINK);
      e = e->UU.U1.ptfrnext;
    }
  }
  while (!emptylist(&l, LINK))
    displaynode(getnodewithlabel(g, poplist(&l, LINK)), LINK);
}  /* ShowNodesBelow */

Local Void showgraph(cursor, LINK)
node *cursor;
struct LOC_graphwalk *LINK;
{
  if (cursor == module) {
    printf("Not in a graph\n");
    return;
  }
  if (cursor->ndsort == ndgraph)
    displaynode(cursor, LINK);
  else
    displaynode(cursor->ndparent, LINK);
}  /* ShowGraph */

Local Void givehelp(LINK)
struct LOC_graphwalk *LINK;
{
  printf("above [port]     : List nodes directly above current node\n");
  printf("allf             : List all function in Module\n");
  printf("below [port]     : List nodes directly below current node\n");
  printf("dn               : Dump the node record of the current node\n");
  printf("di [port]        : Dump the input edge record(s)\n");
  printf("do [port]        : Dump the output edge record(s)\n");
  printf("ddepi\t\t: Dump the input dependence edge records\n");
  printf("ddepo\t\t: Dump the output dependence edge records\n");
  printf("f <opcode>       : List all nodes in current graph with the given opcode\n");
  printf("f <opcode>       : List all nodes in function with the given opcode\n");
  printf("fun              : List function containing current node\n");
  printf("gport            : List graph ports which effect current node\n");
  printf("graph            : List graph containing current node\n");
  printf("help             : Display this HELP table\n");
  printf("id <idnum>       : Move cursor to the node with this idnum\n");
  printf("iedge [port]     : List input edges of cursor\n");
  printf("l                : Move to left sibling graph\n");
  printf("label <lnum>     : Move cursor to node in current graph with this label\n");
  printf("loop    \t\t: Show cursors loop depth\n");
  printf("n                : Move to next node in the graph\n");
  printf("nodes            : List all nodes in the current graph\n");
  printf("oedge [port]     : List output edges of cursor\n");
  printf("up               : Move to parent graph or node\n");
  printf("pos              : Show current position\n");
  printf("q                : Quit the graphwalker\n");
  printf("r                : Move to the right sibling graph\n");
  printf("table            : Show distribution of commands in hash table\n");
  printf("down <grnum>     : Move to given subgraph of compound node (zero based)\n");
  printf("type <typenum>   : Show structure of given type\n");
}  /* GiveHelp */

Local Void showgraphports(cursor, LINK)
node *cursor;
struct LOC_graphwalk *LINK;
{
  intlist l;
  long markcount;

  if (cursor == module || cursor->ndsort == ndgraph) {
    printf("At graph node\n");
    return;
  }
  initlist(&l, LINK);
  markcount = 0;
  gatherboundaryedges(&l, cursor, &markcount, LINK);
  unmarkgraph(cursor->ndparent, markcount, LINK);
  printf("Graph Ports: ");
  while (!emptylist(&l, LINK))
    printf("%3ld", poplist(&l, LINK));
  putchar('\n');
}  /* ShowGraphPorts */

Local Void dumpnode(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{
  long count;
  graph *g;
  linkrec *WITH1;
  FILE *TEMP1;

/* p2c: nl.p, line 9834:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9834:
 * Note: Element has wrong type for WRITE statement [196] */
  printf("N =         <meef>\n");

  printf("NDId =      %11ld   NDLabel =  %11ld\n", n->ndid, n->ndlabel);
  printf("NDCode =    %11ld   NDMisc. =   %11ld\n", n->ndcode, n->ndmisc.numb);
/* p2c: nl.p, line 9838:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9838:
 * Note: Element has wrong type for WRITE statement [196] */
/* p2c: nl.p, line 9838:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9838:
 * Note: Element has wrong type for WRITE statement [196] */
  printf("NDParent =  <meef>   NDNext =   <meef>\n");
/* p2c: nl.p, line 9839:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9839:
 * Note: Element has wrong type for WRITE statement [196] */
/* p2c: nl.p, line 9839:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9839:
 * Note: Element has wrong type for WRITE statement [196] */
  printf("NDIList =   <meef>   NDOList =  <meef>\n");

  printf("NDLine =    %11ld\n", n->ndline);
  printf("NDSrcLine = %11ld   NDWiLine = %11ld\n", n->ndsrcline, n->ndwiline);
  printf("NDXCoord =  %11ld   NDYCoord = %11ld\n", n->ndxcoord, n->ndycoord);
  switch (n->ndsort) {

  case ndatomic:
    printf("NDSort =       NDAtomic  (Simple Node)\n");
    break;

  case ndcompound:
    printf("NDSort =     NDCompound   NDAssoc =  <meef>\n");
/* p2c: nl.p, line 9850:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9850:
 * Note: Element has wrong type for WRITE statement [196] */
    printf("NDSubsid =  <meef>\n");

    count = 0;
    g = n->UU.U2.ndsubsid;
    while (g != NULL) {
      printf("  Graph %ld: (G = <meef>)  GRNode = <meef>  GRNext = <meef>\n",
	     count);

      g = g->grnext;
      count++;
    }
/* p2c: nl.p, line 9856:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9856:
 * Note: Element has wrong type for WRITE statement [196] */
/* p2c: nl.p, line 9857:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9857:
 * Note: Element has wrong type for WRITE statement [196] */
/* p2c: nl.p, line 9857:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9857:
 * Note: Element has wrong type for WRITE statement [196] */
    break;
/* p2c: nl.p, line 9849:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9849:
 * Note: Element has wrong type for WRITE statement [196] */

  case ndgraph:
    printf("NDSort =        NDGraph   NDType =   <meef>");


    if (n->UU.U1.ndtype != NULL)
      printf("  (STLabel = %ld)\n", n->UU.U1.ndtype->stlabel);
    else
      putchar('\n');
/* p2c: nl.p, line 9872:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9872:
 * Note: Element has wrong type for WRITE statement [196] */
    printf("NDLink =    <meef>\n");

    if (n->UU.U1.ndlink != NULL) {
      WITH1 = n->UU.U1.ndlink;
      switch (WITH1->lksort) {

      case lslocal:
	printf(" LKSort =     LSLocal\n");
	break;

      case lsimported:
	printf(" LKSort =     LSImported  (Global)\n");
	break;

      case lsexported:
	printf(" LKSort =     LSExported  (Defined)\n");
	break;
      }/*case*/
      printf(" LKName =     ");
      TEMP1 = stdout;
/* p2c: nl.p, line 9883:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
      writestring(&TEMP1, &WITH1->lkname);
      printf("\n LKGraph =   <meef>  LKNext =    <meef>\n");
/* p2c: nl.p, line 9885:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9885:
 * Note: Element has wrong type for WRITE statement [196] */
/* p2c: nl.p, line 9885:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9885:
 * Note: Element has wrong type for WRITE statement [196] */

      printf(" LKARSize =  %11ld  LKARIndex = %11ld\n",
	     WITH1->lkarsize, WITH1->lkarindex);
      if (WITH1->lkexpand)
	printf(" LKExpand =   TRUE\n");
      else
	printf(" LKExpand =   FALSE\n");
    }
    break;
/* p2c: nl.p, line 9865:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9865:
 * Note: Element has wrong type for WRITE statement [196] */
  }/* case */
}  /* DumpNode */

Local Void dumponeedge(e, LINK)
port *e;
struct LOC_graphwalk *LINK;
{
  FILE *TEMP1;

/* p2c: nl.p, line 9902:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9902:
 * Note: Element has wrong type for WRITE statement [196] */
/* p2c: nl.p, line 9902:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9902:
 * Note: Element has wrong type for WRITE statement [196] */
  printf("E =         <meef>   PTType =    <meef>");

  if (e->pttype != NULL)
    printf("  (STLabel = %ld)\n", e->pttype->stlabel);
  else
    putchar('\n');
  printf("PTIF1Line = %11ld   PTName =    ", e->ptif1line);
  TEMP1 = stdout;
/* p2c: nl.p, line 9909:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
  writestring(&TEMP1, &e->ptname);
  printf("\nPTToNode =  <meef>   (NodeID = %ld)\n", e->pttonode->ndid);
/* p2c: nl.p, line 9911:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9911:
 * Note: Element has wrong type for WRITE statement [196] */

/* p2c: nl.p, line 9914:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9914:
 * Note: Element has wrong type for WRITE statement [196] */
  printf("PTToNext =  <meef>   PTToPort =  %11ld\n", e->pttoport);

  printf("PTSrcLine = %11ld   PTWiLine =  %11ld\n", e->ptsrcline, e->ptwiline);
  printf("PTId =      %11ld", e->ptid);
  if (e->ptmark == byref)
    printf("   PTMark =          ByRef\n");
  else if (e->ptmark == byval)
    printf("   PTMark =          ByVal\n");
  else
    printf("   PTMark =          ByDefault\n");
  printf("PTLBound =  %11ld   PTUBound =  %11ld\n", e->ptlbound, e->ptubound);
  printf("PTDFAddr =  %11ld\n", e->ptdfaddr);
  if (e->ptsort == ptedge) {
    printf("PTSort =         PTEdge\n");
/* p2c: nl.p, line 9929:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9929:
 * Note: Element has wrong type for WRITE statement [196] */
    printf("PTFrNode =  <meef>   (^.NDId  = %ld)\n", e->UU.U1.ptfrnode->ndid);

/* p2c: nl.p, line 9932:
 * Internal error in writeelement: got a char * instead of a string [214] */
/* p2c: nl.p, line 9932:
 * Note: Element has wrong type for WRITE statement [196] */
    printf("PTFrNext =  <meef>   PTFrPort =  %11ld\n", e->UU.U1.ptfrport);

    return;
  }
  printf("PTSort =          PTLit\n");
  printf("PTLitValue =     ");
  TEMP1 = stdout;
/* p2c: nl.p, line 9939:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
  writestring(&TEMP1, &e->UU.ptlitvalue);
  putchar('\n');
}  /* DumpOneEdge */

Local Void dumpdepinputedges(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{
  port *e;

  e = n->nddepilist;
  if (e == NULL)
    printf("This node as no input dependence edges. \n");
  while (e != NULL) {
    dumponeedge(e, LINK);
    e = e->pttonext;
    if (e != NULL) {
      if (e->pttoport != 0)
	e = NULL;
      else
	printf("error, dep edges not connected to real edges\n");
    }
    if (e != NULL)
      printf("---------------\n");
  }
}

Local Void dumpdepoutputedges(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{
  port *e;

  e = n->nddepolist;
  if (e == NULL)
    printf("This node as no output dependence edges. \n");
  while (e != NULL) {
    dumponeedge(e, LINK);
    e = nextoutputedgesameport(e);
    if (e != NULL)
      printf("---------------\n");
  }
}

Local Void dumpinputedges_(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{
  long port_;
  port *e;

  if (readinteger_(&port_, LINK)) {
    e = getinputedge(n, port_);
    if (e == NULL)
      printf("No input edge on port # %ld\n", port_);
    else
      dumponeedge(e, LINK);
    return;
  }
  e = n->ndilist;
  while (e != NULL) {
    dumponeedge(e, LINK);
    e = e->pttonext;
    if (e != NULL)
      printf("---------------\n");
  }

  /* Dump All Input Edges */
}

Local Void dumpallinput(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{  /* Dump All Input Edges */
  port *e;

  if (n->nddepilist == NULL)
    e = n->ndilist;
  else
    e = n->nddepilist;
  while (e != NULL) {
    dumponeedge(e, LINK);
    e = e->pttonext;
    if (e != NULL)
      printf("---------------\n");
  }
}

Local Void dumpoutputedges(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{
  long port_;
  port *e;

  if (readinteger_(&port_, LINK)) {
    e = getoutputedge(n, port_);
    if (e == NULL) {
      printf("No output edge on port # %ld\n", port_);
      return;
    }
    while (e != NULL) {
      dumponeedge(e, LINK);
      e = nextoutputedgesameport(e);
      if (e != NULL)
	printf("---------------\n");
    }
    return;
  }
  e = n->ndolist;
  while (e != NULL) {
    dumponeedge(e, LINK);
    e = e->UU.U1.ptfrnext;
    if (e != NULL)
      printf("---------------\n");
  }

  /* Dump All Input Edges */
}  /* DumpOutputEdges */

Local Void dumpalloutput(n, LINK)
node *n;
struct LOC_graphwalk *LINK;
{  /* Dump All Output Edges */
  port *e;

  if (n->nddepolist == NULL)
    e = n->ndolist;
  else
    e = n->nddepolist;
  while (e != NULL) {
    dumponeedge(e, LINK);
    e = e->UU.U1.ptfrnext;
    if (e != NULL)
      printf("---------------\n");
  }
}





Static node *graphwalk(start)
node *start;
{
  struct LOC_graphwalk V;
  node *Result, *cursor;
  commandtype command;

  P_addset(P_expset(V.blankchars, 0L), ' ');
  P_addset(V.blankchars, (Char)tab);
  initcommandtable(&V);
  cursor = start;
  command = ccposition;
  displaynode(cursor, &V);
  while (command != ccquit) {
    getvalidcommand(&command, &V);
    switch (command) {

    case cclisallfun:
      listallfuns(&V);
      break;

    case cclisallnodes:
      listallnodes(cursor, &V);
      break;

    case ccrecfind:
      findnodes(cursor, true, &V);
      break;

    case ccfunction:
      showcurrfun(cursor, &V);
      break;

    case cchelp:
      givehelp(&V);
      break;

    case ccnodeid:
      gotonodeid(&cursor, &V);
      break;

    case cclisinedges:
      showinedges(cursor, &V);
      break;

    case cclooplevel:
      printf("Loop Level: %ld\n", findlooplevel(cursor, &V));
      break;

    case ccgraphports:
      showgraphports(cursor, &V);
      break;

    case ccnodelabel:
      gotonodelabel(&cursor, &V);
      break;

    case cclisnodeswop:
      findnodes(cursor, false, &V);
      break;

    case ccnextnode:
      gotonextnode(&cursor, &V);
      break;

    case cclisoutedges:
      showoutedges(cursor, &V);
      break;

    case ccparent:
      gotoparent(&cursor, &V);
      break;

    case ccposition:
      displaynode(cursor, &V);
      break;

    case ccquit:
      Result = cursor;
      break;

    case ccshowtable:
      displaytable(&V);
      break;

    case ccsubgraph:
      gotosubgraph(&cursor, &V);
      break;

    case ccdisptype:
      displaytype(&V);
      break;

    case ccright:
      moveright_(&cursor, &V);
      break;

    case ccleft:
      moveleft_(&cursor, &V);
      break;

    case ccnodesabove:
      shownodesabove(cursor, &V);
      break;

    case ccnodesbelow:
      shownodesbelow(cursor, &V);
      break;

    case ccgraph:
      showgraph(cursor, &V);
      break;

    case ccdumpnode:
      dumpnode(cursor, &V);
      break;

    case ccdumpinput:
      dumpinputedges_(cursor, &V);
      break;

    case ccdumpoutput:
      dumpoutputedges(cursor, &V);
      break;

    case ccdumpdepinput:
      dumpdepinputedges(cursor, &V);
      break;

    case ccdumpdepoutput:
      dumpdepoutputedges(cursor, &V);
      break;

    case ccdumpallinput:
      dumpallinput(cursor, &V);
      break;

    case ccdumpalloutput:
      dumpalloutput(cursor, &V);
      break;
    }/* case */
    scanf("%*[^\n]");
    getchar();
  }
  return Result;
}  /* GraphWalk */

#undef tab
#undef maxnamelen
#undef commtablesize
#undef commtablemax
#undef intlistlen


#define stacksize       300

#define ident           "$Header: offset.m4,v 1.2 86/05/22 10:05:00 welcome Exp $"


/* Local variables for asgnar: */
struct LOC_asgnar {
  long specialsizenodes[ifmaxnode / 32 + 2];
  long specialnodes[ifmaxnode / 32 + 2];
  port *stack[stacksize];
  short stackptr;
} ;

Local Void moveup PP((port *e, struct LOC_asgnar *LINK));
Local Void movedown PP((port *e, struct LOC_asgnar *LINK));

/* ----------------------------------------------------------------- */

Local Void initoffsets(g, LINK)
node *g;
struct LOC_asgnar *LINK;
{
  /* Initialize all edges in the graph to have offsets of -1 */
  long gnum;
  node *n;
  port *e;
  long FORLIM;

  n = g;
  while (n != NULL) {
    /* init the input edges of N */
    e = n->ndilist;
    while (e != NULL) {
      e->ptdfaddr = -1;
      e = e->pttonext;
    }
    if (n->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(n);
      for (gnum = 0; gnum < FORLIM; gnum++)
	initoffsets(tochildgraph(n, gnum), LINK);
    }
    n = n->ndnext;
  }
}  /* InitOffsets */

Local Void insertnoop(g, e)
node *g;
port *e;
{
  /* -----------------------------------------------------------
     Looks at last node in graph G
       - if G empty or last node <> NoOp then insert a NoOp node
         otherwise the last node is already a NoOp.
       - Change the destination of E so that it is connected to
         this noop node at the first available input port.
       - Add a new edge from this NoOp node to the graph
         boundary where E used to be connected.  Give this
         edge the same name and type as E
       - Works for either Literals or Edges
     ------------------------------------------------------------ */
  port *newedge;
  node *newnode, *prev;
  boolean insert;
  stryng ename;
  stentry *etype;
  long toport, newport;

  prev = tolastnodeingraph(g);
  if (prev == NULL)
    insert = true;
  else if (prev->ndcode != ifnnoop)
    insert = true;
  else
    insert = false;
  if (insert) {
    newnode = createsimplenode((long)ifnnoop);
    insertnode(g, prev, newnode);
    newport = 1;
  } else {
    newnode = prev;
    newport = largestinputportnumber(newnode) + 1;
  }
  ename = e->ptname;
  etype = e->pttype;
  toport = e->pttoport;
  changeedgedest(e, newnode, newport);
  memcpy(e->ptname.str, blankstring, sizeof(stryngar));
  e->ptname.len = 0;
  newedge = insertedge(newnode, newport, g, toport, etype, ename);
}  /* InsertNoOp */

Local Void checkliteral(e, g)
port *e;
node *g;
{
  /* There are certain cases when a NoOp node must be inserted between */
  /* a literal and the input ports of a Graph node.  If this is not    */
  /* done, the address of the literal would, in certain cases be the   */
  /* same as an edges in a different subgraph and the value may be     */
  /* changed.  Literals are supposed to be constant.                   */
  switch (graphkind(g)) {

  case ifgfunction:
  case ifgselector:
  case ifgloopatest:
  case ifgloopbtest:
  case ifgforallbody:
  case ifgifpredicate:   /* literals ok */
    break;

  case ifgvariant:
  case ifgloopareturns:
  case ifgloopbreturns:
  case ifgalternative:
  case ifgloopainit:
  case ifgloopbinit:
  case ifgforallgenerator:
  case ifgforallreturns:
  case ifgloopabody:
  case ifgloopbbody:
  case ifgiftrue:
  case ifgiffalse:
  case ifgiterbody:
    insertnoop(g, e);
    break;
  }/* case */
}  /* CheckLiteral */


Local Void checkedge(e, g)
port *e;
node *g;
{
  /* As mentioned above, a direct edge from the import to the outport */
  /* of a subgraph may cause input and output edges of the surrounding*/
  /* compound node to have the same address.                          */
  long portnum, k, l;

  switch (graphkind(g)) {

  case ifgfunction:
  case ifgselector:
  case ifgloopatest:
  case ifgloopbtest:
  case ifgforallbody:
  case ifgifpredicate:   /* direct edges ok */
    break;

  case ifgforallgenerator:
  case ifgforallreturns:
  case ifgiftrue:
  case ifgiffalse:
  case ifgloopainit:
  case ifgloopbinit:
  case ifgloopareturns:
  case ifgloopbreturns:
  case ifgvariant:
  case ifgalternative:
  case ifgiterbody:
    insertnoop(g, e);
    break;

  case ifgloopabody:
  case ifgloopbbody:
    k = largestinputportnumber(toenclosingcompound(g));
    l = largestinputportnumber(g);
    if (l == 0)
      l = k;
    portnum = producerportnumber(e);
    if (portnum <= l)
      insertnoop(g, e);
    break;

  }/* case */
}  /* CheckEdge */

Local Void addnoops(g, LINK)
node *g;
struct LOC_asgnar *LINK;
{
  /* Find places in the graph where NoOp nodes must be inserted in */
  /* order to insure that all the input addresses of a node are    */
  /* distinct from the output addresses.                           */
  long srcport, numloopvals, portnum, graphnum;
  port *srce, *e;
  node *srcnode, *n;
  long FORLIM;
  ifgraphtype TEMP1;

  FORLIM = largestinputportnumber(g);
  /* First check the graphs input list */
  for (portnum = 1; portnum <= FORLIM; portnum++) {
    e = getinputedge(g, portnum);
    if (e != NULL) {
      if (e->ptsort == ptlit)
	checkliteral(e, g);
      else if (producernodeofedge(e) == g)
	checkedge(e, g);
    }
  }

  TEMP1 = graphkind(g);
  /* Make sure that no two loop values will be assigned the
     same offset.  This only applies to the INIT graphs of
     the LoopA and LoopB nodes and the Generator graph of
     the Forall node. */
  /* 11/25/85:  Added IFGAlternative and IFGVariant to
     this class for the following reason:
        if X < 5 then X+1, X+1 else X+1, X-1 end if
     in the true branch, fanout implies both results have the
     same offset.  In the false branch, they must have different
     offsets.
   */

  if (((1L << ((long)TEMP1)) & ((1L << ((long)ifgloopbinit)) |
	 (1L << ((long)ifgloopainit)) | (1L << ((long)ifgforallgenerator)) |
	 (1L << ((long)ifgalternative)) | (1L << ((long)ifgvariant)) |
	 (1L << ((long)ifgiftrue)) | (1L << ((long)ifgiffalse)))) != 0) {
/* p2c: nl.p, line 10919: Note:
 * Line breaker spent 2.0+0.54 seconds, 1747 tries on line 11564 [251] */
    FORLIM = largestinputportnumber(g);
    for (portnum = 1; portnum <= FORLIM; portnum++) {
      e = getinputedge(g, portnum);
      if (e != NULL) {
	if (e->ptsort == ptedge) {
	  srcnode = producernodeofedge(e);
	  srcport = producerportnumber(e);
	  if (fanout(srcnode, srcport) > 1) {
	    /* Count the number of Loop Values generated
	       at node = SrcNode and port = SrcPort */
	    numloopvals = 0;
	    srce = getoutputedge(srcnode, srcport);
	    while (srce != NULL) {
	      if (srce->pttonode == g)
		numloopvals++;
	      srce = nextoutputedgesameport(srce);
	    }
	    if (numloopvals > 1)
	      insertnoop(g, e);
	  }
	}
      }
    }
  }

  /* now walk the graph looking for compound nodes and
     check the graphs of each subgraph */
  n = g->ndnext;
  while (n != NULL) {
    if (n->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(n);
      for (graphnum = 0; graphnum < FORLIM; graphnum++)
	addnoops(tochildgraph(n, graphnum), LINK);
    }
    n = n->ndnext;
  }
}  /* AddNoOps */

Local Void push(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /* Push the edge E on the current stack of edges */
  if (LINK->stackptr == stacksize)
    printf("INTERNAL ERROR:  Stack overflow in Offsetter\n");
  else {
    LINK->stackptr++;
    LINK->stack[LINK->stackptr - 1] = e;
  }
}  /* Push */

Local port *pop(LINK)
struct LOC_asgnar *LINK;
{
  /* Pop the next edge off the current stack of edges.  If the */
  /* stack is empty, return a nil pointer.                     */
  port *Result;

  if (LINK->stackptr == 0)
    return NULL;
  Result = LINK->stack[LINK->stackptr - 1];
  LINK->stack[LINK->stackptr - 1] = NULL;
  LINK->stackptr--;
  return Result;
}  /* Pop */

Local Void initstack(LINK)
struct LOC_asgnar *LINK;
{
  LINK->stackptr = 0;
}  /* InitStack */

Local Void clearstack(LINK)
struct LOC_asgnar *LINK;
{
  /* Clears the stack.  IF the program works properly, this routine
     should be a NoOp. */
  while (LINK->stackptr > 0) {
    LINK->stack[LINK->stackptr - 1] = NULL;
    LINK->stackptr--;
  }
}  /* ClearStack */

Local Void dumpstack(LINK)
struct LOC_asgnar *LINK;
{
  /* This if for debugging purposes.  It lists all edges currently on
     the edge stack.  All edges on the stack are equivalent in that
     they should be assigned the same offset. */
  long pid, i;
  port *e;
  node *cn, *pn;
  long FORLIM;
  FILE *TEMP1;

  FORLIM = LINK->stackptr;
  for (i = 0; i < FORLIM; i++) {
    e = LINK->stack[i];
    printf("%4ld: ", e->ptif1line);
    cn = e->pttonode;
    pid = 0;
    if (e->ptsort == ptlit)
      printf("L%12c", ' ');
    else {
      pn = producernodeofedge(e);
      pid = pn->ndid;
      printf("E  %3ld  %2ld   ", pn->ndlabel, e->UU.U1.ptfrport);
    }
    printf("%3ld  %2ld  T=%ld  ",
	   cn->ndlabel, e->pttoport, e->pttype->stlabel);
    TEMP1 = stdout;
/* p2c: nl.p, line 10431:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
    writestring(&TEMP1, &e->ptname);
    printf("  PI=%ld  CI=%ld\n", pid, cn->ndid);
  }
}  /* DumpStack */

Local Void mark_(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /* Mark that edge E has been visited and pushed on the edge stack */
  e->ptdfaddr = 0;
}  /* Mark */

Local boolean notmarked(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /* Returns true if edge E has not yet been marked. */
  return (e->ptdfaddr < 0);
}  /* NotMarked */

Local Void gatherup(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /* if E <> nil and E has not been marked then GatherUp will do two things:
      (1) Mark and Push all sibling edges, and call MoveDown on them
      (2) Mark and Push E and call MoveUp with E
  */
  node *pn;
  long pp;
  port *se;

  if (e == NULL)
    return;
  if (!notmarked(e, LINK))
    return;
  mark_(e, LINK);
  push(e, LINK);
  if (e->ptsort != ptedge)
    return;
  pn = producernodeofedge(e);
  pp = producerportnumber(e);
  se = getoutputedge(pn, pp);   /* sibling edge */
  while (se != NULL) {
    if (notmarked(se, LINK) && se != e) {
      mark_(se, LINK);
      push(se, LINK);
      movedown(se, LINK);
    }
    se = nextoutputedgesameport(se);
  }  /* while */
  moveup(e, LINK);
}  /* GatherUp */

Local Void gatherdown(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /* If E <> nil and is not already Marked then GatherDown marks and pushes
     all sibling edges of E.  It also calls MoveDown with each. */
  node *pn;
  long pp;
  port *se;

  if (e == NULL)
    return;
  if (!notmarked(e, LINK))
    return;
  mark_(e, LINK);
  push(e, LINK);
  movedown(e, LINK);
  if (e->ptsort != ptedge) {
    return;
  }  /* (^.PTSort = PTEdge) */
  pn = producernodeofedge(e);
  pp = producerportnumber(e);
  se = getoutputedge(pn, pp);
  while (se != NULL) {
    if (notmarked(se, LINK)) {
      mark_(se, LINK);
      push(se, LINK);
      movedown(se, LINK);
    }
    se = nextoutputedgesameport(se);
  }  /* while SE */
}  /* GatherDown */

/* Local variables for moveup: */
struct LOC_moveup {
  struct LOC_asgnar *LINK;
  long pp;
} ;

/* ---------------------------------------------------------- */
Local Void atconstantport(n, g, p, LINK)
node *n, *g;
long p;
struct LOC_moveup *LINK;
{
  long gnum;
  node *subg;
  long FORLIM;

  FORLIM = numbofsubgraphs(n);
  for (gnum = 0; gnum < FORLIM; gnum++) {
    subg = tochildgraph(n, gnum);
    if (subg != g)
      gatherdown(getoutputedge(subg, p), LINK->LINK);
  }  /* for */
  gatherup(getinputedge(n, p), LINK->LINK);
}  /* AtConstantPort */

Local Void atforallreturns(n, g, p, LINK)
node *n, *g;
long p;
struct LOC_moveup *LINK;
{
  node *geng, *bodyg;
  long l;

  geng = toforallgeneratorgraph(n);
  bodyg = toforallbodygraph(n);
  l = largestinputportnumber(geng);
  if (l == 0)
    l = largestinputportnumber(n);
  if (p <= l) {   /* Multiple generated in generator graph */
    gatherup(getinputedge(geng, LINK->pp), LINK->LINK);
    gatherdown(getoutputedge(bodyg, LINK->pp), LINK->LINK);
  } else  /* value generated in body graph */
    gatherup(getinputedge(bodyg, LINK->pp), LINK->LINK);
}  /* AtForallReturns */

Local Void attestorret(n, g, p, LINK)
node *n, *g;
long p;
struct LOC_moveup *LINK;
{
  /* At the top of the Returns or Test graph of a while loop */
  node *initg, *testg, *bodyg, *retg;

  initg = toinitgraph(n);
  testg = totestgraph(n);
  bodyg = tobodygraph(n);
  retg = toreturnsgraph(n);
  gatherup(getinputedge(initg, p), LINK->LINK);
  gatherup(getinputedge(bodyg, p), LINK->LINK);
  if (g == testg)
    gatherdown(getoutputedge(retg, p), LINK->LINK);
  else
    gatherdown(getoutputedge(testg, p), LINK->LINK);
}  /* AtTestOrRet */

Local Void atloopatest(n, testg, p, LINK)
node *n, *testg;
long p;
struct LOC_moveup *LINK;
{
  node *initg, *bodyg, *retg;
  long l;

  initg = toinitgraph(n);
  bodyg = tobodygraph(n);
  retg = toreturnsgraph(n);
  gatherup(getinputedge(bodyg, p), LINK->LINK);
  l = largestinputportnumber(initg);
  if (l == 0)
    l = largestinputportnumber(n);
  if (p <= l) {   /* is a loop value */
    gatherup(getinputedge(initg, p), LINK->LINK);
    gatherdown(getoutputedge(retg, p), LINK->LINK);
  }
}  /* AtLoopATest */

Local Void moveup(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /*( E : EGPtr)*/
  /* Pre:  E has already been marked and saved on the stack.
     Action: The producer node of E (if it has one) is examined.
             If it is a simple node then no equivalent edges can be
               found above and no action is taken.
             If it is a compound node then we gather all edges equivalent
               to E within the subgraphs.
             If it is a graph node then the action is to examine what
               kind of graph node it is and gather equivalent edges
               in sibling subgraphs (if any).  */
  struct LOC_moveup V;
  long k, gnum, lastgraph;
  node *n, *pn, *subg;
  ifgraphtype gkind;
  long FORLIM;

  /* ---------------------------------------------------------- */

  V.LINK = LINK;
  if (e->ptsort != ptedge) {
    return;
  }  /* (^.PTSort = PTEdge) */
  pn = producernodeofedge(e);
  V.pp = producerportnumber(e);
  if (pn->ndsort == ndatomic)  /* do nothing */
    return;
  if (pn->ndsort == ndcompound) {
    switch (pn->ndcode) {

    case ifnselect:
      FORLIM = numbofsubgraphs(pn);
      for (gnum = 1; gnum < FORLIM; gnum++) {
	subg = tochildgraph(pn, gnum);
	gatherup(getinputedge(subg, V.pp), LINK);
      }
      break;
      /* Select */

    case ifnifthenelse:
      lastgraph = numbofsubgraphs(pn) - 1;
      for (gnum = 0; gnum <= lastgraph; gnum++) {
	if (gnum == lastgraph || (gnum & 1) == 0)
	{  /* only move up into true and false branches */
	  subg = tochildgraph(pn, gnum);
	  gatherup(getinputedge(subg, V.pp), LINK);
	}
      }
      break;
      /* IfThenElse */

    case ifntagcase:
      FORLIM = numbofsubgraphs(pn);
      for (gnum = 0; gnum < FORLIM; gnum++) {
	subg = tochildgraph(pn, gnum);
	gatherup(getinputedge(subg, V.pp), LINK);
      }
      break;
      /* Tagcase */

    case ifnforall:
      subg = toforallreturnsgraph(pn);
      gatherup(getinputedge(subg, V.pp), LINK);
      break;
      /* IFNForall */

    case ifnloopb:
    case ifnloopa:
      subg = toreturnsgraph(pn);
      gatherup(getinputedge(subg, V.pp), LINK);
      break;
      /* IFNLoopB, IFNLoopA */

    case ifniter:
      subg = toiterbodygraph(pn);
      gatherup(getinputedge(subg, V.pp), LINK);
      break;
    }/* case ^.NDCode */
    return;
  }  /* (^.NDSort = NDCompound) */
  gkind = graphkind(pn);
  if (gkind == ifgfunction)
    return;
  n = toenclosingcompound(pn);
  k = largestinputportnumber(n);
  if (V.pp <= k) {   /* at a constant port of the compound node */
    if (V.pp != 1 || gkind != ifgvariant)   /* do nothing */
      atconstantport(n, pn, V.pp, &V);
    return;
  }
  switch (gkind) {

  case ifgforallbody:
    gatherup(getinputedge(toforallgeneratorgraph(n), V.pp), LINK);
    gatherdown(getoutputedge(toforallreturnsgraph(n), V.pp), LINK);
    break;
    /* Forall Body */

  case ifgforallreturns:
    atforallreturns(n, pn, V.pp, &V);
    break;

  case ifgloopareturns:
  case ifgloopbtest:
  case ifgloopbreturns:
    attestorret(n, pn, V.pp, &V);
    break;

  case ifgloopabody:
  case ifgloopbbody:
  case ifgiterbody:   /* do nothing */
    break;

  case ifgloopatest:
    atloopatest(n, pn, V.pp, &V);
    break;
  }/* case */

  /* (PN ^.NDSort = NDGraph) */
  /* at a Loop value or temporary port of a loop node */
  /* (^.NDSort = NDGraph) */
}  /* MoveUp */

/* Local variables for movedown: */
struct LOC_movedown {
  struct LOC_asgnar *LINK;
} ;

/* --------------------------------------------------------------- */
Local Void atalternative(n, g, p, LINK)
node *n, *g;
long p;
struct LOC_movedown *LINK;
{
  /* Handles Select Alternative graphs and Tagcase Variant graphs */
  long gnum;
  node *subg;
  long FORLIM;

  FORLIM = numbofsubgraphs(n);
  for (gnum = 0; gnum < FORLIM; gnum++) {
    subg = tochildgraph(n, gnum);
    if ((subg != g) & (graphkind(subg) != ifgselector))
      gatherup(getinputedge(subg, p), LINK->LINK);
  }  /* for */
  /* now walk output edges of N */
  gatherdown(getoutputedge(n, p), LINK->LINK);
}  /* AtAlternative */

/* --------------------------------------------------------------- */

Local Void attruefalsegraph(n, g, p, LINK)
node *n, *g;
long p;
struct LOC_movedown *LINK;
{
  /* Handles IfThenElse True and False branches */
  long lastgraph, gnum;
  node *subg;

  lastgraph = numbofsubgraphs(n) - 1;
  for (gnum = 0; gnum <= lastgraph; gnum++) {
    if (gnum == lastgraph || (gnum & 1) == 0) {
      subg = tochildgraph(n, gnum);
      if (subg != g)
	gatherup(getinputedge(subg, p), LINK->LINK);
    }  /* for */
  }
  /* now walk output edges of N */
  gatherdown(getoutputedge(n, p), LINK->LINK);
}  /* AtTrueFalseGraph */

Local Void movedown(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /*( E : EGPtr )*/
  /* Similar to MoveUp except that we examine the consumer node of E
     rather than the producer node. */
  struct LOC_movedown V;
  node *cn, *n, *subg;
  long l, cp, gnum;
  ifgraphtype gkind;
  long FORLIM;

  /* --------------------------------------------------------------- */

  V.LINK = LINK;
  cn = e->pttonode;
  cp = e->pttoport;
  if (cn->ndsort == ndatomic)  /* do nothing */
    return;
  if (cn->ndsort == ndcompound) {
    if (cp == 1 && cn->ndcode == ifntagcase || cn->ndcode == ifniter)
	  /* do nothing */
	    return;
    FORLIM = numbofsubgraphs(cn);
    for (gnum = 0; gnum < FORLIM; gnum++) {
      subg = tochildgraph(cn, gnum);
      gatherdown(getoutputedge(subg, cp), LINK);
    }
    return;
  }  /* (^.NDSort = NDCompound) */
  gkind = graphkind(cn);
  if (gkind != ifgfunction)
    n = toenclosingcompound(cn);
  switch (gkind) {

  case ifgfunction:
  case ifgselector:
  case ifgloopbtest:
  case ifgloopatest:
  case ifgifpredicate:
    break;
    /* Do Nothing */

  case ifgalternative:
  case ifgvariant:
    atalternative(n, cn, cp, &V);
    break;

  case ifgiftrue:
  case ifgiffalse:
    attruefalsegraph(n, cn, cp, &V);
    break;

  case ifgforallgenerator:
    gatherdown(getoutputedge(toforallbodygraph(n), cp), LINK);
    gatherdown(getoutputedge(toforallreturnsgraph(n), cp), LINK);
    break;
    /* ForallGenerator */

  case ifgforallbody:
    gatherdown(getoutputedge(toforallreturnsgraph(n), cp), LINK);
    break;

  case ifgforallreturns:
  case ifgloopbreturns:
  case ifgloopareturns:
    gatherdown(getoutputedge(n, cp), LINK);
    break;

  case ifgiterbody:
    gatherdown(getoutputedge(n, cp), LINK);
    break;

  case ifgloopainit:
  case ifgloopbinit:
    gatherdown(getoutputedge(totestgraph(n), cp), LINK);
    gatherup(getinputedge(tobodygraph(n), cp), LINK);
    gatherdown(getoutputedge(toreturnsgraph(n), cp), LINK);
    break;
    /* LoopB Init */

  case ifgloopbbody:
    gatherup(getinputedge(toinitgraph(n), cp), LINK);
    gatherdown(getoutputedge(totestgraph(n), cp), LINK);
    gatherdown(getoutputedge(toreturnsgraph(n), cp), LINK);
    break;
    /* LoopB Body */

  case ifgloopabody:
    subg = toinitgraph(n);
    gatherdown(getoutputedge(totestgraph(n), cp), LINK);
    l = largestinputportnumber(subg);
    if (l == 0)
      l = largestinputportnumber(n);
    if (cp <= l) {   /* Loop value */
      gatherup(getinputedge(subg, cp), LINK);   /* the Init graph */
      gatherdown(getoutputedge(toreturnsgraph(n), cp), LINK);
    }
    break;
    /* LoopA Body */
  }/* case */

  /* (CN ^.NDSort = NDGraph) */
  /* (^.NDSort = NDGraph) */
}  /* MoveDown */

/* Local variables for offsetgraph: */
struct LOC_offsetgraph {
  struct LOC_asgnar *LINK;
} ;

Local Void assignoffset(e, addr, LINK)
port *e;
long addr;
struct LOC_offsetgraph *LINK;
{
  e->ptdfaddr = addr;
}  /* AssignOffset */

Local long sizeofedge(e, LINK)
port *e;
struct LOC_offsetgraph *LINK;
{
  long s;
  node *pn;

  s = 1;
  if (e->ptsort != ptedge)
    return s;
  pn = producernodeofedge(e);
  if (P_inset((int)pn->ndcode, LINK->LINK->specialsizenodes))
    s *= 2;
  return s;
}  /* SizeOfEdge */

Local Void offsetgraph(g, offset, LINK)
node *g;
long *offset;
struct LOC_asgnar *LINK;
{
  /* The input edges of each node of G (including G itself) are
     walked.  For each edge, all equivalent nodes are gathered and
     stored in the edge stack.  Each edge in the stack is assigned
     the same offset and its size requirements are computed.  Finally,
     the running offset variable is incremented by the maximum of
     the edge sizes. */
  struct LOC_offsetgraph V;
  node *n;
  long startport, p, size, maxsize, gnum;
  port *ie, *e;
  long FORLIM;

  V.LINK = LINK;
  n = g;
  while (n != NULL) {
    /* process input edges of N */
    if (P_inset((int)n->ndcode, LINK->specialnodes))
      startport = 2;
    else
      startport = 1;
    FORLIM = largestinputportnumber(n);
    for (p = startport; p <= FORLIM; p++) {
      ie = getinputedge(n, p);
      if (ie != NULL) {
	if (notmarked(ie, LINK)) {
	  clearstack(LINK);
	  gatherdown(ie, LINK);
	  moveup(ie, LINK);
	  /* now the stack contains all edges equivalent to IE */
	  maxsize = 0;
	  e = pop(LINK);
	  while (e != NULL) {
	    assignoffset(e, *offset, &V);
	    size = sizeofedge(e, &V);
	    if (size > maxsize)
	      maxsize = size;
	    e = pop(LINK);
	  }
	  *offset += maxsize;
	}  /* NotMarked */
      }
    }  /* for */
    if (n->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(n);
      for (gnum = 0; gnum < FORLIM; gnum++)
	offsetgraph(tochildgraph(n, gnum), offset, LINK);
    }
    n = n->ndnext;
  }
}  /* OffsetGraph */





Static boolean asgnar()
{

  /*-------------------------------------------------------------------*/
  /* The LLNL IF1 interpreter executes function graphs that have been  */
  /* translated from SISAL to IF1.  Since several activations of a     */
  /* particular function may be in existence at one time the           */
  /* interpreter keeps a seperate data space or activation record (AR) */
  /* for each function instantiation.  Each edge and literal within    */
  /* a function graph must then be assigned an offset within an AR     */
  /* where its value will be stored.  IF1Offset is the program that    */
  /* assigns these offsets.  This program works in three passes of     */
  /* each function graph, the passes are:      */
  /*  (I) Insertion of NoOp nodes are certain places.  This insures    */
  /*      the functional semantics of IF1.  See the doccumentation     */
  /*      for a complete description.      */
  /*  (II) Initialization of offsets.  Each edge and literal of each   */
  /*       function graph is assigned an initial offset of -1.  This   */
  /*       indicates that the true offset (a positive integer) has not */
  /*       yet been assigned.      */
  /*  (III) Assignment of offsets.  For each previously unmarked arc   */
  /*        of the graph (edge or literal with an offset of -1) we     */
  /*        perform several steps: (1) gather all equivalent arcs,     */
  /*        (2) assign each the current offset, and (3) compute the    */
  /*        AR space requirement for each edge and increment the       */
  /*        running offset by the maximum of these sizes.              */
  /* NOTE:  The offset assigned to each edge and literal is stored as  */
  /*        the %of pragma.  The size of an activation record required */
  /*        by a function graph is stored as the %ar pragma.           */
  /*-------------------------------------------------------------------*/
  struct LOC_asgnar V;
  stryng offsetstamp;
  long offset;
  node *func;

  /* ----------------------------------------------------------------- */

  if (stampismissing('C')) {
    printf("Error: Not all files have been Structure Checked\n");
    return false;
  } else {
    /* These are the old special size nodes (pre 9/26/85)
          SpecialSizeNodes := [ IFNAGather, IFNReduce, IFNRedLeft, IFNRedRight,
                                IFNRedTree, IFNFirstValue, IFNFinalValue,
                                IFNAllButLastValue ];
    */
    P_addset(P_expset(V.specialsizenodes, 0L), ifnallbutlastvalue);
    P_addset(P_expset(V.specialnodes, 0L), ifncall);
    P_addset(V.specialnodes, ifnspawn);
    P_addset(V.specialnodes, ifnreduce);
    P_addset(V.specialnodes, ifnredleft);
    P_addset(V.specialnodes, ifnredright);
    P_addset(V.specialnodes, ifnredtree);

    func = firstfunction;
    while (func != NULL) {
      addnoops(func, &V);
      initoffsets(func, &V);
      offset = 1;
      initstack(&V);
      offsetgraph(func, &offset, &V);
      func->UU.U1.ndlink->lkarsize = offset - 1;
      func = tonextfunction(func);
    }
    string20(&offsetstamp, " Offsets Assigned   ");
    addstamp('O', offsetstamp);
    return true;
  }


}  /* AssAR */

#undef stacksize
#undef ident


typedef struct trec {
  node *node_;
  struct trec *next;
} trec;


/* Local variables for removegraphcse: */
struct LOC_removegraphcse {
  trec *table[ifmaxnode - firstatom + 1];
} ;


Local boolean nodesareequivalent(n1, n2, LINK)
node *n1, *n2;
struct LOC_removegraphcse *LINK;
{
  /* Pre:  (N1^.NDSort = NDAtomic) and (N2^.NDSort = NDAtomic) and OpCode(N1) = OpCode(N2)
     Post: NodesAreEquivalent := (Input edges of N1 and N2 are equivalent)
                     AND (corresponding output edges have the same types )
   */
  port *e1, *e2;
  stryng lit1, lit2;
  boolean sametypes, same;
  long port_, maxport;

  maxport = largestinputportnumber(n1);
  same = (maxport == largestinputportnumber(n2));
  port_ = 1;
  while (same && port_ <= maxport) {
    e1 = getinputedge(n1, port_);
    e2 = getinputedge(n2, port_);
    /* Check that the edges are equivalent */
    if (e1 != NULL || e2 != NULL) {
      if (e1 != NULL && e2 != NULL) {
	/* Both edges are not nil, check that they are equivalent */
	if (e1->ptsort == ptlit && e2->ptsort == ptlit) {
	  lit1 = e1->UU.ptlitvalue;
	  lit2 = e2->UU.ptlitvalue;
	  same = (e1->pttype == e2->pttype) & equalstrings(&lit1, &lit2);
	} else if (e1->ptsort == ptedge && e2->ptsort == ptedge)
	  same = (producernodeofedge(e1) == producernodeofedge(e2)) &
		 (producerportnumber(e1) == producerportnumber(e2));
	else
	  same = false;
      } else  /* One edge is nil and the other is not */
	same = false;
    }
    /* do nothing, go on to the next port */
    port_++;
  }  /* while same ... */

  if (same) {
    /* The inputs of the two nodes are identical, now we must
       check that the corresponding types of the output edges
       are the same */
    sametypes = true;
    port_ = largestoutputportnumber(n1);
    maxport = largestoutputportnumber(n2);
    if (port_ > maxport)
      maxport = port_;
    port_ = 1;
    while (port_ <= maxport && sametypes) {
      e1 = getoutputedge(n1, port_);
      e2 = getoutputedge(n2, port_);
      if (e1 != NULL && e2 != NULL)
	sametypes = (e1->pttype == e2->pttype);
      port_++;
    }
    return sametypes;
  } else
    return false;

  /* one is an edge and the other is a literal */
}  /* NodesAreEquivalent */

Local Void inittable(LINK)
struct LOC_removegraphcse *LINK;
{
  /* Think of the Table as a collection of sets, one for each
     simple opcode.  InitTable initiallizes all these sets to
     be empty.
   */
  unsigned char index;

  for (index = firstatom; index <= ifmaxnode; index++)
    LINK->table[index - firstatom] = NULL;
}  /* InitTable */

Local Void addtotable(key, n, LINK)
unsigned char key;
node *n;
struct LOC_removegraphcse *LINK;
{
  /* Add node N to the set identified by Key */
  trec *t;

  t = (trec *)Malloc(sizeof(trec));
  t->node_ = n;
  t->next = LINK->table[key - firstatom];
  LINK->table[key - firstatom] = t;
}  /* AddToTable */

Local node *getequivnode(opcode, n, LINK)
unsigned char opcode;
node *n;
struct LOC_removegraphcse *LINK;
{
  /* Search the table for a node with the given OpCode and
     Matches N's input edges
     Return this equivalent node if one exists otherwise return nil.
   */
  boolean found;
  trec *t;
  node *checknode;

  found = false;
  t = LINK->table[opcode - firstatom];
  while (!found && t != NULL) {
    checknode = t->node_;
    if (nodesareequivalent(checknode, n, LINK))
      found = true;
    else
      t = t->next;
  }
  if (found)
    return checknode;
  else
    return NULL;
}  /* GetEquivNode */

Local Void movealloutputedges(fromnode, tonode, LINK)
node *fromnode, *tonode;
struct LOC_removegraphcse *LINK;
{
  /* move all the output edges of FromNode to corresponding
     output edges of ToNode.
     NOTE:  ChangeEdgeSrc( E, .. ) changes the "environment"
            of E and so we must save E in temp, then advance E
            and finally modify temp
   */
  port *e, *temp;
  long port_;

  e = fromnode->ndolist;
  while (e != NULL) {
    temp = e;
    e = e->UU.U1.ptfrnext;
    port_ = producerportnumber(temp);
    changeedgesrc(temp, tonode, port_);
  }
}  /* MoveAllOutputEdges */

Local Void moveoutputedges(n, fromport, toport)
node *n;
long fromport, toport;
{
  /* detach the output edges from port 'fromport' and reattach
     then to port 'toport'
   */
  port *e, *tmpe;

  e = getoutputedge(n, fromport);
  while (e != NULL) {
    /* NOTE: we must move off the edge we are moving
            BEFORE we move it! */
    tmpe = e;
    e = nextoutputedgesameport(e);
    changeedgesrc(tmpe, n, toport);
  }
}  /* MoveOutputEdges */

Local Void pushfanoutout(n, LINK)
node *n;
struct LOC_removegraphcse *LINK;
{
  /* If fanout was created from nodes inside the returns
     graph to the boundry of that edge, we wnat to push the
     fanout out of the subgraph and into the outside scope */
  /* The assumptions are:
     (1) N is a loop node (Forall, LoopA or LoopB)
     (2) cse has been run on it
  */
  node *retg, *srcnode, *cn;
  stryng litvalue, name;
  long litport, eport, srcport, removeport, cp;
  port *e, *lite, *ne, *srce, *removee;

  if (n->ndcode == ifnforall)
    retg = toforallreturnsgraph(n);
  else
    retg = toreturnsgraph(n);
  e = retg->ndilist;
  while (e != NULL) {
    if (e->ptsort == ptlit) {
      /* Push this Literal edge out of the returns
         graph and into the graph containing the
         compound node
       */
      lite = e;
      e = e->pttonext;
      litport = lite->pttoport;
      litvalue = lite->UU.ptlitvalue;
      ne = getoutputedge(n, litport);
      while (ne != NULL) {
	srce = ne;
	ne = nextoutputedgesameport(ne);
	cn = srce->pttonode;
	cp = srce->pttoport;
	name = srce->ptname;
	disconnectedgefromdest(srce);
	disconnectedgefromsource(srce);
	srce = insertliteral(cn, cp, srce->pttype, litvalue, name);
	/*  ChangeEdgeToLiteral( SrcE, LitValue );*/
      }
      removeedge(&lite);
      shiftinputports(retg, litport, -1L);
      shiftoutputports(n, litport, -1L);
      continue;
    }
    /* Replace fanout within the returns graph with fanout
       on the surrounding compound node.
       In this algorithm, all activity takes place to the RIGHT
       of edge E.  Edge E itself is never removed.
     */
    eport = e->pttoport;
    srcnode = producernodeofedge(e);
    srcport = producerportnumber(e);
    srce = getoutputedge(srcnode, srcport);
    while (srce != NULL) {
      if (srce == e || srce->pttonode != retg) {
	srce = nextoutputedgesameport(srce);
	continue;
      }
      removee = srce;
      srce = nextoutputedgesameport(srce);
      removeport = removee->pttoport;
      moveoutputedges(n, removeport, eport);
      removeedge(&removee);
      shiftinputports(retg, removeport, -1L);
      shiftoutputports(n, removeport, -1L);
    }
    e = e->pttonext;
  }
}  /* PushFanoutOut */




Static long removegraphcse(g, recurse)
node *g;
boolean recurse;
{

  /* Search this graph removing all common subexpressions involving
     simple nodes.
     NOTE:  Will not equate equivalent compound nodes.
            This can be done by checking for:
                1) Equivalent Opcodes
                2) Equivalent inputs
                3) Equivalent subgraphs.  We can assume subgraphs
                   have common subexpressions already merged and
                   hence all surviving nodes are in fact unique.
                   Walk the two graphs in the given order and
                   check that corresponding nodes are equivalent.
                   This will only find IDENTICAL graphs and not
                   equivalent graphs.  Finding EQUIVALENT graphs
                   is a bit more complicated.  It involves constructing
                   parallel lists, one for each opcode in each graph.
                   With each list, pull one node off a list at a time
                   and pair it with an equivalent node from its
                   parallel list.  The two subgraphs are equivalent
                   if the operation terminates normally.
     NOTE:  Will not equate node with identical but reversed
            inputs on a commutative operation node.
            The only commutative nodes are:  Plus, Times, Min, Max,
                Equal, NotEqual.
     NOTE:  Common subexpressions are not moved across graph boundaries.
   */
  struct LOC_removegraphcse V;
  node *tmpn, *eqnode, *n;
  boolean remove;
  long count, subgr;
  unsigned char opcode;
  long FORLIM;

  count = 0;
  inittable(&V);   /* Initialize all sets to be empty */
  n = g->ndnext;
  while (n != NULL) {   /* Walk the graph */
    remove = false;
    if (n->ndsort == ndatomic) {
      opcode = n->ndcode;
      eqnode = getequivnode(opcode, n, &V);
      if (eqnode == NULL) {
	/* No equivalent nodes found, add it to the set */
	addtotable(opcode, n, &V);
      } else {
	count++;
	/* An equivalent node was found, flag this one to be removed */
	remove = true;
      }
    } else {  /* Recursively walk subgraphs of compound node */
      if (recurse) {
	FORLIM = numbofsubgraphs(n);
	for (subgr = 0; subgr < FORLIM; subgr++)
	  count += removegraphcse(tochildgraph(n, subgr), recurse);
      }
      if ((unsigned long)n->ndcode < 32 &&
	  ((1L << n->ndcode) &
	   ((1L << ifnforall) | (1L << ifnloopb) | (1L << ifnloopa))) != 0)
	pushfanoutout(n, &V);
    }
    tmpn = n;
    n = n->ndnext;
    if (remove) {
      movealloutputedges(tmpn, eqnode, &V);
      /* Note, RemoveNode also removes all remaining input
              and output edges */
      removenode(tmpn);
    }
  }  /* while */
  return count;
}  /* RemoveGraphCSE */


Static boolean csemodule(module, verbose)
node *module;
boolean verbose;
{

  /* returns true iff the operation was successful */
  boolean Result;
  long count, funnum;
  node *fungraph;
  stryng csestring, funname;
  long FORLIM;
  FILE *TEMP1;

  /* Check Stamps Here */
  if (stampismissing('C')) {
    printf("ERROR: Not all input files have been Structure Checked\n");
    return false;
  }
  if (stampismissing('D')) {
    printf("ERROR: Not all input files have been Data Flow Ordered\n");
    return false;
  }
  FORLIM = numbofsubgraphs(module);
  for (funnum = 0; funnum < FORLIM; funnum++) {
    fungraph = tochildgraph(module, funnum);
    count = removegraphcse(fungraph, true);
    if (verbose) {
      funname = fungraph->UU.U1.ndlink->lkname;
      printf("In function ");
      TEMP1 = stdout;
/* p2c: nl.p, line 11270:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
      writestring(&TEMP1, &funname);
      printf(", CSE removed %ld simple nodes.\n", count);
    }
  }
  Result = true;
  /* Add Stamps Here */
  string20(&csestring, " Common Subs Removed");
  addstamp('E', csestring);
  removestamp('O');
  return Result;
}  /* CSEModule */


typedef struct ndptrelmlist {
  node *elem;
  struct ndptrelmlist *next;   /*NDPtrelmlist*/
} ndptrelmlist;

typedef struct ndptrreclist {
  long length;
  ndptrelmlist *listhd, *listtl;
} ndptrreclist;


Local ndptrreclist *ndptrnewlist()
{
  ndptrreclist *templis;

  templis = (ndptrreclist *)Malloc(sizeof(ndptrreclist));
  templis->length = 0;
  templis->listhd = NULL;
  templis->listtl = NULL;
  return templis;
}

Local boolean ndptrisnull(lisptr)
ndptrreclist *lisptr;
{
  return (lisptr->length == 0);
}

Local node *ndptrrmhead(lisptr)
ndptrreclist *lisptr;
{
  node *Result;

  if (lisptr->listhd == NULL)
    return NULL;
  Result = lisptr->listhd->elem;
  lisptr->length--;
  if (lisptr->listhd == lisptr->listtl) {
    lisptr->listhd = NULL;
    lisptr->listtl = NULL;
  } else
    lisptr->listhd = lisptr->listhd->next;
  return Result;
}

Local long ndptrlength(lisptr)
ndptrreclist *lisptr;
{
  return (lisptr->length);
}

Local ndptrreclist *ndptrappend(lisptr, element)
ndptrreclist *lisptr;
node *element;
{
  ndptrelmlist *elmptr;

  elmptr = (ndptrelmlist *)Malloc(sizeof(ndptrelmlist));
  elmptr->elem = element;
  elmptr->next = NULL;
  if (lisptr->length == 0)
    lisptr->listhd = elmptr;
  else
    lisptr->listtl->next = elmptr;
  lisptr->listtl = elmptr;
  lisptr->length++;
  return lisptr;
}

Local Void imposegraphordering(neworder, g)
ndptrreclist *neworder;
node *g;
{

  /* ImposeGraphOrdering*/
  /*   Rearrange the links on the nodes in G to reflect the*/
  /*   ordering given in NewOrder*/
  /* Precondition:  length( NewOrder ) = length( G )   */
  /* written 84/3/8 by sks*/
  /* modified 85/1/13 by mlw*/
  long newlabel;
  node *thisnode, *previousnode;

  /* ImposeGraphOrdering */
  newlabel = 0;
  previousnode = g;
  while (!ndptrisnull(neworder)) {
    thisnode = ndptrrmhead(neworder);
    newlabel++;
    thisnode->ndlabel = newlabel;
    previousnode->ndnext = thisnode;
    previousnode = thisnode;
  }
  previousnode->ndnext = NULL;
}

Local long numancestors(n)
node *n;
{

  /* NumAncestors*/
  /*   Return the number of direct ancestor nodes*/
  /* written 84/9/11 by sks*/
  port *e;
  long result;
  node *prodn;

  /* NumAncestors */
  result = 0;
  e = n->nddepilist;
  if (e == NULL)
    e = n->ndilist;
  while (e != NULL) {
    if (e->ptsort != ptlit) {
      prodn = producernodeofedge(e);
      if (prodn->ndsort != ndgraph)
	result++;
    }
    e = e->pttonext;
  }
  return result;
}

/* Store the reference count of a node in the Misc field of the node */
Local Void setrefcount(n, count)
node *n;
long count;
{
  n->ndmisc.numb = count;
}  /* SetRefCount */

Local long refcount(n)
node *n;
{
  return (n->ndmisc.numb);
}  /* RefCount */

Local boolean dfordergraph(g)
node *g;
{

  /* DFOrderGraph*/
  /*   Rearrange nodes in a graph so that if node A depends*/
  /*   on outputs of node B, A will follow B*/
  /* written 84/2/22 by sks*/
  /* changed 84/9/11 by sks to use linear time algorithm*/
  /* modified 85/1/13 by mlw to check for cycles in graph*/
  /* modified 86/2/24 by mlw: Changed to a function to return a    */
  /*   status code (true if it worked ok, false if a problem).     */
  /*   Also, changed for seperate compilation of */
  ndptrreclist *newordering, *scheduled;
  long i, neworderlength, graphlength;
  node *n, *current, *consumer;
  boolean noerror;
  port *e;
  long FORLIM;

  /*DFOrderGraph*/
  noerror = true;
  if (g->ndnext == NULL) {
    return noerror;
  }  /* not an empty graph */

  scheduled = ndptrnewlist();
  newordering = ndptrnewlist();

  /* Set the reference count for each node to be the number*/
  /* of ancestors.  If none, place node on 'scheduled' list*/
  /* if we see a compound node, schedule within it now!*/

  current = g->ndnext;
  while (current != NULL) {
    if (current->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(current);
      for (i = 0; i < FORLIM; i++)
	noerror &= dfordergraph(tochildgraph(current, i));
    }

    setrefcount(current, numancestors(current));
    if (refcount(current) == 0)
      scheduled = ndptrappend(scheduled, current);
    current = current->ndnext;
  }

  /* Decrement reference counts of direct descendants of each node*/
  /* that has been scheduled.  When reference count reaches zero,*/
  /* move a node to the scheduled list.*/

  current = ndptrrmhead(scheduled);
  while (current != NULL) {
    newordering = ndptrappend(newordering, current);
    e = current->nddepolist;
    if (e == NULL)
      e = current->ndolist;
    while (e != NULL) {
      consumer = e->pttonode;
      if (consumer->ndsort != ndgraph) {
	setrefcount(consumer, refcount(consumer) - 1);
	if (refcount(consumer) == 0)
	  scheduled = ndptrappend(scheduled, consumer);
      }
      e = e->UU.U1.ptfrnext;
    }
    current = ndptrrmhead(scheduled);
  }

  neworderlength = ndptrlength(newordering);
  graphlength = numbnodesingraph(g);
  if (neworderlength < graphlength) {
    noerror = false;
    printf("ERROR: Not all graph nodes scheduled\n");
    printf("  ---  Check for cycles in graph\n");
    printf("  ---  Here is a list of unscheduled nodes:\n");
    n = g->ndnext;
    while (n != NULL) {
      if (refcount(n) != 0)
	printf("  -----      %.16sID = %5ld    (Label = %ld)\n",
	       nodename[n->ndcode], n->ndid, n->ndlabel);
      n = n->ndnext;
    }
    return noerror;
  }
  if (neworderlength <= graphlength) {
    imposegraphordering(newordering, g);
    return noerror;
  }
  noerror = false;
  printf("ERROR: More nodes scheduled than in graph\n");
  printf("  ---  Some nodes may be scheduled twice.\n");
  return noerror;
}

/* Local variables for fixreturnsgraph: */
struct LOC_fixreturnsgraph {
  node *loop, *geng, *bodyg, *retg, *initg, *testg, *loopparent;
  long k, l, t, port_;
  port *e;
  boolean isforall;
} ;

Local boolean allconstantinputs(n, LINK)
node *n;
struct LOC_fixreturnsgraph *LINK;
{
  /* Returns true if all inputs of N are either literals or come from
     K ports.
     -- N is a node in the returns graph of Loop which does not
        depend on any other node in that graph.
   */
  boolean constant;
  port *e;

  /* K : integer   -- Imported from outer scope */
  constant = true;
  e = n->ndilist;
  while (constant && e != NULL) {
    if (e->ptsort == ptedge) {
      if (producerportnumber(e) > LINK->k)
	constant = false;
    }
    e = e->pttonext;
  }
  return constant;
}  /* AllConstantInputs */

Local Void createnewkport(LINK)
struct LOC_fixreturnsgraph *LINK;
{
  /* Creates ONE new K port on the compound node Loop.
     -- Imports the following variables:
     -- IsForall : boolean;
     -- Loop, InitG, TestG, BodyG, RetG, GenG : NDPtr;
     -- var  K, L, T : integer
   */
  LINK->k++;
  LINK->l++;
  LINK->t++;
  if (LINK->isforall) {
    shiftinputports(LINK->geng, LINK->k, 1L);
    shiftoutputports(LINK->bodyg, LINK->k, 1L);
    shiftinputports(LINK->bodyg, LINK->k, 1L);
    shiftoutputports(LINK->retg, LINK->k, 1L);
    return;
  }
  shiftinputports(LINK->initg, LINK->k, 1L);
  shiftoutputports(LINK->bodyg, LINK->k, 1L);
  shiftinputports(LINK->bodyg, LINK->k, 1L);
  shiftoutputports(LINK->testg, LINK->k, 1L);
  shiftoutputports(LINK->retg, LINK->k, 1L);
}  /* CreateNewKPort */

Local Void createnewlport(LINK)
struct LOC_fixreturnsgraph *LINK;
{
  /* Creates ONE new L port on the compound node Loop.
     -- Imports the following variables:
     -- IsForall : boolean;
     -- Loop, InitG, TestG, BodyG, RetG, GenG : NDPtr;
     -- var  L, T : integer
   */
  LINK->l++;
  LINK->t++;
  if (LINK->isforall) {
    shiftinputports(LINK->bodyg, LINK->l, 1L);
    shiftoutputports(LINK->retg, LINK->l, 1L);
    return;
  }
  shiftinputports(LINK->bodyg, LINK->l, 1L);
  shiftoutputports(LINK->testg, LINK->l, 1L);
  shiftoutputports(LINK->retg, LINK->l, 1L);
}  /* CreateNewLPort */

Local Void insureedgeisnotconstant(n, p, LINK)
node *n;
long p;
struct LOC_fixreturnsgraph *LINK;
{
  /* The edge on input port P of node N is not supposed to be
     a literal or from a K port.  If it is, a new L or T port is
     added and this edge is redirected to that new port.
   */
  port *e, *newe;
  stryng ename;
  stentry *etype;
  long pp;
  node *pn;

  e = getinputedge(n, p);
  if (e == NULL) {
    return;
  }  /* E <> nil */
  memcpy(ename.str, blankstring, sizeof(stryngar));
  ename.len = 0;
  etype = e->pttype;
  if (etype->stsort == iftmultiple)
    etype = etype->UU.stbasetype;
  if (e->ptsort == ptlit) {
    if (LINK->isforall) {
      LINK->t++;
      changeedgedest(e, LINK->bodyg, LINK->t);
      newe = insertedge(LINK->retg, LINK->t, n, p, etype, ename);
      return;
    }
    createnewlport(LINK);
    changeedgedest(e, LINK->initg, LINK->l);
    newe = insertedge(LINK->bodyg, LINK->l, LINK->bodyg, LINK->l, etype,
		      ename);
    newe = insertedge(LINK->retg, LINK->l, n, p, etype, ename);
    return;
  }
  pn = producernodeofedge(e);
  pp = producerportnumber(e);
  if (pn != LINK->retg || pp > LINK->k)
    return;
  if (LINK->isforall) {  /* Should Come from a T port in the Body */
    LINK->t++;
    newe = insertedge(LINK->bodyg, pp, LINK->bodyg, LINK->t, etype, ename);
    changeedgesrc(e, LINK->retg, LINK->t);
    return;
  }
  createnewlport(LINK);
  newe = insertedge(LINK->initg, pp, LINK->initg, LINK->l, etype, ename);
  newe = insertedge(LINK->bodyg, LINK->l, LINK->bodyg, LINK->l, etype, ename);
  changeedgesrc(e, LINK->retg, LINK->l);

  /* E is an edge */
  /* Should come from an L port */
}  /* InsureEdgeIsNotConstant */

Local Void moveoutsideofloop(n, LINK)
node *n;
struct LOC_fixreturnsgraph *LINK;
{
  /* -- N is a node in the returns graph that is to be moved outside
       the loop.  Its inputs are either literals for edges directly from
       K ports.  A copy of the node is make outside and a new K port
       and edges are created for each wired output port of N
  */
  port *le, *e, *newe, *tmpe;
  node *newn, *pn;
  long pp, cp;
  stryng ename, litvalue;
  stentry *etype;
  long FORLIM;

  /* Imported from outside scope . . .
     var K : integer;
     LoopParent, Loop, RetG : NDPtr;
   */
  newn = copynode(n);
  insertnode(LINK->loopparent, toprevnode(LINK->loop), newn);
  /* Add input edges */
  e = n->ndilist;
  while (e != NULL) {
    cp = e->pttoport;
    if (e->ptsort == ptlit) {
      ename = e->ptname;
      litvalue = e->UU.ptlitvalue;
      etype = e->pttype;
      if (etype->stsort == iftmultiple)
	etype = etype->UU.stbasetype;
      newe = insertliteral(newn, cp, etype, litvalue, ename);
    } else {
      pp = producerportnumber(e);
      le = getinputedge(LINK->loop, pp);
      ename = le->ptname;
      etype = le->pttype;
      if (etype->stsort == iftmultiple)
	etype = etype->UU.stbasetype;
      if (le->ptsort == ptlit) {
	litvalue = le->UU.ptlitvalue;
	newe = insertliteral(newn, cp, etype, litvalue, ename);
      } else {
	pn = producernodeofedge(le);
	pp = producerportnumber(le);
	newe = insertedge(pn, pp, newn, cp, etype, ename);
      }
    }
    e = e->pttonext;
  }  /* Add input edges to NewN */
  FORLIM = largestoutputportnumber(n);
  /* Create a new K port for each used output port of node N */
  for (pp = 1; pp <= FORLIM; pp++) {
    e = getoutputedge(n, pp);
    if (e != NULL) {
      createnewkport(LINK);
      etype = e->pttype;
      if (etype->stsort == iftmultiple)
	etype = etype->UU.stbasetype;
      ename = e->ptname;
      newe = insertedge(newn, pp, LINK->loop, LINK->k, etype, ename);
      do {
	tmpe = e;
	e = nextoutputedgesameport(e);
	changeedgesrc(tmpe, LINK->retg, LINK->k);
      } while (e != NULL);
    }
  }
}  /* MoveOutsideOfLoop */

Local Void copynodetograph(n, g, startport, LINK)
node *n, *g;
long startport;
struct LOC_fixreturnsgraph *LINK;
{
  /* -- N is a node in the returns graph.
     -- All input edges of N are Literals or from K or L ports.
     -- Make a copy of N and install it as the last node in graph G.
     -- Graph ports, starting at number StartPort, have been allocated
        and reserved for the outputs of the copy of N.  These edges
        are installed here, but the output edges of node N itself
        are left unchanged.
   */
  node *prev, *newn, *pn;
  long pp, cp;
  port *ge, *e, *newe;
  stentry *etype;
  stryng ename, litvalue;
  long FORLIM;

  prev = tolastnodeingraph(g);
  newn = copynode(n);
  insertnode(g, prev, newn);
  /* Add input edges */
  e = n->ndilist;
  while (e != NULL) {
    cp = e->pttoport;
    etype = e->pttype;
    if (etype->stsort == iftmultiple)
      etype = etype->UU.stbasetype;
    ename = e->ptname;
    if (e->ptsort == ptlit) {
      litvalue = e->UU.ptlitvalue;
      newe = insertliteral(newn, cp, etype, litvalue, ename);
    } else {  /* E is an edge, trace it back to graph G */
      pp = producerportnumber(e);
      ge = getinputedge(g, pp);
      if (ge == NULL)   /* create one */
	newe = insertedge(g, pp, newn, cp, etype, ename);
      else if (ge->ptsort == ptedge) {
	pp = producerportnumber(ge);
	pn = producernodeofedge(ge);
	newe = insertedge(pn, pp, newn, cp, etype, ename);
      } else {
	litvalue = ge->UU.ptlitvalue;
	newe = insertliteral(newn, cp, etype, litvalue, ename);
      }
    }
    e = e->pttonext;
  }
  FORLIM = largestoutputportnumber(n);
  /* Add Output Edges, assume ports have already been created */
  for (LINK->port_ = 1; LINK->port_ <= FORLIM; LINK->port_++) {
    e = getoutputedge(n, LINK->port_);
    if (e != NULL) {
      ename = e->ptname;
      etype = e->pttype;
      if (etype->stsort == iftmultiple)
	etype = etype->UU.stbasetype;
      newe = insertedge(newn, LINK->port_, g, startport, etype, ename);
      startport++;
    }
  }

  /* GE is a literal edge */
}  /* CopyNodeToGraph */

Local Void movenodeafterloop(node_, fvnode, loop, LINK)
node *node_, *fvnode, *loop;
struct LOC_fixreturnsgraph *LINK;
{
  /* -- Node is a node in the returns graph.
     -- FVNode is the final value node that an input edge at port 1 which
        which comes from the above Node.
     -- Loop is the for loop we are working in.

     Make a copy of Node and place it below the loop.  Connect each of its
     input edges as follows:
       if the edge is a literal
         then just connect it
       else if it comes from a KPort in the returns graph
         then make a connection from the value outside the loop
       else
         create a Final Value node with in the returns graph
         connect the value that used to go into Node to port 1 of the
         Final Value node.  If FVNode has a masking value, connect it to
         the new Final Value node.  Create an edge from the Final Value to
         the returns subgraph.  Create an edge from the loop to the copied
         node outside the loop.

      Finally create an edge(s) from the output of the newly created node
      to where ever the output of FVNode used to go (this edge will come
      out of the loop node);*/
  node *newn, *newfv;
  port *nextedgetomove, *nexte, *newe, *tempe;
  stentry *etype;
  stryng valuestr, namestr;
  long eoldinputport;

  newn = copynode(node_);

  /* Place node after loop */

  insertnode(loop->ndparent, loop, newn);

  /* Connect input edges */

  LINK->e = node_->ndilist;

  while (LINK->e != NULL) {
    eoldinputport = LINK->e->pttoport;
    nextedgetomove = LINK->e->pttonext;
    if (LINK->e->pttype->stsort == iftmultiple)
      etype = LINK->e->pttype->UU.stbasetype;
    else
      etype = LINK->e->pttype;

    if (((producernodeofedge(LINK->e) == LINK->retg) &
	 (producerportnumber(LINK->e) <= LINK->k)) ||
	LINK->e->ptsort == ptlit)
    {  /*connect edge from outside of loop*/
      if (LINK->e->ptsort == ptlit) {
	valuestr = LINK->e->UU.ptlitvalue;
	namestr = LINK->e->ptname;
	newe = insertliteral(newn, LINK->e->pttoport, etype, valuestr,
			     namestr);
      } else {  /*else its coming from a K Port */
	tempe = getinputedge(loop, producerportnumber(LINK->e));
	namestr = tempe->ptname;
	if (tempe->ptsort == ptlit) {
	  valuestr = tempe->UU.ptlitvalue;
	  newe = insertliteral(newn, LINK->e->pttoport, etype, valuestr,
			       namestr);
	}  /*then*/
	else
	  newe = insertedge(producernodeofedge(tempe),
			    producerportnumber(tempe), newn,
			    LINK->e->pttoport, etype, namestr);
      }  /*else*/
    }  /*then*/
    else {  /* else input isn't a literal or imported into loop */
      newfv = createsimplenode((long)ifnfinalvalue);
      insertnode(LINK->retg, tolastnodeingraph(LINK->retg), newfv);
      changeedgedest(LINK->e, newfv, 1L);
      tempe = getinputedge(fvnode, 2L);
      namestr = LINK->e->ptname;
      if (tempe != NULL)   /*FV has a mask, must add it to newFV */
	tempe = insertedge(producernodeofedge(tempe),
			   producerportnumber(tempe), newfv, 2L,
			   tempe->pttype, namestr);

      /* Connect NewFV to RetG */

      tempe = insertedge(newfv, 1L, LINK->retg,
			 largestinputportnumber(LINK->retg) + 1, etype,
			 namestr);

      /* Connect output edge to NewN */

      memcpy(namestr.str, blankstring, sizeof(stryngar));
      namestr.len = 0;
      tempe = insertedge(loop, largestinputportnumber(LINK->retg), newn,
			 eoldinputport, etype, namestr);
    }  /*else*/

    LINK->e = nextedgetomove;
  }  /*while*/

  tempe = getoutputedge(fvnode, 1L);
  if (tempe == NULL)
    printf("Error in fix returns graph!\n");
  else {
    tempe = getoutputedge(loop, tempe->pttoport);
    while (tempe != NULL) {
      nexte = nextoutputedgesameport(tempe);
      changeedgesrc(tempe, newn, producerportnumber(getinputedge(fvnode, 1L)));
      tempe = nexte;
    }  /*while*/
  }  /*else*/

  /* chop off connection from Node to FVNode */

  tempe = getinputedge(fvnode, 1L);

  removeedge(&tempe);

}  /* MoveNodeAfterLoop */

Local Void removefinalvalue(n, loop, retg, LINK)
node *n, *loop, *retg;
struct LOC_fixreturnsgraph *LINK;
{
  long pp, foroutport;
  port *fvinedge, *fvoutedge, *foroutedge, *loopinedge, *newe, *tempe;
  boolean literal;
  stryng ename, eval;

  fvinedge = getinputedge(n, 1L);
  pp = producerportnumber(fvinedge);
  literal = (fvinedge->ptsort == ptlit);
  if (!literal)
    loopinedge = getinputedge(loop, pp);

  fvoutedge = n->ndolist;
  while (fvoutedge != NULL) {
    foroutport = fvoutedge->pttoport;
    foroutedge = getoutputedge(loop, foroutport);
    while (foroutedge != NULL) {
      if (literal) {
	ename = fvinedge->ptname;
	eval = fvinedge->UU.ptlitvalue;
	newe = insertliteral(foroutedge->pttonode, foroutedge->pttoport,
			     fvinedge->pttype, eval, ename);
      } else {
	ename = loopinedge->ptname;
	newe = insertedge(producernodeofedge(loopinedge),
			  producerportnumber(loopinedge),
			  foroutedge->pttonode, foroutedge->pttoport,
			  loopinedge->pttype, ename);
      }
      disconnectedgefromdest(foroutedge);
      tempe = foroutedge;
      foroutedge = nextoutputedgesameport(tempe);
      disconnectedgefromsource(tempe);
    }  /*while*/
    disconnectedgefromdest(fvoutedge);
    tempe = fvoutedge;
    fvoutedge = nextoutputedgesameport(tempe);
    disconnectedgefromsource(tempe);
  }  /*while*/
}  /*RemoveFinalValue*/

Local Void fixreturnsgraph(loop_)
node *loop_;
{
  /*  -- Loop is either a FORALL, LOOPA or LOOPB compound node.
      -- All the subgraphs of Loop must be complete and must have
         been ordered by data dependence.
      -- Loop is contained in a graph G that must be complete above this
         compound node (Parent pointers are set, Next fields are set,
         input edges of Loop are defined).
      This routine will walk the returns graph, transplanting nodes that
      really don't belong there to either the outer graph G or the other
      subgraphs.  After the walk:
      -- The returns graph will only contain nodes dealing with multiple
         values.
      -- The port numbers of the subgraphs may be dramatically altered
         but will be consistant with the new graph organization.
   */
  struct LOC_fixreturnsgraph V;
  node *n, *pn, *rn;
  long oports, startport, cse;
  port *tmpe;
  stentry *etype;
  boolean ok;
  long legalreturnsnodes[ifmaxnode / 32 + 2];
  long FORLIM;

  V.loop = loop_;
  P_addset(P_expset(legalreturnsnodes, 0L), ifnfirstvalue);
  P_addset(legalreturnsnodes, ifnfinalvalue);
  P_addset(legalreturnsnodes, ifnagather);
  P_addset(legalreturnsnodes, ifnallbutlastvalue);
  P_addset(legalreturnsnodes, ifnreduce);
  P_addset(legalreturnsnodes, ifnredleft);
  P_addset(legalreturnsnodes, ifnredright);
  P_addset(legalreturnsnodes, ifnredtree);
  P_addset(legalreturnsnodes, ifnagatherat);
  P_addset(legalreturnsnodes, ifnreduceat);
  P_addset(legalreturnsnodes, ifnfinalvalueat);
  V.loopparent = V.loop->ndparent;
  V.k = largestinputportnumber(V.loop);
  V.isforall = (V.loop->ndcode == ifnforall);
  if (V.isforall) {
    V.geng = toforallgeneratorgraph(V.loop);
    V.bodyg = toforallbodygraph(V.loop);
    V.retg = toforallreturnsgraph(V.loop);
    V.l = largestinputportnumber(V.geng);
    if (V.l == 0)
      V.l = V.k;
  } else {
    V.initg = toinitgraph(V.loop);
    V.testg = totestgraph(V.loop);
    V.bodyg = tobodygraph(V.loop);
    V.retg = toreturnsgraph(V.loop);
    V.l = largestinputportnumber(V.initg);
    if (V.l == 0)
      V.l = V.k;
  }
  V.t = largestinputportnumber(V.bodyg);
  if (V.t == 0)
    V.t = V.l;

  cse = removegraphcse(V.retg, false);
  rn = V.retg->ndnext;

  while (rn != NULL) {
    n = rn;

    if (n->ndcode == ifnfinalvalue) {
      V.e = getinputedge(n, 1L);
      if (V.e->ptsort != ptlit) {
	pn = producernodeofedge(V.e);
	tmpe = pn->ndolist;
	if (tmpe->UU.U1.ptfrnext == NULL && pn != V.retg &&
	    pn->ndcode != ifnallbutlastvalue)
	  movenodeafterloop(pn, n, V.loop, &V);
      }  /*then*/
    }  /*then*/
    rn = rn->ndnext;
  }  /*while*/

  cleanupgraph(V.loop->ndparent);

  if (V.loop->ndparent == NULL)
  {   /* make sure loop was not removed by CleanUpGraph*/
    return;
  }  /*then*/
  V.k = largestinputportnumber(V.loop);
  if (V.isforall) {
    V.l = largestinputportnumber(V.geng);
    if (V.l == 0)
      V.l = V.k;
  } else {
    V.l = largestinputportnumber(V.initg);
    if (V.l == 0)
      V.l = V.k;
  }

  V.t = largestinputportnumber(V.bodyg);
  if (V.t == 0)
    V.t = V.l;

  rn = V.retg->ndnext;
  while (rn != NULL) {
    n = rn;
    rn = rn->ndnext;
    if (P_inset((int)n->ndcode, legalreturnsnodes)) {
      switch (n->ndcode) {

      case ifnfinalvalue:
	pn = producernodeofedge(getinputedge(n, 1L));
	if (pn == NULL)
	  ok = true;
	else if (pn->ndsort == ndgraph)
	  ok = true;
	else
	  ok = false;
	if ((allconstantinputs(n, &V) & (getinputedge(n, 2L) == NULL)) && ok)
	  removefinalvalue(n, V.loop, V.retg, &V);
	else {
	  insureedgeisnotconstant(n, 1L, &V);
	  insureedgeisnotconstant(n, 2L, &V);
	}
	break;

      case ifnfirstvalue:
      case ifnallbutlastvalue:
      case ifnfinalvalueat:
	insureedgeisnotconstant(n, 1L, &V);
	insureedgeisnotconstant(n, 2L, &V);
	break;
	/* FirstValue */

      case ifnagather:
      case ifnagatherat:
	insureedgeisnotconstant(n, 2L, &V);
	insureedgeisnotconstant(n, 3L, &V);
	break;
	/* AGather */

      case ifnreduce:
      case ifnredleft:
      case ifnredright:
      case ifnredtree:
      case ifnreduceat:
	insureedgeisnotconstant(n, 3L, &V);
	insureedgeisnotconstant(n, 4L, &V);
	break;
	/* Reduce */
      }/* case */
      continue;
    }
    if (allconstantinputs(n, &V))
      moveoutsideofloop(n, &V);
    else {
      oports = numberofwiredoutputports(n);
      if (V.isforall) {
	/* Create ports for output edges of N */
	startport = V.t + 1;
	V.t += oports;
	copynodetograph(n, V.bodyg, startport, &V);
      } else {  /* Must be an iterative loop */
	/* Create ports for output edges of N */
	startport = V.l + 1;
	shiftoutputports(V.testg, startport, oports);
	shiftinputports(V.bodyg, startport, oports);
	V.l += oports;
	V.t += oports;
	copynodetograph(n, V.bodyg, startport, &V);
	copynodetograph(n, V.initg, startport, &V);
      }
      FORLIM = largestoutputportnumber(n);
      /* Move output ports of N to RetG */
      for (V.port_ = 1; V.port_ <= FORLIM; V.port_++) {
	V.e = getoutputedge(n, V.port_);
	if (V.e != NULL) {
	  do {
	    tmpe = V.e;
	    V.e = nextoutputedgesameport(V.e);
	    changeedgesrc(tmpe, V.retg, startport);
	  } while (V.e != NULL);
	  startport++;
	}
      }
    }
    removenode(n);
  }  /* while RN */
  compactports(V.loop);
  /* Make sure all L and T port edges in RetG are multiples */
  V.k = largestinputportnumber(V.loop);
  V.e = outputedgegeport(V.retg, V.k + 1);
  while (V.e != NULL) {
    etype = V.e->pttype;
    if (etype->stsort != iftmultiple && etype->stsort != iftbuffer) {
      etype = getconstructortype(iftmultiple, etype);
      V.e->pttype = etype;
    }
    V.e = V.e->UU.U1.ptfrnext;
  }
  /* Change the type of the output edges of AllButLastValue
     nodes to a Multiple */
  n = V.retg->ndnext;
  while (n != NULL) {
    if (n->ndcode == ifnallbutlastvalue) {
      V.e = n->ndolist;
      while (V.e != NULL) {
	etype = V.e->pttype;
	if (etype->stsort != iftmultiple) {
	  etype = getconstructortype(iftmultiple, etype);
	  V.e->pttype = etype;
	}
	V.e = V.e->UU.U1.ptfrnext;
      }
    }
    n = n->ndnext;
  }

  /* Must move N out of RetG */
  /* Move N out of RetG */
}  /* FixReturnsGraph */

Local Void findloopnodes(g)
node *g;
{
  node *n;
  long grnum, FORLIM;

  n = g->ndnext;
  while (n != NULL) {
    if (n->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(n);
      for (grnum = 0; grnum < FORLIM; grnum++)
	findloopnodes(tochildgraph(n, grnum));
      switch (n->ndcode) {

      case ifnforall:
      case ifnloopa:
      case ifnloopb:
	fixreturnsgraph(n);
	break;

      case ifnselect:
      case ifntagcase:
      case ifnifthenelse:
      case ifniter:
	/* blank case */
	break;
      }/* case */
    }
    n = n->ndnext;
  }
}  /* FindLoopNodes */




Static boolean dforder(module)
node *module;
{
  boolean Result;
  node *g;
  long i;
  stryng orderstring;
  boolean ok, noerror;
  long FORLIM;

  /* DFOrder */
  noerror = true;
  FORLIM = numbofsubgraphs(module);
  for (i = 0; i < FORLIM; i++) {
    g = tochildgraph(module, i);
    ok = dfordergraph(g);
    if (ok)
      findloopnodes(g);
    noerror = (noerror && ok);
  }  /* for */
  removedeadcode(false);
  Result = noerror;
  if (!noerror)
    return Result;
  string20(&orderstring, " Nodes are DFOrdered");
  addstamp('D', orderstring);
  /* Remove the offsetter stamp */
  removestamp('O');
  return Result;
}


typedef enum {
  valueof, arrayof, reduce, filter
} delaytype;


/* Local variables for copytestout: */
struct LOC_copytestout {
  node *newloop;
} ;

Local Void copytest(tonode, oldloop, toport, copyedge, LINK)
node *tonode, *oldloop;
long toport;
port *copyedge;
struct LOC_copytestout *LINK;
{
  node *newnode, *pn;
  stryng edgename, litvalue;
  long pp;
  port *tempedge, *outercopyedge;

  edgename = copyedge->ptname;
  if (copyedge->ptsort == ptlit) {
    litvalue = copyedge->UU.ptlitvalue;
    tempedge = insertliteral(tonode, toport, copyedge->pttype, litvalue,
			     edgename);
    return;
  }
  pn = producernodeofedge(copyedge);
  pp = producerportnumber(copyedge);
  if (pn->ndsort == ndgraph) {
    outercopyedge = getinputedge(LINK->newloop, pp + 1);
    edgename = outercopyedge->ptname;
    if (outercopyedge->ptsort == ptlit) {
      litvalue = outercopyedge->UU.ptlitvalue;
      tempedge = insertliteral(tonode, toport, copyedge->pttype, litvalue,
			       edgename);
      return;
    }
    pn = producernodeofedge(outercopyedge);
    pp = producerportnumber(outercopyedge);
    tempedge = insertedge(pn, pp, tonode, toport, copyedge->pttype, edgename);
    return;
  }  /*then*/
  newnode = copynode(pn);
  insertnode(tonode->ndparent, tonode, newnode);
  tempedge = insertedge(newnode, pp, tonode, toport, copyedge->pttype,
			edgename);
  tempedge = pn->ndilist;
  while (tempedge != NULL) {
    copytest(newnode, oldloop, tempedge->pttoport, tempedge, LINK);
    tempedge = tempedge->pttonext;
  }  /*while*/

  /*else*/
  /*else*/
}  /*CopyTest*/

Local Void copytestout(newloop_, oldloop)
node *newloop_, *oldloop;
{
  struct LOC_copytestout V;
  node *oldtest;
  port *edge;

  V.newloop = newloop_;
  oldtest = totestgraph(oldloop);
  edge = getinputedge(oldtest, 1L);
  copytest(V.newloop, oldloop, 1L, edge, &V);
}

Local Void copytest_(tonode, oldloop, newbody, parent, toport, copyedge)
node *tonode, *oldloop, *newbody, *parent;
long toport;
port *copyedge;
{
  node *newnode, *pn;
  stryng edgename, litvalue;
  long pp;
  port *tempedge;

  edgename = copyedge->ptname;
  if (copyedge->ptsort == ptlit) {
    litvalue = copyedge->UU.ptlitvalue;
    tempedge = insertliteral(tonode, toport, copyedge->pttype, litvalue,
			     edgename);
    return;
  }
  pn = producernodeofedge(copyedge);
  pp = producerportnumber(copyedge);
  if (pn->ndsort == ndgraph) {
    tempedge = getinputedge(newbody, pp + 1);
    if (tempedge == NULL) {
      tempedge = getoutputedge(newbody, pp + 1);
      if (tempedge != NULL)
	edgename = tempedge->ptname;
      tempedge = insertedge(newbody, pp + 1, tonode, toport, copyedge->pttype,
			    edgename);
      return;
    }  /*then*/
    pn = producernodeofedge(tempedge);
    pp = producerportnumber(tempedge);
    edgename = tempedge->ptname;
    tempedge = insertedge(pn, pp, tonode, toport, copyedge->pttype, edgename);
    return;
  }  /*then*/
  newnode = copynode(pn);
  insertnode(parent, tonode, newnode);
  tempedge = insertedge(newnode, pp, tonode, toport, copyedge->pttype,
			edgename);
  tempedge = pn->ndilist;
  while (tempedge != NULL) {
    copytest_(newnode, oldloop, newbody, newbody, tempedge->pttoport,
	      tempedge);
    tempedge = tempedge->pttonext;
  }  /*while*/

  /*else*/
  /*else*/
  /*else*/
}  /*CopyTest*/

Local Void copytesttobody(newloop, oldloop, newbody)
node *newloop, *oldloop, *newbody;
{
  node *oldtest;
  port *edge;


  oldtest = totestgraph(oldloop);
  edge = getinputedge(oldtest, 1L);
  copytest_(newbody, oldloop, newbody, newbody, 1L, edge);
}

Local Void removeinit(newloop, oldloop)
node *newloop, *oldloop;
{
  port *loopedge, *initedge, *outeredge, *tempedge;
  node *init, *pn;
  long pp, loopport;
  stryng edgename, litvalue;

  init = toinitgraph(oldloop);
  loopedge = init->ndilist;
  while (loopedge != NULL) {
    loopport = loopedge->pttoport;
    pn = producernodeofedge(loopedge);
    if (pn->ndcode != ifnnoop)
      printf("ERROR! non-nop node in init graph\n");
    pp = producerportnumber(loopedge);
    initedge = getinputedge(pn, pp);
    if (initedge->ptsort == ptlit) {
      memcpy(edgename.str, blankstring, sizeof(stryngar));
      edgename.len = 0;
      litvalue = initedge->UU.ptlitvalue;
      tempedge = insertliteral(newloop, loopport, initedge->pttype, litvalue,
			       edgename);
    }  /*then*/
    else {
      pp = producerportnumber(initedge);
      pn = producernodeofedge(initedge);
      if (pn->ndsort != ndgraph)
	printf("ERROR! input to NOP node not from graph boundary\n");
      outeredge = getinputedge(newloop, pp);
      edgename = outeredge->ptname;
      if (outeredge->ptsort == ptlit) {
	litvalue = outeredge->UU.ptlitvalue;
	tempedge = insertliteral(newloop, loopport, outeredge->pttype,
				 litvalue, edgename);
      } else {
	pp = producerportnumber(outeredge);
	pn = producernodeofedge(outeredge);
	tempedge = insertedge(pn, pp, newloop, loopport, outeredge->pttype,
			      edgename);
      }  /*else*/
    }  /*else*/
    loopedge = loopedge->pttonext;
  }  /*while*/
}  /*RemoveInit*/

/* Local variables for convertreturns: */
struct LOC_convertreturns {
  node *oldloop, *pn, *newnode;
  long pp;
} ;

Local long nextfreebodyport(newbody, newloop, LINK)
node *newbody, *newloop;
struct LOC_convertreturns *LINK;
{
  long maxbodyout, maxloopin, max;

  max = largestinputportnumber(newbody);
  maxbodyout = largestoutputportnumber(newbody);
  if (max < maxbodyout)
    max = maxbodyout;
  maxloopin = largestinputportnumber(newloop);
  if (max < maxloopin)
    max = maxloopin;
  return (max + 1);
}  /*NextFreeBodyPort*/

Local graph *newgraphptr()
{
  graph *gr;

  gr = (graph *)Malloc(sizeof(graph));
  gr->grnode = NULL;
  gr->grnext = NULL;
  return gr;
}  /*NewGraphPtr*/

Local Void addgrptr(gr, comp)
graph *gr;
node *comp;
{
  graph *curgrptr;

  curgrptr = comp->UU.U2.ndsubsid;
  if (curgrptr == NULL) {
    comp->UU.U2.ndsubsid = gr;
    return;
  }
  while (curgrptr->grnext != NULL)
    curgrptr = curgrptr->grnext;
  curgrptr->grnext = gr;

  /*else*/
}  /*AddGRPtr*/

Local node *buildsubgraph(comp)
node *comp;
{
  node *subgr;
  graph *gr;

  subgr = newnodealloc(ndgraph);
  subgr->ndcode = ifngraph;
  subgr->ndlabel = 0;
  gr = newgraphptr();
  gr->grnode = subgr;
  addgrptr(gr, comp);
  subgr->ndparent = comp;
  return subgr;
}  /*BuildSubGraph*/

Local Void addtoassoclist(node_, assoc)
node *node_;
long assoc;
{
  assoclist *newa, *assoclist_;

  newa = (assoclist *)Malloc(sizeof(assoclist));
  newa->graphnum = assoc;
  newa->next = NULL;
  assoclist_ = node_->UU.U2.ndassoc;
  if (assoclist_ == NULL) {
    node_->UU.U2.ndassoc = newa;
    return;
  }
  while (assoclist_->next != NULL)
    assoclist_ = assoclist_->next;
  assoclist_->next = newa;

  /*else*/
}  /*AddToAssocList*/

Local node *buildif(parent, LINK)
node *parent;
struct LOC_convertreturns *LINK;
{
  node *node_, *graph_;

  node_ = newnodealloc(ndcompound);
  node_->ndcode = ifnselect;
  insertnode(parent, parent->ndnext, node_);
  graph_ = buildsubgraph(node_);
  addtoassoclist(node_, 0L);
  graph_ = buildsubgraph(node_);
  addtoassoclist(node_, 1L);
  graph_ = buildsubgraph(node_);
  addtoassoclist(node_, 2L);
  return node_;
}  /*BuildIf*/

Local Void connectnewreturns(newloop, loopport, retedge, LINK)
node *newloop;
long loopport;
port *retedge;
struct LOC_convertreturns *LINK;
{
  port *outedge, *tempedge;
  long outport;

  outport = retedge->pttoport;
  while (retedge != NULL) {
    outedge = getoutputedge(LINK->oldloop, outport);
    while (outedge != NULL) {
      tempedge = nextoutputedgesameport(outedge);
      changeedgesrc(outedge, newloop, loopport);
      outedge = tempedge;
    }  /*while*/
    retedge = retedge->UU.U1.ptfrnext;
  }  /*while*/
}  /*ConnectNewReturns*/


Local Void connectfilterunitvalue(node_, port_, etype, redkind, LINK)
node *node_;
long port_;
stentry *etype;
unsigned char redkind;
struct LOC_convertreturns *LINK;
{
  stryng litvalue, emptystr, edgename;
  port *tempedge;

  memcpy(emptystr.str, blankstring, sizeof(stryngar));
  emptystr.len = 0;
  switch (redkind) {

  case ifnplus:
    switch (etype->UU.stbasic) {

    case ifbinteger:
      string10(&litvalue, "0         ");
      break;

    case ifbreal:
      string10(&litvalue, "0.0       ");
      break;

    case ifbdouble:
      string10(&litvalue, "0D0       ");
      break;

    case ifbboolean:
      string10(&litvalue, "false     ");
      break;
    }/*case*/
    break;

  case ifntimes:
    switch (etype->UU.stbasic) {

    case ifbinteger:
      string10(&litvalue, "1         ");
      break;

    case ifbreal:
      string10(&litvalue, "1.0       ");
      break;

    case ifbdouble:
      string10(&litvalue, "1D0       ");
      break;

    case ifbboolean:
      string10(&litvalue, "true      ");
      break;
    }/*case*/
    break;

  case ifnmin:
    switch (etype->UU.stbasic) {

    case ifbinteger:
      string20(&litvalue, "posinfinity         ");
      break;

    case ifbreal:
      string20(&litvalue, "posinfinity         ");
      break;

    case ifbdouble:
      string20(&litvalue, "posinfinity         ");
      break;

    case ifbboolean:
      string10(&litvalue, "true      ");
      break;
    }/*case*/
    break;

  case ifnmax:
    switch (etype->UU.stbasic) {

    case ifbinteger:
      string20(&litvalue, "neginfinity         ");
      break;

    case ifbreal:
      string20(&litvalue, "neginfinity         ");
      break;

    case ifbdouble:
      string20(&litvalue, "neginfinity         ");
      break;

    case ifbboolean:
      string10(&litvalue, "false     ");
      break;
    }/*case*/
    break;

  case ifnacatenate:
    LINK->newnode = createsimplenode((long)ifnabuild);
    insertnode(node_->ndparent, node_, LINK->newnode);
    string10(&litvalue, "1         ");
    memcpy(edgename.str, blankstring, sizeof(stryngar));
    edgename.len = 0;
    tempedge = insertliteral(LINK->newnode, 1L, getbasictype(ifbinteger),
			     litvalue, edgename);
    tempedge = insertedge(LINK->newnode, 1L, node_, port_, etype, edgename);
    break;
  }/*case*/

  if (redkind != ifnacatenate)
    tempedge = insertliteral(node_, port_, etype, litvalue, emptystr);

}  /*ConnectFilterUnitValue*/

/* Local variables for dofilter: */
struct LOC_dofilter {
  struct LOC_convertreturns *LINK;
} ;


Local Void buildouterifnode(newloop, filterport, newport, loopport, LINK)
node *newloop;
long filterport, newport, loopport;
struct LOC_dofilter *LINK;
{
  node *ifnode, *subgr, *pn, *integernode;
  port *edge, *tempedge;
  stryng edgename, tempstr, emptystr, litvalue;
  long pp;
  boolean haserrorval;

  memcpy(emptystr.str, blankstring, sizeof(stryngar));
  emptystr.len = 0;
  string10(&tempstr, "error     ");
  edge = getinputedge(newloop, loopport);
  if (edge->ptsort == ptlit) {
    edgename = edge->UU.ptlitvalue;
    if (equalstrings(&edgename, &tempstr)) {
      haserrorval = true;
      tempedge = insertliteral(newloop, newport, edge->pttype, tempstr,
			       emptystr);
    } else
      haserrorval = false;
  }
  if (haserrorval) {
    return;
  }  /*then*/
  ifnode = buildif(newloop->ndparent, LINK->LINK);
  integernode = createsimplenode((long)ifnint);
  insertnode(newloop->ndparent, newloop, integernode);
  tempedge = getinputedge(newloop, filterport);
  edgename = tempedge->ptname;
  if (tempedge->ptsort == ptlit)
    litvalue = tempedge->UU.ptlitvalue;
  else {
    pn = producernodeofedge(tempedge);
    pp = producerportnumber(tempedge);
    tempedge = insertedge(pn, pp, integernode, 1L, getbasictype(ifbboolean),
			  edgename);
  }
  tempedge = insertedge(integernode, 1L, ifnode, 1L, getbasictype(ifbinteger),
			emptystr);
  tempedge = getinputedge(newloop, loopport);
  edgename = tempedge->ptname;
  if (tempedge->ptsort == ptlit) {
    litvalue = tempedge->UU.ptlitvalue;
    tempedge = insertliteral(ifnode, 2L, tempedge->pttype, litvalue, edgename);
  }  /*then*/
  else {
    pn = producernodeofedge(tempedge);
    pp = producerportnumber(tempedge);
    tempedge = insertedge(pn, pp, ifnode, 2L, tempedge->pttype, edgename);
  }

  /*  if (ReduceNode = nil)
            then*/
  tempedge = insertliteral(ifnode, 3L, tempedge->pttype, tempstr, emptystr);
  /*  else
              ConnectFilterUnitValue(IfNode, 3, TempEdge^.PTType, RedKind)*/
  tempedge = insertedge(ifnode, 1L, newloop, newport, tempedge->pttype,
			emptystr);
  subgr = tochildgraph(ifnode, 0L);
  tempedge = insertedge(subgr, 1L, subgr, 1L, getbasictype(ifbinteger),
			emptystr);
  subgr = tochildgraph(ifnode, 1L);
  tempedge = insertedge(subgr, 3L, subgr, 1L, edge->pttype, emptystr);
  subgr = tochildgraph(ifnode, 2L);
  tempedge = insertedge(subgr, 2L, subgr, 1L, edge->pttype, edgename);
}  /*BuildOuterIfNode*/



Local long dofilter(loopport, filterport, newbody, newloop, reducenode, LINK)
long loopport, filterport;
node *newbody, *newloop, *reducenode;
struct LOC_convertreturns *LINK;
{
  struct LOC_dofilter V;
  node *ifnode, *subgr, *pn, *integernode;
  port *edge, *tempedge;
  stryng edgename, emptystr;
  long pp, newport;

  V.LINK = LINK;
  memcpy(emptystr.str, blankstring, sizeof(stryngar));
  emptystr.len = 0;
  ifnode = buildif(newbody, LINK);
  edge = getinputedge(newbody, filterport);
  pn = producernodeofedge(edge);
  pp = producerportnumber(edge);
  edgename = edge->ptname;
  integernode = createsimplenode((long)ifnint);
  insertnode(newbody, newbody->ndnext, integernode);
  /*    if (ReduceNode <> nil)
      then begin
        OrNode := CreateSimpleNode(IFNPlus);
        InsertNode(NewBody, NewBody^.NDNext, OrNode);
        Edge := InsertEdge(OrNode, 1, IntegerNode, 1, GetBasicType(IFBBoolean),
                                   EmptyStr);
        IsErrNode := CreateSimpleNode(IFNIsError);
        InsertNode(NewBody, NewBody^.NDNext, IsErrNode);
        Edge := InsertEdge(IsErrNode, 1, OrNode, 1, GetBasicType(IFBBoolean),
                                      EmptyStr);
        Edge := InsertEdge(PN, PP, IsErrNode, 1, GetBasicType(IFBBoolean), EdgeName);
        Edge := InsertEdge(PN, PP, OrNode, 2, GetBasicType(IFBBoolean), EdgeName);
      end
      else
   */
  edge = insertedge(pn, pp, integernode, 1L, getbasictype(ifbboolean),
		    edgename);

  edge = insertedge(integernode, 1L, ifnode, 1L, getbasictype(ifbinteger),
		    emptystr);
  edge = getinputedge(newbody, loopport);
  pn = producernodeofedge(edge);
  pp = producerportnumber(edge);
  edgename = edge->ptname;
  tempedge = insertedge(pn, pp, ifnode, 2L, edge->pttype, edgename);
  newport = nextfreebodyport(newbody, newloop, LINK);   /*then*/

  /*if this is an AGather, we much change the AddH node's array input to
    be the previous filtered array.  It is now the full unfiltered array.*/

  /*  if (ReduceNode <> nil)
    then begin
        TempEdge := GetInputEdge(ReduceNode, 1);
        ChangeEdgeSrc(TempEdge, NewBody, NewPort);
    end;*/

  tempedge = insertedge(newbody, newport, ifnode, 3L, edge->pttype, emptystr);
  subgr = tochildgraph(ifnode, 0L);
  tempedge = insertedge(subgr, 1L, subgr, 1L, getbasictype(ifbinteger),
			emptystr);
  subgr = tochildgraph(ifnode, 1L);
  tempedge = insertedge(subgr, 3L, subgr, 1L, edge->pttype, emptystr);
  subgr = tochildgraph(ifnode, 2L);
  tempedge = insertedge(subgr, 2L, subgr, 1L, edge->pttype, edgename);
  /*    if (ReduceNode = nil)
      then*/
  buildouterifnode(newloop, filterport, newport, loopport, &V);
  /*    else
        BuildRedOuterIfNode(NewLoop, FilterPort, NewPort, LoopPort, ReduceNode);*/
  memcpy(edgename.str, blankstring, sizeof(stryngar));
  edgename.len = 0;
  tempedge = insertedge(ifnode, 1L, newbody, newport, edge->pttype, edgename);
  return newport;
}  /*DoFilter*/

/* Local variables for doredfilter: */
struct LOC_doredfilter {
  struct LOC_convertreturns *LINK;
  stryng errorstr;
} ;

Local Void buildredouterifnode(newloop, filterport, newport, loopport,
			       rednode, LINK)
node *newloop;
long filterport, newport, loopport;
node *rednode;
struct LOC_doredfilter *LINK;
{
  stryng emptystr, errstr, litvalue, edgename;
  node *ifnode, *integernode, *iserrnode, *innerifnode, *pn, *subgr,
       *frednode, *abuildnode;
  port *tempedge, *filteredge, *loopedge;
  long pp;

  memcpy(emptystr.str, blankstring, sizeof(stryngar));
  emptystr.len = 0;
  string10(&errstr, "error     ");
  ifnode = buildif(newloop->ndparent, LINK->LINK);
  integernode = createsimplenode((long)ifnint);
  insertnode(newloop->ndparent, newloop, integernode);
  tempedge = insertedge(integernode, 1L, ifnode, 1L, getbasictype(ifbinteger),
			emptystr);
  iserrnode = createsimplenode((long)ifniserror);
  insertnode(newloop->ndparent, newloop, iserrnode);
  tempedge = insertedge(iserrnode, 1L, integernode, 1L,
			getbasictype(ifbboolean), emptystr);
  filteredge = getinputedge(newloop, filterport);
  tempedge = insertliteral(iserrnode, 1L, getbasictype(ifbboolean), errstr,
			   emptystr);
  edgename = filteredge->ptname;
  if (filteredge->ptsort == ptlit) {
    litvalue = filteredge->UU.ptlitvalue;
    tempedge = insertliteral(iserrnode, 2L, getbasictype(ifbboolean),
			     litvalue, edgename);
    tempedge = insertliteral(ifnode, 2L, getbasictype(ifbboolean), litvalue,
			     edgename);
  }  /*then*/
  else {
    pn = producernodeofedge(filteredge);
    pp = producerportnumber(filteredge);
    tempedge = insertedge(pn, pp, iserrnode, 2L, getbasictype(ifbboolean),
			  edgename);
    tempedge = insertedge(pn, pp, ifnode, 2L, getbasictype(ifbboolean),
			  edgename);
  }  /*else*/

  loopedge = getinputedge(newloop, loopport);
  edgename = loopedge->ptname;
  if (loopedge->ptsort == ptlit) {
    litvalue = loopedge->UU.ptlitvalue;
    tempedge = insertliteral(ifnode, 2L, getbasictype(ifbboolean), litvalue,
			     edgename);
  } else {
    pn = producernodeofedge(loopedge);
    pp = producerportnumber(loopedge);
    tempedge = insertedge(pn, pp, ifnode, 3L, loopedge->pttype, edgename);
  }

  /* build internals of select node */

  subgr = tochildgraph(ifnode, 0L);
  tempedge = insertedge(subgr, 1L, subgr, 1L, getbasictype(ifbinteger),
			emptystr);

  subgr = tochildgraph(ifnode, 2L);

  if (rednode->ndcode == ifnaaddh || rednode->ndcode == ifnacatenate) {
    abuildnode = createsimplenode((long)ifnabuild);
    insertnode(subgr, NULL, abuildnode);
    string10(&litvalue, "1         ");
    tempedge = insertliteral(abuildnode, 1L, getbasictype(ifbinteger),
			     litvalue, emptystr);
    frednode = createsimplenode(rednode->ndcode);
    insertnode(subgr, abuildnode, frednode);
    tempedge = insertedge(abuildnode, 1L, frednode, 1L, loopedge->pttype,
			  emptystr);
    if (rednode->ndcode == ifnaaddh)
      tempedge = insertliteral(frednode, 2L, loopedge->pttype->UU.stbasetype,
			       LINK->errorstr, emptystr);
    else
      tempedge = insertliteral(frednode, 2L, loopedge->pttype, LINK->errorstr,
			       emptystr);
    tempedge = insertedge(frednode, 1L, subgr, 1L, loopedge->pttype, emptystr);
  }  /*then*/
  else
    tempedge = insertliteral(subgr, 1L, loopedge->pttype, errstr, edgename);

  subgr = tochildgraph(ifnode, 1L);
  innerifnode = buildif(subgr, LINK->LINK);
  integernode = createsimplenode((long)ifnint);
  insertnode(subgr, innerifnode, integernode);

  tempedge = insertedge(integernode, 1L, innerifnode, 1L,
			getbasictype(ifbinteger), emptystr);
  tempedge = insertedge(subgr, 2L, integernode, 1L, getbasictype(ifbboolean),
			emptystr);
  tempedge = insertedge(subgr, 3L, innerifnode, 2L, loopedge->pttype,
			emptystr);
  tempedge = insertedge(innerifnode, 1L, subgr, 1L, loopedge->pttype,
			emptystr);
  subgr = tochildgraph(innerifnode, 0L);
  tempedge = insertedge(subgr, 1L, subgr, 1L, getbasictype(ifbinteger),
			emptystr);

  subgr = tochildgraph(innerifnode, 1L);

  if (rednode->ndcode == ifnaaddh) {
    frednode = createsimplenode((long)ifnabuild);
    insertnode(subgr, NULL, frednode);
    string10(&litvalue, "1         ");
    tempedge = insertliteral(frednode, 1L, getbasictype(ifbinteger), litvalue,
			     emptystr);
    tempedge = insertedge(frednode, 1L, subgr, 1L, loopedge->pttype, emptystr);
    subgr = tochildgraph(innerifnode, 2L);
    tempedge = insertedge(subgr, 2L, subgr, 1L, loopedge->pttype, emptystr);
  }  /*then*/
  else {
    connectfilterunitvalue(subgr, 1L, loopedge->pttype, (int)rednode->ndcode,
			   LINK->LINK);
    subgr = tochildgraph(innerifnode, 2L);
    frednode = createsimplenode(rednode->ndcode);
    insertnode(subgr, NULL, frednode);
    tempedge = insertedge(subgr, 2L, frednode, 1L, loopedge->pttype, emptystr);
    connectfilterunitvalue(frednode, 2L, loopedge->pttype,
			   (int)rednode->ndcode, LINK->LINK);
    tempedge = insertedge(frednode, 1L, subgr, 1L, loopedge->pttype, emptystr);
  }  /*else*/

  tempedge = insertedge(ifnode, 1L, newloop, newport, loopedge->pttype,
			emptystr);
}  /*BuildRedOuterIfNode*/

Local long doredfilter(loopport, filterport, newbody, newloop, rednode, LINK)
long loopport, filterport;
node *newbody, *newloop, *rednode;
struct LOC_convertreturns *LINK;
{
  struct LOC_doredfilter V;
  stryng emptystr, edgename;
  node *ifnode, *innerifnode, *iserrnode, *intnode, *subgr, *newrednode;
  port *filteredge, *loopedge, *tempedge;
  long newport;


  V.LINK = LINK;
  memcpy(emptystr.str, blankstring, sizeof(stryngar));
  emptystr.len = 0;
  string10(&V.errorstr, "error     ");
  loopedge = getinputedge(newbody, loopport);

  newport = nextfreebodyport(newbody, newloop, LINK);
  ifnode = buildif(newbody, LINK);
  filteredge = getinputedge(newbody, filterport);
  edgename = filteredge->ptname;
  LINK->pn = producernodeofedge(filteredge);
  LINK->pp = producerportnumber(filteredge);
  iserrnode = createsimplenode((long)ifniserror);
  insertnode(newbody, LINK->pn, iserrnode);
  tempedge = insertliteral(iserrnode, 1L, getbasictype(ifbboolean),
			   V.errorstr, emptystr);
  tempedge = insertedge(LINK->pn, LINK->pp, iserrnode, 2L,
			getbasictype(ifbboolean), edgename);
  tempedge = insertedge(LINK->pn, LINK->pp, ifnode, 2L,
			getbasictype(ifbboolean), edgename);
  intnode = createsimplenode((long)ifnint);
  insertnode(newbody, iserrnode, intnode);
  tempedge = insertedge(iserrnode, 2L, intnode, 1L, getbasictype(ifbboolean),
			emptystr);
  tempedge = insertedge(intnode, 1L, ifnode, 1L, getbasictype(ifbinteger),
			emptystr);
  /*      TempEdge := GetInputEdge(RedNode, 1);
        ChangeEdgeDest(TempEdge, IfNode, 3);*/
  tempedge = getinputedge(rednode, 2L);
  LINK->pn = producernodeofedge(tempedge);
  LINK->pp = producerportnumber(tempedge);
  tempedge = insertedge(LINK->pn, LINK->pp, ifnode, 4L, tempedge->pttype,
			emptystr);

  /*      ChangeEdgeDest(TempEdge, IfNode, 4);*/

  tempedge = insertedge(newbody, newport, ifnode, 3L, loopedge->pttype,
			emptystr);
  subgr = tochildgraph(ifnode, 0L);
  tempedge = insertedge(subgr, 1L, subgr, 1L, getbasictype(ifbinteger),
			emptystr);

  subgr = tochildgraph(ifnode, 2L);
  newrednode = createsimplenode(rednode->ndcode);
  insertnode(subgr, NULL, newrednode);
  tempedge = insertedge(subgr, 3L, newrednode, 1L, loopedge->pttype, emptystr);
  if (newrednode->ndcode == ifnaaddh)
    tempedge = insertliteral(newrednode, 2L, loopedge->pttype->UU.stbasetype,
			     V.errorstr, emptystr);
  else
    tempedge = insertliteral(newrednode, 2L, loopedge->pttype, V.errorstr,
			     emptystr);
  tempedge = insertedge(newrednode, 1L, subgr, 1L, loopedge->pttype, emptystr);

  subgr = tochildgraph(ifnode, 1L);
  intnode = createsimplenode((long)ifnint);
  insertnode(subgr, NULL, intnode);
  tempedge = insertedge(subgr, 2L, intnode, 1L, getbasictype(ifbboolean),
			emptystr);
  innerifnode = buildif(subgr, LINK);
  tempedge = insertedge(intnode, 1L, innerifnode, 1L,
			getbasictype(ifbinteger), emptystr);
  tempedge = insertedge(subgr, 3L, innerifnode, 2L, loopedge->pttype,
			emptystr);
  if (rednode->ndcode == ifnaaddh) {
    tempedge = insertedge(subgr, 4L, innerifnode, 3L,
			  loopedge->pttype->UU.stbasetype, emptystr);

  } else
    tempedge = insertedge(subgr, 4L, innerifnode, 3L, loopedge->pttype,
			  emptystr);

  subgr = tochildgraph(innerifnode, 0L);
  tempedge = insertedge(subgr, 1L, subgr, 1L, getbasictype(ifbinteger),
			emptystr);

  subgr = tochildgraph(innerifnode, 1L);
  tempedge = insertedge(subgr, 2L, subgr, 1L, loopedge->pttype, emptystr);

  subgr = tochildgraph(innerifnode, 2L);
  newrednode = createsimplenode(rednode->ndcode);
  insertnode(subgr, NULL, newrednode);
  tempedge = insertedge(subgr, 2L, newrednode, 1L, loopedge->pttype, emptystr);
  if (rednode->ndcode == ifnaaddh)
    tempedge = insertedge(subgr, 3L, newrednode, 2L,
			  loopedge->pttype->UU.stbasetype, emptystr);
  else
    tempedge = insertedge(subgr, 3L, newrednode, 2L, loopedge->pttype,
			  emptystr);
  tempedge = insertedge(newrednode, 1L, subgr, 1L, loopedge->pttype, emptystr);

  subgr = tochildgraph(ifnode, 1L);
  tempedge = insertedge(innerifnode, 1L, subgr, 1L, loopedge->pttype,
			emptystr);

  /*This is a reduce, we have to change the Red nodes input to be
    the previous filtered value.  It is now the unfiltered value */

  /*      TempEdge := GetInputEdge(RedNode, 1);
        ChangeEdgeSrc(TempEdge, NewBody, NewPort);

        TempEdge := GetOutputEdge(RedNode, 1);
        DisconnectEdgeFromDest(TempEdge);*/

  buildredouterifnode(newloop, filterport, newport, loopport, rednode, &V);

  tempedge = insertedge(ifnode, 1L, newbody, newport, loopedge->pttype,
			emptystr);
  return newport;
}  /*DoRedFilter*/

Local Void connectunitvalue(newloop, maxout, loopport, etype, redkind, LINK)
node *newloop;
long maxout, loopport;
stentry *etype;
unsigned char redkind;
struct LOC_convertreturns *LINK;
{
  stryng litvalue, emptystr, edgename;
  port *tempedge;
  long pp;
  node *pn, *abuildnode, *acatnode;

  memcpy(emptystr.str, blankstring, sizeof(stryngar));
  emptystr.len = 0;
  switch (redkind) {

  case ifnplus:
    switch (etype->UU.stbasic) {

    case ifbinteger:
      string10(&litvalue, "0         ");
      break;

    case ifbreal:
      string10(&litvalue, "0.0       ");
      break;

    case ifbdouble:
      string10(&litvalue, "0D0       ");
      break;

    case ifbboolean:
      string10(&litvalue, "false     ");
      break;
    }/*case*/
    break;

  case ifntimes:
    switch (etype->UU.stbasic) {

    case ifbinteger:
      string10(&litvalue, "1         ");
      break;

    case ifbreal:
      string10(&litvalue, "1.0       ");
      break;

    case ifbdouble:
      string10(&litvalue, "1D0       ");
      break;

    case ifbboolean:
      string10(&litvalue, "true      ");
      break;
    }/*case*/
    break;

  case ifnmin:
    switch (etype->UU.stbasic) {

    case ifbinteger:
      string20(&litvalue, "posinfinity         ");
      break;

    case ifbreal:
      string20(&litvalue, "posinfinity         ");
      break;

    case ifbdouble:
      string20(&litvalue, "posinfinity         ");
      break;

    case ifbboolean:
      string10(&litvalue, "true      ");
      break;
    }/*case*/
    break;

  case ifnmax:
    switch (etype->UU.stbasic) {

    case ifbinteger:
      string20(&litvalue, "neginfinity         ");
      break;

    case ifbreal:
      string20(&litvalue, "neginfinity         ");
      break;

    case ifbdouble:
      string20(&litvalue, "neginfinity         ");
      break;

    case ifbboolean:
      string10(&litvalue, "false     ");
      break;
    }/*case*/
    break;

  case ifnaaddh:
    LINK->newnode = createsimplenode((long)ifnabuild);
    insertnode(newloop->ndparent, newloop, LINK->newnode);
    string10(&litvalue, "1         ");
    tempedge = insertliteral(LINK->newnode, 1L, getbasictype(ifbinteger),
			     litvalue, emptystr);
    tempedge = insertedge(LINK->newnode, 1L, newloop, maxout, etype, emptystr);
    break;
    /*IFNAAddH*/

  case ifnacatenate:
    abuildnode = createsimplenode((long)ifnabuild);
    insertnode(newloop->ndparent, newloop, abuildnode);
    string10(&litvalue, "1         ");
    tempedge = insertliteral(abuildnode, 1L, getbasictype(ifbinteger),
			     litvalue, emptystr);
    acatnode = createsimplenode((long)ifnacatenate);
    insertnode(newloop->ndparent, abuildnode, acatnode);
    tempedge = insertedge(abuildnode, 1L, acatnode, 1L, etype, emptystr);
    tempedge = getinputedge(newloop, loopport);
    edgename = tempedge->ptname;
    if (tempedge->ptsort == ptlit) {
      litvalue = tempedge->UU.ptlitvalue;
      tempedge = insertliteral(acatnode, 2L, etype, litvalue, edgename);
    }  /*then*/
    else {
      pn = producernodeofedge(tempedge);
      pp = producerportnumber(tempedge);
      tempedge = insertedge(pn, pp, acatnode, 2L, etype, edgename);
    }  /*else*/
    tempedge = insertedge(acatnode, 1L, newloop, maxout, etype, emptystr);

    /*also connect it to input for loop port*/

    tempedge = getinputedge(newloop, loopport);
    changeedgesrc(tempedge, acatnode, 1L);
    break;
  }/*case*/

  if (redkind != ifnaaddh && redkind != ifnacatenate)
    tempedge = insertliteral(newloop, maxout, etype, litvalue, emptystr);

}  /*ConnectUnitValue*/

Local long delayvalueoneiter(loopport, newbody, newloop, delaykind, redkind,
			     isloopa, LINK)
long loopport;
node *newbody, *newloop;
delaytype delaykind;
unsigned char redkind;
boolean isloopa;
struct LOC_convertreturns *LINK;
{
  port *tempedge, *loopedge;
  stryng edgename, oldstring, errorstr, litvalue;
  long nextport;
  node *abuildnode;

  loopedge = getoutputedge(newbody, loopport);
  if (loopedge == NULL) {
    string10(&oldstring, "old-      ");
    loopedge = getinputedge(newbody, loopport);
    if (loopedge == NULL)
      printf("ERROR! no edges in the body for this loop port!\n");
    edgename = loopedge->ptname;
    if (oldstring.len < maxstringchars)
      insertstring(&oldstring, &edgename, oldstring.len + 1);
    edgename = oldstring;
  } else
    edgename = loopedge->ptname;
  nextport = nextfreebodyport(newbody, newloop, LINK);
  tempedge = insertedge(newbody, loopport, newbody, nextport,
			loopedge->pttype, edgename);
  memcpy(edgename.str, blankstring, sizeof(stryngar));
  edgename.len = 0;
  string10(&errorstr, "error     ");
  switch (delaykind) {

  case valueof:
    tempedge = insertliteral(newloop, nextport, loopedge->pttype, errorstr,
			     edgename);
    break;

  case arrayof:
    if (isloopa) {
      tempedge = getinputedge(newloop, loopport);
      tempedge = insertedge(producernodeofedge(tempedge),
			    producerportnumber(tempedge), newloop, nextport,
			    tempedge->pttype, edgename);
    } else {
      abuildnode = createsimplenode((long)ifnabuild);
      insertnode(newloop->ndparent, newloop, abuildnode);
      string10(&litvalue, "1         ");
      tempedge = insertliteral(abuildnode, 1L, getbasictype(ifbinteger),
			       litvalue, edgename);
      tempedge = getinputedge(newloop, loopport);
      tempedge = insertedge(abuildnode, 1L, newloop, nextport,
			    tempedge->pttype, edgename);
    }  /*else*/
    break;
    /*ArrayOf*/

  case reduce:
    if (isloopa || redkind != ifnacatenate)
      connectunitvalue(newloop, nextport, loopport, loopedge->pttype, redkind,
		       LINK);
    else {
      abuildnode = createsimplenode((long)ifnabuild);
      insertnode(newloop->ndparent, newloop, abuildnode);
      string10(&litvalue, "1         ");
      memcpy(edgename.str, blankstring, sizeof(stryngar));
      edgename.len = 0;
      tempedge = insertliteral(abuildnode, 1L, getbasictype(ifbinteger),
			       litvalue, edgename);
      tempedge = getinputedge(newloop, loopport);
      tempedge = insertedge(abuildnode, 1L, newloop, nextport,
			    tempedge->pttype, edgename);
    }
    break;
    /*   TempEdge := GetInputEdge(NewLoop, LoopPort);
       if ((TempEdge^.PTSort = PTLit))
       then begin
         LitValue := TempEdge^.PTLitValue;
         TempEdge := InsertLiteral(NewLoop, NextPort,
                    TempEdge^.PTType, LitValue, EdgeName);
       end
       else
         TempEdge := InsertEdge(ProducerNodeOfEdge(TempEdge),
                        ProducerPortNumber(TempEdge), NewLoop,
                        NextPort, TempEdge^.PTType, EdgeName);*/

    /*Reduce*/

  case filter:
    tempedge = insertliteral(newloop, nextport, getbasictype(ifbboolean),
			     errorstr, edgename);
    break;

  }/*case*/
  return nextport;
}  /*DelayValueOneIter*/

Local Void convertreturns(newloop, oldloop_, newbody)
node *newloop, *oldloop_, *newbody;
{
  struct LOC_convertreturns V;
  port *retedge, *inedge, *loopedge, *outedge, *tempedge, *filteredge;
  node *retnode, *oldret, *newrednode;
  long loopport, filterport, maxout;
  stryng edgename, litvalue, redfunctstr, sumstr, prodstr, leaststr, greatstr,
	 catenatestr;
  boolean old, isloopa;

  V.oldloop = oldloop_;
  oldret = toreturnsgraph(V.oldloop);
  retnode = oldret->ndnext;
  if (V.oldloop->ndcode == ifnloopa)
    isloopa = true;
  else
    isloopa = false;

  while (retnode != NULL) {
    old = false;
    switch (retnode->ndcode) {

    case ifnfinalvalue:
      inedge = getinputedge(retnode, 1L);
      loopport = producerportnumber(inedge);
      retedge = getoutputedge(retnode, 1L);
      V.pn = producernodeofedge(inedge);
      if (V.pn->ndcode == ifnallbutlastvalue) {
	inedge = getinputedge(V.pn, 1L);
	loopport = producerportnumber(inedge);
	loopport = delayvalueoneiter(loopport, newbody, newloop, valueof, 0,
				     isloopa, &V);
      } else if (V.pn->ndsort != ndgraph)
	printf("ERROR! edge not coming from a graph in convert returns\n");
      filteredge = getinputedge(retnode, 2L);
      if (filteredge != NULL) {
	V.pn = producernodeofedge(filteredge);
	if (V.pn->ndcode == ifnallbutlastvalue) {
	  filteredge = getinputedge(V.pn, 1L);
	  filterport = producerportnumber(filteredge);
	  filterport = delayvalueoneiter(filterport, newbody, newloop, filter,
					 0, isloopa, &V);
	} else if (V.pn->ndsort == ndgraph)
	  filterport = producerportnumber(filteredge);
	else
	  printf("***ERROR!  filter edge not coming for a graph \n");
	loopport = dofilter(loopport, filterport, newbody, newloop, NULL, &V);
      }  /*then*/
      connectnewreturns(newloop, loopport, retedge, &V);

      break;
      /*IFNFinalValue*/

    case ifnredright:
    case ifnredtree:
    case ifnredleft:
    case ifnreduce:
      if (retnode->ndcode == ifnredright) {
	printf(" warning **** RedRight node will be implemented as a RedLeft\n");
	retnode->ndcode = ifnredleft;
      }

      if (retnode->ndcode == ifnredtree) {
	printf(" warning **** RedTree node will be implemented as a RedLeft\n");
	retnode->ndcode = ifnredleft;
      }

      string10(&sumstr, "SUM       ");
      stripspaces(&sumstr);
      string10(&prodstr, "PRODUCT   ");
      stripspaces(&prodstr);
      string10(&leaststr, "LEAST     ");
      stripspaces(&leaststr);
      string10(&greatstr, "GREATEST  ");
      stripspaces(&greatstr);
      string10(&catenatestr, "CATENATE  ");
      stripspaces(&catenatestr);

      inedge = getinputedge(retnode, 3L);
      retedge = retnode->ndolist;
      V.pn = producernodeofedge(inedge);
      if (V.pn->ndcode == ifnallbutlastvalue) {
	old = true;
	inedge = getinputedge(V.pn, 1L);
	loopport = producerportnumber(inedge);
      }  /*then*/
      else {
	loopport = producerportnumber(inedge);
	if (V.pn->ndsort != ndgraph)
	  printf("ERROR!! edge not coming for a graph in ConvertReturns\n");
      }  /*else*/

      loopedge = getinputedge(newbody, loopport);
      tempedge = getinputedge(retnode, 1L);
      redfunctstr = tempedge->UU.ptlitvalue;
      if (equalstrings(&redfunctstr, &sumstr))
	V.newnode = createsimplenode((long)ifnplus);
      else if (equalstrings(&redfunctstr, &prodstr))
	V.newnode = createsimplenode((long)ifntimes);
      else if (equalstrings(&redfunctstr, &leaststr))
	V.newnode = createsimplenode((long)ifnmin);
      else if (equalstrings(&redfunctstr, &greatstr))
	V.newnode = createsimplenode((long)ifnmax);
      else if (equalstrings(&redfunctstr, &catenatestr))
	V.newnode = createsimplenode((long)ifnacatenate);
      else
	printf("ERROR!  Bad reduction function\n");

      insertnode(newbody, newbody->ndnext, V.newnode);
      newrednode = V.newnode;
      V.pn = producernodeofedge(loopedge);
      V.pp = producerportnumber(loopedge);
      edgename = loopedge->ptname;
      tempedge = insertedge(V.pn, V.pp, V.newnode, 2L, loopedge->pttype,
			    edgename);
      edgename = retedge->ptname;
      maxout = nextfreebodyport(newbody, newloop, &V);
      tempedge = insertedge(newbody, maxout, V.newnode, 1L, loopedge->pttype,
			    edgename);
      tempedge = insertedge(V.newnode, 1L, newbody, maxout, loopedge->pttype,
			    edgename);

      outedge = getinputedge(newloop, loopport);
      edgename = outedge->ptname;
      if (V.newnode->ndcode == ifnacatenate)
	connectunitvalue(newloop, maxout, loopport, loopedge->pttype,
			 (int)V.newnode->ndcode, &V);
      else {
	if (outedge->ptsort == ptlit) {
	  litvalue = outedge->UU.ptlitvalue;
	  tempedge = insertliteral(newloop, maxout, outedge->pttype, litvalue,
				   edgename);
	}  /*then*/
	else
	  tempedge = insertedge(producernodeofedge(outedge),
				producerportnumber(outedge), newloop, maxout,
				outedge->pttype, edgename);
      }  /*else*/


      loopport = maxout;
      /*      if (Old)
                            then
                              LoopPort := DelayValueOneIter(LoopPort, NewBody,
                                              NewLoop, Reduce, NewNode^.NDCode);*/
      if (getinputedge(retnode, 4L) != NULL) {
	filteredge = getinputedge(retnode, 4L);
	V.pn = producernodeofedge(filteredge);
	if (V.pn->ndcode == ifnallbutlastvalue) {
	  filteredge = getinputedge(V.pn, 1L);
	  filterport = producerportnumber(filteredge);
	  /*  FilterPort := DelayValueOneIter(FilterPort, NewBody,
	                                                          NewLoop, Filter, 0);*/
	}  /*then*/
	else if (V.pn->ndsort == ndgraph)
	  filterport = producerportnumber(filteredge);
	else
	  printf("ERROR filter edge not coming from a graph\n");
	loopport = doredfilter(loopport, filterport, newbody, newloop,
			       newrednode, &V);
      }  /*then*/
      if (old)
	loopport = delayvalueoneiter(loopport, newbody, newloop, reduce,
				     (int)newrednode->ndcode, isloopa, &V);
      connectnewreturns(newloop, loopport, retedge, &V);
      break;
      /*IFNReduce, IFNRedLeft*/

    case ifnagather:
      inedge = getinputedge(retnode, 2L);
      retedge = retnode->ndolist;
      V.pn = producernodeofedge(inedge);
      if (V.pn->ndcode == ifnallbutlastvalue) {
	old = true;
	inedge = getinputedge(V.pn, 1L);
	loopport = producerportnumber(inedge);
      } else {
	loopport = producerportnumber(inedge);
	if (V.pn->ndsort != ndgraph)
	  printf("ERROR! edge not coming from a graph in convert returns\n");
      }  /*else*/

      loopedge = getinputedge(newbody, loopport);
      newrednode = createsimplenode((long)ifnaaddh);
      insertnode(newbody, newbody->ndnext, newrednode);
      V.pn = producernodeofedge(loopedge);
      V.pp = producerportnumber(loopedge);
      edgename = loopedge->ptname;
      tempedge = insertedge(V.pn, V.pp, newrednode, 2L, loopedge->pttype,
			    edgename);
      edgename = retedge->ptname;
      maxout = nextfreebodyport(newbody, newloop, &V);
      tempedge = insertedge(newbody, maxout, newrednode, 1L, retedge->pttype,
			    edgename);
      tempedge = insertedge(newrednode, 1L, newbody, maxout, retedge->pttype,
			    edgename);
      V.newnode = createsimplenode((long)ifnabuild);
      insertnode(newloop->ndparent, newloop, V.newnode);
      string10(&litvalue, "1         ");
      memcpy(edgename.str, blankstring, sizeof(stryngar));
      edgename.len = 0;
      tempedge = insertliteral(V.newnode, 1L, getbasictype(ifbinteger),
			       litvalue, edgename);
      tempedge = insertedge(V.newnode, 1L, newloop, maxout, retedge->pttype,
			    edgename);
      inedge = getinputedge(newloop, loopport);
      edgename = inedge->ptname;
      if (inedge->ptsort == ptlit) {
	litvalue = inedge->UU.ptlitvalue;
	tempedge = insertliteral(V.newnode, 2L, inedge->pttype, litvalue,
				 edgename);
      }  /*then*/
      else {
	V.pn = producernodeofedge(inedge);
	V.pp = producerportnumber(inedge);
	tempedge = insertedge(V.pn, V.pp, V.newnode, 2L, inedge->pttype,
			      edgename);
      }  /*else*/
      loopport = maxout;
      /*       if (Old)
                             then
                               LoopPort := DelayValueOneIter(LoopPort, NewBody,
                                                      NewLoop, ArrayOf, 0);*/
      if (getinputedge(retnode, 3L) != NULL) {
	filteredge = getinputedge(retnode, 3L);
	V.pn = producernodeofedge(filteredge);
	if (V.pn->ndcode == ifnallbutlastvalue) {
	  filteredge = getinputedge(V.pn, 1L);
	  filterport = producerportnumber(filteredge);
	  /*   FilterPort := DelayValueOneIter(FilterPort, NewBody,
	                                                   NewLoop, Filter, 0);*/
	} else if (V.pn->ndsort == ndgraph)
	  filterport = producerportnumber(filteredge);
	else
	  printf("****ERROR filter edge not coming from a graph\n");
	loopport = doredfilter(loopport, filterport, newbody, newloop,
			       newrednode, &V);
      }  /*then*/
      if (old)
	loopport = delayvalueoneiter(loopport, newbody, newloop, arrayof, 0,
				     isloopa, &V);
      connectnewreturns(newloop, loopport, retedge, &V);

      break;
      /*IFNAGather*/

    case ifnallbutlastvalue:
      /* blank case */
      break;
    }/*case*/
    retnode = retnode->ndnext;
  }  /*while*/
}  /*ConvertReturns*/

Local Void convertloop(oldloop, prevnode)
node *oldloop, *prevnode;
{
  node *newloop, *newbody;
  boolean isloopa;
  long k, port_;
  stryng emptystring, truestring;
  port *edge, *nextedge;

  memcpy(emptystring.str, blankstring, sizeof(stryngar));
  emptystring.len = 0;
  string10(&truestring, "true      ");
  if (oldloop->ndcode == ifnloopa)
    isloopa = true;
  else
    isloopa = false;
  newloop = copynode(oldloop);
  insertnode(oldloop->ndparent, toprevnode(oldloop), newloop);
  newloop->ndcode = ifniter;

  /*Make Body the only subgraph*/

  newloop->UU.U2.ndsubsid = newloop->UU.U2.ndsubsid->grnext->grnext;
  newloop->UU.U2.ndsubsid->grnext = NULL;

  /* Remove Association list, it's not needed */

  newloop->UU.U2.ndassoc = NULL;
  newbody = newloop->UU.U2.ndsubsid->grnode;

  /* Connect K ports*/

  edge = oldloop->ndilist;
  while (edge != NULL) {
    port_ = edge->pttoport;
    nextedge = edge->pttonext;
    changeedgedest(edge, newloop, port_);
    port_++;
    edge = nextedge;
  }  /*while*/


  removeinit(newloop, oldloop);

  convertreturns(newloop, oldloop, newbody);

  k = largestinputportnumber(newloop);
  shiftinputports(newloop, 1L, 1L);
  shiftoutputports(newbody, 1L, 1L);
  shiftinputports(newbody, 1L, 1L);
  shiftoutputports(newloop, 1L, 1L);

  if (!isloopa)
    copytestout(newloop, oldloop);
  else
    nextedge = insertliteral(newloop, 1L, getbasictype(ifbboolean),
			     truestring, emptystring);

  /* Copy test out for LoopB and wire in a true on port 1 for LoopA */

  copytesttobody(newloop, oldloop, newbody);

}  /* ConvertLoop */

Local boolean findloops(graph_)
node *graph_;
{
  node *n, *prevnode, *nextnode;
  long numsg, i;
  boolean hasloops;

  n = graph_->ndnext;
  prevnode = NULL;
  while (n != NULL) {
    nextnode = n->ndnext;
    if (n->ndsort == ndcompound) {
      numsg = numbofsubgraphs(n);
      for (i = 0; i < numsg; i++) {
	if (findloops(tochildgraph(n, i)))
	  hasloops = true;
      }
    }  /*then*/
    if (n->ndcode == ifnloopa || n->ndcode == ifnloopb) {
      convertloop(n, prevnode);
      hasloops = true;
    }  /*then*/
    else
      prevnode = n;
    n = nextnode;
  }  /*while*/
  return hasloops;
}  /*FindLoops*/



Static Void newloop()
{
  node *funct;
  long cseint;
  boolean ok;

  funct = firstfunction;
  while (funct != NULL) {
    if (findloops(funct))
      cseint = removegraphcse(funct, true);
    funct = tonextfunction(funct);
  }  /*while*/
  if (dforder(module))
    ok = asgnar();
  else
    printf("***** graph could not be ordered after loop conversion ******\n");
  removedeadcode(false);
}  /*NewLoop*/


main(argc, argv)
int argc;
Char *argv[];
{
  PASCAL_MAIN(argc, argv);
  /* if2newloop */
  diag = NULL;
  source = NULL;
  paramlist = NULL;
  if (loadmodule(&paramlist)) {
    if (!stampisset('D'))
      printf("*******error graph not ordered********\n");
    else {
      newloop();
      /*    RemoveDeadCode(false);*/
      dumpmodule();
    }
  }
  if (source != NULL)
    fclose(source);
  if (diag != NULL)
    fclose(diag);
  exit(0);
}



/* End. */
