#include <stdio.h>

extern	char	*index();
#ifdef BSD
extern	char	*sprintf();
#endif

int	Miscompares	= 0;	/* Number of blown comparisons */
char	*suite		= "stdin"; /* Name of suite being executed */

/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
int FixIStat(istat)
     int	istat;
{
  return (istat<256)?istat:(istat/256);
}

/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
void
CreateFile(name)
     char	*name;
{
  int		lineno;
  char		line[1025];
  FILE		*FP;

  /* ------------------------------------------------------------ */
  /* Open the requested file */
  FP = fopen(name,"w");
  if ( !FP ) {
    (void)fprintf(stderr,"Couldn't open %s\n",name);
    perror("suite");
    exit(2);
  }

  /* ------------------------------------------------------------ */
  /* Read lines into the file upto a #ENDFILE */
  for(lineno=0;
      fgets(line,sizeof(line),stdin) && strcmp(line,"#ENDFILE\n") != 0;
      lineno++) {
    fputs(line,FP);
  }

  (void)fprintf(stderr,">>> Created file %s with %d lines\n",name,lineno);

  /* ------------------------------------------------------------ */
  /* Close the file */
  (void)fclose(FP);
}

/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
void
CompareFiles(name1,name2)
     char	*name1,*name2;
{
  char		com[1025];
  int		istat;

  /* ------------------------------------------------------------ */
  (void)fprintf(stderr,">>> Compare %s and %s\n",name1,name2);

  /* ------------------------------------------------------------ */
  /* Use the fibrecompare command */
  (void)sprintf(com,"fibrecheck %s %s",name1,name2);
  istat = FixIStat(system(com));

  /* ------------------------------------------------------------ */
  /* 0 == OK, 1 == Different, 2 == Oops */
  switch ( istat ) {
   case 0:
    break;
   case 1:
    (void)fprintf(stderr,"### Files %s and %s miscompare!\n",name1,name2);
    Miscompares++;
    break;
   default:
    (void)fprintf(stderr,"### Fatal error %d on comparison ``%s''\n",istat,com);
    exit(2);
  }
}

/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
void
Execute(com)
     char	*com;
{
  int		istat;

  (void)fprintf(stderr,">>> Execute ``%s''\n",com);

  istat = system(com);

  if ( istat ) {
    (void)fprintf(stderr,"### Warning: ``%s'' returns %d\n",com,istat);
  }
}

/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
void
main(argc,argv)
     int	argc;
     char	*argv[];
{
  char		line[1025];
  char		*arg,*com;
  int		LineNo;

  /* ------------------------------------------------------------ */
  /* Use the suite name on the command line if provided */
  if ( argv[1] ) {
    if ( !freopen(argv[1],"r",stdin) ) {
      (void)fprintf(stderr,"Couldn't open script %s\n",argv[1]);
      perror("suite");
      exit(2);
    } else {
      suite = argv[1];
    }
  }

  /* ------------------------------------------------------------ */
  /* Parse any command lines starting with # */
  LineNo = 0;
  while(gets(line)) {
    LineNo++;
    if ( line[0] == '#' ) {
      switch( line[1] ) {
	/* Ignore empty lines and comments */
	/* ## Anything... --> Comment */
       case '\0':
       case '#':
	break;
       
	/* #FILE=name --> Create file */
       case 'F':
	arg = index(line,'=');
	if ( arg ) {
	  CreateFile(arg+1);
	}
	break;

	/* #compare=name1,name2 --> compare 2 files */
       case 'C':
	arg = index(line,'=');
	if ( arg ) {
	  com = index(arg+1,',');
	  if ( com ) {
	    *com = '\0';
	    CompareFiles(arg+1,com+1);
	  }
	}
	break;

	/* #environment=name=... --> set environment string name */
       case 'E':
	arg = index(line,'=');
	if (arg) {
	  putenv(strcpy(malloc(strlen(arg+1)+1),arg+1));
	}
	break;

	/* #X=command --> execute a SH command */
       case 'X':
	arg = index(line,'=');
	if ( arg ) {
	  Execute(arg+1);
	}
	break;

	/* #QUIT --> quit the program */
       case 'Q':
	goto Done;
	break;

       default:
	(void)fprintf(stderr,"### Ignoring line %d = ``%s''\n",LineNo,line);
      }
    } else {
	(void)fprintf(stderr,"### Ignoring line %d = ``%s''\n",LineNo,line);
    }
  }

  /* ------------------------------------------------------------ */
  /* Error exit when miscomparison */
 Done:
  if ( Miscompares ) {
    (void)fprintf(stderr,"### %d Miscompares in %s!\n",Miscompares,suite);
    exit(1);
  } else {
    (void)fprintf(stderr,">>> No Miscompares in %s!\n",suite);
    exit(0);
  }
}
