/* getresource.c
 *
 * Copyright 1990,1991 the Regents of the University of California.  All
 * rights reserved.  Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that this copyright notice appear in all
 * copies.  See the file copyright.h for more information.
 *
 */

/*
 * contains general object manipulation commands.
 *
 */

#include <stdio.h>
#include <math.h>
#include "xwrap.h"
#include <X11/IntrinsicP.h>      /* is this really needed? */
#include <X11/CoreP.h>
#include <X11/Xaw/TextP.h>           /* to get XtNScrollMode, etc. */
#include <X11/Xmu/Converters.h>  /* for converting from string to ...  */

#include "debug.h"
#include "global.h"
#include "util.h"
#include "object.h"

static int GetFontHeight(w)
     Widget w;
{
	int height;
	XFontStruct *font;
	entering("GetFontHeight");
	if ((XtClass(w)==commandWidgetClass)||
	    (XtClass(w)==menuButtonWidgetClass)||
	    (XtClass(w)==labelWidgetClass)||
	    (XtClass(w)==scToolWidgetClass)||
	    (XtClass(w)==asciiTextWidgetClass)||
	    (XtClass(w)==toggleWidgetClass)||
	    (XtClass(w)==listWidgetClass)||
	    (XtClass(w)==smeBSBObjectClass)) {
		XtVaGetValues(w,XtNfont,&font,NULL);
		height = font->max_bounds.ascent + font->max_bounds.descent;
	} else {
		height = 1;
	}
	myreturn height;
}

static int GetFontWidth(w)
     Widget w;
{
	int width;
	XFontStruct *font;
	entering("GetFontWidth");
	if ((XtClass(w)==commandWidgetClass)||
	    (XtClass(w)==menuButtonWidgetClass)||
	    (XtClass(w)==labelWidgetClass)||
	    (XtClass(w)==scToolWidgetClass)||
	    (XtClass(w)==asciiTextWidgetClass)||
	    (XtClass(w)==toggleWidgetClass)||
	    (XtClass(w)==listWidgetClass)||
	    (XtClass(w)==smeBSBObjectClass)) {
		XtVaGetValues(w,XtNfont,&font,NULL);
		width=font->max_bounds.rbearing - font->min_bounds.lbearing;
	} else {
		width = 1;
	}
	myreturn width;
}
static char *NewIntegerString(i)
     int i;
     /* returns a string for the integer value. */
{
	char *space;
	int count;
	entering("NewIntegerString");
	if (i==0) {
		space = XtNewString("0");
	} else if (i<0) {
		space = XtMalloc((int)(log10((double)(abs(i)))+2));
		sprintf(space,"-%d",abs(i));
	} else {
		space = XtMalloc((int)(log10((double)i)+1));
		sprintf(space,"%d",i);
	}
	myreturn space;
}

static int ParseGetResource(clientData,interp,argc,argv)
     char *clientData;
     Tcl_Interp *interp;
     int argc;
     char **argv;
     /* used for commands which get a single resource for a widget:
	'getresource object-name' */
{
	Dimension d;
	Position p;
	char *value;
	Widget nextwidget,w;
	char *result,usage[MAXLINE];
	entering("ParseGetResource");
	sprintf(usage,"%s object-name",argv[0]);
	if (BadUsage(argc,2,usage,interp)) {
		myreturn TCL_ERROR;
	}
	if (!(w=WidgetExists(argv[1],interp))) {
		myreturn TCL_ERROR;
	}
	value=NULL;
	if (mystrcmp(argv[0],"getlabel")==0) {
		XtVaGetValues(w,XtNlabel,&value,NULL);
		result = XtNewString(value);
	} else if (mystrcmp(argv[0],"getx")==0) {
		XtVaGetValues(w,XtNx,&p,NULL);
		result = NewIntegerString((int)p);
	} else if (mystrcmp(argv[0],"gety")==0) {
		XtVaGetValues(w,XtNy,&p,NULL);
		result = NewIntegerString((int)p);
	} else if (mystrcmp(argv[0],"getheight")==0) {
		XtVaGetValues(w,XtNheight,&d,NULL);
		result = NewIntegerString((int)d);
	} else if (mystrcmp(argv[0],"getwidth")==0) {
		XtVaGetValues(w,XtNwidth,&d,NULL);
		result = NewIntegerString((int)d);
	} else if (mystrcmp(argv[0],"getborderwidth")==0) {
		XtVaGetValues(w,XtNborderWidth,&d,NULL);
		result = NewIntegerString((int)d);
	} else if (mystrcmp(argv[0],"getmenuname")==0) {
		XtVaGetValues(w,XtNmenuName,&value,NULL);
		result = XtNewString(value);
	} else if (mystrcmp(argv[0],"getfontheight")==0) {
		result = NewIntegerString((int)GetFontHeight(w));
	} else if (mystrcmp(argv[0],"getfontwidth")==0) {
		result = NewIntegerString((int)GetFontWidth(w));
	} else if (mystrcmp(argv[0],"getfromvert")==0) {
		if (XtClass(XtParent(w))==formWidgetClass) {
			XtVaGetValues(w,XtNfromVert,&nextwidget,NULL);
			if (nextwidget) {
				result = XtNewString(XtName(nextwidget));
			} else {
				result = XtNewString("0");
			}
		} else {
			result = XtNewString("0");
		}
	} else if (mystrcmp(argv[0],"getfromhoriz")==0) {
		if (XtClass(XtParent(w))==formWidgetClass) {
			XtVaGetValues(w,XtNfromHoriz,&nextwidget,NULL);
			if (nextwidget) {
				result = XtNewString(XtName(nextwidget));
			} else {
				result = XtNewString("0");
			}
		} else {
			result = XtNewString("0");
		}
	} else if (mystrcmp(argv[0],"getlisthighlighted")==0) {
		if (XtClass(w)==listWidgetClass) {
			XawListReturnStruct *item;
			item=XawListShowCurrent(w);
			if (item->list_index!=XAW_LIST_NONE) {
				result = XtNewString(item->string);
			} else {
				result = XtNewString("");
			}
		} else {
			result = XtNewString("");
		}
	} else if (mystrcmp(argv[0],"getprogram")==0) {
		if (XtClass(w)==scToolWidgetClass) {
			XtVaGetValues(w,XtNprogram,&value,NULL);
			if (value) {
				result = XtNewString(value);
			} else {
				result = XtNewString("");
			}
		} else {
			result = XtNewString("");
		}
	} else if (mystrcmp(argv[0],"getvalue")==0) {
		if (XtClass(w)==dialogWidgetClass) {
		        value=XawDialogGetValueString(w);
		} else if ((XtClass(w)==scToolWidgetClass)||
			   (XtClass(w)==asciiTextWidgetClass)) {
			XtVaGetValues(w,XtNstring,&value,NULL);
		} else if ((XtClass(w)==commandWidgetClass)||
			   (XtClass(w)==menuButtonWidgetClass)||
			   (XtClass(w)==labelWidgetClass)||
			   (XtClass(w)==smeBSBObjectClass)){
			XtVaGetValues(w,XtNlabel,&value,NULL);
		} else {
			XtVaGetValues(w,XtNvalue,&value,NULL);
		}
		result = XtNewString(value);
	} else if (mystrcmp(argv[0],"getcallback")==0) {
		switch (ObjectType(w)) {
		      case button:
		      case toggle:
		      case list:
		      case menuItem:
		      case grip:
			gettingcallback = True;
			XtCallCallbacks(w,XtNcallback,NULL);
			gettingcallback = False;
			result = XtNewString(callbackdata);
			XtFree(callbackdata);
			break;
		      case menuButton:
			XtVaGetValues(w,XtNmenuName,&value,NULL);
			result = XtNewString(value);
		      default:
			result = XtNewString("");
		}
	} else {
		result = XtMalloc(35*sizeof(char)+strlen(argv[0])+
				  strlen(argv[1]));
		sprintf (result,"Don't know how to '%s' for object %s\n.",
			 argv[0],argv[1]);
		Tcl_Return(interp,result,TCL_VOLATILE);
		XtFree(result);
		myreturn TCL_ERROR;
	}
	Tcl_Return(interp,result,TCL_VOLATILE);
	if (result && *result) {
		XtFree(result);
	}
	myreturn TCL_OK;
}

static int ParseGetBoolean(clientData,interp,argc,argv)
     char *clientData;
     Tcl_Interp *interp;
     int argc;
     char **argv;
     /* used for commands which get a single boolean resource for a widget:
	'getresource object-name' */
{
	Boolean b;
	Widget w;
	char result[MAXLINE],usage[MAXLINE];
	entering("ParseGetBoolean");
	sprintf(usage,"%s object-name",argv[0]);
	if (BadUsage(argc,2,usage,interp)) {
		myreturn TCL_ERROR;
	}
	if (!(w=WidgetExists(argv[1],interp))) {
		myreturn TCL_ERROR;
	}
	if (mystrcmp(argv[0],"getmappedwhenmanaged")==0) {
		XtVaGetValues(w,XtNmappedWhenManaged,&b,NULL);
	} else if (mystrcmp(argv[0],"getresize")==0) {
		/* for some reason, GetValues on XtNresize for text objects
		   overwrites the stack. */
		if (XtClass(w)!=scToolWidgetClass) {
			XtVaGetValues(w,XtNresize,&b,NULL);
		} else {
			b=NULL;
		}
	} else if (mystrcmp(argv[0],"getsensitive")==0) {
		XtVaGetValues(w,XtNsensitive,&b,NULL);
	} else if (mystrcmp(argv[0],"getforcecolumns")==0) {
		XtVaGetValues(w,XtNforceColumns,&b,NULL);
	} else if (mystrcmp(argv[0],"getstate")==0) {
		XtVaGetValues(w,XtNstate,&b,NULL);
	} else if (mystrcmp(argv[0],"getautofill")==0) {
		XtVaGetValues(w,XtNautoFill,&b,NULL);
	} else if (mystrcmp(argv[0],"getresizable")==0) {
		XtVaGetValues(w,XtNresizable,&b,NULL);
	} else if (mystrcmp(argv[0],"getallowresize")==0) {
		XtVaGetValues(w,XtNallowResize,&b,NULL);
	} else if (mystrcmp(argv[0],"getallowshellresize")==0) {
		XtVaGetValues(w,XtNallowShellResize,&b,NULL);
	} else if (mystrcmp(argv[0],"getshowgrip")==0) {
		XtVaGetValues(w,XtNshowGrip,&b,NULL);
	} else if (mystrcmp(argv[0],"getskipadjust")==0) {
		XtVaGetValues(w,XtNskipAdjust,&b,NULL);
	} else if (mystrcmp(argv[0],"getresizetopreferred")==0) {
		XtVaGetValues(w,XtNresizeToPreferred,&b,NULL);
	} else if (mystrcmp(argv[0],"getallowhoriz")==0) {
		XtVaGetValues(w,XtNallowHoriz,&b,NULL);
	} else if (mystrcmp(argv[0],"getallowvert")==0) {
		XtVaGetValues(w,XtNallowVert,&b,NULL);
	} else if (mystrcmp(argv[0],"getforcebars")==0) {
		XtVaGetValues(w,XtNforceBars,&b,NULL);
	} else if (mystrcmp(argv[0],"getusebottom")==0) {
		XtVaGetValues(w,XtNuseBottom,&b,NULL);
	} else if (mystrcmp(argv[0],"getuseright")==0) {
		XtVaGetValues(w,XtNuseRight,&b,NULL);
	} else {
		sprintf (result,"Don't know how to '%s' for object %s\n.",
			 argv[0],argv[1]);
		Tcl_Return(interp,result,TCL_VOLATILE);
		myreturn TCL_ERROR;
	}
	sprintf(result,"%d",(int)b);
	Tcl_Return(interp,result,TCL_VOLATILE);
	myreturn TCL_OK;
}

void AddWidgetGetCommands(interp)
     Tcl_Interp *interp;
{
	entering("AddWidgetGetCommands");

	/* create commands for getting resources:  getresource object value */

	CREATE("getlabel",ParseGetResource);
	CREATE("getx",ParseGetResource);
	CREATE("gety",ParseGetResource);
	CREATE("getheight",ParseGetResource);
	CREATE("getwidth",ParseGetResource);
	CREATE("getprogram",ParseGetResource);
	CREATE("getvalue",ParseGetResource);
	CREATE("getcallback",ParseGetResource);
	CREATE("getmenuname",ParseGetResource);
	CREATE("getfontheight",ParseGetResource);
	CREATE("getfontwidth",ParseGetResource);
	CREATE("getfromhoriz",ParseGetResource);
	CREATE("getlisthighlighted",ParseGetResource);
	CREATE("getborderwidth",ParseGetResource);

	/* create boolean commands for getting resources: 
	   getresource object [True|False] */

	CREATE("getmappedwhenmanaged",ParseGetBoolean);
	CREATE("getresize",ParseGetBoolean);
	CREATE("getsensitive",ParseGetBoolean);
	CREATE("getforcecolumns",ParseGetBoolean);
	CREATE("getstate",ParseGetBoolean);
	CREATE("getautofill",ParseGetBoolean);
	CREATE("getresizable",ParseGetBoolean);
	CREATE("getallowresize",ParseGetBoolean);
	CREATE("getallowshellresize",ParseGetBoolean);
	CREATE("getshowgrip",ParseGetBoolean);
	CREATE("getskipadjust",ParseGetBoolean);
	CREATE("getresizetopreferred",ParseGetBoolean);
	CREATE("getallowhoriz",ParseGetBoolean);
	CREATE("getallowvert",ParseGetBoolean);
	CREATE("getforcebars",ParseGetBoolean);
	CREATE("getusebottom",ParseGetBoolean);
	CREATE("getuseright",ParseGetBoolean);

	myreturn;
}
