#!/usr/local/bin/perl
# procextract.perl:  usage perl procextract.perl < alpal.setup
#
# extracts and sorts the proc descriptions in a tcl script.
# The proc description is:
#
# proc procname {arg1 arg2 ...} {
#	#
#	# comments
#	#
#	<blank line>
#

$flag = 0;

while (<>) {
    chop;	# strip record separator
    if (/^proc/) {
	$flag = 1;
	$l = length;
	$name = substr($_,5);
	$oneproc = substr($_, 0, $l - 1);
    } elsif (/^( |\t)+[^#]/) {
	if ($flag) {
	    $flag = 0;
	    $table{$name} = join("\n",$oneproc,"");
	}
    } elsif (/^( |\t)+#/) {
	if ($flag) {
	    $oneproc = join("\n",$oneproc,$_);
	}
    }
}
foreach $key (sort (keys %table)) {
    printf ("%s\n",$table{$key});
}