'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_TildeSubst.man,v 1.2 90/04/18 17:09:29 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_TildeSubst tcl
.VS
.BS
.SH NAME
Tcl_TildeSubst \- replace tilde with home directory in a file name
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
char *
\Tcl_TildeSubst\fR(\fIinterp\fR, \fIname\fR)
.SH ARGUMENTS
.AP Tcl_Interp *interp in
Interpreter in which to report an error, if any.
.AP char *name in
File name, which may start with a ``~''.
.BE

.SH DESCRIPTION
.PP
This utility procedure does tilde substition.  If \fIname\fR doesn't
start with a ``~'' character, then the procedure returns \fIname\fR.
If \fIname\fR does start with a tilde, then \fBTcl_TildeSubst\fR
returns a new string identical to \fIname\fR except that the first
element of \fIname\fR is replaced with the location of the home
directory for the given user.  The substitution is carried out in
the same way that it would be done by \fIcsh\fR.  If the tilde is
followed immediately by a slash, then the \fB$HOME\fR environment
variable is substituted.  Otherwise the characters between the
tilde and the next slash are taken as a user name, which is
looked up in the password file;  the user's home directory is
retrieved from the password file and substituted.
.PP
The string returned by \fBTcl_TildeSubst\fR is a static string
belonging to \fBTcl_TildeSubst\fR.  Its value will only persist
until the next call to \fBTcl_TildeSubst\fR;  the caller should
make a copy of the result if it needs to live a long time.
.PP
If an error occurs (e.g. because there was no user by the given
name) then NULL is returned and an error message will be left
at \fIinterp->result\fR.  It is assumed that \fIinterp->result\fR
has been initialized in the standard way when \fBTcl_TildeSubst\fR
is invoked.

.SH KEYWORDS
file name, home directory, tilde, user
.VE
