[manpage_begin cksum n 1.0]
[moddesc   {cksum}]
[titledesc {calculate a cksum(1) compatible checksum}]
[require Tcl 8.2]
[require cksum [opt 1.0]]
[description]
[para]

This package provides a Tcl-only implementation of the cksum(1)
algorithm based upon information provided at in the GNU implementation
of this program as part of the GNU Textutils 2.0 package.

[section COMMANDS]

[list_begin definitions]

[call [cmd ::crc::cksum] [opt "-format [arg format]"] [arg message]]
[call [cmd ::crc::cksum] [opt "-format [arg format]"] "-filename [arg file]"]

The command takes string data or a file name and returns a checksum
value calculated using the [strong cksum(1)] algorithm. The result is
formatted using the [arg format](n) specifier provided or as an
unsigned integer (%u) by default.

[list_end]

[section OPTIONS]

[list_begin definitions]

[lst_item "-filename [arg name]"]

Return a checksum for the file contents instead of for parameter data.

[lst_item "-format [arg string]"]

Return the checksum using an alternative format template.

[list_end]

[section EXAMPLES]

[para]
[example {
% crc::cksum "Hello, World!"
2609532967
}]

[para]
[example {
% crc::cksum -format 0x%X "Hello, World!"
0x9B8A5027
}]

[para]
[example {
% crc::cksum -file cksum.tcl
1828321145
}]

[see_also sum(n) crc32(n)]
[section AUTHORS]
Pat Thoyts

[keywords cksum checksum crc crc32 {cyclic redundancy check} {data integrity} security]
[manpage_end]

