[comment {-*- tcl -*- doctools manpage}]
[manpage_begin smtp n 1.3.2]
[moddesc   {smtp client}]
[titledesc {Client-side tcl implementation of the smtp protocol}]
[require Tcl]
[require mime [opt 1.3.2]]
[require smtp [opt 1.3.2]]
[description]
[para]

The [package smtp] library package provides the client side of the
smtp protocol.

[list_begin definitions]

[call [cmd ::smtp::sendmessage] [arg token] [arg option]...]

This command sends the MIME part (see package [package mime])
represented by [arg token] to an SMTP server. [arg options] is a list
of options and their associated values.  The recognized options are:

[list_begin definitions]

[lst_item [option -servers]]

A list of SMTP servers. The default is [strong localhost].

[lst_item [option -ports]]

A list of SMTP ports. The default is [strong 25].

[lst_item [option -queue]]

Indicates that the SMTP server should be asked to queue the message
for later processing. A boolean value.

[lst_item [option -atleastone]]

Indicates that the SMTP server must find at least one recipient
acceptable for the message to be sent. A boolean value.

[lst_item [option -originator]]

A string containing an 822-style address specification. If present the
header isn't examined for an originator address.

[lst_item [option -recipients]]

A string containing one or more 822-style address specifications. If
present the header isn't examined for recipient addresses). If the
string contains more than one address they will be separated by
commas.

[lst_item [option -header]]

A list of keywords and their values (may occur zero or more times).

[list_end]
[nl]

If the [option -originator] option is not present, the originator
address is taken from [strong From] (or [strong Resent-From]);
similarly, if the [option -recipients] option is not present,
recipient addresses are taken from [strong To], [strong cc], and
[strong Bcc] (or [strong Resent-To], and so on). Note that the header
key/values supplied by the [option -header] option (not those present
in the MIME part) are consulted. Regardless, header key/values are
added to the outgoing message as necessary to ensure that a valid
822-style message is sent.

[nl]

The command returns a list indicating which recipients were
unacceptable to the SMTP server. Each element of the list is another
list, containing the address, an SMTP error code, and a textual
diagnostic. Depending on the [option -atleastone] option and the
intended recipients, a non-empty list may still indicate that the
message was accepted by the server.

[list_end]

[see_also mime pop3 ftp http]
[keywords mail mail email smtp mime rfc821 rfc822 internet net]
[manpage_end]
