/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.UnaryMathFunction;

class SinhFunction
extends UnaryMathFunction {
    ExprValue apply(Interp interp, TclObject[] argv) throws TclException {
        double x = TclDouble.get((Interp)interp, (TclObject)argv[0]);
        double d1 = Math.pow(Math.E, x);
        double d2 = Math.pow(Math.E, -x);
        Expression.checkDoubleRange(interp, d1);
        Expression.checkDoubleRange(interp, d2);
        return new ExprValue((d1 - d2) / 2.0);
    }

    SinhFunction() {
    }
}

