#include <tcl.h>
/*
#include <bindata.h>
*/
#include <math.h>

#ifdef USE_DMALLOC
#include<dmalloc.h>
#endif

int
Tkgraph_LlimitCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
    int		xyflag = 0,
    		minflag = 1,
		maxflag = 1;
    int		i;
    Tcl_Obj	*objPtr = (Tcl_Obj *)NULL;
    double	x, y,
    		xmin, ymin,
		xmax, ymax;
    char	buf[TCL_DOUBLE_SPACE];
    int		targc = argc;
    int		largc = argc;
    int		nelem = argc;
    char	**targv = argv;
    char	**largv = argv;
    float	*objData = (float *)NULL;

    ++targv, --targc;

    largv = targv;
    largc = targc;
    while (targc && **targv == '-') {
	if (!strcmp(*targv, "-xy")) {
	    xyflag = 1;
	} else if (!strcmp(*targv, "-min")) {
	    minflag = 1, maxflag = 0;
	} else if (!strcmp(*targv, "-max")) {
	    maxflag = 1, minflag = 0;
	} else {
	    /* We found data.  set targc to 1 so we exit out of the loop */
	    /*
	    Tcl_AppendResult(interp, "Usage: \"", *argv,
		"?-xy? ?-min? ?-max? list\"", (char *)NULL);
	    return TCL_ERROR;
	    */
	    break;
	}
	++targv, --targc;
    }

    if (targc == 1) {
	if (Tcl_SplitList(interp, argv[0], &argc, &largv) != TCL_OK) {
	    if (largv != NULL) {
		ckfree((char *) largv);
	    }
	    return TCL_ERROR;
	}

	/* If we have one argument, then assume that it's a variable with
	 * binary data.
	 * Create the coordinate array from this object.  The idea is that
	 * we want to be able to pass the graph a pre-existing binary
	 * structure containing the coordinates so that creating a new
	 * dataset does not involve billions of calls to Tcl_GetDouble().
	 */

	if (targc == 1) {
	    Tcl_Obj	*part1 = Tcl_NewStringObj(targv[0], -1);

	    objPtr = Tcl_ObjGetVar2(interp, part1, (Tcl_Obj *)NULL, TCL_LEAVE_ERR_MSG);

	    if (objPtr == (Tcl_Obj *)NULL) {
		return TCL_ERROR;
	    }

	    objData = (float *)(Tcl_GetStringFromObj(objPtr, &nelem));

	    /*
	     * 4 is the size of a network float
	     */

	    nelem = nelem / 4;
	}
    } else {
	nelem = targc;
    }
    if (targc & 1 && (objPtr == (Tcl_Obj *)NULL)) {
	Tcl_AppendResult(interp,
		"odd number of coordinates specified for line",
		(char *) NULL);
	return TCL_ERROR;
    }

    if ((nelem < 1) || (xyflag && nelem < 2) || (xyflag && nelem%2)) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", *argv,
		"?-xy? ?-min? ?-max? list\"", (char *)NULL);
	return TCL_ERROR;
    }

    if (objPtr == NULL) {
	if (Tcl_GetDouble(interp, targv[0], &xmin) != TCL_OK)
	    return TCL_ERROR;
	if (xyflag) {
	    if (Tcl_GetDouble(interp, targv[1], &ymin) != TCL_OK)
		return TCL_ERROR;
	}
    } else {
	xmin = objData[0];
	ymin = objData[1];
    }
    xmax = xmin;
    ymax = ymin;

    for (i = 0; i < nelem; i++) {
	if (!objPtr) {
	    if (Tcl_GetDouble(interp, targv[i], &x) != TCL_OK)
		return TCL_ERROR;
	    xmin = (x < xmin)?x:xmin;
	    xmax = (x > xmax)?x:xmax;

	    if (xyflag) {
		if (Tcl_GetDouble(interp, targv[i+1], &y) != TCL_OK)
		    return TCL_ERROR;
		ymin = (y < ymin)?y:ymin;
		ymax = (y > ymax)?y:ymax;
		i++;
	    }
	} else {
	    printf("Checking %g, %g against %g\n", xmin, xmax, objData[i]);

	    if (objData[i] < xmin)
		xmin = objData[i];
	    if (objData[i] > xmax)
		xmax = objData[i];

	    if (xyflag) {
		if (objData[i+1] < ymin)
		    ymin = objData[i+1];
		if (objData[i+1] > ymax)
		    ymax = objData[i+1];
		i++;
	    }
	}
    }

    if (minflag) {
	Tcl_PrintDouble(interp, xmin, buf);
	Tcl_AppendElement(interp, buf);
	if (xyflag) {
	    Tcl_PrintDouble(interp, ymin, buf);
	    Tcl_AppendElement(interp, buf);
	}
    }
    if (maxflag) {
	Tcl_PrintDouble(interp, xmax, buf);
	Tcl_AppendElement(interp, buf);
	if (xyflag) {
	    Tcl_PrintDouble(interp, ymax, buf);
	    Tcl_AppendElement(interp, buf);
	}
    }

    return TCL_OK;
}

int
Tkgraph_TickroundCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv) {
    double a = 0.0;
    double b = 0.0;
    double t = 0.0;
    double l1 = 0.0;
    double l2 = 0.0;
    double nticks = 0.0;
    double interval = 0.0;
    double max = 0.0;
    double min = 0.0;
    double mantissa = 0.0;

    char result[TCL_DOUBLE_SPACE];

    if (argc != 3) {
	Tcl_AppendResult(interp, "Bad number of arguments.  Should be:  ", *argv, " a b", (char *)NULL);
	return TCL_ERROR;
    }

    if (Tcl_GetDouble(interp, argv[1], &a) != TCL_OK)
	return TCL_ERROR;
    if (Tcl_GetDouble(interp, argv[2], &b) != TCL_OK)
	return TCL_ERROR;

    if (a > b) {
	t = a;
	a = b;
	b = t;
    }

    if (a == b) {
	Tcl_PrintDouble(interp, a, result);
	Tcl_AppendElement(interp, result);
	Tcl_PrintDouble(interp, b, result);
	Tcl_AppendElement(interp, result);
	Tcl_AppendElement(interp, "0");
	Tcl_AppendElement(interp, "0");
	return TCL_OK;
    }

    l1 = log((b - a) / 2.0) / log(10.);
    l2 = 1.0;
    mantissa = l1 - floor(l1);

    if (mantissa > .87)
	l2 = 4.;
    else if (mantissa > .69897)
	l2 = 2.;
    else if (mantissa < .39794)
	l2 = .5;
    else if (mantissa < .2)
	l2 = .25;

    interval = pow(10, (double)(floor(l1))) * l2;
    max = ceil( (b + interval)/interval) * interval;
    min = ceil( (a - interval)/interval) * interval;
    nticks = ceil((max - min) / interval);

    if (min == -0.0) min = 0.0;

    Tcl_PrintDouble(interp, min, result);
    Tcl_AppendElement(interp, result);
    Tcl_PrintDouble(interp, max, result);
    Tcl_AppendElement(interp, result);
    Tcl_PrintDouble(interp, interval, result);
    Tcl_AppendElement(interp, result);
    Tcl_PrintDouble(interp, nticks, result);
    Tcl_AppendElement(interp, result);
    return TCL_OK;
}
