proc literal { name literal } {
    set data "class $name {double d = ${literal};}\n"
    return [compile [saveas $name.java $data] ]
}

tcltest::test 3.10.2-invalid-1 { Whole or fractional part must have a digit } {
    literal T3102i1 .e2
} FAIL

tcltest::test 3.10.2-invalid-2 { Whole or fractional part must have a digit } {
    literal T3102i2 .F
} FAIL

tcltest::test 3.10.2-invalid-3 { Invalid Digits } {
    literal T3102i3 E.1e20
} FAIL

tcltest::test 3.10.2-invalid-4 { ExponentPart must include a SignedInteger } {
    literal T3102i4 1.E
} FAIL

tcltest::test 3.10.2-invalid-5 { ExponentPart must include a SignedInteger } {
    literal T3102i5 1.e
} FAIL

tcltest::test 3.10.2-invalid-6 { ExponentPart must include a SignedInteger } {
    literal T3102i6 1.E+
} FAIL

tcltest::test 3.10.2-invalid-7 { ExponentPart must include a SignedInteger } {
    literal T3102i7 1.E-
} FAIL

tcltest::test 3.10.2-invalid-8 { ExponentPart must include a SignedInteger } {
    literal T3102i8 .1eF
} FAIL

tcltest::test 3.10.2-invalid-9 { ExponentPart must include a SignedInteger } {
    literal T3102i9 .1e-D
} FAIL

tcltest::test 3.10.2-invalid-10 { ExponentPart must include a SignedInteger } {
    literal T3102i10 1e-d
} FAIL

tcltest::test 3.10.2-invalid-11 { ExponentPart must include a SignedInteger } {
    literal T3102i11 .1e+F
} FAIL

# Error in case of invalid rounding

tcltest::test 3.10.2-round-1 { It is an error for a floating-point
        literal to round to an infinity } {
    literal T3102r1 1e39f
} FAIL

tcltest::test 3.10.2-round-2 { It is an error for a floating-point
        literal to round to an infinity } {
    literal T3102r2 -1e310
} FAIL

tcltest::test 3.10.2-round-3 { It is an error for a nonzero
        floating-point to round to zero } {
    literal T3102r3 1e-47f
} FAIL

tcltest::test 3.10.2-round-4 { It is an error for a nonzero
        floating-point to round to zero } {
    literal T3102r4 -1e-326
} FAIL

tcltest::test 3.10.2-round-5 { It is an error for a floating-point
        literal to round to an infinity } {
    literal T3102r5 340282356779733661637539395458142568448f
} FAIL

tcltest::test 3.10.2-round-6 { It is an error for a floating-point
        literal to round to an infinity } {
    literal T3102r6 179769313486231580793728971405303415079934132710037826936173778980444968292764750946649017977587207096330286416692887910946555547851940402630657488671505820681908902000708383676273854845817711531764475730270069855571366959622842914819860834936475292719074168444365510704342711559699508093042880177904174497792.0
} FAIL

tcltest::test 3.10.2-round-7 { It is an error for a nonzero
        floating-point to round to zero } {
    literal T3102r7 0.000000000000000000000000000000000000000000000700649232162408535461864791644958065640130970938257885878534141944895541342930300743319094181060791015625f
} FAIL

tcltest::test 3.10.2-round-8 { It is an error for a nonzero
        floating-point to round to zero } {
    literal T3102r8 0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000024703282292062327208828439643411068618252990130716238221279284125033775363510437593264991818081799618989828234772285886546332835517796989819938739800539093906315035659515570226392290858392449105184435931802849936536152500319370457678249219365623669863658480757001585769269903706311928279558551332927834338409351978015531246597263579574622766465272827220056374006485499977096599470454020828166226237857393450736339007967761930577506740176324673600968951340535537458516661134223766678604162159680461914467291840300530057530849048765391711386591646239524912623653881879636239373280423891018672348497668235089863388587925628302755995657524455507255189313690836254779186948667994968324049705821028513185451396213837722826145437693412532098591327667236328125
} FAIL
# Valid floating-point literals

tcltest::test 3.10.2-float-1 { example float literal } {
    literal T3102f1 1e1f
} PASS

tcltest::test 3.10.2-float-2 { example float literal } {
    literal T3102f2 2.f
} PASS

tcltest::test 3.10.2-float-3 { example float literal } {
    literal T3102f3 1.e-1
} PASS

tcltest::test 3.10.2-float-4 { example float literal } {
    literal T3102f4 .3F
} PASS

tcltest::test 3.10.2-float-5 { example float literal } {
    literal T3102f5 0f
} PASS

tcltest::test 3.10.2-float-6 { example float literal } {
    literal T3102f6 3.14f
} PASS

tcltest::test 3.10.2-float-7 { example float literal } {
    literal T3102f7 6.022137e+23f
} PASS

tcltest::test 3.10.2-float-8 { largest finite float, by JLS } {
    literal T3102f8 3.40282347e+38f
} PASS

tcltest::test 3.10.2-float-9 { smallest finite float } {
    literal T3102f9 1.40239846e-45f
} PASS

tcltest::test 3.10.2-float-10 { extra 0s don't affect floating point parsing } {
    literal T3102f10 000000000000000000000000000000000000000000000000000000000000000000000000.000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000e00000000000000000000000000000000050f
} PASS

tcltest::test 3.10.2-float-11 { unicode 1e0F } {
    literal T3102f11 {\u0031\u0065\u0030\u0046}
} PASS

tcltest::test 3.10.2-float-12 { largest finite float, by rounding } {
    constant_expression T3102f12 {340282356779733661637539395458142568447.99999f == Float.MAX_VALUE}
} PASS

tcltest::test 3.10.2-float-13 { smallest finite float, by rounding.
        errors: fail to parse number, round number to zero
        note: We can't compare to Float.MIN_VALUE because
        some stupid JDK versions don't use a constant value } {
    constant_expression T3102f13 {0.00000000000000000000000000000000000000000000070064923216240853546186479164495806564013097093825788587853414194489554134293030074331909418106079101562500001f != 0}
} PASS

tcltest::test 3.10.2-double-1 { example double literal } {
    literal T3102d1 1E1D
} PASS

tcltest::test 3.10.2-double-2 { example double literal } {
    literal T3102d2 2.
} PASS

tcltest::test 3.10.2-double-3 { example double literal } {
    literal T3102d3 .3
} PASS

tcltest::test 3.10.2-double-4 { example double literal } {
    literal T3102d4 0.0
} PASS

tcltest::test 3.10.2-double-5 { example double literal } {
    literal T3102d5 3.14
} PASS

tcltest::test 3.10.2-double-6 { example double literal } {
    literal T3102d6 1e-9d
} PASS

tcltest::test 3.10.2-double-7 { example double literal } {
    literal T3102d7 1e137
} PASS

tcltest::test 3.10.2-double-8 { largest finite double, by JLS } {
    literal T3102d8 1.79769313486231570e+308
} PASS

tcltest::test 3.10.2-double-9 { smallest finite double } {
    literal T3102d9 4.94065645841246544e-324
} PASS
 
tcltest::test 3.10.2-double-10 { the compiler should correctly
        round denormalized literals } {
    constant_expression T3102d10 {.0000000000012345678901234567890e+10 ==
	    1.2345678901234568e-2}
} PASS

tcltest::test 3.10.2-double-11 { extra 0s don't affect floating point parsing } {
    literal T3102d11 000000000000000000000000000000000000000000000000000000000000000000000000.000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000e00000000000000000000000000000000050
} PASS

tcltest::test 3.10.2-double-12 { unicode escape the . in float 1.0 } {
    literal T3102d12 1\u002e0
} PASS

tcltest::test 3.10.2-double-13 { largest finite double, by rounding } {
    constant_expression T3102d13 {179769313486231580793728971405303415079934132710037826936173778980444968292764750946649017977587207096330286416692887910946555547851940402630657488671505820681908902000708383676273854845817711531764475730270069855571366959622842914819860834936475292719074168444365510704342711559699508093042880177904174497791.999999 == Double.MAX_VALUE}
} PASS

tcltest::test 3.10.2-double-14 { smallest finite double, by rounding
        errors: fail to parse number, round number to zero
        note: We can't compare to Double.MIN_VALUE because
        some stupid JDK versions don't use a constant value } {
    constant_expression T3102d14 {0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002470328229206232720882843964341106861825299013071623822127928412503377536351043759326499181808179961898982823477228588654633283551779698981993873980053909390631503565951557022639229085839244910518443593180284993653615250031937045767824921936562366986365848075700158576926990370631192827955855133292783433840935197801553124659726357957462276646527282722005637400648549997709659947045402082816622623785739345073633900796776193057750674017632467360096895134053553745851666113422376667860416215968046191446729184030053005753084904876539171138659164623952491262365388187963623937328042389101867234849766823508986338858792562830275599565752445550725518931369083625477918694866799496832404970582102851318545139621383772282614543769341253209859132766723632812500001 != 0}
} PASS

