tcltest::test 7.5.1-1 {Doing an import of a class that does not exist should fail} {
    compile [saveas FailImportDoesNotExist.java \
{
package foo;

import a_class_that_does_not_exist;

public class FailImportDoesNotExist extends Object;
}]
} FAIL

tcltest::test 7.5.1-2 {Extend a public class in the
    default package with a class in another package} {
    saveas ClassInDefaultPackage.java \
{
public class ClassInDefaultPackage {}

class ClassInDefaultPackage_Test extends ClassInDefaultPackage {}
}

    saveas ClassInDefaultPackage_ImportFromGlobal.java \
{
package foo;

import ClassInDefaultPackage;

public class ClassInDefaultPackage_ImportFromGlobal
    extends ClassInDefaultPackage {}
}

    compile ClassInDefaultPackage.java ClassInDefaultPackage_ImportFromGlobal.java
} PASS

tcltest::test 7.5.1-3 {Importing a non public class from the global package should fail} {
    saveas ClassInDefaultPackage_FailImportFromGlobal.java \
{
package foo;

import ClassInDefaultPackage_Test;

public class ClassInDefaultPackage_FailImportFromGlobal
    extends ClassInDefaultPackage_Test {}
}

    compile ClassInDefaultPackage.java ClassInDefaultPackage_FailImportFromGlobal.java
} FAIL

# FIXME : add tests for import of package from another package (not the global)
# and tests for importing of an interface

# FIXME : add test case for importing the same simple name from two packages
# also test that a duplicate import of the exact same class is ignored

# FIXME : add test case for error where the simple name is already used
# in the compilation unit when the import is done (class FOO ; import FOO)
