#!/bin/sh
# \
exec wish "$0" ${1+"$@"}

#
# FROGGER
#
# A tclet/app variant of the classic game by Donal Fellows.
# http://www.cs.man.ac.uk/~fellowsd/tcl/breakout.html
#
# Copyright (c) 2000 Donal Fellows
#
# RCS: @(#) $Id: frogger.tcl,v 1.1 2001/11/07 22:30:33 hobbs Exp $

proc rand {{range 100}} {expr {int(rand()*$range)}}

# ----------------------------------------------------------------------
# Load the images

array set imagedata {
    frog,n,image {
#define frog-n_width 32
#define frog-n_height 32
static unsigned char frog-n_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x01, 0x00, 0x40, 0xe2, 0x47, 0x02, 0x48, 0xe1, 0x87, 0x12,
    0x50, 0xf1, 0x8f, 0x0a, 0xe0, 0xc8, 0x13, 0x07, 0xc0, 0xc5, 0xa3, 0x03,
    0xe0, 0xe4, 0x27, 0x07, 0x70, 0xfc, 0x3f, 0x0e, 0x70, 0xfc, 0x3f, 0x0e,
    0xe0, 0xfe, 0x7f, 0x07, 0x40, 0xff, 0xff, 0x02, 0x80, 0xff, 0xff, 0x01,
    0xc0, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0x03, 0xe4, 0xff, 0xff, 0x27,
    0xe8, 0xff, 0xff, 0x17, 0xe8, 0xff, 0xff, 0x17, 0xe0, 0xff, 0xff, 0x07,
    0xe0, 0xff, 0xff, 0x07, 0xc0, 0xff, 0xff, 0x03, 0xd0, 0xff, 0xff, 0x0b,
    0x90, 0xff, 0xff, 0x09, 0x70, 0xff, 0xff, 0x0e, 0xf0, 0xfc, 0x3f, 0x0f,
    0xf0, 0x00, 0x00, 0x0f, 0x70, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    frog,s,image {
#define frog-s_width 32
#define frog-s_height 32
static unsigned char frog-s_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x70, 0x00, 0x00, 0x0e, 0xf0, 0x00, 0x00, 0x0f, 0xf0, 0xfc, 0x3f, 0x0f,
    0x70, 0xff, 0xff, 0x0e, 0x90, 0xff, 0xff, 0x09, 0xd0, 0xff, 0xff, 0x0b,
    0xc0, 0xff, 0xff, 0x03, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
    0xe8, 0xff, 0xff, 0x17, 0xe8, 0xff, 0xff, 0x17, 0xe4, 0xff, 0xff, 0x27,
    0xc0, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0x03, 0x80, 0xff, 0xff, 0x01,
    0x40, 0xff, 0xff, 0x02, 0xe0, 0xfe, 0x7f, 0x07, 0x70, 0xfc, 0x3f, 0x0e,
    0x70, 0xfc, 0x3f, 0x0e, 0xe0, 0xe4, 0x27, 0x07, 0xc0, 0xc5, 0xa3, 0x03,
    0xe0, 0xc8, 0x13, 0x07, 0x50, 0xf1, 0x8f, 0x0a, 0x48, 0xe1, 0x87, 0x12,
    0x40, 0xe2, 0x47, 0x02, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    frog,e,image {
#define frog-e_width 32
#define frog-e_height 32
static unsigned char frog-e_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
    0x00, 0x30, 0x00, 0x04, 0xf8, 0x01, 0x30, 0x02, 0x78, 0x7c, 0x78, 0x01,
    0x78, 0xff, 0xfd, 0x0f, 0xb0, 0xff, 0xcb, 0x01, 0xc0, 0xff, 0x87, 0x06,
    0xc0, 0xff, 0x0f, 0x08, 0xe0, 0xff, 0xff, 0x00, 0xe0, 0xff, 0x3f, 0x01,
    0xe0, 0xff, 0x3f, 0x02, 0xe0, 0xff, 0x7f, 0x0e, 0xe0, 0xff, 0xff, 0x0f,
    0xe0, 0xff, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0x0f,
    0xe0, 0xff, 0x7f, 0x0e, 0xe0, 0xff, 0x3f, 0x02, 0xe0, 0xff, 0x3f, 0x01,
    0xe0, 0xff, 0xff, 0x00, 0xc0, 0xff, 0x0f, 0x08, 0xc0, 0xff, 0x87, 0x06,
    0xb0, 0xff, 0xcb, 0x01, 0x78, 0xff, 0xfd, 0x0f, 0x78, 0x7c, 0x78, 0x01,
    0xf8, 0x01, 0x30, 0x02, 0x00, 0x30, 0x00, 0x04, 0x00, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    frog,w,image {
#define frog-w_width 32
#define frog-w_height 32
static unsigned char frog-w_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x20, 0x00, 0x0c, 0x00, 0x40, 0x0c, 0x80, 0x1f, 0x80, 0x1e, 0x3e, 0x1e,
    0xf0, 0xbf, 0xff, 0x1e, 0x80, 0xd3, 0xff, 0x0d, 0x60, 0xe1, 0xff, 0x03,
    0x10, 0xf0, 0xff, 0x03, 0x00, 0xff, 0xff, 0x07, 0x80, 0xfc, 0xff, 0x07,
    0x40, 0xfc, 0xff, 0x07, 0x70, 0xfe, 0xff, 0x07, 0xf0, 0xff, 0xff, 0x07,
    0xf8, 0xff, 0xff, 0x07, 0xf8, 0xff, 0xff, 0x07, 0xf0, 0xff, 0xff, 0x07,
    0x70, 0xfe, 0xff, 0x07, 0x40, 0xfc, 0xff, 0x07, 0x80, 0xfc, 0xff, 0x07,
    0x00, 0xff, 0xff, 0x07, 0x10, 0xf0, 0xff, 0x03, 0x60, 0xe1, 0xff, 0x03,
    0x80, 0xd3, 0xff, 0x0d, 0xf0, 0xbf, 0xff, 0x1e, 0x80, 0x1e, 0x3e, 0x1e,
    0x40, 0x0c, 0x80, 0x1f, 0x20, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }

    frog,n,mask {
#define frog-n-mask_width 32
#define frog-n-mask_height 32
static unsigned char frog-n-mask_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x01, 0x00, 0x40, 0xe2, 0x47, 0x02, 0x48, 0xe1, 0x87, 0x12,
    0x50, 0xf1, 0x8f, 0x0a, 0xe0, 0xf8, 0x1f, 0x07, 0xc0, 0xfd, 0xbf, 0x03,
    0xe0, 0xfc, 0x3f, 0x07, 0x70, 0xfc, 0x3f, 0x0e, 0x70, 0xfc, 0x3f, 0x0e,
    0xe0, 0xfe, 0x7f, 0x07, 0xc0, 0xff, 0xff, 0x03, 0x80, 0xff, 0xff, 0x01,
    0xc0, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0x03, 0xf4, 0xff, 0xff, 0x2f,
    0xe8, 0xff, 0xff, 0x17, 0xe8, 0xff, 0xff, 0x17, 0xf0, 0xff, 0xff, 0x0f,
    0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
    0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xfd, 0xbf, 0x0f,
    0xf0, 0x00, 0x00, 0x0f, 0x70, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    frog,s,mask {
#define frog-s-mask_width 32
#define frog-s-mask_height 32
static unsigned char frog-s-mask_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x70, 0x00, 0x00, 0x0e, 0xf0, 0x00, 0x00, 0x0f, 0xf0, 0xfd, 0xbf, 0x0f,
    0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
    0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
    0xe8, 0xff, 0xff, 0x17, 0xe8, 0xff, 0xff, 0x17, 0xf4, 0xff, 0xff, 0x2f,
    0xc0, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0x03, 0x80, 0xff, 0xff, 0x01,
    0xc0, 0xff, 0xff, 0x03, 0xe0, 0xfe, 0x7f, 0x07, 0x70, 0xfc, 0x3f, 0x0e,
    0x70, 0xfc, 0x3f, 0x0e, 0xe0, 0xfc, 0x3f, 0x07, 0xc0, 0xfd, 0xbf, 0x03,
    0xe0, 0xf8, 0x1f, 0x07, 0x50, 0xf1, 0x8f, 0x0a, 0x48, 0xe1, 0x87, 0x12,
    0x40, 0xe2, 0x47, 0x02, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    frog,e,mask {
#define frog-e-mask_width 32
#define frog-e-mask_height 32
static unsigned char frog-e-mask_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
    0x00, 0x30, 0x00, 0x04, 0xf8, 0x4f, 0x30, 0x02, 0xf8, 0x7f, 0x78, 0x01,
    0xf8, 0xff, 0xfd, 0x0f, 0xf0, 0xff, 0xcf, 0x01, 0xe0, 0xff, 0x87, 0x06,
    0xc0, 0xff, 0x0f, 0x08, 0xe0, 0xff, 0xff, 0x00, 0xe0, 0xff, 0xff, 0x01,
    0xe0, 0xff, 0xff, 0x03, 0xe0, 0xff, 0xff, 0x0f, 0xe0, 0xff, 0xff, 0x0f,
    0xe0, 0xff, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0x0f,
    0xe0, 0xff, 0xff, 0x0f, 0xe0, 0xff, 0xff, 0x03, 0xe0, 0xff, 0xff, 0x01,
    0xe0, 0xff, 0xff, 0x00, 0xc0, 0xff, 0x0f, 0x08, 0xe0, 0xff, 0x87, 0x06,
    0xf0, 0xff, 0xcf, 0x01, 0xf8, 0xff, 0xfd, 0x0f, 0xf8, 0x7f, 0x78, 0x01,
    0xf8, 0x4f, 0x30, 0x02, 0x00, 0x30, 0x00, 0x04, 0x00, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    frog,w,mask {
#define frog-w-mask_width 32
#define frog-w-mask_height 32
static unsigned char frog-w-mask_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x20, 0x00, 0x0c, 0x00, 0x40, 0x0c, 0xf2, 0x1f, 0x80, 0x1e, 0xfe, 0x1f,
    0xf0, 0xbf, 0xff, 0x1f, 0x80, 0xf3, 0xff, 0x0f, 0x60, 0xe1, 0xff, 0x07,
    0x10, 0xf0, 0xff, 0x03, 0x00, 0xff, 0xff, 0x07, 0x80, 0xff, 0xff, 0x07,
    0xc0, 0xff, 0xff, 0x07, 0xf0, 0xff, 0xff, 0x07, 0xf0, 0xff, 0xff, 0x07,
    0xf8, 0xff, 0xff, 0x07, 0xf8, 0xff, 0xff, 0x07, 0xf0, 0xff, 0xff, 0x07,
    0xf0, 0xff, 0xff, 0x07, 0xc0, 0xff, 0xff, 0x07, 0x80, 0xff, 0xff, 0x07,
    0x00, 0xff, 0xff, 0x07, 0x10, 0xf0, 0xff, 0x03, 0x60, 0xe1, 0xff, 0x07,
    0x80, 0xf3, 0xff, 0x0f, 0xf0, 0xbf, 0xff, 0x1f, 0x80, 0x1e, 0xfe, 0x1f,
    0x40, 0x0c, 0xf2, 0x1f, 0x20, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    car,image {
#define limo_width 64
#define limo_height 32
static unsigned char limo_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x40, 0x80,
    0x03, 0x08, 0x30, 0x00, 0x00, 0x00, 0x60, 0xbf, 0xfb, 0xeb, 0x6f, 0x00,
    0x00, 0x00, 0xa0, 0xbf, 0xfb, 0xeb, 0x5f, 0x00, 0x00, 0x00, 0xb0, 0xbf,
    0xfb, 0xeb, 0xdf, 0x00, 0x00, 0x00, 0xd0, 0xbf, 0xfb, 0xeb, 0xbf, 0x00,
    0x00, 0x00, 0xd8, 0xbf, 0xfb, 0xeb, 0xbf, 0x01, 0x00, 0x00, 0xe8, 0xbf,
    0xfb, 0xeb, 0x7f, 0x01, 0xfc, 0xff, 0x0f, 0x80, 0x03, 0x08, 0x00, 0x3f,
    0xfe, 0xff, 0xef, 0xbf, 0xfb, 0xfb, 0xff, 0x7f, 0xfe, 0xff, 0xef, 0xbf,
    0xfb, 0xfb, 0xff, 0x7f, 0xff, 0xff, 0xef, 0xbf, 0xfb, 0xfb, 0xff, 0x7f,
    0xfe, 0xff, 0xef, 0xbf, 0xfb, 0xfb, 0xff, 0x7f, 0x3f, 0xf8, 0xef, 0xbf,
    0xfb, 0x1b, 0x1c, 0x7c, 0x9e, 0xf3, 0xef, 0xbf, 0xfb, 0xcd, 0xc9, 0x79,
    0xcf, 0xe7, 0xef, 0xbf, 0xfb, 0xe5, 0xe3, 0x73, 0xee, 0xef, 0x0f, 0x80,
    0x03, 0xf4, 0xf7, 0x77, 0xee, 0xef, 0xff, 0xff, 0xff, 0xf7, 0xf7, 0x77,
    0xe0, 0x0f, 0x00, 0x00, 0x00, 0xf0, 0xf7, 0xe7, 0xc0, 0x07, 0x00, 0x00,
    0x00, 0xe0, 0xe3, 0x03, 0x80, 0x03, 0x00, 0x00, 0x00, 0xc0, 0xc1, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00};
    }
    car,mask {
#define limo-mask_width 64
#define limo-mask_height 32
static unsigned char limo-mask_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0xc0, 0xff,
    0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0x7f, 0x00,
    0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0xf0, 0xff,
    0xff, 0xff, 0xff, 0x00, 0x10, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x00,
    0x18, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x01, 0x10, 0x00, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0x01, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x3f, 0xf8, 0xff, 0xff,
    0xff, 0x1f, 0x1c, 0x7c, 0x9f, 0xf3, 0xff, 0xff, 0xff, 0xcf, 0xc9, 0x79,
    0xcf, 0xe7, 0xff, 0xff, 0xff, 0xe7, 0xe3, 0x73, 0xef, 0xef, 0xff, 0xff,
    0xff, 0xf7, 0xf7, 0x77, 0xee, 0xef, 0xff, 0xff, 0xff, 0xf7, 0xf7, 0x77,
    0xe0, 0x0f, 0x00, 0x00, 0x00, 0xf0, 0xf7, 0xe7, 0xc0, 0x07, 0x00, 0x00,
    0x00, 0xe0, 0xe3, 0x03, 0x80, 0x03, 0x00, 0x00, 0x00, 0xc0, 0xc1, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00};
    }
    bus,image {
#define bus_width 64
#define bus_height 40
static unsigned char bus_bits[] = {
   0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x39, 0x70, 0xe0, 0xc0,
   0x81, 0x03, 0x07, 0x8e, 0x39, 0x70, 0xe0, 0xc0, 0x81, 0x03, 0x07, 0x8e,
   0x39, 0x70, 0xe0, 0xc0, 0x81, 0x03, 0x07, 0x8e, 0x39, 0x70, 0xe0, 0xc0,
   0x81, 0x03, 0x07, 0x8e, 0x39, 0x70, 0xe0, 0xc0, 0x81, 0x03, 0x07, 0x8e,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xfe, 0xff, 0xf0,
   0xff, 0xff, 0xff, 0xe7, 0xb7, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xe7,
   0xb7, 0xbe, 0xf5, 0x5e, 0xe7, 0x18, 0xb3, 0xe6, 0xc7, 0x8e, 0xf5, 0x98,
   0x5a, 0x6b, 0x2d, 0xe5, 0xf7, 0xb6, 0xf5, 0xde, 0x5b, 0x6b, 0xb1, 0xe7,
   0xf7, 0xb6, 0xf3, 0xde, 0xdb, 0x18, 0xbd, 0xff, 0xf7, 0x4d, 0xf7, 0xde,
   0xe7, 0x7b, 0xa3, 0xe7, 0xff, 0xff, 0xf9, 0xff, 0x7f, 0x8c, 0xff, 0xe7,
   0xc1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x81, 0x03, 0x07,
   0x0e, 0x1c, 0x38, 0x8e, 0xc1, 0x81, 0x03, 0x07, 0x0e, 0x1c, 0x38, 0x8e,
   0xc1, 0x81, 0x03, 0x07, 0x0e, 0x1c, 0x38, 0x8e, 0xc1, 0x81, 0x03, 0x07,
   0x0e, 0x1c, 0x38, 0x8e, 0xc1, 0x81, 0x03, 0x07, 0x0e, 0x1c, 0x38, 0x8e,
   0xc1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xc1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xc1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xc1, 0xc1, 0xff, 0xff, 0xff, 0xff, 0x83, 0xff,
   0xc1, 0x80, 0xff, 0xff, 0xff, 0xff, 0x01, 0xff, 0x41, 0x00, 0xff, 0xff,
   0xff, 0xff, 0x00, 0xfe, 0x41, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0xfe,
   0x7f, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    bus,mask {
#define bus-mask_width 64
#define bus-mask_height 40
static unsigned char bus-mask_bits[] = {
   0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x39, 0x70, 0xe0, 0xc0,
   0x81, 0x03, 0x07, 0x8e, 0x39, 0x70, 0xe0, 0xc0, 0x81, 0x03, 0x07, 0x8e,
   0x39, 0x70, 0xe0, 0xc0, 0x81, 0x03, 0x07, 0x8e, 0x39, 0x70, 0xe0, 0xc0,
   0x81, 0x03, 0x07, 0x8e, 0x39, 0x70, 0xe0, 0xc0, 0x81, 0x03, 0x07, 0x8e,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81, 0x03, 0x07,
   0x0e, 0x1c, 0x38, 0x8e, 0xff, 0x81, 0x03, 0x07, 0x0e, 0x1c, 0x38, 0x8e,
   0xff, 0x81, 0x03, 0x07, 0x0e, 0x1c, 0x38, 0x8e, 0xff, 0x81, 0x03, 0x07,
   0x0e, 0x1c, 0x38, 0x8e, 0xff, 0x81, 0x03, 0x07, 0x0e, 0x1c, 0x38, 0x8e,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0x83, 0xff,
   0xff, 0x9c, 0xff, 0xff, 0xff, 0xff, 0x39, 0xff, 0x7f, 0x3e, 0xff, 0xff,
   0xff, 0xff, 0x7c, 0xfe, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe,
   0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0x00, 0x7f, 0x00, 0x00,
   0x00, 0x00, 0xfe, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
   0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00};
    }
    lorry,image {
#define lorry_width 64
#define lorry_height 40
static unsigned char lorry_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
   0xff, 0x3f, 0x00, 0x00, 0xff, 0xf8, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00,
   0xc3, 0x18, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xff, 0xf8, 0xff, 0xff,
   0xff, 0x3f, 0x00, 0x00, 0x63, 0x32, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00,
   0x7f, 0xf2, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x63, 0x32, 0x00, 0x00,
   0x00, 0x38, 0x00, 0x00, 0x7f, 0xf2, 0xff, 0xff, 0xff, 0xbf, 0xff, 0x01,
   0x7f, 0x72, 0x00, 0x00, 0x00, 0xb8, 0x03, 0x02, 0x3f, 0xe7, 0xff, 0xff,
   0xff, 0xbf, 0x03, 0x02, 0x3f, 0xe7, 0xff, 0xff, 0xff, 0xbf, 0x03, 0x04,
   0x3f, 0xe7, 0xff, 0xff, 0xff, 0xbf, 0x03, 0x04, 0x3f, 0xe7, 0xc3, 0xf9,
   0x0c, 0xb8, 0x03, 0x08, 0x3f, 0xe7, 0x81, 0x71, 0x0c, 0xbc, 0x03, 0x08,
   0x9f, 0xcf, 0xb9, 0x21, 0xcc, 0xbf, 0x03, 0x10, 0x9f, 0xcf, 0xf9, 0x89,
   0x0c, 0xbf, 0x03, 0x20, 0x9f, 0xcf, 0xf9, 0xd9, 0x0c, 0xbf, 0x03, 0x20,
   0x9f, 0xcf, 0xb9, 0xf9, 0xcc, 0xbf, 0x03, 0x40, 0x9f, 0xcf, 0x81, 0xf9,
   0x0c, 0xbc, 0x03, 0x40, 0xcf, 0x81, 0xc3, 0xf9, 0x0c, 0xb8, 0xff, 0xff,
   0x0f, 0x80, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0x0f, 0x9e, 0xff, 0xff,
   0xff, 0xb7, 0xff, 0xff, 0xcf, 0x9f, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff,
   0xcf, 0x9f, 0x03, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xe7, 0x3f, 0xff, 0xff,
   0xff, 0xbf, 0xff, 0xff, 0xe7, 0x3f, 0x03, 0x00, 0x00, 0xb8, 0xff, 0xff,
   0xe7, 0x3f, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    lorry,mask {
#define lorry-mask_width 64
#define lorry-mask_height 40
static unsigned char lorry-mask_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
   0xff, 0x3f, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
   0xff, 0x3f, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
   0xff, 0x3f, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x02, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x03, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x04,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x04, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x03, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x08,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x10, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x03, 0x20, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x20,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x40, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x03, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0x83, 0x83, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1,
   0x39, 0x39, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x7c, 0x7c, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x3e, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f,
   0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0xfe, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x7f, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e,
   0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c};
    }
    reeds,image {
#define reeds_width 16
#define reeds_height 16
static unsigned char reeds_bits[] = {
   0x00, 0x04, 0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
   0x90, 0x00, 0x90, 0x00, 0x90, 0x00, 0x94, 0x30, 0xa2, 0x40, 0xa2, 0x40,
   0xa2, 0x82, 0x92, 0x62, 0x92, 0x11, 0xff, 0xff};
    }
    sand,image {
#define sand_width 16
#define sand_height 16
static unsigned char sand_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xf9, 0xfc, 0x00, 0x20, 0x00};
    }
    w1,image {
#define w1_width 16
#define w1_height 16
static unsigned char w1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0,
   0x38, 0x38, 0x3e, 0x3e, 0x33, 0x33, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    w2,image {
#define w2_width 16
#define w2_height 16
static unsigned char w2_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x20, 0x20, 0x6c, 0x6c, 0x73, 0x73, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    w3,image {
#define w3_width 16
#define w3_height 16
static unsigned char w3_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x0c, 0x0c, 0xf3, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    w4,image {
#define w4_width 16
#define w4_height 16
static unsigned char w4_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x18, 0x18, 0x0e, 0x0e, 0x33, 0x33, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    log1,image {
#define log-1_width 64
#define log-1_height 24
static unsigned char log-1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x67,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x37, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xc0, 0x81, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0x07,
   0x00, 0x00, 0x00, 0x00, 0xf0, 0xcd, 0x71, 0x00, 0x00, 0x00, 0x00, 0x80,
   0x3f, 0xf7, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xc7, 0xfd, 0x00, 0x00,
   0x00, 0x06, 0x60, 0xfc, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x07, 0x9e, 0x3f,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0xe3, 0x2f, 0xc3, 0xf9, 0x07, 0x00, 0x00,
   0x80, 0xfd, 0xe2, 0xff, 0x83, 0x39, 0x18, 0x00, 0xe0, 0x82, 0xff, 0x67,
   0x78, 0xce, 0x33, 0x00, 0xf8, 0xf9, 0x5f, 0x00, 0xc0, 0x3f, 0x7f, 0x00,
   0xc4, 0xff, 0x00, 0x00, 0x00, 0xec, 0xe3, 0x00, 0x8e, 0x2f, 0x00, 0x00,
   0x00, 0x00, 0x7c, 0x00, 0x10, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    log1,mask {
#define log-1-mask_width 64
#define log-1-mask_height 24
static unsigned char log-1-mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x7f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xc0, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07,
   0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x80,
   0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x00, 0x00,
   0x00, 0x06, 0x60, 0xfc, 0xff, 0x01, 0x00, 0x00, 0x00, 0x07, 0xfe, 0xff,
   0x7f, 0x00, 0x00, 0x00, 0x00, 0xe3, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00,
   0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0xff, 0x67,
   0xf8, 0xff, 0x3f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0xc0, 0xff, 0xff, 0x00,
   0xfc, 0xff, 0x00, 0x00, 0x00, 0xec, 0xff, 0x03, 0xfe, 0x2f, 0x00, 0x00,
   0x00, 0x00, 0xfc, 0x03, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    log2,image {
#define log-2_width 64
#define log-2_height 24
static unsigned char log-2_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xc0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
   0x80, 0x0f, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0xe0, 0x01, 0xff, 0x03,
   0x10, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x81, 0xff, 0xef, 0x29, 0x24, 0x00,
   0x7e, 0xe0, 0xbf, 0x6c, 0x7f, 0xff, 0xff, 0x3f, 0x0c, 0x9f, 0x67, 0xd7,
   0x1c, 0x1f, 0x2e, 0x70, 0xf0, 0x1f, 0xf8, 0x38, 0xfd, 0xf4, 0xff, 0x5e,
   0xf0, 0xfc, 0xff, 0xff, 0x60, 0xeb, 0xe0, 0x7f, 0x00, 0x00, 0xfc, 0x00,
   0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    log2,mask {
#define log-2-mask_width 64
#define log-2-mask_height 24
static unsigned char log-2-mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xc0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
   0x80, 0x0f, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00,
   0x70, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x29, 0x24, 0x00,
   0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x7f, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
   0xf0, 0xfc, 0xff, 0xff, 0xe0, 0xff, 0xe0, 0x7f, 0x00, 0x00, 0xfc, 0x00,
   0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    croc,1,image {
#define croc-1_width 64
#define croc-1_height 24
static unsigned char croc-1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x1a, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xfb, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xfe, 0xdf, 0x17, 0xf8, 0x40, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    croc,1,mask {
#define croc-mask-1_width 64
#define croc-mask-1_height 24
static unsigned char croc-mask-1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x1e, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xfe, 0xdf, 0x17, 0xf8, 0x40, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    croc,2,image {
#define croc-2_width 64
#define croc-2_height 24
static unsigned char croc-2_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x1a, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xfb, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x3f, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
   0xfe, 0xdf, 0x17, 0xf8, 0x40, 0xf8, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    croc,2,mask {
#define croc-mask-2_width 64
#define croc-mask-2_height 24
static unsigned char croc-mask-2_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x1e, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x3f, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
   0xfe, 0xdf, 0x17, 0xf8, 0x40, 0xf8, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    croc,3,image {
#define croc-1_width 64
#define croc-1_height 24
static unsigned char croc-1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x1a, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xfb, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xfe, 0xdf, 0x17, 0xf8, 0x40, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    croc,3,mask {
#define croc-mask-1_width 64
#define croc-mask-1_height 24
static unsigned char croc-mask-1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x1e, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xfe, 0xdf, 0x17, 0xf8, 0x40, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    croc,4,image {
#define croc-3_width 64
#define croc-3_height 24
static unsigned char croc-3_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x07,
   0x00, 0x00, 0x00, 0xc0, 0x0c, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0x70,
   0x1a, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x3f, 0xfb, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
   0xfe, 0xdf, 0x17, 0xf8, 0x40, 0xf8, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    croc,4,mask {
#define croc-mask-3_width 64
#define croc-mask-3_height 24
static unsigned char croc-mask-3_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x07,
   0x00, 0x00, 0x00, 0xc0, 0x0c, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0x70,
   0x1e, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x3f, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
   0xfe, 0xdf, 0x17, 0xf8, 0x40, 0xf8, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
    heron,e,image {
#define heron-e_width 32
#define heron-e_height 44
static unsigned char heron-e_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00,
   0x00, 0x00, 0x73, 0x00, 0x00, 0x80, 0xf3, 0x07, 0x00, 0xc0, 0xff, 0x7f,
   0x00, 0x20, 0x1f, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x00, 0x08, 0x0f, 0x00,
   0x00, 0x04, 0x06, 0x00, 0x00, 0x04, 0x06, 0x00, 0x00, 0x00, 0x06, 0x00,
   0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00,
   0x00, 0x80, 0x1d, 0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
   0x00, 0xb8, 0x0f, 0x00, 0x00, 0xdc, 0x0d, 0x00, 0x00, 0xec, 0x05, 0x00,
   0x00, 0xf6, 0x01, 0x00, 0x00, 0xfb, 0x01, 0x00, 0x80, 0xfd, 0x01, 0x00,
   0xc0, 0xfd, 0x01, 0x00, 0xe0, 0xfe, 0x00, 0x00, 0xf0, 0xfe, 0x00, 0x00,
   0x78, 0x6f, 0x00, 0x00, 0x7c, 0x63, 0x00, 0x00, 0xb8, 0x41, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
   0x00, 0x00, 0x1d, 0x00, 0x00, 0xc0, 0x30, 0x00};
    }
    heron,e,mask {
#define heron-e-mask_width 32
#define heron-e-mask_height 44
static unsigned char heron-e-mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00,
   0x00, 0x00, 0x7f, 0x00, 0x00, 0x80, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x7f,
   0x00, 0x20, 0x1f, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x00, 0x08, 0x0f, 0x00,
   0x00, 0x04, 0x06, 0x00, 0x00, 0x04, 0x06, 0x00, 0x00, 0x00, 0x06, 0x00,
   0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00,
   0x00, 0x80, 0x1d, 0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
   0x00, 0xf8, 0x0f, 0x00, 0x00, 0xfc, 0x0f, 0x00, 0x00, 0xfc, 0x07, 0x00,
   0x00, 0xfe, 0x03, 0x00, 0x00, 0xff, 0x01, 0x00, 0x80, 0xff, 0x01, 0x00,
   0xc0, 0xff, 0x01, 0x00, 0xe0, 0xff, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00,
   0xf8, 0x6f, 0x00, 0x00, 0x7c, 0x63, 0x00, 0x00, 0xb8, 0x61, 0x00, 0x00,
   0x00, 0x60, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
   0x00, 0x50, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00,
   0x00, 0x98, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00,
   0x00, 0x30, 0x01, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x20, 0x02, 0x00,
   0x00, 0xe0, 0x1d, 0x00, 0x00, 0x3c, 0x37, 0x00};
    }
    heron,w,image {
#define heron-w_width 32
#define heron-w_height 44
static unsigned char heron-w_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00,
   0x00, 0xce, 0x00, 0x00, 0xe0, 0xcf, 0x01, 0x00, 0xfe, 0xff, 0x03, 0x00,
   0x00, 0xf8, 0x04, 0x00, 0x00, 0xf0, 0x08, 0x00, 0x00, 0xf0, 0x10, 0x00,
   0x00, 0x60, 0x20, 0x00, 0x00, 0x60, 0x20, 0x00, 0x00, 0x60, 0x00, 0x00,
   0x00, 0x20, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00,
   0x00, 0xb8, 0x01, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0xf8, 0x0f, 0x00,
   0x00, 0xf0, 0x1d, 0x00, 0x00, 0xb0, 0x3b, 0x00, 0x00, 0xa0, 0x37, 0x00,
   0x00, 0x80, 0x6f, 0x00, 0x00, 0x80, 0xdf, 0x00, 0x00, 0x80, 0xbf, 0x01,
   0x00, 0x80, 0xbf, 0x03, 0x00, 0x00, 0x7f, 0x07, 0x00, 0x00, 0x7f, 0x0f,
   0x00, 0x00, 0xf6, 0x1e, 0x00, 0x00, 0xc6, 0x3e, 0x00, 0x00, 0x82, 0x1d,
   0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
   0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0xb8, 0x00, 0x00, 0x00, 0x0c, 0x03, 0x00};
    }
    heron,w,mask {
#define heron-w-mask_width 32
#define heron-w-mask_height 44
static unsigned char heron-w-mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00,
   0x00, 0xfe, 0x00, 0x00, 0xe0, 0xff, 0x01, 0x00, 0xfe, 0xff, 0x03, 0x00,
   0x00, 0xf8, 0x04, 0x00, 0x00, 0xf0, 0x08, 0x00, 0x00, 0xf0, 0x10, 0x00,
   0x00, 0x60, 0x20, 0x00, 0x00, 0x60, 0x20, 0x00, 0x00, 0x60, 0x00, 0x00,
   0x00, 0x20, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00,
   0x00, 0xb8, 0x01, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0xf8, 0x0f, 0x00,
   0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0xe0, 0x3f, 0x00,
   0x00, 0xc0, 0x7f, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x80, 0xff, 0x01,
   0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x0f,
   0x00, 0x00, 0xf6, 0x1f, 0x00, 0x00, 0xc6, 0x3e, 0x00, 0x00, 0x86, 0x1d,
   0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x1a, 0x00,
   0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x09, 0x00,
   0x00, 0x80, 0x0c, 0x00, 0x00, 0x40, 0x04, 0x00, 0x00, 0x40, 0x04, 0x00,
   0x00, 0xb8, 0x07, 0x00, 0x00, 0xec, 0x3c, 0x00};
    }
    bullet,image {
#define bullet.xbm_width 7
#define bullet.xbm_height 7
static unsigned char bullet.xbm_bits[] = {
   0x1c, 0x3e, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c};
    }
}
foreach dir {n s e w} {
    image create bitmap frog-$dir \
	    -data $imagedata(frog,$dir,image) -foreground green4 \
	    -maskdata $imagedata(frog,$dir,mask) -background black
}
foreach {i f b} {
    car black grey25
    bus red black
    lorry yellow black
    log1 brown black
    log2 brown black
} {
    image create bitmap $i -data $imagedata($i,image) -foreground $f \
	    -maskdata $imagedata($i,mask) -background $b
}
foreach {i f} {
    reeds green3
    sand yellow
    w1 skyblue
    w2 skyblue
    w3 skyblue
    w4 skyblue
    bullet black
} {
    image create bitmap $i -data $imagedata($i,image) -foreground $f
}
foreach {ib c f b} {
    croc 4 darkolivegreen black
} {
    for {set i 1} {$i<=$c} {incr i} {
	image create bitmap $ib-$i \
		-data $imagedata($ib,$i,image)    -foreground $f \
		-maskdata $imagedata($ib,$i,mask) -background $b
    }
}
foreach d {e w} {
    image create bitmap heron-$d \
	    -data $imagedata(heron,$d,image)    -foreground grey45 \
	    -maskdata $imagedata(heron,$d,mask) -background grey15
}

# ----------------------------------------------------------------------

# I would like to say something like:
#     [eval .c find overlapping [.c bbox frog] && withtag obstacle]
# or
#     [.c find closest $x $y 10 && withtag obstacle]

proc listfrogtags {} {
    set t {nothing}
    foreach id [eval .c find overlapping [.c bbox frog]] {
	append t " [.c gettags $id]"
    }
    return $t
}
proc listspottags {x y} {
    set t {nothing}
    foreach id [.c find overlapping \
	    [expr {$x-10}] [expr {$y-10}] [expr {$x+10}] [expr {$y+10}]] {
	append t " [.c gettags $id]"
    }
    return $t
}

# ----------------------------------------------------------------------

proc movetraffic {y r tag d t} {
    global after
    if {$d>0} {
	.c move $tag 5 0
	if {![string match *$tag* [listspottags 0 $y]] && [rand $r]<1} {
	    if {[catch {
		.c create image -30 $y -image $tag -tags $tag
	    }]} {
		.c create rectangle -62 [expr {$y-22}] 2 [expr {$y+22}] \
			-outline red -fill yellow -tags $tag
	    }
	}
	eval .c delete [.c find enclosed 251 0 500 450]
    } else {
	.c move $tag -5 0
	if {![string match *$tag* [listspottags 250 $y]] && [rand $r]<1} {
	    if {[catch {
		.c create image 280 $y -image $tag -tags $tag
	    }]} {
		.c create rectangle 312 [expr {$y-22}] 248 [expr {$y+22}] \
			-outline red -fill yellow -tags $tag
	    }
	}
	eval .c delete [.c find enclosed -1 0 -250 450]
    }
    if {[string match *$tag* [listfrogtags]]} {
	die $tag "Splat! Roadkill..."
    }
    set after($tag) [after $t movetraffic $y $r $tag $d $t]
}

proc moveheron {r d t dn} {
    global after
    if {[rand $r]<1} {
	if {[string match *heron* [listspottags 0 225]]} {
	    set d 5
	    set dn e
	} elseif {[string match *heron* [listspottags 250 225]]} {
	    set d -5
	    set dn w
	}
	.c move heron $d 0
	.c itemconf heron -image heron-$dn
    }
    if {[string match *heron* [listfrogtags]]} {
	die heron "Eaten by the heron! "
    }
    set after(heron) [after $t moveheron $r $d $t $dn]
}

proc movelog {y r tag d t {ani 0} {c 1} {map {xyzzy}}} {
    global after
    if {$d>0} {
	if {[string match *$tag* [listfrogtags]]} {.c move frog 5 0}
	.c move $tag 5 0
	if {![string match *$tag* [listspottags 0 $y]] && [rand $r]<1} {
	    if {[catch {
		.c lower [.c create image -30 $y -image [lindex $map 0] -tags "$tag $tag-anim"] frog
	    }]} {
		.c lower [.c create rectangle -62 [expr {$y-22}] 2 [expr {$y+22}] \
			-outline black -fill brown -tags $tag] frog
	    }
	}
	eval .c delete [.c find enclosed 251 0 500 450]
    } else {
	if {[string match *$tag* [listfrogtags]]} {.c move frog -5 0}
	.c move $tag -5 0
	if {![string match *$tag* [listspottags 250 $y]] && [rand $r]<1} {
	    if {[catch {
		.c lower [.c create image 280 $y -image [lindex $map 0] -tags "$tag $tag-anim"] frog
	    }]} {
		.c lower [.c create rectangle 312 [expr {$y-22}] \
			248 [expr {$y+22}] -outline black -fill brown \
			-tags $tag] frog
	    }
	}
	eval .c delete [.c find enclosed -1 0 -250 450]
    }
    .c itemconf $tag-anim -image [lindex $map $ani]
    foreach {x1 y1 x2 y2} [.c bbox frog] {break}
    if {$x1<0} {
	die left "Drowned..."
    } elseif {$x2>250} {
	die right "Drowned..."
    }
    incr ani
    if {$ani>=$c} {set ani 0}
    set after($tag) [after $t [list movelog $y $r $tag $d $t $ani $c $map]]
}

# ----------------------------------------------------------------------

proc movefrog {dir dx dy} {
    .c move frog $dx $dy
    .c itemconf frog -image frog-$dir
    foreach {x1 y1 x2 y2} [.c bbox frog] {break}
    if {$x1<0 || $y1<0 || $x2>250 || $y2>450} {
	.c move frog [expr {-$dx}] [expr {-$dy}]
    }
    switch -glob [listfrogtags] {
	*car* {
	    die car "Splat! Roadkill..."
	}
	*bus* {
	    die bus "Splat! Roadkill..."
	}
	*lorry* {
	    die lorry "Splat! Roadkill..."
	}
	*croc* - *log* {
	    #ignore the water when on a log
	}
	*water* {
	    die water "Drowned..."
	}
	*heron* {
	    die heron "Eaten by the heron! "
	}
	*win* {
	    die winner "You win! "
	}
    }
}

# ----------------------------------------------------------------------

proc animatewater {t {stage 1}} {
    global after
    .c itemconf aniwater -image w$stage
    .c move aniwater 5 0
    foreach item [.c find enclosed 250 0 300 450] {
	if {[string match *aniwater* [.c gettags $item]]} {
	    .c move $item -265 0
	}
    }
    incr stage; if {$stage>4} {set stage 1}
    set after(aniwater) [after $t animatewater $t $stage]
}

# ----------------------------------------------------------------------

proc die {tag string} {
    global after
    # puts $string
    focus .
    foreach {k id} [array get after] {after cancel $id}
    unset after
    switch $tag {
	winner {
	    set id [.c create text 125 225 -font *Adobe*Helvetica*Bold*O*240* \
		    -text $string -fill red]
	    eval .c create rectangle [.c bbox $id] -outline blue -fill yellow
	}
	default {
	    set id [.c create text 125 225 -font *Adobe*Helvetica*Bold*O*240* \
		    -text $string -fill white]
	    eval .c create rectangle [.c bbox $id] -outline white -fill black
	}
    }
    .c raise $id
    after 5000 init restart
    return -code return "exit the caller!"
}

# ----------------------------------------------------------------------

proc init {action} {
    switch $action {
	clear {
	    # clear anything previously there
	    global after
	    .c delete all
	    foreach {k id} [array get after] {after cancel $id}
	    foreach b [bind .c] {bind .c $b {}}
	}
	scene {
	    # set up the display
	    foreach {y d c t} {
		0 50 green3 win
		50 150 blue2 water
		200 50 green3 {}
		250 150 grey50 {}
		400 50 green3 {}
	    } {
		.c create rectangle 0 $y 250 [expr {$y+$d}] -outline {} \
			-fill $c -tags $t
	    }
	    .c create rectangle 0 297 250 299 -outline {} -fill white
	    .c create rectangle 0 301 250 303 -outline {} -fill white
	    for {set x 5} {$x<250} {incr x 30} {
		.c create rectangle $x 349 [expr {$x+20}] 351 \
			-outline {} -fill white
	    }
	    .c create rectangle 0 247 250 251 -outline {} -fill grey50
	    .c create rectangle 0 399 250 403 -outline {} -fill grey50
	    for {set x 1} {$x<250} {incr x 10} {
		.c create rectangle $x 247 [expr {$x+9}] 251 \
			-outline {} -fill grey85
		.c create rectangle $x 399 [expr {$x+9}] 403 \
			-outline {} -fill grey85
	    }
	    for {set x 7} {$x<259} {incr x 16} {
		.c create image $x 48 -image sand -tags sand
		.c create image $x 193 -image reeds -tags reeds
	    }
	    .c lower sand; .c raise sand water
	    foreach {x y} {35 75  50 175  106 125  161 175  177 75  222 125} {
		.c create image $x $y -image w1 -tags aniwater
	    }
	    .c lower aniwater; .c raise aniwater water
	    # create the frog
	    .c lower [.c create image 125 425 -image frog-n -tags frog] reeds
	    # start the traffic
	    movetraffic 275 30 car  -1 25
	    movetraffic 325 40 bus   1 50
	    movetraffic 375 50 lorry 1 75
	    # start the heron
	    .c create image 35 225 -image heron-e -tags heron
	    moveheron 4 5 100 e
	    # start the logs and 'gators
	    movelog  75 60 log1  1 80 0 1 log1
	    movelog 125 70 croc -1 100 0 10 {
		croc-1 croc-1 croc-1 croc-1 croc-1
		croc-2 croc-2 croc-3 croc-4 croc-4
	    }
	    movelog 175 80 log2  1 70 0 1 log2
	    # start the background animations
	    animatewater 250
	}
	instructions {
	    frame .i;lower .i
	    grid .i -row 0 -column 0
	    if {[info tclversion] < 8.0} {
		text .i.t -background white -width 20 -height 6 -wrap word -cursor {}
	    } else {
		text .i.t -background white -width 30 -height 7 -wrap word -cursor {}
	    }
	    pack .i.t -fill x -expand 1 -side top

	    .i.t tag conf head -font *Adobe*Helvetica*Bold*O*240* \
		    -justify center -spacing1 2 -spacing3 2 -foreground red3
	    .i.t tag conf body -font *Adobe*Times*Medium*R*140* \
		    -justify left -spacing1 2 -spacing2 1 -spacing3 2 \
		    -lmargin1 22 -lmargin2 3 -rmargin 3 -foreground black

	    .i.t insert end "Frogger!\n" head
	    .i.t insert end "Get your frog across the busy road and river any way you can (using the cursor keys to move.)  Don't forget that:\n" body
	    .i.t insert end " Drivers love to squash frogs, as roadkill forms a major part of their diet,\n" body
	    .i.t insert end " Herons love to eat frogs, especially with ketchup,\n" body
	    .i.t insert end " You cannot swim for some reason,\n" body
	    .i.t insert end " You can travel on the back of a crocodile as well as on a log, though I don't know why the crocs don't eat the frogs, and\n" body
	    .i.t insert end " Going off the edge of the screen is fatal too...\n" body
	    foreach l {3 4 5 6 7} {
		.i.t window create $l.0 -create \
			[list label .i.t.$l -image bullet -background white]
	    }
	    for {set h 8} {[.i.t dlineinfo end-1c] == ""} {incr h} {
		.i.t conf -height $h
		update idletasks
	    }
	    .i.t conf -state disabled
	    button .i.dismiss -text "OK! Play the game..." \
		    -command {destroy .i;init motion}
	    pack .i.dismiss -fill x -expand 1 -side top
	    update idletasks
	    raise .i
	    #tkwait window .i
	}
	motion {
	    # allow the frog to move...
	    focus .c
	    bind .c <Left>  {movefrog w -25   0}
	    bind .c <Right> {movefrog e  25   0}
	    bind .c <Up>    {movefrog n   0 -50}
	    bind .c <Down>  {movefrog s   0  50}
	}
	restart {
	    init clear
	    init scene
	    init motion
	}
    }
}

# ----------------------------------------------------------------------

set tk_strictMotif 1

catch {destroy .c}
canvas .c -width 250 -height 450 -highlightthick 0
catch {init clear}
grid .c
catch {wm title . "Frogger!"}
catch {wm iconname . "Frogger"}
catch {wm resizable . 0 0}
catch {wm protocol . WM_DELETE_WINDOW {init clear; exit}}

init scene
init instructions
