'\"
'\" @(#) bargraph.man 2.0
'\"
.TH bargraph n 2.0 Tk "Tk bargraph widget"
.HS bargraph tk
.BS
.SH NAME
::vu::bargraph \- Create and manipulate bargraph widgets
.SH SYNOPSIS
\fB::vu::bargraph\fI \fIpathName \fR?\fIoptions\fR?
.SO
\-background	\-borderWidth	\-cursor
\-highlightbackground	\-highlightcolor	\-highlightthickness
\-font	\-foreground
\-orient	\-relief	\-takefocus
.SE

.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-alabels alabels Alabels
In addition to the regularly-spaced ticks that can be controlled with the
\fI\-tickinterval\fR option, arbitrarily-positioned labels and/or ticks can
be placed along the length of the bar.
The \fILabelList\fR specifies positions, labels, and ticks along the top
[left] side of the bar for horizontal [vertical] bars.
See \fI\-blabels\fR for the right or bottom side of the bar.
The value is a Tcl compound list:
.ti +0.2i
\-alabels { {\fIposn\fP \fItxt\fP ?usetick?} ...}
.br
where \fIposn\fR is a value between the \fIminval\fR and \fImaxval\fR of
the widget, \fItxt\fR is a text string to be drawn beside that position,
and \fIusetick\fR is a boolean flag which if set indicates that a tick mark
should be placed at \fIposn\fR.
.br
This option does not affect the regularly-spaced ticks
that are controlled with the \fI\-tickinterval\fR option.
.br
Example:
.ti +0.5i
\-alabels {{20 start 1} {40 "halfway"} {60 end 1}}
.br
This will cause labels to be written beside positions 20, 50, and 60.
Ticks will additionally be drawn at positions 20 and 60.
.OP \-alabfont alabFont AlabFont
The font used for the \fI\-alabels\fR text.
.OP \fB\-barbackground barBackground BarBackground
Specifies the background color for the bar region.
Defaults to regular background color.
.OP \-barborderwidth barBorderwidth BarBorderwidth
Specifies the width of a bar border. Default 2 pixels.
.OP \fB\-barcolor barColor BarColor
Specifies the color in which the bargraph bars should be rendered.
Defaults to red.
.OP \-barrelief barRelief BarRelief
Specifies the relief of the bars.  Must be a valid Tk relief value.
.OP \-base base Base
Specifies where the origin of the bar is.
It should be a value between \fI\-from\fR and \fI\-to\fR.
Default is 0.0.
Ticks are drawn as offsets from \fI\-base\fR.
For example,
.ti +0.5i
\-base 33.33 -tickinterval 10
.br
will give tick marks at 33.33, 43.33, 53.33,\ ...
.OP \-blabels blabels Blabels
Like \fI\-alabels\fR, except it is for the right [bottom] side of the bar
when the orientation is vertical [horizontal].
.OP \-blabfont blabFont BlabFont
The font used for the \fI\-blabels\fR text.
.OP \-digits digits Digits
An integer specifying how many significant digits should be retained
when converting the value of the dial to a string.
If the number is less than or equal to zero, then the dial picks
the smallest value that guarantees that every possible dial
position prints as a different string.
Default is 6.
.OP \-from from From
Specifies the starting value which be displayed at the bottom (or
the left of a horizontal bargraph) of a bargraph.
If \fI\-from\fR is greater than \fI\-to\fR
then the bargraph will grow \fIbackwards\fR.
Default is 0.0.
.OP \-height height Height
Specifies the height in pixels a bar should be when displaying the maximum
value (\fIi.e.\fP the maximum height of a bar).
The option \fI\-length\fR is a synonym for \fI\-height\fR.
Default 100 pixels.
.OP \-label label Label
This string is placed at the top of the widget.
Specifying the empty string will remove the label.
Defaults to {}.
.OP \-mode mode Mode
The bargraph can work in one of two modes: if the \fImodename\fR is
\(lqbargraph\(rq, the bar grows from the \fIbaseval\fR to the current
value.  In mode \(lqslider\(rq, a slider of fixed width travels along the
bar area with its center point indicating the current value.
.OP \-padx padX Pad
Specifies internal widget padding between central bar and labels in
the horizontal space.
Default 2 pixels.
.OP \-pady padY Pad
Specifies internal widget padding between central bar and labels in
the vertical space.
Default 2 pixels.
.OP \-showrange showRange ShowRange
Specifies whether labels for \fI\i-from\fR and \fI\-to\fR will be displayed.
Default is 1.
.OP \-showvalue showValue ShowValue
Specifies whether the current value to which the bargraph is set
will be displayed.  Default is 1.
.OP \-sliderlength sliderLength SliderLength
If the bargraph is in slider mode (see \fI\-mode\fP), the length of
the slider (in pixels) is set by this option.  Default 10 pixels.
.OP \-tickcolor tickColor TickColor
Specifies the color in which bargraph ticks should be rendered.
Defaults to blue.
.OP \-tickinterval tickInterval TickInterval
Specifies the interval between successive ticks.  Default 20.0.
The default doesn't depend on the range of data, and if there are too
many pixels, the widget will generate an error and you will have to
increase the \fI\-tickinterval\fR.
Specify 0 to indicate no ticks at all.
This option doesn't affect the ticks drawn with the \fI\-alabels\fR
or \fI\-blabels\fR options.
.OP \-ticklength tickLength TickLength
Specifies the length of all tick marks.  Default 4 pixels.
.OP \-to\ to To
Specifies the value to be displayed at the top (or the right of a
horizontal bargraph) of a bargraph.  If \fI\-from\fR is greater than
\fI\-to\fR then the bargraph will grow \fIbackwards\fR.
Default is 100.0.
.OP \-width width Width
Specifies the width of a bar in pixels. Default 20 pixels.
.BE

.SH DESCRIPTION
.PP
The \fB::vu::bargraph\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a bargraph widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the bargraph
such as its colors, font, text, and initial relief.  The
\fB::vu::bargraph\fR command returns its \fIpathName\fR argument.  At the
time this command is invoked, there must not exist a window named
\fIpathName\fR, but \fIpathName\fR's parent must exist.
.PP
A bargraph is a widget that displays a value as a bargraph.

.SH "WIDGET COMMAND"
.PP
The \fB::vu::bargraph\fR command creates a new Tcl command whose name is
\fIpathName\fR.  This command may be used to invoke various operations
on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following commands are possible for bargraph widgets:
.TP
\fIpathName \fBset\fR ?\fIvalue\fR?
Display a bar whose height represents the specified value.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given by
.IR option .
.I Option
may have any of the values accepted by the
.I ::vu::bargraph
command.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.  If
no \fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fB::vu::bargraph\fR command.
.TP
\fIpathName \fBget\fR
Returns the current value of the bargraph.

.SH KEYWORDS
bargraph, widget
