/*
 * pkgInit.c - a widget extension for Tk
 *
 * RCS: @(#) $Id: pkgInit.c,v 1.11 2003/07/09 01:48:37 hobbs Exp $
 */

#include "pkg.h"

Tk_CustomOption customTagsOption = {
    (Tk_OptionParseProc *) NULL,
    (Tk_OptionPrintProc *) NULL,
    (ClientData) NULL
};

/* Function to call on loading the module */

#ifdef BUILD_vu
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif

#ifdef MAC_TCL
#pragma export on
#endif
EXTERN int
Vu_Init(interp)
    Tcl_Interp *interp;
{
    int major, minor, patchlevel, release;
#undef USE_NAMESPACE_CODE
#ifdef USE_NAMESPACE_CODE
    Tcl_Namespace *nsPtr;
#endif

#include "pkgInitScript.h"

    if (
#ifdef USE_TCL_STUBS
	Tcl_InitStubs(interp, "8.0", 0)
#else
	Tcl_PkgRequire(interp, "Tcl", "8.0", 0)
#endif
	== NULL) {
	return TCL_ERROR;
    }
    if (
#ifdef USE_TK_STUBS
	Tk_InitStubs(interp, "8.0", 0)
#else
#    if (TK_MAJOR_VERSION == 8) && (TK_MINOR_VERSION == 0)
	/* We require 8.0 exact because of the Unicode in 8.1+ */
	Tcl_PkgRequire(interp, "Tk", "8.0", 1)
#    else
	Tcl_PkgRequire(interp, "Tk", "8.0", 0)
#    endif
#endif
	== NULL) {
	return TCL_ERROR;
    }
    if (Tcl_PkgProvide(interp, PACKAGE, VU_VERSION) != TCL_OK) {
	return TCL_ERROR;
    }

    Tcl_CreateObjCommand(interp, "::vu::dial", Tk_DialObjCmd,
	    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

#ifdef USE_NAMESPACE_CODE
    /*
     * The first create will create the namespace.  Now cache it
     * for the export calls.
     */
    nsPtr = (Tcl_Namespace *)Tcl_FindNamespace(interp, "::vu",
	    (Tcl_Namespace *) NULL, TCL_LEAVE_ERR_MSG);
    if (nsPtr == NULL) {
	return TCL_ERROR;
    }
    Tcl_Export(interp, nsPtr, "dial", 0 /* dontResetList */);
#endif

    Tcl_CreateObjCommand(interp, "::vu::pie", Tk_PieObjCmd,
	    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
#ifdef USE_NAMESPACE_CODE
    Tcl_Export(interp, nsPtr, "pie", 0);
#endif

    Tcl_CreateObjCommand(interp, "::vu::bargraph", Tk_BargraphObjCmd,
	    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
#ifdef USE_NAMESPACE_CODE
    Tcl_Export(interp, nsPtr, "bargraph", 0);
#endif

#ifdef HAVE_MEGAWIDGET
    Tcl_CreateObjCommand(interp, "::vu::megawidget", Tk_MegawidgetObjCmd,
	    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
#endif
#ifdef USE_NAMESPACE_CODE
    Tcl_Export(interp, nsPtr, "widget", 0);
#endif

#ifdef HAVE_COMBOBOX
    Tcl_CreateObjCommand(interp, "::vu::combo", Tk_ComboObjCmd,
	    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
#ifdef USE_NAMESPACE_CODE
    Tcl_Export(interp, nsPtr, "combo", 0);
#endif
#endif

    /*
     * Get the version so we can runtime switch on available functionality.
     */
    Tcl_GetVersion(&major, &minor, &patchlevel, &release);

#ifdef HAVE_SPINBOX
    if ((major == 8) && (minor >= 1)) {
	/*
	 * spinbox is a core widget in 8.4
	 */
	Tcl_CreateObjCommand(interp, "::vu::spinbox", Vu_SpinboxObjCmd,
		(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
#ifdef USE_NAMESPACE_CODE
	Tcl_Export(interp, nsPtr, "spinbox", 0);
#endif
    }
#endif

    if (customTagsOption.parseProc == NULL) {
	customTagsOption.parseProc = Tk_CanvasTagsParseProc;
	customTagsOption.printProc = Tk_CanvasTagsPrintProc;
    }

    Tk_CreateItemType((Tk_ItemType *) &TkCanvStripchartType);
    Tk_CreateItemType((Tk_ItemType *) &TkCanvBarchartType);
#ifdef HAVE_STICKER_ITEM
    /*
     * This doesn't really work right, due to the unfinished XGetImage
     * implementation on Win/Mac
     */
    Tk_CreateItemType((Tk_ItemType *) &TkCanvStickerType);
#endif
#ifdef HAVE_LABEL_ITEM
    /*
     * This works, but requires internal Tk headers.
     */
    Tk_CreateItemType((Tk_ItemType *) &TkCanvLabelType);
#endif
    return Tcl_Eval(interp, initScript);
}

EXTERN int
Vu_SafeInit(interp)
    Tcl_Interp *interp;
{
    return Vu_Init(interp);
}
#ifdef MAC_TCL
#pragma export reset
#endif

#ifdef _WIN32
/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

BOOL APIENTRY
DllEntryPoint(hInst, reason, reserved)
    HINSTANCE hInst;		/* Library instance handle. */
    DWORD reason;		/* Reason this function is being called. */
    LPVOID reserved;		/* Not used. */
{
    return TRUE;
}
#endif
