'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) tkerror.n 1.14 96/03/26 18:28:36
'\" 
.so man.macros
.TH tkerror n 4.0 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tkerror \- Command invoked to process background errors
.SH SYNOPSIS
\fBtkerror \fImessage\fR
.BE

.SH DESCRIPTION
.PP
The \fBtkerror\fR command doesn't exist as built-in part of Tk.  Instead,
individual applications or users can define a \fBtkerror\fR
command (e.g. as a Tcl procedure) if they wish to handle background
errors.
.PP
A background error is one that occurs in a command that didn't
originate with the application.  For example, if an error occurs
while executing a command specified with a \fBbind\fR of \fBafter\fR
command, then it is a background error.  For a non-background error,
the error can simply be returned up through nested Tcl command
evaluations until it reaches the top-level code in the application;
then the application can report the error in whatever way it
wishes.  When a background error occurs, the unwinding ends in
the Tk library and there is no obvious way for Tk to report
the error.
.PP
.VS
When Tk detects a background error, it saves information about the
error and invokes the \fBtkerror\fR command later when Tk is idle.
Before invoking \fBtkerror\fR, Tk restores the \fBerrorInfo\fR
and \fBerrorCode\fR variables to their values at the time the
error occurred, then it invokes \fBtkerror\fR with
.VE
the error message as its only argument.
Tk assumes that the application has implemented the \fBtkerror\fR
command, and that the command will report the error in a way that
makes sense for the application.  Tk will ignore any result returned
by the \fBtkerror\fR command.
.PP
If another Tcl error occurs within the \fBtkerror\fR command
(for example, because no \fBtkerror\fR command has been defined)
then Tk reports the error itself by writing a message to stderr.
.PP
.VS
If several background errors accumulate before \fBtkerror\fR
is invoked to process them, \fBtkerror\fR will be invoked once
for each error, in the order they occurred.
However, if \fBtkerror\fR returns with a break exception, then
any remaining errors are skipped without calling \fBtkerror\fR.
.VE
.PP
The Tk script library includes a default \fBtkerror\fR procedure
that posts a dialog box containing the error message and offers
the user a chance to see a stack trace showing where the
error occurred.

.SH KEYWORDS
background error, reporting
