# Bindings for query/replace


if {([bind all <Control-s>] == "")} {puts "You will also have to load the searchbindings"}


proc undo_replace {t replacements} {
	foreach replacement $replacements {
		eval undo_filter $t $replacement
}}


proc search_same_direction {t f} {
	set direction [lindex [$f.s configure -text] 4]
	global reverse_search_msg reverse_search_failed_msg
	if {($direction == $reverse_search_msg) || ($direction == $reverse_search_failed_msg)} {
		$t mark set insert {insert +1 chars}
		uplevel #0 [bind $f.ss <Control-r>]
	} else {$t mark set insert {insert -1 chars}
		uplevel #0 [bind $f.ss <Control-s>]
}}

# The string to be replaced (it's bound to the replace entry)
set replace_string ""
# Number of replacements made
set replace_count 0

# For undoing replace. Replacements is a list, each entry is a list of three
# items, the starting mark, the ending mark, and the replaced text.
set all_replacements {}
# All the marks used in the current replace operation.
set all_replacement_marks {}

proc replace_one {t f} {
	global replace_string replace_count
	set old_stuff [$t get search.first search.last]
	$t delete search.first search.last
	$t insert insert $replace_string ; incr replace_count
	global modified ; set modified 1

	global all_replacements all_replacement_marks
	set m1 [gensym] ; set m2 [gensym]
	$t mark set $m1 "insert -[string length $replace_string] chars"
	$t mark set $m2 insert
	set replacement [list $m1 $m2 $old_stuff]
	$t tag add was_replaced $m1 $m2
	lappend all_replacements $replacement
	lappend all_replacement_marks $m1 $m2

	$t mark set insert "insert -1 chars"
	search_same_direction $t $f
}

proc replace_to_end {t f} {
	while {![catch {$t index search.first}]} {replace_one $t $f}
	exit_search $t $f x
	exit_replace $t $f x
}

proc replace_this_one {t f} {
	if {![catch {$t index search.first}]} {replace_one $t $f
	} else {beep ; 	search_same_direction $t $f
}}

proc exit_replace {t f c} {
	if {![regexp . $c]} {return}
	destroy_f_entry $t $f.r $f.rs
	global replace_count
	flash_label $f -text "Replaced $replace_count occurrences."
	$t tag remove was_replaced 1.0 end

	global all_replacements all_replacement_marks
	global search_string replace_string
	register_undoable_cmd $t [list undo_replace $t $all_replacements] "Replace $search_string with $replace_string" $all_replacement_marks
	global menu ; menuentries_change_state $menu.search.m disabled 8 9 10
	foreach binding [bind $t] {	bind $t $binding ""
}} 

# What to display in the Replace label.
set replace_msg "Change to: "

proc replace_setup {t f m} {
	global replace_msg replace_string replace_count
	set replace_count 0
	$f.ss configure -width [string length [$f.ss get]]
	create_f_entry $t $f.r $f.rs
	$f.r configure -text $replace_msg
	$f.rs configure -textvariable replace_string
	$t tag lower was_replaced

	global all_replacements all_replacement_marks Keys
	set all_replacements {}
	set all_replacement_marks {}

	parse_bindings $f.ss $Keys(C_m) [bind all <Control-g>]
	parse_bindings $f.rs \
$Keys(C_r)		[bind $f.ss <Control-r>] \
$Keys(C_s)		[bind $f.ss <Control-s>] \
$Keys(C_m)		"exit_replace $t $f %A ; exit_search $t $f %A" \
C-c			"replace_this_one $t $f" \
C-C			"beth_busy $t replace_to_end $t $f"

	if {[winfo exists $m]} {
		menuentries_change_state $m.search.m normal 10
		menuentries_change_state $m.search.m disabled 9
}}

proc reset_replace {} {global replace_string ; set replace_string ""}

proc add_replace_bindings {t f m} {
	global Keys
	parse_bindings $f.ss \
C-C			"replace_setup $t $f $m" \
C-c			"reset_replace ; replace_setup $t $f $m"

	menuentries_change_state $m.search.m normal 8 9
	bind all <Control-g> "+ menuentries_change_state $m.search.m disabled 8 9"
	parse_bindings $f.ss \
$Keys(C_m)	"+ menuentries_change_state $m.search.m disabled 8 9"
}


# Replace bindings. f is a frame widget to put messages in.
proc replacebind {f t m} {
	global search_bindings
	if {([string first "add_replace_bindings" [bind all <Control-s>]] \
		 < 0)} {
		bind all <Control-g> "+ catch \{exit_replace $t $f x\}"
		parse_bindings all \
$search_bindings	"+ add_replace_bindings $t $f $m"}

		if {[winfo exists $m]} {
			parse_menuentries $m.search.m {
				separator
					{Change 0 C-c}
					{"Change Previous" 7 C-C}
					{"Change All" 7 C-C}}

			menuentries_change_state $m.search.m disabled 8 9 10
}}


replacebind $frame $text $menu
