# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Icon operations
#
# Exported Global Variables
#
#    icon_path		List of icon directories.
#
# Commands
#
#    icon <name>	Search for icon with specified <name> and
#			return specification suitable as an argument
#			to a -bitmap option.  Raises error if icon not
#			found.
#
# Hidden global variables
#
#	_icons		Cache of icons already searched for.

catch {unset _icons}

proc icon {name} {
    global icon_path _icons

    if ![catch {set result $_icons($name)}] {
	return $result
    }

    # Search for icon
    foreach dir $icon_path {
	if [file readable "$dir/$name"] {
	    set _icons($name) "@$dir/$name"
	    return "@$dir/$name"
	}
    }
    error "no icon $name"
}
