# nis.tcl
#
# Copyright (C) 1994 Matthew R. Wette -- All rights reserved.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appears in all copies.  Matthew R. Wette
# makes no representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied warranty.
#
# Copyright (C) Matthew R. Wette -- this is free software
#
# history -
#	03Feb94	M.Wette: created.
#
# version -
#	$Id: nis.tcl,v 1.1 1994/02/04 18:24:32 mwette Exp $

set dir [nis_local_directory]

proc nis_key {res} {
  set obj [nis_result $res object]
  set str [nis_object $obj expand]
  set key [lindex $str 0]
  return $key
}

proc nis_match {item table} {
  global dir
  set tbl $table.org_dir.$dir
  set res [nis_first_entry $tbl]
  while {1} {
    if [catch {nis_next_entry $tbl $res} next_res] { break }
    set res $next_res
    if {[nis_key $res]==$item} { break; }
  }
  return [nis_result $res expand]
}

