#############################################################################
#
# message.tcl:
#       This file contains the procedures directly related to operations on
#       messages.
#
# ComposeMsg {Address} 
#       Compose a message, bringing up an editor, with the To: field already
#       Filled in.
#
# DeleteMsg {Fol Msg}
#       delete a message, or a range of messages
#       TODO: instead of boldly deleting them, maybe back them up in the mh
#       way, by prepending a ",", controlled by a global variable.
#
# ShowMsg {Fol Msg}
#       Bring up a window in which the message is displayed. Add buttons 
#       For reply, forward and so on.
#       TODO: write the stuff for the buttons
#
# EditMsg {Fol Msg} 
#       bring up a window in which the message in the Folder can be edited.
#       needs buttons for save, refile, mail and so
#       TODO: finish it, especially the send. Add checkbuttons for save on 
#       exit. remove the save button, do it automatically, then send, then
#       check if the message hould be deleted.
#
# SendMsg {Fol Msg}
#       Send out the Message. Keep determines if it should be kept or 
#       backed up.
#
# SignEdit {w}
#       belongs to EditMsg, appends the Signature file to the edit window w.
#
# ForwardMsg {Fol Msg}
#       forward the current message
#
# PrintMsg {Fol Msgs}
#       Print the message, using the printcommand defined by the user.
#
# ReplyMsg {Fol Msg}
#       Reply to a message
#
#############################################################################

proc ComposeMsg {{Address {}}} {
    global MH cmd

    exec $MH(bindir)/comp -nowhatnowproc
    set File [FindLastFile $MH(Draft-Folder)]
    set FileContents [eval exec $cmd(cat) [RF $MH(Path)/$MH(Draft-Folder)/$File]]
    if {$Address != ""} {
        regsub "To:" $FileContents "To: $Address" FileContents
        set FHandle [open [RF $MH(Path)/$MH(Draft-Folder)/$File] w]
        puts $FHandle $FileContents
        close $FHandle
    }
    EditMsg $MH(Draft-Folder) $File
    if [winfo exists .$MH(Draft-Folder)] {ScanFol $MH(Draft-Folder)}
}

proc DeleteMsg {Fol Msgs} {
    global MH cmd PREF
    
    if $PREF(BackupMsg) {
        foreach Msg $Msgs {
            eval exec $cmd(mv) [RF $MH(Path)/$Fol/$Msg] [RF $MH(Path)/$Fol/,$Msg]
        }

    } else {
        foreach Msg $Msgs {
            eval exec $cmd(rm) [RF $MH(Path)/$Fol/$Msg]
        }
    }
}

proc ShowMsg {Fol Msg} {
    global MH FolList Aliases
    global FONT cmd PREF

    set OldFont $PREF(ShowFont)
    set w .show$Fol$Msg
    catch {destroy $w}
    toplevel $w
    wm title $w "$Fol: $Msg"

    text $w.t -yscroll "$w.s set" -setgrid true -width 80 -height 25 \
      -wrap $PREF(Wrap) -font $PREF(ShowFont) -relief raised -borderwidth 2
    scrollbar $w.s -relief raised -command "$w.t yview"

    frame $w.m -relief raised -borderwidth 2
    checkbutton $w.m.mono -variable PREF(ShowFont) \
      -onvalue $FONT(FixR) -offvalue $FONT(ProR) \
      -command "$w.t configure -font \$PREF(ShowFont)" \
      -relief flat -anchor w -text "Mono"
    checkbutton $w.m.wrap -variable PREF(Wrap) \
      -onvalue word -offvalue none \
      -command "$w.t configure -wrap \$PREF(Wrap)" \
      -relief flat -anchor w -text "Wrap long lines"

    frame $w.b
        menubutton $w.b.move -text "Move To" -menu $w.b.move.m -relief raised
        menubutton $w.b.copy -text "Copy To" -menu $w.b.copy.m -relief raised
        menubutton $w.b.forw -text "Forward To" -relief raised -menu $w.b.forw.m
        button $w.b.reply -text "Reply" -command "ReplyMsg $Fol $Msg"
        button $w.b.del -text "Delete" \
          -command "destroy $w; DeleteMsg $Fol $Msg; ScanFol $Fol"
        button $w.b.print -text "Print" -command "PrintMsg $Fol $Msg"
        button $w.b.ok -text "Close" -command "destroy $w"
        button $w.b.help -text "Help" -command "Help Message"

        menu $w.b.move.m
        menu $w.b.copy.m
          foreach F $FolList {
            $w.b.move.m add command -label "$F" \
                -command "MoveMsg $Fol $Msg $F 
                        destroy $w; ScanFol $Fol
                        if \[winfo exists .fol$F\] {ScanFol $F}"
            $w.b.copy.m add command -label "$F" \
                -command "CopyMsg $Fol $Msg $F
                        if \[winfo exists .fol$F\] {ScanFol $F}"
          }

        menu $w.b.forw.m
        $w.b.forw.m add command -label *NEW* -command "ForwardMsg $Fol $Msg"
        foreach A $Aliases {
          $w.b.forw.m add command -label "$A" -command \
            "if \$PREF(ExpandAlias) {
               ForwardMsg $Fol $Msg \"\[SearchAlias $A 1\]\"
             } else {ForwardMsg $Fol $Msg $A}"
          }

    pack append $w.m \
      $w.m.mono {right} \
      $w.m.wrap {right}

    pack append $w.b \
      $w.b.reply {top expand fill} \
      $w.b.forw {top expand fill} \
      $w.b.copy {top expand fill} \
      $w.b.move {top expand fill} \
      $w.b.print {top expand fill} \
      $w.b.del {top expand fill} \
      $w.b.help {top expand fill} \
      $w.b.ok {top expand fill}

    pack append $w \
      $w.m {top fillx} \
      $w.t {left expand fill} \
      $w.s {left filly} \
      $w.b {left filly}

    $w.t insert end [exec $MH(bindir)/show +$Fol $Msg]
    $w.t configure -state disabled
    focus $w.t
    tkwait window $w
    set PREF(ShowFont) $OldFont
}

proc EditMsg {Fol Msg} {
    global MH cmd FONT PREF env

    set OldKeepSent $PREF(KeepSent)
    set OldFont $PREF(EditFont)
    set w .edit$Fol$Msg
    toplevel $w
    wm title $w "$Fol: $Msg"

    text $w.t -yscroll "$w.s set" -setgrid true -width 80 -height 25 \
      -wrap word -font $PREF(EditFont) -relief raised -borderwidth 2
    scrollbar $w.s -relief raised -command "$w.t yview"

    frame $w.m -relief raised -borderwidth 2
    checkbutton $w.m.keepsent -variable PREF(KeepSent) \
      -relief flat -anchor w -text "Save when Done"
    checkbutton $w.m.mono -variable PREF(EditFont) \
      -onvalue $FONT(FixR) -offvalue $FONT(ProR) \
      -command "$w.t configure -font \$PREF(EditFont)" \
      -relief flat -anchor w -text "Mono"
    checkbutton $w.m.wrap -variable PREF(Wrap) \
      -onvalue word -offvalue none \
      -command "$w.t configure -wrap \$PREF(Wrap)" \
      -relief flat -anchor w -text "Wrap long lines"
    menubutton $w.m.filter -text Filter -menu $w.m.filter.m
    menu $w.m.filter.m
    foreach Filter $cmd(pipes) {
        if [string compare $Filter separator] {
          $w.m.filter.m add command -label [lindex $Filter 0] \
            -command "Pipe $w.t {[lindex $Filter 1]} [lindex $Filter 2]"
        } else {
          $w.m.filter.m add separator
        }
    }
    $w.m.filter.m add separator
    $w.m.filter.m add command -label {Filter through...} -command \
        "set pipecommand \[Ask {Filter through:}\]
         if {\$pipecommand != {}} {
             Pipe $w.t \"\$pipecommand\" nonewline
         }"

    frame $w.b
    button $w.b.ok -text "Done" -command \
     "if {!\$PREF(KeepSent)} {DeleteMsg $Fol $Msg}; destroy $w"
    button $w.b.mail -text "Mail It" -command \
      "SaveText $w.t [RF $MH(Path)/$Fol/$Msg]
       SendMsg $Fol $Msg
       set Sent 1"
    button $w.b.sign -text "Sign" -command "SignEdit $w"
    button $w.b.insert -text "Insert File" -command \
     "set File \[Browse $env(HOME)\]
      if {\$File != {}} {$w.t insert insert \[eval exec \$cmd(cat) \$File\]}"
    button $w.b.help -text "Help" -command "Help Edit"

    pack append $w.m \
      $w.m.filter {left} \
      $w.m.mono {right} \
      $w.m.wrap {right} \
      $w.m.keepsent {right}

    pack append $w.b \
      $w.b.mail {top expand fill} \
      $w.b.sign {top expand fill} \
      $w.b.insert {top expand fill} \
      $w.b.help {top expand fill} \
      $w.b.ok {top expand fill}

    pack append $w \
      $w.m {top fillx} \
      $w.t {left expand fill} \
      $w.s {left filly} \
      $w.b {left filly}

    $w.t insert end [eval exec $cmd(cat) [RF $MH(Path)/$Fol/$Msg]]
    $w.t insert end "\n"
    $w.t mark set insert 0.0
    focus $w.t
    tkwait window $w
    set PREF(EditFont) $OldFont
    set PREF(KeepSent) $OldKeepSent
}

proc SendMsg {Fol Msg} {
    global MH PREF cmd

    for {set i 0; set File "#tkmhdraft0"} {[file exists $File]} {incr i} {
        set File "#tkmhdraft$i"
    }
    eval exec $cmd(cp) [RF $MH(Path)/$Fol/$Msg] [RF $MH(Path)/$File]
    exec $MH(bindir)/send -push -noverbose -draftmessage $File
}

proc SignEdit {w} {
    global MH cmd

    $w.t insert end "\n-----\n"
    $w.t insert end [eval exec $cmd(cat) [RF $MH(SigFile)]]
}

proc ForwardMsg {Fol Msg {Address {}}} {
    global MH cmd

    exec $MH(bindir)/forw $Msg +$Fol -nowhatnowproc
    set File [FindLastFile $MH(Draft-Folder)]
    set FileContents [eval exec $cmd(cat) [RF $MH(Path)/$MH(Draft-Folder)/$File]]
    if {$Address != ""} {
        regsub "To:" $FileContents "To: $Address" FileContents
        set FHandle [open [RF $MH(Path)/$MH(Draft-Folder)/$File] w]
        puts $FHandle $FileContents
        close $FHandle
    }
    EditMsg $MH(Draft-Folder) $File
    if [winfo exists .$MH(Draft-Folder)] {ScanFol $MH(Draft-Folder)}
}

proc ReplyMsg {Fol Msg} {
    global MH

    exec $MH(bindir)/repl $Msg +$Fol -nowhatnowproc
    set File [FindLastFile $MH(Draft-Folder)]
    EditMsg $MH(Draft-Folder) $File
    if [winfo exists .$MH(Draft-Folder)] {ScanFol $MH(Draft-Folder)}
}

proc PrintMsg {Fol Msgs} {
    global cmd MH

    if {![regsub "%f" $cmd(print) {[RF $MH(Path)/$Fol/$Msg]} PrintCmd]} {
        set PrintCmd "$cmd(print) {[RF $MH(Path)/$Fol/$Msg]}"
    }
    foreach Msg $Msgs {
        eval exec $PrintCmd
    }
}
