##############################################################################
#
# main.tcl:
#       This file contains the procedures needed to create the toplevel window,
#       the control panel for the program. It also contains some procedures 
#       that don't fit in one of the other categories.
#
# MakeControl {}
#       Make the toplevel window, containing a list of folders, and a button 
#       menu, from which one can manipulate the folders, incorporate mail,
#       compose a message, and call up the alias window.
#
# AdaptFolMenus {}
#	Adapt folder menus to current values for FolTree
#	TODO: adapt more than the main window alone.
#
# DisplayFols {}
#       Put the contents of FolList in the folderwindow
#
# CheckForMail {}
#       Check the Maildrop for incoming mail.
#
# Loop {}
#       The loop used for checking for new mail and so
#
##############################################################################

proc makeControl {} {
    global BM Aliases PREF FolList FolTree MH

    wm withdraw .
    
    toplevel .tkmh -class Control
    wm title .tkmh TkMH
    wm iconbitmap .tkmh @$BM(nomail)

    scrollbar .tkmh.fols -command {.tkmh.foll yview}
    listbox .tkmh.foll -yscroll {.tkmh.fols set}

    frame .tkmh.b -border 1
    button .tkmh.b.quit -text Quit! -command {destroy .tkmh; exit}
    button .tkmh.b.inc -bitmap @$BM(nomail) -command {IncMail}
    button .tkmh.b.help -text Help -command {Help Control}
    menubutton .tkmh.b.conf -text Configure -menu .tkmh.b.conf.m
    menubutton .tkmh.b.f -text "Folder" -menu .tkmh.b.f.m

    menu .tkmh.b.f.m
    .tkmh.b.f.m add cascade -label Open -menu .tkmh.b.f.m.open
    .tkmh.b.f.m add cascade -label Remove -menu .tkmh.b.f.m.remove
     .tkmh.b.f.m add cascade -label Rename -menu .tkmh.b.f.m.rename
    .tkmh.b.f.m add separator
    .tkmh.b.f.m add command -label {Create New} -command \
      {if {[set Fol [Ask {Folder to Create?}]] != {}} {CreateFol $Fol}}
    .tkmh.b.f.m add separator
    .tkmh.b.f.m add command -label "Pick Folders" -command \
      {if {[set EXPR [Ask {Match against:}]] != {}} {
        set PickList {}
        foreach Fol $FolList {if [regexp $EXPR $Fol] {lappend PickList $Fol}}
        DisplayFols $PickList}}
    .tkmh.b.f.m add command -label {Redisplay Folders} -command \
      {DisplayFols $FolList}
    .tkmh.b.f.m add command -label {Reread Folder Tree} -command \
      {BuildFolList 0; set FolTree [BuildFolTree $FolList]; 
       DisplayFols $FolList; AdaptFolMenus}
    AdaptFolMenus

    menu .tkmh.b.conf.m
    .tkmh.b.conf.m add command -label Aliases -command AliasWindow
    .tkmh.b.conf.m add command -label TkMH -command ConfTkMH
    .tkmh.b.conf.m add command -label MH -command \
      {if [Confirm "All Message, Edit and Folder windows will be closed.\
                       \nContinue?\n"] {
          Refresh; ConfMH
      }}

     pack append .tkmh.b \
      .tkmh.b.inc {top expand fill} \
      .tkmh.b.conf {top expand fill} \
      .tkmh.b.f {top expand fill} \
      .tkmh.b.help {top expand fill} \
      .tkmh.b.quit {top expand fill}

    pack append .tkmh \
      .tkmh.foll {left expand fill} \
      .tkmh.fols {left filly} \
      .tkmh.b {left filly} 

    bind .tkmh.foll <Double-Button-1> {
      if {[set Sel [GetListboxSel .tkmh.foll]] != {}} {
        FlashSel .tkmh.foll 2; OpenFol $Sel}}
    update
    AdaptAliMenus 
    DisplayFols $FolList
    tk_listboxSingleSelect .tkmh.foll
    .tkmh.b.inc configure -state disabled
}

proc AdaptFolMenus {} {
    global FolTree
    
    # Control Window 'Open', 'Remove' and 'Rename'
    # Folder and Show windows 'Copy to' and 'Move to'
    # Edit window 'Save to' 
    foreach w [winfo children .] {
        switch [winfo class $w] {
          Control {
            KillMenu .tkmh.b.f.m.open
            MakeMenu .tkmh.b.f.m.open $FolTree 1 {} -command \
              {OpenFol %EntryPath}
            KillMenu .tkmh.b.f.m.remove
            MakeMenu .tkmh.b.f.m.remove $FolTree 1 {} -command \
              {RemoveFol %EntryPath}
            KillMenu .tkmh.b.f.m.rename
            MakeMenu .tkmh.b.f.m.rename $FolTree 1 {} -command \
              {RenameFol %EntryPath}
          }
          Folder {
            KillMenu $w.b.move.m
            MakeMenu $w.b.move.m $FolTree 1 {} -command \
             "if \[conv_listbox_seq [WF $w] movemsgs\] {MoveMsg [WF $w] %EntryPath}"
            KillMenu $w.b.copy.m
            MakeMenu $w.b.copy.m $FolTree 1 {} -command \
             "if \[conv_listbox_seq [WF $w] copymsgs\] {CopyMsg [WF $w] %EntryPath}"
          }
          ShowMsg {
            KillMenu $w.b.move.m
            MakeMenu $w.b.move.m $FolTree 1 {} -command \
             "write_seq [lindex [WS $w] 0] movemsgs [lindex [WS $w] 1]
              MoveMsg [lindex [WS $w] 0] %EntryPath"
            KillMenu $w.b.copy.m
            MakeMenu $w.b.copy.m $FolTree 1 {} -command \
             "write_seq [lindex [WS $w] 0] copymsgs [lindex [WS $w] 1]
              CopyMsg [lindex [WS $w] 0] %EntryPath"
          }
          EditMsg {
            KillMenu $w.b.save.m
            MakeMenu $w.b.save.m $FolTree 1 {} -command \
             "set Fol [lindex [WE $w] 0]; set Msg [lindex [WE $w] 1]
              set NewMsg \[FindLastFile %EntryPath\]; incr NewMsg
              SaveText $w.t \[RF \$MH(Path)/%EntryPath/\$NewMsg\]
              if \[winfo exists \[FW %EntryPath\]\] {ScanFol %EntryPath 1}"
          }
        }
    }
}

proc DisplayFols {List} {

    set curYview [lindex [.tkmh.fols get] 2]
    .tkmh.foll delete 0 end
    foreach Fol $List {
        .tkmh.foll insert end $Fol
    }
    .tkmh.foll yview $curYview
}

proc Loop {} {
    global PREF
    
    CheckForMail
    if {![winfo exists .tkmh]} {exit}
    after [expr $PREF(Delay) * 1000] Loop
}

set MDSize 0
set MDOldSize 0

proc CheckForMail {} {
    global MH BM PREF
    global MDSize MDOldSize

    if {![file isfile $MH(MailDrop)]} {
        return
    }

    set MDOldSize $MDSize
    set MDSize [file size $MH(MailDrop)]

    if {$MDSize > $MDOldSize} {
        # There is new mail
        if $PREF(DeIcon) {wm deiconify .tkmh; raise .tkmh}
        .tkmh.b.inc configure -bitmap @$BM(mail) -state active
        wm iconbitmap .tkmh @$BM(mail)
        .tkmh.b.inc flash; .tkmh.b.inc flash
    }

    if {$MDSize < $MDOldSize && $MDSize <= 1} {
        # The maildrop file must be emptied by something else
        .tkmh.b.inc configure -bitmap @$BM(nomail) -state disabled
        wm iconbitmap .tkmh @$BM(nomail)
    }
}

proc IncMail {} {
    global MH BM PREF

    # the check is normally not needed, but just in case something 
    # outside TkMH is working at the maildrop at the same time, or
    # the maildrop is not accessible for some reason
    if {[catch {exec $MH(bindir)/inc +$MH(Inbox)}] == 1} {
        MsgWindow "Something wrong with the Maildrop file!\
                   \nMaybe it's locked because you were just receiving mail.\
                   \n\n Try again.\n"
        return
    }

    .tkmh.b.inc configure -bitmap @$BM(nomail) -state disabled
    wm iconbitmap .tkmh @$BM(nomail)
    if $PREF(OpenInbox) {
        OpenFol $MH(Inbox) 1
    }
}
