#
# This creates the "Mark" menu, which is used to set article status.
#
proc create_mark_menu {} {
    menu .menubar.mark.m
    
    add_comm_item .menubar.mark.m "Mark Read" "mark_article r"
    add_comm_item .menubar.mark.m "Mark Unread" "mark_article u"
    add_comm_item .menubar.mark.m "Toggle Status" "mark_article toggle"
}

proc create_help_menu {} {
    global Resources

    menu .menubar.help.m
    
    .menubar.help.m configure -activeborderwidth 2
    add_comm_item .menubar.help.m "Getting Started" "help_show getting_started"
    add_comm_item .menubar.help.m "Bindings" "help_show bindings"
    .menubar.help.m add separator
    add_comm_item .menubar.help.m "Groups Mode" "help_show groups_mode"
    add_comm_item .menubar.help.m "Articles Mode" "help_show articles_mode"
    add_comm_item .menubar.help.m "GroupList Mode" "help_show grouplist_mode"
    .menubar.help.m add separator
    add_comm_item .menubar.help.m "Posting" "help_show posting"
    add_comm_item .menubar.help.m "Replying" "help_show replying"
    add_comm_item .menubar.help.m "Bugs" "help_show bug_reports"
    add_comm_item .menubar.help.m "Group Status" "help_show group_status"
    add_comm_item .menubar.help.m "Marking Articles" "help_show marking_articles"
    add_comm_item .menubar.help.m "Menubar" "help_show menubar"
    add_comm_item .menubar.help.m "Navigating" "help_show navigating"
    add_comm_item .menubar.help.m "Rescanning" "help_show rescanning"
    add_comm_item .menubar.help.m "Saving Articles" "help_show saving_articles"
    add_comm_item .menubar.help.m "Saving Newsrc" "help_show saving_newsrc"
    add_comm_item .menubar.help.m "Saving State" "help_show saving_state"
    add_comm_item .menubar.help.m "View" "help_show view"
}
    
proc create_help_comm_menu {} {
    menu .menubar.help.m.comm
    .menubar.help.m add cascade -menu .menubar.help.m.comm -label "Commands  ->"

    add_comm_item .menubar.help.m.comm "Quit" "help_show comm_quit"
    add_comm_item .menubar.help.m.comm "Abort" "help_show comm_abort"
    .menubar.help.m.comm add separator 
    add_comm_item .menubar.help.m.comm "Exit Newsgroup" "help_show comm_exit_newsgroup"
    add_comm_item .menubar.help.m.comm "Post" "help_show comm_post"
    add_comm_item .menubar.help.m.comm "Followup (don't include)" "help_show comm_followup"
    add_comm_item .menubar.help.m.comm "Follouwp (include article)" "help_show comm_Followup"
    add_comm_item .menubar.help.m.comm "Compose Email" "help_show comm_compose_email"
    add_comm_item .menubar.help.m.comm "Reply (don't include)" "help_show comm_reply"
    add_comm_item .menubar.help.m.comm "Reply (include)" "help_show comm_Reply"
    add_comm_item .menubar.help.m.comm "Rescan" "help_show comm_rescan"
    add_comm_item .menubar.help.m.comm "Save Article" "help_show comm_save_article"
    add_comm_item .menubar.help.m.comm "Save Newsrc" "help_show comm_save_newsrc"
    add_comm_item .menubar.help.m.comm "Save Tknewsrc" "help_show comm_save_tknewsrc"
    add_comm_item .menubar.help.m.comm "Catch Up" "help_show comm_catchup"
    add_comm_item .menubar.help.m.comm "List Old" "help_show comm_list_old"
    add_comm_item .menubar.help.m.comm "Unsubscribe" "help_show comm_unsubscribe"
    add_comm_item .menubar.help.m.comm "Add New Group" "help_show comm_add_new_group"
    add_comm_item .menubar.help.m.comm "Goto Newsgroup" "help_show comm_goto_newsgroup"
    add_comm_item .menubar.help.m.comm "All Groups" "help_show comm_all_groups"
    add_comm_item .menubar.help.m.comm "New Groups" "help_show comm_new_groups"
    add_comm_item .menubar.help.m.comm "Preferences" "help_show comm_preferences"
    .menubar.help.m.comm add separator 
    add_comm_item .menubar.help.m.comm "Next Unread" "help_show comm_next"
    add_comm_item .menubar.help.m.comm "Prev Unread" "help_show comm_prev"
    add_comm_item .menubar.help.m.comm "Next Article" "help_show comm_Next"
    add_comm_item .menubar.help.m.comm "Prev Article" "help_show comm_Prev"
    add_comm_item .menubar.help.m.comm "Next Subject" "help_show comm_next_subject"
    add_comm_item .menubar.help.m.comm "Prev Subject" "help_show comm_prev_subject"
    .menubar.help.m.comm add separator 
    add_comm_item .menubar.help.m.comm "Mark Read" "help_show comm_mark_read"
    add_comm_item .menubar.help.m.comm "Mark Unread" "help_show comm_mark_unread"
    add_comm_item .menubar.help.m.comm "Toggle Status" "help_show comm_toggle_status"
    .menubar.help.m.comm add separator 
    add_comm_item .menubar.help.m.comm "Horizontal View" "help_show comm_horizontal_view"
    add_comm_item .menubar.help.m.comm "Vertical View" "help_show comm_vertical_view"
}

proc create_file_menu {} {
    menu .menubar.file.m
    add_comm_item .menubar.file.m "Quit" "tknews_exit"
    .menubar.file.m add separator
    add_comm_item .menubar.file.m "Abort" "tknews_abort"
}

proc create_action_menu {} {
    
    menu .menubar.action.m
    add_comm_item .menubar.action.m "Exit Newsgroup" "quit_mode"
    add_comm_item .menubar.action.m "Post" "post_article original"
    add_comm_item .menubar.action.m "Followup (don't include)" \
	"post_article followup"
    add_comm_item .menubar.action.m "Follouwp (include article)" \
	"post_article Followup"
    add_comm_item .menubar.action.m "Compose Email" "mail_article compose"
    add_comm_item .menubar.action.m "Reply (don't include)" \
	"mail_article reply"
    add_comm_item .menubar.action.m "Reply (include article)" \
	"mail_article Reply"
    add_comm_item .menubar.action.m "Rescan" "rescan 1"
    add_comm_item .menubar.action.m "Save Article" "save_article"
    add_comm_item .menubar.action.m "Save Newsrc" "save_newsrc"
    add_comm_item .menubar.action.m "Save Tknewsrc" "save_tknewsrc"
    add_comm_item .menubar.action.m "Catch Up" "catch_up"
    add_comm_item .menubar.action.m "List Old" "list_old"
    add_comm_item .menubar.action.m "Unsubscribe" "unsubscribe"
    add_comm_item .menubar.action.m "Add New Group" "add_newsgroup 0"
    add_comm_item .menubar.action.m "Goto Newsgroup" "add_newsgroup 1"
    add_comm_item .menubar.action.m "All Groups" "all_groups 0"
    add_comm_item .menubar.action.m "New Groups" "all_groups 1"
    add_comm_item .menubar.action.m "Preferences" "preferences"
}

proc create_move_menu {} {

    menu .menubar.move.m
    add_comm_item .menubar.move.m "Next Unread" "article_action NextUnread"
    add_comm_item .menubar.move.m "Prev Unread" "article_action PrevUnread"
    add_comm_item .menubar.move.m "Next Article" "article_action Next"
    add_comm_item .menubar.move.m "Prev Article" "article_action Previous"
    add_comm_item .menubar.move.m "Next Subject" "article_action NextSubject"
    add_comm_item .menubar.move.m "Prev Subject" "article_action PrevSubject"
}

proc create_view_menu {} {
    global Resources

    menu .menubar.view.m
    add_comm_item .menubar.view.m "Horizontal Layout" "change_view horizontal"
    add_comm_item .menubar.view.m "Vertical Layout" "change_view vertical"
}

proc create_font_menu {} {
    global Resources

    menu .menubar.font.m
    .menubar.font.m add radiobutton -label "Default" \
	-variable Resources(textFont) -value $Resources(defaultFont) 
    .menubar.font.m add radiobutton -label $Resources(font1Label) \
	-variable Resources(textFont) -value $Resources(font1)
    .menubar.font.m add radiobutton -label $Resources(font2Label) \
	-variable Resources(textFont) -value $Resources(font2)
    .menubar.font.m add radiobutton -label $Resources(font3Label) \
	-variable Resources(textFont) -value $Resources(font3)
    .menubar.font.m add radiobutton -label $Resources(font4Label) \
	-variable Resources(textFont) -value $Resources(font4)
}

proc create_options_menu {} {
    global Resources
    
    menu .menubar.options.m
    .menubar.options.m add checkbutton -label "AutoHelp" \
	-variable Resources(autoHelp) -onvalue 1 -offvalue 0
    .menubar.options.m add checkbutton -label "Disable Keyboard" \
	-variable Resources(disableKeyboard) -onvalue 1 -offvalue 0
}

proc add_comm_item {menu label command} {
    global BindingList Resource TclVersion

    
    set i ""
    if {[info exists BindingList($command)]} {
	set i [lindex $BindingList($command) 0]
	set i [lindex $i 1]
	if {[regsub "Key-" $i "" result]} {
	    set i $result
	}
	if {[regsub "key-" $i "" result]} {
	    set i $result
	}
	if {$TclVersion == "7.0"} {
	    set filler "--"
	} else {
	    set filler ""
	}
	if {[regsub $filler "-key" $i "" result]} {
	    set i $result
	}
	if {[regsub $filler "-Key" $i "" result]} {
	    set i $result
	}
	if {[regsub $filler "-control" $i "-Ctrl" result]} {
	    set i $result
	} 
	if {[regsub $filler "-Control" $i "-Ctrl" result]} {
	    set i $result
	} 
	if {[regsub "control-" $i "Ctrl-" result]} {
	    set i $result
	}
	if {[regsub "Control-" $i "Ctrl-" result]} {
	    set i $result
	}
	if {[regsub "equal" $i "=" result]} {
	    set i $result
	}
    }
    $menu add command -label "$label" -command $command -accelerator $i
}


proc load_menus {} {
    create_file_menu
    create_action_menu
    create_move_menu
    create_view_menu
    create_mark_menu
    create_options_menu
    create_font_menu
    create_help_menu
    tk_menuBar .menubar .menubar.file .menubar.action .menubar.move \
	.menubar.mark .menubar.view .menubar.font .menubar.options \
	.menubar.help
    tk_bindForTraversal .
}

#
# This proc destroys the individual menubar menus with
# commands in them.  It works even if these menus
# do not exist.
#
proc destroy_menus {} {
    catch "destroy .menubar.file.m"
    catch "destroy .menubar.action.m"
    catch "destroy .menubar.view.m"
    catch "destroy .menubar.move.m"
    catch "destroy .menubar.mark.m"
    catch "destroy .menubar.options.m"
    catch "destroy .menubar.help.m"
}


