#!/usr/local/bin/wish
# convert templates to auto_load able templates
set TMPLT_ROOT ./templates

catch "exec mkdir $TMPLT_ROOT"
catch "exec mkdir $TMPLT_ROOT/autoProcedures"

# read file
set curDir [pwd]
cd $TMPLT_ROOT/Procedures
set fileList ""
foreach fileName [exec ls] {
  if {[string match *.t $fileName]} {
    lappend fileList $fileName
  }
}
foreach fileName $fileList {
  puts stdout "converting: $fileName"
  set inFd [open $fileName r]
  set fileContents [read $inFd]
  close $inFd
  set outFd [open ../autoProcedures/$fileName w]
  regsub -all "# xf ignore me 0" $fileContents "# xf ignore me 9" fileContents
  regsub -all "# xf ignore me 1" $fileContents "# xf ignore me 9" fileContents
  regsub -all "# xf ignore me 2" $fileContents "# xf ignore me 9" fileContents
  regsub -all "# xf ignore me 3" $fileContents "# xf ignore me 9" fileContents
  regsub -all "# xf ignore me 4" $fileContents "# xf ignore me 9" fileContents
  regsub -all "# xf ignore me 5" $fileContents "# xf ignore me 9" fileContents
  regsub -all "# xf ignore me 6" $fileContents "# xf ignore me 9" fileContents
  regsub -all "# xf ignore me 7" $fileContents "# xf ignore me 9" fileContents
  regsub -all "# xf ignore me 8" $fileContents "# xf ignore me 9" fileContents
  puts $outFd $fileContents
  close $outFd
}

# the following code is taken from the original Tcl/Tk distribution by:
# John Ousterhout

# auto_mkindex:
# Regenerate a tclIndex file from Tcl source files.  Takes two arguments:
# the name of the directory in which the tclIndex file is to be placed,
# and a glob pattern to use in that directory to locate all of the relevant
# files.

proc auto_mkindex {dir files} {
    global errorCode errorInfo
    set oldDir [pwd]
    cd $dir
    set dir [pwd]
    append index "# Tcl autoload index file: each line identifies a Tcl\n"
    append index "# procedure and the file where that procedure is\n"
    append index "# defined.  Generated by the \"auto_mkindex\" command.\n"
    append index "\n"
    foreach file [glob $files] {
	set f ""
	set error [catch {
	    set f [open $file]
	    while {[gets $f line] >= 0} {
		if [regexp {^proc[ 	]+([^ 	]*)} $line match procName] {
		    append index "[list $procName $file]\n"
		}
	    }
	    close $f
	} msg]
	if $error {
	    set code $errorCode
	    set info $errorInfo
	    catch [close $f]
	    cd $oldDir
	    error $msg $info $code
	}
    }
    set f [open tclIndex w]
    puts $f $index nonewline
    close $f
    cd $oldDir
}

auto_mkindex ../autoProcedures *.t

catch "destroy ."
catch "exit 0"
