#
# Copyright P. Alexander, MRAO, Cambridge
# All rights reserved.
# Version 1.0 30/04/93
#
# The following procedures are used to implement additional bindings
# not defined in the standard TK bindings.
#

# Entry widgets
# -------------
#
# Entry_MoveCursor :::: provide cursor motion in entry widgets
#
#   Parameters: 
#               1  window name for the entry widget
#               2  increment by which the cursor is to be moved
#
#   This procedure can be used to provide bindings for cursor-key
#   motions within entry widgets.  A typical calling sequence would
#   be
#       bind Entry <Key-Left>  {Entry_movecursor %W -1}
#       bind Entry <Key-Right> {Entry_movecursor %W  1}
#
proc Entry_MoveCursor {w inc} {
       set x [expr "[$w index insert] + $inc"]
       if {$x == -1} then {set x 0}
       if {$x >= [$w index end]} then {set x end}
       $w icursor $x
}


