#
#
# Main windows support for Xgnuplot
#
proc xgpl_WindowMain  { w } {
   global Xgpl

# open gnuplot connection
   xgpl_Open
   xgpl_FunctionApply

# create command bar
   frame $w
   frame $w.bar -relief flat
   set width 10
   pack [menubutton $w.bar.file -text "File" -width $width -relief raised \
         -borderwidth 1 -menu $w.bar.file.m] -side left -anchor w
    menu $w.bar.file.m
    $w.bar.file.m add command -label "Save Configuration" \
                     -command "Desktop_Save Xgpl"
    $w.bar.file.m add command -label "Function Scratch Pad..." \
                     -command "xgpl_FunctionPad"
    $w.bar.file.m add command -label "Hard Copy output..." \
                     -command "xgpl_Output"
    $w.bar.file.m add command -label "Help..." \
                     -command "xgpl_help"
    $w.bar.file.m add cascade -label "Tools" \
                     -menu $w.bar.file.m.tools
    $w.bar.file.m add command -label "Quit" -command "xgpl_Exit"
    menu $w.bar.file.m.tools
      $w.bar.file.m.tools add command -label "Linear Fitting" \
                             -command xgpl_FitWindow

   pack [menubutton $w.bar.opts -text "Options" -width $width -relief raised \
         -borderwidth 1 -menu $w.bar.opts.m] -side left -anchor w
    menu $w.bar.opts.m
    $w.bar.opts.m add command -label "Main..." \
                     -command "xgpl_WindowOpts $w.opts"
    $w.bar.opts.m add command -label "3D..." \
                     -command "xgpl_Window3D $w.d3"
    $w.bar.opts.m add command -label "Parametric..." \
                     -command "xgpl_WindowParametric $w.param"
    $w.bar.opts.m add command -label "Polar..." \
                     -command "xgpl_WindowPolar $w.polar"
    $w.bar.opts.m add command -label "Miscellaneous..." \
                     -command "xgpl_WindowMisc $w.misc"

   pack [button $w.bar.plot -text "Plot" -width $width -relief raised \
         -borderwidth 1 -command xgpl_Plot] -side left -anchor w
   pack [button $w.bar.clear -text "Clear" -width $width -relief raised \
         -borderwidth 1 -command "xgpl_Send clear"] -side left -anchor w
   pack [radiobutton $w.bar.dim2 -text "2D Data" -width $width -relief raised \
         -borderwidth 2 -relief flat -variable Xgpl(dimension) -value 2] \
         -side left -anchor w
   pack [radiobutton $w.bar.dim3 -text "3D Data" -width $width -relief raised \
         -borderwidth 2 -relief flat -variable Xgpl(dimension) -value 3] \
         -side left -anchor w


# make the complete widget
   pack $w.bar -side top -fill x -padx 2 -pady 2
   pack [checkbutton $w.showlines -relief flat -anchor w -text "Lines" \
      -variable Xgpl(show:lines) -width 20 \
      -command "xgpl_setWindowAllLines $w"] \
      -side top -fill x -padx 4 -pady 2
   xgpl_setWindowAllLines $w
   bind Entry <Return> " "
}


proc xgpl_setWindowAllLines { w } {
   global Xgpl
   catch {destroy $w.ll}
   if {$Xgpl(show:lines)} then {
       xgpl_WindowAllLines $w 350 500 1200
       pack $w.ll -after $w.showlines \
            -side top -fill both -expand 1 -padx 4 -pady 4
   }
}

proc xgpl_WindowOpts { w } {
   global Xgpl gpl_line

   toplevel $w ; set title "Xgnuplot: Main Options"
   wm title $w $title
   wm iconname $w $title
   wm iconbitmap $w @$Xgpl(bitmap)
   wm group $w .
   pack [frame $w.bar -relief flat] -side top -fill x -padx 2 -pady 2
     pack [button $w.bar.dismiss -text Dismiss -command "destroy $w" \
           -width 10 -borderwidth 1 -relief raised] -side left -anchor w

   set ww $w
   pack [frame $ww.ttl -relief groove -borderwidth 2] \
         -padx 2 -pady 2 -fill x
     pack [label $ww.ttl.l -text "Main Title: " -width 12 -anchor w \
           -relief flat] -side left -anchor w
     pack [entry $ww.ttl.e -relief sunken -width 20 \
           -textvariable Xgpl(main:title)] \
           -side left -anchor w -expand 1 -fill x
     pack [label $ww.ttl.l1 -relief flat -text "  Offset:" -width 8] \
           -side left -anchor w
     pack [label $ww.ttl.l2 -relief flat -text "X:" -width 3] \
           -side left -anchor w
     pack [entry $ww.ttl.e1 -relief sunken -width 4 \
                 -textvariable Xgpl(main:ofsx)] \
                 -side left -padx 1 -anchor w -fill x -expand 0
     pack [label $ww.ttl.l3 -relief flat -text "Y:" -width 3] \
           -side left -anchor w
     pack [entry $ww.ttl.e2 -relief sunken -width 4 \
                 -textvariable Xgpl(main:ofsy)] \
                 -side left -padx 1 -anchor w -fill x
     pack [label $ww.ttl.l4 -relief flat -text {} -width 1] \
           -side left -anchor w
     pack [checkbutton $ww.ttl.grid -text Grid -width 4 -relief flat \
                 -variable Xgpl(grid) -anchor w] -side left -anchor w -padx 2
     pack [checkbutton $ww.ttl.keyon -text Key -width 4 -relief flat \
                 -variable Xgpl(key:on) -anchor w] -side left -anchor w -padx 2
     pack [label $ww.ttl.keypos -text At: -width 4 \
                 -relief flat -anchor e] \
                 -side left -anchor w -padx 2
     pack [entry $ww.ttl.keypz -relief sunken -width 4 \
                 -textvariable Xgpl(key:z)] -side right -anchor e -padx 2
     pack [entry $ww.ttl.keypy -relief sunken -width 4 \
                 -textvariable Xgpl(key:y)] -side right -anchor e -padx 2
     pack [entry $ww.ttl.keypx -relief sunken -width 4 \
                 -textvariable Xgpl(key:x)] -side right -anchor e -padx 2


   pack [frame $ww.c -relief groove -borderwidth 2] \
         -padx 2 -pady 2 -fill x
     pack [xgpl_WindowCoord $ww.c.x "X Axis" x] \
         -side left -fill both -padx 4 -pady 6
     pack [xgpl_WindowCoord $ww.c.y "Y Axis" y] \
         -side left -fill both -padx 4 -pady 6
     pack [xgpl_WindowCoord $ww.c.z "Z Axis" z] \
         -side left -fill both -padx 4 -pady 6


}

proc xgpl_WindowAllLines { w  xh xw xl } {
   global Xgpl gpl_line

# create scrollable list of line options
   frame $w.ll -relief groove -borderwidth 2
   pack [scrollbar $w.ll.scrolly -relief sunken -width 3m \
                  -command "$w.ll.c yview"] -side right -fill y
   pack [scrollbar $w.ll.scrollx -orient horizontal -relief sunken -width 3m \
                  -command "$w.ll.c xview"] -side bottom -fill x
   pack [canvas $w.ll.c -relief sunken -relief sunken -borderwidth 2 \
         -yscroll "$w.ll.scrolly set" -xscroll "$w.ll.scrollx set"\
         -height $xh -width $xw -scrollregion "0 0 $xw $xl" ] \
         -side top -expand 1 -fill both
        frame $w.ll.c.f -relief flat
        $w.ll.c create window [expr $xw/2] 5 -anchor n -window $w.ll.c.f
   set ww $w.ll.c.f

# loop and add line types
   for {set n 1} {$n <= $Xgpl(nlines)} {incr n} {
      pack [xgpl_WindowLine $ww.l$n $n] -side top -fill x -padx 2 -pady 2
   }
}

proc xgpl_WindowLine { w n } {
   global Xgpl gpl_line

# make container frame
   frame $w -relief groove -borderwidth 2

# setup defaults
   xgpl_lineReset $w $n
   xgpl_lineClear $w $n

# add some options for this window
   pack [frame $w.top0 -relief flat] -side top -fill x -padx 2 -pady 3
   pack [button $w.top0.b1 -text "Clear" -relief raised -borderwidth 1 \
         -command "xgpl_lineClear $w $n" -width 8] \
         -side left -anchor w -padx 2
   pack [button $w.top0.b2 -text "Reset" -relief raised -borderwidth 1 \
         -command "xgpl_lineReset $w $n" -width 8] \
         -side left -anchor w -padx 2
   pack [checkbutton $w.top0.title -text "Title:" -relief flat \
         -width 8 -variable gpl_line(titleon,$n)] \
         -side left -anchor w -padx 19
   pack [entry $w.top0.etitle -relief sunken -width 15 \
         -textvariable gpl_line(title,$n)] \
         -side left -anchor w -padx 4 -fill x -expand 1

   pack [frame $w.top -relief flat] -side top -fill x -padx 2 -pady 3
   pack [checkbutton $w.top.l -text "Line $n" -anchor w\
            -relief flat -width 8 -variable gpl_line(on,$n)] \
            -side left -anchor w
   pack [radiobutton $w.top.type1 -text "Function" -width 8 -anchor w\
            -relief flat \
            -variable gpl_line(type,$n) -value function] -side left -anchor w
   pack [radiobutton $w.top.type2 -text "File" -width 8 -anchor w\
            -relief flat \
            -variable gpl_line(type,$n) -value file] -side left -anchor w
   pack [entry $w.top.e -width 30 -relief sunken \
            -textvariable gpl_line(entry,$n)] \
            -side left -anchor w -expand 1 -fill x -padx 4

   pack [frame $w.mid1 -relief flat] -side top -fill x -padx 2 -pady 3
   pack [menubutton $w.mid1.with -text "Style:" -width 8 -menu $w.mid1.with.m \
         -relief flat] \
         -side left -padx 1 -anchor w
   pack [label $w.mid1.lwith -textvariable gpl_line(style,$n) -width 16 \
         -relief flat] \
         -side left -padx 0 -anchor w
   menu $w.mid1.with.m
   foreach m {lines points linespoint impulses dots steps errorbars \
              boxes boxerrorbars} {
     $w.mid1.with.m add radiobutton -label $m -variable gpl_line(style,$n) \
                                   -value $m
   }
   pack [menubutton $w.mid1.line -text "Line:" -width 8 -menu $w.mid1.line.m \
         -relief flat] \
         -side left -padx 1 -anchor w
   pack [label $w.mid1.lline -textvariable gpl_line(line,$n) -width 4 \
         -relief flat] \
         -side left -padx 0 -anchor w
   menu $w.mid1.line.m
   for {set m 1} {$m <= $Xgpl(nlines)} {incr m} {
     $w.mid1.line.m add radiobutton -label "line $m" \
             -variable gpl_line(line,$n) -value $m
   }
   pack [menubutton $w.mid1.point -text "Point:" -width 8 -menu $w.mid1.point.m \
         -relief flat] \
         -side left -padx 1 -anchor w
   pack [label $w.mid1.lpoint -textvariable gpl_line(point,$n) -width 4 \
         -relief flat] \
         -side left -padx 0 -anchor w
   menu $w.mid1.point.m
   for {set m 1} {$m <= $Xgpl(nlines)} {incr m} {
     $w.mid1.point.m add radiobutton -label "point $m" \
             -variable gpl_line(point,$n) -value $m
   }



   pack [frame $w.cols -relief flat] -fill x -side top
   pack [label $w.cols.cols -text Columns: -width 8 -anchor w] \
         -side left -anchor w -padx 2
   pack [label $w.cols.cl1 -text " X:" -width 3 -relief flat] \
         -side left -anchor w
   pack [entry $w.cols.ce1 -relief sunken -width 3 \
         -textvariable gpl_line(xc,$n)] -side left -anchor w
   pack [label $w.cols.cl2 -text " Y:" -width 3 -relief flat] \
         -side left -anchor w
   pack [entry $w.cols.ce2 -relief sunken -width 3 \
         -textvariable gpl_line(yc,$n)] -side left -anchor w
   pack [label $w.cols.cl3 -text " Z:" -width 3 -relief flat] \
         -side left -anchor w
   pack [entry $w.cols.ce3 -relief sunken -width 3 \
         -textvariable gpl_line(zc,$n)] -side left -anchor w
   pack [label $w.cols.cl4 -text " Err1:" -width 6 -relief flat] \
         -side left -anchor w
   pack [entry $w.cols.ce4 -relief sunken -width 3 \
         -textvariable gpl_line(err1c,$n)] -side left -anchor w
   pack [label $w.cols.cl5 -text " Err2:" -width 6 -relief flat] \
         -side left -anchor w
   pack [entry $w.cols.ce5 -relief sunken -width 3 \
         -textvariable gpl_line(err2c,$n)] -side left -anchor w
   return $w
}

proc xgpl_lineClear { w n } {
   global Xgpl gpl_line
   set gpl_line(on,$n) 0
   set gpl_line(entry,$n) {}
}

proc xgpl_lineReset { w n } {
   global Xgpl gpl_line
   set gpl_line(type,$n) function
   set gpl_line(style,$n) lines
   set gpl_line(line,$n) $n
   set gpl_line(point,$n) $n
   set gpl_line(title,$n) {}
   set gpl_line(titleon,$n) 1
   set gpl_line(xc,$n) {1}
   set gpl_line(yc,$n) {2}
   set gpl_line(zc,$n) {3}
   set gpl_line(err1c,$n) {}
   set gpl_line(err2c,$n) {}
}

proc xgpl_Open { } {
  global Xgpl
  set Xgpl(fidX) [open "|gnuplot" w+]
}

proc xgpl_Close { } {
  global Xgpl
  catch {close $Xgpl(fidX)}
}

proc xgpl_Send { args } {
  global Xgpl
  foreach n $args {append line " $n"}
  if $Xgpl(debug) then {
    puts "Sending $Xgpl(debug) puts $Xgpl(fidX) $line"
  }
  puts $Xgpl(fidX) $line
  puts $Xgpl(fidX) "\r"
  flush $Xgpl(fidX)
}

proc xgpl_Plot { } {
  global Xgpl gpl_line
  xgpl_Update
  set clist {}
  for {set n 1} {$n <= $Xgpl(nlines)} {incr n} {
     if {$gpl_line(on,$n)} then {
       if [string length $gpl_line(entry,$n)] then {
         if [string length $clist] {append clist ,}
         switch $gpl_line(type,$n) {
           {function}      {
                  append clist $gpl_line(entry,$n)
           }
           {file}          {
                  append clist '$gpl_line(entry,$n)'
                  if {$Xgpl(dimension) == 2} then {
                    append clist " using $gpl_line(xc,$n):$gpl_line(yc,$n)"
                    if [string length $gpl_line(err1c,$n)] then {
                      append clist ":$gpl_line(err1c,$n)"
                    }
                    if [string length $gpl_line(err2c,$n)] then {
                      append clist ":$gpl_line(err2c,$n)"
                    }
                  } else {
                      append clist \
                     " using $gpl_line(xc,$n):$gpl_line(yc,$n):$gpl_line(zc,$n)"
                  }
           }
         }
         if {$gpl_line(titleon,$n)} then {
           if [string length $gpl_line(title,$n)] then {
             append clist " title '$gpl_line(title,$n)'"
           }
         } else {
           append clist " notitle"
         }
         append clist \
           " with $gpl_line(style,$n) $gpl_line(line,$n) $gpl_line(point,$n)"
       }
     }
  }
  if {"$Xgpl(dimension)" == "2"} then {
    xgpl_Send plot $clist
  } else {
    xgpl_Send splot $clist
  }
}

proc xgpl_Exit { } {
   global Xgpl
   xgpl_Close
   exit
}

proc xgpl_cd { dir } {cd $dir ; xgpl_Send cd $dir}

proc xgpl_Update { } {
   global Xgpl

   foreach coord {x y z} {

  # setup scaling of axes
     if {$Xgpl($coord:auto)} then {
       xgpl_Send set autoscale $coord
     } else { 
       xgpl_Send set nautoscale $coord
       if {[string length $Xgpl($coord:rngfrom)] && \
           [string length $Xgpl($coord:rngto)]} then {
         xgpl_Send set ${coord}range \
             \[$Xgpl($coord:rngfrom):$Xgpl($coord:rngto)\]
       }
     }
     if {$Xgpl($coord:logon)} then {
       xgpl_Send set logscale $coord $Xgpl($coord:logbase)
     } else {
       xgpl_Send set nologscale $coord
     }
     if [string length $Xgpl($coord:ofsx)] then {
       set clist $Xgpl($coord:ofsx)
     } else {
       set clist {}
     }
     if [string length $Xgpl($coord:ofsy)] then {
       append clist ",$Xgpl($coord:ofsy)"
     } 

  # set axes titles
     if [string length $Xgpl($coord:title)] then {
       xgpl_Send set ${coord}label '$Xgpl($coord:title)' $clist
     } else {
       xgpl_Send set ${coord}label $clist
     }

  # set axes tick marks and axes
     if $Xgpl($coord:axis) then {
       xgpl_Send set ${coord}zeroaxis
     } else {
       xgpl_Send set no${coord}zeroaxis
     }
     if !{$Xgpl($coord:ticks)} then {
       xgpl_Send set no${coord}tics no${coord}dtics  no${coord}mtics 
     } else {
       switch $Xgpl($coord:tickt) {
         {dtics}    {xgpl_Send set ${coord}dtics}
         {mtics}    {xgpl_Send set ${coord}mtics}
         {tics}     {if $Xgpl($coord:tickron) then {
                       if {[string length $Xgpl($coord:tickrs)] && \
                           [string length $Xgpl($coord:tickri)] } then {
                         set clist  "$Xgpl($coord:tickrs),$Xgpl($coord:tickri)"
                         if [string length $Xgpl($coord:tickre)] then {
                            append clist ",$Xgpl($coord:tickre)"
                         }
                         xgpl_Send set ${coord}tics $clist
                       }
                     } elseif $Xgpl($coord:ticklon) then {
                       if {[string length $Xgpl($coord:tickll)]} then {
                          xgpl_Send set ${coord}tics ( $Xgpl($coord:tickll) )
                       }
                     } else {
                        xgpl_Send set ${coord}tics
                     }
                    }
       }
     }
   }

   if [string length $Xgpl(main:ofsx)] then {
       set clist $Xgpl(main:ofsx)
   } else {
       set clist {}
   }
   if [string length $Xgpl(main:ofsy)] then {
       append clist ",$Xgpl(main:ofsy)"
   } 
   if [string length $Xgpl(main:title)] then {
       xgpl_Send set title '$Xgpl(main:title)' $clist
   } else {
       xgpl_Send set title $clist
   }
   if {$Xgpl(border)} then {
       xgpl_Send set border
   } else {
       xgpl_Send set noborder
   }
   if {$Xgpl(grid)} then {
       xgpl_Send set grid
   } else {
       xgpl_Send set nogrid
   }
   if {$Xgpl(tics)} then {
       xgpl_Send set tics in
   } else {
       xgpl_Send set tics out
   }
   foreach m {points one two} {
     if {$Xgpl(clip:$m)} then {
         xgpl_Send set clip $m
     } else {
         xgpl_Send set noclip $m
     }
   }
   if {[string length Xgpl(size:x)] && [string length Xgpl(size:y)]} then {
       xgpl_Send set size $Xgpl(size:x),$Xgpl(size:y)
   }
   if {[string length Xgpl(sampling)]} then {
       xgpl_Send set samples $Xgpl(sampling)
   }
   if {[string length $Xgpl(space:x1)] && \
       [string length $Xgpl(space:x2)] && \
       [string length $Xgpl(space:y1)] && \
       [string length $Xgpl(space:y2)] } then {
       xgpl_Send set offsets \
         $Xgpl(space:x1),$Xgpl(space:x2),$Xgpl(space:y1),$Xgpl(space:y2)
   }
   if {$Xgpl(key:on)} then {
       set clist {} 
       if {[string length $Xgpl(key:x)] && \
           [string length $Xgpl(key:y)]} then {
          append clist " $Xgpl(key:x),$Xgpl(key:y)"
         if {$Xgpl(dimension) == 2} then {
            if {[string length $Xgpl(key:z)]} then {
               append clist ",$Xgpl(key:z)"
            }
         }
       }
       xgpl_Send set key $clist
   } else {
       xgpl_Send set nokey
   }
   if {$Xgpl(param)} then {
       xgpl_Send set parametric
       if {[string length $Xgpl(param:t1)] && \
           [string length $Xgpl(param:t2)] } then {
              xgpl_Send set trange \[$Xgpl(param:t1):$Xgpl(param:t2)\]
       }
       if {[string length $Xgpl(param:u1)] && \
           [string length $Xgpl(param:u2)] } then {
              xgpl_Send set urange \[$Xgpl(param:t1):$Xgpl(param:t2)\]
       }
       if {[string length $Xgpl(param:v1)] && \
           [string length $Xgpl(param:v2)] } then {
              xgpl_Send set vrange \[$Xgpl(param:t1):$Xgpl(param:t2)\]
       }
   } else {
       xgpl_Send set noparametric
   }
   if {$Xgpl(polar)} then {
       xgpl_Send set polar
       xgpl_Send set angles $Xgpl(angle)
       if {[string length $Xgpl(polar:r1)] && \
           [string length $Xgpl(polar:r2)] } then {
              xgpl_Send set rrange \[$Xgpl(polar:r1):$Xgpl(polar:r2)\]
       }
   } else {
       xgpl_Send set nopolar
   }
   if {$Xgpl(dimension) == 3} then {
     xgpl_Send set view $Xgpl(view:xrot),$Xgpl(view:zrot),$Xgpl(view:xsc),$Xgpl(view:zsc)
     xgpl_Send set mapping $Xgpl(smap)
     if {$Xgpl(surf)} then {
       xgpl_Send set surface
       xgpl_Send set isosamples $Xgpl(isamp)
       if {$Xgpl(hidden)} then {
          xgpl_Send set hidden3d
       } else {
          xgpl_Send set nohidden3d
       }
     } else {
       xgpl_Send set nosurface
     }
     if {$Xgpl(cont)} then {
       xgpl_Send set contour $Xgpl(ctype)
       if {$Xgpl(clabel)} then {
          xgpl_Send set clabel
       } else {
          xgpl_Send set noclabel
       }
       xgpl_Send set cntrparam $Xgpl(cmode)
       xgpl_Send set cntrparam points $Xgpl(cont:points)
       xgpl_Send set cntrparam order $Xgpl(cont:order)
       xgpl_Send set cntrparam levels $Xgpl(cont:n)
       switch $Xgpl(cont:levm) {
         {auto}        {xgpl_Send set cntrparam levels auto
         }
         {incremental} {
             if {[string length $Xgpl(cont:lev1)] && \
                 [string length $Xgpl(cont:lev2)]} then {
               set clist "$Xgpl(cont:lev1),$Xgpl(cont:lev2)"
               if {[string length $Xgpl(cont:lev3)]} then {
                   append clist ",$Xgpl(cont:lev3)"
               }
               xgpl_Send set cntrparam levels incremental $clist
             }
         } 
         {discrete}   {
               xgpl_Send set cntrparam levels discrete $Xgpl(cont:levs)
         }
       }
     } else {
       xgpl_Send set nocontour
     }
   }
}

proc xgpl_WindowCoord { w title label } {
   global Xgpl


  frame $w -relief sunken -borderwidth 2
   pack [label $w.l -text $title -relief flat] \
         -side top -fill x -padx 2 -pady 1


   pack [frame $w.t -relief flat] -side top -fill x -padx 4 -pady 3
     pack [label $w.t.l -text Title: -width 6 -anchor w -relief flat] \
           -side left -anchor w
     pack [entry $w.t.e -relief sunken -width 20 \
           -textvariable Xgpl($label:title)] \
           -side left -anchor w -expand 1 -fill x

   pack [frame $w.ofs -relief flat] -side top -fill x -padx 4 -pady 3
     pack [label $w.ofs.l1 -relief flat -text "Offset:" -width 6] \
           -side left -anchor w
     pack [label $w.ofs.l2 -relief flat -text "X:" -width 4] \
           -side left -anchor w
     pack [entry $w.ofs.e1 -relief sunken -width 6 \
                 -textvariable Xgpl($label:ofsx)] \
                 -side left -padx 1 -anchor w -fill x -expand 1
     pack [label $w.ofs.l3 -relief flat -text "Y:" -width 3] \
           -side left -anchor w
     pack [entry $w.ofs.e2 -relief sunken -width 6 \
                 -textvariable Xgpl($label:ofsy)] \
                 -side left -padx 1 -anchor w -fill x -expand 1

   pack [frame $w.sp1 -relief flat] -side top -fill x -padx 2 -pady 5

   pack [frame $w.as -relief flat] -side top -fill x
   pack [checkbutton $w.as.as -relief flat -text "Autoscale" \
           -width 10 -anchor w -variable Xgpl($label:auto)] \
           -side left -anchor w -fill x
   pack [entry $w.as.lb -relief sunken -width 4 \
           -textvariable Xgpl($label:logbase)] \
           -side right -anchor e -fill x -padx 5
   pack [checkbutton $w.as.ls -relief flat -text "Logscale" \
           -width 10 -anchor w -variable Xgpl($label:logon)] \
           -side right -anchor e -fill x


   pack [frame $w.rng -relief flat] -side top -fill x -padx 4 -pady 3
     pack [label $w.rng.l1 -relief flat -text "Range:" -width 6] \
           -side left -anchor w
     pack [label $w.rng.l2 -relief flat -text "from" -width 4] \
           -side left -anchor w
     pack [entry $w.rng.e1 -relief sunken -width 6 \
                 -textvariable Xgpl($label:rngfrom)] \
                 -side left -padx 1 -anchor w -fill x -expand 1
     pack [label $w.rng.l3 -relief flat -text "to" -width 3] \
           -side left -anchor w
     pack [entry $w.rng.e2 -relief sunken -width 6 \
                 -textvariable Xgpl($label:rngto)] \
                 -side left -padx 1 -anchor w -fill x -expand 1

   pack [frame $w.sp2 -relief flat] -side top -fill x -padx 2 -pady 5
   pack [frame $w.ticks  -relief flat] -side top -fill x -padx 4 -pady 3
   pack [frame $w.ticks.top  -relief flat] -side top -fill x
   pack [checkbutton $w.ticks.top.on -relief flat -text "Display tick marks" \
         -variable Xgpl($label:ticks) -anchor w] \
           -side left -anchor w -fill x
   pack [checkbutton $w.ticks.top.aon -relief flat -text "Display axis" \
         -variable Xgpl($label:axis) -anchor w] \
           -side left -anchor w -fill x
   pack [frame $w.ticks.t  -relief flat] -side top -fill x
     pack [radiobutton $w.ticks.t.n -relief flat -text "Normal" \
           -width 6 -anchor w -variable Xgpl($label:tickt) -value tics] \
           -side left -anchor w -fill x -expand 1
     pack [radiobutton $w.ticks.t.d -relief flat -text "Days" \
           -width 6 -anchor w -variable Xgpl($label:tickt) -value dtics] \
           -side left -anchor w -fill x -expand 1
     pack [radiobutton $w.ticks.t.m -relief flat -text "Months" \
           -width 6 -anchor w -variable Xgpl($label:tickt) -value mtics] \
           -side left -anchor w -fill x -expand 1
   pack [frame $w.ticks.r  -relief flat] -side top -fill x
     pack [checkbutton $w.ticks.r.on -text "Increment:" -width 10 -anchor w\
           -relief flat -variable Xgpl($label:tickron)] \
           -side left -anchor w -fill x
     pack [entry $w.ticks.r.e1 -relief sunken -width 6\
           -textvariable Xgpl($label:tickrs) ] \
           -side left -anchor w -fill x -expand 1
     pack [entry $w.ticks.r.e2 -relief sunken -width 6\
           -textvariable Xgpl($label:tickri) ] \
           -side left -anchor w -fill x -expand 1
     pack [entry $w.ticks.r.e3 -relief sunken -width 6\
           -textvariable Xgpl($label:tickre) ] \
           -side left -anchor w -fill x -expand 1
   pack [frame $w.ticks.l  -relief flat] -side top -fill x
     pack [checkbutton $w.ticks.l.on -text "List ticks:" -width 10 -anchor w\
           -relief flat -variable Xgpl($label:ticklon)] \
           -side left -anchor w -fill x
     pack [entry $w.ticks.l.e1 -relief sunken -width 6\
           -textvariable Xgpl($label:tickll) ] \
           -side left -anchor w -fill x -expand 1
   return $w
}

proc xgpl_FunctionApply { } {
  global Xgpl Desktop
  xgpl_Send $Xgpl(funcs)
}

proc xgpl_help { } {
  global Xgpl
  set w .help
  catch {destroy $w} ; toplevel $w
  wm title $w "Xgnuplot Install Help"
  wm iconname $w "Xgnuplot Install Help"
  frame $w.t -relief groove -borderwidth 2
  pack [scrollbar $w.t.scroll -width 3m -command "$w.t.text yview" \
        -relief sunken -borderwidth 2] -side right -fill y
  pack [text $w.t.text -relief flat -width 70\
        -setgrid 1 -yscroll "$w.t.scroll set"] \
        -side top -fill both -expand 1 -padx 5 -pady 5
  pack $w.t -side top -padx 10 -pady 10 -expand 1 -fill both
  frame $w.c -relief groove -borderwidth 2
  pack [button $w.c.dismiss -text Dismiss -width 10 -command "destroy $w"] \
        -side left -anchor c -expand 1 -pady 10
  pack $w.c -side top -fill x -padx 10 -pady 10
  if [file exists $Xgpl(src)/Xgnuplot.doc] then {
    set fid [open $Xgpl(src)/Xgnuplot.doc r]
    $w.t.text insert 0.0 [read $fid]
    close $fid
  }
  $w.t.text configure -state disabled
}
