'\"
'\" Copyright 1992 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" Copyright 1993 by AT&T Bell Laboratories.
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\" Bitmap command created by George Howlett.
'\"
.so man.macros
.HS blt_bitmap cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
blt_bitmap \- Define bitmap from data
.SH SYNOPSIS
\fBblt_bitmap define \fIname dataList\fR
.sp
.VS
\fBblt_bitmap exists \fIname\fR
.VE
.sp
\fBblt_bitmap bits \fIname\fR
.sp
\fBblt_bitmap data \fIname\fR
.sp
\fBblt_bitmap height \fIname\fR
.sp
\fBblt_bitmap width \fIname\fR
.sp
.VS
\fBblt_bitmap compose \fIname text \fR?\fIoptions\fR?
.VE
.BE
.SH DESCRIPTION
.PP
This command creates an internal bitmap for Tk from a list of data 
and associates it with a given name.  It essentially offers the 
functionality of \fBTk_DefineBitmap\fR at the Tcl programming level.  
.SH BITMAP COMMANDS
The following commands are available for \fBblt_bitmap\fR:
.TP
\fBblt_bitmap define \fIname dataList\fR 
Associates \fIname\fR with in-memory bitmap data so that \fIname\fR can 
be used in later calls to \fBTk_GetBitmap\fR. 
The \fIname\fR argument is the name of the bitmap; it must
not previously have been defined in either a call to Tk_DefineBitmap or
\fBblt_bitmap\fR.  The argument \fIdataList\fP describes
the bitmap to be created.  It is a list of two elements, the dimensions
and source data.  The dimensions are a list of two numbers which are
the width and height of the bitmap.  The source data is a list 
of hexadecimal values in a format similar to the X11 or X10 bitmap format.  
The values may be optionally separated by commas and do not need to 
be prefixed with "\fC0x\fR". 
.TP
\fBblt_bitmap exists \fIname\fR 
.VS
Returns "1" if a bitmap \fIname\fR exists, otherwise "0". 
.TP
\fBblt_bitmap bits \fIname\fR 
Returns the source data of the bitmap \fIname\fR. The source data is a 
list of the hexadecimal values.  
It is an error if \fIname\fR does not represent a valid bitmap.
.TP
\fBblt_bitmap data \fIname\fR 
Returns a list of both the dimensions of the bitmap \fIname\fR and its 
source data. 
It is an error if \fIname\fR does not represent a valid bitmap.
.TP
\fBblt_bitmap height \fIname\fR 
Returns the height of the bitmap \fIname\fR.
It is an error if \fIname\fR does not represent a valid bitmap.
.TP
\fBblt_bitmap width \fIname\fR 
Returns the width of the bitmap \fIname\fR.
It is an error if \fIname\fR does not represent a valid bitmap.
.TP
\fBblt_bitmap compose \fIname text \fR?\fIoptions\fR?
Creates a bitmap \fIname\fR from the text string \fItext\fR.
A bitmap \fIname\fR can not already exist.  
The following options are available.
.RS
.TP
\fB\-font \fIfontName\fR 
Specifies a font to use when drawing text into the bitmap.
If this option isn't specified then \fIfontName\fR defaults to 
\fC*-Helvetica-Bold-R-Normal-*-140-*\fR.
.TP
\fB\-rotate \fItheta\fR
Specifies the angle of rotation of the text in the bitmap.
\fITheta\fR is a real number representing the angle in degrees.
It defaults to \fC0.0\fR degrees.
.RE
.VE
.SH EXAMPLES
The following examples demonstrate the various forms \fIdataList\fR 
may take in the \fBblt_bitmap\fR command.
.PP
The elements may or may not be separated by commas.
.DS 
\fCblt_bitmap define light_gray { { 4 2 } { 0x08, 0x02 } }\fR
\fCblt_bitmap define light_gray { { 4 2 } { 0x08 0x02 } }\fR
.DE
.PP
Each element is a hexadecimal number which is optionally prefixed
by "\fC0x\fR".
.DS
\fCblt_bitmap define light_gray { { 4 2 } { 8 2 } }\fR
.DE
.PP
The hex values of data can be represented in either X11 or X10 bitmap 
format.  In X11 bitmap format, each element is an unsigned character.
.DS 
\fCblt_bitmap define face { { 16 16 } {
   0x1f, 0xf8, 0xc7, 0xe3, 0xf3, 0xcf, 0xf9, 0x9f, 
   0xfd, 0xbf, 0xcc, 0x33, 0xfe, 0x7f, 0xfe, 0x7f, 
   0x7e, 0x7e, 0xfe, 0x7f, 0xec, 0x37, 0xdd, 0xbb,
   0x39, 0x9c, 0xf3, 0xcf, 0xc7, 0xe3, 0x1f, 0xf8 } 
}\fR
.DE
.PP
While in X10 format, they instead represent short integers.
.DS 
\fCblt_bitmap define face { 16 16 } { 
    0xf81f, 0xe3c7, 0xcff3, 0x9ff9, 0xbffd, 0x33cc, 
    0x7ffe, 0x7ffe, 0x7e7e, 0x7ffe, 0x37ec, 0xbbdd, 
    0x9c39, 0xcff3, 0xe3c7, 0xf81f
}\fR
.DE
.SH BUGS
.PP
There is no way to delete or redefine a bitmap.
.SH KEYWORDS
bitmap
