/*
 *  blt.h
 */

#ifndef _BLT_H
#define _BLT_H

#include "bltConfig.h"

#include <tcl.h>
#include <tk.h>
#include <stdio.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */

#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif /* HAVE_ERRNO_H */

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif /* HAVE_MEMORY_H */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif /* HAVE_MALLOC_H */

#include "bltList.h"

/*
 * ----------------------------------------------------------------------
 *
 * 	X11/Xosdefs.h requires XNOSTDHDRS be set for some systems.
 *	This is a guess.  If I can't find STDC headers or unistd.h,
 *	assume that this is non-POSIX and non-STDC environment.
 *	(needed for Encore Umax 3.4 ?)
 *
 * ----------------------------------------------------------------------
 */
#if !defined(STDC_HEADERS) && !defined(HAVE_UNISTD_H)
#define XNOSTDHDRS 	1
#endif

/*
 * ----------------------------------------------------------------------
 *
 * 	The TCL_DYNAMIC macro requires "free" to be declared.
 *	Assume we need one if there's no stdlib.h or malloc.h
 *
 * ----------------------------------------------------------------------
 */
#if !defined(HAVE_STDLIB_H) && !defined(HAVE_MALLOC_H)
extern void free _ANSI_ARGS_((void *));
#endif

/*
 * ----------------------------------------------------------------------
 *
 *	If strerror isn't in the C library (we'll get it from 
 *	libtcl.a) that we also need a forward declaration.
 *
 * ----------------------------------------------------------------------
 */
#ifndef HAVE_STRERROR
extern char *strerror _ANSI_ARGS_((int));
#endif

/* Forward declarations */

extern int Blt_FindCmd _ANSI_ARGS_((Tcl_Interp *, char *, ClientData *));

#endif /*_BLT_H*/
