#!ewish -f
#
# Program: xfemacs
#
# startup source

  global argc
  global argv
  global env

  wm protocol . WM_DELETE_WINDOW EmacsQuit
  update
  wm withdraw .

  set runAsClient 0
  set tmpStartArgv ""
  for {set counter 0} {$counter < $argc} {incr counter 1} {
    case [string tolower [lindex $argv $counter]] in {
      {-client} {
        set runAsClient 1
      }
      {default} {
        lappend tmpStartArgv [lindex $argv $counter]
      }
    }
  }
  set tmpFileArgv ""
  set tmpLoadFile ""
  set tmpFunction ""
  if {$runAsClient == 1} {
    for {set counter 0} {$counter < [llength $tmpStartArgv]} {incr counter 1} {
      case [string tolower [lindex $tmpStartArgv $counter]] in {
        {-xfloadpath} {
          incr counter
        }
        {-load} {
          incr counter
          lappend tmpLoadFile [lindex $tmpStartArgv $counter]
        }
        {-function} {
          incr counter
          set tmpFunction [lindex $tmpStartArgv $counter]
        }
        {default} {
          set fileName [lindex $tmpStartArgv $counter]
          if {"[file dirname $fileName]" == "."} {
            lappend tmpFileArgv [pwd]/$fileName
          } {
            lappend tmpFileArgv $fileName
          }
        }
      }
    }
    foreach counter $tmpLoadFile {
      set sendCommand "SendToEmacs {(load \"$counter\")}"
      if {[catch "send xfemacs \{$sendCommand\}" result]} {
        set argv $tmpStartArgv
        set argc [llength $tmpStartArgv]
        set runAsClient 0
        break
      }
    }
    foreach counter $tmpFileArgv {
      set sendCommand "SendToEmacs {(find-file \"$counter\")}"
      if {[catch "send xfemacs \{$sendCommand\}" result]} {
        set argv $tmpStartArgv
        set argc [llength $tmpStartArgv]
        set runAsClient 0
        break
      }
    }
    if {"[string trim $tmpFunction]" != ""} {
      set sendCommand "SendToEmacs {$tmpFunction}"
      if {[catch "send xfemacs \{$sendCommand\}" result]} {
        set argv $tmpStartArgv
        set argc [llength $tmpStartArgv]
        set runAsClient 0
        break
      }
    }
  }
  if {$runAsClient == 1} {
    destroy .
  }
  catch "unset fileName"
  catch "unset runAsClient"
  catch "unset tmpStartArgv"
  catch "unset tmpFileArgv"
  catch "unset tmpLoadFile"
  catch "unset tmpFunction"



# module inclusion
global argc
global argv
global env
global xfLoadInfo
global xfLoadPath

if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) .:/usr/local/lib] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):.:/usr/local/lib
  } {
    set xfLoadPath .:/usr/local/lib
  }
} {
  set xfLoadPath .:/usr/local/lib
}

set xfLoadInfo 0
set tmpArgv ""
for {set counter 0} {$counter < $argc} {incr counter 1} {
  case [string tolower [lindex $argv $counter]] in {
    {-xfloadpath} {
      incr counter 1
      set xfLoadPath "[lindex $argv $counter]:$xfLoadPath"
    }
    {-xfcolorfile} {
      incr counter 1
      set env(XF_COLOR_FILE) "[lindex $argv $counter]"
    }
    {-xfcursorfile} {
      incr counter 1
      set env(XF_CURSOR_FILE) "[lindex $argv $counter]"
    }
    {-xffontfile} {
      incr counter 1
      set env(XF_FONT_FILE) "[lindex $argv $counter]"
    }
    {-xfloading} {
      set xfLoadInfo 1
    }
    {-xfnoloading} {
      set xfLoadInfo 0
    }
    {default} {
      lappend tmpArgv [lindex $argv $counter]
    }
  }
}
set argv $tmpArgv
set argc [llength $tmpArgv]
unset counter
unset tmpArgv


proc ShowWindow. {args} {

  # Window manager configurations
  wm title . {xfemacs.tcl}
  if {[string match 200x200* [wm geometry .]] == 1} {
    wm sizefrom . program
    wm geometry . 600x400
  } {
    if {[string match *x* [wm geometry .]] == 1} {
      wm sizefrom . program
    } {
      wm sizefrom . user
    }
  }
  if {[string match *+0+0 [wm geometry .]] == 1} {
    wm positionfrom . program
    wm geometry . +436+284
  } {
    if {[regexp {[+]+0[+]+0} [wm geometry .]] == 1} {
      wm positionfrom . program
    } {
      wm positionfrom . user
    }
  }
  wm maxsize . 1152 900
  wm minsize . 0 0

  # build widget .c
  menu .c
  .c configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .c add command\
    -command {SendToEmacs {(find-tag "")}}\
    -label {Find tag under pointer}
  .c add command\
    -accelerator {M-.}\
    -command {SendToEmacs {(call-interactively 'find-tag)}}\
    -label {Find tag}
  .c add command\
    -accelerator {C-x `}\
    -command {SendToEmacs {(next-error)}}\
    -label {Next error}
  .c add separator
  .c add command\
    -accelerator {C-M-q}\
    -command {SendToEmacs {(indent-sexp)}}\
    -label {Indent expression}
  .c add command\
    -accelerator {C-M-\ }\
    -command {SendToEmacs {(indent-region)}}\
    -label {Indent region}

  # build widget .emacs-default
  menu .emacs-default
  .emacs-default configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .emacs-default add command\
    -accelerator {C-x u}\
    -command {SendToEmacs {(undo)}}\
    -label {Undo}

  # build widget .frame
  frame .frame
  .frame configure \
    -background {#dcdcdc}\
    -relief {raised}
  # bindings


  # build widget .frame.scrollbar1
  scrollbar .frame.scrollbar1
  .frame.scrollbar1 configure \
    -activeforeground {GhostWhite}\
    -background {#dcdcdc}\
    -command {.frame.text yview}\
    -foreground {gray}\
    -relief {raised}
  # bindings
  bind .frame.scrollbar1 <Any-Button> {
incr tk_priv(buttons)
.frame.text updatescrollbars} 


  # build widget .frame.scrollbar5
  scrollbar .frame.scrollbar5
  .frame.scrollbar5 configure \
    -activeforeground {GhostWhite}\
    -background {#dcdcdc}\
    -command {.frame.text xview}\
    -foreground {gray}\
    -orient {horizontal}\
    -relief {raised}
  # bindings
  bind .frame.scrollbar5 <Any-Button> {
incr tk_priv(buttons)
.frame.text updatescrollbars} 


  # build widget .frame.text
  if {[catch "tkemacs .frame.text -command TkEmacs -lispfile tkemacs.el"] != 0} {
    if {[string length [info procs XFSaveAsProc]] > 0} {
      XFError "Unknown widget type: tkemacs"
      return
    } {
      puts stderr "Unknown widget type: tkemacs"
      destroy .
    }
  }
  .frame.text configure \
    -background {#dcdcdc}\
    -borderwidth {2}\
    -errorcallback {EmacsError}\
    -debug {false}\
    -foreground {black}\
    -geometry {300x200}\
    -insertbackground {blue}\
    -pollinterval {60}\
    -relief {raised}\
    -useadvise {true}\
    -xscrollcommand {.frame.scrollbar5 set}\
    -yscrollcommand {.frame.scrollbar1 set}
  # bindings
  bind .frame.text <Any-ButtonRelease-3> {
      global emacsCurrentMenu
      if {"$emacsCurrentMenu" != ""} {
        $emacsCurrentMenu invoke active
        $emacsCurrentMenu unpost
        set emacsCurrentMenu ""
      }} 
  bind .frame.text <B3-Mod1-Motion> {EmacsPopupHandle %X %Y} 
  bind .frame.text <Double-Button-1> {EmacsDoubleClick} 
  bind .frame.text <Mod1-Button-3> {EmacsPopup %X %Y} 


  # pack widget .frame
  pack append .frame\
    .frame.scrollbar1   {left frame center filly} \
    .frame.text   {top frame center expand fill} \
    .frame.scrollbar5   {top frame center fillx} 


  # build widget .frame0
  frame .frame0
  .frame0 configure \
    -background {#dcdcdc}\
    -borderwidth {2}\
    -relief {raised}
  # bindings


  # build widget .frame0.button01
  button .frame0.button01
  .frame0.button01 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -command {SendToEmacs {(undo)}}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -text {Undo}
  # bindings


  # build widget .frame0.menubutton00
  menubutton .frame0.menubutton00
  .frame0.menubutton00 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton00.m}\
    -text {File}\
    -underline {0}
  # bindings
  bind .frame0.menubutton00 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton00 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton00 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton00"

  # build widget .frame0.menubutton00.m
  menu .frame0.menubutton00.m
  .frame0.menubutton00.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton00.m add command\
    -accelerator {C-x C-f}\
    -command {set emacsResult [FSBox {Select file to load:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(find-file \"$emacsResult\")"
}}\
    -label {Open...}\
    -underline {0}
  .frame0.menubutton00.m add command\
    -accelerator {C-x 4 f}\
    -command {set emacsResult [FSBox {Select file to load:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(find-file-other-window \"$emacsResult\")"
}}\
    -label {In other window...}\
    -underline {0}
  .frame0.menubutton00.m add command\
    -accelerator {C-x i}\
    -command {set emacsResult [FSBox {Select file to load:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(insert-file \"$emacsResult\")"
}}\
    -label {Insert...}\
    -underline {0}
  .frame0.menubutton00.m add command\
    -command {set emacsResult [FSBox {Select lisp file to load:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(load-file \"$emacsResult\")"
}}\
    -label {Load file (lisp)...}\
    -underline {5}
  .frame0.menubutton00.m add separator
  .frame0.menubutton00.m add command\
    -accelerator {C-x C-s}\
    -command {SendToEmacs (save-buffer)}\
    -label {Save}\
    -underline {0}
  .frame0.menubutton00.m add command\
    -accelerator {C-x s}\
    -command {SendToEmacs {(call-interactively 'save-some-buffers)}}\
    -label {Save some}\
    -underline {7}
  .frame0.menubutton00.m add command\
    -accelerator {C-x C-w}\
    -command {set emacsResult [FSBox {Select filename for saving:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(write-file \"$emacsResult\")"
}}\
    -label {Save as...}\
    -underline {5}
  .frame0.menubutton00.m add separator
  .frame0.menubutton00.m add command\
    -command {ReadBox}\
    -label {Enter TCL code...}\
    -underline {6}
  .frame0.menubutton00.m add separator
  .frame0.menubutton00.m add command\
    -accelerator {C-x C-c}\
    -command {
EmacsQuit}\
    -label {Quit}\
    -underline {0}

  # build widget .frame0.menubutton01
  menubutton .frame0.menubutton01
  .frame0.menubutton01 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton01.m}\
    -text {Edit}\
    -underline {0}
  # bindings
  bind .frame0.menubutton01 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton01 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton01 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton01"

  # build widget .frame0.menubutton01.m
  menu .frame0.menubutton01.m
  .frame0.menubutton01.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton01.m add command\
    -accelerator {C-x u}\
    -command {SendToEmacs {(undo)}}\
    -label {Undo}\
    -underline {0}
  .frame0.menubutton01.m add separator
  .frame0.menubutton01.m add command\
    -accelerator {C-w}\
    -command {SendToEmacs {(call-interactively 'kill-region)}}\
    -label {Cut}\
    -underline {1}
  .frame0.menubutton01.m add command\
    -accelerator {M-w}\
    -command {SendToEmacs {(call-interactively 'copy-region-as-kill)}}\
    -label {Copy}\
    -underline {0}
  .frame0.menubutton01.m add command\
    -accelerator {C-y}\
    -command {SendToEmacs {(yank)}}\
    -label {Paste}\
    -underline {0}
  .frame0.menubutton01.m add separator
  .frame0.menubutton01.m add command\
    -accelerator {C-SPC}\
    -command {SendToEmacs {(call-interactively 'set-mark-command)}}\
    -label {Set mark}\
    -underline {0}
  .frame0.menubutton01.m add command\
    -accelerator {C-x C-x}\
    -command {SendToEmacs {(exchange-point-and-mark)}}\
    -label {Exchange point and mark}\
    -underline {0}
  .frame0.menubutton01.m add command\
    -accelerator {C-u C-SPC}\
    -command {SendToEmacs {(set-mark-command '(4))}}\
    -label {Previous mark}\
    -underline {9}

  # build widget .frame0.menubutton02
  menubutton .frame0.menubutton02
  .frame0.menubutton02 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton02.m}\
    -text {Commands}\
    -underline {0}
  # bindings
  bind .frame0.menubutton02 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton02 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton02 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton02"

  # build widget .frame0.menubutton02.m
  menu .frame0.menubutton02.m
  .frame0.menubutton02.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton02.m add command\
    -command {SendToEmacs {(redraw-display)}}\
    -label {Redisplay}\
    -underline {0}
  .frame0.menubutton02.m add separator
  .frame0.menubutton02.m add command\
    -accelerator {C-x m}\
    -command {SendToEmacs (mail)}\
    -label {Send mail}\
    -underline {5}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs (rmail)}\
    -label {Read mail}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs (gnus)}\
    -label {Read news}\
    -underline {5}
  .frame0.menubutton02.m add command\
    -command {set emacsResult [FSBox {Select directoryname:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(dired \"$emacsResult\")"
}}\
    -label {Dired...}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {set emacsResult [FSBox {Select filename for debugging:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(gdb \"$emacsResult\")"
}}\
    -label {GDB}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs (shell)}\
    -label {Shell}\
    -underline {0}
  .frame0.menubutton02.m add separator
  .frame0.menubutton02.m add command\
    -command {SendToEmacs {(call-interactively 'search-forward)}}\
    -label {Search}
  .frame0.menubutton02.m add command\
    -accelerator {M-.}\
    -command {SendToEmacs {(call-interactively 'find-tag)}}\
    -label {Find tag}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs {(call-interactively 'compile)}}\
    -label {Compile}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs (eval-current-buffer)}\
    -label {Eval buffer}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs (ispell-buffer)}\
    -label {Ispell buffer}\
    -underline {4}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs {(call-interactively 'query-replace)}}\
    -label {Query replace}\
    -underline {0}
  .frame0.menubutton02.m add separator
  .frame0.menubutton02.m add command\
    -accelerator {C-g}\
    -command {SendToEmacs {(message "Press C-g to abort.")(sit-for 3)}}\
    -label {Abort}\
    -underline {0}

  # build widget .frame0.menubutton03
  menubutton .frame0.menubutton03
  .frame0.menubutton03 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton03.m}\
    -text {Buffers}\
    -underline {0}
  # bindings
  bind .frame0.menubutton03 <B1-Enter> {
          EmacsBuildBuffList %W
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton03 <Button-1> {
          EmacsBuildBuffList %W
          tk_mbButtonDown %W} 
  bind .frame0.menubutton03 <Button-2> {
          EmacsBuildBuffList %W
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton03"

  # build widget .frame0.menubutton03.m
  menu .frame0.menubutton03.m
  .frame0.menubutton03.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton03.m add command\
    -label {nothing}

  # build widget .frame0.menubutton04
  menubutton .frame0.menubutton04
  .frame0.menubutton04 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton04.m}\
    -text {Windows}\
    -underline {0}
  # bindings
  bind .frame0.menubutton04 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton04 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton04 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton04"

  # build widget .frame0.menubutton04.m
  menu .frame0.menubutton04.m
  .frame0.menubutton04.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton04.m add command\
    -accelerator {C-x 2}\
    -command {SendToEmacs {(split-window-vertically)}}\
    -label {Split Window Vertically}\
    -underline {13}
  .frame0.menubutton04.m add command\
    -accelerator {C-x 5}\
    -command {SendToEmacs {(split-window-horizontally)}}\
    -label {Split Window Horizontally}\
    -underline {13}
  .frame0.menubutton04.m add command\
    -accelerator {C-x 0}\
    -command {SendToEmacs {(delete-window)}}\
    -label {Delete window}\
    -underline {0}
  .frame0.menubutton04.m add command\
    -accelerator {C-x 1}\
    -command {SendToEmacs {(delete-other-windows)}}\
    -label {Delete other windows}\
    -underline {0}
  .frame0.menubutton04.m add separator
  .frame0.menubutton04.m add cascade\
    -label {Shrink window}\
    -menu {.frame0.menubutton04.m.m1}\
    -underline {1}
  .frame0.menubutton04.m add cascade\
    -accelerator {C-x ^}\
    -label {Enlarge window}\
    -menu {.frame0.menubutton04.m.m2}\
    -underline {1}

  # build widget .frame0.menubutton04.m.m
  menu .frame0.menubutton04.m.m
  .frame0.menubutton04.m.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code

  # build widget .frame0.menubutton04.m.m1
  menu .frame0.menubutton04.m.m1
  .frame0.menubutton04.m.m1 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 1)}}\
    -label {1}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 2)}}\
    -label {2}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 3)}}\
    -label {3}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 4)}}\
    -label {4}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 6)}}\
    -label {6}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 9)}}\
    -label {9}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 13)}}\
    -label {13}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 20)}}\
    -label {20}\
    -underline {0}

  # build widget .frame0.menubutton04.m.m2
  menu .frame0.menubutton04.m.m2
  .frame0.menubutton04.m.m2 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 1)}}\
    -label {1}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 2)}}\
    -label {2}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 3)}}\
    -label {3}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 4)}}\
    -label {4}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 6)}}\
    -label {6}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 9)}}\
    -label {9}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 13)}}\
    -label {13}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 20)}}\
    -label {20}\
    -underline {0}

  # build widget .frame0.menubutton05
  menubutton .frame0.menubutton05
  .frame0.menubutton05 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton05.m}\
    -text {Modes}\
    -underline {0}
  # bindings
  bind .frame0.menubutton05 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton05 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton05 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton05"

  # build widget .frame0.menubutton05.m
  menu .frame0.menubutton05.m
  .frame0.menubutton05.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (fundamental-mode)}\
    -label {Fundamental}\
    -underline {0}
  .frame0.menubutton05.m add separator
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (c-mode)}\
    -label {C}\
    -underline {0}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (emacs-lisp-mode)}\
    -label {Emacs lisp}\
    -underline {0}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (latex-mode)}\
    -label {LaTeX}\
    -underline {0}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (lisp-interaction-mode)}\
    -label {Lisp interaction}\
    -underline {5}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (nroff-mode)}\
    -label {Nroff}\
    -underline {0}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (outline-mode)}\
    -label {Outline}\
    -underline {0}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (picture-mode)}\
    -label {Picture}\
    -underline {4}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (tex-mode)}\
    -label {Tex}\
    -underline {2}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (text-mode)}\
    -label {Text}\
    -underline {0}

  # build widget .frame0.menubutton06
  menubutton .frame0.menubutton06
  .frame0.menubutton06 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -cursor {arrow}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton06.m}\
    -text {Configure}\
    -underline {1}
  # bindings
  bind .frame0.menubutton06 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton06 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton06 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton06"

  # build widget .frame0.menubutton06.m
  menu .frame0.menubutton06.m
  .frame0.menubutton06.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton06.m add cascade\
    -label {Resources}\
    -menu {.frame0.menubutton06.m.m0}\
    -underline {0}
  .frame0.menubutton06.m add cascade\
    -label {Menus}\
    -menu {.frame0.menubutton06.m.m1}\
    -underline {0}
  .frame0.menubutton06.m add cascade\
    -label {Emacs popup binding}\
    -menu {.frame0.menubutton06.m.m2}\
    -underline {0}
  .frame0.menubutton06.m add cascade\
    -label {Other}\
    -menu {.frame0.menubutton06.m.m3}\
    -underline {0}
  .frame0.menubutton06.m add command\
    -command {EmacsSaveOptions}\
    -label {Save}\
    -underline {0}

  # build widget .frame0.menubutton06.m.m0
  menu .frame0.menubutton06.m.m0
  .frame0.menubutton06.m.m0 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton06.m.m0 add command\
    -command {global menuConfColorFile
global emacsActBackground
global alertBoxActiveBackground
global colorBoxActiveBackground
global fontBoxActiveBackground
global fsBoxActiveBackground
global menuConfActiveBackground
global readBoxActiveBackground
global textBoxActiveBackground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsActBackground \"$emacsResult\"
  set alertBoxActiveBackground $emacsResult
  set colorBoxActiveBackground $emacsResult
  set fontBoxActiveBackground $emacsResult
  set fsBoxActiveBackground $emacsResult
  set menuConfActiveBackground $emacsResult
  set readBoxActiveBackground $emacsResult
  set textBoxActiveBackground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Active background}
  .frame0.menubutton06.m.m0 add command\
    -command {global menuConfColorFile
global emacsActForeground
global alertBoxActiveForeground
global colorBoxActiveForeground
global fontBoxActiveForeground
global fsBoxActiveForeground
global menuConfActiveForeground
global readBoxActiveForeground
global textBoxActiveForeground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsActForeground \"$emacsResult\"
  set alertBoxActiveForeground $emacsResult
  set colorBoxActiveForeground $emacsResult
  set fontBoxActiveForeground $emacsResult
  set fsBoxActiveForeground $emacsResult
  set menuConfActiveForeground $emacsResult
  set readBoxActiveForeground $emacsResult
  set textBoxActiveForeground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Active foreground}
  .frame0.menubutton06.m.m0 add command\
    -command {global menuConfColorFile
global emacsBackground
global alertBoxBackground
global colorBoxBackground
global fontBoxBackground
global fsBoxBackground
global menuConfBackground
global readBoxBackground
global textBoxBackground
global alertBoxScrollBackground
global colorBoxScrollBackground
global fontBoxScrollBackground
global fsBoxScrollBackground
global menuConfScrollBackground
global readBoxScrollBackground
global textBoxScrollBackground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsBackground \"$emacsResult\"
  set alertBoxBackground $emacsResult
  set colorBoxBackground $emacsResult
  set fontBoxBackground $emacsResult
  set fsBoxBackground $emacsResult
  set menuConfBackground $emacsResult
  set readBoxBackground $emacsResult
  set textBoxBackground $emacsResult
  set alertBoxScrollBackground $emacsResult
  set colorBoxScrollBackground $emacsResult
  set fontBoxScrollBackground $emacsResult
  set fsBoxScrollBackground $emacsResult
  set menuConfScrollBackground $emacsResult
  set readBoxScrollBackground $emacsResult
  set textBoxScrollBackground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Background}
  .frame0.menubutton06.m.m0 add command\
    -command {global menuConfColorFile
global emacsForeground
global alertBoxForeground
global colorBoxForeground
global fontBoxForeground
global fsBoxForeground
global menuConfForeground
global readBoxForeground
global textBoxForeground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsForeground \"$emacsResult\"
  set alertBoxForeground $emacsResult
  set colorBoxForeground $emacsResult
  set fontBoxForeground $emacsResult
  set fsBoxForeground $emacsResult
  set menuConfForeground $emacsResult
  set readBoxForeground $emacsResult
  set textBoxForeground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Foreground}
  .frame0.menubutton06.m.m0 add command\
    -command {global menuConfFontFile
global emacsFont
global alertBoxFont
global colorBoxFont
global fontBoxFont
global fsBoxFont
global menuConfFont
global readBoxFont
global textBoxFont
set emacsResult [FontBox $menuConfFontFile]
if {"$emacsResult" != ""} {
  set emacsFont \"$emacsResult\"
  set alertBoxFont $emacsResult
  set colorBoxFont $emacsResult
  set fontBoxFont $emacsResult
  set fsBoxFont $emacsResult
  set menuConfFont $emacsResult
  set readBoxFont $emacsResult
  set textBoxFont $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Font}
  .frame0.menubutton06.m.m0 add command\
    -command {global menuConfFontFile
global emacsEmacsFont
set emacsResult [FontBox $menuConfFontFile "Emacs font:"]
if {"$emacsResult" != ""} {
  set emacsEmacsFont \"$emacsResult\"
  EmacsSetWidgetResources .
}}\
    -label {Emacs font}
  .frame0.menubutton06.m.m0 add command\
    -command {global menuConfColorFile
global emacsEmacsCursor
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsEmacsCursor \"$emacsResult\"
  EmacsSetWidgetResources .
}}\
    -label {Emacs insert background}
  .frame0.menubutton06.m.m0 add command\
    -command {global menuConfColorFile
global emacsScrollActForeground
global alertBoxScrollActiveForeground
global colorBoxScrollActiveForeground
global fontBoxScrollActiveForeground
global fsBoxScrollActiveForeground
global menuConfScrollActiveForeground
global readBoxScrollActiveForeground
global textBoxScrollActiveForeground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsScrollActForeground \"$emacsResult\"
  set alertBoxScrollActiveForeground $emacsResult
  set colorBoxScrollActiveForeground $emacsResult
  set fontBoxScrollActiveForeground $emacsResult
  set fsBoxScrollActiveForeground $emacsResult
  set menuConfScrollActiveForeground $emacsResult
  set readBoxScrollActiveForeground $emacsResult
  set textBoxScrollActiveForeground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Scrollbar active foreground}
  .frame0.menubutton06.m.m0 add command\
    -command {global menuConfColorFile
global emacsScrollForeground
global alertBoxScrollForeground
global colorBoxScrollForeground
global fontBoxScrollForeground
global fsBoxScrollForeground
global menuConfScrollForeground
global readBoxScrollForeground
global textBoxScrollForeground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsScrollForeground \"$emacsResult\"
  set alertBoxScrollForeground $emacsResult
  set colorBoxScrollForeground $emacsResult
  set fontBoxScrollForeground $emacsResult
  set fsBoxScrollForeground $emacsResult
  set menuConfScrollForeground $emacsResult
  set readBoxScrollForeground $emacsResult
  set textBoxScrollForeground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Scrollbar foreground}

  # build widget .frame0.menubutton06.m.m1
  menu .frame0.menubutton06.m.m1
  .frame0.menubutton06.m.m1 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton06.m.m1 add command\
    -command {MenuConf .frame0}\
    -label {Menubar}
  .frame0.menubutton06.m.m1 add command\
    -command {MenuConf .}\
    -label {Popups}
  .frame0.menubutton06.m.m1 add command\
    -command {MenuConf}\
    -label {All}

  # build widget .frame0.menubutton06.m.m2
  menu .frame0.menubutton06.m.m2
  .frame0.menubutton06.m.m2 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton06.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Mod1-Button-3>}
set bindPopupRelease {<Any-ButtonRelease-3>}
set bindPopupMove {<B3-Mod1-Motion>}
EmacsSetBinding}\
    -label {<Mod1-Button3>}\
    -value {<Mod1-Button3>}\
    -variable {emacsPopupBind}
  .frame0.menubutton06.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Mod1-Button-2>}
set bindPopupRelease {<Any-ButtonRelease-2>}
set bindPopupMove {<B2-Mod1-Motion>}
EmacsSetBinding}\
    -label {<Mod1-Button2>}\
    -value {<Mod1-Button2>}\
    -variable {emacsPopupBind}
  .frame0.menubutton06.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Mod1-Button-1>}
set bindPopupRelease {<Any-ButtonRelease-1>}
set bindPopupMove {<B1-Mod1-Motion>}
EmacsSetBinding}\
    -label {<Mod1-Button1>}\
    -value {<Mod1-Button1>}\
    -variable {emacsPopupBind}
  .frame0.menubutton06.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Shift-Button-3>}
set bindPopupRelease {<Any-ButtonRelease-3>}
set bindPopupMove {<B3-Shift-Motion>}
EmacsSetBinding}\
    -label {<Shift-Button3>}\
    -value {<Shift-Button3>}\
    -variable {emacsPopupBind}
  .frame0.menubutton06.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Control-Button-3>}
set bindPopupRelease {<Any-ButtonRelease-3>}
set bindPopupMove {<B3-Control-Motion>}
EmacsSetBinding}\
    -label {<Control-Button3>}\
    -value {<Control-Button3>}\
    -variable {emacsPopupBind}
  .frame0.menubutton06.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Shift-Control-Button-3>}
set bindPopupRelease {<Any-ButtonRelease-3>}
set bindPopupMove {<B3-Shift-Control-Motion>}
EmacsSetBinding}\
    -label {<Shift-Control-Button3>}\
    -value {<Shift-Control-Button3>}\
    -variable {emacsPopupBind}

  # build widget .frame0.menubutton06.m.m3
  menu .frame0.menubutton06.m.m3
  .frame0.menubutton06.m.m3 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton06.m.m3 add checkbutton\
    -command {global emacsDebug; .frame.text debug $emacsDebug}\
    -label {Debugging}\
    -variable {emacsDebug}\
    -underline {0}
  .frame0.menubutton06.m.m3 add checkbutton\
    -command {global emacsUseAdvise
.frame.text config -useadvise $emacsUseAdvise}\
    -label {Update scrollbars from emacs}\
    -offvalue {false}\
    -onvalue {true}\
    -variable {emacsUseAdvise}\
    -underline {0}
  .frame0.menubutton06.m.m3 add cascade\
    -label {Scrollbar poll interval}\
    -menu {.frame0.menubutton06.m.m3.m}\
    -underline {0}

  # build widget .frame0.menubutton06.m.m3.m
  menu .frame0.menubutton06.m.m3.m
  .frame0.menubutton06.m.m3.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton06.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {0 seconds (off)}\
    -value {0}\
    -variable {emacsPollInterval}
  .frame0.menubutton06.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {5 seconds}\
    -value {5}\
    -variable {emacsPollInterval}
  .frame0.menubutton06.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {10 seconds}\
    -value {10}\
    -variable {emacsPollInterval}
  .frame0.menubutton06.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {30 seconds}\
    -value {30}\
    -variable {emacsPollInterval}
  .frame0.menubutton06.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {60 seconds}\
    -value {60}\
    -variable {emacsPollInterval}
  .frame0.menubutton06.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {120 seconds}\
    -value {120}\
    -variable {emacsPollInterval}

  # build widget .frame0.menubutton07
  menubutton .frame0.menubutton07
  .frame0.menubutton07 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton07.m}\
    -text {}\
    -underline {0}
  # bindings
  bind .frame0.menubutton07 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton07 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton07 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton07"

  # build widget .frame0.menubutton07.m
  menu .frame0.menubutton07.m
  .frame0.menubutton07.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings


  # build widget .frame0.menubutton08
  menubutton .frame0.menubutton08
  .frame0.menubutton08 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton08.m}\
    -text {}\
    -underline {0}
  # bindings
  bind .frame0.menubutton08 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton08 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton08 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton08"

  # build widget .frame0.menubutton08.m
  menu .frame0.menubutton08.m
  .frame0.menubutton08.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings


  # build widget .frame0.menubutton09
  menubutton .frame0.menubutton09
  .frame0.menubutton09 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton09.m}\
    -text {}\
    -underline {0}
  # bindings
  bind .frame0.menubutton09 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton09 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton09 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton09"

  # build widget .frame0.menubutton09.m
  menu .frame0.menubutton09.m
  .frame0.menubutton09.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings


  # build widget .frame0.menubutton10
  menubutton .frame0.menubutton10
  .frame0.menubutton10 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton10.m}\
    -text {}\
    -underline {0}
  # bindings
  bind .frame0.menubutton10 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton10 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton10 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton10"

  # build widget .frame0.menubutton10.m
  menu .frame0.menubutton10.m
  .frame0.menubutton10.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings


  # build widget .frame0.menubutton11
  menubutton .frame0.menubutton11
  .frame0.menubutton11 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton11.m}\
    -text {}\
    -underline {0}
  # bindings
  bind .frame0.menubutton11 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton11 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton11 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton11"

  # build widget .frame0.menubutton11.m
  menu .frame0.menubutton11.m
  .frame0.menubutton11.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings


  # build widget .frame0.menubutton12
  menubutton .frame0.menubutton12
  .frame0.menubutton12 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton12.m}\
    -text {}\
    -underline {0}
  # bindings
  bind .frame0.menubutton12 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton12 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton12 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton12"

  # build widget .frame0.menubutton12.m
  menu .frame0.menubutton12.m
  .frame0.menubutton12.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings


  # build widget .frame0.menubutton13
  menubutton .frame0.menubutton13
  .frame0.menubutton13 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton13.m}\
    -text {}\
    -underline {0}
  # bindings
  bind .frame0.menubutton13 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton13 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton13 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton13"

  # build widget .frame0.menubutton13.m
  menu .frame0.menubutton13.m
  .frame0.menubutton13.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings


  # build widget .frame0.menubutton14
  menubutton .frame0.menubutton14
  .frame0.menubutton14 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton14.m}\
    -text {Help}\
    -underline {0}
  # bindings
  bind .frame0.menubutton14 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton14 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton14 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menuBar .frame0 [string trim [tk_menuBar .frame0] \"\{\}\"] .frame0.menubutton14"

  # build widget .frame0.menubutton14.m
  menu .frame0.menubutton14.m
  .frame0.menubutton14.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton14.m add cascade\
    -accelerator {C-h i d}\
    -label {Info}\
    -menu {.frame0.menubutton14.m.m}\
    -underline {0}
  .frame0.menubutton14.m add command\
    -accelerator {C-h i d}\
    -command {SendToEmacs {(info)}
SendToEmacs {(Info-directory)}
}\
    -label {Info directory}\
    -underline {0}
  .frame0.menubutton14.m add command\
    -accelerator {C-h i 2}\
    -command {SendToEmacs {(info)}
SendToEmacs {(Info-directory)}
SendToEmacs {(Info-menu "Emacs")}
}\
    -label {Info Emacs}\
    -underline {5}
  .frame0.menubutton14.m add separator
  .frame0.menubutton14.m add command\
    -accelerator {C-h t}\
    -command {SendToEmacs {(help-with-tutorial)}}\
    -label {Tutorial}\
    -underline {0}
  .frame0.menubutton14.m add separator
  .frame0.menubutton14.m add command\
    -accelerator {C-h a}\
    -command {SendToEmacs {(call-interactively 'command-apropos)}}\
    -label {Apropos command}\
    -underline {0}
  .frame0.menubutton14.m add command\
    -accelerator {C-h c}\
    -command {SendToEmacs {(call-interactively 'describe-key-briefly)}}\
    -label {Describe key briefly}\
    -underline {3}
  .frame0.menubutton14.m add command\
    -accelerator {C-h k}\
    -command {SendToEmacs {(call-interactively 'describe-key)}}\
    -label {Describe key}\
    -underline {9}
  .frame0.menubutton14.m add command\
    -accelerator {C-h w}\
    -command {SendToEmacs {(call-interactively 'where-is)}}\
    -label {Where is command}\
    -underline {0}
  .frame0.menubutton14.m add command\
    -accelerator {C-h m}\
    -command {SendToEmacs {(call-interactively 'describe-mode)}}\
    -label {Describe mode}\
    -underline {9}
  .frame0.menubutton14.m add command\
    -accelerator {C-h v}\
    -command {SendToEmacs {(call-interactively 'describe-variable)}}\
    -label {Describe variable}\
    -underline {9}
  .frame0.menubutton14.m add separator
  .frame0.menubutton14.m add command\
    -accelerator {C-h C-c}\
    -command {SendToEmacs {(call-interactively 'describe-copying)}}\
    -label {License}\
    -underline {0}

  # build widget .frame0.menubutton14.m.m
  menu .frame0.menubutton14.m.m
  .frame0.menubutton14.m.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings

  # Menu widget code
  .frame0.menubutton14.m.m add command\
    -command {SendToEmacs {(info)}}\
    -label {Previous entry}\
    -underline {0}
  .frame0.menubutton14.m.m add separator
  .frame0.menubutton14.m.m add command\
    -command {SendToEmacs {(info)}
SendToEmacs {(Info-directory)}
SendToEmacs {(Info-menu "GCC")}}\
    -label {GCC}\
    -underline {1}
  .frame0.menubutton14.m.m add command\
    -command {SendToEmacs {(info)}
SendToEmacs {(Info-directory)}
SendToEmacs {(Info-menu "GDB")}}\
    -label {GDB}\
    -underline {1}

  # pack widget .frame0
  pack append .frame0\
    .frame0.menubutton00   {left frame center} \
    .frame0.menubutton01   {left frame center} \
    .frame0.menubutton02   {left frame center} \
    .frame0.menubutton03   {left frame center} \
    .frame0.menubutton04   {left frame center} \
    .frame0.menubutton05   {left frame center} \
    .frame0.menubutton06   {left frame center} \
    .frame0.button01   {left frame center} \
    .frame0.menubutton14   {right frame center} 

  # bindings


  # pack widget .
  pack append .\
    .frame0   {top frame center fillx} \
    .frame   {top frame center expand fill} 

  if {[string length [info commands .XFEdit]] > 0} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .frame0
  }
}


# Procedure: AlertBox
proc AlertBox { {alertBoxMessage "Alert message"} {alertBoxGeometry "350x150"} args} {
  # Description: show alert box
  # Arguments: alertBoxMessage - the text to display
  #            alertBoxGeometry - the geometry for the window
  #            args - labels of buttons
  # Returns: The number of the selected button
  # Notes: there exists also functions called:
  #          AlertBoxFile - to open and read a file automatically
  #          AlertBoxFd - to read from an already opened filedescriptor
  #
  # global alertBoxActiveBackground - active background color
  # global alertBoxActiveForeground - active foreground color
  # global alertBoxAnchor - anchor for message box
  # global alertBoxBackground - background color
  # global alertBoxFont - message font
  # global alertBoxForeground - foreground color
  # global alertBoxJustify - justify for message box

  global alertBoxButton

  # show alert box
  if {[llength $args] > 0} {
    eval AlertBoxInternal "\{$alertBoxMessage\}" "\{$alertBoxGeometry\}" $args
  } {
    AlertBoxInternal $alertBoxMessage $alertBoxGeometry
  }

  # wait for the box to be destroyed
  update idletask
  grab .alertBox
  tkwait window .alertBox

  return $alertBoxButton
}


# Procedure: AlertBoxInternal
proc AlertBoxInternal { alertBoxMessage alertBoxGeometry args} {
  global alertBoxActiveBackground
  global alertBoxActiveForeground
  global alertBoxAnchor
  global alertBoxBackground
  global alertBoxFont
  global alertBoxForeground
  global alertBoxJustify
  global alertBoxButton

  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .alertBox}
  } {
    catch {destroy .alertBox}
  }
  toplevel .alertBox     -background "$alertBoxBackground"     -borderwidth 0
  if {[catch "wm geometry .alertBox $alertBoxGeometry"]} {
    wm geometry .alertBox 350x150
  }
  wm title .alertBox {Alert box}
  wm maxsize .alertBox 1000 1000
  wm minsize .alertBox 100 100
  wm positionfrom .alertBox program
  wm sizefrom .alertBox user

  message .alertBox.message1     -background "$alertBoxBackground"     -foreground "$alertBoxForeground"     -font "$alertBoxFont"     -anchor "$alertBoxAnchor"     -justify "$alertBoxJustify"     -relief raised     -text "$alertBoxMessage"
  set xfTmpWidth     [string range $alertBoxGeometry 0 [expr [string first x $alertBoxGeometry]-1]]
  if {"$xfTmpWidth" != ""} {
    # set message size
    catch ".alertBox.message1 configure       -width [expr $xfTmpWidth-10]"
  } {
    .alertBox.message1 configure       -aspect 1500
  }

  frame .alertBox.frame1     -background "$alertBoxBackground"     -borderwidth 0     -relief raised

  set alertCounter 0
  set buttonNum [llength $args]

  if {$buttonNum > 0} {
    while {$alertCounter < $buttonNum} {
      button .alertBox.frame1.button$alertCounter         -activebackground "$alertBoxActiveBackground"         -activeforeground "$alertBoxActiveForeground"         -background "$alertBoxBackground"         -foreground "$alertBoxForeground"         -font "$alertBoxFont"         -text "[lindex $args $alertCounter]"         -command "
          global alertBoxButton
          set alertBoxButton $alertCounter
          if {\"\[info commands XFDestroy\]\" != \"\"} {
            catch {XFDestroy .alertBox}
          } {
            catch {destroy .alertBox}
          }"

      pack append .alertBox.frame1                   .alertBox.frame1.button$alertCounter {left fillx expand}

      incr alertCounter
    }
  } {
    button .alertBox.frame1.button0       -activebackground "$alertBoxActiveBackground"       -activeforeground "$alertBoxActiveForeground"       -background "$alertBoxBackground"       -foreground "$alertBoxForeground"       -font "$alertBoxFont"       -text "OK"       -command "
        global alertBoxButton
        set alertBoxButton 0
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch {XFDestroy .alertBox}
        } {
          catch {destroy .alertBox}
        }"

    pack append .alertBox.frame1                 .alertBox.frame1.button0 {left fillx expand}
  }

  # packing
  pack append .alertBox               .alertBox.frame1 {bottom fill}               .alertBox.message1 {top fill expand}
}


# Procedure: ColorBox
proc ColorBox { {colorFileColor "/usr/local/lib/xf/lib/Colors"} {colorMessage "Color:"}} {
  # Description: select a color
  # Arguments: colorFileColor - the color file with all colornames
  #            colorMessage - a message to display
  # Returns: colorname
  # 
  # global colorBoxActiveBackground - active background color
  # global colorBoxActiveForeground - active foreground color
  # global colorBoxBackground - background color
  # global colorBoxFont - text font
  # global colorBoxForeground - foreground color
  # global colorBoxScrollActiveForeground - scrollbar active background color
  # global colorBoxScrollBackground - scrollbar background color
  # global colorBoxScrollForeground - scrollbar foreground color

  global colorBoxName
  global colorBoxActiveBackground
  global colorBoxActiveForeground
  global colorBoxBackground
  global colorBoxFont
  global colorBoxForeground
  global colorBoxScrollActiveForeground
  global colorBoxScrollBackground
  global colorBoxScrollForeground

  set colorBoxName ""

  # get color file name
  if {!([file exists $colorFileColor] &&
        [file readable $colorFileColor])} {
    set colorFileColor ""
  }
  if {"$colorFileColor" == ""} {
    global env
    if {[info exists env(XF_COLOR_FILE)]} {
      if {[file exists $env(XF_COLOR_FILE)] &&
          [file readable $env(XF_COLOR_FILE)]} {
        set colorFileColor $env(XF_COLOR_FILE)
      }
    }
  }

  # build widget structure
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .colorBox}
  } {
    catch {destroy .colorBox}
  }
  toplevel .colorBox     -background "$colorBoxBackground"     -borderwidth 0
  wm geometry .colorBox 400x477
  wm title .colorBox {Color box}
  wm maxsize .colorBox 1000 1000
  wm minsize .colorBox 100 100
  wm positionfrom .colorBox program
  wm sizefrom .colorBox user

  frame .colorBox.frame1     -background "$colorBoxBackground"     -borderwidth 0     -relief raised
 
  button .colorBox.frame1.ok     -activebackground "$colorBoxActiveBackground"     -activeforeground "$colorBoxActiveForeground"     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -text "OK"     -command "
      global colorBoxName
      set colorBoxName \[.colorBox.current.current get\]
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .colorBox}
      } {
        catch {destroy .colorBox}
      }"

  button .colorBox.frame1.cancel     -activebackground "$colorBoxActiveBackground"     -activeforeground "$colorBoxActiveForeground"     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -text "Cancel"     -command "
      global colorBoxName
      set colorBoxName {}
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .colorBox}
      } {
        catch {destroy .colorBox}
      }"

  scale .colorBox.red     -activeforeground "$colorBoxScrollActiveForeground"     -background red     -foreground "$colorBoxForeground"     -from 0     -label "Red"     -orient horizontal     -relief raised     -sliderlength 15     -to 255     -width 8     -command "ColorBoxSetRGBColor $colorMessage"

   scale .colorBox.green     -activeforeground "$colorBoxScrollActiveForeground"     -background green     -foreground "$colorBoxForeground"     -from 0     -label "Green"     -orient horizontal     -relief raised     -sliderlength 15     -to 255     -width 8     -command "ColorBoxSetRGBColor $colorMessage"

  scale .colorBox.blue     -activeforeground "$colorBoxScrollActiveForeground"     -background blue     -foreground "$colorBoxForeground"     -from 0     -label "Blue"     -orient horizontal     -relief raised     -sliderlength 15     -to 255     -width 8     -command "ColorBoxSetRGBColor $colorMessage"

  scale .colorBox.h     -activeforeground "$colorBoxScrollActiveForeground"     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -from 0     -label "Hue"     -orient horizontal     -relief raised     -sliderlength 15     -to 360     -width 8     -command "ColorBoxSetHSVColor $colorMessage"

   scale .colorBox.s     -activeforeground "$colorBoxScrollActiveForeground"     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -from 0     -label "Saturation * 100"     -orient horizontal     -relief raised     -sliderlength 15     -to 100     -width 8     -command "ColorBoxSetHSVColor $colorMessage"

  scale .colorBox.v     -activeforeground "$colorBoxScrollActiveForeground"     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -from 0     -label "Value"     -orient horizontal     -relief raised     -sliderlength 15     -to 255     -width 8     -command "ColorBoxSetHSVColor $colorMessage"

  label .colorBox.demo     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -relief raised     -text "This text shows the results :-)"

  frame .colorBox.current     -background "$colorBoxBackground"     -borderwidth 0     -relief raised

  label .colorBox.current.labelcurrent     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -relief raised     -text "$colorMessage"

  entry .colorBox.current.current     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -relief raised

  frame .colorBox.colors     -background "$colorBoxBackground"     -borderwidth 0     -relief raised

  scrollbar .colorBox.colors.vscroll     -activeforeground "$colorBoxScrollActiveForeground"     -background "$colorBoxScrollBackground"     -foreground "$colorBoxScrollForeground"     -relief raised     -command ".colorBox.colors.colors yview"

  scrollbar .colorBox.colors.hscroll     -activeforeground "$colorBoxScrollActiveForeground"     -background "$colorBoxScrollBackground"     -foreground "$colorBoxScrollForeground"     -orient horiz     -relief raised     -command ".colorBox.colors.colors xview"

  listbox .colorBox.colors.colors     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -exportselection false     -relief raised     -xscrollcommand ".colorBox.colors.hscroll set"     -yscrollcommand ".colorBox.colors.vscroll set"

  # read color file
  if {"$colorFileColor" != ""} {
    if {[catch "open $colorFileColor r" colorInFile]} {
      puts stderr "$colorInFile"
      set colorFileColor ""
    } {
      while {1 == 1} {
        if {[gets $colorInFile colorLine] == -1} {
          break
        }
        set colorNewLine [lrange $colorLine 3 end]
        append colorNewLine " " [format #%02x [lindex $colorLine 0]]
        append colorNewLine [format %02x [lindex $colorLine 1]]
        append colorNewLine [format %02x [lindex $colorLine 2]]
        .colorBox.colors.colors insert end $colorNewLine
      }
      close $colorInFile
    }
  }

  # bindings
  bind .colorBox.current.current <Delete> {
    EntryBS %W}
  bind .colorBox.current.current <BackSpace> {
    EntryBS %W}
  bind .colorBox.current.current <Right> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W }
  bind .colorBox.current.current <Left> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W }
  bind .colorBox.current.current <Control-a> {
    %W icursor 0
    %W view 0}
  bind .colorBox.current.current <Control-b> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W}
  bind .colorBox.current.current <Control-d> {
    %W delete [%W index insert]
    EntryV2C %W }
  bind .colorBox.current.current <Control-e> {
    %W icursor end
    EntryV2C %W}
  bind .colorBox.current.current <Control-f> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .colorBox.current.current <Control-h> {
    EntryBS %W}
  bind .colorBox.current.current <Meta-h> {
    %W delete 0 insert
    %W view insert}
  bind .colorBox.current.current <Control-i> {
    %W insert insert \t}
  bind .colorBox.current.current <Control-k> {
    %W delete insert end
    EntryV2C %W}
  bind .colorBox.current.current <Control-l> {
    EntryV2C %W}
  bind .colorBox.current.current <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index insert]-2]]
    set char2 [string index $contents [expr [%W index insert]-1]]
    %W delete [expr [%W index insert]-2] [expr [%W index insert]-1]
    %W insert [%W index insert] "$char2$char1"
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .colorBox.current.current <Control-v> {
    %W insert insert "[GetSelection]"}
  bind .colorBox.current.current <Control-w> {
    catch "%W delete sel.first sel.last"
    EntryV2C %W}
  bind .colorBox.current.current <Control-y> {
    %W insert insert "[GetSelection]"}
  bind .colorBox.current.current <space> {
    %W insert insert " "
    EntryV2C %W}
  bind .colorBox.current.current <Any-Key> {
    %W insert insert "%A"
    EntryV2C %W}
  bind .colorBox.current.current <Return> {
    catch ".colorBox.demo configure -background       [.colorBox.current.current get]"}

  bind .colorBox.colors.colors <ButtonPress-1> {
    ColorBoxSelectColor %W %y}
  bind .colorBox.colors.colors <Button1-Motion> {
    ColorBoxSelectColor %W %y}
  bind .colorBox.colors.colors <Shift-ButtonPress-1> {
    ColorBoxSelectColor %W %y}
  bind .colorBox.colors.colors <Shift-Button1-Motion> {
    ColorBoxSelectColor %W %y}

  # packing
  pack append .colorBox.frame1               .colorBox.frame1.ok {left fill expand}               .colorBox.frame1.cancel {left fill expand}
  pack append .colorBox.current               .colorBox.current.labelcurrent {left}               .colorBox.current.current {left fill expand}
  pack append .colorBox.colors               .colorBox.colors.vscroll {left filly}               .colorBox.colors.hscroll {bottom fillx}               .colorBox.colors.colors {left fill expand}

  if {[string length $colorFileColor] > 0} {
    pack append .colorBox                 .colorBox.frame1 {bottom fillx}                 .colorBox.current {bottom fillx}                 .colorBox.demo {bottom fillx}                 .colorBox.red {top fillx}                 .colorBox.green {top fillx}                 .colorBox.blue {top fillx}                 .colorBox.h {top fillx}                 .colorBox.s {top fillx}                 .colorBox.v {top fillx}                 .colorBox.colors {top fill expand}
  } {
    wm geometry .colorBox 400x345
    pack append .colorBox                 .colorBox.frame1 {bottom fillx}                 .colorBox.current {bottom fillx}                 .colorBox.red {top fillx}                 .colorBox.green {top fillx}                 .colorBox.blue {top fillx}                 .colorBox.h {top fillx}                 .colorBox.s {top fillx}                 .colorBox.v {top fillx}                 .colorBox.demo {bottom fill expand}
  }

  # wait for the box to be destroyed
  update idletask
  grab .colorBox
  tkwait window .colorBox

  return $colorBoxName
}


# Procedure: ColorBoxSelectColor
proc ColorBoxSelectColor { colorW colorY} {

  set colorNearest [$colorW nearest $colorY]
  if {$colorNearest >= 0} {
    $colorW select from $colorNearest
    $colorW select to $colorNearest
    set colorTmpValue [$colorW get $colorNearest]
    set colorCurrentColor [lrange $colorTmpValue 0           [expr [llength $colorTmpValue]-2]]
    set colorCurrentValue [lrange $colorTmpValue           [expr [llength $colorTmpValue]-1] end]

    scan [string range $colorCurrentValue 1 2] "%x" colorValue
    .colorBox.red set $colorValue
    scan [string range $colorCurrentValue 3 4] "%x" colorValue
    .colorBox.green set $colorValue
    scan [string range $colorCurrentValue 5 6] "%x" colorValue
    .colorBox.blue set $colorValue

    .colorBox.current.current delete 0 end
    .colorBox.current.current insert 0 $colorCurrentColor
    catch ".colorBox.demo configure -background $colorCurrentColor"
  }
}


# Procedure: ColorBoxSetHSVColor
proc ColorBoxSetHSVColor { colorMessage colorValue} {

  set H [expr ([.colorBox.h get]%360)/60.0]
  set Hint [expr ([.colorBox.h get]%360)/60]
  set Hfloat [expr $H-$Hint]
  set S [expr [.colorBox.s get]/100.0]
  set V [.colorBox.v get]
  set tmp1 [expr $V*(1.0-$S)]
  set tmp2 [expr $V*(1.0-$S*$Hfloat)]
  set tmp3 [expr $V*(1.0-$S*(1.0-$Hfloat))]

  case $Hint in {
    {0} {
      set red $V
      set green $tmp3
      set blue $tmp1
    }
    {1} {
      set red $tmp2
      set green $V
      set blue $tmp1
    }
    {2} {
      set red $tmp1
      set green $V
      set blue $tmp3
    }
    {3} {
      set red $tmp1
      set green $tmp2
      set blue $V
    }
    {4} {
      set red $tmp3
      set green $tmp1
      set blue $V
    }
    {default} {
      set red $V
      set green $tmp1
      set blue $tmp2
    }
  }

  if {[string first . $red] >= 0} {
    set red [string range $red 0 [expr [string first . $red]-1]]
  }
  if {[string first . $green] >= 0} {
    set green [string range $green 0 [expr [string first . $green]-1]]
  }
  if {[string first . $blue] >= 0} {
    set blue [string range $blue 0 [expr [string first . $blue]-1]]
  }

  .colorBox.red configure     -command "NoFunction"
  .colorBox.green configure     -command "NoFunction"
  .colorBox.blue configure     -command "NoFunction"
  .colorBox.red set $red
  .colorBox.green set $green
  .colorBox.blue set $blue
  .colorBox.red configure     -command "ColorBoxSetRGBColor $colorMessage"
  .colorBox.green configure     -command "ColorBoxSetRGBColor $colorMessage"
  .colorBox.blue configure     -command "ColorBoxSetRGBColor $colorMessage"

  .colorBox.current.current delete 0 end
  .colorBox.current.current insert 0     [format #%02x%02x%02x [.colorBox.red get]       [.colorBox.green get] [.colorBox.blue get]]
  if {[string match "*oreground*" $colorMessage]} {
    catch ".colorBox.demo configure -foreground       [format #%02x%02x%02x [.colorBox.red get]         [.colorBox.green get] [.colorBox.blue get]]"
  } {
    catch ".colorBox.demo configure -background       [format #%02x%02x%02x [.colorBox.red get]         [.colorBox.green get] [.colorBox.blue get]]"
  }
}


# Procedure: ColorBoxSetRGBColor
proc ColorBoxSetRGBColor { colorMessage colorValue} {

  set R [.colorBox.red get].0
  set G [.colorBox.green get].0
  set B [.colorBox.blue get].0
  set cMax $R
  set cMin $G
  set iMax 1
  if {$cMax < $G} {
    set cMax $G
    set cMin $R
    set iMax 2
  }
  if {$cMax < $B} {
    set cMax $B
    set iMax 3
  }
  if {$cMin > $B} {
    set cMin $R
  }
  set cMM [expr $cMax-$cMin]
  set V $cMax
  if {$cMM == 0} {
    set S 0
    set H 0
  } {
    set S [expr $cMM/$cMax]
    case $iMax in {
      {1} {
        set H [expr ($G-$B)/$cMM]
      }
      {2} {
        set H [expr 2.0+($B-$R)/$cMM]
      }
      {3} {
        set H [expr 4.0+($R-$G)/$cMM]
      }
    }
    if {$H < 0} {
      set H [expr $H+6.0]
    }
  }
  set H [expr $H*60.0]
  set S [expr $S*100.0]

  if {[string first . $H] >= 0} {
    set H [string range $H 0 [expr [string first . $H]-1]]
  }
  if {[string first . $S] >= 0} {
    set S [string range $S 0 [expr [string first . $S]-1]]
  }
  if {[string first . $V] >= 0} {
    set V [string range $V 0 [expr [string first . $V]-1]]
  }

  .colorBox.h configure     -command "NoFunction"
  .colorBox.s configure     -command "NoFunction"
  .colorBox.v configure     -command "NoFunction"
  .colorBox.h set $H
  .colorBox.s set $S
  .colorBox.v set $V
  .colorBox.h configure     -command "ColorBoxSetHSVColor $colorMessage"
  .colorBox.s configure     -command "ColorBoxSetHSVColor $colorMessage"
  .colorBox.v configure     -command "ColorBoxSetHSVColor $colorMessage"

  .colorBox.current.current delete 0 end
  .colorBox.current.current insert 0     [format #%02x%02x%02x [.colorBox.red get]       [.colorBox.green get] [.colorBox.blue get]]
  if {[string match "*oreground*" $colorMessage]} {
    catch ".colorBox.demo configure -foreground       [format #%02x%02x%02x [.colorBox.red get]         [.colorBox.green get] [.colorBox.blue get]]"
  } {
    catch ".colorBox.demo configure -background       [format #%02x%02x%02x [.colorBox.red get]         [.colorBox.green get] [.colorBox.blue get]]"
  }
}


# Procedure: EmacsBuildBuffList
proc EmacsBuildBuffList { emacsW} {
  global emacsBuffList

  set buffList ""
  set tmpBuffList [string trim [.frame.text send "(mapcar 'buffer-name (buffer-list))"] ()]
  foreach counter $tmpBuffList {
    if {[string index $counter 0] != " "} {
      append buffList "\{$counter\} "
    }
  }
  set buffList [lsort $buffList]
  if {"$buffList" == "$emacsBuffList"} {
    return
  }
  set emacsBuffList $buffList

  catch "destroy $emacsW.m"
  menu $emacsW.m

  set counter 0
  foreach buffName $buffList {
    $emacsW.m add cascade      -label "$buffName"      -menu "$emacsW.m.$counter"

    menu $emacsW.m.$counter
    $emacsW.m.$counter add command      -accelerator {C-x b}      -label "Switch to buffer"      -command "
        SendToEmacs \{(switch-to-buffer \"$buffName\")\}"
    $emacsW.m.$counter add command      -accelerator {C-x 4 b}      -label "Switch to buffer other window"      -command "
        SendToEmacs \{(switch-to-buffer-other-window \"$buffName\")\}"
    $emacsW.m.$counter add command      -label "Bury buffer"      -command "
        SendToEmacs \{(bury-buffer)\}"
    $emacsW.m.$counter add separator
    $emacsW.m.$counter add command      -accelerator {C-x k}      -command "SendToEmacs \{(kill-buffer \"$buffName\")\}"      -label {Kill buffer}      -underline {0}
    incr counter
  }
  EmacsSetWidgetResources $emacsW.m
  update idletask
}


# Procedure: EmacsDoubleClick
proc EmacsDoubleClick {} {
  global emacsCurrentMenu

  set emacsMode [.frame.text send mode-name]
  set menuName .
  foreach counter [split $emacsMode] {
    append menuName [string trim $counter]
  }
  if {"$menuName" != "." && "[info commands $menuName]" != ""} {
    catch "$menuName invoke 0"
  }
}


# Procedure: EmacsError
proc EmacsError { emacsW emacsMessage} {
  global emacsErrorMessage
  
  append emacsErrorMessage "$emacsMessage\n"
  TextBox $emacsErrorMessage 400x300
}


# Procedure: EmacsPopup
proc EmacsPopup { emacsX emacsY} {
  global emacsCurrentMenu

  set emacsMode [.frame.text send mode-name]
  set menuName .
  foreach counter [split $emacsMode] {
    append menuName [string trim $counter]
  }
  if {"$menuName" != "." && "[info commands $menuName]" != ""} {
    set emacsCurrentMenu $menuName
    $menuName post $emacsX $emacsY
  } {
    set emacsCurrentMenu .emacs-default
    .emacs-default post $emacsX $emacsY
  }
}


# Procedure: EmacsPopupHandle
proc EmacsPopupHandle { emacsX emacsY} {
  global emacsCurrentMenu

  if {"$emacsCurrentMenu" != "" &&
      [winfo ismapped $emacsCurrentMenu]} {
    set emacsPopMinX [winfo rootx $emacsCurrentMenu]
    set emacsPopMaxX       [expr "$emacsPopMinX + [winfo width $emacsCurrentMenu]"]
    if {($emacsX >= $emacsPopMinX) && ($emacsX <= $emacsPopMaxX)} {
      $emacsCurrentMenu activate @[expr "$emacsY - [winfo rooty $emacsCurrentMenu]"]
    } {
      $emacsCurrentMenu activate none
    }
  }
}


# Procedure: EmacsQuit
proc EmacsQuit {} {

  if {"[info commands ClientShutdown]" != ""} {
    wm iconify .
    wm withdraw .
  } {
    SendToEmacs {(progn (tk-advise-destroy-widget-on-exit)
                 (save-buffers-kill-emacs))}
  }
}


# Procedure: EmacsSaveOptions
proc EmacsSaveOptions {} {
  global bindPopupDown
  global oldBindPopupDown
  global bindPopupRelease
  global oldBindPopupRelease
  global bindPopupMove
  global oldBindPopupMove
  global emacsPopupBind
  global emacsActBackground
  global emacsActForeground
  global emacsBackground
  global emacsForeground
  global emacsFont
  global emacsEmacsFont
  global emacsEmacsCursor
  global emacsPollInterval
  global emacsScrollActForeground
  global emacsScrollForeground
  global emacsUseAdvise

  if {![catch "open ~/.xfemacs-o.tcl w" outFile]} {
    puts $outFile "global bindPopupDown"
    puts $outFile "set bindPopupDown \{$bindPopupDown\}"
    puts $outFile "global bindPopupRelease"
    puts $outFile "set bindPopupRelease \{$bindPopupRelease\}"
    puts $outFile "global bindPopupMove"
    puts $outFile "set bindPopupMove \{$bindPopupMove\}"
    puts $outFile "global emacsPopupBind"
    puts $outFile "set emacsPopupBind \{$emacsPopupBind\}"
    puts $outFile "global emacsActBackground"
    puts $outFile "set emacsActBackground $emacsActBackground"
    puts $outFile "global emacsActForeground"
    puts $outFile "set emacsActForeground $emacsActForeground"
    puts $outFile "global emacsBackground"
    puts $outFile "set emacsBackground $emacsBackground"
    puts $outFile "global emacsForeground"
    puts $outFile "set emacsForeground $emacsForeground"
    puts $outFile "global emacsFont"
    puts $outFile "set emacsFont $emacsFont"
    puts $outFile "global emacsEmacsFont"
    puts $outFile "set emacsEmacsFont $emacsEmacsFont"
    puts $outFile "global emacsEmacsCursor"
    puts $outFile "set emacsEmacsCursor $emacsEmacsCursor"
    puts $outFile "global emacsPollInterval"
    puts $outFile "set emacsPollInterval \{$emacsPollInterval\}"
    puts $outFile "global emacsScrollActForeground"
    puts $outFile "set emacsScrollActForeground $emacsScrollActForeground"
    puts $outFile "global emacsScrollForeground"
    puts $outFile "set emacsScrollForeground $emacsScrollForeground"
    puts $outFile "global emacsUseAdvise"
    puts $outFile "set emacsUseAdvise $emacsUseAdvise"
    close $outFile
  } {
    puts stderr "could not open options file ~/.xfemacs-o.tcl"
  }
}


# Procedure: EmacsSetBinding
proc EmacsSetBinding {} {
  global bindPopupDown
  global oldBindPopupDown
  global bindPopupRelease
  global oldBindPopupRelease
  global bindPopupMove
  global oldBindPopupMove

  if {"$bindPopupDown" != "$oldBindPopupDown"} {
    bind .frame.text $oldBindPopupDown {}
    bind .frame.text $bindPopupDown {EmacsPopup %X %Y}
    set oldBindPopupDown $bindPopupDown
  }
  if {"$bindPopupRelease" != "$oldBindPopupRelease"} {
    bind .frame.text $oldBindPopupRelease {}
    bind .frame.text $bindPopupRelease {
      global emacsCurrentMenu
      if {"$emacsCurrentMenu" != ""} {
        $emacsCurrentMenu invoke active
        $emacsCurrentMenu unpost
        set emacsCurrentMenu ""
      }}
    set oldBindPopupRelease $bindPopupRelease
  }
  if {"$bindPopupMove" != "$oldBindPopupMove"} {
    bind .frame.text $oldBindPopupMove {}
    bind .frame.text $bindPopupMove {EmacsPopupHandle %X %Y}
    set oldBindPopupMove $bindPopupMove
  }
}


# Procedure: EmacsSetModeMenu
proc EmacsSetModeMenu { emacsW} {

  set emacsMode [.frame.text send mode-name]
  set menuName .
  foreach counter [split $emacsMode] {
    append menuName [string trim $counter]
  }
  if {"$menuName" != "." && "[info commands $menuName]" != ""} {
    $emacsW config -menu "$menuName"
  } {
    $emacsW config -menu ".emacs-default"
  }
}


# Procedure: EmacsSetWidgetResources
proc EmacsSetWidgetResources { emacsW} {
  global emacsActBackground
  global emacsActForeground
  global emacsBackground
  global emacsForeground
  global emacsFont
  global emacsEmacsFont
  global emacsEmacsCursor
  global emacsScrollActForeground
  global emacsScrollForeground

  if {"[info commands $emacsW]" == "" &&
      "$emacsW" != "."} {
    return
  }
  set emacsOptions ""
  case [winfo class $emacsW] in {
    {Button CheckButton RadioButton Menubutton Menu} {
      if {"$emacsActBackground" != ""} {
        append emacsOptions " -activebackground $emacsActBackground"
      }
      if {"$emacsActForeground" != ""} {
        append emacsOptions " -activeforeground $emacsActForeground"
      }
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsForeground" != ""} {
        append emacsOptions " -foreground $emacsForeground"
      }
      if {"$emacsFont" != ""} {
        append emacsOptions " -font $emacsFont"
      }
    }
    {Listbox} {
      if {"$emacsActBackground" != ""} {
        append emacsOptions " -selectbackground $emacsActBackground"
      }
      if {"$emacsActForeground" != ""} {
        append emacsOptions " -selectforeground $emacsActForeground"
      }
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsForeground" != ""} {
        append emacsOptions " -foreground $emacsForeground"
      }
      if {"$emacsFont" != ""} {
        append emacsOptions " -font $emacsFont"
      }
    }
    {Frame Toplevel} {
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
    }
    {Label Message Text Entry} {
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsForeground" != ""} {
        append emacsOptions " -foreground $emacsForeground"
      }
      if {"$emacsFont" != ""} {
        append emacsOptions " -font $emacsFont"
      }
      if {[string compare Entry [winfo class $emacsW]] == 0} {
        if {"$emacsEmacsCursor" != ""} {
          append emacsOptions " -cursorbackground $emacsEmacsCursor"
        }
      }
    }
    {Scrollbar} {
      if {"$emacsScrollActForeground" != ""} {
        append emacsOptions " -activeforeground $emacsScrollActForeground"
      }
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsScrollForeground" != ""} {
        append emacsOptions " -foreground $emacsScrollForeground"
      }
    }
    {Scale} {
      if {"$emacsScrollActForeground" != ""} {
        append emacsOptions " -activeforeground $emacsScrollActForeground"
      }
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsScrollForeground" != ""} {
        append emacsOptions " -foreground $emacsForeground"
      }
    }
    {TkEmacs Text} {
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsForeground" != ""} {
        append emacsOptions " -foreground $emacsForeground"
      }
      if {"$emacsEmacsFont" != ""} {
        append emacsOptions " -font $emacsEmacsFont"
      }
      if {"$emacsEmacsCursor" != ""} {
        append emacsOptions " -insertbackground $emacsEmacsCursor"
      }
    }
  }
  if {"$emacsOptions" != ""} {
    catch "$emacsW config $emacsOptions" xfres
  }
  foreach counter [winfo children $emacsW] {
    EmacsSetWidgetResources $counter
  }
}


# Procedure: EmacsUpdateResources
proc EmacsUpdateResources {} {

  foreach counter [lsort [winfo children .frame0]] {
    pack unpack $counter
  }
  set emacsButtonList ""
  foreach counter [lsort [winfo children .frame0]] {
    if {"[string trim [lindex [$counter config -text] 4]]" != ""} {
      if {"[winfo class $counter]" == "Menubutton"} {
        set emacsButtonList "$emacsButtonList $counter"
      }
      if {"$counter" == ".frame0.menubutton14"} {
        pack append .frame0           .frame0.button01 {left frame center}
        pack append .frame0           $counter {right frame center}
      } {
        pack append .frame0           $counter {left frame center}
      }
      if {"[lindex [$counter config -text] 4]" == "Buffers"} {
        bind $counter <1> {
          EmacsBuildBuffList %W
          tk_mbButtonDown %W}
        bind $counter <B1-Enter> {
          EmacsBuildBuffList %W
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }}
        bind $counter <2> {
          EmacsBuildBuffList %W
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }}
      } {
        if {"[winfo class $counter]" == "Menubutton"} {
          bind $counter <1> {
            tk_mbButtonDown %W}
          bind $counter <B1-Enter> {
            set tk_priv(inMenuButton) %W
            if {([lindex [%W config -state] 4] != "disabled")
                && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
              if {!$tk_strictMotif} {
                %W config -state active
              }
              tk_mbPost %W
            }}
          bind $counter <2> {
            if {($tk_priv(posted) == "")
                && ([lindex [%W config -state] 4] != "disabled")} {
              set tk_priv(dragging) %W
                [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
            }}
        }
      }
    } {
      pack unpack $counter
    }
  }
  eval "tk_menuBar .frame0 $emacsButtonList"
  EmacsSetWidgetResources .
}


# Procedure: EntryBS
if {[string length [info procs EntryBS]] == 0} {
proc EntryBS { xfW} {

  set xfX [expr "[$xfW index insert]-1"]
  if {$xfX != -1} {
    $xfW delete $xfX
  }
  EntryV2C $xfW
}
}


# Procedure: EntryV2C
if {[string length [info procs EntryV2C]] == 0} {
proc EntryV2C { xfW} {

  set xfLeftExtent [$xfW index @0]
  set xfRightExtent [$xfW index @[winfo width $xfW]]
  set xfCursorPos [$xfW index insert]
  set xfEntryLen [expr "$xfRightExtent-$xfLeftExtent"]

  if {$xfCursorPos > $xfLeftExtent} {
    if {$xfCursorPos > $xfRightExtent} {
      #handle cursor too far to the right
      $xfW view [expr "$xfCursorPos-$xfEntryLen+1"]
    }
  } { 
    #handle cursor too far to the left
    $xfW view [expr "$xfCursorPos-1"]
  }
}
}


# Procedure: FSBox
proc FSBox { {fsBoxMessage "Select file:"} {fsBoxFileName ""}} {
  # Description: show file selector box
  # Arguments: fsBoxMessage - the text to display
  #            fsBoxFileName - a file name that should be selected
  # Returns: The filename that was selected
  # 
  # global fsBoxActiveBackground - active background color
  # global fsBoxActiveForeground - active foreground color
  # global fsBoxBackground - background color
  # global fsBoxFont - text font
  # global fsBoxForeground - foreground color
  # global fsBoxExtensions - scan directory for extensions
  # global fsBoxScrollActiveForeground - scrollbar active background color
  # global fsBoxScrollBackground - scrollbar background color
  # global fsBoxScrollForeground - scrollbar foreground color

  global fsBoxFSAll
  global fsBoxFSName
  global fsBoxFSPath
  global fsBoxFSInternalPath
  global fsBoxFSPattern
  global fsBoxActiveBackground
  global fsBoxActiveForeground
  global fsBoxBackground
  global fsBoxExtensions
  global fsBoxFont
  global fsBoxForeground
  global fsBoxScrollActiveForeground
  global fsBoxScrollBackground
  global fsBoxScrollForeground

  set fsBoxFSName $fsBoxFileName
  if {"$fsBoxFSPath" != "" &&
      [file exists $fsBoxFSPath] &&
      [file isdirectory $fsBoxFSPath]} {
    set fsBoxFSInternalPath $fsBoxFSPath
  } {
    if {"$fsBoxFSInternalPath" == "" ||
        ![file exists $fsBoxFSInternalPath]} {
      set fsBoxFSInternalPath [pwd]
    }
  }

  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .fsBox}
  } {
    catch {destroy .fsBox}
  }
  toplevel .fsBox     -background "$fsBoxBackground"     -borderwidth 0
  wm geometry .fsBox 350x300 
  wm title .fsBox {File select box}
  wm maxsize .fsBox 1000 1000
  wm minsize .fsBox 100 100
  wm positionfrom .fsBox program
  wm sizefrom .fsBox user

  label .fsBox.message1     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -anchor c     -relief raised     -text "$fsBoxMessage"

  frame .fsBox.frame1     -background "$fsBoxBackground"     -borderwidth 0     -relief raised

  button .fsBox.frame1.ok     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -text "OK"     -command "
      global fsBoxFSName
      global fsBoxFSPath
      global fsBoxFSInternalPath
      set fsBoxFSName \[.fsBox.file.file get\]
      set fsBoxFSPath \[.fsBox.path.path get\]
      set fsBoxFSInternalPath \[.fsBox.path.path get\]
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fsBox}
      } {
        catch {destroy .fsBox}
      }"

  button .fsBox.frame1.rescan     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -text "Rescan"     -command {
      global fsBoxFSAll
      FSBoxFSShow [.fsBox.path.path get]         [.fsBox.pattern.pattern get] $fsBoxFSAll}

  button .fsBox.frame1.cancel     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -text "Cancel"     -command "
      global fsBoxFSName
      global fsBoxFSPath
      set fsBoxFSName {}
      set fsBoxFSPath {}
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fsBox}
      } {
        catch {destroy .fsBox}
      }"

  frame .fsBox.path     -background "$fsBoxBackground"     -borderwidth 0     -relief raised

  frame .fsBox.path.paths     -background "$fsBoxBackground"     -borderwidth 2     -relief raised

  menubutton .fsBox.path.paths.paths     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -borderwidth 0     -underline 0     -menu ".fsBox.path.paths.paths.menu"     -relief flat     -text "Pathname:"

  menu .fsBox.path.paths.paths.menu     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"

  .fsBox.path.paths.paths.menu add command      -label "$fsBoxFSInternalPath"      -command "
       global fsBoxFSAll 
       global fsBoxFSInternalPath
       FSBoxFSShow \[.fsBox.path.path get\]          \[.fsBox.pattern.pattern get\] \$fsBoxFSAll
       .fsBox.path.path delete 0 end
       .fsBox.path.path insert 0 $fsBoxFSInternalPath"

  entry .fsBox.path.path     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -relief raised
  if {![file isdirectory $fsBoxFSInternalPath]} {
    set $fsBoxFSInternalPath [pwd]
  }
  .fsBox.path.path insert 0 $fsBoxFSInternalPath

  frame .fsBox.pattern     -background "$fsBoxBackground"     -borderwidth 0     -relief raised

  frame .fsBox.pattern.patterns     -background "$fsBoxBackground"     -borderwidth 2     -relief raised

  menubutton .fsBox.pattern.patterns.patterns     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -borderwidth 0     -underline 0     -menu ".fsBox.pattern.patterns.patterns.menu"     -relief flat     -text "Selection pattern:"

  menu .fsBox.pattern.patterns.patterns.menu     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"

  .fsBox.pattern.patterns.patterns.menu add checkbutton     -label "Scan extensions"     -variable fsBoxExtensions     -command {
      global fsBoxFSAll
      FSBoxFSShow [.fsBox.path.path get]         [.fsBox.pattern.pattern get] $fsBoxFSAll}

  entry .fsBox.pattern.pattern     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -relief raised
  .fsBox.pattern.pattern insert 0 $fsBoxFSPattern
  
  frame .fsBox.files     -background "$fsBoxBackground"     -borderwidth 0     -relief raised

  scrollbar .fsBox.files.vscroll     -activeforeground "$fsBoxScrollActiveForeground"     -background "$fsBoxScrollBackground"     -foreground "$fsBoxScrollForeground"     -relief raised     -command ".fsBox.files.files yview"

  scrollbar .fsBox.files.hscroll     -activeforeground "$fsBoxScrollActiveForeground"     -background "$fsBoxScrollBackground"     -foreground "$fsBoxScrollForeground"     -orient horiz     -relief raised     -command ".fsBox.files.files xview"

  listbox .fsBox.files.files     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -exportselection false     -relief raised     -xscrollcommand ".fsBox.files.hscroll set"     -yscrollcommand ".fsBox.files.vscroll set"

  frame .fsBox.file     -background "$fsBoxBackground"     -borderwidth 0     -relief raised

  label .fsBox.file.labelfile     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -relief raised     -text "Filename:"

  entry .fsBox.file.file     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -relief raised

  .fsBox.file.file delete 0 end
  .fsBox.file.file insert 0 $fsBoxFSName
  
  checkbutton .fsBox.pattern.all     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -offvalue 0     -onvalue 1     -text "Show all files"     -variable fsBoxFSAll     -command {
      global fsBoxFSAll
      FSBoxFSShow [.fsBox.path.path get]         [.fsBox.pattern.pattern get] $fsBoxFSAll}

  FSBoxFSShow $fsBoxFSInternalPath $fsBoxFSPattern $fsBoxFSAll

  # bindings
  bind .fsBox.files.files <Double-Button-1> {
    FSBoxBindSelectOne %W %y
    FSBoxFSFileSelectDouble %W %y}
  bind .fsBox.files.files <Button-1> {
    FSBoxBindSelectOne %W %y
    FSBoxFSFileSelect %W %y}
  bind .fsBox.files.files <Button1-Motion> {
    FSBoxBindSelectOne %W %y
    FSBoxFSFileSelect %W %y}
  bind .fsBox.files.files <Shift-Button1-Motion> {
    FSBoxBindSelectOne %W %y
    FSBoxFSFileSelect %W %y}
  bind .fsBox.files.files <Shift-Button-1> {
    FSBoxBindSelectOne %W %y
    FSBoxFSFileSelect %W %y}

  bind .fsBox.path.path <Delete> {
    EntryBS %W}
  bind .fsBox.path.path <BackSpace> {
    EntryBS %W}
  bind .fsBox.path.path <Right> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W }
  bind .fsBox.path.path <Left> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W }
  bind .fsBox.path.path <Control-a> {
    %W icursor 0
    %W view 0}
  bind .fsBox.path.path <Control-b> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W}
  bind .fsBox.path.path <Control-d> {
    %W delete [%W index insert]
    EntryV2C %W }
  bind .fsBox.path.path <Control-e> {
    %W icursor end
    EntryV2C %W}
  bind .fsBox.path.path <Control-f> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .fsBox.path.path <Control-h> {
    EntryBS %W}
  bind .fsBox.path.path <Meta-h> {
    %W delete 0 insert
    %W view insert}
  bind .fsBox.path.path <Control-i> {
    %W insert insert \t}
  bind .fsBox.path.path <Control-k> {
    %W delete insert end
    EntryV2C %W}
  bind .fsBox.path.path <Control-l> {
    EntryV2C %W}
  bind .fsBox.path.path <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index insert]-2]]
    set char2 [string index $contents [expr [%W index insert]-1]]
    %W delete [expr [%W index insert]-2] [expr [%W index insert]-1]
    %W insert [%W index insert] "$char2$char1"
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .fsBox.path.path <Control-v> {
    %W insert insert "[GetSelection]"}
  bind .fsBox.path.path <Control-w> {
    catch "%W delete sel.first sel.last"
    EntryV2C %W}
  bind .fsBox.path.path <Control-y> {
    %W insert insert "[GetSelection]"}
  bind .fsBox.path.path <space> {
    %W insert insert " "
    EntryV2C %W}
  bind .fsBox.path.path <Any-Key> {
    %W insert insert "%A"
    EntryV2C %W}
  bind .fsBox.path.path <Tab> {
    FSBoxFSNameComplete path}
  bind .fsBox.path.path <Return> {
    global fsBoxFSAll
    FSBoxFSShow [.fsBox.path.path get]       [.fsBox.pattern.pattern get] $fsBoxFSAll
    FSBoxFSInsertPath
    .fsBox.file.file icursor end
    focus .fsBox.file.file}
  catch "bind .fsBox.path.path <Up> {}"
  bind .fsBox.path.path <Down> {
    .fsBox.file.file icursor end
    focus .fsBox.file.file}

  bind .fsBox.file.file <Delete> {
    EntryBS %W}
  bind .fsBox.file.file <BackSpace> {
    EntryBS %W}
  bind .fsBox.file.file <Right> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W }
  bind .fsBox.file.file <Left> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W }
  bind .fsBox.file.file <Control-a> {
    %W icursor 0
    %W view 0}
  bind .fsBox.file.file <Control-b> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W}
  bind .fsBox.file.file <Control-d> {
    %W delete [%W index insert]
    EntryV2C %W }
  bind .fsBox.file.file <Control-e> {
    %W icursor end
    EntryV2C %W}
  bind .fsBox.file.file <Control-f> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .fsBox.file.file <Control-h> {
    EntryBS %W}
  bind .fsBox.file.file <Meta-h> {
    %W delete 0 insert
    %W view insert}
  bind .fsBox.file.file <Control-i> {
    %W insert insert \t}
  bind .fsBox.file.file <Control-k> {
    %W delete insert end
    EntryV2C %W}
  bind .fsBox.file.file <Control-l> {
    EntryV2C %W}
  bind .fsBox.file.file <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index insert]-2]]
    set char2 [string index $contents [expr [%W index insert]-1]]
    %W delete [expr [%W index insert]-2] [expr [%W index insert]-1]
    %W insert [%W index insert] "$char2$char1"
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .fsBox.file.file <Control-v> {
    %W insert insert "[GetSelection]"}
  bind .fsBox.file.file <Control-w> {
    catch "%W delete sel.first sel.last"
    EntryV2C %W}
  bind .fsBox.file.file <Control-y> {
    %W insert insert "[GetSelection]"}
  bind .fsBox.file.file <space> {
    %W insert insert " "
    EntryV2C %W}
  bind .fsBox.file.file <Any-Key> {
    %W insert insert "%A"
    EntryV2C %W}
  bind .fsBox.file.file <Tab> {
    FSBoxFSNameComplete file}
  bind .fsBox.file.file <Return> "
    global fsBoxFSName
    global fsBoxFSPath
    global fsBoxFSInternalPath
    set fsBoxFSName \[.fsBox.file.file get\]
    set fsBoxFSPath \[.fsBox.path.path get\]
    set fsBoxFSInternalPath \[.fsBox.path.path get\]
    if {\"\[info commands XFDestroy\]\" != \"\"} {
      catch {XFDestroy .fsBox}
    } {
      catch {destroy .fsBox}
    }"
  bind .fsBox.file.file <Up> {
    .fsBox.path.path icursor end
    focus .fsBox.path.path}
  bind .fsBox.file.file <Down> {
    .fsBox.pattern.pattern icursor end
    focus .fsBox.pattern.pattern}

  bind .fsBox.pattern.pattern <Delete> {
    EntryBS %W}
  bind .fsBox.pattern.pattern <BackSpace> {
    EntryBS %W}
  bind .fsBox.pattern.pattern <Right> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W }
  bind .fsBox.pattern.pattern <Left> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W }
  bind .fsBox.pattern.pattern <Control-a> {
    %W icursor 0
    %W view 0}
  bind .fsBox.pattern.pattern <Control-b> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W}
  bind .fsBox.pattern.pattern <Control-d> {
    %W delete [%W index insert]
    EntryV2C %W }
  bind .fsBox.pattern.pattern <Control-e> {
    %W icursor end
    EntryV2C %W}
  bind .fsBox.pattern.pattern <Control-f> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .fsBox.pattern.pattern <Control-h> {
    EntryBS %W}
  bind .fsBox.pattern.pattern <Meta-h> {
    %W delete 0 insert
    %W view insert}
  bind .fsBox.pattern.pattern <Control-i> {
    %W insert insert \t}
  bind .fsBox.pattern.pattern <Control-k> {
    %W delete insert end
    EntryV2C %W}
  bind .fsBox.pattern.pattern <Control-l> {
    EntryV2C %W}
  bind .fsBox.pattern.pattern <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index insert]-2]]
    set char2 [string index $contents [expr [%W index insert]-1]]
    %W delete [expr [%W index insert]-2] [expr [%W index insert]-1]
    %W insert [%W index insert] "$char2$char1"
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .fsBox.pattern.pattern <Control-v> {
    %W insert insert "[GetSelection]"}
  bind .fsBox.pattern.pattern <Control-w> {
    catch "%W delete sel.first sel.last"
    EntryV2C %W}
  bind .fsBox.pattern.pattern <Control-y> {
    %W insert insert "[GetSelection]"}
  bind .fsBox.pattern.pattern <space> {
    %W insert insert " "
    EntryV2C %W}
  bind .fsBox.pattern.pattern <Any-Key> {
    %W insert insert "%A"
    EntryV2C %W}
  bind .fsBox.pattern.pattern <Return> {
    global fsBoxFSAll
    FSBoxFSShow [.fsBox.path.path get]       [.fsBox.pattern.pattern get] $fsBoxFSAll}
  bind .fsBox.pattern.pattern <Up> {
    .fsBox.file.file icursor end
    focus .fsBox.file.file}
  catch "bind .fsBox.pattern.pattern <Down> {}"

  # packing
  pack append .fsBox.files               .fsBox.files.vscroll {left filly}               .fsBox.files.hscroll {bottom fillx}               .fsBox.files.files {left fill expand}
  pack append .fsBox.file               .fsBox.file.labelfile {left}               .fsBox.file.file {left fill expand}
  pack append .fsBox.frame1               .fsBox.frame1.ok {left fill expand}               .fsBox.frame1.rescan {left fill expand}               .fsBox.frame1.cancel {left fill expand}
  pack append .fsBox.path.paths               .fsBox.path.paths.paths {left}
  pack append .fsBox.pattern.patterns               .fsBox.pattern.patterns.patterns {left}
  pack append .fsBox.path               .fsBox.path.paths {left}               .fsBox.path.path {left fill expand}
  pack append .fsBox.pattern               .fsBox.pattern.patterns {left}               .fsBox.pattern.all {right fill}               .fsBox.pattern.pattern {left fill expand}
  pack append .fsBox               .fsBox.message1 {top fill}               .fsBox.frame1 {bottom fill}               .fsBox.pattern {bottom fill}               .fsBox.file {bottom fill}               .fsBox.path {bottom fill}               .fsBox.files {left fill expand}

  # wait for the box to be destroyed
  update idletask
  grab .fsBox
  tkwait window .fsBox

  if {"[string trim $fsBoxFSPath]" != "" ||
      "[string trim $fsBoxFSName]" != ""} {
    return [string trimright [string trim $fsBoxFSPath] /]/[string trimleft [string trim $fsBoxFSName] /]
  }
}


# Procedure: FSBoxBindSelectOne
proc FSBoxBindSelectOne { fsBoxW fsBoxY} {

  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    $fsBoxW select from $fsBoxNearest
    $fsBoxW select to $fsBoxNearest
  }
}


# Procedure: FSBoxFSFileSelect
proc FSBoxFSFileSelect { fsBoxW fsBoxY} {
  global fsBoxFSName
  global fsBoxFSInternalPath

  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    set fsBoxTmpEntry [$fsBoxW get $fsBoxNearest]
    if {"/" == "[string index $fsBoxTmpEntry           [expr [string length $fsBoxTmpEntry]-1]]" ||
        "@" == "[string index $fsBoxTmpEntry           [expr [string length $fsBoxTmpEntry]-1]]"} {
      set fsBoxFileName [string range $fsBoxTmpEntry 0             [expr [string length $fsBoxTmpEntry]-2]]
      if {![IsADir [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]] &&
          ![IsASymlink [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]]} {
        set fsBoxFileName $fsBoxTmpEntry
      }
    } {
      if {"*" == "[string index $fsBoxTmpEntry             [expr [string length $fsBoxTmpEntry]-1]]"} {
        set fsBoxFileName [string range $fsBoxTmpEntry 0               [expr [string length $fsBoxTmpEntry]-2]]
        if {![file executable $fsBoxFSInternalPath/$fsBoxFileName]} {
          set fsBoxFileName $fsBoxTmpEntry
        }
      } {
        set fsBoxFileName $fsBoxTmpEntry
      }
    }
    if {![IsADir [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]]} {
      set fsBoxFSName $fsBoxFileName
      .fsBox.file.file delete 0 end
      .fsBox.file.file insert 0 $fsBoxFSName
    }
  }
}


# Procedure: FSBoxFSFileSelectDouble
proc FSBoxFSFileSelectDouble { fsBoxW fsBoxY} {
  global fsBoxFSAll
  global fsBoxFSName
  global fsBoxFSPath
  global fsBoxFSInternalPath

  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    set fsBoxTmpEntry [$fsBoxW get $fsBoxNearest]
    if {"../" == "$fsBoxTmpEntry"} {
      set fsBoxTmpEntry [string trimright [string trimright [string trim $fsBoxFSInternalPath] /] @]
      if {[string length $fsBoxTmpEntry] <= 0} {
        return
      }
      FSBoxFSShow [file dirname $fsBoxTmpEntry]         [.fsBox.pattern.pattern get] $fsBoxFSAll
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 $fsBoxFSInternalPath
    } {
      if {"/" == "[string index $fsBoxTmpEntry             [expr [string length $fsBoxTmpEntry]-1]]" ||
          "@" == "[string index $fsBoxTmpEntry             [expr [string length $fsBoxTmpEntry]-1]]"} {
        set fsBoxFileName [string range $fsBoxTmpEntry 0               [expr [string length $fsBoxTmpEntry]-2]]
        if {![IsADir [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]] &&
            ![IsASymlink [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]]} {
          set fsBoxFileName $fsBoxTmpEntry
        }
      } {
        if {"*" == "[string index $fsBoxTmpEntry               [expr [string length $fsBoxTmpEntry]-1]]"} {
          set fsBoxFileName [string range $fsBoxTmpEntry 0                 [expr [string length $fsBoxTmpEntry]-2]]
          if {![file executable $fsBoxFSInternalPath/$fsBoxFileName]} {
            set fsBoxFileName $fsBoxTmpEntry
          }
        } {
          set fsBoxFileName $fsBoxTmpEntry
        }
      }
      if {[IsADir [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]]} {
        if {"/" == "[string index $fsBoxFSInternalPath               [expr [string length $fsBoxFSInternalPath]-1]]"} {
           append fsBoxFSInternalPath $fsBoxFileName
        } {
          append fsBoxFSInternalPath / $fsBoxFileName
        }
        FSBoxFSShow $fsBoxFSInternalPath           [.fsBox.pattern.pattern get] $fsBoxFSAll
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBoxFSInternalPath
      } {
        set fsBoxFSName $fsBoxFileName
        set fsBoxFSPath $fsBoxFSInternalPath
        if {[string length [info commands XFDestroy]] > 0} {
          catch {XFDestroy .fsBox}
        } {
          catch {destroy .fsBox}
        }
      }
    }
  }
}


# Procedure: FSBoxFSInsertPath
proc FSBoxFSInsertPath {} {
  global fsBoxFSInternalPath

  set fsBoxLast [.fsBox.path.paths.paths.menu index last]
  set fsBoxNewEntry [string trimright [string trimright [.fsBox.path.path get] /] @]
  for {set fsBoxCounter 0} {$fsBoxCounter <= $fsBoxLast} {incr fsBoxCounter 1} {
    if {"$fsBoxNewEntry" ==           "[lindex [.fsBox.path.paths.paths.menu entryconfigure                     $fsBoxCounter -label] 4]"} {
      return
    }
  }
  if {$fsBoxLast < 9} {
    .fsBox.path.paths.paths.menu add command       -label "$fsBoxNewEntry"       -command "
        global fsBoxFSAll 
        FSBoxFSShow $fsBoxNewEntry           \[.fsBox.pattern.pattern get\] \$fsBoxFSAll
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBoxNewEntry"
  } {
    for {set fsBoxCounter 0} {$fsBoxCounter < $fsBoxLast} {incr fsBoxCounter 1} {
      .fsBox.path.paths.paths.menu entryconfigure         $fsBoxCounter -label           [lindex [.fsBox.path.paths.paths.menu entryconfigure             [expr $fsBoxCounter+1] -label] 4]
      .fsBox.path.paths.paths.menu entryconfigure $fsBoxCounter         -command "
          global fsBoxFSAll 
          FSBoxFSShow [lindex [.fsBox.path.paths.paths.menu entryconfigure             [expr $fsBoxCounter+1] -label] 4]             \[.fsBox.pattern.pattern get\] \$fsBoxFSAll
          .fsBox.path.path delete 0 end
          .fsBox.path.path insert 0 [lindex             [.fsBox.path.paths.paths.menu entryconfigure               [expr $fsBoxCounter+1] -label] 4]"
    }
    .fsBox.path.paths.paths.menu entryconfigure $fsBoxLast       -label "$fsBoxNewEntry"
    .fsBox.path.paths.paths.menu entryconfigure $fsBoxCounter       -command "
        global fsBoxFSAll 
        FSBoxFSShow \[.fsBox.path.path get\]           \[.fsBox.pattern.pattern get\] \$fsBoxFSAll
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBoxNewEntry"
  }
}


# Procedure: FSBoxFSNameComplete
proc FSBoxFSNameComplete { fsBoxType} {

  set fsBoxNewFile ""
  set fsBoxMatched ""
  if {"$fsBoxType" == "path"} {
    set fsBoxDirName [file dirname [.fsBox.path.path get]]
    set fsBoxFileName [file tail [.fsBox.path.path get]]
  } {
    set fsBoxDirName [file dirname [.fsBox.path.path get]/]
    set fsBoxFileName [file tail [.fsBox.file.file get]]
  }
  set fsBoxFoundCounter 0
  if {[IsADir [string trimright $fsBoxDirName @]]} {
    catch "exec ls $fsBoxDirName/" fsBoxResult
    set fsBoxCounter 0
    set fsBoxListLength [llength $fsBoxResult]
    while {$fsBoxCounter < $fsBoxListLength} {
      if {"$fsBoxFileName" == ""} {
        if {$fsBoxFoundCounter == 0} {
          set fsBoxNewFile [lindex $fsBoxResult $fsBoxCounter]
        } {
          set fsBoxCounter1 0
          set fsBoxTmpFile1 $fsBoxNewFile
          set fsBoxTmpFile2 [lindex $fsBoxResult $fsBoxCounter]
          set fsBoxLength1 [string length $fsBoxTmpFile1]
          set fsBoxLength2 [string length $fsBoxTmpFile2]
          set fsBoxNewFile ""
          if {$fsBoxLength1 > $fsBoxLength2} {
            set fsBoxLength1 $fsBoxLength2
          }
          while {$fsBoxCounter1 < $fsBoxLength1} {
            if {"[string index $fsBoxTmpFile1 $fsBoxCounter1]" ==                   "[string index $fsBoxTmpFile2 $fsBoxCounter1]"} {
              append fsBoxNewFile [string index $fsBoxTmpFile1 $fsBoxCounter1]
            } {
              break
            }
            incr fsBoxCounter1 1
          }
        }
        incr fsBoxFoundCounter 1
      } {
        if {[regexp "^$fsBoxFileName" [lindex $fsBoxResult $fsBoxCounter]               fsBoxMatched]} {
          if {$fsBoxFoundCounter == 0} {
            set fsBoxNewFile [lindex $fsBoxResult $fsBoxCounter]
          } {
            set fsBoxCounter1 0
            set fsBoxTmpFile1 $fsBoxNewFile
            set fsBoxTmpFile2 [lindex $fsBoxResult $fsBoxCounter]
            set fsBoxLength1 [string length $fsBoxTmpFile1]
            set fsBoxLength2 [string length $fsBoxTmpFile2]
            set fsBoxNewFile ""
            if {$fsBoxLength1 > $fsBoxLength2} {
              set fsBoxLength1 $fsBoxLength2
            }
            while {$fsBoxCounter1 < $fsBoxLength1} {
              if {"[string index $fsBoxTmpFile1 $fsBoxCounter1]" ==                     "[string index $fsBoxTmpFile2 $fsBoxCounter1]"} {
                append fsBoxNewFile [string index $fsBoxTmpFile1 $fsBoxCounter1]
              } {
                break
              }
              incr fsBoxCounter1 1
            }
          }
          incr fsBoxFoundCounter 1
        }
      }
      incr fsBoxCounter 1
    }
  }
  if {$fsBoxFoundCounter == 1} {
    if {[IsADir [string trimright $fsBoxDirName/$fsBoxNewFile @]]} {
      if {"/" == "$fsBoxDirName"} {
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 "/[string trimright [string trim $fsBoxNewFile /] @]/"
      } {
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 "[string trimright $fsBoxDirName /]/[string trimright [string trim $fsBoxNewFile /] @]/"
      }
    } {
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 "[string trimright [string trimright $fsBoxDirName /] @]/"
      .fsBox.file.file delete 0 end
      .fsBox.file.file insert 0 "$fsBoxNewFile"
      .fsBox.file.file cursor end
      focus .fsBox.file.file
    }
  } {
    if {[IsADir [string trimright $fsBoxDirName/$fsBoxNewFile @]] ||
        "$fsBoxType" == "path"} {
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 "[string trimright $fsBoxDirName /]/[string trimright [string trim $fsBoxNewFile /] @]"
    } {
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 "$fsBoxDirName"
      if {[string length $fsBoxNewFile] > 0} {
        .fsBox.file.file delete 0 end
        .fsBox.file.file insert 0 "$fsBoxNewFile"
        .fsBox.file.file cursor end
        focus .fsBox.file.file
      }
    }
  }
}


# Procedure: FSBoxFSShow
proc FSBoxFSShow { fsBoxPath fsBoxPattern fsBoxAll} {
  global fsBoxActiveBackground
  global fsBoxActiveForeground
  global fsBoxBackground
  global fsBoxExtensions
  global fsBoxFont
  global fsBoxForeground
  global fsBoxScrollActiveForeground
  global fsBoxScrollBackground
  global fsBoxScrollForeground
  global fsBoxFSInternalPath
  global fsBoxFSPattern

  set fsBoxFSPattern $fsBoxPattern
  if {[file exists $fsBoxPath] &&
      [file readable $fsBoxPath] &&
      [file isdirectory $fsBoxPath]} {
    set fsBoxFSInternalPath $fsBoxPath
    .fsBox.path.path delete 0 end
    .fsBox.path.path insert 0 "$fsBoxFSInternalPath"
  } {
    if {[file exists $fsBoxPath] &&
        [file readable $fsBoxPath] &&
        [file isfile $fsBoxPath]} {
      set fsBoxFSInternalPath [file dirname $fsBoxPath]
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 "$fsBoxFSInternalPath"
      .fsBox.file.file delete 0 end
      .fsBox.file.file insert 0 [file tail $fsBoxPath]
      set fsBoxPath $fsBoxFSInternalPath
    } {
      while {"$fsBoxPath" != "" &&
             "$fsBoxPath" != "/" &&
             ![file isdirectory $fsBoxPath]} {
        set fsBoxFSInternalPath [file dirname $fsBoxPath]
       .fsBox.path.path delete 0 end
       .fsBox.path.path insert 0 "$fsBoxFSInternalPath"
        set fsBoxPath $fsBoxFSInternalPath
      }
      if {"$fsBoxPath" == ""} {
        set fsBoxPath "/"
        set fsBoxFSInternalPath "/"
      }
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 "$fsBoxFSInternalPath"
    }
  }

  if {[.fsBox.files.files size] > 0} {
    .fsBox.files.files delete 0 end
  }
  if {$fsBoxAll == 1} {
    if {[catch "exec ls -F -a $fsBoxPath" fsBoxResult]} {
      puts stderr "$fsBoxResult"
    }
  } {
    if {[catch "exec ls -F $fsBoxPath" fsBoxResult]} {
      puts stderr "$fsBoxResult"
    }
  }
  set fsBoxElementList [lsort $fsBoxResult]

  if {$fsBoxExtensions == 1} {
    foreach fsBoxCounter [winfo children .fsBox.pattern.patterns.patterns] {
      if {[string length [info commands XFDestroy]] > 0} {
        catch {XFDestroy $fsBoxCounter}
      } {
        catch {destroy $fsBoxCounter}
      }
    }
    menu .fsBox.pattern.patterns.patterns.menu       -activebackground "$fsBoxActiveBackground"       -activeforeground "$fsBoxActiveForeground"       -background "$fsBoxBackground"       -foreground "$fsBoxForeground"       -font "$fsBoxFont"

    .fsBox.pattern.patterns.patterns.menu add command       -label "*"       -command {
        global fsBoxFSAll
        global fsBoxFSPattern
        set fsBoxFSPattern "*"
        .fsBox.pattern.pattern delete 0 end
        .fsBox.pattern.pattern insert 0 $fsBoxFSPattern
        FSBoxFSShow [.fsBox.path.path get] $fsBoxFSPattern           $fsBoxFSAll}
  } {
    if {[.fsBox.pattern.patterns.patterns.menu index last] > 0} {
      foreach fsBoxCounter [winfo children .fsBox.pattern.patterns.patterns] {
        if {[string length [info commands XFDestroy]] > 0} {
          catch {XFDestroy $fsBoxCounter}
        } {
          catch {destroy $fsBoxCounter}
        }
      }
      menu .fsBox.pattern.patterns.patterns.menu         -activebackground "$fsBoxActiveBackground"         -activeforeground "$fsBoxActiveForeground"         -background "$fsBoxBackground"         -foreground "$fsBoxForeground"         -font "$fsBoxFont"    
    }
  }

  if {"/" != "$fsBoxPath"} {
    .fsBox.files.files insert end "../"
  }
  foreach fsBoxCounter $fsBoxElementList {
    if {[string match $fsBoxPattern $fsBoxCounter] ||
        [IsADir [string trimright $fsBoxPath/$fsBoxCounter @]]} {
      if {"../" != "$fsBoxCounter" &&
          "./" != "$fsBoxCounter"} {
        .fsBox.files.files insert end $fsBoxCounter
      }
    }

    if {$fsBoxExtensions == 1} {
      catch "file rootname $fsBoxCounter" fsBoxRootName
      catch "file extension $fsBoxCounter" fsBoxExtension
      set fsBoxExtension [string trim $fsBoxExtension /]
      set fsBoxExtension [string trim $fsBoxExtension *]
      set fsBoxExtension [string trim $fsBoxExtension @]
      if {[string length $fsBoxExtension] > 0 &&
          [string length $fsBoxRootName] > 0} {
        set fsBoxInsert 1
        set fsBoxLast [.fsBox.pattern.patterns.patterns.menu index last]
        for {set fsBoxCounter1 0} {$fsBoxCounter1 <= $fsBoxLast} {incr fsBoxCounter1 1} {
          if {"*$fsBoxExtension" ==                 "[lindex [.fsBox.pattern.patterns.patterns.menu entryconfigure                         $fsBoxCounter1 -label] 4]"} {
            set fsBoxInsert 0
          }
        }
	if {$fsBoxInsert == 1} {
          .fsBox.pattern.patterns.patterns.menu add command             -label "*$fsBoxExtension"             -command "
              global fsBoxFSAll
              global fsBoxFSPattern
              set fsBoxFSPattern \"*$fsBoxExtension\"
              .fsBox.pattern.pattern delete 0 end
              .fsBox.pattern.pattern insert 0 \$fsBoxFSPattern
              FSBoxFSShow \[.fsBox.path.path get\] \$fsBoxFSPattern                 \$fsBoxFSAll"
        }
      }
    }
  }
  if {$fsBoxExtensions == 1} {
    .fsBox.pattern.patterns.patterns.menu add separator
  }
  if {$fsBoxExtensions == 1 || 
      "[.fsBox.pattern.patterns.patterns.menu index last]" == "none"} {
    .fsBox.pattern.patterns.patterns.menu add checkbutton       -label "Scan extensions"       -variable "fsBoxExtensions"       -command {
        global fsBoxFSAll
        FSBoxFSShow [.fsBox.path.path get]           [.fsBox.pattern.pattern get] $fsBoxFSAll}
  }
}


# Procedure: FontBox
proc FontBox { {fontFileFont "/usr/local/lib/xf/lib/Fonts"} {fontMessage "Font:"}} {
  # Description: select a font
  # Arguments: fontFileFont - the font file with all fontnames
  #            fontMessage - a message to display
  # Returns: fontname
  # 
  # global fontBoxActiveBackground - active background color
  # global fontBoxActiveForeground - active foreground color
  # global fontBoxBackground - background color
  # global fontBoxFont - text font
  # global fontBoxForeground - foreground color
  # global fontBoxScrollActiveForeground - scrollbar active background color
  # global fontBoxScrollBackground - scrollbar background color
  # global fontBoxScrollForeground - scrollbar foreground color

  global fontBoxName
  global fontBoxFontFamily
  global fontBoxFontPixels
  global fontBoxFontSlant
  global fontBoxFontSWeight
  global fontBoxFontWeight
  global fontBoxActiveBackground
  global fontBoxActiveForeground
  global fontBoxBackground
  global fontBoxFont
  global fontBoxForeground
  global fontBoxScrollActiveForeground
  global fontBoxScrollBackground
  global fontBoxScrollForeground

  set fontBoxName ""
  set fontBoxFontFamily *
  set fontBoxFontPixels *
  set fontBoxFontSlant *
  set fontBoxFontSWeight *
  set fontBoxFontWeight *

  # get font file name
  if {!([file exists $fontFileFont] &&
        [file readable $fontFileFont])} {
    set fontFileFont ""
  }
  if {"$fontFileFont" == ""} {
    global env
    if {[info exists env(XF_FONT_FILE)]} {
      if {[file exists $env(XF_FONT_FILE)] &&
          [file readable $env(XF_FONT_FILE)]} {
        set fontFileFont $env(XF_FONT_FILE)
      }
    }
  }

  # build widget structure
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .fontBox}
  } {
    catch {destroy .fontBox}
  }
  toplevel .fontBox     -background "$fontBoxBackground"     -borderwidth 0
  wm geometry .fontBox 600x300
  wm title .fontBox {Font box}
  wm maxsize .fontBox 1000 1000
  wm minsize .fontBox 100 90
  wm positionfrom .fontBox program
  wm sizefrom .fontBox user

  frame .fontBox.frame1     -background "$fontBoxBackground"     -borderwidth 0     -relief raised

  frame .fontBox.frame2     -background "$fontBoxBackground"     -borderwidth 2     -relief raised

  button .fontBox.frame1.ok     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "OK"     -command "
      global fontBoxName
      set fontBoxName \[.fontBox.current.current get\]
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fontBox}
      } {
        catch {destroy .fontBox}
      }"

  button .fontBox.frame1.rescan     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Rescan fonts"     -command "
      if {\"$fontFileFont\" != \"\"} {
        exec xlsfonts > $fontFileFont
        if {\[.fontBox.fonts.fonts size\] > 0} {
          .fontBox.fonts.fonts delete 0 end
        }
        if {\[catch \"open $fontFileFont r\" fontInFile\]} {
          puts stderr \"\$fontInFile\"
        } {
          while {1 == 1} {
            if {\[gets \$fontInFile fontLine\] == -1} {
              break
            }
            .fontBox.fonts.fonts insert end \$fontLine
          }
          close \$fontInFile
        }
      }"

  button .fontBox.frame1.cancel     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Cancel"     -command "
      global fontBoxName
      set fontBoxName \"\"
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fontBox}
      } {
        catch {destroy .fontBox}
      }"

  label .fontBox.demo     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -relief raised     -text "This text shows the results :-)"

  frame .fontBox.current     -background "$fontBoxBackground"     -borderwidth 0     -relief raised

  label .fontBox.current.labelcurrent     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -relief raised     -text "$fontMessage"

  entry .fontBox.current.current     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -relief raised

  frame .fontBox.fonts     -background "$fontBoxBackground"     -borderwidth 0     -relief raised

  scrollbar .fontBox.fonts.vscroll     -activeforeground "$fontBoxScrollActiveForeground"     -background "$fontBoxScrollBackground"     -foreground "$fontBoxScrollForeground"     -relief raised     -command ".fontBox.fonts.fonts yview"

  scrollbar .fontBox.fonts.hscroll     -activeforeground "$fontBoxScrollActiveForeground"     -background "$fontBoxScrollBackground"     -foreground "$fontBoxScrollForeground"     -orient horiz     -relief raised     -command ".fontBox.fonts.fonts xview"

  listbox .fontBox.fonts.fonts     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -exportselection false     -relief raised     -xscrollcommand ".fontBox.fonts.hscroll set"     -yscrollcommand ".fontBox.fonts.vscroll set"

  # family menu
  menubutton .fontBox.frame2.family     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Family"     -underline 0     -menu ".fontBox.frame2.family.m"

  menu .fontBox.frame2.family.m     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"

  .fontBox.frame2.family.m add radiobutton     -label "*"     -value "*"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .fontBox.frame2.family.m add radiobutton     -label "charter"     -value "charter"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .fontBox.frame2.family.m add radiobutton     -label "courier"     -value "courier"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .fontBox.frame2.family.m add radiobutton     -label "fixed"     -value "fixed"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .fontBox.frame2.family.m add radiobutton     -label "helvetica"     -value "helvetica"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .fontBox.frame2.family.m add radiobutton     -label "lucida"     -value "lucida"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .fontBox.frame2.family.m add radiobutton     -label "terminal"     -value "terminal"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .fontBox.frame2.family.m add radiobutton     -label "times"     -value "times"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"

  # weight menu
  menubutton .fontBox.frame2.weight     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Weight"     -underline 0     -menu ".fontBox.frame2.weight.m"

  menu .fontBox.frame2.weight.m     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"

  .fontBox.frame2.weight.m add radiobutton     -label "*"     -value "*"     -variable fontBoxFontWeight     -command "FontBoxComposeFont"
  .fontBox.frame2.weight.m add radiobutton     -label "bold"     -value "bold"     -variable fontBoxFontWeight     -command "FontBoxComposeFont"
  .fontBox.frame2.weight.m add radiobutton     -label "demibold"     -value "demibold"     -variable fontBoxFontWeight     -command "FontBoxComposeFont"
  .fontBox.frame2.weight.m add radiobutton     -label "medium"     -value "medium"     -variable fontBoxFontWeight     -command "FontBoxComposeFont"

  # Slant menu
  menubutton .fontBox.frame2.slant     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Slant"     -underline 0     -menu ".fontBox.frame2.slant.m"

  menu .fontBox.frame2.slant.m     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"

  .fontBox.frame2.slant.m add radiobutton     -label "*"     -value "*"     -variable fontBoxFontSlant     -command "FontBoxComposeFont"
  .fontBox.frame2.slant.m add radiobutton     -label "i"     -value "i"     -variable fontBoxFontSlant     -command "FontBoxComposeFont"
  .fontBox.frame2.slant.m add radiobutton     -label "o"     -value "o"     -variable fontBoxFontSlant     -command "FontBoxComposeFont"
  .fontBox.frame2.slant.m add radiobutton     -label "r"     -value "r"     -variable fontBoxFontSlant     -command "FontBoxComposeFont"

  # Set width menu
  menubutton .fontBox.frame2.swidth     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Set width"     -underline 1     -menu ".fontBox.frame2.swidth.m"

  menu .fontBox.frame2.swidth.m     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"

  .fontBox.frame2.swidth.m add radiobutton     -label "*"     -value "*"     -variable fontBoxFontSWidth     -command "FontBoxComposeFont"
  .fontBox.frame2.swidth.m add radiobutton     -label "normal"     -value "normal"     -variable fontBoxFontSWidth     -command "FontBoxComposeFont"
  .fontBox.frame2.swidth.m add radiobutton     -label "semicondensed"     -value "semicondensed"     -variable fontBoxFontSWidth     -command "FontBoxComposeFont"

  # pixels menu
  menubutton .fontBox.frame2.pixels     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Pixels"     -underline 0     -menu ".fontBox.frame2.pixels.m"

  menu .fontBox.frame2.pixels.m     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"

  .fontBox.frame2.pixels.m add radiobutton     -label "*"     -value "*"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "6 pixels"     -value "6"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "8 pixels"     -value "8"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "10 pixels"     -value "10"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "12 pixels"     -value "12"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "13 pixels"     -value "13"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "14 pixels"     -value "14"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "16 pixels"     -value "16"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "18 pixels"     -value "18"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "24 pixels"     -value "24"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "28 pixels"     -value "28"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .fontBox.frame2.pixels.m add radiobutton     -label "30 pixels"     -value "30"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"

  # read font file
  if {"$fontFileFont" != ""} {
    if {[catch "open $fontFileFont r" fontInFile]} {
      puts stderr "$fontInFile"
    } {
      while {1 == 1} {
        if {[gets $fontInFile fontLine] == -1} {
          break
        }
        .fontBox.fonts.fonts insert end $fontLine
      }
      close $fontInFile
    }
  }
  
  # init menus
  tk_menuBar .fontBox.frame2     .fontBox.frame2.family     .fontBox.frame2.weight     .fontBox.frame2.slant     .fontBox.frame2.swidth     .fontBox.frame2.pixels

  # bindings
  bind .fontBox.current.current <Delete> {
    EntryBS %W}
  bind .fontBox.current.current <BackSpace> {
    EntryBS %W}
  bind .fontBox.current.current <Right> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W }
  bind .fontBox.current.current <Left> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W }
  bind .fontBox.current.current <Control-a> {
    %W icursor 0
    %W view 0}
  bind .fontBox.current.current <Control-b> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W}
  bind .fontBox.current.current <Control-d> {
    %W delete [%W index insert]
    EntryV2C %W }
  bind .fontBox.current.current <Control-e> {
    %W icursor end
    EntryV2C %W}
  bind .fontBox.current.current <Control-f> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .fontBox.current.current <Control-h> {
    EntryBS %W}
  bind .fontBox.current.current <Meta-h> {
    %W delete 0 insert
    %W view insert}
  bind .fontBox.current.current <Control-i> {
    %W insert insert \t}
  bind .fontBox.current.current <Control-k> {
    %W delete insert end
    EntryV2C %W}
  bind .fontBox.current.current <Control-l> {
    EntryV2C %W}
  bind .fontBox.current.current <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index insert]-2]]
    set char2 [string index $contents [expr [%W index insert]-1]]
    %W delete [expr [%W index insert]-2] [expr [%W index insert]-1]
    %W insert [%W index insert] "$char2$char1"
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .fontBox.current.current <Control-v> {
    %W insert insert "[GetSelection]"}
  bind .fontBox.current.current <Control-w> {
    catch "%W delete sel.first sel.last"
    EntryV2C %W}
  bind .fontBox.current.current <Control-y> {
    %W insert insert "[GetSelection]"}
  bind .fontBox.current.current <space> {
    %W insert insert " "
    EntryV2C %W}
  bind .fontBox.current.current <Any-Key> {
    %W insert insert "%A"
    EntryV2C %W}
  bind .fontBox.current.current <Return> "
    FontBoxSetFont"

  bind .fontBox.fonts.fonts <ButtonPress-1> "
    FontBoxSelectFont %W %y"
  bind .fontBox.fonts.fonts <Button1-Motion> "
    FontBoxSelectFont %W %y"
  bind .fontBox.fonts.fonts <Shift-ButtonPress-1> "
    FontBoxSelectFont %W %y"
  bind .fontBox.fonts.fonts <Shift-Button1-Motion> "
    FontBoxSelectFont %W %y"

  # packing
  pack append .fontBox.frame1               .fontBox.frame1.ok {left fill expand}               .fontBox.frame1.rescan {left fill expand}               .fontBox.frame1.cancel {left fill expand}
  pack append .fontBox.frame2               .fontBox.frame2.family {left}               .fontBox.frame2.weight {left}               .fontBox.frame2.slant {left}               .fontBox.frame2.swidth {left}               .fontBox.frame2.pixels {left}
  pack append .fontBox.current               .fontBox.current.labelcurrent {left}               .fontBox.current.current {left fill expand}
  pack append .fontBox.fonts               .fontBox.fonts.vscroll {left filly}               .fontBox.fonts.hscroll {bottom fillx}               .fontBox.fonts.fonts {left fill expand}

  if {"$fontFileFont" != ""} {
    pack append .fontBox                 .fontBox.frame1 {bottom fillx}                 .fontBox.current {bottom fillx}                 .fontBox.demo {bottom fillx}                 .fontBox.frame2 {top fill}                 .fontBox.fonts {left expand fill}
  } {
    wm geometry .fontBox 400x90
    pack append .fontBox                 .fontBox.frame1 {bottom fillx}                 .fontBox.current {bottom fillx}                 .fontBox.frame2 {top fill}                 .fontBox.demo {bottom fill expand}
  }

  # wait for the box to be destroyed
  update idletask
  grab .fontBox
  tkwait window .fontBox

  return $fontBoxName
}


# Procedure: FontBoxComposeFont
proc FontBoxComposeFont {} {
  global fontBoxFontFamily
  global fontBoxFontPixels
  global fontBoxFontSlant
  global fontBoxFontSWidth
  global fontBoxFontWeight
  
  if {"$fontBoxFontFamily" != "*"} {
    append fontNewFont * $fontBoxFontFamily
  } {
    append fontNewFont *
  }
  if {"$fontBoxFontWeight" != "*"} {
    append fontNewFont - $fontBoxFontWeight
  } {
    append fontNewFont - *
  }
  if {"$fontBoxFontSlant" != "*"} {
    append fontNewFont - $fontBoxFontSlant
  } {
    append fontNewFont - *
  }
  if {"$fontBoxFontSWidth" != "*"} {
    append fontNewFont - $fontBoxFontSWidth
  } {
    append fontNewFont - *
  }
  append fontNewFont - *
  if {"$fontBoxFontPixels" != "*"} {
    append fontNewFont - $fontBoxFontPixels
  } {
    append fontNewFont -
  }
  append fontNewFont *

  .fontBox.current.current delete 0 end
  .fontBox.current.current insert 0 $fontNewFont
  catch ".fontBox.demo configure     -font $fontNewFont"
}


# Procedure: FontBoxSelectFont
proc FontBoxSelectFont { fontW fontY} {

  set fontNearest [$fontW nearest $fontY]
  if {$fontNearest >= 0} {
    $fontW select from $fontNearest
    $fontW select to $fontNearest
    .fontBox.current.current delete 0 end
    .fontBox.current.current insert 0 [$fontW get $fontNearest]
    FontBoxSetFont
  }
}


# Procedure: FontBoxSetFont
proc FontBoxSetFont {} {

  if {"[.fontBox.current.current get]" != ""} {
    catch ".fontBox.demo configure -font       [.fontBox.current.current get]"
  }
}


# Procedure: GetSelection
if {[string length [info procs GetSelection]] == 0} {
proc GetSelection {} {

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  return $xfSelection
}
}


# Procedure: IsADir
proc IsADir { pathName} {

  if {[file isdirectory $pathName]} {
    return 1
  } {
    catch "file type $pathName" fileType
    if {"$fileType" == "link"} {
      if {[catch "file readlink $pathName" linkName]} {
        return 0
      }
      catch "file type $linkName" fileType
      while {"$fileType" == "link"} {
        if {[catch "file readlink $linkName" linkName]} {
          return 0
        }
      }
      return [file isdirectory $linkName]
    }
  }
  return 0
}


# Procedure: IsASymlink
proc IsASymlink { fileName} {

  catch "file type $fileName" fileType
  if {"$fileType" == "link"} {
    return 1
  }
  return 0
}


# Procedure: MenuConf
proc MenuConf { args} {
  # Description: configure the menubutton and menus of
  #              the given pathnames
  # Arguments: args - the widget pathnames we configure
  # Returns: none
  # 
  # global menuConfActiveBackground - active background color
  # global menuConfActiveForeground - active foreground color
  # global menuConfBackground - background color
  # global menuConfFont - text font
  # global menuConfForeground - foreground color
  # global menuConfScrollActiveForeground - scrollbar active background color
  # global menuConfScrollBackground - scrollbar background color
  # global menuConfScrollForeground - scrollbar foreground color

  global menuConfPathNames
  global menuConfActiveBackground
  global menuConfActiveForeground
  global menuConfBackground
  global menuConfFont
  global menuConfForeground
  global menuConfScrollActiveForeground
  global menuConfScrollBackground
  global menuConfScrollForeground

  if {[llength $args] == 0} {
    set menuConfConfig $menuConfPathNames
  } {
    set menuConfConfig $args
  }

  # build widget structure
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .menuConf}
  } {
    catch {destroy .menuConf}
  }
  toplevel .menuConf     -background "$menuConfBackground"     -borderwidth 0
  wm geometry .menuConf 530x400
  wm title .menuConf {Menu configuration}
  wm maxsize .menuConf 1000 1000
  wm minsize .menuConf 100 100
  wm positionfrom .menuConf program
  wm sizefrom .menuConf user

  frame .menuConf.frame1     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .menuConf.frame1.frame2     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .menuConf.frame1.frame2.frame4     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .menuConf.frame1.frame2.frame5     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .menuConf.frame1.frame2.frame6     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .menuConf.frame1.frame2.frame8     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .menuConf.frame1.frame7     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .menuConf.frame1.frame3     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  scrollbar .menuConf.frame1.frame2.frame5.vscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -relief raised     -command ".menuConf.frame1.frame2.frame5.buttons yview"

  scrollbar .menuConf.frame1.frame2.frame5.hscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -orient horiz     -relief raised     -command ".menuConf.frame1.frame2.frame5.buttons xview"

  listbox .menuConf.frame1.frame2.frame5.buttons     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -exportselection false     -relief raised     -xscrollcommand ".menuConf.frame1.frame2.frame5.hscroll set"     -yscrollcommand ".menuConf.frame1.frame2.frame5.vscroll set"

  scrollbar .menuConf.frame1.frame2.frame6.vscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -relief raised     -command ".menuConf.frame1.frame2.frame6.menus yview"

  scrollbar .menuConf.frame1.frame2.frame6.hscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -orient horiz     -relief raised     -command ".menuConf.frame1.frame2.frame6.menus xview"

  listbox .menuConf.frame1.frame2.frame6.menus     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -exportselection false     -relief raised     -xscrollcommand ".menuConf.frame1.frame2.frame6.hscroll set"     -yscrollcommand ".menuConf.frame1.frame2.frame6.vscroll set"

  scrollbar .menuConf.frame1.frame2.frame8.vscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -relief raised     -command ".menuConf.frame1.frame2.frame8.menu yview"

  scrollbar .menuConf.frame1.frame2.frame8.hscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -orient horiz     -relief raised     -command ".menuConf.frame1.frame2.frame8.menu xview"

  listbox .menuConf.frame1.frame2.frame8.menu     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -exportselection false     -relief raised     -xscrollcommand ".menuConf.frame1.frame2.frame8.hscroll set"     -yscrollcommand ".menuConf.frame1.frame2.frame8.vscroll set"

  scale .menuConf.frame1.frame2.frame8.mover     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -orient vertical     -width 8     -relief raised     -sliderlength 15     -from 0     -command "MenuConfReposition"

  button .menuConf.frame1.frame7.insert     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Append"     -command "
      MenuConfInsert \"$menuConfConfig\""

  button .menuConf.frame1.frame7.modify     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Modify"     -command "
      MenuConfModify \"$menuConfConfig\""

  button .menuConf.frame1.frame7.modifymenu     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Modify menu"     -command {
      set curSelected [.menuConf.frame1.frame2.frame6.menus curselection]
      if {$curSelected >= 0} {
        place forget .menuConf.frame1.frame2.frame5
        place forget .menuConf.frame1.frame2.frame6
        place .menuConf.frame1.frame2.frame8           -in .menuConf.frame1.frame2           -relx 0.5           -rely 0           -relheight 1.0           -relwidth 0.5
        pack unpack .menuConf.frame1.frame7.modifymenu
        pack append .menuConf.frame1.frame7                     .menuConf.frame1.frame7.insert {left fill expand}                     .menuConf.frame1.frame7.modify {left fill expand}                     .menuConf.frame1.frame7.modifyback {left fill expand}                     .menuConf.frame1.frame7.delete {left fill expand}
        update idletask
        MenuConfSetItems command
        MenuConfReadMenu           [.menuConf.frame1.frame2.frame6.menus get $curSelected]
        case [lindex [.menuConf.frame1.frame2.frame4.items.message1 config -text] 4] in {
          {Cascadebutton} {
            .menuConf.frame1.frame2.frame4.items.items.m invoke 0
          }
          {Checkbutton} {
            .menuConf.frame1.frame2.frame4.items.items.m invoke 1
          }
          {Radiobutton} {
            .menuConf.frame1.frame2.frame4.items.items.m invoke 3
          }
          {Separator} {
            .menuConf.frame1.frame2.frame4.items.items.m invoke 4
          }
          {default} {
            .menuConf.frame1.frame2.frame4.items.items.m invoke 2
          }
        }
        MenuConfSetItem
      }}

  button .menuConf.frame1.frame7.modifyback     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Back to main"     -command {
      place forget .menuConf.frame1.frame2.frame8
      if {[.menuConf.frame1.frame2.frame5.buttons size] > 0} {
        place .menuConf.frame1.frame2.frame5           -in .menuConf.frame1.frame2           -relx 0.5           -rely 0           -relheight 0.5           -relwidth 0.5
        place .menuConf.frame1.frame2.frame6           -in .menuConf.frame1.frame2           -relx 0.5           -rely 0.5           -relheight 0.5           -relwidth 0.5
      } {
        place .menuConf.frame1.frame2.frame6           -in .menuConf.frame1.frame2           -relx 0.5           -rely 0           -relheight 1           -relwidth 0.5
      }
      update idletask
      pack unpack .menuConf.frame1.frame7.modifyback
      pack append .menuConf.frame1.frame7                   .menuConf.frame1.frame7.insert {left fill expand}                   .menuConf.frame1.frame7.modify {left fill expand}                   .menuConf.frame1.frame7.modifymenu {left fill expand}                   .menuConf.frame1.frame7.delete {left fill expand}
      MenuConfSetItem}

  button .menuConf.frame1.frame7.delete     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Delete"     -command "
      if {\[.menuConf.frame1.frame2.frame6.menus size\] > 0} {
        MenuConfDelete \"$menuConfConfig\"
      }"

  button .menuConf.frame1.frame3.ok     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "OK"     -command "
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .menuConf}
      } {
        catch {destroy .menuConf}
      }"

  button .menuConf.frame1.frame3.save     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Save"     -command "MenuConfSave"

  frame .menuConf.frame1.frame2.frame4.items     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  menubutton .menuConf.frame1.frame2.frame4.items.items     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Menu entry:"     -menu ".menuConf.frame1.frame2.frame4.items.items.m"

  menu .menuConf.frame1.frame2.frame4.items.items.m     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"

  .menuConf.frame1.frame2.frame4.items.items.m     add radiobutton       -label "Cascadebutton"       -variable menuConfCurrentMenuType       -value "<cascade> "       -command "MenuConfSetItems cascade"
  .menuConf.frame1.frame2.frame4.items.items.m     add radiobutton       -label "Checkbutton"       -variable menuConfCurrentMenuType       -value "<checkbutton> "       -command "MenuConfSetItems check"
  .menuConf.frame1.frame2.frame4.items.items.m     add radiobutton       -label "Commandbutton"       -variable menuConfCurrentMenuType       -value "<command> "       -command "MenuConfSetItems command"
  .menuConf.frame1.frame2.frame4.items.items.m     add radiobutton       -label "Radiobutton"       -variable menuConfCurrentMenuType       -value "<radiobutton> "       -command "MenuConfSetItems radio"
  .menuConf.frame1.frame2.frame4.items.items.m     add radiobutton       -label "Separator"       -variable menuConfCurrentMenuType       -value "<separator> "       -command "MenuConfSetItems separator"
  
  label .menuConf.frame1.frame2.frame4.items.message1     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -anchor w     -text "Commandbutton"
  
  MenuConfEntry accelerator "Accelerator:"
  MenuConfEntry actbg "Active background:"
  MenuConfScale actborder "Active borderwidth:" "pixels" 40
  MenuConfEntry actfg "Active foreground:"
  MenuConfEntry bg "Background:"
  MenuConfEntry bitmap "Bitmap:"
  MenuConfScale border "Borderwidth:" "pixels" 40
  MenuConfEntry font "Font:"
  MenuConfEntry fg "Foreground:"
  MenuConfEntry label "Label:"
  MenuConfEntry menu "Menu:"
  MenuConfEntry name "Menu name:"
  MenuConfEntry offvalue "Offvalue:"
  MenuConfEntry onvalue "Onvalue:"
  MenuConfScaleDouble size "Size:" "Width" "Height" 300 300

  frame .menuConf.frame1.frame2.frame4.state     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  label .menuConf.frame1.frame2.frame4.state.message1     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -anchor w     -relief raised     -text "State:"

  radiobutton .menuConf.frame1.frame2.frame4.state.normal     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Normal"     -variable menuConfState

  radiobutton .menuConf.frame1.frame2.frame4.state.active     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Active"     -variable menuConfState

  radiobutton .menuConf.frame1.frame2.frame4.state.disabled     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Disabled"     -variable menuConfState

  pack append .menuConf.frame1.frame2.frame4.state               .menuConf.frame1.frame2.frame4.state.message1 {left}               .menuConf.frame1.frame2.frame4.state.normal {left fillx expand}               .menuConf.frame1.frame2.frame4.state.active {left fillx expand}               .menuConf.frame1.frame2.frame4.state.disabled {left fillx expand}

  MenuConfEntry textvar "Text variable:"

  MenuConfScale underline "Underline:" "" 40
  .menuConf.frame1.frame2.frame4.underline.underline config     -from -1

  MenuConfEntry value "Value:"
  MenuConfEntry variable "Variable:"

  label .menuConf.frame1.frame2.frame4.message1     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -anchor c     -relief raised     -text "Command:"
  
  frame .menuConf.frame1.frame2.frame4.command     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  text .menuConf.frame1.frame2.frame4.command.command     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -relief raised     -wrap none     -borderwidth 2     -yscrollcommand ".menuConf.frame1.frame2.frame4.command.vscroll set"

  scrollbar .menuConf.frame1.frame2.frame4.command.vscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -relief raised     -command ".menuConf.frame1.frame2.frame4.command.command yview"

  pack append .menuConf.frame1.frame2.frame4.command               .menuConf.frame1.frame2.frame4.command.vscroll {left filly}               .menuConf.frame1.frame2.frame4.command.command {left fill expand}

  # bindings
  bind .menuConf.frame1.frame2.frame4.command.command <Left> {
    %W mark set insert insert-1c
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Right> {
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Up> {
    %W mark set insert insert-1l
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Down> {
    %W mark set insert insert+1l
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Delete> {
    tk_textBackspace %W
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-a> {
    %W mark set insert "insert linestart"
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-b> {
    %W mark set insert insert-1c
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-d> {
    %W delete insert insert+1c
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-e> {
    %W mark set insert "insert lineend"
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-f> {
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Meta-h> {
    %W delete "insert linestart" insert
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-i> {
    %W inser insert \t
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-j> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-k> {
    if {[%W compare insert == "insert lineend"]} {
      %W delete insert "insert lineend +1c"
      %W yview -pickplace insert
    } {
      %W delete insert "insert lineend"
      %W yview -pickplace insert
    }}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-l> {
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-m> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-n> {
    %W mark set insert insert+1l
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-o> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-p> {
    %W mark set insert insert-1l
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-t> {
    set char1 [%W get insert-2c insert-1c]
    set char2 [%W get insert-1c insert]
    %W delete insert-2c insert
    %W insert insert "$char2$char1"
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Meta-v> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert-1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-v> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert+1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-w> {
    catch "%W delete sel.first sel.last"}
  bind .menuConf.frame1.frame2.frame4.command.command <Control-y> {
    %W insert insert "[GetSelection]"
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Home> {
    %W mark set insert 1.0
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <End> {
    %W mark set insert end
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Prior> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert-1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .menuConf.frame1.frame2.frame4.command.command <Next> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert+1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}

  bind .menuConf.frame1.frame2.frame5.buttons <ButtonPress-1> {
   MenuConfSelect1 %W %y}
  bind .menuConf.frame1.frame2.frame5.buttons <Button1-Motion> {
   MenuConfSelect1 %W %y}
  bind .menuConf.frame1.frame2.frame5.buttons <Shift-ButtonPress-1> {
   MenuConfSelect1 %W %y}
  bind .menuConf.frame1.frame2.frame5.buttons <Shift-Button1-Motion> {
   MenuConfSelect1 %W %y}

  bind .menuConf.frame1.frame2.frame6.menus <ButtonPress-1> {
   MenuConfSelect1 %W %y}
  bind .menuConf.frame1.frame2.frame6.menus <Button1-Motion> {
   MenuConfSelect1 %W %y}
  bind .menuConf.frame1.frame2.frame6.menus <Shift-ButtonPress-1> {
   MenuConfSelect1 %W %y}
  bind .menuConf.frame1.frame2.frame6.menus <Shift-Button1-Motion> {
   MenuConfSelect1 %W %y}

  bind .menuConf.frame1.frame2.frame8.menu <ButtonPress-1> {
   MenuConfSelect2 %W %y}
  bind .menuConf.frame1.frame2.frame8.menu <Button1-Motion> {
   MenuConfSelect2 %W %y}
  bind .menuConf.frame1.frame2.frame8.menu <Shift-ButtonPress-1> {
   MenuConfSelect2 %W %y}
  bind .menuConf.frame1.frame2.frame8.menu <Shift-Button1-Motion> {
   MenuConfSelect2 %W %y}

  bind .menuConf.frame1.frame2.frame4.actbg.actbg <Double-ButtonPress-3> {
   global menuConfColorFile
   if {"[info commands ColorBox]" != ""} {
     set menuConfResult [ColorBox $menuConfColorFile "Active background:"]
     if {"$menuConfResult" != ""} {
       .menuConf.frame1.frame2.frame4.actbg.actbg delete 0 end
       .menuConf.frame1.frame2.frame4.actbg.actbg insert end $menuConfResult
     }
   }}

  bind .menuConf.frame1.frame2.frame4.actfg.actfg <Double-ButtonPress-3> {
   global menuConfColorFile
   if {"[info commands ColorBox]" != ""} {
     set menuConfResult [ColorBox $menuConfColorFile "Active foreground:"]
     if {"$menuConfResult" != ""} {
       .menuConf.frame1.frame2.frame4.actfg.actfg delete 0 end
       .menuConf.frame1.frame2.frame4.actfg.actfg insert end $menuConfResult
     }
   }}

  bind .menuConf.frame1.frame2.frame4.bg.bg <Double-ButtonPress-3> {
   global menuConfColorFile
   if {"[info commands ColorBox]" != ""} {
     set menuConfResult [ColorBox $menuConfColorFile "Background:"]
     if {"$menuConfResult" != ""} {
       .menuConf.frame1.frame2.frame4.bg.bg delete 0 end
       .menuConf.frame1.frame2.frame4.bg.bg insert end $menuConfResult
     }
   }}

  bind .menuConf.frame1.frame2.frame4.bitmap.bitmap <Double-ButtonPress-3> {
   if {"[info commands FSBox]" != ""} {
     set menuConfResult [FSBox]
     if {"$menuConfResult" != ""} {
       .menuConf.frame1.frame2.frame4.bitmap.bitmap delete 0 end
       .menuConf.frame1.frame2.frame4.bitmap.bitmap insert end $menuConfResult
     }
   }}

  bind .menuConf.frame1.frame2.frame4.font.font <Double-ButtonPress-3> {
   global menuConfFontFile
   if {"[info commands FontBox]" != ""} {
     set menuConfResult [FontBox $menuConfFontFile]
     if {"$menuConfResult" != ""} {
       .menuConf.frame1.frame2.frame4.font.font delete 0 end
       .menuConf.frame1.frame2.frame4.font.font insert end $menuConfResult
     }
   }}

  bind .menuConf.frame1.frame2.frame4.fg.fg <Double-ButtonPress-3> {
   global menuConfColorFile
   if {"[info commands ColorBox]" != ""} {
     set menuConfResult [ColorBox $menuConfColorFile "Foreground:"]
     if {"$menuConfResult" != ""} {
       .menuConf.frame1.frame2.frame4.fg.fg delete 0 end
       .menuConf.frame1.frame2.frame4.fg.fg insert end $menuConfResult
     }
   }}

  MenuConfReadMenus $menuConfConfig

  # packing
  pack append .menuConf.frame1.frame7               .menuConf.frame1.frame7.insert {left fill expand}               .menuConf.frame1.frame7.modify {left fill expand}               .menuConf.frame1.frame7.modifymenu {left fill expand}               .menuConf.frame1.frame7.delete {left fill expand}
  pack append .menuConf.frame1.frame3               .menuConf.frame1.frame3.ok {left fill expand}               .menuConf.frame1.frame3.save {left fill expand}
  pack append .menuConf.frame1.frame2.frame4.items               .menuConf.frame1.frame2.frame4.items.items {left fill}               .menuConf.frame1.frame2.frame4.items.message1 {left fill expand}
  pack append .menuConf.frame1.frame2.frame4               .menuConf.frame1.frame2.frame4.actbg {top fillx}               .menuConf.frame1.frame2.frame4.actfg {top fillx}               .menuConf.frame1.frame2.frame4.bg {top fillx}               .menuConf.frame1.frame2.frame4.bitmap {top fillx}               .menuConf.frame1.frame2.frame4.border {top fillx}               .menuConf.frame1.frame2.frame4.font {top fillx}               .menuConf.frame1.frame2.frame4.fg {top fillx}               .menuConf.frame1.frame2.frame4.label {top fillx}               .menuConf.frame1.frame2.frame4.menu {top fillx}               .menuConf.frame1.frame2.frame4.size {top fillx}               .menuConf.frame1.frame2.frame4.textvar {top fillx}               .menuConf.frame1.frame2.frame4.underline {top fillx}               .menuConf.frame1.frame2.frame4.variable {top fillx}
  pack append .menuConf.frame1.frame2.frame5               .menuConf.frame1.frame2.frame5.vscroll {left filly}               .menuConf.frame1.frame2.frame5.hscroll {bottom fillx}               .menuConf.frame1.frame2.frame5.buttons {left fill expand}
  pack append .menuConf.frame1.frame2.frame6               .menuConf.frame1.frame2.frame6.vscroll {left filly}               .menuConf.frame1.frame2.frame6.hscroll {bottom fillx}               .menuConf.frame1.frame2.frame6.menus {left fill expand}
  pack append .menuConf.frame1.frame2.frame8               .menuConf.frame1.frame2.frame8.mover {right filly}               .menuConf.frame1.frame2.frame8.vscroll {left filly}               .menuConf.frame1.frame2.frame8.hscroll {bottom fillx}               .menuConf.frame1.frame2.frame8.menu {left fill expand}

  place .menuConf.frame1.frame2.frame4     -in .menuConf.frame1.frame2     -relx 0     -rely 0     -relheight 1.0     -relwidth 0.5

  if {[.menuConf.frame1.frame2.frame5.buttons size] > 0} {
    place .menuConf.frame1.frame2.frame5       -in .menuConf.frame1.frame2       -relx 0.5       -rely 0       -relheight 0.5       -relwidth 0.5

    place .menuConf.frame1.frame2.frame6       -in .menuConf.frame1.frame2       -relx 0.5       -rely 0.5       -relheight 0.5       -relwidth 0.5
    MenuConfSetItems menubutton
  } {
    place .menuConf.frame1.frame2.frame6       -in .menuConf.frame1.frame2       -relx 0.5       -rely 0       -relheight 1       -relwidth 0.5
    MenuConfSetItems menu
  }

  pack append .menuConf.frame1               .menuConf.frame1.frame3 {bottom fillx}               .menuConf.frame1.frame7 {bottom fillx}               .menuConf.frame1.frame2 {top fill expand}
  pack append .menuConf               .menuConf.frame1 {top fill expand}

  update idletask
  MenuConfSetItem
}


# Procedure: MenuConfDelete
proc MenuConfDelete { menuConfConfig} {

  set curSelected     [.menuConf.frame1.frame2.frame6.menus curselection]
  if {[winfo ismapped .menuConf.frame1.frame2.frame6] &&
      $curSelected >= 0} {
    if {"[info commands XFDestroy]" != ""} {
      catch "XFDestroy [.menuConf.frame1.frame2.frame6.menus get $curSelected]"
    } {
      catch "destroy [.menuConf.frame1.frame2.frame6.menus get $curSelected]"
    }
    MenuConfReadMenus $menuConfConfig
  } {
    set curSelected       [.menuConf.frame1.frame2.frame8.menu curselection]
    if {[winfo ismapped .menuConf.frame1.frame2.frame8] &&
        $curSelected >= 0} {
      [.menuConf.frame1.frame2.frame6.menus get [.menuConf.frame1.frame2.frame6.menus curselection]] delete $curSelected
      MenuConfReadMenu         [.menuConf.frame1.frame2.frame6.menus get [.menuConf.frame1.frame2.frame6.menus curselection]]
    }
  }
}


# Procedure: MenuConfEntry
proc MenuConfEntry { menuConfName menuConfLabel} {
  global menuConfActiveBackground
  global menuConfActiveForeground
  global menuConfBackground
  global menuConfFont
  global menuConfForeground
  global menuConfScrollActiveForeground
  global menuConfScrollBackground
  global menuConfScrollForeground

  # build widgets
  frame .menuConf.frame1.frame2.frame4.$menuConfName     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  label .menuConf.frame1.frame2.frame4.$menuConfName.label$menuConfName     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -relief raised     -text "$menuConfLabel"

  entry .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -relief raised

  # bindings
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Delete> {
    EntryBS %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <BackSpace> {
    EntryBS %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Right> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W }
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Left> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W }
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-a> {
    %W icursor 0
    %W view 0}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-b> {
    %W icursor [expr [%W index insert]-1]
    EntryV2C %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-d> {
    %W delete [%W index insert]
    EntryV2C %W }
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-e> {
    %W icursor end
    EntryV2C %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-f> {
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-h> {
    EntryBS %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Meta-h> {
    %W delete 0 insert
    %W view insert}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-i> {
    %W insert insert \t}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-k> {
    %W delete insert end
    EntryV2C %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-l> {
    EntryV2C %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index insert]-2]]
    set char2 [string index $contents [expr [%W index insert]-1]]
    %W delete [expr [%W index insert]-2] [expr [%W index insert]-1]
    %W insert [%W index insert] "$char2$char1"
    %W icursor [expr [%W index insert]+1]
    EntryV2C %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-v> {
    %W insert insert "[GetSelection]"}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-w> {
    %W delete sel.first sel.last
    EntryV2C %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-y> {
    %W insert insert "[GetSelection]"}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <space> {
    %W insert insert " "
    EntryV2C %W}
  bind .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Any-Key> {
    %W insert insert "%A"
    EntryV2C %W}

  # packing of the subwidgets
  pack append .menuConf.frame1.frame2.frame4.$menuConfName               .menuConf.frame1.frame2.frame4.$menuConfName.label$menuConfName {left filly}               .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName {left fill expand}
}


# Procedure: MenuConfEntryType
proc MenuConfEntryType { menuConfW menuConfPosition} {

  set menuConfEntryNum [llength [$menuConfW entryconfigure $menuConfPosition]]
  # get number of components
  if {9 == $menuConfEntryNum} {
    return "command"
  } {
    if {0 == $menuConfEntryNum} {
      return "separator"
    } {
      if {10 == $menuConfEntryNum} {
        return "cascade"
      } {
        if {11 == $menuConfEntryNum} {
          return "radiobutton"
        } {
          if {12 == $menuConfEntryNum} {
            return "checkbutton"
          } {
            puts stderr "MenuConf error: menu item type is unknown\nYou have probably switched to a new tk release"
            return "unknown"
          }
        }
      }
    }
  }
}


# Procedure: MenuConfInit
proc MenuConfInit { confUserFile confFile args} {
  # Description: initialize the configuration of menubuttons and
  #              menus of specified pathnames
  # Arguments: menuConfUserFile - the user specific loadfile
  #            menuConfFile - the default loadfile
  #            args - the widget pathnames we configure
  # Returns: none

  global menuConfPathNames
  global menuConfFile
  global menuConfUserFile

  set menuConfFile $confFile
  set menuConfUserFile $confUserFile
  if {[file exists $menuConfUserFile]} {
    if {[catch "source \"$menuConfUserFile\"" menuConfResult]} {
      puts stderr $menuConfResult
    }
  } {
    if {[file exists $menuConfFile]} {
      if {[catch "source \"$menuConfFile\"" menuConfResult]} {
        puts stderr $menuConfResult
      }
    }
  }
  set menuConfPathNames "$args"
}


# Procedure: MenuConfInsert
proc MenuConfInsert { menuConfConfig} {
  global menuConfCurrentMenuType

  if {[winfo ismapped .menuConf.frame1.frame2.frame6]} {
    if {"[.menuConf.frame1.frame2.frame4.name.name get]" != ""} {
      if {"[info commands XFDestroy]" != ""} {
        catch "XFDestroy [.menuConf.frame1.frame2.frame4.name.name get]"
      } {
        catch "destroy [.menuConf.frame1.frame2.frame4.name.name get]"
      }
      if {[catch "menu [.menuConf.frame1.frame2.frame4.name.name get]" menuConfResult]} {
        puts stderr $menuConfResult
      } {
        .menuConf.frame1.frame2.frame6.menus insert end           "[.menuConf.frame1.frame2.frame4.name.name get]"
        .menuConf.frame1.frame2.frame6.menus select from           [.menuConf.frame1.frame2.frame6.menus size]
        .menuConf.frame1.frame2.frame6.menus select to           [.menuConf.frame1.frame2.frame6.menus size]
        MenuConfModify $menuConfConfig
        MenuConfReadMenus $menuConfConfig
      }
    }
  } {
    set currType       [string trim [string trim [string trim $menuConfCurrentMenuType] >] <]
    if {[winfo ismapped .menuConf.frame1.frame2.frame8]} {
      if {[catch "[.menuConf.frame1.frame2.frame6.menus get [.menuConf.frame1.frame2.frame6.menus curselection]] add $currType" menuConfResult]} {
        puts stderr $menuConfResult
      } {
        .menuConf.frame1.frame2.frame8.menu insert end           "$menuConfCurrentMenuType [.menuConf.frame1.frame2.frame4.name.name get]"
        .menuConf.frame1.frame2.frame8.menu select from           [.menuConf.frame1.frame2.frame8.menu size]
        .menuConf.frame1.frame2.frame8.menu select to           [.menuConf.frame1.frame2.frame8.menu size]
        MenuConfModify $menuConfConfig
        MenuConfReadMenu           [.menuConf.frame1.frame2.frame6.menus get [.menuConf.frame1.frame2.frame6.menus curselection]]
      }
    }
  }
}


# Procedure: MenuConfInsertMenus
proc MenuConfInsertMenus { menuConfW} {
  if {"[winfo class $menuConfW]" == "Menu"} {
    .menuConf.frame1.frame2.frame6.menus insert end $menuConfW
  }

  set last [$menuConfW index last]
  if {"$last" == "none"} {
    set last -1
  }
  for {set counter 0} {$counter <= $last} {incr counter 1} {
    if {"[MenuConfEntryType $menuConfW $counter]" == "cascade"} {
      if {"[lindex [$menuConfW entryconfig $counter -menu] 4]" != ""} {
        if {"[info commands [lindex [$menuConfW entryconfig $counter -menu] 4]]" == ""} {
          $menuConfW entryconfig $counter -menu ""
        }
      }
    }
  }
  foreach counter [lsort [winfo children $menuConfW]] {
    if {"[winfo class $counter]" == "Menu"} {
      MenuConfInsertMenus $counter
    }
  }
}


# Procedure: MenuConfModify
proc MenuConfModify { menuConfConfig} {
  global menuConfState

  set curSelected     [.menuConf.frame1.frame2.frame5.buttons curselection]
  if {[winfo ismapped .menuConf.frame1.frame2.frame5] &&
      $curSelected >= 0} {
    set menuConfList .menuConf.frame1.frame2.frame5.buttons
    set menuConfW [$menuConfList get $curSelected]
    # insert values
    set optionString "config"
    if {"[.menuConf.frame1.frame2.frame4.actbg.actbg get]" != ""} {
      append optionString         " -activebackground \{[.menuConf.frame1.frame2.frame4.actbg.actbg get]\}"
    }
    if {"[.menuConf.frame1.frame2.frame4.actfg.actfg get]" != ""} {
      append optionString         " -activeforeground \{[.menuConf.frame1.frame2.frame4.actfg.actfg get]\}"
    }
    if {"[.menuConf.frame1.frame2.frame4.bg.bg get]" != ""} {
      append optionString         " -background \{[.menuConf.frame1.frame2.frame4.bg.bg get]\}"
    }
    if {"[.menuConf.frame1.frame2.frame4.bitmap.bitmap get]" != ""} {
      if {"[string index [.menuConf.frame1.frame2.frame4.bitmap.bitmap get] 0]" == "@"} {
        append optionString           " -bitmap \{[.menuConf.frame1.frame2.frame4.bitmap.bitmap get]\}"
      } {
        append optionString           " -bitmap \{@[.menuConf.frame1.frame2.frame4.bitmap.bitmap get]\}"
      }
    } {
      append optionString         " -bitmap \{\}"
    }
    append optionString       " -borderwidth [.menuConf.frame1.frame2.frame4.border.border get]"
    if {"[.menuConf.frame1.frame2.frame4.font.font get]" != ""} {
      append optionString         " -font \{[.menuConf.frame1.frame2.frame4.font.font get]\}"
    }
    if {"[.menuConf.frame1.frame2.frame4.fg.fg get]" != ""} {
      append optionString         " -foreground \{[.menuConf.frame1.frame2.frame4.fg.fg get]\}"
    }
    append optionString       " -menu \{[.menuConf.frame1.frame2.frame4.menu.menu get]\}"
    append optionString       " -text \{[.menuConf.frame1.frame2.frame4.label.label get]\}"
    append optionString       " -textvariable \{[.menuConf.frame1.frame2.frame4.textvar.textvar get]\}"
    append optionString       " -underline \{[.menuConf.frame1.frame2.frame4.underline.underline get]\}"
    if {[.menuConf.frame1.frame2.frame4.size.size1.size1 get] > 0 &&
	[.menuConf.frame1.frame2.frame4.size.size2.size2 get] > 0} {
      append optionString         " -width \{[.menuConf.frame1.frame2.frame4.size.size1.size1 get]\}"
      append optionString         " -height \{[.menuConf.frame1.frame2.frame4.size.size2.size2 get]\}"
    }
    if {[catch "$menuConfW $optionString" menuConfResult]} {
      puts stderr $menuConfResult
    }
  } {
    set curSelected       [.menuConf.frame1.frame2.frame6.menus curselection]
    if {[winfo ismapped .menuConf.frame1.frame2.frame6] &&
        $curSelected >= 0} {
      set menuConfList .menuConf.frame1.frame2.frame6.menus
      set menuConfW [$menuConfList get $curSelected]
      # insert values
      set optionString "config"
      if {"[.menuConf.frame1.frame2.frame4.actbg.actbg get]" != ""} {
        append optionString           " -activebackground \{[.menuConf.frame1.frame2.frame4.actbg.actbg get]\}"
      }
      append optionString         " -activeborderwidth \{[.menuConf.frame1.frame2.frame4.actborder.actborder get]\}"
      if {"[.menuConf.frame1.frame2.frame4.actfg.actfg get]" != ""} {
        append optionString           " -activeforeground \{[.menuConf.frame1.frame2.frame4.actfg.actfg get]\}"
      }
      if {"[.menuConf.frame1.frame2.frame4.bg.bg get]" != ""} {
        append optionString           " -background \{[.menuConf.frame1.frame2.frame4.bg.bg get]\}"
      }
      append optionString         " -borderwidth \{[.menuConf.frame1.frame2.frame4.border.border get]\}"
      if {"[.menuConf.frame1.frame2.frame4.font.font get]" != ""} {
        append optionString           " -font \{[.menuConf.frame1.frame2.frame4.font.font get]\}"
      }
      if {"[.menuConf.frame1.frame2.frame4.fg.fg get]" != ""} {
        append optionString           " -foreground \{[.menuConf.frame1.frame2.frame4.fg.fg get]\}"
      }
      if {[catch "$menuConfW $optionString" menuConfResult]} {
        puts stderr $menuConfResult
      }
    } {
      set curSelected         [.menuConf.frame1.frame2.frame8.menu curselection]
      if {[winfo ismapped .menuConf.frame1.frame2.frame8] &&
          $curSelected >= 0} {
        set menuConfList .menuConf.frame1.frame2.frame6.menus
        set menuConfW           [$menuConfList get [.menuConf.frame1.frame2.frame6.menus curselection]]
        # insert values
        if {![string match <separator* [.menuConf.frame1.frame2.frame8.menu get $curSelected]]} {
          set optionString "entryconfig $curSelected"
          if {"[.menuConf.frame1.frame2.frame4.actbg.actbg get]" != ""} {
            append optionString               " -activebackground \{[.menuConf.frame1.frame2.frame4.actbg.actbg get]\}"
          }
          append optionString             " -accelerator \{[.menuConf.frame1.frame2.frame4.accelerator.accelerator get]\}"
          if {"[.menuConf.frame1.frame2.frame4.bg.bg get]" != ""} {
            append optionString               " -background \{[.menuConf.frame1.frame2.frame4.bg.bg get]\}"
          }
          if {"[.menuConf.frame1.frame2.frame4.bitmap.bitmap get]" != ""} {
            if {"[string index [.menuConf.frame1.frame2.frame4.bitmap.bitmap get] 0]" == "@"} {
              append optionString                 " -bitmap \{[.menuConf.frame1.frame2.frame4.bitmap.bitmap get]\}"
            } {
              append optionString                 " -bitmap \{@[.menuConf.frame1.frame2.frame4.bitmap.bitmap get]\}"
            }
          } {
            append optionString               " -bitmap \{\}"
          }
          append optionString             " -command \{[.menuConf.frame1.frame2.frame4.command.command get 1.0 end]\}"
          if {"[.menuConf.frame1.frame2.frame4.font.font get]" != ""} {
            append optionString               " -font \{[.menuConf.frame1.frame2.frame4.font.font get]\}"
          }
          append optionString             " -label \{[.menuConf.frame1.frame2.frame4.label.label get]\}"
          append optionString             " -state \{$menuConfState\}"
          append optionString             " -underline \{[.menuConf.frame1.frame2.frame4.underline.underline get]\}"
          case [.menuConf.frame1.frame2.frame8.menu get $curSelected] in {
            {<cascade*} {
              append optionString                 " -menu \{[.menuConf.frame1.frame2.frame4.menu.menu get]\}"
            }
            {<radiobutton*} {
              append optionString                 " -value \{[.menuConf.frame1.frame2.frame4.value.value get]\}"
              if {"[.menuConf.frame1.frame2.frame4.variable.variable get]" != ""} {
                append optionString                   " -variable \{[.menuConf.frame1.frame2.frame4.variable.variable get]\}"
              }
            }
            {<checkbutton*} {
              append optionString                 " -offvalue \{[.menuConf.frame1.frame2.frame4.offvalue.offvalue get]\}"
              append optionString                 " -onvalue \{[.menuConf.frame1.frame2.frame4.onvalue.onvalue get]\}"
              if {"[.menuConf.frame1.frame2.frame4.variable.variable get]" != ""} {
                append optionString                   " -variable \{[.menuConf.frame1.frame2.frame4.variable.variable get]\}"
              }
            }
          }
          if {[catch "$menuConfW $optionString" menuConfResult]} {
            puts stderr $menuConfResult
          }
        }
      }
    }
  }
}


# Procedure: MenuConfReadMenu
proc MenuConfReadMenu { menuConfW} {

  if {[.menuConf.frame1.frame2.frame8.menu size] > 0} {
    .menuConf.frame1.frame2.frame8.menu delete 0 end
  }
  set last [$menuConfW index last]
  if {"$last" == "none"} {
    set last -1
  }
  for {set counter 0} {$counter <= $last} {incr counter 1} {
    if {"[MenuConfEntryType $menuConfW $counter]" == "separator"} {
      .menuConf.frame1.frame2.frame8.menu insert end        "<[MenuConfEntryType $menuConfW $counter]>"
    } {
      .menuConf.frame1.frame2.frame8.menu insert end         "<[MenuConfEntryType $menuConfW $counter]> [lindex [$menuConfW entryconfigure $counter -label] 4]"
    }
  }

  if {[.menuConf.frame1.frame2.frame8.menu size] > 0} {
    .menuConf.frame1.frame2.frame8.menu select from 0
    .menuConf.frame1.frame2.frame8.menu select to 0
    MenuConfSetItem
    .menuConf.frame1.frame2.frame8.mover configure         -to [.menuConf.frame1.frame2.frame8.menu size]
  } {
    .menuConf.frame1.frame2.frame8.mover configure         -to 1
  }
}


# Procedure: MenuConfReadMenus
proc MenuConfReadMenus { menuConfConfig} {

  if {[.menuConf.frame1.frame2.frame5.buttons size] > 0} {
    .menuConf.frame1.frame2.frame5.buttons delete 0 end
  }
  if {[.menuConf.frame1.frame2.frame6.menus size] > 0} {
    .menuConf.frame1.frame2.frame6.menus delete 0 end
  }
  foreach menuConfCounter [split $menuConfConfig] {
    if {![catch "winfo children $menuConfCounter" menuConfResult]} {
      foreach menuConfChild [lsort [split $menuConfResult]] {
        if {"[winfo class $menuConfChild]" == "Menubutton"} {
          if {"[lindex [$menuConfChild config -menu] 4]" != ""} {
            if {"[info commands [lindex [$menuConfChild config -menu] 4]]" == ""} {
              $menuConfChild config -menu ""
            }
          }
          .menuConf.frame1.frame2.frame5.buttons insert end $menuConfChild
          foreach menuConfMenuChild [lsort [winfo children $menuConfChild]] {
            MenuConfInsertMenus $menuConfMenuChild
          }
        }
        if {"[winfo class $menuConfChild]" == "Menu"} {
          MenuConfInsertMenus $menuConfChild
        }
      }
    }
  }
  if {[.menuConf.frame1.frame2.frame5.buttons size] > 0} {
    .menuConf.frame1.frame2.frame5.buttons select from 0
    .menuConf.frame1.frame2.frame5.buttons select to 0
    MenuConfSetItem
  } {
    .menuConf.frame1.frame2.frame6.menus select from 0
    .menuConf.frame1.frame2.frame6.menus select to 0
    MenuConfSetItem
  }
}


# Procedure: MenuConfReposition
proc MenuConfReposition { menuConfPos} {

  set curSelected     [.menuConf.frame1.frame2.frame8.menu curselection]
  set menuConfW     [.menuConf.frame1.frame2.frame6.menus get [.menuConf.frame1.frame2.frame6.menus curselection]]
  if {$curSelected >= 0} {
    set menuConfLast [$menuConfW index last]
    if {"$menuConfLast" == "none"} {
      set menuConfLast -1
    }
    set counter 0
    set newMenu ""
    set currentItem "[MenuConfEntryType $menuConfW $curSelected] "
    foreach optCounter [$menuConfW entryconfig $curSelected] {
      if {[llength $optCounter] == 5} {
        if {"[lindex $optCounter 3]" != "[lindex $optCounter 4]"} {
          append currentItem " [lindex $optCounter 0] \{[lindex $optCounter 4]\}"
        }
      }
    }
    set counter 0
    while {$counter <= $menuConfLast} {
      if {$menuConfPos > $curSelected &&
          $counter == [expr $menuConfPos+1]} {
        lappend newMenu $currentItem
      }
      if {$menuConfPos <= $curSelected &&
          $counter == $menuConfPos} {
        lappend newMenu $currentItem
      }
      if {$counter == $curSelected} {
        incr counter
        continue
      }
      set newItem "[MenuConfEntryType $menuConfW $counter] "
      foreach optCounter [$menuConfW entryconfig $counter] {
        if {[llength $optCounter] == 5} {
          if {"[lindex $optCounter 3]" != "[lindex $optCounter 4]"} {
            append newItem " [lindex $optCounter 0] \{[lindex $optCounter 4]\}"
          }
        }
      }
      lappend newMenu $newItem
      incr counter
    }
    if {$menuConfPos > $curSelected} {
      lappend newMenu $currentItem
    }
    set counter 0
    while {$counter <= $menuConfLast} {
      $menuConfW delete 0
      incr counter
    }
    set counter 0
    while {$counter <= $menuConfLast} {
      if {[catch "$menuConfW add [lindex $newMenu $counter]" menuConfRes]} {
        puts stderr $menuConfRes
      }
      incr counter
    }
    MenuConfReadMenu $menuConfW
    .menuConf.frame1.frame2.frame8.menu select from $menuConfPos
    .menuConf.frame1.frame2.frame8.menu select to $menuConfPos
    MenuConfSetItem
  }
}


# Procedure: MenuConfSave
proc MenuConfSave {} {
  global menuConfPathNames
  global menuConfFile
  global menuConfUserFile

  if {![catch "open $menuConfUserFile w" outFile]} {
    foreach counter $menuConfPathNames {
      foreach widgets [winfo children $counter] {
        if {"[winfo class $widgets]" == "Menu"} {
          MenuConfSaveMenu $outFile $widgets
        }
        if {"[winfo class $widgets]" == "Menubutton"} {
          puts $outFile "$widgets config" nonewline
          foreach optCounter [$widgets config] {
            if {[llength $optCounter] == 5} {
              if {"[lindex $optCounter 3]" != "[lindex $optCounter 4]"} {
                puts $outFile "\\\n  [lindex $optCounter 0] \{[lindex $optCounter 4]\}" nonewline
              }
            }
          }
          puts $outFile ""
          puts $outFile ""
          foreach children [winfo children $widgets] {
            if {"[winfo class $children]" == "Menu"} {
              MenuConfSaveMenu $outFile $children
            }
          }
        }
      }
    }
    close $outFile
  } {
    puts stderr $outFile
  }
}


# Procedure: MenuConfSaveMenu
proc MenuConfSaveMenu { outFile menuConfW} {

  puts $outFile "if {\"\[info commands XFDestroy\]\" != \"\"} {"
  puts $outFile "  catch \"XFDestroy $menuConfW\""
  puts $outFile "} {"
  puts $outFile "  catch \"destroy $menuConfW\""
  puts $outFile "}"
  puts $outFile "menu $menuConfW" nonewline
  foreach optCounter [$menuConfW config] {
    if {[llength $optCounter] == 5} {
      if {"[lindex $optCounter 3]" != "[lindex $optCounter 4]"} {
        puts $outFile "\\\n  [lindex $optCounter 0] \{[lindex $optCounter 4]\}" nonewline
      }
    }
  }
  puts $outFile ""

  set menuLast [$menuConfW index last]
  if {"$menuLast" == "none"} {
    set menuLast -1
  }
  set counter 0
  while {$counter <= $menuLast} {
    puts $outFile "$menuConfW add [MenuConfEntryType $menuConfW $counter] " nonewline
    foreach optCounter [$menuConfW entryconfig $counter] {
      if {[llength $optCounter] == 5} {
        if {"[lindex $optCounter 3]" != "[lindex $optCounter 4]"} {
          puts $outFile "\\\n  [lindex $optCounter 0] \{[lindex $optCounter 4]\}" nonewline
        }
      }
    }
    puts $outFile ""
    incr counter
  }
  puts $outFile ""
  puts $outFile ""

  foreach children [winfo children $menuConfW] {
    if {"[winfo class $children]" == "Menu"} {
      MenuConfSaveMenu $outFile $children
    }
  }
}


# Procedure: MenuConfScale
proc MenuConfScale { menuConfName menuConfLabel1 menuConfLabel2 menuConfTo} {
  global menuConfActiveBackground
  global menuConfActiveForeground
  global menuConfBackground
  global menuConfFont
  global menuConfForeground
  global menuConfScrollActiveForeground
  global menuConfScrollBackground
  global menuConfScrollForeground

  # build widgets
  frame .menuConf.frame1.frame2.frame4.$menuConfName     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  label .menuConf.frame1.frame2.frame4.$menuConfName.message1     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -relief raised     -text "$menuConfLabel1"

  scale .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -from 0     -label "$menuConfLabel2"     -orient horizontal     -relief raised     -sliderlength 15     -to $menuConfTo     -width 8

  # packing of the subwidgets
  pack append .menuConf.frame1.frame2.frame4.$menuConfName               .menuConf.frame1.frame2.frame4.$menuConfName.message1 {left filly}               .menuConf.frame1.frame2.frame4.$menuConfName.$menuConfName {left fillx expand}
}


# Procedure: MenuConfScaleDouble
proc MenuConfScaleDouble { menuConfName menuConfLabel1 menuConfLabel2 menuConfLabel3 menuConfTo1 menuConfTo2} {
  global menuConfActiveBackground
  global menuConfActiveForeground
  global menuConfBackground
  global menuConfFont
  global menuConfForeground
  global menuConfScrollActiveForeground
  global menuConfScrollBackground
  global menuConfScrollForeground

  # build widgets
  frame .menuConf.frame1.frame2.frame4.$menuConfName     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  frame .menuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}1     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  frame .menuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}2     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  label .menuConf.frame1.frame2.frame4.$menuConfName.message1     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -relief raised     -text "$menuConfLabel1"

  scale .menuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}1.${menuConfName}1     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -from 0     -label "$menuConfLabel2"     -orient horizontal     -relief raised     -sliderlength 15     -to $menuConfTo1     -width 8

  scale .menuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}2.${menuConfName}2     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -from 0     -label "$menuConfLabel3"     -orient horizontal     -relief raised     -sliderlength 15     -to $menuConfTo2     -width 8

  # packing of the subwidgets
  pack append .menuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}1               .menuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}1.${menuConfName}1 {left fillx expand}
  pack append .menuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}2               .menuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}2.${menuConfName}2 {left fillx expand}
  pack append .menuConf.frame1.frame2.frame4.$menuConfName               .menuConf.frame1.frame2.frame4.$menuConfName.message1 {left filly}               .menuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}1 {left fillx expand}               .menuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}2 {left fillx expand}
}


# Procedure: MenuConfSelect1
proc MenuConfSelect1 { menuConfW menuConfY} {

  .menuConf.frame1.frame2.frame5.buttons select clear
  .menuConf.frame1.frame2.frame6.menus select clear

  set menuConfNearest [$menuConfW nearest $menuConfY]
  if {$menuConfNearest >= 0} {
    $menuConfW select from $menuConfNearest
    $menuConfW select to $menuConfNearest
    MenuConfSetItem
    if {"$menuConfW" == ".menuConf.frame1.frame2.frame5.buttons"} {
      .menuConf.frame1.frame7.insert config         -state disabled
      .menuConf.frame1.frame7.modifymenu config         -state disabled
      .menuConf.frame1.frame7.delete config         -state disabled
    } {
      .menuConf.frame1.frame7.insert config         -state normal
      .menuConf.frame1.frame7.modifymenu config         -state normal
      .menuConf.frame1.frame7.delete config         -state normal
    }
  }
}


# Procedure: MenuConfSelect2
proc MenuConfSelect2 { menuConfW menuConfY} {

  set menuConfNearest [$menuConfW nearest $menuConfY]
  if {$menuConfNearest >= 0} {
    $menuConfW select from $menuConfNearest
    $menuConfW select to $menuConfNearest
    MenuConfSetItem
  }
}


# Procedure: MenuConfSetItem
proc MenuConfSetItem {} {
  global menuConfCurrentMenuType
  global menuConfState

  set menuConfList ""
  set curSelected     [.menuConf.frame1.frame2.frame5.buttons curselection]
  if {[winfo ismapped .menuConf.frame1.frame2.frame5] &&
      $curSelected >= 0} {
    set menuConfList .menuConf.frame1.frame2.frame5.buttons
    MenuConfSetItems menubutton
    set menuConfW [$menuConfList get $curSelected]
    # insert values
    .menuConf.frame1.frame2.frame4.actbg.actbg       insert 0 [lindex [$menuConfW config -activebackground] 4]
    .menuConf.frame1.frame2.frame4.actfg.actfg       insert 0 [lindex [$menuConfW config -activeforeground] 4]
    .menuConf.frame1.frame2.frame4.bg.bg       insert 0 [lindex [$menuConfW config -background] 4]
    .menuConf.frame1.frame2.frame4.bitmap.bitmap       insert 0 [lindex [$menuConfW config -bitmap] 4]
    if {"[lindex [$menuConfW config -borderwidth] 4]" != ""} {
      .menuConf.frame1.frame2.frame4.border.border         set [lindex [$menuConfW config -borderwidth] 4]
    }
    .menuConf.frame1.frame2.frame4.font.font       insert 0 [lindex [$menuConfW config -font] 4]
    .menuConf.frame1.frame2.frame4.fg.fg       insert 0 [lindex [$menuConfW config -foreground] 4]
    if {"[lindex [$menuConfW config -height] 4]" != ""} {
      .menuConf.frame1.frame2.frame4.size.size2.size2         set [lindex [$menuConfW config -height] 4]
    }
    .menuConf.frame1.frame2.frame4.label.label       insert 0 [lindex [$menuConfW config -text] 4]
    if {"[lindex [$menuConfW config -menu] 4]" != ""} {
      .menuConf.frame1.frame2.frame4.menu.menu         delete 0 end
    }
    .menuConf.frame1.frame2.frame4.menu.menu       insert 0 [lindex [$menuConfW config -menu] 4]
    .menuConf.frame1.frame2.frame4.textvar.textvar       insert 0 [lindex [$menuConfW config -textvariable] 4]
    if {"[lindex [$menuConfW config -underline] 4]" != ""} {
      .menuConf.frame1.frame2.frame4.underline.underline         set [lindex [$menuConfW config -underline] 4]
    }
    if {"[lindex [$menuConfW config -width] 4]" != ""} {
      .menuConf.frame1.frame2.frame4.size.size1.size1         set [lindex [$menuConfW config -width] 4]
    }
  } {
    set curSelected       [.menuConf.frame1.frame2.frame6.menus curselection]
    if {[winfo ismapped .menuConf.frame1.frame2.frame6] &&
        $curSelected >= 0} {
      set menuConfList .menuConf.frame1.frame2.frame6.menus
      MenuConfSetItems menu
      set menuConfW [$menuConfList get $curSelected]
      # insert values
      .menuConf.frame1.frame2.frame4.name.name         insert 0 [.menuConf.frame1.frame2.frame6.menus get $curSelected]
      .menuConf.frame1.frame2.frame4.actbg.actbg         insert 0 [lindex [$menuConfW config -activebackground] 4]
      if {"[lindex [$menuConfW config -activeborderwidth] 4]" != ""} {
        .menuConf.frame1.frame2.frame4.actborder.actborder           set [lindex [$menuConfW config -activeborderwidth] 4]
      }
      .menuConf.frame1.frame2.frame4.actfg.actfg         insert 0 [lindex [$menuConfW config -activeforeground] 4]
      .menuConf.frame1.frame2.frame4.bg.bg         insert 0 [lindex [$menuConfW config -background] 4]
      if {"[lindex [$menuConfW config -borderwidth] 4]" != ""} {
        .menuConf.frame1.frame2.frame4.border.border           set [lindex [$menuConfW config -borderwidth] 4]
      }
      .menuConf.frame1.frame2.frame4.font.font         insert 0 [lindex [$menuConfW config -font] 4]
      .menuConf.frame1.frame2.frame4.fg.fg         insert 0 [lindex [$menuConfW config -foreground] 4]
    } {
      set curSelected         [.menuConf.frame1.frame2.frame8.menu curselection]
      if {[winfo ismapped .menuConf.frame1.frame2.frame8] &&
          $curSelected >= 0} {
        set menuConfList .menuConf.frame1.frame2.frame8.menu
        case [.menuConf.frame1.frame2.frame8.menu get $curSelected] in {
          {<cascade*} {
            set menuConfCurrentMenuType "<cascade> "
            .menuConf.frame1.frame2.frame4.items.items.m               entryconfigure 0 -state active
            MenuConfSetItems cascade
          }
          {<check*} {
            set menuConfCurrentMenuType "<checkbutton> "
            .menuConf.frame1.frame2.frame4.items.items.m               entryconfigure 1 -state active
            MenuConfSetItems check
          }
          {<radio*} {
            set menuConfCurrentMenuType "<radiobutton> "
            .menuConf.frame1.frame2.frame4.items.items.m               entryconfigure 3 -state active
            MenuConfSetItems radio
          }
          {<separator*} {
            set menuConfCurrentMenuType "<separator> "
            .menuConf.frame1.frame2.frame4.items.items.m               entryconfigure 4 -state active
            MenuConfSetItems separator
          }
          {default} {
            set menuConfCurrentMenuType "<command> "
            .menuConf.frame1.frame2.frame4.items.items.m               entryconfigure 2 -state active
            MenuConfSetItems command
          }
        }
        # insert values
        if {![string match <separator* [.menuConf.frame1.frame2.frame8.menu get $curSelected]]} {
          set menuConfW [.menuConf.frame1.frame2.frame6.menus get [.menuConf.frame1.frame2.frame6.menus curselection]]
          .menuConf.frame1.frame2.frame4.accelerator.accelerator             insert 0 [lindex [$menuConfW entryconfig $curSelected -accelerator] 4]
          .menuConf.frame1.frame2.frame4.actbg.actbg             insert 0 [lindex [$menuConfW entryconfig $curSelected -activebackground] 4]
          .menuConf.frame1.frame2.frame4.bg.bg             insert 0 [lindex [$menuConfW entryconfig $curSelected -background] 4]
          .menuConf.frame1.frame2.frame4.bitmap.bitmap             insert 0 [lindex [$menuConfW entryconfig $curSelected -bitmap] 4]
          .menuConf.frame1.frame2.frame4.command.command delete 1.0 end
          .menuConf.frame1.frame2.frame4.command.command insert 1.0             [lindex [$menuConfW entryconfig $curSelected -command] 4]
          .menuConf.frame1.frame2.frame4.font.font             insert 0 [lindex [$menuConfW entryconfig $curSelected -font] 4]
          .menuConf.frame1.frame2.frame4.label.label             insert 0 [lindex [$menuConfW entryconfig $curSelected -label] 4]
          set menuConfState             [lindex [$menuConfW entryconfig $curSelected -state] 4]
          case $menuConfState in {
            {active} {
              .menuConf.frame1.frame2.frame4.state.active select
            }
            {disabled} {
              .menuConf.frame1.frame2.frame4.state.disabled select
            }
            {default} {
              .menuConf.frame1.frame2.frame4.state.normal select
            }
          }
          if {"[lindex [$menuConfW entryconfig $curSelected -underline] 4]" != ""} {
            .menuConf.frame1.frame2.frame4.underline.underline               set [lindex [$menuConfW entryconfig $curSelected -underline] 4]
          }
          case [.menuConf.frame1.frame2.frame8.menu get $curSelected] in {
            {<cascade*} {
              if {[string length [lindex [$menuConfW entryconfig $curSelected -menu] 4]] > 0} {
                .menuConf.frame1.frame2.frame4.menu.menu                   delete 0 end
              }
              .menuConf.frame1.frame2.frame4.menu.menu                 insert 0 [lindex [$menuConfW entryconfig $curSelected -menu] 4]
            }
            {<radiobutton*} {
              .menuConf.frame1.frame2.frame4.value.value                 insert 0 [lindex [$menuConfW entryconfig $curSelected -value] 4]
              .menuConf.frame1.frame2.frame4.variable.variable                 insert 0 [lindex [$menuConfW entryconfig $curSelected -variable] 4]
            }
            {<checkbutton*} {
              .menuConf.frame1.frame2.frame4.offvalue.offvalue                 insert 0 [lindex [$menuConfW entryconfig $curSelected -offvalue] 4]
              .menuConf.frame1.frame2.frame4.onvalue.onvalue                 insert 0 [lindex [$menuConfW entryconfig $curSelected -onvalue] 4]
              .menuConf.frame1.frame2.frame4.variable.variable                 insert 0 [lindex [$menuConfW entryconfig $curSelected -variable] 4]
            }
          }
        }
      }
    }
  }
}


# Procedure: MenuConfSetItems
proc MenuConfSetItems { menuConfType} {

  # remove widgets
  pack unpack .menuConf.frame1.frame2.frame4.items
  pack unpack .menuConf.frame1.frame2.frame4.accelerator
  pack unpack .menuConf.frame1.frame2.frame4.actbg
  pack unpack .menuConf.frame1.frame2.frame4.actborder
  pack unpack .menuConf.frame1.frame2.frame4.actfg
  pack unpack .menuConf.frame1.frame2.frame4.bg
  pack unpack .menuConf.frame1.frame2.frame4.bitmap
  pack unpack .menuConf.frame1.frame2.frame4.border
  pack unpack .menuConf.frame1.frame2.frame4.message1
  pack unpack .menuConf.frame1.frame2.frame4.command
  pack unpack .menuConf.frame1.frame2.frame4.font
  pack unpack .menuConf.frame1.frame2.frame4.fg
  pack unpack .menuConf.frame1.frame2.frame4.label
  pack unpack .menuConf.frame1.frame2.frame4.menu
  pack unpack .menuConf.frame1.frame2.frame4.name
  pack unpack .menuConf.frame1.frame2.frame4.offvalue
  pack unpack .menuConf.frame1.frame2.frame4.onvalue
  pack unpack .menuConf.frame1.frame2.frame4.size
  pack unpack .menuConf.frame1.frame2.frame4.state
  pack unpack .menuConf.frame1.frame2.frame4.textvar
  pack unpack .menuConf.frame1.frame2.frame4.underline
  pack unpack .menuConf.frame1.frame2.frame4.value
  pack unpack .menuConf.frame1.frame2.frame4.variable

  # clear entry fields
  .menuConf.frame1.frame2.frame4.accelerator.accelerator     delete 0 end
  .menuConf.frame1.frame2.frame4.actbg.actbg     delete 0 end
  .menuConf.frame1.frame2.frame4.actborder.actborder     set 0
  .menuConf.frame1.frame2.frame4.actfg.actfg     delete 0 end
  .menuConf.frame1.frame2.frame4.bg.bg     delete 0 end
  .menuConf.frame1.frame2.frame4.bitmap.bitmap     delete 0 end
  .menuConf.frame1.frame2.frame4.border.border     set 0
  .menuConf.frame1.frame2.frame4.command.command     delete 1.0 end
  .menuConf.frame1.frame2.frame4.font.font     delete 0 end
  .menuConf.frame1.frame2.frame4.fg.fg     delete 0 end
  .menuConf.frame1.frame2.frame4.size.size2.size2     set 0
  .menuConf.frame1.frame2.frame4.label.label     delete 0 end
  .menuConf.frame1.frame2.frame4.menu.menu     delete 0 end
  .menuConf.frame1.frame2.frame4.name.name     delete 0 end
  .menuConf.frame1.frame2.frame4.offvalue.offvalue     delete 0 end
  .menuConf.frame1.frame2.frame4.onvalue.onvalue     delete 0 end
  .menuConf.frame1.frame2.frame4.state.normal     select
  .menuConf.frame1.frame2.frame4.textvar.textvar     delete 0 end
  .menuConf.frame1.frame2.frame4.underline.underline     set -1
  .menuConf.frame1.frame2.frame4.value.value     delete 0 end
  .menuConf.frame1.frame2.frame4.variable.variable     delete 0 end
  .menuConf.frame1.frame2.frame4.size.size1.size1     set 0

  case $menuConfType in {
    {menubutton} {
      pack append .menuConf.frame1.frame2.frame4                   .menuConf.frame1.frame2.frame4.actbg {top fillx}                   .menuConf.frame1.frame2.frame4.actfg {top fillx}                   .menuConf.frame1.frame2.frame4.bg {top fillx}                   .menuConf.frame1.frame2.frame4.bitmap {top fillx}                   .menuConf.frame1.frame2.frame4.border {top fillx}                   .menuConf.frame1.frame2.frame4.font {top fillx}                   .menuConf.frame1.frame2.frame4.fg {top fillx}                   .menuConf.frame1.frame2.frame4.label {top fillx}                   .menuConf.frame1.frame2.frame4.menu {top fillx}                   .menuConf.frame1.frame2.frame4.size {top fillx}                   .menuConf.frame1.frame2.frame4.textvar {top fillx}                   .menuConf.frame1.frame2.frame4.underline {top fillx}
    }
    {menu} {
      pack append .menuConf.frame1.frame2.frame4                   .menuConf.frame1.frame2.frame4.name {top fillx}                   .menuConf.frame1.frame2.frame4.actbg {top fillx}                   .menuConf.frame1.frame2.frame4.actborder {top fillx}                   .menuConf.frame1.frame2.frame4.actfg {top fillx}                   .menuConf.frame1.frame2.frame4.bg {top fillx}                   .menuConf.frame1.frame2.frame4.border {top fillx}                   .menuConf.frame1.frame2.frame4.font {top fillx}                   .menuConf.frame1.frame2.frame4.fg {top fillx}
    }
    {cascade} {
      .menuConf.frame1.frame2.frame4.items.message1 configure         -text Cascadebutton

      pack append .menuConf.frame1.frame2.frame4                   .menuConf.frame1.frame2.frame4.items {top fillx}                   .menuConf.frame1.frame2.frame4.label {top fillx}                   .menuConf.frame1.frame2.frame4.actbg {top fillx}                   .menuConf.frame1.frame2.frame4.accelerator {top fillx}                   .menuConf.frame1.frame2.frame4.bg {top fillx}                   .menuConf.frame1.frame2.frame4.bitmap {top fillx}                   .menuConf.frame1.frame2.frame4.font {top fillx}                   .menuConf.frame1.frame2.frame4.menu {top fill}                   .menuConf.frame1.frame2.frame4.state {top fillx}                   .menuConf.frame1.frame2.frame4.underline {top fillx}                   .menuConf.frame1.frame2.frame4.message1 {top fillx}                   .menuConf.frame1.frame2.frame4.command {top fill}
    }
    {check} {
      .menuConf.frame1.frame2.frame4.items.message1 configure         -text Checkbutton

      pack append .menuConf.frame1.frame2.frame4                   .menuConf.frame1.frame2.frame4.items {top fillx}                   .menuConf.frame1.frame2.frame4.label {top fillx}                   .menuConf.frame1.frame2.frame4.actbg {top fillx}                   .menuConf.frame1.frame2.frame4.accelerator {top fillx}                   .menuConf.frame1.frame2.frame4.bg {top fillx}                   .menuConf.frame1.frame2.frame4.bitmap {top fillx}                   .menuConf.frame1.frame2.frame4.font {top fillx}                   .menuConf.frame1.frame2.frame4.offvalue {top fillx}                   .menuConf.frame1.frame2.frame4.onvalue {top fillx}                   .menuConf.frame1.frame2.frame4.state {top fillx}                   .menuConf.frame1.frame2.frame4.underline {top fillx}                   .menuConf.frame1.frame2.frame4.variable {top fillx}                   .menuConf.frame1.frame2.frame4.message1 {top fillx}                   .menuConf.frame1.frame2.frame4.command {top fill}
    }
    {radio} {
      .menuConf.frame1.frame2.frame4.items.message1 configure         -text Radiobutton

      pack append .menuConf.frame1.frame2.frame4                   .menuConf.frame1.frame2.frame4.items {top fillx}                   .menuConf.frame1.frame2.frame4.label {top fillx}                   .menuConf.frame1.frame2.frame4.actbg {top fillx}                   .menuConf.frame1.frame2.frame4.accelerator {top fillx}                   .menuConf.frame1.frame2.frame4.bg {top fillx}                   .menuConf.frame1.frame2.frame4.bitmap {top fillx}                   .menuConf.frame1.frame2.frame4.font {top fillx}                   .menuConf.frame1.frame2.frame4.state {top fillx}                   .menuConf.frame1.frame2.frame4.underline {top fillx}                   .menuConf.frame1.frame2.frame4.value {top fillx}                   .menuConf.frame1.frame2.frame4.variable {top fillx}                   .menuConf.frame1.frame2.frame4.message1 {top fillx}                   .menuConf.frame1.frame2.frame4.command {top fill}
    }
    {separator} {
      .menuConf.frame1.frame2.frame4.items.message1 configure         -text Separator

      pack append .menuConf.frame1.frame2.frame4                   .menuConf.frame1.frame2.frame4.items {top fillx}
    }
    {default} {
      .menuConf.frame1.frame2.frame4.items.message1 configure         -text Commandbutton

      pack append .menuConf.frame1.frame2.frame4                   .menuConf.frame1.frame2.frame4.items {top fillx}                   .menuConf.frame1.frame2.frame4.label {top fillx}                   .menuConf.frame1.frame2.frame4.actbg {top fillx}                   .menuConf.frame1.frame2.frame4.accelerator {top fillx}                   .menuConf.frame1.frame2.frame4.bg {top fillx}                   .menuConf.frame1.frame2.frame4.bitmap {top fillx}                   .menuConf.frame1.frame2.frame4.font {top fillx}                   .menuConf.frame1.frame2.frame4.state {top fillx}                   .menuConf.frame1.frame2.frame4.underline {top fillx}                   .menuConf.frame1.frame2.frame4.message1 {top fillx}                   .menuConf.frame1.frame2.frame4.command {top fill}
    }
  }
}


# Procedure: MenuPopupAdd
if {[string length [info procs MenuPopupAdd]] == 0} {
proc MenuPopupAdd { xfW xfButton xfMenu} {

  if {[catch "bind $xfW \"<ButtonPress-$xfButton>\"                 \"$xfMenu post %X %Y\"" xfResult]} {
    XFError "$xfResult"
    return
  }
  # we need these to counteract the effects of passive grabs :-(
  if {[catch "bind $xfW \"<ButtonRelease-$xfButton>\"                 \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
    XFError "$xfResult"
    return
  }
  if {[catch "bind $xfW \"<B$xfButton-Motion>\"                 \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
    XFError "$xfResult"
    return
  }
}
}


# Procedure: MenuPopupHandle
if {[string length [info procs MenuPopupHandle]] == 0} {
proc MenuPopupHandle { xfMenu xfW xfX xfY} {

 if {"[info commands $xfMenu]" != "" && [winfo ismapped $xfMenu]} {
   set xfPopMinX [winfo rootx $xfMenu]
   set xfPopMaxX [expr "$xfPopMinX+[winfo width $xfMenu]"]
   if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
     $xfMenu activate @[expr "$xfY - [winfo rooty $xfMenu]"]
   } {
     $xfMenu activate none}
   }
}
}


# Procedure: NoFunction
if {[string length [info procs NoFunction]] == 0} {
proc NoFunction { args} {

}
}


# Procedure: ReadBox
proc ReadBox {} {
  # Description: show a box where tcl code can be entered and
  #              evaluated
  # Arguments: none
  # Returns: none
  # Notes: none
  #
  # global readBoxActiveBackground
  # global readBoxActiveForeground
  # global readBoxBackground
  # global readBoxFont
  # global readBoxForeground
  # global readBoxScrollActiveForeground
  # global readBoxScrollBackground
  # global readBoxScrollForeground

  global readBoxActiveBackground
  global readBoxActiveForeground
  global readBoxBackground
  global readBoxFont
  global readBoxForeground
  global readBoxScrollActiveForeground
  global readBoxScrollBackground
  global readBoxScrollForeground

  # build widget structure
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .readBox}
  } {
    catch {destroy .readBox}
  }
  toplevel .readBox     -background "$readBoxBackground"     -borderwidth 0
  wm geometry .readBox 420x300
  wm title .readBox {Read TCL commands}
  wm maxsize .readBox 1000 1000
  wm minsize .readBox 100 100
  wm positionfrom .readBox program
  wm sizefrom .readBox user

  button .readBox.ok     -activebackground "$readBoxActiveBackground"     -activeforeground "$readBoxActiveForeground"     -background "$readBoxBackground"     -foreground "$readBoxForeground"     -font "$readBoxFont"     -text "OK"     -command {
      if {"[info commands XFDestroy]" != ""} {
        catch {XFDestroy .readBox}
      } {
        catch {destroy .readBox}
      }}

  frame .readBox.frame1     -background "$readBoxBackground"     -borderwidth 0     -relief raised
 
  button .readBox.frame1.send     -activebackground "$readBoxActiveBackground"     -activeforeground "$readBoxActiveForeground"     -background "$readBoxBackground"     -foreground "$readBoxForeground"     -font "$readBoxFont"     -text "Send"     -command {
      if {[catch "[string trim [.readBox.text1.text1 get 1.0 end]]" result]} {
        if {"[info commands AlertBox]" != ""} {
          AlertBox "$result"
        } {
          puts stderr "$result"
        }
      }}

  button .readBox.frame1.sendAndClear     -activebackground "$readBoxActiveBackground"     -activeforeground "$readBoxActiveForeground"     -background "$readBoxBackground"     -foreground "$readBoxForeground"     -font "$readBoxFont"     -text "Send + Clear"     -command {
      if {[catch "[string trim [.readBox.text1.text1 get 1.0 end]]" result]} {
        if {"[info commands AlertBox]" != ""} {
          AlertBox "$result"
        } {
          puts stderr "$result"
        }
      }
      .readBox.text1.text1 delete 1.0 end}

  button .readBox.frame1.clear     -activebackground "$readBoxActiveBackground"     -activeforeground "$readBoxActiveForeground"     -background "$readBoxBackground"     -foreground "$readBoxForeground"     -font "$readBoxFont"     -text "Clear"     -command ".readBox.text1.text1 delete 1.0 end"

  frame .readBox.text1     -background "$readBoxBackground"     -borderwidth 0     -relief raised
 
  scrollbar .readBox.text1.scrollbar1     -activeforeground "$readBoxScrollActiveForeground"     -background "$readBoxScrollBackground"     -foreground "$readBoxScrollForeground"     -command ".readBox.text1.text1 yview"     -relief "raised"

  text .readBox.text1.text1     -background "$readBoxBackground"     -foreground "$readBoxForeground"     -font "$readBoxFont"     -borderwidth "2"     -exportselection "true"     -insertbackground "blue"     -relief "raised"     -yscrollcommand ".readBox.text1.scrollbar1 set"

  # bindings
  bind .readBox.text1.text1 <Left> {
    %W mark set insert insert-1c
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Right> {
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Up> {
    %W mark set insert insert-1l
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Down> {
    %W mark set insert insert+1l
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Delete> {
    tk_textBackspace %W
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-a> {
    %W mark set insert "insert linestart"
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-b> {
    %W mark set insert insert-1c
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-d> {
    %W delete insert insert+1c
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-e> {
    %W mark set insert "insert lineend"
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-f> {
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Meta-h> {
    %W delete "insert linestart" insert
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-i> {
    %W inser insert \t
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-j> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-k> {
    if {[%W compare insert == "insert lineend"]} {
      %W delete insert "insert lineend +1c"
      %W yview -pickplace insert
    } {
      %W delete insert "insert lineend"
      %W yview -pickplace insert
    }}
  bind .readBox.text1.text1 <Control-l> {
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-m> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-n> {
    %W mark set insert insert+1l
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-o> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-p> {
    %W mark set insert insert-1l
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-t> {
    set char1 [%W get insert-2c insert-1c]
    set char2 [%W get insert-1c insert]
    %W delete insert-2c insert
    %W insert insert "$char2$char1"
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Meta-v> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert-1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-v> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert+1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Control-w> {
    catch "%W delete sel.first sel.last"}
  bind .readBox.text1.text1 <Control-y> {
    %W insert insert "[GetSelection]"
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Home> {
    %W mark set insert 1.0
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <End> {
    %W mark set insert end
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Prior> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert-1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .readBox.text1.text1 <Next> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert+1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}

  # packing
  pack append .readBox.frame1               .readBox.frame1.send {left fill expand}               .readBox.frame1.sendAndClear {left fill expand}               .readBox.frame1.clear {left fill expand}
  pack append .readBox.text1               .readBox.text1.scrollbar1 {left frame center filly}               .readBox.text1.text1 {top frame center expand fill}
  pack append .readBox               .readBox.ok {bottom fill}               .readBox.frame1 {bottom fill}               .readBox.text1 {bottom fill expand}
}


# Procedure: SendToEmacs
proc SendToEmacs { emacsLisp} {

  if {"$emacsLisp" == ""} {
    return
  }
  if {[catch ".frame.text send \{$emacsLisp\}" emacsResult]} {
    puts stdout ">$emacsResult<"
  }
}


# Procedure: SymbolicName
if {[string length [info procs SymbolicName]] == 0} {
proc SymbolicName { {xfName ""}} {
  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFError]" != ""} {
        XFError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: TextBox
proc TextBox { {textBoxMessage "Text message"} {textBoxGeometry "350x150"} args} {
  # Description: show text box
  # Arguments: textBoxMessage - the text to display
  #            textBoxGeometry - the geometry for the window
  #            args - labels of buttons
  # Returns: The number of the selected button
  # Notes: there exists also functions called:
  #          TextBoxFile - to open and read a file automatically
  #          TextBoxFd - to read from an already opened filedescriptor
  #
  # global textBoxActiveBackground - active background color
  # global textBoxActiveForeground - active foreground color
  # global textBoxBackground - background color
  # global textBoxFont - text font
  # global textBoxForeground - foreground color
  # global textBoxScrollActiveForeground - scrollbar active background color
  # global textBoxScrollBackground - scrollbar background color
  # global textBoxScrollForeground - scrollbar foreground color

  global textBoxButton

  # show text box
  if {[llength $args] > 0} {
    eval TextBoxInternal "\{$textBoxMessage\}" "\{$textBoxGeometry\}" $args
  } {
    TextBoxInternal $textBoxMessage $textBoxGeometry
  }
}


# Procedure: TextBoxInternal
proc TextBoxInternal { textBoxMessage textBoxGeometry args} {
  global textBoxActiveBackground
  global textBoxActiveForeground
  global textBoxBackground
  global textBoxFont
  global textBoxForeground
  global textBoxScrollActiveForeground
  global textBoxScrollBackground
  global textBoxScrollForeground
  global textBoxButton

  if {[string length [info commands .textBox]] > 0} {
    .textBox.frame0.text1 configure       -state normal
    .textBox.frame0.text1 delete 1.0 end
    .textBox.frame0.text1 insert end $textBoxMessage
    .textBox.frame0.text1 mark set insert end
    .textBox.frame0.text1 yview -pickplace end
    .textBox.frame0.text1 configure       -state disabled
    return
  }
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .textBox}
  } {
    catch {destroy .textBox}
  }
  toplevel .textBox     -background "$textBoxBackground"     -borderwidth 0
  if {[catch "wm geometry .textBox $textBoxGeometry"]} {
    wm geometry .textBox 350x150
  }
  wm title .textBox {Text box}
  wm maxsize .textBox 1000 1000
  wm minsize .textBox 100 100
  wm positionfrom .textBox program
  wm sizefrom .textBox user

  frame .textBox.frame0     -background "$textBoxBackground"     -borderwidth 0     -relief raised

  text .textBox.frame0.text1     -background "$textBoxBackground"     -foreground "$textBoxForeground"     -font "$textBoxFont"     -relief raised     -wrap none     -borderwidth 2     -yscrollcommand ".textBox.frame0.vscroll set"

  scrollbar .textBox.frame0.vscroll     -activeforeground "$textBoxScrollActiveForeground"     -background "$textBoxScrollBackground"     -foreground "$textBoxScrollForeground"     -relief raised     -command ".textBox.frame0.text1 yview"

  frame .textBox.frame1     -background "$textBoxBackground"     -borderwidth 0     -relief raised

  set textCounter 0
  set buttonNum [llength $args]

  if {$buttonNum > 0} {
    while {$textCounter < $buttonNum} {
      button .textBox.frame1.button$textCounter         -activebackground "$textBoxActiveBackground"         -activeforeground "$textBoxActiveForeground"         -background "$textBoxBackground"         -foreground "$textBoxForeground"         -font "$textBoxFont"         -text "[lindex $args $textCounter]"         -command "
          global textBoxButton
          set textBoxButton $textCounter
          if {\"\[info commands XFDestroy\]\" != \"\"} {
            catch {XFDestroy .textBox}
          } {
            catch {destroy .textBox}
          }"

      pack append .textBox.frame1                   .textBox.frame1.button$textCounter {left fillx expand}

      incr textCounter
    }
  } {
    button .textBox.frame1.button0       -activebackground $textBoxActiveBackground       -activeforeground $textBoxActiveForeground       -background $textBoxBackground       -foreground $textBoxForeground       -font $textBoxFont       -text {Dismiss}       -command "
        global textBoxButton
        set textBoxButton 0
        if {[string length [info commands XFDestroy]] > 0} {
          catch {XFDestroy .textBox}
        } {
          catch {destroy .textBox}
        }"

    button .textBox.frame1.button1       -activebackground $textBoxActiveBackground       -activeforeground $textBoxActiveForeground       -background $textBoxBackground       -foreground $textBoxForeground       -font $textBoxFont       -text {Clear}       -command "
        global textBoxButton
        global emacsErrorMessage
        set textBoxButton 1
        set emacsErrorMessage {}
        if {[string length [info commands XFDestroy]] > 0} {
          catch {XFDestroy .textBox}
        } {
          catch {destroy .textBox}
        }"

    pack append .textBox.frame1                 .textBox.frame1.button0 {left fillx expand}                 .textBox.frame1.button1 {left fillx expand}
  }

  .textBox.frame0.text1 insert end "$textBoxMessage"

  .textBox.frame0.text1 configure     -state disabled

  # packing
  pack append .textBox.frame0               .textBox.frame0.vscroll {left filly}               .textBox.frame0.text1 {left fill expand}
  pack append .textBox               .textBox.frame1 {bottom fill}               .textBox.frame0 {top fill expand}
}




# initialize global variables
global {alertBoxActiveBackground}
set {alertBoxActiveBackground} {white}
global {alertBoxActiveForeground}
set {alertBoxActiveForeground} {black}
global {alertBoxAnchor}
set {alertBoxAnchor} {nw}
global {alertBoxBackground}
set {alertBoxBackground} {#dcdcdc}
global {alertBoxButton}
set {alertBoxButton} {0}
global {alertBoxFont}
set {alertBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {alertBoxForeground}
set {alertBoxForeground} {black}
global {alertBoxJustify}
set {alertBoxJustify} {center}
global {alertBoxScrollActiveForeground}
set {alertBoxScrollActiveForeground} {GhostWhite}
global {alertBoxScrollBackground}
set {alertBoxScrollBackground} {#dcdcdc}
global {alertBoxScrollForeground}
set {alertBoxScrollForeground} {gray}
global {bindPopupDown}
set {bindPopupDown} {<Mod1-Button-3>}
global {bindPopupMove}
set {bindPopupMove} {<B3-Mod1-Motion>}
global {bindPopupRelease}
set {bindPopupRelease} {<Any-ButtonRelease-3>}
global {colorBoxActiveBackground}
set {colorBoxActiveBackground} {white}
global {colorBoxActiveForeground}
set {colorBoxActiveForeground} {black}
global {colorBoxBackground}
set {colorBoxBackground} {#dcdcdc}
global {colorBoxFont}
set {colorBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {colorBoxForeground}
set {colorBoxForeground} {black}
global {colorBoxName}
set {colorBoxName} {gray}
global {colorBoxScrollActiveForeground}
set {colorBoxScrollActiveForeground} {GhostWhite}
global {colorBoxScrollBackground}
set {colorBoxScrollBackground} {#dcdcdc}
global {colorBoxScrollForeground}
set {colorBoxScrollForeground} {gray}
global {connect_info}
set {connect_info(file4)} {1160}
set {connect_info(file5)} {127.0.0.1 1163}
set {connect_info(file6)} {127.0.0.1 1098}
global {curSelected}
set {curSelected} {0}
global {emacsActBackground}
set {emacsActBackground} {"white"}
global {emacsActForeground}
set {emacsActForeground} {"black"}
global {emacsBackground}
set {emacsBackground} {"#dcdcdc"}
global {emacsBuffList}
set {emacsBuffList} {}
global {emacsCurrentMenu}
set {emacsCurrentMenu} {}
global {emacsDebug}
set {emacsDebug} {0}
global {emacsEmacsCursor}
set {emacsEmacsCursor} {}
global {emacsEmacsFont}
set {emacsEmacsFont} {}
global {emacsErrorMessage}
set {emacsErrorMessage} {}
global {emacsFont}
set {emacsFont} {"-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1"}
global {emacsForeground}
set {emacsForeground} {"black"}
global {emacsPollInterval}
set {emacsPollInterval} {60}
global {emacsPopupBind}
set {emacsPopupBind} {<Mod1-Button3>}
global {emacsResult}
set {emacsResult} {gray}
global {emacsScrollActForeground}
set {emacsScrollActForeground} {"GhostWhite"}
global {emacsScrollForeground}
set {emacsScrollForeground} {"gray"}
global {emacsUseAdvise}
set {emacsUseAdvise} {true}
global {fontBoxActiveBackground}
set {fontBoxActiveBackground} {white}
global {fontBoxActiveForeground}
set {fontBoxActiveForeground} {black}
global {fontBoxBackground}
set {fontBoxBackground} {#dcdcdc}
global {fontBoxFont}
set {fontBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {fontBoxFontFamily}
set {fontBoxFontFamily} {*}
global {fontBoxFontPixels}
set {fontBoxFontPixels} {*}
global {fontBoxFontSWeight}
set {fontBoxFontSWeight} {*}
global {fontBoxFontSWidth}
set {fontBoxFontSWidth} {}
global {fontBoxFontSlant}
set {fontBoxFontSlant} {*}
global {fontBoxFontWeight}
set {fontBoxFontWeight} {*}
global {fontBoxForeground}
set {fontBoxForeground} {black}
global {fontBoxName}
set {fontBoxName} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {fontBoxScrollActiveForeground}
set {fontBoxScrollActiveForeground} {GhostWhite}
global {fontBoxScrollBackground}
set {fontBoxScrollBackground} {#dcdcdc}
global {fontBoxScrollForeground}
set {fontBoxScrollForeground} {gray}
global {fsBoxActiveBackground}
set {fsBoxActiveBackground} {white}
global {fsBoxActiveForeground}
set {fsBoxActiveForeground} {black}
global {fsBoxBackground}
set {fsBoxBackground} {#dcdcdc}
global {fsBoxButton}
set {fsBoxButton} {0}
global {fsBoxFSAll}
set {fsBoxFSAll} {0}
global {fsBoxFSInternalPath}
set {fsBoxFSInternalPath} {/home/stone/garfield/dvlpmnt/TkEmacs/xfemacs}
global {fsBoxFSName}
set {fsBoxFSName} {}
global {fsBoxFSPath}
set {fsBoxFSPath} {/home/stone/garfield/development/TkEmacs/xfemacs}
global {fsBoxFSPattern}
set {fsBoxFSPattern} {*}
global {fsBoxFont}
set {fsBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {fsBoxForeground}
set {fsBoxForeground} {black}
global {fsBoxScrollActiveForeground}
set {fsBoxScrollActiveForeground} {GhostWhite}
global {fsBoxScrollBackground}
set {fsBoxScrollBackground} {#dcdcdc}
global {fsBoxScrollForeground}
set {fsBoxScrollForeground} {gray}
global {menuConfActiveBackground}
set {menuConfActiveBackground} {white}
global {menuConfActiveForeground}
set {menuConfActiveForeground} {black}
global {menuConfBackground}
set {menuConfBackground} {#dcdcdc}
global {menuConfColorFile}
set {menuConfColorFile} {/usr/local/lib/tk/xf/lib/Colors}
global {menuConfCurrentMenuType}
set {menuConfCurrentMenuType} {<command> }
global {menuConfFile}
set {menuConfFile} {.:/usr/local/lib/xfemacs-c.tcl}
global {menuConfFont}
set {menuConfFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {menuConfFontFile}
set {menuConfFontFile} {/usr/local/lib/tk/xf/lib/Fonts}
global {menuConfForeground}
set {menuConfForeground} {black}
global {menuConfPathNames}
set {menuConfPathNames} {. .frame0}
global {menuConfScrollActiveForeground}
set {menuConfScrollActiveForeground} {GhostWhite}
global {menuConfScrollBackground}
set {menuConfScrollBackground} {#dcdcdc}
global {menuConfScrollForeground}
set {menuConfScrollForeground} {gray}
global {menuConfState}
set {menuConfState} {normal}
global {menuConfUserFile}
set {menuConfUserFile} {~/.xfemacs-c.tcl}
global {oldBindPopupDown}
set {oldBindPopupDown} {<Mod1-Button-3>}
global {oldBindPopupMove}
set {oldBindPopupMove} {<B3-Mod1-Motion>}
global {oldBindPopupRelease}
set {oldBindPopupRelease} {<Any-ButtonRelease-3>}
global {readBoxActiveBackground}
set {readBoxActiveBackground} {white}
global {readBoxActiveForeground}
set {readBoxActiveForeground} {black}
global {readBoxBackground}
set {readBoxBackground} {#dcdcdc}
global {readBoxFont}
set {readBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {readBoxForeground}
set {readBoxForeground} {black}
global {readBoxScrollActiveForeground}
set {readBoxScrollActiveForeground} {GhostWhite}
global {readBoxScrollBackground}
set {readBoxScrollBackground} {#dcdcdc}
global {readBoxScrollForeground}
set {readBoxScrollForeground} {gray}
global {symbolicName}
set {symbolicName(root)} {.}
global {textBoxActiveBackground}
set {textBoxActiveBackground} {white}
global {textBoxActiveForeground}
set {textBoxActiveForeground} {Black}
global {textBoxBackground}
set {textBoxBackground} {#dcdcdc}
global {textBoxButton}
set {textBoxButton} {0}
global {textBoxFont}
set {textBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {textBoxForeground}
set {textBoxForeground} {Black}
global {textBoxScrollActiveForeground}
set {textBoxScrollActiveForeground} {GhostWhite}
global {textBoxScrollBackground}
set {textBoxScrollBackground} {#dcdcdc}
global {textBoxScrollForeground}
set {textBoxScrollForeground} {gray}

# stuff to display and remove toplevel windows
# call the procedures to create the toplevels.
ShowWindow.

# end source

  global argc
  global argv
  global emacsBuffList
  global emacsPollInterval
  global emacsUseAdvise
  global fsBoxFSPath
  global xfLoadPath

  if {[file exists ~/.xfemacs-o.tcl]} {
    catch "source ~/.xfemacs-o.tcl"
  }

  MenuConfInit ~/.xfemacs-c.tcl $xfLoadPath/xfemacs-c.tcl . .frame0
  EmacsUpdateResources
  EmacsSetBinding

  set runAsClient 0
  set tmpArgv ""
  set tmpLoadFile ""
  set tmpFunction ""
  for {set counter 0} {$counter < $argc} {incr counter 1} {
    case [string tolower [lindex $argv $counter]] in {
      {-client} {
        set runAsClient 1
      }
      {-load} {
        incr counter
        lappend tmpLoadFile [lindex $argv $counter]
      }
      {-function} {
        incr counter
        set tmpFunction [lindex $argv $counter]
      }
      {default} {
        lappend tmpArgv [lindex $argv $counter]
      }
    }
  }
  set argv $tmpArgv
  set argc [llength $tmpArgv]
  unset counter
  unset tmpArgv

  foreach counter $tmpLoadFile {
    SendToEmacs "(load \"$counter\")"
  }
  foreach counter $argv {
    SendToEmacs "(find-file \"$counter\")"
  }
  if {"[string trim $tmpFunction]" != ""} {
    SendToEmacs "($tmpFunction)"
  }

  set fsBoxFSPath [pwd]
  set emacsBuffList ""

  .frame.text send "(tk-advise-destroy-widget-on-exit)"
  .frame.text config -pollinterval $emacsPollInterval
  .frame.text config -useadvise $emacsUseAdvise

  wm deiconify .
  if {"[info commands ClientLogin]" != ""} {
    ClientLogin xfemacs
  }


# eof
#
