'\"
'\" Copyright 1992 Sven Delmas
'\"
'\" The manual page is based upon the manual page style from:
'\"
'\" Copyright 1992 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: megawidget.n[5.0] Thu May  5 00:04:06 1994 garfield@mydomain.de frozen $
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS megawidget cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
megawidget \- Create and manipulate megawidget widgets
.SH SYNOPSIS
.nf
\fBmegawidget\fI \fIpathName \fR?\fIoptions\fR?
\fBtopmegawidget\fI \fIpathName \fR?\fIoptions\fR?
.fi
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR	\fBrelief\fR
\fBborderwidth\fR	\fBgeometry\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:   \fBclass\fR
Class:  \fBClass\fR
Command-Line Switch:    \fB\-class\fR
.fi
.IP
Specifies the class of the megawidget. For Tk, the
widget class is always MegaWidget. This resource can be used
to classify the widget by attaching a new class name.
.LP
.nf
Name:	\fBcreateCommand\fR
Class:	\fBCreateCommand\fR
Command-Line Switch:	\fB\-createcommand\fR
.fi
.IP
This option contains the command that is evaluated when the
widget is created. The command gets the argument list as
parameter.
.LP
.nf
Name:	\fBcrypting\fR
Class:	\fBCrypting\fR
Command-Line Switch:	\fB\-crypting\fR
.fi
.IP
Setting this option to "true" forces the reading of the
\fB-userfile\fR and \fB-libfile\fR files in encrypted
format.
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB\-height\fR
.fi
.IP
Specifies the desired height for the window in any of the forms
acceptable to \fBTk_GetPixels\fR. This option is only used
if the \fB\-geometry\fR option is unspecified. If this
option is less than or equal to zero (and \fB\-geometry\fR
is not specified), then the window will not request any size at
all.
.LP
.nf
Name:	\fBinterpreter\fR
Class:	\fBInterpreter\fR
Command-Line Switch:	\fB\-interpreter\fR
.fi
.IP
When this option contains a name, this is the name of a
newly created or already existing Tcl interpreter. This
interpreter is attached to the new widget. Most widget
commands will only be available from the inside of this
interpreter. All external actions of the widget are made
available in the form of minor commands.
.LP
.nf
Name:	\fBlibFile\fR
Class:	\fBLibFile\fR
Command-Line Switch:	\fB\-libfile\fR
.fi
.IP
This option contains a filename of a Tcl library file that
is loaded when the widget is created. This file can be an
encrypted file, or a plain file (depending on the
\fB-crypting\fR option).
.LP
.nf
Name:	\fBtkSupport\fR
Class:	\fBTkSupport\fR
Command-Line Switch:	\fB\-tksupport\fR
.fi
.IP
This option enables/disables Tk support in the local
interpreter. If this option is set to 1, the local
interpreter contains a local widget tree. Otherwise, all Tk
operations are performed on the global widget tree.
.LP
.nf
Name:	\fBuserFile\fR
Class:	\fBUserFile\fR
Command-Line Switch:	\fB\-userfile\fR
.fi
.IP
This option contains a filename of a user specific Tcl
file that is loaded when the widget is created. This file
can be an encrypted file, or a plain file (depending on the
\fB-crypting\fR option).
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies the desired width for the window in any of the forms
acceptable to \fBTk_GetPixels\fR. This option is only used
if the \fB\-geometry\fR option is unspecified. If this
option is less than or equal to zero (and \fB\-geometry\fR
is not specified), then the window will not request any size
at all.
.VE
.BE

.SH DESCRIPTION
.PP
The \fBmegawidget\fR command creates a new window (given by the 
\fIpathName\fR argument) and makes it into a megawidget
widget. The \fBtopmegawidget\fR command makes the created
megawidget into a toplevel. Additional options, as described
above, may be specified on the command line or in the option
database to configure aspects of the megawidget such as its
default background color. The \fBmegawidget\fR command
returns the path name of the new window.
.PP
The megawidget is a complex widget allowing the combination
of other widgets, procedures and variables to a new complex
widget. The idea is to provide a simple container to which the
user can attach options and minor commands that are
maintained like normal Tk minor commands and options. 
.PP
To reduce name space conflicts, it is also possible to create
a new interpreter (with the option \fB-interpreter\fR) where
all the evaluations for this new widget are done. This
interpreter gets a certain name and can be shared among
megawidgets. This local interpreter can optionally (use the
-tksupport option) also contain a local widget tree. This
local widget tree contains a widget named after the mega
widget that is the root for the underlying widgetstructure.
.PP
To access the widget's functionality, the minor commands
have to be used. All commands that are used to maintain the
minor commands and options are only accessible from the new
interpreter. This makes it possible to use real information
hiding. The code that has to be evaluated in the additional
interpreter is loaded with the two options \fB-libfile\fR
and \fB-userfile\fR. To initialize the widget, the option
\fB-createcommand\fR contains a procedure name that is
evaluated after the widget Tcl code has been loaded. This
procedure typically adds the minor commands and the widget
options.
.PP
To make the distribution of code more secure, the option
\fB-crypting\fR allows the loading of encrypted source
files. This way, it is possible to distribute commercial
code written in Tcl (although the protection is not 100%). 

.SH "WIDGET COMMAND"
.PP
The \fBmegawidget\fR command creates a new Tcl command the
name of which is the same as the path name of the
megawidget's window. This command may be used to invoke
various operations on the widget. It has the following
general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIPathName\fR is the name of the command. It is the same as
the megawidget widget's path name. \fIOption\fR and the
\fIarg\fRs determine the exact behavior of the command.  The
following commands are possible for megawidget widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
Queries or modifies the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing
all available options for \fIpathName\fR (see
\fBTk_ConfigureInfo\fR for information on the format of this
list).  If \fIoption\fR is specified with no \fIvalue\fR,
the command returns a list describing the named
"option" (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is
specified).  If one or more \fIoption\-value\fR pairs are
specified, the command modifies the given widget option(s)
to have the given value(s); in this case, the command
returns an empty string.  \fIOption\fR may have any of the
values accepted by the \fBmegawidget\fR command, as well as
all user defined options. For user defined options, the
attached Tcl command is evaluated when the option is set. 
.TP
\fIpathName \fBconfhidden\fR ?\fIoption\fR? \fI?value option value ...\fR?
Queries or modifies the hidden configuration options of the
widget. Hidden options can only be accessed via the
\fBconfhidden\fR minor command. Apart from that, the
\fBconfhidden\fR command behaves like the configuring
command.
.TP
\fIpathName \fBconfinternal\fR \fIoption\fR \fIvalue ?option value ...\fR?
Modifies the configuration options of the widget. The
difference from the standard configuring command is that the
Tcl command attached to user options is not evaluated.
.TP
\fIpathName \fBconfvalue\fR \fIoption\fR
This command retrieves the value for the specified option.
The return value is the plain value, instead of the list
that is usually returned by the standard configure command.
This makes the accessing of values easier (and faster).
.TP
\fIpathName \fBinterpeval\fR \fIarg\fR ?\fIarg\fR?
This command takes a Tcl command and evaluates it in the
main Tcl interpreter. Usually the interpreter has a modified
unknown command that uses this command to redirect unknown
commands to the main interpreter.
.TP
\fIpathName \fBinterpset\fR \fIvarName\fR ?\fIvalue\fR?
To set and retrieve a variable in the main interpreter, this
command is used. It takes the name of a variable and the
new value (if the variable is to be set) and sets or
retrieves the variable in the main interpreter.
.TP
\fIpathName \fBminoradd\fR \fIminorname TclCommand\fR
Attaches a new minor command named \fIminorName\fR to the
megawidget. The attached Tcl command is evaluated when the
minor command is called. The Tcl command is called with the
widget's path name and the parameters given to the call of
the minor command.
.TP
\fIpathName \fBminordelete\fR \fI?minorname?\fR
Removes the minor command named \fIminorName\fR from the
megawidget. If no \fIminorName\fR is specified, all minor
commands are deleted.
.TP
\fIpathName \fBminorlist\fR \fI?minorName?\fR
Displays the Tcl command attached to the minor command
named \fIminorName\fR. If no \fIminorName\fR is specified,
all minor commands are listed.
.TP
\fIpathName \fBoptionadd\fR \fIcommandLineSwitch optionName optionClass default value type TclCommand\fR
Attaches a new user option named \fIoptionName\fR to the
megawidget. The \fIcommandLineSwitch\fR is used to access
the option on the commandline. The new option has the class
\fIoptionClass\fR, it has the default value \fIdefault\fR
and the value \fIvalue\fR. The option can be of the
\fItype\fR 'readonly' (the option can only be
read), 'hidden' (the option is not accessible via
configure), 'once' (the option can only be set once)
or 'normal'. The attached Tcl command is evaluated when the
option is set and gets four parameters. The first parameter
is the megawidget's pathName, the second parameter is the
option name. The next parameter is the old value, and the
last parameter is the new value of the option.
.TP
\fIpathName \fBoptiondelete\fR \fI?optionName?\fR
Removes the option named \fIoptionName\fR from the
megawidget. If no \fIoptionName\fR is specified, all options
are deleted.
.TP
\fIpathName \fBoptionlist\fR \fI?optionName?\fR
Displays the definition of the user option named
\fIoptionName\fR. If no \fIoptionName\fR is specified, all 
user options are listed.
.TP
\fIpathName \fBrecursiveconfigure\fR \fIpathName value option\fR
Recursively sets the specified option to the new value.
Descends through all children of the specified pathName.
.TP
\fIpathName \fBuserMinorCommand\fR \fI?options?\fR
User defined minor commands that match. The minor command is
called with the widget's path name and the passed options.
.RE

.SH BUGS
.PP
.\"
.IP "\(bu"
Surely, there are many bugs.

.SH KEYWORDS
widget
